// BJLUploader.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "BJLUploader.h"
#include "BJLUploaderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CBJLCommandLineInfo::CBJLCommandLineInfo()
{
	m_strImageName = "";

	// default to LPT1
	m_base = 0x378;

	// default base
	m_baseAddr = 0x4000;

	// default header size
	m_headerSkip = 0;
}

void CBJLCommandLineInfo::ParseParam(LPCSTR lpszParam, BOOL bFlag, BOOL bLast)
{
	CString strParam = lpszParam;

	if (m_strLastParam == "s")
	{
		 ArgValue(strParam.GetBuffer(sizeof(long)), &m_headerSkip);
	}
	else if (m_strLastParam == "b")
	{
		 ArgValue(strParam.GetBuffer(sizeof(long)), &m_baseAddr);
	}
	else if (m_strLastParam == "p")
	{
		ArgValue(strParam.GetBuffer(sizeof(long)), &m_base);
	}
	else if (m_strLastParam == "f")
	{
		m_strImageName = lpszParam;
	}

	m_strLastParam = lpszParam;
}

void CBJLCommandLineInfo::GetSettingsFromProfile()
{
	m_strImageName = "";

	// default to LPT1
	m_base = AfxGetApp()->GetProfileInt("Settings", "Base", 0x378);

	// default base
	m_baseAddr = AfxGetApp()->GetProfileInt("Settings", "Base Address", 0x4000);

	// default header size
	m_headerSkip = AfxGetApp()->GetProfileInt("Settings", "Header Skip", 0);
}

/////////////////////////////////////////////////////////////////////////////
// CBJLUploaderApp

BEGIN_MESSAGE_MAP(CBJLUploaderApp, CWinApp)
	//{{AFX_MSG_MAP(CBJLUploaderApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBJLUploaderApp construction

CBJLUploaderApp::CBJLUploaderApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBJLUploaderApp object

CBJLUploaderApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBJLUploaderApp initialization

BOOL CBJLUploaderApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CBJLUploaderDlg dlg;
	CBJLCommandLineInfo info;
	CString strCmdLine = m_lpCmdLine;

	SetRegistryKey("\\BJL\\");

	if (strCmdLine.IsEmpty())
	{
		info.GetSettingsFromProfile();
	}
	else
	{
		ParseCommandLine(info);
	}

	m_pMainWnd = &dlg;

	dlg.SetImageName(info.m_strImageName);
	dlg.SetBase(info.m_base);
	dlg.SetBaseAddr(info.m_baseAddr);
	dlg.SetHeaderSkip(info.m_headerSkip);

	dlg.DoModal();

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

