// BJLUploaderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BJLUploader.h"
#include "BJLUploaderDlg.h"
#include "SettingsDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBJLUploaderDlg dialog

CBJLUploaderDlg::CBJLUploaderDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBJLUploaderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBJLUploaderDlg)
	m_strFileName = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBJLUploaderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBJLUploaderDlg)
	DDX_Control(pDX, IDCANCEL, m_ctlCancel);
	DDX_Control(pDX, IDC_MESSAGE, m_ctlMessage);
	DDX_Control(pDX, IDC_STATUS, m_ctlStatus);
	DDX_Text(pDX, IDC_FILENAME, m_strFileName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBJLUploaderDlg, CDialog)
	//{{AFX_MSG_MAP(CBJLUploaderDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SETTINGS, OnSettings)
	ON_BN_CLICKED(IDC_GET_FILE, OnGetFile)
	ON_BN_CLICKED(IDC_UPLOAD, OnUpload)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_START, OnStart)
	ON_MESSAGE(WM_SET_MESSAGE, OnSetMessage)
	ON_MESSAGE(WM_SET_LENGTH, OnSetLength)
	ON_MESSAGE(WM_SET_POSITION, OnSetPosition)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBJLUploaderDlg message handlers

BOOL CBJLUploaderDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CString strCmdLine = AfxGetApp()->m_lpCmdLine;

	if (!strCmdLine.IsEmpty())
	{	
		GetDlgItem(IDC_SETTINGS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_UPLOAD)->ShowWindow(SW_HIDE);
		PostMessage(WM_START);	// process started by using PostMessage
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBJLUploaderDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBJLUploaderDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBJLUploaderDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBJLUploaderDlg::WaitMsecs(DWORD dwMsecs)
{
	DWORD dwStart = ::GetTickCount();
	MSG msg;
	while(::GetTickCount() <= dwStart + dwMsecs)
	{
		while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
//	User defined messages to maintain portability of original loader code.
//	These messages are posted from the loader code to this dialog to update
//	the dialog with the current position of the loader

// Start the load process (msg posted from OnInitDialog)
LPARAM CBJLUploaderDlg::OnStart(WPARAM wParam, LPARAM lParam)
{
	try
	{
		m_strFileName = m_strImageName;
		UpdateData(FALSE);

		InitWindows(m_hWnd);
		InitPort(m_base);
		SendFile(m_strImageName.GetBuffer(_MAX_PATH), m_base, m_baseAddr, m_headerSkip);

		m_ctlMessage.SetWindowText("Done.");
		m_ctlCancel.SetWindowText("Close");
		UpdateData(FALSE);
	}
	catch(CException* e)
	{
		MessageBox("Error sending file.", "BJL Uploader", MB_OK);
		e->Delete();
	}
	catch(...)
	{
		MessageBox("Error sending file.", "BJL Uploader", MB_OK);
	}

	CString strCmdLine = AfxGetApp()->m_lpCmdLine;
	if (!strCmdLine.IsEmpty())
	{
		WaitMsecs(1000);	// give the user time to see what happend
		PostQuitMessage(0);	// exit the application
	}

	return 0;
}

// Set the status message
LPARAM CBJLUploaderDlg::OnSetMessage(WPARAM wParam, LPARAM lParam)
{
	m_ctlMessage.SetWindowText((char*) wParam);
	return 0;
}

// Set the length of the file
LPARAM CBJLUploaderDlg::OnSetLength(WPARAM wParam, LPARAM lParam)
{
	m_ctlStatus.SetRange(0, wParam);
	m_ctlStatus.SetStep(1);
	return 0;
}

// Set the current position of the file
LPARAM CBJLUploaderDlg::OnSetPosition(WPARAM wParam, LPARAM lParam)
{
	m_ctlStatus.SetPos(wParam);
	return 0;
}

void CBJLUploaderDlg::OnSettings() 
{
	CSettingsDialog dlg;

	dlg.SetBaseAddr(m_baseAddr);
	dlg.SetBase(m_base);
	dlg.SetHeaderSkip(m_headerSkip);

	if (dlg.DoModal() != IDOK)
	{
		return;
	}

	m_base = dlg.GetBase();
	m_baseAddr = dlg.GetBaseAddr();
	m_headerSkip = dlg.GetHeaderSkip();

	AfxGetApp()->WriteProfileInt("Settings", "Base", m_base);
	AfxGetApp()->WriteProfileInt("Settings", "Base Address", m_baseAddr);
	AfxGetApp()->WriteProfileInt("Settings", "Header Skip", m_headerSkip);
}

void CBJLUploaderDlg::OnCancel() 
{
	PostMessage(WM_CANCEL);	
	CDialog::OnCancel();
}

void CBJLUploaderDlg::OnGetFile() 
{
	CFileDialog dlg(TRUE, "", "", OFN_HIDEREADONLY, "BJL Files (*.prg;*.tos)|*.prg; *.tos|Jaguar Server Files (*.jag)|*.jag|All Files (*.*)|*.*||");
	
	if (dlg.DoModal() != IDOK)
	{
		return;
	}

	m_strImageName = dlg.GetPathName();
	m_strFileName = dlg.GetPathName();
	UpdateData(FALSE);
}

void CBJLUploaderDlg::OnUpload() 
{
	if (m_strImageName.IsEmpty())
	{
		AfxMessageBox("You must provide a file to send.");
		return;
	}

	// Start the upload
	PostMessage(WM_START);	
}
