
/*
	BJL-uploader for Linux
	Copyright (c) 1997, Joe Britt
	
	Freely distributable and modifiable.
	I only ask that if you use this as the basis of some other work,
	you give me credit for this original version.  Thanks.

	Special thanks to 42Bastian, for being extremely helpful in debugging
	the communication with the BJL-ROM in the Jag.  He's the man!

	  JOE       Joe Britt
	  42BS      42Bastian Schick <elw5basc(at)gp.fht-esslingen.de>
	  JBS		John Sohn (jsohn@ee.net)

	Change History:

	30 Oct 97 JOE			First version.
    31 Oct 97 42BS			added DJGPP support, but don't know if it works...
     1 Dec 97 JBS			added Win95 console support and enhanced DGJPP functionality
	10 Jan 98 JBS			supports linking with Windows 95 GUI application
*/

#include <stdio.h>

#ifndef _WIN32
	#include <unistd.h>
	#include <sys/time.h>
#endif

#ifdef DJGPP
#  include <pc.h>
#  define outb(data,port) outp((port),(data))
#  define inb(port)       inp(port)
#  define ioperm(a,b,c)   (0)
#elif _WIN32
#  include <windows.h>
#  include <conio.h>
#  define outb(data,port) _outp((port),(data))
#  define inb(port)       _inp(port)
#  define ioperm(a,b,c)   (0)
#  define sleep           Sleep
#else
#  include <asm/io.h>
#endif

// After debating what to do I've decided to keep this file the same
// and hack it into a windows app. This file should compile under
// any of the orignal platforms it was written for. (JBS)
#ifdef _W95GUI
#include "Loader.h"
#endif

typedef unsigned char uchar;
typedef unsigned char Boolean;
typedef unsigned long ulong;    // 42BS
typedef unsigned short ushort;  // 42BS

#define true                1
#define false               0

#define kLPT1Base           0x378
#define kLPT2Base           0x278

/*
from http://www.paranoia.com/~filipg/HTML/LINK/PORTS/F_PARALLEL5.html#PARALLEL_008

STATUS
        7 6 5 4 3 2 1 0
        * . . . . . . .  Busy . . (pin 11), high=0, low=1 (inverted)
        . * . . . . . .  Ack  . . (pin 10), high=1, low=0 (true)
        . . * . . . . .  No paper (pin 12), high=1, low=0 (true)
        . . . * . . . .  Selected (pin 13), high=1, low=0 (true)
        . . . . * . . .  Error. . (pin 15), high=1, low=0 (true)
        . . . . . * * *  Undefined

CONTROL
        7 6 5 4 3 2 1 0
        * * . . . . . .  Unused (undefined on read, ignored on write)
        . . * . . . . .  Bidirectional control, see below
        . . . * . . . .  Interrupt control, 1=enable, 0=disable
        . . . . * . . .  Select . . (pin 17), 1=low, 0=high (inverted)
        . . . . . * . .  Initialize (pin 16), 1=high, 0=low (true)
        . . . . . . * .  Auto Feed  (pin 14), 1=low, 0=high (inverted)
        . . . . . . . *  Strobe . . (pin 1),  1=low, 0=high (inverted)
*/

#define	kDataReg			0
#define	kStatusReg			1		/* BUSY is bit 7 */
#define	kControlReg			2		/* STB is bit 0 */

void SendLong( ulong base, ulong w );
void SendByte( ulong base, uchar c );
ulong relocate(uchar * pdata, ulong * len, ulong *addr,ulong skip);


void SendFile( char *fn, ulong base, ulong addr, ulong skip );

ulong ReverseEndian(ulong d);
ulong ReverseEndian(ulong d)
{
    return  ((d << 24) |
            ((d & 0x0000ff00) << 8) |
            ((d & 0x00ff0000) >> 8) |
            (d >> 24));
}

#define BE_TO_LE(_x)    ReverseEndian(_x)
#define LE_TO_BE(_x)    ReverseEndian(_x)

/* 42BS */

#define BE_TO_LE42(_x)\
            ((ulong)(\
            (((_x) << 24) |\
            (((_x) & 0x0000ff00) << 8) |\
            (((_x) & 0x00ff0000) >> 8) |\
            ((_x) >> 24))))
            
#define LE_TO_BE42(_x)    BE_TO_LE(_x)

#define BE_TO_LEW(_x)    ( (ushort)( ((_x)>>8)|((_x)<<8) ) )
#define LE_TO_BEW(_x)    BE_TO_LEW(_x)


Boolean ParseCmds( ulong argc, char *argv[] );
void ArgValue( char *s, ulong *value );


ulong gBase = kLPT2Base;			/* default to LPT2 */
ulong gBaseAddr = 0x4000;			/* default base */
ulong gHeaderSkip = 0;				/* default header size */ /* was 28,changed 42BS */
char *gImageName = "Joe Britt";

#ifdef _W95GUI
HWND g_hWnd;
#define STATUS_OFFSET		100
#endif

main( int argc,char *argv[] )
{
	if ( !ParseCmds( argc, argv ) )
	{
		printf("usage: loader [-s skipbytes] [-b baseaddr] [-p lptbase] -f <filename>\n");
		printf("       skipbytes is # bytes in header to skip.   default = %ld\n", gHeaderSkip); 
		printf("       baseaddr is addr to upload to.            default = 0x%08lx\n", gBaseAddr);
		printf("       lptbase specifies base addr of LPT port.  default = 0x%lx\n", gBase); 

		return -1;
	}

    if ( ioperm(gBase, 3, true) == 0 )
    {
		outb( 0x20, gBase+kControlReg );		/* input, /STB is high */

		SendFile( gImageName, gBase, gBaseAddr, gHeaderSkip );

		ioperm(gBase, 3, false);
	}
    else
        printf("### ioperm() FAILED!\n\n");
}

void ArgValue( char *s, ulong *value )
{
    if ( isdigit(s[0]) ) 
	{
        if ( s[1] == 'x' )
            sscanf( s, "%x", value );
        else
            sscanf( s, "%d", value );
    }
	else
		*value = 0;
}


Boolean ParseCmds( unsigned long argc, char *argv[] )
{
    char *s;
    ulong cnt;

    if ( argc != 1 ) 
	{
        for ( cnt = 1; cnt < argc; cnt++ ) 
		{
            s = argv[cnt];
            switch ( s[1] ) 
			{
				case 's':	
					cnt++;
					ArgValue( argv[cnt], &gHeaderSkip );
					break;

				case 'b':	
					cnt++;
                    ArgValue( argv[cnt], &gBaseAddr );
                    break;

            	case 'p':	
					cnt++;
                    ArgValue( argv[cnt], &gBase );
                    break;

            	case 'f':	
					cnt++;
					gImageName = argv[cnt];
					break;	
            }
        }
	
		return true;
    }
	else
	{
		return false;
	}
}

#ifdef _W95GUI
void InitWindows(HWND hWnd)
{
	g_hWnd = hWnd;
}

/* Allows messages to process and check's for cancel message */
BOOL IsCancelled()
{
	MSG msg;

	while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		if (msg.message == WM_CANCEL)
		{
			return TRUE;
		}

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return FALSE;
}

#endif

void InitPort( ulong base )
{
	outb( 0x20, base+kControlReg );		/* input, /STB is high */
}

void SendFile( char *fn, ulong base, ulong addr, ulong skip )
{
	FILE *fp;
	ulong len;
	uchar *buf;
	long *copy;
	long cksum = 0;
	long data;
#ifdef _W95GUI
	char wMessage[80];
	long wLength = 0;
	long wCount = 0;
#endif

	if ( fp = fopen( fn, "rb" ) )
	{
		fseek(fp, 0, SEEK_END);
		len = ftell(fp);

#ifdef _W95GUI
		wLength = len;

		/* wLength /4 = length of file in bytes / number of bytes sent during SendLong */
		/* divided by STATUS_OFFSET to ensure the range isn't too large for the Progress Control */
		SendMessage(g_hWnd, WM_SET_LENGTH, (wLength / 4) / STATUS_OFFSET, 0);
#else
		printf("%s is %ld bytes long\n", fn, len);
#endif

// 42BS
//		fseek( fp, skip, SEEK_SET );
//		len -= skip;
//
//		len = ((len + 3) & ~3);			/* round up */
//		printf("len = %ld\n", len);

		fseek( fp, 0, SEEK_SET );   /* 42BS */

		buf = (uchar*)malloc( len );

		if ( buf )
		{
			uchar * save_buf = buf;   /* 42BS */
		  
			fread( buf, sizeof(char), len, fp ); 			

			skip = relocate( buf, &len , &addr, skip);    /* 42BS added this */

			buf += skip;                // skip some byte

			//len -= skip;                                  /* 42BS */

			len = ((len + 3) & ~3);			/* round up */

			SendLong( base, 0x22071970 );		  /* send magic number */
			SendLong( base, addr );			      /* send starting addr */
			SendLong( base, len+4 );		    	/* send length */

			len >>= 2;					        /* bytes -> words */ /* lets say :32-bit words :-) */
			copy = (ulong*)buf;

			while ( len-- )
			{
				data = BE_TO_LE(*copy++);	
				cksum += data;
				SendLong( base, data );
#ifdef _W95GUI
				if (IsCancelled())
				{
					break;
				}

				wCount++;

				/* every STATUS_OFFSET times otherwise the update slows the app down */
				if ((wCount % STATUS_OFFSET) == 0)
				{
					SendMessage(g_hWnd, WM_SET_POSITION, wCount / STATUS_OFFSET, 0);

					wsprintf(wMessage, "Sending byte %ld of %ld", wCount * 4, wLength);
					SendMessage(g_hWnd, WM_SET_MESSAGE, (WPARAM) wMessage, 0);
				}
#endif
			} 
	
#ifdef _W95GUI
			SendMessage(g_hWnd, WM_SET_POSITION, wLength, 0);

			wsprintf(wMessage, "Sending byte %ld of %ld", wLength, wLength);
			SendMessage(g_hWnd, WM_SET_MESSAGE, (WPARAM) wMessage, 0);
#else
			printf("cksum = %08lx\n", cksum);
#endif
			SendLong( base, -cksum );	/* send checksum */

			free( save_buf );     /* 42BS */
		}
		else
		{
#ifdef _W95GUI
			MessageBox(g_hWnd, "SendFile: couldn't alloc buf!", "BJL Uploader", MB_OK);
#else
			printf("SendFile: couldn't alloc buf!\n");
#endif
		}

		fclose( fp );
	}
	else
	{
#ifdef _W95GUI
		MessageBox(g_hWnd, "Couldn't open file!", "BJL Uploader", MB_OK);
#else
		printf("Couldn't open file %s!\n", fn);
#endif
	}
}

/* This expects a little-endian long. */
/* It big-endian-ifies it on the way out. */

void SendLong(ulong base, ulong w)
{
	SendByte( base, (uchar)w );
	SendByte( base, (uchar)(w >> 8) );
	SendByte( base, (uchar)(w >> 16) );
	SendByte( base, (uchar)(w >> 24) );
}


/*
From LOADER.DOC:

1) Wait for BUSY to be low => inactive
2) Send LSB
3) Set /STROBE to low => active
4) Wait for BUSY high => active
5) Set /STROBE to high
6) continue for the next three bytes
*/

void SendByte( ulong base, uchar c )
{
	sleep(0);
	while( !(inb( base+kStatusReg ) & 0x80) ) 	/* wait for BUSY = 0 */
		;
	sleep(0);

	outb( c, base+kDataReg );					/* drive data */
	outb( 0x01, base+kControlReg );			/* output, /STB = 0 */
	outb( c, base+kDataReg );					/* drive data */
	outb( c, base+kDataReg );					/* drive data */

	while( (inb( base+kStatusReg ) & 0x80) ) 	/* wait for BUSY = 1 */
		;

	outb( 0x20, base+kControlReg );			/* input, /STB is high */
}

/**********************/
/* GEMDOS - relocator */
/**********************/
/* this function sees if it finds a GEMDOS or JServer - header
   if so, skip,addr and len are adjusted
*/

ulong relocate( uchar * pdata, ulong *len , ulong *addr, ulong skip)
{
  if ( *((ushort *)pdata) != BE_TO_LEW(0x601a) )  // GEMDOS - header
  {
#ifdef _W95GUI
	MessageBox(g_hWnd, "No Gemdos-header !", "BJL Uploader", MB_OK);
#else
    printf("No Gemdos-header !\n");
#endif
    return (skip);                    /* skip user-defined bytes */
  }

  if ( *((ulong *)(pdata+28)) == BE_TO_LE42(0x4a414752) ) /* JAGR */
  {
    ushort type = BE_TO_LEW(*((ushort *)(pdata+32)));
    ulong new_len;
    
    if ( type != 2 && type != 3 )
    {
#ifdef _W95GUI
	  MessageBox(g_hWnd, "Unsupported JServer-Header!", "BJL Uploader", MB_OK);
#elif
      printf("Unsupported JServer-Header !\nLeaving ...\n");
#endif
      exit(-1);
    }
    
    *addr = BE_TO_LE42( *(ulong *)(pdata+34) );  // dest and start address
    
    if ( (new_len = BE_TO_LE42( *(ulong *)(pdata+38) ) ))
	{
      *len = new_len;
	}

	if ( type == 2)
		return (28+14);
	else
		return (28+18);
    //return ( 28 + 14 );      // skip GEMDOS and JServer-header
  }
//
// BJL - program
//
  {
    ulong textlen,datalen,symblen;   /* header info */
    ulong offset;
    ulong addr2 = *addr;
    uchar * reloptr, * pdata2;

    textlen = BE_TO_LE(*(ulong *)(pdata+2));
    datalen = BE_TO_LE(*(ulong *)(pdata+6));
//  bss_len = BE_TO_LE(*(ulong *)(pdata+10));   no need for this, yet
    symblen = BE_TO_LE(*(ulong *)(pdata+14));

    reloptr = pdata + textlen + datalen + symblen + 28;

    offset = *(ulong *)reloptr;   // first long to relocate
    
    reloptr += 4;                 // from now only bytes as offset
    
    pdata2 = pdata + offset;      // ptr to it

    while ( offset )              // until offset == 0
    {
      // compute new address , things are so simple on BE-machine ;-)
      
      *(ulong *)pdata2 = LE_TO_BE(BE_TO_LE( *(ulong *)pdata2 ) + addr2);
      
      // as long as offset is 1 skip 254 byte
      do
      {
        offset = (ulong) *reloptr;
        ++reloptr;
        if (! --offset)
          pdata2 += 254;
      }while ( !offset );
      pdata2 += offset+1;           // next address
    }

    *len = textlen + datalen;     // send only text and data , no symbols ...
    return ( 28 );                // skip GEMDOS header
  }
}

