// SettingsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "BJLUploader.h"
#include "SettingsDialog.h"
#include "Loader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettingsDialog dialog


CSettingsDialog::CSettingsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettingsDialog)
	m_strBaseAddr = _T("");
	m_dwHeaderSkip = 0;
	m_strBase = _T("");
	//}}AFX_DATA_INIT
}


void CSettingsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingsDialog)
	DDX_Text(pDX, IDC_BASE_ADDR, m_strBaseAddr);
	DDX_Text(pDX, IDC_HEADER_SKIP, m_dwHeaderSkip);
	DDX_CBString(pDX, IDC_BASE, m_strBase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingsDialog, CDialog)
	//{{AFX_MSG_MAP(CSettingsDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingsDialog message handlers

void CSettingsDialog::SetBaseAddr(unsigned long baseAddr)
{
	m_strBaseAddr.Format("0x%x", baseAddr);
}

void CSettingsDialog::SetBase(unsigned long base)
{
	if (base == 0x378)
	{
		m_strBase = "LPT1:";
	} 
	else if (base == 0x278)
	{
		m_strBase = "LPT2:";
	}
	else
	{
		m_strBase = "(None)";
	}
}

void CSettingsDialog::SetHeaderSkip(unsigned long headerSkip)
{
	m_dwHeaderSkip = headerSkip;
}

unsigned long CSettingsDialog::GetBaseAddr()
{ 
	unsigned long value;
	CString strBaseAddr = m_strBaseAddr;

	ArgValue(m_strBaseAddr.GetBuffer(m_strBaseAddr.GetLength()), &value);
	return value;
}

unsigned long CSettingsDialog::GetBase()
{ 
	if (m_strBase == CString("LPT1:"))
	{
		return 0x378;
	} 
	else if (m_strBase == CString("LPT2:"))
	{
		return 0x278;
	} 

	return 0;
}

unsigned long CSettingsDialog::GetHeaderSkip()
{ 
	return m_dwHeaderSkip; 
}


void CSettingsDialog::OnOK() 
{
	CDialog::OnOK();
}
