;*****************************************************************************
;*****************************************************************************
;*** CDEN16.S
;***
;*** Atari Jaguar CD-Encryption Utility
;***
;*** Reverse-engineered by Matthias Domin (DO)
;***
;*** DD.MM.YYYY
;*** 30.11.2003 DO: Finished reverse-engineering of the CDEN13 file.
;***                Result was called V1.5, run from $802000 (FLASH-card)
;*** 30.11.2004 DO: V1.6, runs from RAM on BJL-consoles
;***                Encryption data is transferred to a computer via
;***                XModem (115200-8-n-1). But this data-block is padded 
;***                with $60 empty bytes to reach a $80-boundary!
;***
;***
;*****************************************************************************
;*****************************************************************************
;*****************************************************************************


	.nlist
	.include	"jaguar.inc"
	.include	"cd.inc"
	.list

; from uart.s
    .extern uart_init   ;uart_init
    .extern uart_send   ;uart_send(char*);   /* stringaddress */
    .extern uart_get    ;uart_get   returns in d0 the  error_flags, in d1 the data-byte!
; from xmodem.s
    .extern upload      ;upload(char*, char*);   /* start, endaddress+1 */
;
;
;
; Butch's hardware registers
;
;
BUTCH     equ  $DFFF00		;base of Butch=interrupt control register, R/W
;
;  When written (Long):
;
;  bit0 - set to enable interrupts
;  bit1 - enable CD data FIFO half full interrupt
;  bit2 - enable CD subcode frame-time interrupt (@ 2x spped = 7ms.)
;  bit3 - enable pre-set subcode time-match found interrupt
;  bit4 - CD module command transmit buffer empty interrupt
;  bit5 - CD module command receive buffer full
;  bit6 - CIRC failure interrupt
;
;  bit7-31  reserved, set to 0 
;
;
;  When read (Long):
;
;  bit0-8 reserved
;
;  bit9  - CD data FIFO half-full flag pending
;  bit10 - Frame pending
;  bit11 - Subcode data pending
;  bit12 - Command to CD drive pending (trans buffer empty if 1)
;  bit13 - Response from CD drive pending (rec buffer full if 1)
;  bit14 - CD uncorrectable data error pending
;
;
;   Offsets from BUTCH
;
DSCNTRL   equ  4		; DSA control register, R/W
DS_DATA   equ  $A		; DSA TX/RX data, R/W
;
;
;
I2CNTRL   equ  $10		; i2s bus control register, R/W
;
;  When read:
;
;  b0 - I2S data from drive is ON if 1
;  b1 - I2S path to Jerry is ON if 1
;  b2 - reserved
;  b3 - host bus width is 16 if 1, else 32
;  b4 - FIFO state is not empty if 1
;
;
;
;
SBCNTRL   equ  $14		; CD subcode control register, R/W
SUBDATA   equ  $18		; Subcode data register A
SUBDATB   equ  $1C		; Subcode data register B
SB_TIME   equ  $20		; Subcode time and compare enable (D24)
FIFODAT   equ  $24		; i2s FIFO data
I2SDAT2   equ  $28		; i2s FIFO data (old)
;
;
;
;
CDtoc	equ	$2c00			;CD Table o Contents base addr
Keysize	equ	65+3
;
dlist	equ	$4000
image	equ	$4040
;
;
sessrow	equ	2
sesscol	equ	8
;
;
;   GPU enRSA program locations..
;
a_num	equ	G_RAM
b_num	equ	a_num+68
c_num	equ	b_num+68
n_num	equ	c_num+68
m_coe	equ	n_num+68
dramin	equ	m_coe+4
dramine	equ	dramin+4
dramout	equ	dramine+4
;
;
;
;
start:
INIT:             move    #$2700,sr
                  lea     $1000.w,sp
                  lea     $F00000,a0
                  move.l  #$070007,d0           ; big endian
                  move.l  d0,$210C(a0)
                  move.l  d0,$F1A10C
                  moveq #0,d0
                  move.l d0,$2114(a0)           ; stop gpu
                  move.l d0,$f1a114             ; stop dsp
                  move.l d0,$2100(a0)           ; disable GPU-IRQs
                                                ; disable DSP-IRQs
                  move.l #%10001111100000000,$f1a100
                  move.l #%111111<<8,$f10020    ; clear and disable IRQs

                  move.l  d0,0.w
                  moveq   #4,d0
                  move.l  d0,4.w
                  moveq   #0,d0
                  move.l  d0,$20(a0)            ; set OP to STOP-OBJECT
                  move.w  d0,$26(a0)            ; clear OP-Flag
                  move.l  d0,$2A(a0)            ; border black
                  move.w  d0,$56(a0)            ; set CRY mode to color/not BW
                  move.w  d0,$58(a0)            ; background black
                  move.l  d0,$50(a0)            ; stop PIT
                  move.l  d0,$f10000            ; stop JPIT1
                  move.l  d0,$f10004            ; stop JPIT2
                  move.l  #$1F00<<16,$E0(a0)    ; clear pending irqs
                  move.w  #$7fff,$4e(a0)        ; no VI
                  lea     dummy_irq(pc),a0
                  move.l  a0,$0100.w
                  bra.s   INIT1
dummy_irq:        move.l #$1f00<<16,$f000e0
                  rte
INIT1:            moveq #0,d0
                  moveq #0,d1
                  moveq #0,d2
                  moveq #0,d3
                  moveq #0,d4
                  moveq #0,d5
                  moveq #0,d6
                  moveq #0,d7
                  move.l d0,a0
                  move.l d0,a1
                  move.l d0,a2
                  move.l d0,a3
                  move.l d0,a4
                  move.l d0,a5
                  move.l d0,a6
                  move.l a0,usp


    move.w  #$1865,MEMCON1      ; 32 bit card-bus
;##    move.l  #0,$dfff00 ; turn off BUTCH chip of the CDROM! in 32bit!!!

;-----------------------------------------------------------------------
; init Videosystem
;-----------------------------------------------------------------------
    bsr     VideoIni   ; init Videosystem





;#######	lea     $200000,sp		;set stack at top of memory
	move.w	#$100,JOYSTICK  ; JOY1		;unmute






;
; the following is test code
;
;>>	lea     premark,a0
;>> lea     $9EAC,a0
    lea     postmark,a0

	moveq	#0,d0
	move.w	#$7fff,d1
clrfine:
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	dbra	d1,clrfine
;
	move.l	#butchbuf,butchptr
;>>   MOVE.L    #$7618,$7614.L
      MOVE.L    #A7618,A7614

;>>   MOVE.L    #$71EAC,$9618 
      MOVE.L    #FileST,A9618 

;>>   MOVE.L    #$980CC,$961C 
      MOVE.L    #premark,A961C 

;
;
;***********************************
;  start-up our fake video
;
	lea     dlistROM,a0
	lea     dlist,a1
	moveq	#15,d0
getlist:
	move.l	(a0)+,(a1)+
	dbra	d0,getlist		;copy ROM display list to ram
;
;
	lea     image,a0
	moveq	#0,d0
	move.w	#12*240-1,d1
clearimg:
	move.l	d0,(a0)+
	dbra	d1,clearimg
;
	clr.l	fcount

;##	move.l	#Frame,$100
	move.l	#dlist,d0
	swap	d0
	move.l	d0,OLP			;stop object is here
;
    bsr     IntInit         ; DO for V1.6 (BJL)
;
	moveq	#0,d0
	move.l	d0,BORD1
	move.w	d0,BG
	move.w	#-1,VDE
;
	move.w	#$101,INT1
;
	move.w	#$4c7,VMODE

;             RRRRRBBBBBGGGGGG
	move.w	#%0000001111000000,CLUT		;blue
	move.w	#%0111101111011111,CLUT+2   ;white
;

	move.w	#%0000001111000000,BG		;blue
;

	lea     signon,a0
	moveq	#sessrow,d0
	moveq	#sesscol,d1
	bsr     Stringprepare
    bsr     Stringoutput        ; = string()

    lea     signon2,a0          ; DO
    moveq   #sessrow+1,d0       ; DO
    moveq   #sesscol,d1         ; DO
    bsr     Stringprepare       ; DO 
    bsr     Stringoutput        ; DO
;
;******************************************

	lea     $3000,a0
	lea     cdbios,a1
	move.w	#$3ff,d0
copbios:
	move.l	(a1)+,(a0)+
	dbra	d0,copbios
;
	jsr     CD_setup
	move.w	#3,d0
	jsr     CD_mode
;
DSP_w:
	move.l	D_CTRL,d0
	lsr.l	#1,d0
	bcs     DSP_w
;
	moveq	#0,d0
	move.w	#255,d1
	lea     privy,a0
zeropriv:
	move.l	d0,(a0)+
	dbra	d1,zeropriv
;
	lea     priat,a0
	lea     privat,a1
	move.w	#68-1,d0
rampriv:
	move.w	(a0)+,(a1)+
	dbra	d0,rampriv
;
	lea     getpriv,a0
	moveq	#sessrow+4,d0
	moveq	#sesscol,d1
	bsr     string
;
	lea     privy,a0        ; Address to which the file PRIVATCD.KEY should be loaded
	lea     resume(pc),a1   ; Address from which the program should be re-started
;
;>>>forever: bra.s forever
;>>>***	illegal
    NOP     ; DO: PRIVATCD.KEY is now INCBINed!!!!!
;
resume:
;
;   Convert dc.b into binary
;
;>>>####	lea     privy,a0            ; DO: PRIVATCD.KEY is now INCBINed!!!!!
    lea     privatekey,a0       ; privy DO

	lea	    privat+3,a1
privlp:
	move.b	(a0)+,d0
	beq.s	privdone
	cmpi.b	#"$",d0
	bne.s	privlp		;wait for "$"
	moveq	#1,d1
	moveq	#0,d2
twonib:
	lsl.w	#4,d2
	move.b	(a0)+,d0
	subi.b	#"0",d0
	cmpi.b	#10,d0
	bcs.s	gotnib
	subi.b	#7,d0
	cmpi.b	#16,d0
	bcs.s	gotnib
	subi.b	#$20,d0
gotnib:
	or.b	d0,d2
	dbra	d1,twonib
	move.b	d2,(a1)+
	bra	    privlp		
privdone:
;
;
; Load, & initialize DSP "gettoc" program
;
DoDSP:
	move.l	#DSP_S,a0
	move.l	#DSP_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#D_RAM,a1
x4loop:
	move.l	(a0)+,(a1)+
    dbra    d0,x4loop
;
	move.l	#D_RAM,D_PC	; Set GPU PC to start of code in SRAM
;
	move.l	#1,D_CTRL	; start GPU
;
	lea	    getcdtoc,a0
	moveq	#sessrow+4,d0
	moveq	#sesscol,d1
	bsr 	string
;
;
	lea	    D_RAM,a0
dwait:
	move.l	(a0),d0		;wait til dsp stuffs 0 here
	bne	    dwait
;
	tst.l	BUTCH+I2CNTRL	;clear any error
;
	lea	    CDtoc,a1
	move.l	(a1)+,d5	;check for "Disc not present or timeout
	bpl	    notTO
;
;  Error condition detected...
;
;  d5.l = $FFFF0000 if time-out (format may be CD-I or other un-recognized)
;	= $FFFFFFFF if disc not present (status = $402 lid closed, no disc)
;
	lea	    badisc,a0
	bra	    errexit

notTO:
;
;  Inform user of Directory status...
;
	lea	    CDtoc,a0
	move.l	(a0)+,d0
	andi.w	#$ff,d0			;last track
	moveq	#0,d2			;init scan track
scantrk:
	addq	#1,d2
	cmp.b	d0,d2
	bcc	    notenuf		;exit if not enough tracks to scan 
	addq.l	#8,a0
	move.l	(a0),d1
	rol.l	#8,d1
	cmpi.b	#1,d1			;session #1?
	bne	    scantrk
	bra.s	sendst
notenuf:
	lea	    trknot,a0
	bra	    errexit
;
;
sendst:
;
;  d2.w = 1st track to encrypt
;  d0.w = Last +1 to encrypt
;
	subq.w	#1,d0
	move.w	d2,d3
	move.w	d0,d4		;save start-end track #
;
	lea	    statmsg,a0
	lea	    statm,a1
copstat:
	move.b	(a1)+,(a0)+
	bne	    copstat
;
	lea	    statmsg+13,a0
	moveq	#1,d1
statclp:
	andi.l	#$ff,d2
	divu	#10,d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	swap	d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	addq.l	#1,a0
	move.w	d0,d2
	dbra	d1,statclp
;
;  Compute total CD time
;
	lsl.w	#3,d3			;start track
	lsl.w	#3,d4			;end track
	lea	    CDtoc+4,a0		;Now, sum the times
	move.l	a0,a1
	adda.w	d3,a0
	adda.w	d4,a1

	moveq	#0,d0			;init sum
	subq.l	#8,a0
sumloop:
	addq.l	#8,a0
	move.l	(a0),d1
	andi.l	#$ffffff,d1		;strip session
;
	add.b	d1,d0			;advance our time by frame increment
	cmp.b	#75,d0			;d3= 00 Am As Af
	bcs.s	frok
	sub.b	#75,d0	
	ori	    #$10,ccr		;set x
frok:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = Af 00 Am As
	addx.b	d1,d0
	cmp.b	#60,d0
	bcs.s	secok
	sub.b	#60,d0
	ori	    #$10,ccr		;set x
secok:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = As Af 00 Am
	addx.b	d1,d0
	swap	d0			;d0 = 00 M S F
	cmp.l	a1,a0
	bcs	    sumloop
;
;  d0 = 00 MM SS FF
;
	moveq	#0,d1
	addi.b	#37,d0			;round off frames
	cmpi.b	#75,d0
	bcs.s	noround
	addq	#1,d1
noround:
	lsr.l	#8,d0
	add.b	d1,d0
	cmpi.b	#60,d0
	bcs.s	norowr
	subi.b	#60,d0
	addi.w	#$100,d0
norowr:
	lea	    statmsg+33,a0
	move.l	d0,d2
	lsr.w	#8,d2			;minutes
;
	moveq	#1,d1
timlp:
	andi.l	#$ff,d2
	divu	#10,d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	swap	d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	addq.l	#1,a0
	move.w	d0,d2
	dbra	d1,timlp
;
	lea	    statmsg,a0
	moveq	#sessrow+4,d0		;put out TOC status
	moveq	#sesscol-4,d1
    bsr     Stringprepare
	bsr     Stringoutput        ; = string()
;
	lea	    headmsg,a0
	moveq	#sessrow+6,d0		;put out header line
	moveq	#sesscol-4,d1
    BSR     L0086 
	bsr	    string
;
	lea	    headmsg1,a0
	moveq	#sessrow+7,d0		;with underline
	moveq	#sesscol-4,d1
    BSR     L0086 
	bsr	    string
;
;
;  Form Header & Tailer
;
	moveq	#$7f,d2
	lea	    CDtoc,a0
	and.l	(a0)+,d2
sess1f:
	addq.l	#8,a0
	btst.b	#0,(a0)
	beq	    sess1f
;
	move.l	-(a0),d3
	rol.l	#8,d3
	sub.b	d3,d2
	move.b	d2,d3
	addi.b	#" ",d3

	lea	    FileST,a0
	move.l	#"ATRI",d0
	moveq	#15,d1
headcp:
	move.l	d0,(a0)+
	dbra	d1,headcp
;
	lea	    headstr,a1
	moveq	#7,d1
headcp1:
	move.l	(a1)+,(a0)+
	dbra	d1,headcp1
	move.b	d3,-1(a0)	;stuff rel track
;
	move.w	#$26160/4-1,d1
	move.l	#$C00DADE0,d0
filler:
	move.l	d0,(a0)+
	dbra	d1,filler
;
	moveq	#7,d1
tailcp1:
	move.l	(a1)+,(a0)+
	dbra	d1,tailcp1
	move.b	d3,-1(a0)
;
	move.l	#"ATRI",d0
	moveq	#15,d1
tailcp:
	move.l	d0,(a0)+
	dbra	d1,tailcp
	bra	    Do_GPU
;
;
;		 10987654321098765432109876543210
headstr:
	dc.b	"ATARI APPROVED DATA HEADER ATRI "
tailstr:
	dc.b	"ATARI APPROVED DATA TAILER ATRI "
;
;
;  Load GPU program for background RSA computation...
;
;
Do_GPU:
	move.l	#ENRSA_S,a0
	move.l	#ENRSA_E,a1
;
	move.l	a1,d0
	sub.l	a0,d0		; Size in bytes
	addq.l	#3,d0
	asr.l	#2,d0
;>>	move.l	#enRstart,a1
    MOVEA.L #$F0351C,A1 ; enRstart

	move.l	a1,d1
	bra.s	xferlpi
xferloop:
	move.l	(a0)+,(a1)+
xferlpi:
    dbra    d0,xferloop
;
	lea	    privat,a0
	lea	    c_num,a1
	move.w	#Keysize/2-1,d0
keyzin:
	move.l	(a0)+,(a1)+
	dbra	d0,keyzin
;
	move.l	-(a0),d0
	andi.w	#$ff,d0
	lea	    coeftab,a0
	move.b	(a0,d0.w),d0
	ext.l	d0
	lea	    m_coe,a0
	move.l	d0,(a0)+	;set montgomery coeffiecient
;
	move.l	#resultF+65,dramout
;
;>> move.l	#enRstart,G_PC
    MOVE.L  #$F0351C,G_PC ; enRstart
	move.l	#1,G_CTRL	;start it up
;
;>>	lea	    RSAsemi,a0
    LEA     $F03774,A0      ; RSAsemi

semwait:
	move.l	(a0),d0
	beq	    semwait		;wait til semiphore is ready

;>>      LEA       privy,a0        ; new $9620,A0 !
;>>      LEA       $9620,a0        ; new privy????
      LEA       privy,a0
;>>      LEA       privy+1024+68,a1; new $9A64,A1 !
;>>      LEA       $9A64,a1        ; new publicK??????
      LEA       publicK,a1        ; new publicK??????
      MOVEQ     #0,D0           ; new!
L0026:MOVE.L    D0,(A0)+        ; new!
      CMPA.L    A1,A0           ; new!
      BCS.S     L0026           ; new!

;
;  Ok, she's ready
;
;
;
DSP_wait:
	move.l	D_CTRL,d0
	lsr.l	#1,d0
	bcs	    DSP_wait
;
	lea	    finehash,a0
	moveq	#0,d0
	moveq	#6,d1
firsthas:
	move.l	d0,(a0)+
	dbra	d1,firsthas
;
	move.l	a0,curfine		;set up output ptr
	move.l	#finehash+$40,currsa	;set up for RSA operation
;
	bsr	    MD5toc		;compute hash for TOC
	lea	    finehash+12,a0
	movem.l	d0-d3,(a0)	;save in finehash
;
;
; Load, & initialize DSP program
;
Do_DSP:
	move.l	#ENMD5_S,a0
	move.l	#ENMD5_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#D_RAM,a1
xferlp:
	move.l	(a0)+,(a1)+
    dbra    d0,xferlp
;
	move.l	#$14,SMODE
;
	moveq	#1,d0
	jsr	    CD_jeri			;send data to Jerry
;
;>>	move.l	#MD5start,D_PC
    MOVE.L  #$F1B030,D_PC   ; MD5start

	move.l	#1,D_CTRL	;start it up
;
;
	clr.l	countRSA
;
;   --------------------------
;  We need to get a track to MD5
;
	lea	    CDtoc+8,a0	;start with boot track (1st track on session #1)
findboot:
	move.l	(a0)+,d0
	move.l	(a0)+,d1
	rol.l	#8,d1
	cmpi.b	#1,d1		;session #1
	bne	    findboot
;
	subq.l	#8,a0
	move.l	a0,nextrk
;
	moveq	#0,d0
	move.l	d0,BlokT	;clear block total
	move.l	d0,SizeT	;& total size
	move.l	d0,MaxT
	moveq	#-1,d0
	move.l	d0,MinT
;
;  repeat here
;
tracklp:
	move.l	currsa,d0	;get start of next allowed finehash to RSA
	move.l	curfine,d1	;get start of last completed finehash
	sub.l	d0,d1		;any finehash ready for RSA?
	bcs.s	skipRSAe	;br if not
;
	andi.w	#~63,d1		;adjust byte count of span to integer blocks
	tst.l	d1
	beq.s	skipRSAe	;br if less that 1 full block
;
;>>	lea     RSAsemi,a0
    LEA     $F03774,A0      ; RSAsemi

	move.l	(a0),d2		;check for busy RSA
	bpl.s	skipRSAe	;skip if RSA is busy
;
	move.l	d0,dramin
	add.l	d1,d0
	move.l	d0,dramine
	moveq	#0,d2
	move.l	d2,(a0)		;start up some more RSA
;
	lsr.l	#6,d1
	move.l	d1,countRSA	;let GPU decrement this for display
	move.l	d0,currsa	;here's where we start next time
skipRSAe:
	move.l	nextrk,a0
	move.l	(a0),d0

	movem.l	a0-a1/d0,-(sp)
;
;  Scroll down any previous data
;
;	lea	    image+((sessrow+18)*48*8),a0
;	lea	    image+((sessrow+19)*48*8),a1
;	move.w	#12*(8*10)-1,d0
;
	lea	    image+((sessrow+25)*48*8),a0
	lea	    image+((sessrow+26)*48*8),a1
	move.w	#12*(8*17)-1,d0
scrdwn:
	move.l	-(a0),-(a1)
	dbra	d0,scrdwn
;
	lea	    scanmsg,a0
	lea	    curmsg,a1
freshmsg:
	move.b	(a0)+,(a1)+		;refresh msg
	bne	    freshmsg
;
	lea	    curmsg+10,a0
	rol.l	#8,d0
	andi.l	#$ff,d0
	divu	#10,d0
	tst.b	d0
	bne.s	lead0
	move.b	#" ",(a0)+
	bra.s	lead1
lead0:
	addi.b	#"0",d0
	move.b	d0,(a0)+
lead1:
	swap	d0
	addi.b	#"0",d0
	move.b	d0,(a0)+
;	
	lea	    curmsg,a0		;put up "Scanning xx" (track #)
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	    string
;
	movem.l	(sp)+,a0-a1/d0

L0031:
	bsr	    backup6		;back up d0.l 6 frames
;
	move.l	butchptr,a3
	move.l	d0,(a3)+
	move.l	a3,butchptr

	bset.l	#31,d0
	jsr	    CD_read		;go play some hash
;
	jsr	    CD_ack
	cmpi.w	#$100,d1	;seek error?
	bne	    seeker0		;br if so
;
	tst.l	BUTCH+I2CNTRL	;clear any error
;
;>>	lea     MD5semi,a3
    LEA     $F1B020,A3          ; MD5semi

;>>  MOVE.L  #$802000,4(A3) ; D0
;>>  MOVE.L  #$C0000,4(A3) ; D0
    move.l  #premark,4(a3)  

	move.l	#1,(a3)	;start up pre-hash (potential markers picked)
;
;
;
.check:
	move.l	(a3),d0		;wait til completion
	bpl.s	.check
;
	move.l	BUTCH,d0
	btst.l	#14,d0
;>>	bne 	cd_err0		;exit if error
    BEQ.S   L0033
    BSR     cd_err0             ; L0064

    ADDQ.B    #1,$101B82        ;???????????
    MOVEA.L   nextrk,A0
    MOVE.L    (A0),D0 
;>>    SUBQ.L    #4,$9AA8
    SUBQ.L    #4,butchptr
    BRA.S     L0031

L0033:
;
	lea	    curmsg,a0
	lea	    analmsg,a1
getanal:
	move.b	(a1)+,d0
	beq.s	nonanal
	move.b	d0,(a0)+
	bra	    getanal
nonanal:
;
;  Convert the potential markers found into legit markers we will use..
;
;  This track's premark has 4-longword records
;
;   +0 marker length (in longs, should be 16)
;   +4 pattern
;   +8 offset from "ATRI" marker at start of track
;   +C unused, reserved
;
;
;>>	move.l	MD5ptr,a2	;get end of list from DSP
    MOVEA.L $F1B024,A2          ; MD5Ptr


	lea	   premark,a0	;SRC ptr
;>> LEA    $802000,a0     ; D0
;>> LEA    $C0000,a0     ; D0

	lea	    postmark,a1	;DST ptr
;
;  print out # of potential markers found
;
	movem.l	a0/d0-d1,-(sp)
;
	move.l	a2,d0
	sub.l	a0,d0
	lsr.l	#4,d0
	lea	    curmsg+13,a6	;start of "Mrk"
	bsr	    dec10000	;decimalize for up to 65535
;
	lea	    curmsg,a0	;now Analyzing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	    string
;
	movem.l	(sp)+,a0/d0-d1
;
	moveq	#0,d0		;starting offset
	move.l	#$20000,d1	;get minimum block size
	moveq	#$10,d3		;get record size
nextmark:
	lea	    -8(a0),a3	;point to offset field, & adjust for adda below
;
;  find next mark at least 128k away
;
momark:
	adda.l	d3,a3		;go for next record
	cmp.l	a2,a3		;did we go off the end?
	bcc.s	markoff		;br if so (we put this in as last one)
	move.l	(a3),d2		;get next offset
	sub.l	d0,d2
	cmp.l	d1,d2		;at least 128k further along?
	bcs	    momark		;br if not
;
;  we found one at least 128k further along
;
	lea	    -8(a3),a4	;go to start of record (marker size in longs)
	moveq	#$10,d2
	cmp.l	(a4),d2		;are we exactly the right size?
	bne	    momark		;br if not--we can't use this one
;
;  now, check this patterns' use over previous 128k
;
	move.l	4(a4),d2	;fetch pattern for putative sync mark 
	move.l	8(a4),d4	; and offset too

	move.l	a4,a5		;start checking up to 128k or at previous
patchk:
	suba.l	d3,a5
	cmp.l	a0,a5		;backed up too far?
	bcs.s	goopat		;br if so--this one will be ok
	move.l	d4,d5		;get putative offset
	sub.l	8(a5),d5	;check for 128k or less
	cmp.l	d1,d5
	bcc.s	goopat		;br if >128k
	cmp.l	4(a5),d2	;are we same pattern?
	beq	    momark		;br if same pattern found within 128k
	bra	    patchk

;
;  a4 -> next pattern we do
;
goopat:
	addq.l	#4,a4		;skip pat length
	move.l	(a4)+,(a1)+	;set terminating pattern
	addq.l	#8,a4
;
	moveq	#63,d5
	add.l	d4,d5
	sub.l	d0,d5
	lsr.l	#6,d5		;this is our block count
;
	move.l	d5,(a1)+	;save block count
;
	lsl.l	#6,d5
	add.l	d0,d5		;offset where hashing ends
;
	moveq	#64,d6
	add.l	d4,d6		;d6 = next begining offset

	move.l	d0,(a1)+	;save start offset	

	move.l	d6,d0		;save next one
;
	sub.l	d5,d6		;skip count (0..64)
	move.l	d6,(a1)+	;save
;
	move.l	a4,a0
	cmp.l	a2,a0		;did we go off the end?
	bcs	    nextmark
	bra.s	markdon
;
;  set last one
;
markoff:
	lea	    -$18(a3),a4
	move.l	8(a4),d4	;get offset for last sync mark
	bra	    goopat
;
;
;  We finished pass 1, now we know which partition markers to use..
;
;  Records in postmark should look like..
; 
;   +0 Terminating pattern
;   +4 Block (64 bytes each) count
;   +8 Absolute starting offset
;   +C Left over offset to skip for next 
;
markdon:
;
; now compute # of blocks, Min/Max block size and total length
;
	moveq	#0,d0		;max
	moveq	#-1,d1		;min
	moveq	#0,d3		;count
	move.l	#"ATRI",d2	;terminating pattern
	lea	    postmark-16,a0	;
;
markchk:
	adda.w	#16,a0
	move.l	4(a0),d4	;get size (in $40 byte blocks)
	cmp.l	d4,d0
	bcc.s	notmax
	move.l	d4,d0
notmax:
	cmp.l	d1,d4
	bcc.s	notmin
	move.l	d4,d1
notmin:
	addq.w	#1,d3
	cmp.l	(a0),d2
	bne	    markchk
	subq.l	#8,a2
	move.l	(a2),d4		;get length til terminator
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
      MOVE.W    D3,A7604.L

	cmp.l	MaxT,d0
	bcs.s	notnmax
	move.l	d0,MaxT		;new global max
notnmax:
	cmp.l	MinT,d1
	bcc.s	notnmin
	move.l	d1,MinT		;new global min
notnmin:
	andi.l	#$ffff,d3
	add.l	d3,BlokT
	add.l	d4,SizeT
;
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
	bsr	    stuffval	;stuff values on current line
;
	move.l	nextrk,a0	;retry the same track
	move.l	#(2*75),d3	;2 seconds of adjust (if not end of session)

	move.l	4(a0),d0
;>>	move.l	20(a0),d1
    move.l  12(a0),d1       ;<<<<<<<<<<<<<
	rol.l	#8,d0
	rol.l	#8,d1
	cmp.b	d1,d0		;next track in same session?
	beq.s	check		;br if so
	moveq	#0,d3		;else, adjustment already in
check:
	move.l	4(a0),d0	;get what directory sez is the file size
	move.l	d0,d1
	swap	d1
	andi.w	#$ff,d1
	mulu	#4500,d1
	moveq	#0,d2
	move.b	d0,d2
	add.l	d2,d1
	lsr.w	#8,d0
	mulu	#75,d0
	add.l	d0,d1		;d1=# of frames in trk, according to directory
	sub.l	d3,d1		;subtract 2 seconds worth (if necessary)
	move.w	d1,d0
	mulu	#2352,d0
	swap	d1
	mulu	#2352,d1
	swap	d1
	add.l	d1,d0		;d0 = # of bytes, according to directory
;
	move.b	#"+",d1		;assume measured is greater
	cmp.l	d4,d0		;which is greater, TOC or measured?
	bcc.s	tocgrat		;br if TOC is greater
;
	sub.l	d0,d4
	move.l	d4,d0
	bra.s	absmag	
tocgrat:
	move.b	#"-",d1
	sub.l	d4,d0		;see how much more we got than indicated
absmag:
	cmpi.l	#(10*2352),d0	;if differs by more than 10 frames, put up +/-
	bcs.s	nostar
;
	move.b	d1,curmsg+43
nostar:
;
;
;
	lea	    curmsg,a0
	lea	    md5msg,a1
getmd5:
	move.b	(a1)+,d0
	beq.s	nonmd5
	move.b	d0,(a0)+
	bra	    getmd5
nonmd5:
;
;  Put in # of Blocks, Min/Max and Size
;
	lea	    curmsg,a0		;"MD5ing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	    string
;
;
;
;>>      MOVEA.L   #A9EAC,A0
      MOVEA.L   #postmark,A0

;>>      MOVE.L    A0,$75F4.L          ; privy ?                    ---> Enmd5.das: "MD5ptr"
      MOVE.L    A0,A75F4.L          ; ---> Enmd5.das: "MD5ptr"

;>>      MOVE.L    #$29EAC,A75F8.L     ; $9EAC+$20000, privy+4????  ---> Enmd5.das: "MDsemi"
      MOVE.L    #prehash,A75F8.L     ; $9EAC+$20000, privy+4????  ---> Enmd5.das: "MDsemi"

      MOVE.W    A7604.L,D0

      ANDI.L    #$FFFF,D0 
      LSL.L     #4,D0 
      ADDA.L    D0,A0 
      MOVE.L    A0,A760C.L          ; MaxT???? $20 offset??
      MOVE.L    #"ATRI",A75FC.L  ; ATRI     ---> Enmd5.das: "PATptr"
      CLR.L     A7610.L 
L0047:
;>>   LEA       postmark,A0
;>>   LEA       $9EB4,A0
      LEA       postmark+8,A0

      MOVEA.L   A760C.L,A3
      MOVE.L    A7610.L,D0

      MOVEQ     #$10,D1 
L0048:SUB.L     D0,(A0) 
      ADDA.L    D1,A0 
      CMPA.L    A3,A0 
      BCS.S     L0048 


      MOVEQ     #-1,D1

      MOVE.L    #$A17FC0,D2     ; (60*75*2352)
L0049:
minsub0:
      ADDQ.W    #1,D1 
      SUB.L     D2,D0 
      BCC.S     minsub0         ; L0049 
      ADD.L     D2,D0 
;
;
      SWAP      D1
      MOVE.W    #-1,D1
      MOVE.L    #$2B110,D2      ; 176400
L004A:ADDQ.W    #1,D1 
      SUB.L     D2,D0 
      BCC.S     L004A 
      ADD.L     D2,D0 
      LSL.W     #8,D1 
      LSR.L     #4,D0 
      DIVU      #$24C,D0
      MOVE.B    D0,D1 
      MOVEA.L   $74C4.L,A0
      MOVE.L    (A0),D0 
      ANDI.L    #$FFFFFF,D0 
      ADD.B     D1,D0 
      CMP.B     #$4B,D0         ; 75
      BCS.S     L004B 
      SUB.B     #$4B,D0         ; 75
      ORI.B     #$10,CCR
L004B:ROR.L     #8,D0 
      ROR.L     #8,D1 
      ADDX.B    D1,D0 
      CMP.B     #$3C,D0         ; 60
      BCS.S     L004C 
      SUB.B     #$3C,D0         ; 60
      ORI.B     #$10,CCR
L004C:ROR.L     #8,D0 
      ROR.L     #8,D1 
      ADDX.B    D1,D0 
      SWAP      D0
      MOVE.L    D0,A7600.L
      MOVE.W    A7604.L,D0
      CMPI.W    #$100,D0
      BLS.S     L004D 
      MOVE.W    #$100,D0
L004D:SUB.W     D0,A7604.L
      MOVE.W    D0,A7606.L
      ANDI.L    #$FFFF,D0 
      CMPI.W    #3,D0 
      BCS.S     L004E 
      SUBQ.W    #1,D0 
L004E:LSL.L     #4,D0 
      MOVEA.L   A75F4.L,A3          ; --> Enmd5.das: "MD5ptr"
      MOVE.L    0(A3,D0.L),A7608.L
      CLR.L     0(A3,D0.L)
L004F:MOVE.L    A7600.L,D0
      BSR       backup6             ; L007D 
      MOVEA.L   $9AA8,A3
      MOVE.L    D0,(A3)+
;>>   MOVE.L    A3,$9AA8
      MOVE.L    A3,butchptr
      BSET      #31,D0
      JSR       CD_read
      JSR       CD_ack
      CMPI.W    #$100,D1
      BNE       seeker1             ; L0068 
      TST.L     $DFFF10             ; BUTCH+$10
      LEA       $F1B020,A3
      MOVE.L    A75F8.L,4(A3)       ; Enmd5.das: "MD5semi"
      MOVE.L    A75F4.L,8(A3)       ; Enmd5.das: "MD5ptr"
      MOVE.L    A75FC.L,12(A3)      ; Enmd5.das: "PATptr"
      MOVE.L    #0,(A3) 


L0050:
.check:
      MOVE.L    (A3),D0 
      BPL.S     .check              ; L0050 
      MOVE.L    BUTCH,D0
      BTST      #14,D0
      BEQ.S     L0051 


      BSR       cd_err1             ; L0065 
      ADDQ.B    #1,$101BA0
;>>   SUBQ.L    #4,$9AA8
      SUBQ.L    #4,butchptr
      BRA.S     L004F 
L0051:
;>>   LEA       A9EB4,A0
;>>   LEA       postmark,A0
      LEA       postmark+8,A0
      MOVEA.L   A760C.L,A3
      MOVE.L    A7610.L,D0
      MOVEQ     #$10,D1 
L0052:ADD.L     D0,(A0) 
      ADDA.L    D1,A0 
      CMPA.L    A3,A0 
      BCS.S     L0052 
      MOVEA.L   A75F4.L,A3     ; ---> Enmd5.das: "MD5ptr"
      MOVE.W    A7606.L,D0
      ANDI.L    #$FFFF,D0 
      CMPI.W    #3,D0 
      BCS.S     L0053 
      SUBQ.W    #1,D0 
L0053:LSL.L     #4,D0 
      ADDA.L    D0,A3 
      MOVE.L    A7608.L,D1
      MOVE.L    D1,(A3) 
      MOVE.L    D1,A75FC.L      ; ---> Enmd5.das: "PATptr"
      ADDA.W    #$10,A3 
      MOVE.L    A3,A75F4.L      ; ---> Enmd5.das: "MD5ptr"
      MOVE.L    8(A3),A7610.L 
      MOVEA.L   A75F8.L,A3      ; ---> Enmd5.das: "MDsemi"
      ADDA.L    D0,A3 
      ADDA.W    #$10,A3 
      MOVE.L    A3,A75F8.L      ; ---> Enmd5.das: "MDsemi"
      TST.W     A7604.L 
      BNE       L0047
;
;
;  we use postmark and prehash tables to generate final finehash
;
;   postmark
;
;   +0 - terminating pattern
;   +4 - block count
;   +8 - start absolute offset (from just after 16 x "ATRI")
;   +C - amount to skip before next (not used)
;
;   prehash is 4 longs corresponding to the postmark table of hash
;
;  Now, put some polish to it
;
;
trkcomp:
	lea	    postmark,a0	;get start of generated buffer
	lea	    prehash,a1	; & hash table
;>>>    lea     $29EAC,a1  ; & hash table
	move.l	curfine,a2	;take up where we left off
	move.l	nextrk,a3
	move.l	(a3),d5		;get track's start time
	andi.l	#$ffffff,d5
;
;  Do first one as special case
;
	move.l	d5,(a2)+	;stuff start time (base track time)
	move.l	#"ATRI",(a2)+	; & start pattern (always start with ATRI)
	move.l	4(a0),(a2)+	;set block count
;
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 1
	move.l	(a1)+,(a2)+	;stuff hash 2
	move.l	(a1)+,(a2)+	;stuff hash 3
;
raw2fin:
	move.l	(a0),d6		;get previous pattern
	adda.w	#16,a0		;advance to next raw record
	cmpi.l	#"ATRI",d6	;are we at end
	beq	    raw2finx	;br if so
;
	move.l	8(a0),d0	;get starting offset
;
;  convert to ABS time (use track start time)
;
	moveq	#-1,d1		;init minutes count
minsub:
	addq.l	#1,d1
	sub.l	#(60*75*2352),d0
	bcc	    minsub
	add.l	#(60*75*2352),d0
;
;  d1 is minutes
;
	moveq	#-1,d2		;init seconds count
secsub:
	addq.l	#1,d2
	sub.l	#(75*2352),d0
	bcc	    secsub
	add.l	#(75*2352),d0
;
;  d2 is seconds
;
	divu	#2352,d0
;
;  d0 is frames
;
	add.b	d5,d0		;add frames
	cmpi.b	#75,d0
	bcs.s	fdone
	subi.b	#75,d0
	addq.w	#1,d2		;carry over to seconds
fdone:
	ror.l	#8,d5
	add.b	d5,d2		;add seconds
	cmpi.b	#60,d2
	bcs.s	sdone
	subi.b	#60,d2
	addq.w	#1,d1		;carry over to minutes
sdone:
	ror.l	#8,d5
	add.b	d5,d1
	swap	d5
	swap	d1
	lsl.w	#8,d2
	or.w	d2,d1
	or.b	d0,d1
;
;
	move.l	d1,(a2)+		;set time
	move.l	d6,(a2)+		;set pattern
	move.l	4(a0),(a2)+		;length (64-byte blocks)
;
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	bra	    raw2fin
raw2finx:
	move.l	a2,curfine

	lea	    curmsg,a0
	lea	    donmsg,a1
getdon:
	move.b	(a1)+,d0
	beq.s	nondon
	move.b	d0,(a0)+
	bra	    getdon
nondon:
	lea 	curmsg,a0		;"Done"
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
    BSR     L0086 
	bsr	    string
;
	move.l	nextrk,a0	;advance to next track
	addq.l	#8,a0
	move.l	a0,nextrk
	tst.l	8(a0)		;check if this is last track
	bne	    tracklp
;
;
;
;  Scroll down any previous data
;
;	lea	    image+((sessrow+18)*48*8),a0
;	lea	    image+((sessrow+19)*48*8),a1
;	move.w	#12*(8*10)-1,d0
;
	lea	    image+((sessrow+25)*48*8),a0
	lea	    image+((sessrow+26)*48*8),a1
	move.w	#12*(8*17)-1,d0

scrdwn1:
	move.l	-(a0),-(a1)
	dbra	d0,scrdwn1
;
;
;
	lea	    finehash,a0
	suba.l	a0,a2
	move.l	a2,d0
	divu	#28,d0
	move.w	d0,2(a0)	;save total partition's count
;
	moveq	#0,d0
	jsr	    CD_jeri		;turn off Jerry data
;
	lea	    rsamsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	    string
;
	move.w	#$200,$dfff0a
;
;>>	move.l	#2,MD5semi		;shut off DSP
    MOVE.L  #2,$F1B020              ; MD5semi

;
;  finish any RSA that needs doin..
;
	move.l	currsa,d0	;get start of next allowed finehash to RSA
	move.l	curfine,d1	;get start of last completed finehash
	sub.l	d0,d1		;any finehash ready for RSA?
	bcs.s	sRSAe		;br if not
;
	add.l	#63,d1
	andi.w	#~63,d1		;adjust byte count of span to integer blocks
	tst.l	d1
	beq.s	sRSAe		;br if nothing doing
;
;>>	lea	    RSAsemi,a0
    LEA     $F03774,A0      ; RSAsemi

;
	move.l	d1,d3
	lsr.l	#6,d3		;# of blocks for next calc
	add.l	d3,countRSA
;
waitR:
	move.l	(a0),d2		;check for busy RSA
	bmi     doneblk		;wait for previous to finish

	movem.l	a0/d0-d1,-(sp)
	bsr	    upcount		;put up count of blocks remaining
	movem.l	(sp)+,a0/d0-d1

	bra	    waitR

doneblk:
;
	move.l	d0,dramin
	add.l	d0,d1
	move.l	d1,dramine
	moveq	#0,d0
	move.l	d0,(a0)		;start up some more RSA
;
	move.l	d1,currsa	;here's where we start next time
sRSAe:
;
;
waitRx:
;>>	lea     RSAsemi,a0
    LEA     $F03774,A0      ; RSAsemi

	move.l	(a0),d2		;check for busy RSA
	bmi.s	onemore
;
	bsr	    upcount		;put up count of blocks remaining
;
	bra	    waitRx		;wait for previous to finish
onemore:
;
;  Now, lets do the first block that we had to wait all day for...
;
	move.l	dramout,a1	;save our last RSA buffer entry
	move.l	#finehash,dramin
	move.l	#finehash+$40,dramine
	move.l	#resultF,dramout
	moveq	#0,d1
	move.l	d1,(a0)		;do one more
;
waitRy:
	move.l	(a0),d2		;check for busy RSA
	bpl	    waitRy		;wait for previous to finish
;
	lea	    donemsg,a0
	lea	    curmsg,a1
donilp:
	move.b	(a0)+,(a1)+
	bne	    donilp
;
	move.l	MaxT,d0
	move.l	MinT,d1
	move.l	BlokT,d3
	move.l	SizeT,d4
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
	bsr	    stuffval
	
	lea	    curmsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
    bsr     Stringprepare
	bsr     Stringoutput        ; = string()
;
;
      LEA       A101D3A,a0      ; "\r\n" $803D3A,A0  , thi sis _NOT_ CRLF !!!
      BSR       L0086           ; Jump into Stringprepare
      BSR       L008B 
      LEA       G_RAM,A0
      MOVEQ     #0,D0 
      MOVE.W    #$3FF,D1
L0063:MOVE.L    D0,(A0)+
      DBF       D1,L0063

;             RRRRRBBBBBGGGGGG
;   move.w  #%0000001111000000,BG       ;blue
    move.w  #%0000000000011111,BG       ;green

    lea     linesofstars,a0
    moveq   #sessrow,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()
    lea     frameofstars,a0
    moveq   #sessrow+1,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()
    lea     frameofstars,a0
    moveq   #sessrow+2,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()
    lea     linesofstars,a0
    moveq   #sessrow+3,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()


    lea     transmitdatatext,a0
    moveq   #sessrow+1,d0
    moveq   #sesscol-4+1,d1
    bsr     Stringoutput        ; = string()
    lea     transmitdatatext2,a0
    moveq   #sessrow+2,d0
    moveq   #sesscol-4+1,d1
    bsr     Stringoutput        ; = string()


    jsr    uart_init

    lea    CRLF,a0
    jsr    uart_send    ;IN: a0 = pointer to message, terminated with NULL
    lea    transmitdatatext,a0
    jsr    uart_send
    lea    CRLF,a0
    jsr    uart_send
    lea    transmitdatatext2,a0
    jsr    uart_send
    lea    CRLF,a0
    jsr    uart_send


waitforfireA:
    move.l  joyedge,d0
    btst.l  #PAUSE,d0
    beq.s   waitforfireA


;             RRRRRBBBBBGGGGGG
;   move.w  #%0000001111000000,BG       ;blue
    move.w  #%0000000111001111,BG       ;dark cyan?


    lea     frameofstars,a0
    moveq   #sessrow+1,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()
    lea     frameofstars,a0
    moveq   #sessrow+2,d0
    moveq   #sesscol-4,d1
    bsr     Stringoutput        ; = string()

    lea    CRLF,a0
    jsr    uart_send
    lea     transmitting,a0
    moveq   #sessrow+1,d0
    moveq   #sesscol-4+1,d1
    bsr     Stringoutput        ; = string()


;##    jsr     DoXmodemUpload

; DO: Clear the additional $60 bytes after FileEND-buffer
;-- lea     FileEND+$60,a1
    lea     FileEND+$60,a1
    move.w  #$60/4-1,d0     
padloop:
    move.l  #0,(a1)+
    dbf     d0,padloop


    ;upload((char*)testdata, (char*)((char*)testdata)+f->size);  /* do xmodem-transfer */
    ; IN: a0 = startaddress
    ;     a1 = endaddress+1 (= startaddress + length?)
    lea     FileST,a0
;---lea     FileEND+$60,a1          ; transfer (FileST + resultF + FileEND) = $60 + $26160 + $60 = $26220
    lea     FileEND+$60+$60,a1      ; transfer (FileST + resultF + FileEND) = $60 + $26160 + $60 + $60 = $26280
    jsr     upload                  ; X-Modem wants to transfer $80 big packets

    lea    CRLF,a0
    jsr    uart_send
    lea    transmitfinished,a0
    jsr    uart_send
    lea    CRLF,a0
    jsr    uart_send


jumpback:
;>>   LEA       $71EAC,A0 
      LEA       FileST,A0 
      LEA       FileEND+$60,A1 

	illegal

;********************************************

;
cd_err0:
	lea	    cdermsg0,a0
	bra.s	errexit0	
cd_err1:
	lea	    cdermsg1,a0
;>>	bra.s	errexit0
errexit0:
      MOVE.L    A0,-(A7)
      MOVEQ     #4,D0 
      MOVEQ     #8,D1 
      BSR       Stringoutput            ; L0081 
      MOVEA.L   (A7)+,A0
      RTS 
	
seeker0:
	lea	    seekmsg0,a0
	bra.s	errexit	
seeker1:
	lea	    seekmsg1,a0
;  a0-> error message string
;
errexit:
	move.l	a0,-(sp)
	moveq	#sessrow+2,d0
	moveq	#sesscol,d1
	bsr	    string
	move.l	(sp)+,a0
;
	move.l	a0,a1
finde:
	tst.b	(a1)+
	bne	    finde
	subq.l	#1,a1	
      MOVE.B    #$D,(A1)+ 
      MOVE.B    #$A,(A1)+ 
      MOVE.L    A0,$9618
      MOVE.L    A1,$961C
;
	illegal
;
;
;
;  Display countRSA
;
upcount:
	move.l	countRSA,d0	;get counter of blocks
	andi.l	#$ffff,d0
	cmp.w	lastc,d0
	bne.s	upcountx
	rts
upcountx:
	move.w	d0,lastc	;save new value
;
	andi.l	#$ffff,d0
	lea 	statmsg,a6
	bsr	    dec10000
	addq.l	#1,a6
	clr.b	(a6)
;
	lea	    statmsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol+24,d1
	bsr	    string
	rts
;
;
;  Up to 65535
;
dec10000:
	move.l	d1,-(sp)
	moveq	#0,d1
	swap	d0
	tst.w	d0		;do we have overflo?
	bne.s	decmax
	swap	d0
	divu	#10000,d0
	tst.b	d0
	bne.s	decx0
	move.b	#" ",d0
	bra.s	decx1
decx0:
	moveq	#-1,d1
	addi.b	#"0",d0
decx1:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
	divu	#1000,d0
	tst.b	d0
	bne.s	decx6
      TST.L     D1
      BNE.S     decx6               ; L0070 
	move.b	#" ",d0
	bra.s	decx7
decx6:
	moveq	#-1,d1
	addi.b	#"0",d0
decx7:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
;
	divu	#100,d0
	tst.b	d0
	bne.s	decx2
	tst.l	d1
	bne.s	decx2
	move.b	#" ",d0
	bra.s	decx3
decx2:
	moveq	#-1,d1
	addi.b	#"0",d0
decx3:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
	divu	#10,d0
	tst.b	d0
	bne.s	decx4
	tst.l	d1
	bne.s	decx4
	move.b	#" ",d0
	bra.s	decx5
decx4:
	moveq	#-1,d1
	addi.b	#"0",d0
decx5:
	move.b	d0,(a6)+
	swap	d0
	addi.b	#"0",d0
	move.b	d0,(a6)

	move.l	(sp)+,d1
	rts
;
decmax:
	move.b	#" ",(a6)+
	move.b	#">",(a6)+
	move.b	#"6",(a6)+
	move.b	#"4",(a6)+
	move.b	#"k",(a6)
	move.l	(sp)+,d1
	rts
;
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
stuffval:
	lsr.l	#4,d0
	mulu	#100,d0
    addi.l  #64,d0
	lsr.l	#7,d0

	lea	    curmsg+29,a6	;start of "Max"
	bsr	    dec10000	;decimalize for up to 65535
;
    MOVE.L  D1,D0 
	lsr.l	#4,d0
	mulu	#100,d0
    addi.l  #64,d0
	lsr.l	#7,d0
;
	andi.l	#$ffff,d0
	lea	    curmsg+24,a6	;start of "Min"
	bsr	    dec10000
;
	move.w	d3,d0
	andi.l	#$ffff,d0
	lea	    curmsg+19,a6	;start of "Blok"
	bsr	    dec10000
;
	lea	    curmsg+35,a6	;start of "size"
	moveq	#7,d1
	moveq	#0,d2
sizelp:
	rol.l	#4,d4		;decode size
	moveq	#$f,d0
	and.w	d4,d0
	bne.s	siz
	tst.l	d2
	bne.s	siz
	tst.w	d1
	beq.s	siz
	move.b	#" ",(a6)+
	bra.s	siz1
siz:
	moveq	#-1,d2
	move.b	hextab(pc,d0.w),(a6)+
siz1:
	dbra	d1,sizelp
	bra.s	ovhexta
hextab:
	dc.b	"0123456789ABCDEF"
ovhexta:
	lea	    curmsg,a0	;now Analyzing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	    string
	rts
;
;
;-------------------------------------------------
;
; Entry:
;  d0.l = seek time (mm:ss:ff)
;
; Exit:
;  d0.l = 6 frames before seek time
;
backup6:
	andi.l	#$ffffff,d0	;strip track # off [31:24]
;
;	subq.b	#6,d0		;back up 6 frames
	subi.b	#9,d0		;back up 6 frames
	bcc.s	doseek

	addi.b	#75,d0		;adjust for frame underflo
	ror.l	#8,d0		;need to borrow from seconds
	subq.b	#1,d0		;subtract 1 from seconds
	bcc.s	doseek1
;
	addi.b	#60,d0		;adjust for seconds underflo
	ror.l	#8,d0		;need to borrow from minutes
	subq.b	#1,d0		;there better be minutes
	rol.l	#8,d0		; since we don't check min underflo
doseek1:
	rol.l	#8,d0
doseek:
	rts
;
;
;
Frame:
      MOVE.W    #$101,INT1
      MOVE.W    #0,INT2 
      MOVEM.L   A0-A1/D0,-(A7)
      LEA       dlistROM+$20,a0 ; $1012BE,A0   trashed part of original object list 
      LEA       dlist+$20,a1    ; $4020, A1    trashed part of object list copy
      MOVEQ     #3,D0 
L0080:MOVE.L    (A0)+,(A1)+ 
      DBF       D0,L0080

      bsr       readpad         ; DO reads only pad1!!!

      ADDQ.L    #1,fcount       ; $74D4.L  increase frame-counter
      MOVEM.L   (A7)+,A0-A1/D0
      RTE 
;
;
;  d0 - row (0-29)
;  d1 - col (0-47)
;  a0 -> string
;
Stringoutput:
string:
    movem.l a1-a4/d0-d3,-(sp)

	lea	    font,a1
	lea	    image.w,a2

	mulu	#8*48,d0
	adda.l	d0,a2
	adda.w	d1,a2	
	moveq	#0,d0
	move.w	#48,d1
	move.w	#256,d2
strlp:
	move.b	(a0)+,d0
	bne.s	strlp1
	movem.l	(sp)+,a1-a4/d0-d3
	rts
strlp1:
	lea	    (a1,d0.w),a3
	move.l	a2,a4
	moveq	#7,d3
strlp2:
	move.b	(a3),(a4)
	adda.w	d1,a4
	adda.w	d2,a3
	dbra	d3,strlp2
	addq.l	#1,a2
	bra	    strlp


Stringprepare:
L0085:MOVEM.L   A0-A1/D0-D1,-(A7) 
      MOVEQ     #3,D1 
      BRA.S     L0087 
L0086:MOVEM.L   A0-A1/D0-D1,-(A7) 
      MOVEQ     #1,D1 
L0087:MOVEA.L   A7614.L,A1
L0088:MOVE.B    (A0)+,(A1)+ 
      BNE.S     L0088 
      SUBQ.L    #1,A1 
      BRA.S     L008A 
L0089:MOVE.B    #$D,(A1)+ 
      MOVE.B    #$A,(A1)+ 
L008A:DBF       D1,L0089
      MOVE.L    A1,A7614.L
      MOVEM.L   (A7)+,A0-A1/D0-D1 
      RTS 


L008B:LEA       CDtoc,A0
      MOVEA.L   A7614.L,A1
      MOVEQ     #$F,D4
L008C:MOVEQ     #3,D1 
      BRA.S     L008E 
L008D:MOVE.B    #$20,(A1)+
L008E:MOVE.L    (A0)+,D0
      BEQ.S     L0090 
      MOVEQ     #7,D2 
L008F:ROL.L     #4,D0 
      MOVE.W    D0,D3 
      AND.W     D4,D3 
      MOVE.B    hextab2(pc,d3.w),(a1)+      ; L0091(PC,D3.W),(A1)+
      DBF       D2,L008F
      DBF       D1,L008D
      MOVE.B    #$D,(A1)+ 
      MOVE.B    #$A,(A1)+ 
      BRA.S     L008C 
L0090:MOVE.B    #$D,(A1)+ 
      MOVE.B    #$A,(A1)+ 
      MOVE.L    A1,A7614.L
      RTS 
L0091:
hextab2:
        dc.b    "0123456789ABCDEF"


;
;
;
;-------------------------------------------------
;	
;
;
;
; d0.l = accum
; d1.l = scratch1
; d2.l = scratch2
; d3.w = index (long aligned) in input buffer (mod 64)
; d4.w = index increment
; d5.w = rotate count index
; d6.w = species (0-futz, 2-grind, 4-hack, 6-ickify)
; 
; a0.l = a
; a1.l = b
; a2.l = cc
; a3.l = d
;
; a4.l = hash table ptr
; a5.l = input buffer ptr (64 bytes)
; a6.l = rotate count table ptr
;
;
;
;
MD5toc:
	lea	    initstate(pc),a4
	move.l	(a4)+,a0
	move.l	(a4)+,a1
	move.l	(a4)+,a2
	move.l	(a4)+,a3
;
;
	lea	    CDtoc,a5	;base addr of CDtoc
;
nextTblk:
	movem.l	a0-a3,-(sp)
;
	lea	    hashman(pc),a4	;64-long entry hash table

	lea	    rotater(pc),a6	;shift count table ptr
	moveq	#0,d5		;index for above
	moveq	#0,d6		;start with futz
nextspec:
	moveq	#15,d7		;iter 16 times for futz

	move.w	initx(pc,d6),d3	;get initial index into 64-byte input
	move.w	xinc(pc,d6),d4	;& get increment
specloop:
	move.w	spectab(pc,d6.w),d0
	jmp	    futz(pc,d0.w)
;
;
initx:
	dc.w	0	;initial index
	dc.w	4
	dc.w	20
	dc.w	0

xinc:
	dc.w	4	;index increment
	dc.w	20
	dc.w	12
	dc.w	28

spectab:
	dc.w	futz-futz
	dc.w	grind-futz	
	dc.w	hack-futz
	dc.w	ickify-futz
	
futz:
;    d0.l = (b & c) | (~b & d)
	move.l	a1,d0	;b -> accum
	move.l	a2,d1	;c -> scratch1
	and.l	d1,d0	;b&c -> accum
	move.l	a1,d1	;b -> scratch1
	move.l	a3,d2	;d -> scratch2
	not.l	d1	;~b
	and.l	d2,d1	;~b&d
	or.l	d1,d0	;OR into result
; end basic futz
	bra.s	endspec
;
;
grind:
;   d0.l = (b & d) | (c & ~d)
	move.l	a1,d0
	move.l	a3,d1
	and.l	d1,d0
	not.l	d1
	move.l	a2,d2
	and.l	d1,d2
	or.l	d2,d0
; end basic grind
	bra.s	endspec
;
hack:
;   d0.l = b ^ c ^ d
	move.l	a3,d0
	move.l	a1,d1
	eor.l	d1,d0
	move.l	a2,d1
	eor.l	d1,d0
; end basic hack
	bra.s	endspec
;
ickify:
;   d0.l = c ^ (b | ~d)
	move.l	a3,d0
	not.l	d0
	move.l	a1,d1
	or.l	d1,d0
	move.l	a2,d1
	eor.l	d1,d0
; end basic ickification

;
endspec:
	add.l	(a5,d3.w),d0	;add next input data entry
;
	add.w	d4,d3		;advance buffer index
	andi.w	#$3f,d3		; mod 64

	add.l	(a4)+,d0	;add next hash table entry
	add.l	a0,d0		;add a
;
	move.w	(a6,d5.w),d1	;get next shift count
	addq.w	#2,d5		;advance shift count index
	andi.w	#7,d5		; mod 8
;
	rol.l	d1,d0		;circular rotate left by count
	add.l	a1,d0		;add b
				;result d0.l is what we should store in a

;
	move.l	a3,a0		;d -> a
	move.l	a2,a3		;cc-> d
	move.l	a1,a2		;b -> cc
	move.l	d0,a1		;new a -> b

	dbra	d7,specloop	;do 16 of these
	addq.l	#8,a6
	addq.l	#2,d6
	cmp.w	#8,d6
	bcs	    nextspec
;
	adda.w	#64,a5
;
	movem.l	(sp)+,d0-d3
	add.l	d0,a0
	add.l	d1,a1
	add.l	d2,a2
	add.l	d3,a3
;
	cmp.l	#$3000,a5
	bcs	    nextTblk
;
	move.l	a0,d0
	move.l	a1,d1
	move.l	a2,d2
	move.l	a3,d3
	rts



;--------------------------------------------------------------------------
; Video System initalisieren
;--------------------------------------------------------------------------
VideoIni:
    move.w  CONFIG,d0   ; Also is joystick register
    andi.w  #$10,d0    ; 0 = PAL, 1 = NTSC
    beq     palvals

    move.w  #NTSC_HMID,d2
    move.w  #NTSC_WIDTH,d0
    move.w  #NTSC_VMID,d6
    move.w  #NTSC_HEIGHT,d4
    bra     calc_vals

palvals:
    move.w  #PAL_HMID,d2
    move.w  #PAL_WIDTH,d0
    move.w  #PAL_VMID,d6
    move.w  #PAL_HEIGHT,d4

calc_vals:
    move.w  d0,width
    move.w  d4,height
    move.w  d0,d1
    asr     #1,d1    ; Width/2
    sub.w   d1,d2    ; Mid - Width/2
    add.w   #4,d2    ; (Mid - Width/2)+4
    sub.w   #1,d1    ; Width/2 - 1
    ori.w   #$400,d1   ; (Width/2 - 1)|$400
    move.w  d1,a_hde
    move.w  d1,HDE
    move.w  d2,a_hdb
    move.w  d2,HDB1
    move.w  d2,HDB2
    move.w  d6,d5
    sub.w   d4,d5
    move.w  d5,a_vdb
    andi.w  #$FFFE,d5

    add.w   d4,d6
    move.w  d6,a_vde
    move.w  a_vdb,VDB
    move.w  #$FFFF,VDE
;    move.l  #0,BORD1   ; Black border
    move.l  #$000000ff,BORD1    ; Blue Border


    move.l  #0,BG    ; Line Buffer black
    rts



;-------------------------------------------------------------------------
; Interrupts initalisieren
;-------------------------------------------------------------------------
IntInit:
    move.l  #Frame,LEVEL0

    move.w  a_vde,d0
    ori.w   #1,d0
    move.w  d0,VI

    move.w  #1,INT1

    move.w  sr,d0
    andi.w  #$F8FF,d0
    move.w  d0,sr
    rts



;-------------------------------------------------------------------------
readpad:
    movem.l d0-d2,-(sp)
;scan for player 1
          move.l    #$f0fffffc,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$81fe,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81fd,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81fb,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #6,d0
          rol.l     #6,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81f7,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur,d0           ; old joycur needed for determining the new joyedge
          move.l    d1,joycur           ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge          ;joypad,buttons,keys that were just pressed

    movem.l (sp)+,d0-d2
          rts       



;######################################################################
;######################################################################
; .data
;
;
    .even
coeftab:
	dc.b $FF,$FF,$55,$55,$33,$33,$49,$49,$C7,$C7,$5D,$5D,$3B,$3B,$11,$11
	dc.b $0F,$0F,$E5,$E5,$C3,$C3,$59,$59,$D7,$D7,$ED,$ED,$CB,$CB,$21,$21
	dc.b $1F,$1F,$75,$75,$53,$53,$69,$69,$E7,$E7,$7D,$7D,$5B,$5B,$31,$31
	dc.b $2F,$2F,$05,$05,$E3,$E3,$79,$79,$F7,$F7,$0D,$0D,$EB,$EB,$41,$41
	dc.b $3F,$3F,$95,$95,$73,$73,$89,$89,$07,$07,$9D,$9D,$7B,$7B,$51,$51
	dc.b $4F,$4F,$25,$25,$03,$03,$99,$99,$17,$17,$2D,$2D,$0B,$0B,$61,$61
	dc.b $5F,$5F,$B5,$B5,$93,$93,$A9,$A9,$27,$27,$BD,$BD,$9B,$9B,$71,$71
	dc.b $6F,$6F,$45,$45,$23,$23,$B9,$B9,$37,$37,$4D,$4D,$2B,$2B,$81,$81
	dc.b $7F,$7F,$D5,$D5,$B3,$B3,$C9,$C9,$47,$47,$DD,$DD,$BB,$BB,$91,$91
	dc.b $8F,$8F,$65,$65,$43,$43,$D9,$D9,$57,$57,$6D,$6D,$4B,$4B,$A1,$A1
	dc.b $9F,$9F,$F5,$F5,$D3,$D3,$E9,$E9,$67,$67,$FD,$FD,$DB,$DB,$B1,$B1
	dc.b $AF,$AF,$85,$85,$63,$63,$F9,$F9,$77,$77,$8D,$8D,$6B,$6B,$C1,$C1
	dc.b $BF,$BF,$15,$15,$F3,$F3,$09,$09,$87,$87,$1D,$1D,$FB,$FB,$D1,$D1
	dc.b $CF,$CF,$A5,$A5,$83,$83,$19,$19,$97,$97,$AD,$AD,$8B,$8B,$E1,$E1
	dc.b $DF,$DF,$35,$35,$13,$13,$29,$29,$A7,$A7,$3D,$3D,$1B,$1B,$F1,$F1
	dc.b $EF,$EF,$C5,$C5,$A3,$A3,$39,$39,$B7,$B7,$CD,$CD,$AB,$AB,$01,$01
;	
;
;
    .even
priat:
	dc.b	0,0,0
;
;	.include	"PRIVATE.KEY"
	dc.b	0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

    .even
pubicK:
	dc.b	0,0,0
	.include	"PUBLICD.KEY"
;
;
;
;  Constant MD5 data goes here..
;
;  Init state
;
initstate:
	dc.l	$67452301
	dc.l	$EFCDAB89
	dc.l	$98BADCFE
	dc.l	$10325476
;
;
hashman:
;futz
          dc.l      $D76AA478
          dc.l      $E8C7B756
          dc.l      $242070DB
          dc.l      $C1BDCEEE
          dc.l      $F57C0FAF
          dc.l      $4787C62A
          dc.l      $A8304613
          dc.l      $FD469501
          dc.l      $698098D8
          dc.l      $8B44F7AF
          dc.l      $FFFF5BB1
          dc.l      $895CD7BE
          dc.l      $6B901122
          dc.l      $FD987193
          dc.l      $A679438E
          dc.l      $49B40821
;grind
          dc.l      $F61E2562
          dc.l      $C040B340
          dc.l      $265E5A51
          dc.l      $E9B6C7AA
          dc.l      $D62F105D
          dc.l      $02441453
          dc.l      $D8A1E681
          dc.l      $E7D3FBC8
          dc.l      $21E1CDE6
          dc.l      $C33707D6
          dc.l      $F4D50D87
          dc.l      $455A14ED
          dc.l      $A9E3E905
          dc.l      $FCEFA3F8
          dc.l      $676F02D9
          dc.l      $8D2A4C8A
;hack
          dc.l      $FFFA3942
          dc.l      $8771F681
          dc.l      $6D9D6122
          dc.l      $FDE5380C
          dc.l      $A4BEEA44
          dc.l      $4BDECFA9
          dc.l      $F6BB4B60
          dc.l      $BEBFBC70
          dc.l      $289B7EC6
          dc.l      $EAA127FA
          dc.l      $D4EF3085
          dc.l      $04881D05
          dc.l      $D9D4D039
          dc.l      $E6DB99E5
          dc.l      $1FA27CF8
          dc.l      $C4AC5665
;ickify
          dc.l      $F4292244
          dc.l      $432AFF97
          dc.l      $AB9423A7
          dc.l      $FC93A039
          dc.l      $655B59C3
          dc.l      $8F0CCC92
          dc.l      $FFEFF47D
          dc.l      $85845DD1
          dc.l      $6FA87E4F
          dc.l      $FE2CE6E0
          dc.l      $A3014314
          dc.l      $4E0811A1
          dc.l      $F7537E82
          dc.l      $BD3AF235
          dc.l      $2AD7D2BB
          dc.l      $EB86D391
;
;
; ROL counts for each op
rotater:
	dc.w	7
	dc.w	12
	dc.w	17
	dc.w	22

	dc.w	5
	dc.w	9
	dc.w	14
	dc.w	20

	dc.w	4
	dc.w	11
	dc.w	16
	dc.w	23

	dc.w	6
	dc.w	10
	dc.w	15
	dc.w	21
;
;  End MD5 constant data
;
;
;
;
;
;----------------------------------------------------------
;
;  Object type (Bits 0-2 in 1st 64-bit phrase of object)
; 
BMAPTYP		equ	0	;Bit-Map object
SCALTYP		equ	1	;Scaled Bit-Map object
GPUTYP		equ	2	;Graphics Processor interrupt Object
BRTYP		equ	3	;Branch Object
STOPTYP		equ	4	;Stop Object
;
;
;
;
;   Rom copy of the Object list
;
dlistROM:

OBJTYPE		set	BRTYP	;1st object is a BR object
BCC		set	1	;Br Condition Code (br if YPOS=<VC)
YPOS		set	21	;top branch object
	dc.w	0
	dc.l	(dlist+16) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
YPOS		set	519	;bottom branch object
	dc.w	0
	dc.l	(dlist+32) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
	dc.l	0,STOPTYP
	dc.l	0,STOPTYP
;
;
OBJTYPE		set	BMAPTYP	;1st object is a Scaled Bit-Map object
HEIGHT		set	240*2	;fill the screen
YPOS		set	41	;from the top
XPOS		set	30	;from the left edge
FIRSTPIX	set	0	;no left edge clipping
RELEASE		set	0	;release bus between image data fetches
TRANSPAR	set	0	;make logical color 0 transparent
RMW		set	0	;no read-modify-write
REFLECT		set	0	;no horizontal reflect
INDEX		set	0	;palette offset if 1-4 bits/pix
IWIDTH		set	6	;12 phrases in displayed image
DWIDTH		set	6	;12 phrases in source form
PITCH		set	1	;increment by 1 phrase for next fetch
DEPTH		set	0	;1 bits/pixel (2 color)
;
;  1st Object is a vanilla Bit-map, so it needs a 2 phrase header
;
;  1st phrase
 dc.l	(image << 8) + ((dlist+48) >> 11)
 dc.l	((dlist+48) << 21) + (HEIGHT << 13) + (YPOS << 3) + OBJTYPE 
;
;  2nd phrase
 dc.w (FIRSTPIX << 1) + RELEASE
 dc.w (TRANSPAR << 15) + (RMW << 14) + (REFLECT <<13) + (INDEX << 6) + (IWIDTH >> 4)
 dc.w ((IWIDTH & $0F) << 12) + (DWIDTH << 2) + (PITCH & $06)
 dc.w ((PITCH & 1) << 15) + (DEPTH << 12) + XPOS
;
 dc.l	0,STOPTYP,0,STOPTYP
;
;
font:
	.nlist
	include	"font8x8.s"
	.list
;
signon:
	.dc.b	"*** CD Encryption Utility V. 1.6 ***",0
signon2:
    .dc.b   "*Modified for BJL by Matthias Domin*",0

getpriv:
	dc.b	"Insert Private Key Disk in A:...    ",0
getcdtoc:
	dc.b	"Reading Submit CD's Directory...    ",0

badisc:
	dc.b	"Unrecognized or Missing Disc        ",0
;		 01234567890123456789012345678901234567
cdermsg0:
    ;dc.b   "CD error detected during 1st pass...",0
    dc.b    "CD error 1st pass retry #1...",0
                                                    
cdermsg1:
	;dc.b	"CD error detected during 2nd pass...",0
    dc.b    "CD error 2nd pass retry #1...",0

seekmsg0:
	dc.b	"Seek error detected during 1st pass.",0
seekmsg1:
	dc.b	"Seek error detected during 2nd pass.",0
statm:
	dc.b	"Encrypt Trks:00-00, Total CDtime 00:00",0
trknot:
	dc.b	"    CD not properly formatted...    ",0
;
;
;
headmsg:
	;dc.b	"Activity Trk  Mark  Blok  Min  Max    Size  ",0
    dc.b    "Activity Trk  Mark  Blok Min% Max%    Size  ",0

;            0123456789012345678901234567890123456789A  
headmsg1:
	dc.b	"-------- ---  ----  ---- ---- ----    ----  ",0
scanmsg:
	dc.b	"Scanning                                    ",0
analmsg:
	dc.b	"Analyzin ",0
md5msg:
	dc.b	" MD5'ing ",0
donmsg:
	dc.b	"  <done> ",0

;
donemsg:
	;dc.b	">>All Done,Totals:                         ",0
    dc.b    ">>All Done,Totals:                          ",0

rsamsg:
	;dc.b	"Finishing RSA computation...      Blks Left",0
    dc.b    "Finishing RSA computation...      Blks Left ",0
A101D3A:
    dc.b    "\r\n"

A101D3C:
    dcb.b 46,"-"
    dc.b    "\r\n\r\nCD Directory:\r\n",0


;
starmsg:
	dc.b	"*",0
;

CRLF:
    dc.b    "\r\n",0

    .even

linesofstars:
;            01234567890123456789012345678901234567890123  
    dc.b    "********************************************",0
frameofstars:
    dc.b    "*                                          *",0

transmitdatatext:
    dc.b    "Prepare X-modem transmission 115200-8-N-1",0
transmitdatatext2:
    dc.b    "Press PAUSE to receive the data!",0

transmitting:
    dc.b    "Transmitting, transmitting, ....",0

transmitfinished:
    dc.b    "Transmission finished!",0

    .even
joyedge: DC.l 0,0    ; Which button has changed compared to the last read?

; joycur:  DC.l 0,0  ; current button-state, already 4 bytes in BSS allocated!


    .even
ENMD5_S: 
      DC.B      $98,$00,$B2,$E6,$00,$F1 
      DC.B      $D0,$00,$E4,$00,$E4,$00,$E4,$00 
      DC.B      $E4,$00,$98,$1E,$B3,$66,$00,$F1 
      DC.B      $D3,$C0,$E4,$00,$E4,$00,$E4,$00 
      DC.B      $E4,$00,$FF,$FF,$FF,$FF,$00,$00 
;      DS.W      5,0 
    DCB.W   5,0
      DC.B      $98,$1F,$D0,$00,$00,$F1,$98,$1D 
      DC.B      $A1,$00,$00,$F1,$98,$1C,$A1,$48 
      DC.B      $00,$F1,$98,$1B,$A1,$4C,$00,$F1 
      DC.B      $98,$1A,$B6,$00,$00,$F1,$98,$19 
      DC.B      $FF,$00,$FF,$FF,$98,$18,$A1,$18 
      DC.B      $00,$F1,$BF,$19,$8C,$19,$8C,$18 
      DC.B      $8C,$17,$98,$16,$B3,$98,$98,$1E 
      DC.B      $98,$15,$B0,$10,$00,$F1,$98,$14 
      DC.B      $80,$00,$00,$00,$8C,$13,$8C,$12 
      DC.B      $98,$0A,$FF,$C0,$FF,$FF,$93,$BD 
      DC.B      $A7,$A0,$39,$C0,$38,$A0,$38,$80 
      DC.B      $BF,$A0,$E4,$00,$E4,$00,$8C,$0D 
      DC.B      $98,$15,$B5,$90,$00,$F1,$98,$07 
      DC.B      $B4,$60,$00,$F1,$88,$E8,$8C,$02 
      DC.B      $90,$49,$38,$C2,$38,$E2,$98,$17 
      DC.B      $B6,$00,$00,$F1,$92,$FA,$8F,$EB 
      DC.B      $89,$76,$02,$D6,$8C,$10,$92,$17 
      DC.B      $98,$10,$23,$01,$67,$45,$98,$11 
      DC.B      $AB,$89,$EF,$CD,$98,$12,$DC,$FE 
      DC.B      $98,$BA,$98,$13,$54,$76,$10,$32 
      DC.B      $92,$06,$92,$27,$92,$48,$92,$69 
      DC.B      $98,$18,$B1,$B8,$00,$F1,$98,$14 
      DC.B      $B1,$98,$00,$F1,$8C,$00,$98,$09 
      DC.B      $B0,$20,$00,$F1,$30,$00,$BD,$20 
      DC.B      $08,$89,$BD,$2D,$18,$89,$A5,$20 
      DC.B      $28,$00,$D7,$B8,$E4,$00,$0C,$89 
      DC.B      $A5,$2D,$D4,$C2,$E4,$00,$98,$01 
      DC.B      $B3,$02,$00,$F1,$D0,$20,$E4,$00 
      DC.B      $08,$89,$A5,$2A,$08,$89,$A5,$23 
      DC.B      $98,$0D,$B8,$00,$00,$F1,$8C,$24 
      DC.B      $8C,$81,$A5,$40,$08,$8A,$28,$00 
      DC.B      $D4,$81,$7C,$81,$D4,$41,$E4,$00 
      DC.B      $8C,$04,$18,$21,$BD,$A0,$D6,$A1 
      DC.B      $08,$8D,$28,$84,$D6,$41,$8C,$81 
      DC.B      $98,$0D,$B8,$00,$00,$F1,$89,$AA 
      DC.B      $A5,$41,$08,$8A,$A5,$40,$88,$0F 
      DC.B      $63,$40,$08,$8A,$90,$18,$A5,$40 
      DC.B      $90,$12,$09,$0A,$98,$01,$52,$49 
      DC.B      $41,$54,$90,$2A,$98,$00,$B7,$00 
      DC.B      $00,$F1,$90,$14,$A5,$41,$0C,$8A 
      DC.B      $28,$21,$90,$2E,$D4,$42,$8C,$01 
      DC.B      $A5,$41,$90,$2F,$63,$41,$08,$8A 
      DC.B      $BC,$01,$08,$80,$A5,$41,$BC,$01 
      DC.B      $08,$80,$09,$0A,$90,$10,$98,$00 
      DC.B      $B3,$98,$98,$1E,$90,$16,$90,$79 
      DC.B      $8C,$03,$8A,$EE,$38,$C3,$00,$77 
      DC.B      $8A,$1A,$3D,$17,$89,$C0,$24,$40 
      DC.B      $8A,$3B,$8A,$5C,$8A,$7D,$97,$43 
      DC.B      $24,$43,$78,$03,$D7,$A2,$97,$43 
      DC.B      $A5,$06,$08,$88,$A5,$04,$08,$88 
      DC.B      $88,$83,$25,$63,$76,$04,$25,$64 
      DC.B      $A5,$05,$08,$88,$D0,$C0,$8E,$09 
      DC.B      $8B,$60,$8B,$61,$27,$80,$30,$01 
      DC.B      $D4,$C0,$27,$A1,$8B,$A0,$8B,$A1 
      DC.B      $27,$60,$30,$01,$27,$81,$D5,$20 
      DC.B      $28,$20,$8B,$A0,$2F,$60,$D4,$A0 
      DC.B      $2F,$80,$8B,$A0,$30,$00,$2B,$60 
      DC.B      $2F,$80,$E8,$61,$00,$83,$00,$20 
      DC.B      $A5,$01,$26,$C3,$00,$20,$08,$88 
      DC.B      $03,$40,$88,$AC,$75,$05,$25,$6C 
      DC.B      $71,$80,$03,$60,$18,$29,$8B,$BA 
      DC.B      $8B,$9D,$8B,$7C,$D0,$C1,$88,$1B 
      DC.B      $79,$15,$D3,$01,$E4,$00,$03,$50 
      DC.B      $03,$71,$7C,$4F,$D5,$41,$03,$92 
      DC.B      $A5,$40,$08,$8A,$90,$03,$A5,$40 
      DC.B      $08,$8A,$90,$04,$A5,$40,$09,$0A 
      DC.B      $90,$05,$18,$2F,$88,$E8,$D2,$81 
      DC.B      $03,$B3,$BD,$B0,$08,$8D,$BD,$B1 
      DC.B      $08,$8D,$BD,$B2,$08,$8D,$BD,$B3 
      DC.B      $95,$EF,$29,$EF,$D4,$C1,$08,$8D 
      DC.B      $98,$00,$B2,$9E,$00,$F1,$D0,$00 
      DC.B      $E4,$00,$96,$03,$95,$C1,$28,$21 
      DC.B      $D4,$81,$8C,$01,$BC,$61,$D4,$80 
      DC.B      $FC,$83,$94,$60,$90,$0E,$94,$81 
      DC.B      $95,$EF,$90,$2F,$63,$41,$BC,$61 
      DC.B      $FC,$83,$94,$A1,$BC,$61,$FC,$83 
      DC.B      $90,$70,$94,$D0,$94,$F1,$95,$12 
      DC.B      $95,$33,$D2,$80,$88,$E8,$98,$00 
      DC.B      $B0,$24,$00,$F1,$A4,$0A,$98,$00 
      DC.B      $B8,$00,$00,$F1,$A4,$03,$08,$80 
      DC.B      $BD,$43,$79,$A0,$D7,$68,$08,$8A 
      DC.B      $98,$00,$B0,$90,$00,$F1,$D0,$00 
      DC.B      $E4,$00,$98,$1D,$A1,$00,$00,$F1 
      DC.B      $A7,$BE,$3C,$BE,$3C,$9E,$3D,$DE 
      DC.B      $BF,$BE,$E4,$00,$E4,$00,$E4,$00 
      DC.B      $98,$1D,$A1,$14,$00,$F1,$8C,$1E 
      DC.B      $BF,$BE,$D7,$C0,$E4,$00,$A7,$BE 
      DC.B      $3C,$7E,$98,$1C,$B2,$C2,$00,$F1 
      DC.B      $39,$3E,$08,$9F,$D3,$80,$BF,$BE 
      DC.B      $98,$1D,$B2,$C2,$00,$F1,$D3,$A0 
      DC.B      $E4,$00,$7C,$40,$D7,$22,$E4,$00 
      DC.B      $98,$00,$C0,$00,$00,$F1,$90,$1A 
      DC.B      $88,$14,$98,$00,$B3,$DA,$98,$1E 
      DC.B      $90,$16,$98,$00,$B4,$3A,$00,$F1 
      DC.B      $90,$10,$98,$00,$52,$49,$41,$54 
      DC.B      $90,$19,$98,$03,$B3,$30,$00,$F1 
      DC.B      $97,$40,$7A,$80,$D7,$C2,$97,$40 
      DC.B      $A6,$81,$BD,$A1,$FC,$94,$08,$8D 
      DC.B      $A6,$81,$BD,$A1,$FC,$94,$08,$8D 
      DC.B      $A6,$81,$BD,$A1,$FD,$14,$08,$8D 
      DC.B      $8C,$01,$BD,$A1,$97,$21,$28,$21 
      DC.B      $D0,$61,$08,$8D,$98,$00,$B0,$90 
      DC.B      $00,$F1,$D0,$00,$E4,$00,$A7,$BE 
      DC.B      $A7,$8C,$A7,$6D,$62,$0C,$62,$0D 
      DC.B      $66,$0C,$2B,$39,$D5,$42,$29,$AC 
      DC.B      $79,$99,$D4,$C1,$E4,$00,$18,$37 
      DC.B      $D4,$81,$2A,$F7,$BE,$B6,$8C,$13 
      DC.B      $8E,$17,$3C,$7E,$A7,$F1,$39,$5E 
      DC.B      $08,$51,$08,$9F,$D2,$20,$BF,$BE 
      DC.B      $A7,$BE,$A7,$8C,$A7,$6D,$62,$0C 
      DC.B      $62,$0D,$66,$0C,$7A,$53,$D5,$88 
      DC.B      $08,$93,$29,$AC,$18,$98,$BF,$4C 
      DC.B      $D4,$E1,$FC,$9A,$A6,$98,$FC,$94 
      DC.B      $2B,$18,$A6,$92,$D5,$02,$FC,$94 
      DC.B      $3C,$7E,$A7,$F1,$39,$5E,$08,$51 
      DC.B      $08,$9F,$D2,$20,$BF,$BE,$98,$16 
      DC.B      $B3,$66,$98,$1E,$BE,$B6,$D6,$80 
      DC.B      $8C,$19,$A7,$BE,$A7,$8C,$A7,$6D 
      DC.B      $62,$0C,$62,$0D,$66,$0C,$08,$93 
      DC.B      $29,$AC,$7B,$0C,$D5,$C1,$7B,$19 
      DC.B      $D4,$41,$0C,$37,$D2,$00,$3C,$7E 
      DC.B      $A7,$F1,$39,$5E,$08,$51,$08,$9F 
      DC.B      $D2,$20,$BF,$BE,$89,$98,$D6,$E0 
      DC.B      $8C,$17,$7D,$F7,$D7,$68,$8A,$71 
      DC.B      $2B,$18,$D7,$02,$18,$91,$08,$37 
      DC.B      $BF,$57,$FC,$9A,$63,$D7,$BF,$58 
      DC.B      $12,$F1,$FC,$9A,$BF,$51,$FD,$1A 
      DC.B      $89,$98,$8C,$17,$3C,$7E,$A7,$F1 
      DC.B      $39,$5E,$08,$51,$08,$9F,$D2,$20 
      DC.B      $BF,$BE,$7D,$F7,$D5,$48,$E4,$00 
      DC.B      $98,$0F,$B3,$66,$98,$1E,$BE,$AF 
      DC.B      $98,$0E,$B4,$0E,$00,$F1,$D1,$C0 
      DC.B      $8C,$19,$A7,$F1,$39,$5E,$08,$51 
      DC.B      $08,$9F,$D2,$20,$BF,$BE,$00,$00 
      DC.B      $00,$F1,$B1,$D0,$00,$04,$00,$00 
      DC.B      $0A,$0F,$14,$19,$D7,$6A,$A4,$78 
      DC.B      $E8,$C7,$B7,$56,$24,$20,$70,$DB 
      DC.B      $C1,$BD,$CE,$EE,$F5,$7C,$0F,$AF 
      DC.B      $47,$87,$C6,$2A,$A8,$30,$46,$13 
      DC.B      $FD,$46,$95,$01,$69,$80,$98,$D8 
      DC.B      $8B,$44,$F7,$AF,$FF,$FF,$5B,$B1 
      DC.B      $89,$5C,$D7,$BE,$6B,$90,$11,$22 
      DC.B      $FD,$98,$71,$93,$A6,$79,$43,$8E 
      DC.B      $49,$B4,$08,$21,$00,$F1,$B1,$DC 
      DC.B      $00,$14,$00,$04,$0C,$12,$17,$1B 
      DC.B      $F6,$1E,$25,$62,$C0,$40,$B3,$40 
      DC.B      $26,$5E,$5A,$51,$E9,$B6,$C7,$AA 
      DC.B      $D6,$2F,$10,$5D,$02,$44,$14,$53 
      DC.B      $D8,$A1,$E6,$81,$E7,$D3,$FB,$C8 
      DC.B      $21,$E1,$CD,$E6,$C3,$37,$07,$D6 
      DC.B      $F4,$D5,$0D,$87,$45,$5A,$14,$ED 
      DC.B      $A9,$E3,$E9,$05,$FC,$EF,$A3,$F8 
      DC.B      $67,$6F,$02,$D9,$8D,$2A,$4C,$8A 
      DC.B      $00,$F1,$B1,$EA,$00,$0C,$00,$14 
      DC.B      $09,$10,$15,$1C,$FF,$FA,$39,$42 
      DC.B      $87,$71,$F6,$81,$6D,$9D,$61,$22 
      DC.B      $FD,$E5,$38,$0C,$A4,$BE,$EA,$44 
      DC.B      $4B,$DE,$CF,$A9,$F6,$BB,$4B,$60 
      DC.B      $BE,$BF,$BC,$70,$28,$9B,$7E,$C6 
      DC.B      $EA,$A1,$27,$FA,$D4,$EF,$30,$85 
      DC.B      $04,$88,$1D,$05,$D9,$D4,$D0,$39 
      DC.B      $E6,$DB,$99,$E5,$1F,$A2,$7C,$F8 
      DC.B      $C4,$AC,$56,$65,$00,$F1,$B1,$F2 
      DC.B      $00,$1C,$00,$00,$0B,$11,$16,$1A 
      DC.B      $F4,$29,$22,$44,$43,$2A,$FF,$97 
      DC.B      $AB,$94,$23,$A7,$FC,$93,$A0,$39 
      DC.B      $65,$5B,$59,$C3,$8F,$0C,$CC,$92 
      DC.B      $FF,$EF,$F4,$7D,$85,$84,$5D,$D1 
      DC.B      $6F,$A8,$7E,$4F,$FE,$2C,$E6,$E0 
      DC.B      $A3,$01,$43,$14,$4E,$08,$11,$A1 
      DC.B      $F7,$53,$7E,$82,$BD,$3A,$F2,$35 
      DC.B      $2A,$D7,$D2,$BB,$EB,$86,$D3,$91 
ENMD5_E:

    .even
ENRSA_S:
      DC.B      $98,$1E,$21,$00,$00,$F0,$93,$DE
      DC.B      $A7,$CD,$39,$CD,$BF,$CD,$E4,$00 
      DC.B      $E4,$00,$98,$14,$38,$3A,$00,$F0 
      DC.B      $98,$13,$38,$46,$00,$F0,$8C,$12 
      DC.B      $98,$17,$00,$00,$FF,$FF,$8A,$F6 
      DC.B      $30,$16,$98,$0E,$31,$EC,$00,$F0 
      DC.B      $98,$1B,$00,$44,$00,$00,$98,$19 
      DC.B      $34,$14,$00,$F0,$A7,$CD,$3D,$CD 
      DC.B      $BF,$CD,$E4,$00,$E4,$00,$98,$00 
      DC.B      $00,$44,$00,$00,$98,$02,$30,$00 
      DC.B      $00,$F0,$98,$01,$30,$44,$00,$F0 
      DC.B      $98,$04,$30,$88,$00,$F0,$98,$03 
      DC.B      $30,$CC,$00,$F0,$98,$05,$31,$20 
      DC.B      $00,$F0,$98,$10,$31,$14,$00,$F0 
      DC.B      $A6,$1A,$98,$11,$31,$10,$00,$F0 
      DC.B      $09,$10,$A6,$3C,$A6,$1B,$98,$10 
      DC.B      $35,$1C,$00,$F0,$98,$11,$31,$0C 
      DC.B      $00,$F0,$98,$12,$00,$FF,$00,$00 
      DC.B      $8C,$93,$A6,$34,$8A,$95,$75,$14 
      DC.B      $26,$55,$18,$33,$1C,$90,$D7,$41 
      DC.B      $BE,$15,$7A,$23,$D6,$A8,$18,$91 
      DC.B      $98,$16,$37,$74,$00,$F0,$8C,$12 
      DC.B      $30,$12,$BE,$D2,$A6,$D7,$2A,$F7 
      DC.B      $D7,$B8,$E4,$00,$D5,$22,$E4,$00 
      DC.B      $98,$00,$21,$14,$00,$F0,$8C,$01 
      DC.B      $E4,$00,$BC,$01,$D7,$A0,$E4,$00 
      DC.B      $98,$16,$31,$14,$00,$F0,$A6,$DA 
      DC.B      $09,$16,$A6,$DB,$8C,$12,$8C,$14 
      DC.B      $88,$31,$08,$81,$00,$11,$8C,$16 
      DC.B      $8C,$97,$9F,$52,$08,$3A,$8A,$55 
      DC.B      $65,$16,$12,$92,$8A,$B4,$61,$12 
      DC.B      $18,$37,$D6,$E1,$2A,$56,$18,$91 
      DC.B      $7A,$21,$D6,$28,$BE,$36,$18,$81 
      DC.B      $8E,$B1,$BC,$31,$88,$6C,$88,$2D 
      DC.B      $88,$AE,$98,$0B,$37,$78,$00,$F0 
      DC.B      $CC,$06,$D1,$60,$08,$C6,$88,$10 
      DC.B      $98,$11,$31,$A8,$00,$F0,$8C,$12 
      DC.B      $8A,$2D,$8A,$2E,$8A,$28,$18,$90 
      DC.B      $BE,$32,$18,$90,$D7,$A1,$0C,$91 
      DC.B      $8C,$32,$BE,$32,$98,$0B,$37,$78 
      DC.B      $00,$F0,$CC,$06,$D1,$60,$08,$C6 
      DC.B      $98,$15,$02,$08,$00,$00,$8C,$11 
      DC.B      $39,$11,$88,$92,$98,$14,$36,$76 
      DC.B      $00,$F0,$89,$0D,$89,$0E,$89,$0F 
      DC.B      $98,$0B,$38,$12,$00,$F0,$CC,$06 
      DC.B      $D1,$60,$08,$C6,$74,$31,$D4,$54 
      DC.B      $E4,$00,$08,$92,$A6,$53,$26,$33 
      DC.B      $D5,$42,$E4,$00,$88,$AD,$89,$0E 
      DC.B      $89,$0F,$98,$0B,$38,$12,$00,$F0 
      DC.B      $CC,$06,$D1,$60,$08,$C6,$18,$35 
      DC.B      $D2,$81,$E4,$00,$88,$10,$8C,$12 
      DC.B      $98,$11,$31,$64,$00,$F0,$8A,$2D 
      DC.B      $18,$90,$BE,$32,$18,$90,$D7,$A1 
      DC.B      $0C,$91,$8C,$32,$BE,$32,$98,$0E 
      DC.B      $31,$A8,$00,$F0,$88,$2F,$98,$0B 
      DC.B      $38,$12,$00,$F0,$CC,$06,$D1,$60 
      DC.B      $08,$C6,$88,$30,$88,$71,$88,$52 
      DC.B      $8C,$16,$A6,$13,$A6,$34,$00,$11 
      DC.B      $00,$12,$7A,$93,$D5,$E8,$00,$10 
      DC.B      $1C,$90,$1C,$91,$A6,$13,$A6,$34 
      DC.B      $6C,$36,$16,$93,$06,$D6,$18,$92 
      DC.B      $7A,$23,$D6,$C8,$BE,$53,$2A,$D6 
      DC.B      $D4,$61,$88,$30,$D4,$60,$18,$90 
      DC.B      $00,$10,$18,$90,$98,$13,$00,$3F 
      DC.B      $00,$00,$A6,$14,$B7,$74,$65,$14 
      DC.B      $18,$33,$0C,$3B,$D4,$D8,$34,$13 
      DC.B      $D7,$22,$34,$33,$D6,$E2,$E4,$00 
      DC.B      $D6,$80,$18,$90,$A6,$14,$B7,$74 
      DC.B      $08,$3B,$98,$16,$74,$C0,$00,$00 
      DC.B      $A6,$D5,$18,$35,$BE,$D5,$98,$10 
      DC.B      $31,$18,$00,$F0,$A6,$11,$7A,$3A 
      DC.B      $D4,$C4,$E4,$00,$98,$12,$35,$F8 
      DC.B      $00,$F0,$D2,$40,$E4,$00,$18,$90 
      DC.B      $BE,$1A,$09,$10,$BE,$1B,$98,$12 
      DC.B      $35,$C4,$00,$F0,$D2,$40,$E4,$00 
;      DS.W      2,0 
    DCB.W   2,0
      DC.B      $88,$10,$89,$B1,$89,$D2,$A6,$33 
      DC.B      $BE,$53,$18,$90,$0C,$91,$D7,$61 
      DC.B      $08,$92,$98,$18,$02,$09,$00,$00 
      DC.B      $18,$92,$98,$19,$37,$98,$00,$F0 
      DC.B      $18,$38,$D0,$C2,$88,$10,$8A,$51 
      DC.B      $8C,$14,$A6,$33,$6C,$34,$06,$73 
      DC.B      $06,$94,$7A,$2E,$BE,$33,$D7,$28 
      DC.B      $1C,$91,$A5,$94,$7A,$93,$D3,$28 
      DC.B      $89,$95,$D5,$C2,$00,$15,$8A,$51 
      DC.B      $8C,$14,$1C,$95,$A6,$33,$A6,$B0 
      DC.B      $6C,$34,$16,$13,$06,$94,$7A,$2E 
      DC.B      $BE,$33,$D6,$E8,$1C,$91,$D3,$20 
      DC.B      $8C,$14,$8A,$51,$8C,$14,$98,$16 
      DC.B      $31,$A8,$00,$F0,$1C,$95,$A6,$33 
      DC.B      $1C,$96,$A6,$B0,$6C,$34,$16,$13 
      DC.B      $06,$94,$7A,$2E,$BE,$D3,$D6,$C8 
      DC.B      $1C,$91,$2A,$94,$D3,$21,$08,$91 
      DC.B      $88,$14,$A6,$D3,$0C,$96,$BE,$33 
      DC.B      $18,$94,$D7,$61,$0C,$91,$D3,$20 
      DC.B      $E4,$00,$A7,$D0,$39,$D0,$BF,$D0 
      DC.B      $E4,$00,$E4,$00,$95,$C3,$95,$A6 
      DC.B      $88,$64,$88,$C7,$03,$64,$03,$67 
      DC.B      $8B,$6D,$89,$CC,$6C,$2D,$88,$E8 
      DC.B      $18,$2D,$BD,$92,$0C,$8C,$D7,$A1 
      DC.B      $18,$2D,$18,$84,$89,$8B,$A4,$85 
      DC.B      $18,$8C,$88,$A1,$76,$01,$18,$88 
      DC.B      $A5,$09,$89,$2A,$89,$2D,$76,$0A 
      DC.B      $40,$AD,$89,$50,$40,$29,$40,$B0 
      DC.B      $40,$2A,$02,$09,$8C,$10,$06,$10 
      DC.B      $76,$09,$76,$10,$89,$31,$26,$D1 
      DC.B      $26,$E9,$2A,$30,$18,$8B,$01,$2D 
      DC.B      $A5,$69,$05,$50,$01,$A9,$89,$6A 
      DC.B      $BD,$69,$1C,$8A,$A5,$4D,$06,$0D 
      DC.B      $D4,$C4,$BD,$4D,$1C,$8A,$A5,$4D 
      DC.B      $06,$4D,$D7,$88,$BD,$4D,$79,$06 
      DC.B      $D2,$61,$78,$83,$88,$E8,$D2,$81 
      DC.B      $E4,$00,$98,$0B,$33,$FC,$00,$F0 
      DC.B      $98,$0C,$32,$70,$00,$F0,$89,$63 
      DC.B      $98,$15,$00,$FF,$00,$00,$8C,$8D 
      DC.B      $A5,$90,$8A,$11,$75,$10,$26,$B1 
      DC.B      $18,$2D,$1C,$83,$D7,$41,$BC,$71 
      DC.B      $79,$8E,$D6,$A8,$18,$8C,$98,$08 
      DC.B      $35,$1C,$00,$F0,$95,$EC,$89,$82 
      DC.B      $03,$6C,$08,$82,$97,$89,$98,$01 
      DC.B      $38,$DE,$00,$F0,$8C,$98,$89,$64 
      DC.B      $65,$1A,$18,$8B,$A5,$6D,$8C,$10 
      DC.B      $41,$2D,$89,$07,$26,$AD,$18,$87 
      DC.B      $A4,$F1,$18,$87,$41,$B1,$18,$84 
      DC.B      $A4,$8A,$02,$30,$01,$50,$8A,$11 
      DC.B      $26,$B1,$65,$10,$BC,$91,$78,$F9 
      DC.B      $D6,$68,$26,$B0,$61,$10,$18,$38 
      DC.B      $D0,$21,$2A,$1A,$18,$8C,$BD,$9A 
      DC.B      $79,$82,$D0,$28,$8C,$98,$95,$F0 
      DC.B      $18,$78,$78,$50,$D0,$21,$8A,$02 
      DC.B      $67,$1A,$BD,$9A,$08,$90,$03,$62 
      DC.B      $8C,$98,$8C,$11,$18,$8B,$A5,$6D 
      DC.B      $29,$B1,$18,$38,$D7,$61,$75,$11 
      DC.B      $18,$82,$A4,$4D,$6C,$32,$06,$2D 
      DC.B      $06,$52,$78,$50,$D6,$28,$BC,$4D 
      DC.B      $8C,$58,$8C,$11,$18,$8B,$A5,$6D 
      DC.B      $29,$B1,$18,$38,$D7,$61,$75,$11 
      DC.B      $66,$11,$18,$82,$A4,$4D,$6C,$32 
      DC.B      $06,$2D,$BC,$4D,$A7,$D0,$3D,$D0 
      DC.B      $BF,$D0,$E4,$00,$E4,$00,$D0,$C0 
      DC.B      $E4,$00
ENRSA_E:

      dc.b      $00,$00

    .even
GETTOC_S:
DSP_S:
      DC.B      $98,$00,$B0,$20 
      DC.B      $00,$F1,$D0,$00,$E4,$00,$E4,$00 
      DC.B      $E4,$00,$E4,$00,$98,$1D,$B2,$5C 
      DC.B      $00,$F1,$D3,$A0,$E4,$00,$E4,$00 
      DC.B      $E4,$00,$E4,$00,$98,$00,$FF,$00 
      DC.B      $00,$DF,$8D,$41,$00,$01,$8C,$82 
      DC.B      $00,$02,$98,$0D,$00,$FF,$00,$00 
      DC.B      $98,$14,$B3,$28,$00,$F1,$8C,$15 
      DC.B      $98,$16,$01,$00,$00,$00,$BE,$95 
      DC.B      $18,$36,$D7,$A1,$08,$94,$8C,$0C 
      DC.B      $89,$8B,$30,$0B,$8C,$09,$98,$14 
      DC.B      $03,$00,$00,$00,$8F,$F8,$08,$38 
      DC.B      $98,$1D,$B2,$92,$00,$F1,$8B,$19 
      DC.B      $8C,$B5,$08,$99,$CC,$03,$D3,$A0 
      DC.B      $29,$34,$A6,$D4,$8C,$97,$65,$14 
      DC.B      $7A,$97,$D4,$C1,$E4,$00,$98,$1D 
      DC.B      $B2,$1C,$00,$F1,$D3,$A0,$E4,$00 
      DC.B      $98,$14,$00,$20,$00,$00,$98,$19 
      DC.B      $B0,$BC,$00,$F1,$8C,$3A,$8E,$9D 
      DC.B      $98,$1E,$B0,$52,$00,$F1,$02,$DD 
      DC.B      $34,$39,$D4,$41,$3C,$39,$62,$1A 
      DC.B      $A7,$3B,$A6,$D7,$8A,$F8,$25,$B7 
      DC.B      $65,$18,$08,$96,$7A,$98,$0C,$34 
      DC.B      $D4,$62,$A7,$3C,$D3,$C0,$BF,$3B 
      DC.B      $8A,$E4,$03,$5C,$7B,$B6,$D6,$28 
      DC.B      $BF,$3C,$63,$07,$62,$06,$28,$E8 
      DC.B      $28,$C8,$88,$AF,$78,$AC,$D4,$44 
      DC.B      $BF,$3B,$88,$AC,$79,$64,$D4,$44 
      DC.B      $E4,$00,$88,$8B,$10,$8F,$98,$14 
      DC.B      $14,$00,$00,$00,$29,$34,$B8,$34 
      DC.B      $8C,$10,$98,$0E,$B3,$28,$00,$F1 
      DC.B      $98,$17,$00,$60,$00,$00,$98,$11 
      DC.B      $01,$90,$00,$00,$8A,$3D,$98,$1C 
      DC.B      $B1,$08,$00,$F1,$18,$3D,$D4,$C1 
      DC.B      $A4,$14,$98,$1D,$B2,$78,$00,$F1 
      DC.B      $D3,$A0,$2A,$94,$35,$B4,$D4,$E1 
      DC.B      $E4,$00,$8E,$9E,$63,$7E,$D7,$E1 
      DC.B      $18,$3E,$D7,$00,$A4,$14,$A0,$36 
      DC.B      $8A,$D8,$65,$16,$A4,$54,$12,$F6 
      DC.B      $D5,$A1,$25,$B8,$78,$98,$D5,$28 
      DC.B      $8C,$10,$7B,$05,$D4,$C8,$E4,$00 
      DC.B      $8A,$3D,$8B,$10,$63,$B0,$8B,$19 
      DC.B      $61,$19,$D3,$80,$18,$56,$D3,$98 
      DC.B      $8C,$74,$7A,$96,$D3,$84,$63,$B6 
      DC.B      $76,$18,$72,$D8,$34,$96,$D3,$82 
      DC.B      $2B,$19,$2A,$10,$D3,$82,$EA,$14 
      DC.B      $2A,$94,$D3,$81,$E4,$00,$F2,$19 
      DC.B      $8C,$10,$18,$2F,$D3,$94,$E4,$00 
      DC.B      $89,$A6,$30,$06,$8C,$07,$88,$94 
      DC.B      $98,$1D,$B3,$2C,$00,$F1,$63,$B4 
      DC.B      $02,$9D,$88,$8F,$89,$F4,$08,$2F 
      DC.B      $89,$F5,$7A,$A5,$D4,$64,$63,$B4 
      DC.B      $D4,$60,$89,$15,$63,$B5,$EA,$B5 
      DC.B      $EA,$94,$8A,$99,$8A,$BA,$25,$B9 
      DC.B      $25,$BA,$24,$D5,$13,$3A,$D4,$A4 
      DC.B      $E4,$00,$98,$1B,$00,$4B,$00,$00 
      DC.B      $03,$7A,$04,$E7,$2B,$55,$75,$14 
      DC.B      $75,$15,$8A,$99,$8A,$BA,$25,$B9 
      DC.B      $25,$BA,$24,$D5,$64,$27,$17,$3A 
      DC.B      $D4,$A4,$E4,$00,$98,$1B,$00,$3C 
      DC.B      $00,$00,$03,$7A,$04,$E7,$2B,$55 
      DC.B      $75,$14,$75,$15,$8A,$99,$8A,$BA 
      DC.B      $25,$B9,$25,$BA,$24,$D5,$64,$27 
      DC.B      $17,$3A,$2B,$55,$75,$15,$24,$D5 
      DC.B      $29,$35,$75,$15,$79,$E5,$D4,$C8 
      DC.B      $BF,$B5,$98,$14,$B1,$90,$00,$F1 
      DC.B      $D2,$80,$09,$1D,$08,$29,$98,$1D 
      DC.B      $B0,$52,$00,$F1,$D3,$A0,$E4,$00 
      DC.B      $77,$08,$77,$0B,$98,$14,$B3,$28 
      DC.B      $00,$F1,$29,$8B,$29,$28,$BE,$8B 
      DC.B      $75,$08,$08,$94,$BE,$88,$98,$14 
      DC.B      $2C,$00,$00,$00,$98,$15,$B3,$28 
      DC.B      $00,$F1,$98,$16,$01,$00,$00,$00 
      DC.B      $8A,$B9,$08,$99,$A6,$B7,$76,$17 
      DC.B      $BA,$97,$76,$17,$08,$54,$08,$95 
      DC.B      $BA,$97,$18,$36,$D6,$E1,$08,$54 
      DC.B      $8C,$19,$98,$1B,$B0,$00,$00,$F1 
      DC.B      $BF,$79,$98,$1A,$A1,$14,$00,$F1 
      DC.B      $BF,$59,$E4,$00,$E4,$00,$E4,$00 
      DC.B      $D7,$60,$E4,$00,$98,$15,$B3,$28 
      DC.B      $00,$F1,$8C,$14,$A6,$B6,$30,$14 
      DC.B      $62,$14,$2A,$96,$98,$1E,$B2,$32 
      DC.B      $00,$F1,$D3,$C0,$BE,$B6,$08,$C3 
      DC.B      $98,$16,$B3,$10,$00,$F1,$A4,$17 
      DC.B      $35,$B7,$D4,$62,$E4,$00,$A0,$37 
      DC.B      $A4,$57,$B8,$34,$18,$35,$D4,$D4 
      DC.B      $8C,$17,$98,$16,$B3,$10,$00,$F1 
      DC.B      $D0,$60,$E4,$00,$35,$B7,$D4,$E1 
      DC.B      $E4,$00,$8E,$9E,$63,$7E,$D7,$E1 
      DC.B      $18,$3E,$D7,$00,$A4,$17,$A0,$3A 
      DC.B      $A4,$5D,$8B,$57,$65,$17,$7B,$17 
      DC.B      $D5,$A8,$7A,$F9,$D5,$68,$E4,$00 
      DC.B      $BE,$DA,$08,$96,$18,$35,$D6,$34 
      DC.B      $E4,$00,$98,$16,$B3,$10,$00,$F1 
      DC.B      $D0,$60,$E4,$00,$8C,$9B,$7A,$FB 
      DC.B      $D4,$C2,$E4,$00,$98,$1B,$B2,$B8 
      DC.B      $00,$F1,$D3,$60,$E4,$00,$98,$16 
      DC.B      $B3,$10,$00,$F1,$BE,$DA,$D0,$60 
      DC.B      $E4,$00,$00,$00,$00,$00,$00,$00 
; A102A84:
;      DS.W      14,0
;    DCB.W   14,0 = 28 bytes
      dc.b      $00,$00,$00,$00,$00,$00,$00,$00
; A102A8c:
      dc.b      $00,$00,$00,$00,$00,$00,$00,$00
; A102A94:
      dc.b      $00,$00,$00,$00,$00,$00,$00,$00
DSP_E:
GETTOC_E:
; A102A9C:
      dc.b      $00,$00,$00,$00

    .even
cdbios:

    .incbin "cdbios.txt"

privatekey:
    .incbin "privatcd.key"  ; ????

;#################################################################
;#################################################################
;#################################################################
	.bss
;
;
; $4000
;dlist:			define this as an equate
	ds.l	16
;
; $4040
;image:
	ds.b	48*280
;
; $74C0
countRSA:
	ds.l	1
;
; $74C4
nextrk:
	ds.l	1

; $74C8
curfine:
	ds.l	1	;ptr to current finehash position

; $74CC
currsa:
	ds.l	1	;ptr to beg of current RSA session (input from finehash)

; $74D0
endrsa:
	ds.l	1	;ptr to end of current RSA session (+1)

; $74D4
fcount:
	ds.l	1

; $74D8
joycur:
	ds.l	1
;
; $74DC
decdig:
	ds.b	4
;
; $74E0
lastc:
	ds.l	1	;used as word
;
;
; $74E4
statmsg:
	ds.b	128		;put up status message built here

; $7564
curmsg:
	ds.b	128		;current display meesage
;
; $75E4
BlokT:
	ds.l	1

; $75E8
MinT:
	ds.l	1

; $75EC
MaxT:
	ds.l	1

; $75F0
SizeT:
	ds.l	1
;
; DO: new $24 = 36 bytes added to upgrade from v.0.3 to v.1.3
A75F4:
    ds.l    1
A75F8:
    ds.l    1
A75FC:
    ds.l    1
A7600:
    ds.l    1
A7604:
    ds.w    1
A7606:
    ds.w    1
A7608:
    ds.l    1
A760C:
    ds.l    1
A7610:
    ds.l    1
A7614:
    ds.l    1
;
; $7618
A7618:
    ds.b    $2000

A9618:
    ds.b    4

A961C:
    ds.b    4


; $9620
privy:      ; Address to which the file PRIVATCD.KEY should be loaded
	ds.b	1024
;
; $9A20
privat:
	ds.b	68
; $9A64
publicK:
	ds.b	68
; $9AA8
butchptr:
	ds.l	1
; $9AAC
butchbuf:
	ds.l	256
; $9EAC
A9EAC:
postmark:
    ds.b    8
; $9EB4
	ds.b	$20000-8		;qualified markers to use for hash
; $29EAC
prehash:
	ds.b	$20000		;hash records generated
;
;
;
; $49EAC
finehash:
;	ds.b	$28000		;final hash table to be enRSA'd
    ds.b    $28000      ;final hash table to be enRSA'd


;############################################################################
;### The following three buffers (FileST, resultF, FileEnd)
;### assemble the content of the Encryption-data-track
; $71EAC
FileST:
	ds.b	$60		;header for RSA'd

; $71F0C
resultF:
	ds.b	$26160		;RSA'd & formatted & ready to go

; $9806C
FileEND:
	ds.b	$60		;tailer here
;### ------------------------------------------------------------------------
; $980CC
XModempadding:
    ds.b    $60     ; DO: padding up to a $80-boundary for XModem-transfer!!
                    ; else X;odem will pad with $1A-bytes!!!!!!
;###
;############################################################################
;
;  The following buffer can get very big...
;
;>> $980CC
; $9812C
premark:
	ds.b	$20000		;pre-scan potential markers found

;>> $B80CC
; $B812C
height:  ds.w 1
a_vdb:  ds.w 1
a_vde:  ds.w 1
width:  ds.w 1
a_hdb:  ds.w 1
a_hde:  ds.w 1
