;*******************************************
; Xmodem Upload Protocol
; Based on original 6805/8031 microcontroller
;  code by Larry L. Cameron of Austin, TX.
; Converted to 68000 for the Atari Jaguar by
;  Glenn Bruner.
;*******************************************

;*******************************************
; Program Includes & External Variables
;*******************************************
		.globl	_upload
        .globl  upload
                .extern uart_init
;*******************************************
; Program Equates
;*******************************************
retries		equ	10
isyncto		equ	10
code0err	equ	0
code11err	equ	11
code12err	equ	12
code13err	equ	13
code14err	equ	14
blocksize	equ	128
soh		equ	1
eot		equ	4
ack		equ	6
nak		equ	21
asistat		equ	$f10032
asidata		equ	$f10030
asi_tbe		equ	8
asi_rbf		equ	7
asi_err		equ	15
asi_timeout1	equ	30000
asi_timeout2	equ	34
crc_coeff	equ	$1021

;*******************************************
; Xmodem Program
;*******************************************
_upload:
    move.l  4(sp),a0        ; startaddress, for C-call
    move.l  8(sp),a1        ; endaddress+1, for C-call

upload:
	move.w	#1,blocknum
;	clr.w	tempu
	clr.w	code11
	clr.w	code13
	clr.w	code14
	clr.l	d3
	jsr	uart_init
step2u:
	bsr	receive
	bcc	dtrec
step2bu:
	addq.w	#1,d3
	cmp.w	#retries,d3
	blt	step2u
	clr.l	d3
	add.w	#1,code11
	cmp.w	#isyncto,code11
	blt	step2u
	moveq.l	#code11err,d0
	rts
dtrec:
	cmp.b	#'C',d0
	bne	step2bu
step3u:
	clr.w	d4
	clr.w	done
	moveq.l	#soh,d0
	bsr	transmit
	move.w	blocknum,d0
	bsr	transmit
	not.w	d0
	bsr	transmit
step4u:
	clr.w	rdatact
step5u:
	cmp.w	#0,done
	bne	done1
	move.b	(a0)+,d0
	bra	sendit
done1:
	moveq.l	#26,d0
sendit:
	bsr	transmit
	bsr	calccrc
	cmp.w	#0,done
	bne	done2
	cmp.l	a0,a1
	bne	done2
	add.w	#1,done
done2:
	add.w	#1,rdatact
	cmp.w	#blocksize,rdatact
	bne	step5u
step6u:
;	clr.l	d0		;this was bogus addition from original source
;	bsr	calccrc		;commented out!
;	clr.l	d0
;	bsr	calccrc
step7u:
	move.w	d4,d0
	ror.w	#8,d0
	bsr	transmit
	move.b	d4,d0
	bsr	transmit
step8u:
	bsr	receive
	bcc	rdack
	moveq.l	#code12err,d0
	rts
rdack:
	cmp.b	#ack,d0
	bne	step10u
step9au:
	cmp.w	#0,done
	bne	fini
step9bu:
	clr.w	code14
	add.w	#1,blocknum
	bra	step3u
fini:
	moveq.l	#eot,d0
	bsr	transmit
	bsr	receive
	bcc	ckack
	moveq.l	#code12err,d0
	rts
ckack:
	cmp.b	#ack,d0
	bne	packr
	moveq.l	#code0err,d0
	rts
packr:
	add.w	#1,code13
	cmp.w	#retries,code13
	bne	fini
	moveq.l	#code13err,d0
	rts
step10u:
	jsr	decptr
	add.w	#1,code14
	cmp.w	#retries,code14
	bne	step3u
	moveq.l	#code14err,d0
	rts
decptr:
	sub.l	#blocksize,a0
	rts

calccrc:
	moveq.l	#7,d2
	moveq.l	#0,d1
crclp:
	andi.w	#$ffee,sr
	roxl.b	#1,d0
	roxr.w	#1,d1
	andi.w	#$8000,d1
	eor.w	d1,d4
	asl.w	#1,d4
	bcc	again
        eori.w  #$1021,d4
again:
	dbra	d2,crclp
	rts


;calccrc:
;	moveq.l	#7,d1
;crclp:
;        andi.w   #$ffef,sr           ;this clears the extended carry flag
;	roxl.b	#1,d0
;	roxl.w	#1,d4
;	bcc	again
;	eori.w	#crc_coeff,d4
;again:
;	dbra	d1,crclp
;	rts
transmit:
	move.w	asistat,d1
	btst	#asi_tbe,d1
	beq	transmit
	andi.w	#$00ff,d0
	move.w	d0,asidata
	rts
receive:
	move.w	#asi_timeout2,d2
rx_lp1:
	move.w	#asi_timeout1,d3
rx_lp3:
	move.w	asistat,d1
	btst	#asi_err,d1
	bne	rx_err
	btst	#asi_rbf,d1
	beq	rx_lp2
	move.w	asidata,d0
	andi.w	#$00ff,d0
	bra	rx_exit
rx_lp2:
	dbra	d3,rx_lp3
	dbra	d2,rx_lp1
rx_err:
        ori.w   #1,sr           ;this sets the carry flag
	rts
rx_exit:
        andi.w  #$fffe,sr	;this clears the carry flag
	rts

crc16:
	moveq.l	#7,d2
	moveq.l	#0,d1
crc16_lp1:
	roxl.b	#1,d0
	roxr.w	#1,d1
	andi.w	#$8000,d1
	eor.w	d1,d4
	asl.w	#1,d4
	bcc	crc16_lp2
	eori.w	#$1021,d4
crc16_lp2:
	dbra	d2,crc16_lp1
	bra	crc16


;crc16:
;	moveq.l	#7,d2
;crc16_lp1:
;	move.b	d0,d1
;	andi.b	#$80,d1
;	ror.w	#8,d4
;	eor.b	d1,d4
;	rol.w	#8,d4
;	andi.w	#$fffe,sr
;	roxl.b	#1,d4
;	
;	bcc	crc_lp2
;	eori.w	#$1021,d4
;crc_lp2:
;	roxl.b	d0
;	andi.w	#$00ff,d0
;	dbra	d2,crc16_lp1
;	bra	crc16

        .data
		.even
;*******************************************
; Data
;*******************************************
blocknum:
                dc.w    1
;tempu:
;               dc.w    0
code11:
                dc.w    0
code13:
                dc.w    0
code14:
                dc.w    0
done:
                dc.w    0
rdatact:
                dc.w    0
