/***************************************************************************
***     INTROPTF.EXE
***     Purpose:        Reads the INTROORG.IMG and patches it with the
***                     given 64*64*16bit-CRY-image and then writes it
***                     back with the filename of the CRY-image and
***                     the extension "IMG"
***
***
***     Author:         Matthias Domin
***
***     Date:           August 22, 2000
***
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

// The 68K-code to load the intro-image from $802000 to $4ff6
// and let it run in an infinite loop:
unsigned char demoheader[32] = {
 0x20, 0x3C, 0x00, 0x00, 0x51, 0x0C, 0x41, 0xF9,
 0x00, 0x80, 0x20, 0x20, 0x43, 0xF9, 0x00, 0x00,
 0x4F, 0xF6, 0x22, 0xD8, 0x53, 0x80, 0x66, 0xFA,
 0x4E, 0xB9, 0x00, 0x00, 0x4F, 0xF6, 0x60, 0xF8};

void main( int argc, char *argv[ ], char *envp[ ] )
{
   char path_buffer[_MAX_PATH];
   char path_bufferOut[_MAX_PATH];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];

   int nCommand, nDownload, nStart, nLength;


   FILE *instream;
   FILE *instream2;
   FILE *instream3;
   FILE *outstream;
   FILE *outstream2;
   char list[20];
   char list2[20];
   int  i, numread, numwritten;
   int bytes, picend, result, offset, part;
   int failure = 0;

   if (argc < 2 || argc > 3)
      failure = 1;
   if (argc == 3)
      {
      if (stricmp("-demo",argv[2]))
         failure = 1;
      }

   if (failure)
      {
      printf("\nINTROPTF.EXE patches a given 64*64-16bit-CRY-image "
             "into the INTROORG.IMG-file.\n"
             "Load the output-file into Jaguar-RAM at $4ff6 "
             "and start it there.\n\n");

      printf("Usage:\n\tintroptf filename [-demo]\n");
      printf("The output-file gets the filename of the CRY-image "
             "but with the extension IMG.\n"
             "Called with -demo the image will be converted into"
             "a cartridge-based program\n"
             "which plays the intro in an infinite-loop.\n"
             "The extension for this file will be ROM.\n");
      exit(1);
      }

   strcpy(path_buffer, argv[1]);
   _splitpath( path_buffer, drive, dir, fname, ext );
   //printf( "Path extracted with _splitpath:\n" );
   //printf( "  Drive: %s\n", drive );
   //printf( "  Dir: %s\n", dir );
   //printf( "  Filename: %s\n", fname );
   //printf( "  Ext: %s\n", ext ); // including the dot!!!

   if (argc == 2)
      _makepath( path_bufferOut, drive, dir, fname, "img" );
   else
      _makepath( path_bufferOut, drive, dir, fname, "rom" );
   //printf( "Path created with _makepath: %s\n\n", path_bufferOut );
   
   /* Open original intro-file in binary mode: */
   if( (instream = fopen( "INTROORG.IMG", "r+b" )) != NULL )
      {
         /* Open CRY-image-file in binary mode: */
         if( (instream3 = fopen( path_buffer, "r+b" )) != NULL )
            {
            printf ("Patching %s into %s!\n", path_buffer, path_bufferOut);
            if( (outstream = fopen( path_bufferOut, "w+b" )) != NULL )
               {
               // Write card-loader-header:
               if (argc == 3)
                  {
                  i=0;
                  picend = 32;
                  while(i<picend)
                     {
                     list[0] = demoheader[i];
                     fwrite( list, 1, 1, outstream);
                     i++;
                     }
                  }


               fseek(instream, 0, SEEK_SET);    // file-start
               i = 0;
               offset = 26138;  // Offset to the image of the Jaguar-head
               while(i<offset)
                  {
                  fread( list, 1, 1, instream );
                  fwrite( list, 1, 1, outstream);
                  i++;
                  }

               // Now patch the picture:
               i=0;
               picend = 8192;   // 64*64*2 Bytes
               while(i<picend)
                  {
                  fread( list, 1, 1, instream );
                  fread( list, 1, 1, instream3 );
                  fwrite( list, 1, 1, outstream);
                  i++;
                  }
               // output rest of INTROORG.IMG-file
               while (fread( list, 1, 1, instream ) != 0)
                  fwrite( list, 1, 1, outstream);

               fclose( outstream );
               }
            else
               printf( "The output-file %s could not be opened\n", path_bufferOut );

            fclose( instream3 );
            }
         else
            printf( "%s could not be opened\n", path_buffer );

      fclose( instream );
      }
   else
      printf( "Intro.img could not be opened\n" );
}
