/***************************************************************************
***     JAG2CARD
***     Author:         Matthias Domin
***
***     Date:           July 15, 2000
***
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>


void main( int argc, char *argv[ ], char *envp[ ] )
{
   char path_buffer[_MAX_PATH];
   char path_bufferOut[_MAX_PATH];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];

   int nCommand, nDownload, nStart, nLength, nRealLength;


   FILE *instream;
   FILE *instream2;
   FILE *outstream;
   unsigned char list[20];         // this must be unsigned !!!!
   int  i, numread, numwritten;
   int bytes, starterbytes, result;   



   if (argc != 2 )
      {
      printf("\nJAG2CARD written by Matthias Domin on July 15, 2000\n");

      printf("\nJAG2CARD produces a FLASHable ROM-image\n out off a JagServer/BJL file (*.JAG-file).\n");

      printf("Usage:\n\tjag2card filename\n");
      printf("The output-file gets the extension ROM.\n");
      printf("Only the JagServer command 3 (Receive program and Run it) is supported!\n");
      printf("JAG2CARD.IMG-file necessary.\n");
      exit(1);
      }

   strcpy(path_buffer, argv[1]);
   _splitpath( path_buffer, drive, dir, fname, ext );
   //printf( "Path extracted with _splitpath:\n" );
   //printf( "  Drive: %s\n", drive );
   //printf( "  Dir: %s\n", dir );
   //printf( "  Filename: %s\n", fname );
   //printf( "  Ext: %s\n", ext ); // including the dot!!!

   _makepath( path_bufferOut, drive, dir, fname, "rom" );
   //printf( "Path created with _makepath: %s\n\n", path_bufferOut );
   printf( "Path created: %s\n\n", path_bufferOut );
   
   /* Open file in binary mode: */
   if( (instream = fopen( path_buffer, "r+b" )) != NULL )
      {
      result = fseek( instream, 28L, SEEK_SET);
      if (strnicmp(ext, ".JAG", 4) == 0)
        {
        fread( list, 1, 4, instream);
        if (strnicmp(list, "JAGR", 4) == 0)
           {
           printf("JAG-file detected.\n");
           // Numbers are stored in Motorola-format!
           fread( list, 1, 2, instream);
           nCommand = list[0]*256+list[1];
           printf("Command: %d\n",nCommand);
           if (nCommand == 3)
              {
              printf("Receive program and Run it\n");
              fread( list, 1, 4, instream);
              //printf("Download: $%x\n", *((int*)list));
              nDownload = list[0]*256*256*256+list[1]*256*256+list[2]*256+list[3];
              printf("Download-Address: $%x\n", nDownload);

              fread( list, 1, 4, instream);
              nLength = list[0]*256*256*256+list[1]*256*256+list[2]*256+list[3];
              printf("Length: %d\n", nLength);

              fread( list, 1, 4, instream);
              nStart = list[0]*256*256*256+list[1]*256*256+list[2]*256+list[3];
              printf("Start-Address: $%x\n", nStart);
              } // Command 3
           else if (nCommand == 2)
              {
              printf("Just receive data\n");
              fread( list, 1, 4, instream);
              nDownload = list[0]<<24+list[1]<<16+list[2]<<8+list[3];
              nStart = nDownload;
              printf("Download-Address: $%x\n", nDownload);


              fread( list, 1, 4, instream);
              nLength = list[0]*256*256*256+list[1]*256*256+list[2]*256+list[3];
              nRealLength = nLength;

              printf("Length: %d\n", nLength);
              } // Command 2

           }    // "JAGR"
         }       // ".JAG"
      else
         {
         // Just strip off the first 28 bytes:
         result = fseek( instream, 28L, SEEK_SET);
         }

      // Copy the rest of the file
      if( (outstream = fopen( path_bufferOut, "w+b" )) != NULL )
         {
         if( (instream2 = fopen( "JAG2CARD.IMG", "r+b" )) != NULL )
           {
           starterbytes = 0;
           while(fread( list, 1, 1, instream2 ) != 0)
              {
              fwrite( list, 1, 1, outstream );
              starterbytes++;
              }
           // There are already< 4 additional 4 bytes at the end of JAG2CARD.IMG
           starterbytes -= 4;
           // Now we add 8 bytes more:
           list[0] = 0x00;
           for (i=0; i<8; i++)
              fwrite( list, 1, 1, outstream );
           fclose( instream2 );
           }

         bytes = 0;
         while(fread( list, 1, 1, instream ) != 0)
            {
            numwritten = fwrite( list, 1, 1, outstream );
            bytes++;
            }
         if (nLength == 0)
            nRealLength = bytes;
         else
            nRealLength = nLength;
         printf("RealLength: %d\n", nRealLength);

         // FLASH.EXE needs longwords
         list[0] = 0xff;
         while(bytes%4)
            {
            numwritten = fwrite( list, 1, 1, outstream );
            bytes++;
            }

         // Now we patch the values (as MOTOROLA-longs!!!)
         fseek( outstream, starterbytes, SEEK_SET);

         // of the destination address
         *list = *( ((char*) &nDownload)+3);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nDownload)+2);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nDownload)+1);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nDownload)+0);
         fwrite( list, 1, 1, outstream );

         // the start-address
         *list = *( ((char*) &nStart)+3);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nStart)+2);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nStart)+1);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nStart)+0);
         fwrite( list, 1, 1, outstream );

         // and the amount of longs to be copied
         nRealLength /= 4;
         nRealLength++;
         *list = *( ((char*) &nRealLength)+3);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nRealLength)+2);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nRealLength)+1);
         fwrite( list, 1, 1, outstream );
         *list = *( ((char*) &nRealLength)+0);
         fwrite( list, 1, 1, outstream );

         fclose( outstream );
         }
      else
         printf( "Problem opening the output-file\n" );

      fclose( instream );
      }
   else
      printf( "Input-File could not be opened\n" );
}
