;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	JAG2.INC  Hardware Equates for JAGUAR II System
;
;	COPYRIGHT 1992-1995 Atari Computer Corporation
;	UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
;	PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR
;	THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
;	ALL RIGHTS RESERVED.
;
;      Last Modified: 8/23/95 - ERS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	BLITTER REGISTERS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

B_FINNER	EQU	BASE + $229C	; Blitter Inner Loop Counter Fractional Part
B_IDELTA	EQU	BASE + $22A0	; Blitter Inner Loop Delta
A1_XSD		EQU	BASE + $22A4	; A1 X Step Delta
A1_YSD		EQU	BASE + $22A8	; A1 Y Step Delta

B_ISTEP		EQU	BASE + $22AC	; Blitter Intensity Step Value
B_ISD		EQU	BASE + $22B0	; Blitter Intensity Step Delta
B_ZSTEP		EQU	BASE + $22B4	; Blitter Z Step Value
B_ZSD		EQU	BASE + $22B8	; Blitter Z Step Delta

B_X0		EQU	BASE + $22BC	; Blitter Texture X address pointer 0
B_X1		EQU	BASE + $22C0	; Blitter Texture X address pointer 1
B_X2		EQU	BASE + $22C4	; Blitter Texture X address pointer 2
B_X3		EQU	BASE + $22C8	; Blitter Texture X address pointer 3

B_Y0		EQU	BASE + $22CC	; Blitter Texture Y address pointer 0
B_Y1		EQU	BASE + $22D0	; Blitter Texture Y address pointer 1
B_Y2		EQU	BASE + $22D4	; Blitter Texture Y address pointer 2
B_Y3		EQU	BASE + $22D8	; Blitter Texture Y address pointer 3

B_XINC		EQU	BASE + $22DC	; Blitter Texture X Increment
B_XSTEP		EQU	BASE + $22E0	; Blitter Texture X Step
B_XSD		EQU	BASE + $22E4	; Blitter Texture X Step Delta

B_YINC		EQU	BASE + $22E8	; Blitter Texture Y Increment
B_YSTEP		EQU	BASE + $22EC	; Blitter Texture Y Step
B_YSD		EQU	BASE + $22F0	; Blitter Texture Y Step Delta

B_TBASE		EQU	BASE + $22F4	; Blitter Texture Base Address
B_IINCX		EQU	BASE + $22F8	; Alternate Intensity Increment Register (11.16 rather than 8.16)

A1_MASK		EQU	BASE + $22FC
A2_CLIP		EQU	BASE + $2300
A1_X		EQU	BASE + $2304
A1_Y		EQU	BASE + $2308
A2_X		EQU	BASE + $230C
A2_Y		EQU	BASE + $2310

A1_XSTEP	EQU	BASE + $2314
A1_YSTEP	EQU	BASE + $2318

B_COLOR		EQU	BASE + $231C
B_TXTD		EQU	BASE + $2320
B_TCLUT		EQU	BASE + $2400

;;;
;;; BLITTER Command Register equates
;;;

POLYGON		EQU	$80000000	; d31:	   enable polygon drawing mode

;;;
;;; BLITTER Extended Control equates
;;;

DATINIT		EQU	$00010000	; d16:     initialize I and Z values
					; d17-18:  Texture mapping controls
NOTEXT		EQU	$00000000	;	   no texture mapping
TEXTEXT		EQU	$00020000	;	   fetch from external RAM
TEXTINT		EQU	$00040000	;	   fetch from internal RAM
TEXTDBL		EQU	$00060000	;	   fetch from internal RAM, doubled

INTERP		EQU	$00080000	; d19:     Enable texture interpolation

TEXTNIB		EQU	$04000000	; d26	   Use 4 bit look up table
TEXTMIR		EQU	$08000000	; d27	   Mirror texture as it wraps
TEXTRGB		EQU	$10000000	; d28	   Texture is RGB data
EXT_INT		EQU	$20000000	; d29	   Extended precision intensity

					; d30-31   Pattern Data Register Select
PDSELPATD	EQU	$00000000	; Pattern data
PDSELTEXT	EQU	$40000000	; Texture data
PDSELXPAT	EQU	$80000000	; Extended Precision Pattern data
PDSELGOUR	EQU	$C0000000	; Mix of Texture Data and Color Register

;;;;;;;;;
;; EOF ;;
;;;;;;;;;
