;
; tex: draw a texture mapped triangle in phrase mode
; OBERON VERSION: can do the whole triangle in 1 blit!
;

;
; SET-UP ROUTINE FOR GOURAUD SHADED POLYGONS
; called in regbank 1
;
;	.REGBANK1


spillreg	.equr	traploop

	.globl	texpoly
texpoly:
;
; make sure the blitter is ready to receive commands
;
	movei	#B_CMD,temp0
.bwait:
	load	(temp0),temp1
	btst	#2,temp1		; check PENDING bit
	jr	NE,.bwait
	nop

	movei	#POLYGON|UPDA1|UPDA1F|PATDSEL|GOURD|ZBUFF|ZMODEGT|DSTENZ|DSTWRZ|DSTEN|BKGWREN,temp1
;;;	movei	#POLYGON|UPDA1|UPDA1F|LFU_ONE,temp1

	moveta	temp1,bcmdval

;
; set up texture registers
;
	movefa	srcaddr,temp0
	movei	#B_TBASE,temp1
	store	temp0,(temp1)

.if 1
	movefa	b_color,temp0
	movei	#$0000FF00,temp1
	and	temp1,temp0
.else
	moveq	#0,temp0
.endif
	movei	#B_COLOR,temp1
	store	temp0,(temp1)
;
; set up the destination registers
;
; first, the Z and I increment register

	movei	#B_ZINC,temp2
	movefa	b_zinc,temp1
	movefa	b_iinc,temp0
.if !(PIXMODE)
	shlq	#2,temp1			; multiply Z increment by 4
	shlq	#2,temp0			; multiply I increment by 4
.endif
	store	temp1,(temp2)			; store Z increment
	movei	#B_IINCX,temp2
	store	temp0,(temp2)			; store I increment
;
; set up texture X and Y increments to be the U and V
; increments, respectively
;
	movei	#B_XINC,temp2
	movefa	b_uinc,temp1
	movefa	b_vinc,temp0
.if !(PIXMODE)
	shlq	#2,temp1			; multiply increments by 4 for phrase mode
	shlq	#2,temp0
.endif
	store	temp1,(temp2)
	addqt	#(B_YINC-B_XINC),temp2
	store	temp0,(temp2)

	jump	(return)
	nop
;
; per-trapezoid routine for gouraud shading
; called in regbank 0
;

	.globl	textrap
textrap:
	.REGBANK0

	cmpq	#1,anumlines			; if numlines is negative or zero, abort
	movei	#.return,trapdone
	jump	MI,(trapdone)
	nop


	shrq	#16,ay				; strip fractional part of ay
	shlq	#16,ay

;
; Make sure the blitter is ready to receive commands
;

.bwait:
	load	(bcmd_ptr),atemp0
	btst	#2,atemp0			; check for PENDING command
	jr	NE,.bwait
	nop


;
; set up the initial count value
; "anumlines" is the number of lines;
; rightx - leftx is the number of pixels
; Also, set atemp2 to be the step value for
; the count, which should be rightxstep-leftxstep

	movei	#B_IDELTA,atemp0
	move	rightxstep,atemp2
	move	rightx,bcount
	sub	leftxstep,atemp2
	sub	leftx,bcount
	store	atemp2,(atemp0)			; store the "count step"

;
; check for negative or 0 count
; the blitter count is found by adding
; the bcount value to the fractional part
; of leftx
;

	sharq	#16,ay

	move	PC,spillreg
.chkcount:
	move	leftx,atemp0
	shlq	#16,atemp0
	shrq	#16,atemp0
	add	bcount,atemp0
	sharq	#16,atemp0
	cmpq	#1,atemp0
	jr	PL,.countOK
	nop
		add	leftxstep,leftx
		add	rightxstep,rightx
		add	leftzstep,leftz
		add	leftistep,lefti
		add	leftustep,leftu
		add	leftvstep,leftv
		addqt	#1,ay		
		add	atemp2,bcount		; atemp2 still has count step
		subq	#1,anumlines		; one fewer line to draw
		jump	NE,(spillreg)		; should we keep going? if so, jump to .chkcount
		nop
		jump	(trapdone)		; all finished
		shlq	#16,ay
.countOK:

	shlq	#16,ay

	movei	#B_ISTEP,atemp0
	movei	#B_ZSTEP,atemp1
	store	lefti,(atemp0)
	store	leftz,(atemp1)
	movei	#B_ISD,atemp0
	movei	#B_ZSD,atemp1
	store	leftistep,(atemp0)
	store	leftzstep,(atemp1)

	movei	#B_XSTEP,atemp0
	movei	#B_YSTEP,atemp1
	store	leftu,(atemp0)
	store	leftv,(atemp1)
	movei	#B_XSD,atemp0
	movei	#B_YSD,atemp1
	store	leftustep,(atemp0)
	store	leftvstep,(atemp1)

	movei	#A1_X,atemp0
	movei	#A1_Y,atemp1
	store	leftx,(atemp0)
	store	ay,(atemp1)
	movei	#A1_XSTEP,atemp0
	movei	#A1_YSTEP,atemp1
	store	leftx,(atemp0)
	store	ay,(atemp1)

	movei	#$00010000,atemp2		; Y step value
	movei	#A1_XSD,atemp0
	movei	#A1_YSD,atemp1
	store	leftxstep,(atemp0)
	store	atemp2,(atemp1)

;
; update all of the various registers affected by the blit:
; leftx, rightx, ay, leftz, lefti are all incremented by
; numlines * step value
;

	move	leftxstep,atemp0	; get the integer part
	move	leftxstep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,leftx
	shlq	#16,atemp0
	add	atemp0,leftx

	move	rightxstep,atemp0	; get the integer part
	move	rightxstep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,rightx
	shlq	#16,atemp0
	add	atemp0,rightx

	move	leftistep,atemp0	; get the integer part
	move	leftistep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,lefti
	shlq	#16,atemp0
	add	atemp0,lefti

	move	leftzstep,atemp0	; get the integer part
	move	leftzstep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,leftz
	shlq	#16,atemp0
	add	atemp0,leftz

	move	leftustep,atemp0	; get the integer part
	move	leftustep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,leftu
	shlq	#16,atemp0
	add	atemp0,leftu

	move	leftvstep,atemp0	; get the integer part
	move	leftvstep,atemp1	; and the fractional part
	sharq	#16,atemp0
	mult	anumlines,atemp1
	imult	anumlines,atemp0
	add	atemp1,leftv
	shlq	#16,atemp0
	add	atemp0,leftv

	shlq	#16,anumlines
	add	anumlines,ay
	shrq	#16,anumlines

;
; check for negative or 0 count at the end of the blit
; the blitter count value is found by adding the fractional part
; of the leftx value to the count register value
;
	move	bcount,spillreg

	move	rightx,atemp2			; atemp2 = last rightx
	move	leftx,atemp1			; atemp1 = last leftx

.chkendcount:
	sub	rightxstep,atemp2	; back up 1 line
	sub	leftxstep,atemp1

	move	atemp1,atemp0		; atemp0 = fractional part of x
	move	atemp2,bcount
	shlq	#16,atemp0
	sub	atemp1,bcount
	shrq	#16,atemp0
	add	atemp0,bcount
	sharq	#16,bcount
	cmpq	#1,bcount			; is last count >= 1?
	jr	PL,.endcountOK
	nop
		subq	#1,anumlines		; if not, do 1 less line
		jr	NE,.chkendcount
		nop
		jump	(trapdone)
		nop
.endcountOK:

	move	spillreg,bcount
	move	spillreg,atemp2				; now make atemp2 the fractional part of the count

	shrq	#16,bcount			; bcount gets integer part of count
	shlq	#16,atemp2				; strip integer part from fraction
	shlq	#16,anumlines			; put number of lines in upper word
	shrq	#16,atemp2				; fill upper word with 0
	or	anumlines,bcount

	movei	#B_COUNT,atemp1
	store	bcount,(atemp1)			; set B_COUNT
	or	srcflags,atemp2			; add in texture mapping, DATINIT, etc. flags
;;;;	bset	#19,atemp2			; turn on anti-aliasing
;;;;	bset	#28,atemp2			; turn on RGB mode
	movei	#B_FINNER,atemp0
	store	atemp2,(atemp0)			; set the fractional part of B_INNER
	store	bcmdval,(bcmd_ptr)	; starts the blit

.return:
	movei	#G_FLAGS,atemp1			; switch back to bank 1
	load	(atemp1),atemp0
	movefa	return,atemp2
	bset	#14,atemp0
	jump	(atemp2)
	store	atemp0,(atemp1)			; the jump will flush the prefetch queue
;	nop					; and take 3 cycles, giving time for the new flags
;	nop					; to take effect
	.REGBANK1

	.equrundef	spillreg
