GPU_OP_start:
        .GPU
	.org	G_RAM
GPU_START:
;*****************************************************************************
;GPU ANIMATION AND SCALING
;
;r11 = obj_data
;r21 = reserviert fr ani data
;r12 = loop_counter
;r13 = .loop
;r14 = scale_list
;r15 = .end_scale
;r16 = .next_scale_obj
;r22 = .do_ani
;r23 = .next_obj
;r17 = .turn_ani_off
;r18 = reserved for run_ani
gpu_animation:
        movei   #gpu_obj_data,r0        ; Adresse Daten fr OP-Liste
	load	(r0),r11		; Adresse laden
	movei	#anz_objects,r0
	loadw	(r0),r12
	movei	#.loop,r13
	movei	#0,r14
	movei	#.end_scale,r15
	movei	#.next_scale_obj,r16
	movei	#.turn_ani_off,r17
	movei	#.do_ani,r22
	movei	#.next_obj,r23
.loop:
;/////////////////////////////////////////////////////////////////////////
;SCALE
;prfen ob max X erreicht ist.
move	r11,r0
movei	#SCALING,r1
add	r1,r0
load	(r0),r1
cmpq	#0,r1
jump	EQ,(r15) ;.end_scale
nop

move	r1,r14	;lade scale liste

move	r11,r0
addq	#XSCAL,r0
movei	#0,r1
loadb	(r0),r1

move	r14,r2
addq	#MAX_SCL_X,r2
movei	#0,r3
loadb	(r2),r3

cmp	r1,r3
jump	EQ,(r16);.next_scale_obj
nop

	move	r11,r0
	movei	#SCALE_COUNTER,r1
	add	r1,r0
	movei	#0,r1
	loadb	(r0),r1

	addq	#1,r1
	storeb	r1,(r0)

	movei	#.end_scale,r2
	cmpq	#4,r1
	jump	NE,(r2);.end_scale
	nop

	movei	#0,r1
	storew	r1,(r0)

;=================================
move	r14,r0
movei	#0,r1
loadb	(r0),r1

move	r11,r2
addq	#XSCAL,r2
movei	#0,r3
loadb	(r2),r3

move	r14,r5
addq	#SCL_DX,r5
load	(r5),r4
cmpq	#1,r4
jr	EQ,.add_x
nop

sub	r1,r3
storeb	r3,(r2)
jr	.no_addx
nop
.add_x:
add	r1,r3
storeb	r3,(r2)

.no_addx:
move	r11,r0
addq	#OBJTYPE,r0
movei	#1,r1
storeb	r1,(r0)

;=================================
;DO Y
;=================================
move	r11,r0
addq	#YSCAL,r0
movei	#0,r1
loadb	(r0),r1

move	r14,r2
addq	#MAX_SCL_Y,r2
movei	#0,r3
loadb	(r2),r3

cmp	r1,r3
jump	EQ,(r16);.next_scale_obj
nop
;=================================
move	r14,r0
addq	#SCL_Y,r0
movei	#0,r1
loadb	(r0),r1

move	r11,r2
addq	#YSCAL,r2
movei	#0,r3
loadb	(r2),r3

move	r14,r5
addq	#SCL_DY,r5
load	(r5),r4
cmpq	#1,r4
jr	EQ,.add_y
nop

sub	r1,r3
storeb	r3,(r2)
jr	.no_addy
nop
.add_y:
add	r1,r3
storeb	r3,(r2)

.no_addy:
move	r11,r0
addq	#OBJTYPE,r0
movei	#1,r1
storeb	r1,(r0)

jump	(r15);.end_scale
nop

.next_scale_obj:
move	r14,r0
addq	#NEXT_SCL,r0
load	(r0),r1
movei	#.go_on,r6
cmpq	#0,r1
jump	NE,(r6);.go_on
nop

move	r11,r3
addq	#OBJTYPE,r3
movei	#0,r4
storeb	r4,(r3)

jump	(r15);.end_scale
nop
.go_on:

move	r11,r3
movei	#SCALING,r4
add	r4,r3
store	r1,(r3)

.end_scale:

;/////////////////////////////////////////////////////////////////////////

        move    r11,r2
        movei   #ANIMATION,r0   ;ANIMATION
        add     r0,r2           ;offset von ANIMATION zu r2
	load    (r2),r0         ;ANIMATION nach r0 holen
        cmpq    #0,r0           ;prfe ob ANIMATION = 0
        jump    EQ,(r23)        ;wenn ja dann .next_obj
        nop
        move    r0,r21          ;lade adresse von Animation (r0) nach ani_list (r21)

	move	r21,r1
	addq	#ANI_SPEED_COUNTER,r1
	movei	#0,r0
	loadw   (r1),r0	;SPEED_COUNTER nach r0 holen
	cmpq    #0,r0		;prfe ob SPEED_COUNTER = 0
	jump	EQ,(r22)	;wenn ja, do ani
	nop
	subq	#1,r0         	;ziehe 1 von SPEED_COUNTER ab
        storew	r0,(r1)

	jump	(r23)	;springe zu .next_obj
	nop

.do_ani:
	move    r21,r1
        movei   #ANI_DATA,r0    ;ANI_DATA
        add     r0,r1           ;offset von ANI_DATA zu r21
        load    (r1),r0         ;ANI_DATA nach r0 holen
        move    r11,r3
        addq	#DATA,r3

        store   r0,(r3)

        move	r21,r1
	addq	#ANI_WIDTH,r1
	movei	#0,r0
	loadw   (r1),r0		;WIDTH nach r0 holen
	move	r11,r2
	addq	#WIDTH,r2
	storew	r0,(r2)

	addq	#2,r2	;BREITE_OFFS setten
	storew	r0,(r2)

        move	r21,r1
	addq	#ANI_HEIGHT,r1
	movei	#0,r0
	loadw   (r1),r0
	move	r11,r2
	addq	#HEIGHT,r2
	storew	r0,(r2)

        ;************** NEW **********************
        move	r21,r2
        addq	#ANI_DEPTH,r2
        movei	#0,r0
        loadb	(r2),r0

        move	r11,r3
        addq	#DEPTH,r3
        storeb	r0,(r3)
        ;************** NEW **********************

;////////////////// CHECK IF UPDATING ANI POINTER IN NECESSARY ////////////////////

	move	r21,r1
	addq	#ADDRESS_NEXT_ANI,r1
	load    (r1),r0				;ADDRESS_NEXT_ANI_OBJ nach r0 holen
	cmpq	#0,r0
	jump	EQ,(r17)
	nop

	move	r21,r1
	addq	#ADDRESS_NEXT_ANI,r1
	load    (r1),r0				;ADDRESS_NEXT_ANI_OBJ nach r0 holen
	move	r11,r2
	movei	#ANIMATION,r3	;ANIMATION
	add	r3,r2		;offset von ANIMATION zu r2
	store	r0,(r2)

	move	r21,r1
	addq	#ANI_SPEED,r1
	movei	#0,r0
	loadb   (r1),r0	;ANI_SPEED nach r0 holen
	move	r21,r2
	addq	#ANI_SPEED_COUNTER,r2
	storew	r0,(r2)

	jump	(r23)	;springe zu .next_obj
	nop
.turn_ani_off:
	move	r11,r2
	addq	#ACTIVE,r2
	movei	#0,r1
	storeb	r1,(r2)

	move	r11,r2
	movei	#ANIMATION,r0	;ANIMATION
	add	r0,r2		;offset von ANIMATION zu r2
	movei	#0,r1
	store	r1,(r2)
.next_obj:
	movei	#OBJECTSIZE,r3          ; OBJECTSIZE     EQU 60
	add	r3,r11
	subq	#1,r12		;loopcounter--
	cmpq	#0,r12
	jump	NE,(r13) 	;goto .loop
	nop

;	movei	#0,r0
;	storew	r0,(r18)	;schreibe 0 in run_ani
.ende:



text_routine:
LETTER_WIDTH	EQU	8
LETTER_HEIGHT	EQU	8
;40 zeichen in x richtung
;30 zeichen in y richtung
;quell bild 744*8

;r11 = zielbild
;r12 = farbe
;r13 = message
;r14 = letter buffer
;r15 = quellbild
;r19 = text list
;r20 = .ende
;r21 = x
;r22 = y
;r23 = offset
;r24 = destination picture
movei	#0,r11
movei	#0,r12
movei	#0,r13
movei	#0,r14
movei	#0,r15
movei	#0,r16
movei	#0,r17
movei	#0,r18
movei	#0,r19
movei	#0,r20
movei	#0,r21
movei	#0,r22
movei	#0,r23
movei	#0,r24

movei	#.ende,r20
movei	#gpu_text,r0   ;text message
load	(r0),r19

.get_message:
;check if there is text (if message = 0 then .ende)
load	(r19),r13
cmpq	#0,r13
jump	EQ,(r20);.ende
nop
;r13 = message
move	r19,r0
addq	#TEXTCOLOR,r0
movei	#0,r12
loadw	(r0),r12
;r12 = farbe

move	r19,r0
addq	#TEXTX,r0
movei	#0,r21
loadw	(r0),r21
;X pos
move	r19,r0
addq	#TEXTY,r0
movei	#0,r22
loadw	(r0),r22
;Y pos

move	r19,r0
addq	#DESTINATION,r0
movei	#0,r24
load	(r0),r24
;destination pos

.message:
movei	#0,r14
loadb	(r13),r14       ;message data, first byte to r14

movei	#.next_text,r0
cmpq	#0,r14
jump	EQ,(r0);.ende	;check if 1st byte is 0 if true --> ende
nop

;///////////////////////////
;ENTER CHECK
cmpq	#1,r14
jr	NE,.go_on1
nop
addq	#1,r22	;nchste Zeile

move	r19,r0
addq	#TEXTX,r0
movei	#0,r1
loadw	(r0),r1
move	r1,r21	;anfang der Zeile

addq	#1,r13 ;nchstes Zeichen
movei	#.message,r2
jump	(r2)
nop
.go_on1:
;///////////////////////////
;SPACE CHECK
movei	#32,r0
movei	#.message,r2
cmp	r0,r14
jr	NE,.go_on2
nop
addq	#1,r21
addq	#1,r13
jump	(r2)
nop
.go_on2:
;///////////////////////////
;CALCULATE OFFSET IN SOURCE

;R14 = byte of message
movei	#33,r0
movei	#font,r15;user_memory+MEM_FONT,r15	;source image
sub	r0,r14
shlq	#1,r14	;*2
shlq	#2,r14  ;*4 = letter width (*8)
shlq	#1,r14 *2 wegen 16-bit
add	r14,r15
;/////////////////////////////////
;CALCULATE OFFSET IN DESTINATION
;320*y+x
;movei	#user_memory+MEM_TXT_IMAGE,r11
move	r24,r11
;r11 = zielbild

movei	#320,r0
move	r22,r1
move	r21,r3
;shlq	#1,r0
shlq	#1,r1
shlq	#2,r1
shlq	#1,r3
shlq	#2,r3
imult	r0,r1
add	r3,r1
shlq	#1,r1
move	r1,r23
add	r23,r11

;///////////////////////////
;COPY LETTER
movei	#LETTER_HEIGHT,r1
movei	#LETTER_WIDTH,r0
movei	#.copy1,r5

.copy1:
loadw	(r15),r6
cmpq	#0,r6
jr	EQ,.next_pixel
nop

storew	r12,(r11)
.next_pixel:
addq	#2,r11
addq	#2,r15
subq	#1,r0
cmpq	#0,r0
jump	NE,(r5);.copy1
nop

movei	#((320-8)*2),r2
movei	#((744-8)*2),r3
movei	#LETTER_WIDTH,r0
add	r2,r11
add	r3,r15
subq	#1,r1
cmpq	#0,r1
jump	NE,(r5);.copy1
nop

.next_letter:
addq	#1,r21
;////////////////
;NEXT LETTER
addq	#1,r13
movei	#.message,r2
jump	(r2)
nop
;///////////////
;NEXT TEXT
.next_text:
move	r19,r0
addq	#NEXTTEXT,r0
movei	#gpu_text,r1
store	r0,(r1)
.ende:










;****************************************************************
;*	  ______                                                *
;*	 / ____ \                                               *
;*	| /    \_\                                              *
;*	| | \   _                                               *
;*	\  \/\_/ /                                              *
;*	 \_/___  \                                              *
;*	  /    \  \                                             *
;*	__     |  |                                             *
;*	\ \___/  /                                              *
;*	 \______/                                               *
;*                                                             	*
;* Copyright 2002 Starcat Developments				*
;* [ http://www.starcat-dev.de ]				*
;*   Programmed by Lars Hannig					*
;*								*
;*		G P U    O B J E C T    B U I L D		*
;*								*
;****************************************************************
;GPU OBJECT LIST BUILD
gpu_build:
; GPU luft auf Registerbank 1
        movei	#G_FLAGS,r17
        load	(r17),r18
        bset	#3,r18			; Keine Interrupts bitte
        bclr	#14,r18
        store	r18,(r17)

; Stackpointer setzen
	movei	#$f03f00,r31
	moveta	r31,r31

gpu_op_liste:
        movei   #OBJECTSIZE,r3;#OBJSIZE,r3             ; Gre eines Objects in Byte (am Ende steht man auf O_SCALE, also nur noch Differenz zur eigentl. Lnge addieren)
        movei   #gpu_obj_data,r0        ; Adresse Daten fr OP-Liste
	load	(r0),r11		; Adresse laden
        movei   #olist_ram,r0           ; Adresse Kopie OP-Liste im RAM
	load	(r0),r12		; Adresse laden
	move	r12,r7			; Adresse OP-Liste retten
	shrq	#3,r7			; geteilt / 8 fr OP
        movei   #anz_objects,r0         ; Adresse Anzahl Objecte
	loadw	(r0),r6			; Anzahl Objecte laden
        movei   #gpu_a_vdb,r0           ; Adresse Y-Pos erste Bildschirmzeile
        load    (r0),r26                ; Y-Pos erste Bildschirmzeile
	move	r11,r13			; Kopie Adresse Daten fr OP-Liste
        movei   #gpu_proc_obj,r5        ; Sprungadresse fr Zhlschleife
        movei   #gpu_next_obj,r4        ; Sprungadresse fr Object Check
        movei   #gpu_proc_obj3,r17      ; Sprungadresse
	movei	#$FFFF0000,r18		; Variable um Zahl negativ zu machen
	movei	#32768,r19		; Variable fr Check ob Zahl negativ ist
        movei   #$ff,r20                ; Byte ausmaskieren
        movei   #$ffff,r21              ; Wort ausmaskieren
        movei   #$7ff,r22               ; um O_YPOS zu ermitteln
	moveq	#$f,r23			; um O_IWIDTH zu ermitteln
	movei	#$fff,r24		; Um O_XPOS zu ermitteln
	moveq	#4,r25			; fr STOP Object

; **** PHRASE 1	******************
gpu_proc_obj:
;***************************************
;NEW
	move	r11,r0
	movei	#ACTIVE,r2
	add	r2,r0
	movei	#0,r2
	loadw	(r0),r2
	cmpq	#0,r2
	jump	EQ,(r4)
	nop
;***************************************
	addq	#O_TYPE,r11		; Adresse auf O_TYPE setzen
        loadb   (r11),r2		; O_TYPE laden
        cmpq    #5,r2                   ; Ist Object aktiv ? (5 = nein)
        jump    EQ,(r4)                 ; Nein, weiter mit nchstem Object

; Object Daten
gpu_proc_obj1:
	subq	#O_TYPE-O_DATA,r11	; Adresse auf O_DATA setzen
        load    (r11),r0	 	; Adresse der Spritedaten

	addq	#O_DWIDTH-O_DATA,r11	; Adresse auf O_DWIDTH setzen
	loadw	(r11),r28		; Breite in Phrases laden

	move	r26,r27			; Y-Pos erste Bildschirmzeile retten
	subq	#O_DWIDTH-O_YPOS,r11	; Adresse auf Y-Pos setzen
	loadw	(r11),r30		; Y-Pos Objekt laden

; Check ob Y-Pos negativ ist
gpu_proc_obj1_0:
	cmp	r19,r30			; Ist Y-Pos negativ
        jr      CS,gpu_proc_obj1_1      ; Nein
	nop
	or	r18,r30			; Y-Pos negativ machen

gpu_proc_obj1_1:
	sub	r30,r27			; halbe Bildschirmzeilen auserhalb sichtbarem Bereich
        jr      PL,gpu_proc_obj2
	nop
	moveq	#0,r27			; keine Bildschirmzeilen auserhalb sichtbarem Bereich
        jr      T,gpu_proc_obj3
	nop
gpu_proc_obj2:
        move    r26,r30                 ; Y-Pos auf 1 sichtbare Zeile
        shrq	#1,r27			; ganze Bildschirmzeilen auserhalb sichtbarem Bereich
	shlq	#3,r28			; Breite in Phrases * 8 Byte pro Phrase
	mult	r27,r28			; Bildschirmzeilen auserhalb * Bytes pro Zeile
	add	r28,r0			; nicht sichtbare Bytes bergehen
gpu_proc_obj3:
        shrq    #3,r0           	; Adresse / 8
        shlq    #11,r0          	; Platz fr Link Pointer schaffen

; Link Pointer fr nchstes Object setzen
        addq    #4,r7	          	; nchstes Object ist 4 Phrases weiter
        move    r7,r1	          	; Adresse in Object Liste fr nchstes Object

        shrq    #8,r1                   ; rechte 8 Bits ins nchste Langwort
        or      r1,r0           	; OR mit Data Pointer
        store   r0,(r12)        	; 1 Langwort Phrase 1 sichern
	addq	#4,r12			; Adresse anpasssen

	move	r7,r0			; Adresse Link Pointer
	and	r20,r0			; 1 Byte ausmaskieren
	shlq	#10,r0			; 10 Bits verschieben fr O_HEIGHT

; Hhe setzen
	addq	#O_HEIGHT-O_YPOS,r11	; Adresse auf O_HEIGHT setzen
	cmpq	#1,r2			; Scaled Bitmap Objekt?
        jr      NE,gpu_proc_obj4        ; Nein
	loadw	(r11),r1		; Object Hhe laden
	subq	#1,r1			; Extra Zeile am unteren Rand bei Scaled Bitmap Objekt
gpu_proc_obj4:
	sub	r27,r1			; Hhe - nicht sichtbare Zeilen
        jr      PL,gpu_proc_obj5        ; Weiter sol. Hhe nicht negativ
	nop
	moveq	#0,r1			; Hhe auf 0 setzen
gpu_proc_obj5:
	and	r21,r1			; 1 Wort ausmaskieren
	or	r1,r0			; OR mit Link Pointer
        shlq    #11,r0                  ; 11 Bits verschieben fr O_YPOS

; Y-Pos setzen
	and	r22,r30			; Nur 11 Bits fr Y-Pos benutzen
	or	r30,r0			; OR mit Link Pointer und Hhe
	shlq	#3,r0			; 3 Bits verschieben fr O_TYPE

; O-Type setzen
	or	r2,r0			; OR mit Object Type
	store	r0,(r12)		; 2 Langwort Phrase 1 schreiben
	addq	#4,r12			; Adresse anpasssen

; **** PHRASE 2	******************
; O-Firstpix setzen
	addq	#O_FIRSTPIX-O_HEIGHT,r11 ; Adresse O_FIRSTPIX laden
	loadb	(r11),r0		; Object Firstpix laden
	shlq	#4,r0			; 4 Bits verschieben

; Object Flags setzen
	subq	#O_FIRSTPIX-O_FLAGS,r11	; Adresse O_FLAGS setzen
	loadb	(r11),r1		; Object Flags laden
	or	r1,r0			; OR mit Object Flags
	shlq	#7,r0			; 7 Bits verschieben fr INDEX

; Object Index setzen
	addq	#O_INDEX-O_FLAGS,r11	; Adresse O_INDEX setzen
	loadb	(r11),r1		; Object Index laden
	or	r1,r0			; OR mit Object Index
	shlq	#6,r0			; 6 Bits verschieben

; Object Breite setzen
	subq	#O_INDEX-O_IWIDTH,r11	; Adresse O_IWIDTH setzen
	loadw	(r11),r1		; Object Breite laden
	move	r1,r2			; Object Breite merken
	shrq	#4,r1			; 4 Bits gehen ins nchtse Langwort
	or	r1,r0			; OR

;
; Nur aktivieren wenn Objekte kopiert werden, und auf
; $00000004 als Endekennung abgefragt wird.
; sonst kann Kopierroutine abbrechen
;        bset    #31,r0

	store	r0,(r12)		; 1 Langwort Phrase 2 schreiben
	addq	#4,r12			; Adresse anpasssen
	and	r23,r2			; unterste 4 Bits von O_IWIDTH
	shlq	#10,r2			; 10 Bits verschieben fr O_DWIDTH

; Object Breite 2 setzen
	subq	#O_IWIDTH-O_DWIDTH,r11	; Adresse O_DWIDTH setzen
	loadw	(r11),r0		; Object Breite 2 laden
	or	r2,r0			; OR mit O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr PITCH

; Object Pitch setzen
	addq	#O_PITCH-O_DWIDTH,r11	; Adresse O_PITCH setzen
	loadb	(r11),r1		; Object Pitch laden
	or	r1,r0			; OR mit O_IWIDTH und O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr O_DEPTH

; Object Depth setzen
	subq	#O_PITCH-O_DEPTH,r11	; Adresse O_DEPTH setzen
	loadb	(r11),r1		; Object Depth laden
	or	r1,r0			; OR mit O_IWIDTH, O_DWIDTH und O_PITCH
	shlq	#12,r0			; 12 Bits verschieben fr O_XPOS

; Object X-Pos setzen
	subq	#O_DEPTH-O_XPOS,r11	; Adresse O_XPOS setzen
	loadw	(r11),r1		; Object X-Pos laden
	and	r24,r1			; Nur 12 Bits fr O_XPOS benutzen
	or	r1,r0			; OR
	store	r0,(r12)		; 2 Langwort Phrase 2 schreiben
	addq	#8,r12			; Adresse anpasssen (+8 wegen O_SCALE)

; **** PHRASE 3	******************
	addq	#O_SCALE-O_XPOS,r11	; Adresse O_SCALE setzen
	load	(r11),r0		; Object Scale laden
	store	r0,(r12)		; Object Scale schreiben
	addq	#12,r12			; Adresse anpassen

gpu_next_obj:
	add	r3,r13			; Auf nchstes Object setzen (+ OBJSIZE)
	subq	#1,r6			; Anzahl Objecte - 1
	jump	NE,(r5)			; Wiederholen sol. > 0
	move	r13,r11			; Arbeitsregister wiederherstellen

; STOP Object am Ende der Liste schreiben
	addq	#4,r12			; Adresse anpassen
	store	r25,(r12)		; Object Type 4 (STOP OBJECT) schreiben

;***********************************************************************************
;***********************************************************************************

;hier GPU stoppen!

        moveq #0,r30
        movei #G_CTRL,r31
        store r30,(r31)

GPU_END:

.IF GPU_END-GPU_START > 4096
    .PRINT "GPU Programm zu gross !"
    .PRINT GPU_END
    .FAIL
.ENDIF

        .68000
GPU_OP_end:

