;**********************************************************************
;**  call_depack - loads depack code into GPU and runs it            **
;**  d0 = source  d1 = destination                                   **
;**********************************************************************
        .text
        .68000

ice_depack:
        move.l  #0,G_CTRL      ;F02114  ; Make sure the GPU is stopped
        move.l  #0,G_FLAGS     ;F02100  ; and in the right mode
        move.l  #$70007,G_END  ;F0210C  ;

        move.l  #Ice_Depack,a0          ; Get the address of the GPU code
        move.l  #G_RAM+$800,a1 ;F03800  ; Get destination address
        move.l  a1,a6                   ; Gpu Base

        swap    d0
        swap    d1

        move.l  #End_Ice_Depack,d7      ; and calculate length of GPU code
        sub.l   #Start_Ice_Depack,d7
        asr.l   #2,d7                   ; divide by 4 since we're copying long
loop1:
        move.l  (a0)+,(a1)+             ; actually copy the code...
        dbra    d7,loop1

        move.l  d0,8(a6)                ; in gpu code
        move.l  d1,16(a6)               ; in gpu code
        move.l  #0,orig_length(a6)      ; in gpu code

        move.l  #G_RAM+$800,G_PC ;F02110; GPU Program counter gets $00f03000

        move.l  #$1,G_CTRL     ;F02114  ; Set the GPU going

wait1:  cmp.l   #0,orig_length(a6)
        beq.s   wait1
.exit:  rts

orig_length     .EQU    608

;**********************************************************************
;**  Ice Depack code - GPU                                           **
;**                                                                  **
;**********************************************************************

        .gpu

        include "mike.inc"

        .phrase

Ice_Depack::
        .org     $f03800

Start_Ice_Depack::
        movei   #MyStack,S_P
Source_add::
        movei   #$12345678,A_0
        nop
Dest_add::
        movei   #$12345678,A_1
        load    (A_0),D_0       ; bsr.s getinfo
        addq    #4,A_0          ;
        movei   #'ICE!',Junk    ; cmpi.l #'ICE!',d0
        nop
        cmp     Junk,D_0        ;
        movei   #Unpacked,Junk  ; bne not_packed
        jump    NE,(Junk)       ;
        nop

; get packed length
        load    (A_0),D_0       ; bsr.s getinfo
        addq    #4,A_0          ;

        move    D_0,A_5         ; lea.l -8(a0,d0.l),a5
        add     A_0,A_5         ;
        subq    #8,A_5          ;

        load    (A_0),Orig_Len  ; bsr.s getinfo
        nop
        move    Orig_Len,D_0
        addq    #4,A_0
        move    A_1,A_4
        move    A_1,A_6
        add     D_0,A_6
;
; Set up a few things
;
        movei   #$ff,mask1
        movei   #$ffff0000,mask2
        movei   #Get_D0_Bits,D0_BITS
        subq    #1,A_5          ;
        loadb   (A_5),D_7       ; move.b -(a5),d7
        rorq    #8,D_7          ; Make into 32bit!!

        JSR     Normal_Bytes    ; bsr normal_bytes

Normal_Bytes::
        Get1Bit frig1
frig1::
        BCC     Test_If_End     ; bcc.s test_if_end
        moveq   #0,D_1          ; moveq.l #0,d1
        Get1Bit frig2           ; bsr.s   get_1_bit
frig2::
        BCC     Copy_Direkt
        movei   #Direct_Tab+20,A_1   ;  lea.l   direkt_tab+20(pc),a1
        moveq   #4,D_3
Nextgb::
        subq    #4,A_1          ; move.l  -(a1),d0
        load    (A_1),D_0       ;
        move    D_0,D_4         ;
        and     mask1,D_0       ;

        JSR_D0_Bits             ; bsr.s   get_d0_bits
        move    D_4,D_0
        and     mask2,D_0
        SWAP    D_0
        cmp     D_0,D_1

        jr      NE,No_More
        nop
        DBF     D_3,Nextgb


No_More::
        move    A_1,r14         ; add.l   20(a1),d1
        load    (r14+(20/4)),Junk
        add     Junk,D_1

Copy_Direkt::
        subq    #1,A_5          ; move.b  -(a5),-(a6)
        subq    #1,A_6          ;
        loadb   (A_5),Junk      ;

        subq    #1,D_1          ; dbf     d1,copy_direkt  ; noch ein Byte
        jr      PL,Copy_Direkt  ;
        storeb  Junk,(A_6)      ;

Test_If_End::
        cmp     A_4,A_6         ; cmpa.l  a4,a6
        BHI     Strings
; Bomb out!!
Unpacked::
        movei   #Orig_Length,Junk
        store   Orig_Len,(Junk)
        nop
        nop
        movei   #0,R30
        movei   #$00f02114,R31
        store   R30,(R31)

        nop
        nop
;
        nop
        nop
        nop
        nop
        nop
        nop

        .phrase
Get_D0_Bits::
        moveq   #0,D_1
Hole_Bit_Loop:
        add     D_7,D_7
        jr      NE,On_D0
        nop
        subqt   #1,A_5
        loadb   (A_5),D_7
        addc    D_7,D_7
        rorq    #9,D_7          ; Dont ask!
        shlq    #1,D_7          ; !!!!!!!!!
On_D0:  addc    D_1,D_1
        subq    #1,D_0
        jr      PL,Hole_Bit_Loop
        nop
        D0_RTS

Strings::
        nop
        movei   #Length_Tab,A_1
        moveq   #3,D_2
Get_Length_Bit::
        Get1Bit frig3
frig3::
        jr      CC,No_Length_Bit
        nop
        DBF     D_2,Get_Length_Bit
No_Length_Bit::

        moveq   #1,Junk
        xor     D_4,D_4
        add     D_2,Junk
        move    D_4,D_1
        shlq    #2,Junk
        add     A_1,Junk

        load    (Junk),D_0
        rorq    #8,D_0
        jr      MI,No_Uber
        nop
Get_Uber::
        rorq    #24,D_0
        JSR_D0_Bits
No_Uber::
        moveq   #6,Junk
        add     D_2,Junk
        shlq    #2,Junk
        add     A_1,Junk
        load    (Junk),D_4

        add     D_1,D_4
        BEQ     Get_Offset_2
        movei   #More_Offset,A_1
        moveq   #1,D_2
getoffs::
        Get1Bit frig4
frig4::
        BCC     .Crap
        DBF     D_2,getoffs
.Crap:
        movei   #Depack_Bytes,D_6
        xor     D_1,D_1
        move    D_2,Junk
        addq    #1,Junk
        shlq    #2,Junk

        add     A_1,Junk

        load    (Junk),D_0

        JSR_D0_Bits

        shlq    #2,D_2
        move    A_1,Junk
        addq    #24,D_2
        add     D_2,Junk

        load    (Junk),D_5
        add     D_5,D_1
        jump    PL,(D_6)
        nop
        sub     D_4,D_1
        jump    (D_6)
        nop
Get_Offset_2:
        xor     D_1,D_1
        moveq   #5,D_0
        movei   #-1,D_2
        Get1Bit frig5
frig5::
        jr      CC,Less_40
        nop
        moveq   #8,D_0
        movei   #$3f,D_2
Less_40::
        JSR_D0_Bits
        add     D_2,D_1

Depack_Bytes::
;
; All interleaved as well!!
;
        move    A_6,A_1
        addq    #1,D_1
        add     D_4,A_1
        subq    #1,A_6
        add     D_1,A_1
        movei   #Normal_Bytes,D_6
        loadb   (A_1),Junk
        storeb  Junk,(A_6)


Dep_B:: subq    #1,A_1
        subq    #1,A_6
        loadb   (A_1),Junk


        subq    #1,D_4          ;
        jr      PL,Dep_B        ; This is a DBF with some nice code optimisation!
        storeb  Junk,(A_6)      ;


        jump    (D_6)
        nop

        .phrase

Orig_Length::   dc.l    0
Direct_Tab::    dc.l    $7fff000e,$00ff0007
                dc.l    $00070002,$00030001
                dc.l    $00030001
                dc.l    270-1,15-1,8-1,5-1,2-1
        .phrase
Length_Tab::    dc.l    9,1,0,-1,-1
                dc.l    8,4,2,1,0
        .phrase
More_Offset::   dc.l    $0000000b,$00000004,$00000007,$00000000
                dc.l    $00000000,$0000011f,$ffffffff,$0000001f
        .phrase
                dcb.l   20,0
MyStack::       dc.l    0


End_Ice_Depack::
;**********************************************************************
;**  The End                                                         **
;**                                                                  **
;**********************************************************************
        .68000
