;****************************************************************
;*	  ______                                                *
;*	 / ____ \                                               *
;*	| /    \_\                                              *
;*	| | \   _                                               *
;*	\  \/\_/ /                                              *
;*	 \_/___  \                                              *
;*	  /    \  \                                             *
;*	__     |  |                                             *
;*	\ \___/  /                                              *
;*	 \______/                                               *
;*                                                             	*
;* Copyright 2002 Starcat Developments				*
;* [ http://www.starcat-dev.de ]				*
;*   Programmed by Lars Hannig					*
;*								*
;*  	                    INCLUDES                           *
;*                                                             *
;***************************************************************
;JOYPAD EQUALS
JOY_UP		EQU	20		;joypad
JOY_DOWN	EQU	21
JOY_LEFT	EQU	22
JOY_RIGHT	EQU	23

FIRE_A		EQU	29		;fire buttons
FIRE_B		EQU	25
FIRE_C		EQU	13

;PRO CONTROLLER SUPPORT
;******************************
FIRE_X          EQU     1
FIRE_Y          EQU     5
FIRE_Z          EQU     17
FIRE_L          EQU     18
FIRE_R          EQU     2
;******************************
OPTION		EQU	9
PAUSE		EQU	28

KEY_STAR	EQU	16		;keypad
KEY_7           EQU     17
KEY_4           EQU     18
KEY_1		EQU	19

KEY_0		EQU	4
KEY_8           EQU     5
KEY_5		EQU	6
KEY_2		EQU	7

KEY_HASH	EQU	0
KEY_9           EQU     1
KEY_6           EQU     2
KEY_3		EQU	3

;************************************************************************
;TEXT ROUTINE DECLARATIONS	(Don't modify)
MESSAGE		EQU	0
DESTINATION	EQU	4
TEXTCOLOR	EQU	8
TEXTX		EQU	10
TEXTY		EQU	12
DUMMY_TXT	EQU	14
NEXTTEXT	EQU	16
;************************************************************************

;************************************************************************
;ANIMATION DECLARATIONS (Don't modify)
ANI_DATA	EQU	0	;l
ANI_WIDTH	EQU	4	;w
ANI_HEIGHT	EQU	6	;w
ANI_DEPTH	EQU	8	;b
ANI_SPEED	EQU	9	;b
ANI_SPEED_COUNTER EQU	10	;w
ADDRESS_NEXT_ANI EQU	12	;l
NEXT_ANI	EQU	16
;************************************************************************

;************************************************************************
;SCALING DECLARATIONS (Don't modify)
SCL_X		EQU	0
SCL_Y		EQU	1
MAX_SCL_X	EQU	2
MAX_SCL_Y	EQU	3
SCL_DX		EQU	4
SCL_DY		EQU	8
NEXT_SCL	EQU	12
NEXT_SCALE_OBJ	EQU	16
;************************************************************************



;*********** VIDEO ***********************************************
vclk		equ	376
horiz_per	equ	317778
sync_per	equ	46050
eq_per		equ	23500
front_porch	equ	17450
line_blank	equ	109500
disp_width	equ	1381					;(pixel width + 1) * 3
disp_height	equ	226					;this is in lines

; Horizontal computations
n_hp		equ	horiz_per/vclk
n_hbb		equ	((horiz_per-sync_per-front_porch)/vclk)+$400
n_hbe		equ	(line_blank-sync_per-front_porch)/vclk
n_hs		equ	((horiz_per-sync_per)/vclk)+$400
n_hvs		equ	(horiz_per-(2*sync_per))/vclk
n_heq		equ	(horiz_per-eq_per)/vclk
n_hde		equ	((disp_width/2)-1)+$400
n_hdb1		equ	((n_hp)-(disp_width/2))
n_hdb2		equ	n_hdb1

n_vp		equ	523
n_vee		equ	6
n_vbe		equ	40
n_vdb		equ	n_vbe+4
n_vde		equ	n_vdb+(disp_height*2)
n_vbb		equ	n_vde+40
n_vs		equ	n_vp-10
n_veb		equ	n_vs-n_vee

SCRN_TOP	equ	n_vdb				;ypos of first line at top of screen
SCRN_BOTTOM	equ	n_vde				;xpos of first line below screen

; Offset Definitionen fr Object Processor
O_XPOS          EQU 0
O_YPOS          EQU 2
O_DATA          EQU 4
O_HEIGHT        EQU 8
O_DWIDTH        EQU 10
O_IWIDTH        EQU 12
O_FLAGS         EQU 14
O_FIRSTPIX      EQU 15
O_TYPE          EQU 16
O_DEPTH         EQU 17
O_PITCH         EQU 18
O_INDEX         EQU 19
O_SCALE         EQU 20
O_XSCAL         EQU 22
O_YSCAL         EQU 23
OBJSIZE		EQU 24			; Gre eines Objektes in Byte

;************************************************************************
;************************************************************************
; OBJECT DECLARATIONS
XPOS		EQU 0
YPOS		EQU O_YPOS
DATA		EQU O_DATA
HEIGHT		EQU O_HEIGHT
WIDTH		EQU O_DWIDTH
WIDTH_OFFS	EQU O_IWIDTH
FLAGS		EQU O_FLAGS
OBJTYPE		EQU O_TYPE
DEPTH		EQU O_DEPTH
YSCAL		EQU O_XSCAL
XSCAL		EQU O_YSCAL

ACTIVE		EQU	XSCAL+1		;w	;RESERVED
KIND		EQU	ACTIVE+2	;b
HITS		EQU	KIND+1		;b
REAL_WIDTH	EQU	HITS+1		;w
REAL_HEIGHT	EQU	REAL_WIDTH+2	;w
D_X		EQU	REAL_HEIGHT+2	;w
D_Y		EQU	D_X+2		;w
FREE1		EQU	D_Y+2		;w
FREE2		EQU	FREE1+2		;w
FREE3		EQU	FREE2+2		;w
FREE4		EQU	FREE3+2		;w
FREE5		EQU	FREE4+2		;w
FREE6		EQU	FREE5+2		;b
SCALE_COUNTER	EQU	FREE6+1		;b	;RESERVED
ANIMATION	EQU	SCALE_COUNTER+1 ;l	;RESERVED
SCALING		EQU	ANIMATION+4	;l	;RESERVED

ADDITIONAL_OBJECT_DATA EQU	SCALING+4

OBJECTSIZE	EQU ADDITIONAL_OBJECT_DATA
;************************************************************************
	BASE	EQU	$f00000		; TOM Internal Register Base

G_RAM           EQU $F03000     ; GPU Internal RAM
D_RAM           EQU $F1B000     ; DSP Internal RAM
G_FLAGS         EQU $F02100     ; GPU PC und Status Register
D_FLAGS         EQU $F1A100     ; DSP PC und Status Register
G_MTXC          EQU $F02104     ; GPU
D_MTXC          EQU $F1A104     ; DSP
G_MTXA          EQU $F02108     ; GPU
D_MTXA          EQU $F1A108     ; DSP
G_END           EQU $F0210C     ; GPU
D_END           EQU $F1A10C     ; DSP
G_PC            EQU $F02110     ; GPU Program Counter
D_PC            EQU $F1A110     ; DSP Program Counter
G_CTRL          EQU $F02114     ; GPU
D_CTRL          EQU $F1A114     ; DSP
G_HIDATA        EQU $F02118     ; GPU
D_MOD           EQU $F1A118     ; DSP
G_DIVCTRL       EQU $F0211C     ; GPU
D_DIVCTRL       EQU $F1A11C     ; DSP
G_REMAIN        EQU $F0211C     ; GPU
D_REMAIN        EQU $F1A11C     ; DSP
D_MACHI         EQU $F1A120     ; DSP
GPUGO		EQU	$00000001	; Start and Stop the GPU
RISCGO		EQU	$00000001	; Start GPU or DSP
; TOM
MEMCON1         EQU $F00000     ; Memory Configuration 1
MEMCON2         EQU $F00002     ; Memory Configuration 2
INT1            EQU $F000E0     ; Interrupt Control INT1
INT2            EQU $F000E2     ; Interrupt Control INT2
PIT             EQU $F00050     ; Programmable Timer

; JERRY
JOYSTICK        EQU $F14000     ; Digital Joypad
JOYBUTS         EQU $F14002     ; Digital Joypad Buttons
ANAJOY          EQU $F17C00     ; Analog Joystick
R_DAC           EQU $F1A148     ; Right Digital Analog Converter
L_DAC           EQU $F1A14C     ; Left Digital Analog Converter
L_I2S		EQU	BASE + $1A148	; I2S Serial Interface
R_I2S		EQU	BASE + $1A14C	; I2S Serial Interface
SCLK            EQU $F1A150     ; Sampling Rate
SMODE           EQU $F1A154     ; Sound production
CLK1            EQU $F10010     ; Clock Register
CLK2            EQU $F10012     ; Video Clock frequence
CHRO_CLK        EQU $F10014     ; color DAC
JPIT            EQU $F10000     ; Programmable Timer
ASIDATA         EQU $F10030     ; Network Receive
ASICTRL         EQU $F10032     ; Network Control
ASICLK          EQU $F10034     ; Network Transfer Speed

; VIDEO

NTSC_WIDTH	EQU	1409		; Width of screen in pixel clocks
NTSC_HMID	EQU	823		; Middle of screen in pixel clocks
NTSC_HEIGHT	EQU	241		; Height of screen in scanlines
NTSC_VMID	EQU	266		; Middle of screen in halflines

PAL_WIDTH	EQU	1381		; Same as above for PAL...
PAL_HMID	EQU	843
PAL_HEIGHT	EQU	287
PAL_VMID	EQU	322

CONFIG		EQU	BASE + $14002	; Also has NTSC/PAL
VMODE           EQU $F00028     ; Video Processing
BG              EQU $F00058     ; Linebuffer
BORD1           EQU $F0002A     ; Border Color
HP              EQU $F0002E     ; Cyles in a Halfline
HBB             EQU $F00030     ; Begin Horizontal Blank
HBE             EQU $F00032     ; End Horizontal Blank
HS              EQU $F00034     ; HSYNC Signal
HVS             EQU $F00036     ; VSYNC Signal
HDB1            EQU $F00038     ; Linebuffer 1
HDB2            EQU $F0003A     ; Linebuffer 2
HDE             EQU $F0003C     ; Cycle Number
HEQ             EQU $F00054     ; EQ Signal
VP              EQU $F0003E     ; Number of Scanlines
VBB             EQU $F00040     ; Start of vertical Blanking
VBE             EQU $F00042     ; End of vertical Blanking
VS              EQU $F00044     ; Start of VSYNC
VDB             EQU $F00046     ; Display Begin
VDE             EQU $F00048     ; Display End
VEB             EQU $F0004A     ; Begin equalization Section
VEE             EQU $F0004C     ; End equalization Section
GENLOCK         EQU $F00026     ; Genlocking
CLUT            EQU $F00400     ; Color Lockup Table
HC              EQU $F00004     ; Active Linebuffer
VC              EQU $F00006     ; Current Scanline being processed
VI              EQU $F0004E     ; VC Register
LPH             EQU $F00008     ; Horizontal latch for light Gun
LPV             EQU $F0000A     ; Vertical latch value for light Gun
LBUFA           EQU $F00800     ; Actuall Adress Linebuffer 1
LBUFB           EQU $F01000     ; Actuell Adress Linebuffer 2

; BLITTER
B_STATUS        EQU $F02238     ; Blitter Status
B_CMD		EQU $F02238	; Blitter Control
B_COUNT         EQU $F0223C     ; Blitter
B_IINC          EQU $F02274     ; Blitter in Pixelmode
B_I3		EQU $F0227C	; Blitter in Phrasemode
B_I2		EQU $F02280	; Blitter in Phrasemode
B_I1		EQU $F02284	; Blitter in Phrasemode
B_I0		EQU $F02288	; Blitter in Phrasemode
B_ZINC		EQU $F02274	; Blitter in Pixelmode
B_Z3            EQU $F0228C     ; Blitter in Phrasemode
B_Z2            EQU $F02290     ; Blitter in Phrasemode
B_Z1            EQU $F02294     ; Blitter in Phrasemode
B_Z0            EQU $F02298     ; Blitter in Phrasemode
B_DSTD          EQU $F02248     ; Blitter
B_SRCD          EQU $F02240     ; Blitter
B_STOP          EQU $F02278     ; Blitter
B_PATD		EQU $F02268	; Blitter
A1_BASE         EQU $F02200     ; Blitter
A1_FLAGS        EQU $F02204     ; Blitter
A1_CLIP         EQU $F02208     ; Blitter
A1_PIXEL        EQU $F0220C     ; Blitter
A1_FPIXEL       EQU $F02218     ; Blitter
A1_INC          EQU $F0221C     ; Blitter
A1_FINC         EQU $F02220     ; Blitter
A1_STEP         EQU $F02210     ; Blitter
A1_FSTEP        EQU $F02214     ; Blitter
A2_BASE         EQU $F02224     ; Blitter
A2_FLAGS        EQU $F02228     ; Blitter
A2_PIXEL        EQU $F02230     ; Blitter
A2_MASK         EQU $F0222C     ; Blitter
A2_STEP         EQU $F02234     ; Blitter

; OBJECT PROCESSOR (OP)
OLP             EQU $F00020     ; Adresse Object List
OB              EQU $F00010     ; Not what you think, it's the Object Data
OBF             EQU $F00026     ; OP
BRANCHOBJ	EQU 3


BITOBJ		EQU	0
SCBITOBJ	EQU	1
GPUOBJ		EQU	2
STOPOBJ		EQU	4

O_REFLECT	EQU	$00002000	; OR with top LONG of BITMAP object
O_RMW		EQU	$00004000
O_TRANS		EQU	$00008000
O_RELEASE	EQU	$00010000

O_DEPTH1	EQU	(0<<12)	; DEPTH Field for BITMAP objects
O_DEPTH2	EQU	(1<<12)
O_DEPTH4	EQU	(2<<12)
O_DEPTH8	EQU	(3<<12)
O_DEPTH16	EQU	(4<<12)
O_DEPTH32	EQU	(5<<12)

O_NOGAP		EQU	(1<<15)	; Phrase GAP between image phrases
O_1GAP		EQU	(2<<15)
O_2GAP		EQU	(3<<15)
O_3GAP		EQU	(4<<15)
O_4GAP		EQU	(5<<15)
O_5GAP		EQU	(6<<15)
O_6GAP		EQU	(7<<15)

O_BREQ		EQU	(0<<14)	; CC field of BRANCH objects
O_BRGT		EQU	(1<<14)
O_BRLT		EQU	(2<<14)
O_BROP		EQU	(3<<14)
O_BRHALF	EQU	(4<<14)

O_STOPINTS	EQU	$00000008	; Enable Interrupts in STOP object

; Sonstige
VIDTYPE		EQU	$10
LEVEL0		EQU	$100		; 68000 Level 0 Autovector Interrupt
LEVEL2          EQU $0100       ; Interrupt Adresse
ENDRAM		EQU $200000	; Ende DRAM
INITSTACK	EQU ENDRAM-4	; Start Stack

; BLITTER Kommandos
SRCEN		EQU $00000001	; d00:     source data read (inner loop)
SRCENZ		EQU $00000002	; d01:     source Z read (inner loop)
SRCENX		EQU $00000004	; d02:     source data read (realign)
DSTEN		EQU $00000008	; d03:     dest data read (inner loop)
DSTENZ		EQU $00000010	; d04:     dest Z read (inner loop)
DSTWRZ		EQU $00000020	; d05:     dest Z write (inner loop)
CLIP_A1		EQU $00000040	; d06:     A1 clipping enable
UPDA1F		EQU $00000100	; d08:     A1 update step fraction
UPDA1		EQU $00000200	; d09:     A1 update step
UPDA2		EQU $00000400	; d10:     A2 update step
DSTA2		EQU $00000800	; d11:     reverse usage of A1 and A2
GOURD		EQU $00001000	; d12:     enable Gouraud shading
ZBUFF		EQU $00002000	; d13:     polygon Z data updates
TOPBEN		EQU $00004000	; d14:     intensity carry into byte
TOPNEN		EQU $00008000	; d15:     intensity carry into nibble
PATDSEL		EQU $00010000	; d16:     Select pattern data
ADDDSEL		EQU $00020000	; d17:     diagnostic
				; d18-d20: Z comparator inhibit
ZMODELT		EQU $00040000	; 	     source < destination
ZMODEEQ		EQU $00080000	;	     source = destination
ZMODEGT		EQU $00100000	;	     source > destination
				; d21-d24: Logic function control
LFU_NAN		EQU $00200000	; 	     !source & !destination
LFU_NA		EQU $00400000	; 	     !source &  destination
LFU_AN		EQU $00800000	; 	      source & !destination
LFU_A		EQU $01000000	; 	      source &  destination

CMPDST		EQU $02000000	; d25:     pixel compare pattern & dest
BCOMPEN		EQU $04000000	; d26:     bit compare write inhibit
DCOMPEN		EQU $08000000	; d27:     data compare write inhibit
BKGWREN		EQU $10000000	; d28:     data write back
BUSHI		EQU $20000000	; d29	   blitter priority
SRCSHADE	EQU $40000000	; d30:	   shade src data w/IINC value

; The following are ALL 16 possible logical operations of the LFUs
LFU_ZERO	EQU $00000000	; All Zeros
LFU_NSAND	EQU $00200000	; NOT Source AND NOT Destination
LFU_NSAD	EQU $00400000	; NOT Source AND Destination
LFU_NOTS	EQU $00600000	; NOT Source
LFU_SAND	EQU $00800000	; Source AND NOT Destination
LFU_NOTD	EQU $00A00000	; NOT Destination
LFU_N_SXORD	EQU $00C00000	; NOT (Source XOR Destination)
LFU_NSORND	EQU $00E00000	; NOT Source OR NOT Destination
LFU_SAD		EQU $01000000	; Source AND Destination
LFU_SXORD	EQU $01200000	; Source XOR Destination
LFU_D		EQU $01400000	; Destination
LFU_NSORD	EQU $01600000	; NOT Source OR Destination
LFU_S		EQU $01800000	; Source
LFU_SORND	EQU $01A00000	; Source OR NOT Destination
LFU_SORD	EQU $01C00000	; Source OR Destination
LFU_ONE		EQU $01E00000	; All Ones

; These are some common combinations with less boolean names
LFU_REPLACE	EQU $01800000	; Source REPLACEs destination
LFU_XOR		EQU $01200000	; Source XOR with destination
LFU_CLEAR	EQU $00000000	; CLEAR destination

;
; BLITTER Flags (A1 or A2) register equates
;

; Pitch d00-d01:
;	distance between pixel phrases
PITCH1		EQU $00000000	; 0 phrase gap
PITCH2		EQU $00000001	; 1 phrase gap
PITCH4		EQU $00000002	; 3 phrase gap
PITCH3		EQU $00000003	; 2 phrase gap

; Pixel d03-d05
;	bit depth (2^n)
PIXEL1		EQU $00000000	; n = 0
PIXEL2		EQU $00000008	; n = 1
PIXEL4		EQU $00000010	; n = 2
PIXEL8		EQU $00000018	; n = 3
PIXEL16		EQU $00000020	; n = 4
PIXEL32		EQU $00000028	; n = 5

; Z offset d06-d08
;	offset from phrase of pixel data from its corresponding
;	Z data phrases
ZOFFS0		EQU $00000000	; offset = 0	UNUSED
ZOFFS1		EQU $00000040	; offset = 1
ZOFFS2		EQU $00000080	; offset = 2
ZOFFS3		EQU $000000C0	; offset = 3
ZOFFS4		EQU $00000100	; offset = 4
ZOFFS5		EQU $00000140	; offset = 5
ZOFFS6		EQU $00000180	; offset = 6
ZOFFS7		EQU $000001C0	; offset = 7	UNUSED

; Width d09-d14
;	width used for address generation
;	This is a 6-bit floating point value in pixels
;	4-bit unsigned exponent
;	2-bit mantissa with implied 3rd bit of 1
WID2		EQU $00000800	; 1.00 X 2^1  ( 4<<9)
WID4 		EQU $00001000	; 1.00 X 2^2  ( 8<<9)
WID6		EQU $00001400	; 1.10 X 2^2  (10<<9)
WID8		EQU $00001800	; 1.00 x 2^3  (12<<9)
WID10		EQU $00001A00	; 1.01 X 2^3  (13<<9)
WID12		EQU $00001C00	; 1.10 X 2^3  (14<<9)
WID14		EQU $00001E00	; 1.11 X 2^3  (15<<9)
WID16		EQU $00002000	; 1.00 X 2^4  (16<<9)
WID20		EQU $00002200	; 1.01 X 2^4  (17<<9)
WID24		EQU $00002400	; 1.10 X 2^4  (18<<9)
WID28		EQU $00002600	; 1.11 X 2^4  (19<<9)
WID32		EQU $00002800	; 1.00 X 2^5  (20<<9)
WID40		EQU $00002A00	; 1.01 X 2^5  (21<<9)
WID48		EQU $00002C00	; 1.10 X 2^5  (22<<9)
WID56		EQU $00002E00	; 1.11 X 2^5  (23<<9)
WID64		EQU $00003000	; 1.00 X 2^6  (24<<9)
WID80		EQU $00003200	; 1.01 X 2^6  (25<<9)
WID96		EQU $00003400	; 1.10 X 2^6  (26<<9)
WID112		EQU $00003600	; 1.11 X 2^6  (27<<9)
WID128		EQU $00003800	; 1.00 X 2^7  (28<<9)
WID160		EQU $00003A00	; 1.01 X 2^7  (29<<9)
WID192		EQU $00003C00	; 1.10 X 2^7  (30<<9)
WID224		EQU $00003E00	; 1.11 X 2^7  (31<<9)
WID256		EQU $00004000	; 1.00 X 2^8  (32<<9)
WID320		EQU $00004200	; 1.01 X 2^8  (33<<9)
WID384		EQU $00004400	; 1.10 X 2^8  (34<<9)
WID448		EQU $00004600	; 1.11 X 2^8  (35<<9)
WID512		EQU $00004800	; 1.00 X 2^9  (36<<9)
WID640		EQU $00004A00	; 1.01 X 2^9  (37<<9)
WID768		EQU $00004C00	; 1.10 X 2^9  (38<<9)
WID896		EQU $00004E00	; 1.11 X 2^9  (39<<9)
WID1024		EQU $00005000	; 1.00 X 2^10 (40<<9)
WID1280		EQU $00005200	; 1.01 X 2^10 (41<<9)
WID1536		EQU $00005400	; 1.10 X 2^10 (42<<9)
WID1792		EQU $00005600	; 1.11 X 2^10 (43<<9)
WID2048		EQU $00005800	; 1.00 X 2^11 (44<<9)
WID2560		EQU $00005A00	; 1.01 X 2^11 (45<<9)
WID3072		EQU $00005C00	; 1.10 X 2^11 (46<<9)
WID3584		EQU $00005E00	; 1.11 X 2^11 (47<<9)

; X add control d16-d17
;	controls the update of the X pointer on each pass
;	round the inner loop
XADDPHR		EQU $00000000	; 00 - add phrase width and truncate
XADDPIX		EQU $00010000	; 01 - add pixel size (add 1)
XADD0		EQU $00020000	; 10 - add zero
XADDINC		EQU $00030000	; 11 - add the increment

; Y add control	d18
;	controls the update of the Y pointer within the inner loop.
;	it is overridden by the X add control if they are in add increment
YADD0		EQU $00000000	; 00 - add zero
YADD1		EQU $00040000	; 01 - add 1

; X sign d19
;	add or subtract pixel size if X add control = 01 (XADDPIX)
XSIGNADD	EQU $00000000	; 0 - add pixel size
XSIGNSUB	EQU $00080000	; 1 - subtract pixel size

; Y sign d20
;	add or subtract pixel size if Y add control = 01 (YADD1)
YSIGNADD	EQU $00000000	; 0 - add 1
YSIGNSUB	EQU $00100000	; 1 - sub 1

