;****************************************************************
;*	  ______                                                *
;*	 / ____ \                                               *
;*	| /    \_\                                              *
;*	| | \   _                                               *
;*	\  \/\_/ /                                              *
;*	 \_/___  \                                              *
;*	  /    \  \                                             *
;*	__     |  |                                             *
;*	\ \___/  /                                              *
;*	 \______/                                               *
;*                                                             	*
;* Copyright 2002 Starcat Developments				*
;* [ http://www.starcat-dev.de ]				*
;*   Programmed by Lars Hannig					*
;*								*
;*	JAGUAR LIBRARY    					*
;*								*
;****************************************************************
	.text
	.68000
;===========================================================================================
readpad:
;scan for player 1
	move.l	#$f0fffffc,d1		; d1 = Joypad data mask
	moveq.l	#-1,d2			; d2 = Cumulative joypad reading
	move.w	#$81fe,JOYSTICK
	move.l	JOYSTICK,d0		; Read joypad, pause button, A button
	or.l	d1,d0			; Mask off unused bits
	ror.l	#4,d0
	and.l	d0,d2			; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
	move.w	#$81fd,JOYSTICK
	move.l	JOYSTICK,d0		; Read *741 keys, B button
	or.l	d1,d0			; Mask off unused bits
	ror.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
	move.w	#$81fb,JOYSTICK
	move.l	JOYSTICK,d0		; Read 2580 keys, C button
	or.l	d1,d0			; Mask off unused bits
	rol.l	#6,d0
	rol.l	#6,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
	move.w	#$81f7,JOYSTICK
	move.l	JOYSTICK,d0		; Read 369# keys, Option button
	or.l	d1,d0			; Mask off unused bits
	rol.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low
	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high
	move.l	joycur,d0		; old joycur needed for determining the new joyedge
	move.l	d1,joycur		; Current joypad reading stored into joycur
	eor.l	d1,d0
	and.l	d1,d0
	move.l	d0,joyedge		;joypad, buttons, keys that were just pressed
;scan for player 2
	move.l	#$0ffffff3,d1		; d1 = Joypad data mask
	moveq.l	#-1,d2			; d2 = Cumulative joypad reading
	move.w	#$817f,JOYSTICK
	move.l	JOYSTICK,d0		; Read joypad, pause button, A button
	or.l	d1,d0			; Mask off unused bits
	rol.b	#2,d0			; note the size of rol
	ror.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
	move.w	#$81bf,JOYSTICK
	move.l	JOYSTICK,d0		; Read *741 keys, B button
	or.l	d1,d0			; Mask off unused bits
	rol.b	#2,d0			; note the size of rol
	ror.l	#8,d0
	ror.l	#4,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
	move.w	#$81df,JOYSTICK
	move.l	JOYSTICK,d0		; Read 2580 keys, C button
	or.l	d1,d0			; Mask off unused bits
	rol.b	#2,d0			; note the size of rol
	rol.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
	move.w	#$81ef,JOYSTICK
	move.l	JOYSTICK,d0		; Read 369# keys, Option button
	or.l	d1,d0			; Mask off unused bits
	rol.b	#2,d0			; note the size of rol
	rol.l	#4,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low
	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high
	move.l	joycur+4,d0		; old joycur needed for determining the new joyedge
	move.l	d1,joycur+4		; Current joypad reading stored into joycur
	eor.l	d1,d0
	and.l	d1,d0
	move.l	d0,joyedge+4		;joypad, buttons, keys that were just pressed
	rts
joyedge::		dc.l		0,0
joycur::		dc.l		0,0
;================================================================================================

;******************************************************
;COPY GPU DATA TO GPU
copy_gpu_data:
	move.l	#G_RAM,a0
	move.w	#4096-1/4,d0
.clear:	move.l	#0,(a0)+
	dbra	d0,.clear

        move.l #G_RAM,a0        ; destination adress
        lea  GPU_OP_start,a1       ; source adress
        move.l #GPU_OP_end,d0
        sub.l a1,d0
        asr  #2,d0              ; Divide by 4 (do longs in copy loop)
.loop:  move.l (a1)+,(a0)+      ; copy 4 bytes to GPU-RAM
        dbra  d0,.loop          ; repeat for GPU program length
        rts


;******************************************************************************
; GPU starten
;******************************************************************************
start_gpu:
	move.l	#G_RAM,G_PC	; Start up GPU
	move.l	#1,G_CTRL
        rts


;************************************************
set_palette:
;A0 must be the address of the palette data
;palette data is 256 words of colors
          lea.l     CLUT,a1             ;get address of color lookup table
          move.w    #255,d0             ;number of colors to set
.10:      move.w    (a0)+,(a1)+         ;put color value into color lookup table
          dbra      d0,.10              ;continue through palette table
          rts

;*******************************************************************************
;RANDOM NUMBER GENERATOR
;I have a 68k version I wrote for a Random # generator.
;it is the same one I use for Gorf Classic and is My gift to all in the
;Jag UDG.

; the variables......leave these initial values as they are

rand_1:      dc.w    0
rand_2:      dc.w    0
rand_3:      dc.w    0
randseed1:   dc.w    $1010
randsl1:     dc.w    $0101
randseed2:   dc.w    $1010
randsl2:     dc.w    $0101

; the code.....

random:
        sub.l   #$00001425,randseed1
        add.l   #$00003796,randseed2
        move.w  randsl2,rand_1
        move.w  $f00004,rand_2    ; $f00004 is the Jaguar's vid counter
        move.w  randsl1,rand_3
        and.w   #15,d1
        lsl.w   d1,d0
        or.w    rand_3,d0
        move.w  rand_2,d1
        eor.w   d1,d0
        and.l   #511,d0   ;this allows only 0-511 but can be adjusted
        rts

;        Just call the routine and d0 has the value upon return.
;        jsr rand
;        d0= random number

;*********************************************************************
clear_text_screen:
	move.l	#PITCH1|PIXEL16|WID320|XADDPIX,d0
	move.l	d0,A1_FLAGS
	move.l	#user_memory+MEM_TXT_IMAGE,d0
	move.l	d0,A1_BASE
	move.w	#0,d0			; y
	swap	d0
	move.w	#0,d0			; x
	move.l	d0,A1_PIXEL
	move.w	#0,d0			; y
	swap	d0
	move.w	#0,d0			; x
	move.l	d0,A1_FPIXEL
	move.w	#1,d0			; y
	swap	d0
	move.w	#(-320),d0		; x
	move.l	d0,A1_STEP
	move.w	#0,d0		; y
	swap	d0
	move.w	#0,d0		; x
	move.l	d0,A1_FSTEP
	move.w	#240,d0	; Height
	swap	d0
	move.w	#320,d0	; x
	move.l	d0,B_COUNT
	move.l	#0,d0
	move.l	d0,B_PATD
	move.l	#0,d0
	move.l	d0,B_PATD+4
	move.l	#PATDSEL|UPDA1,d0
	move.l	d0,B_CMD
	rts


;-------------------------------------------------------------------------
; Interrupts initalisieren
;-------------------------------------------------------------------------
IntInit:
	move.l	LEVEL0,s_level2
	move.l	VI,s_vi
	move.l	INT1,s_int1
	move.w	sr,s_sr

	move.l	#Frame,LEVEL0

	move.w  a_vde,d0
	ori.w   #1,d0
	move.w  d0,VI

	move.w  #1,INT1

	move.w  sr,d0
	andi.w  #$F8FF,d0
	move.w  d0,sr
	rts



;-------------------------------------------------------------------------
; Interrupt Routine
;-------------------------------------------------------------------------
Frame:	movem.l	d0-d1,-(sp)
	move.l	olist_ram,d0			; Adresse neue OP-Liste laden
	move.l	olist,d1			; Adresse aktive OP-Liste laden
	move.l	d1,olist_ram			; Adresse neue OP-Liste = Adresse aktive OP-Liste
	move.l	d0,olist			; Adresse aktive OP-Liste = Adresse neue OP-Liste

	move.l	d1,$f03f44			; Adresse olist_ram fr GPU

	subq.l	#4,d0				; Adresse OP-Liste auf Branch Objekt
	swap	d0				; Adresse vertauschen fr OP
	move.l	d0,OLP				; Adresse fr OP einstellen

	move.w	#$101,INT1
	move.w	#0,INT2
	movem.l	(sp)+,d0-d1
	rte



;******************************************************************************
; Subroutine copy OP List                                                     *
;******************************************************************************
copy_olist:
	lea	olist_ram,a0		; Adresse der erstellen OP Liste
	lea	olist,a1		; Adresse der OP Liste, die der OP beim Bildaufbau verwendet
.10:	move.l	(a0),(a1)+		; OP Liste von "olist_ram" nach "olist" kopieren
        cmpi.l  #4,(a0)+                ; Wert 4 kennzeichnet das STOP Object
	bne.b	.10			; Wiederhole bis komplette OP Liste kopiert ist
	rts				; Ende Unterprogramm


;******************************************************************************
; Branch Objekte fr Objekt Listen erstellen
;******************************************************************************
; In:	A0	; Adresse Branch Objekt
; 	D2	; Adresse Stop Objekt
create_branch:

; Erstes BRANCH Objekt (branch if YPOS < a_vdb)
	clr.l   d1
	move.l  #(BRANCHOBJ|O_BRGT),d0  ; YPOS < VC

; Format Link erstellen
	movem.l d2-d3,-(sp)
	andi.l  #$3FFFF8,d2             ; Ensure alignment/valid address
	move.l  d2,d3                   ; Make a copy

	swap    d2                      ; This section places bits 10-3
	clr.w   d2                      ; in bits 31-24. It saves cycles
	lsl.l   #5,d2                   ; over using three shifts.
	or.l    d2,d0

	lsr.l   #8,d3                   ; Put bits 21-11 in bits 42-32
	lsr.l   #3,d3
	or.l    d3,d1
	movem.l (sp)+,d2-d3             ; Restore regs
; Ende Format Link erstellen

        move.w  a_vdb,d3                ; oberer Rand
	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+
	move.l  d0,(a0)+                ; First OBJ is done.

; Zweites BRANCH Objekt (branch if YPOS > a_vde)
	andi.l  #$FF000007,d0           ; Mask off CC and YPOS
	ori.l   #O_BRLT,d0              ; $8000 = YPOS < VC
        move.w  a_vde,d3                ; unterer Rand
	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+                ; Second OBJ is done
	move.l  d0,(a0)+
	rts

        .QPHRASE
s_sp:           dc.l    1       ; Adresse alter Stackpointer
s_level2:       dc.l    1
s_vi:           dc.l    1
s_int1:         dc.l    1
s_sr:           dc.w    1

	.QPHRASE
; in "olist" befindet sich die Object Liste die der OP beim Bildaufbau verwendet.
olist: dc.l	1	;((8*TOTAL_OBJS)+2)

	.QPHRASE
; in "olist_ram" wird die neue OP Liste erstellt, waehrend der OP die Liste
; aus "olist" verwendet, um den Bildschirm zu rendern.
; Die erstellte OP Liste in "olist_ram" wird im VBL-Interrupt nach "olist" kopiert
olist_ram:dc.l	1	;((8*TOTAL_OBJS)+2)


