        INCLUDE "include.s"     ;  My own includes

		.globl _start

		.extern	a_vdb
		.extern	a_vde
		.extern	a_hdb
		.extern	a_hde
		.extern	width
		.extern	height

        .text
        .68000
TOTAL_OBJS       EQU    256    ;reserviere Speicher fr obj daten
;******************************************************************************
_start:
        jsr     copy_gpu_data

	bsr	IntInit			; init Interrupts

; Create branch Objects for 2 OP-lists
        lea     olist1_branch,a0        ; adress Branch Object
        move.l  #olist1_stop,d2         ; adress Stop Object
	bsr	create_branch		; Branch Objekt erstellen

	lea	olist2_branch,a0	; Adresse Branch Objekt
	move.l	#olist2_stop,d2		; Adresse Stop Objekt
	bsr	create_branch		; Branch Objekt erstellen

	move.l	#olist1,olist		; Adresse aktive OP-Liste
	move.l	#olist2,olist_ram	; Adresse zu erstellende OP-Liste

	move.l	#olist1_stop,d0		; Adresse der Objekt Liste
	swap	d0			; Adresse vertauschen fr OP
	move.l	d0,OLP			; Adresse fr OP einstellen

        move.w  #$6C7,VMODE             ; Video Init 320x200 16 Bit RGB

        moveq   #0,d0                   ;
        move.w  a_vdb,d0                ; erste Bildschirmzeile fr GPU OP-Routine
        andi.w  #$FFFE,d0               ;
        move.l  d0,gpu_a_vdb              ;

;////////////////////////////////////////////////////////////////////////


game_code:
	move.w	#2,anz_objects	;We want to display 2 Objects

        lea	gpu_obj_data,a0
        lea	start_data,a1 ;Move the Addess of "start_data" (our OBJ List) into gpu_obj_data.
        move.l  a1,(a0)

;/////////////////////////////////////////////
;ICE DEPACK
	move.l	#logo_ice,d0
	move.l	#user_memory+MEM_DATA,d1
	jsr	ice_depack
;/////////////////////////////////////////////
;LOAD CLUT
	lea	LOGO_PAL,a0
	jsr	set_palette
;/////////////////////////////////////////////

;///////////////////////////////////////
;TEXT SETTING
	jsr	clear_text_screen

	lea	gpu_text,a1
	lea	text_list,a2    ;message to print
	move.l	a2,(a1)
;///////////////////////////////////////

;************************************************************************
;GAME LOOP
main:
	jsr	start_gpu	;Start GPU

	jsr	check_joypad

	stop	#$2000	;Stop 68k till next VBL interrupt
        bra     main	;Branch Always to main





;************************************************************************************************
;****************************************************************************
;JOYPAD READING
; D0 = JOYPAD DATA

check_joypad:
	jsr     readpad		;GET JOYPAD STATE
	move.l  joycur,d0	;JOYPAD STATE INTO D0

;SAMPLE DIRECTION LEFT CHECK CODE
.check_left:
	btst.l  #JOY_LEFT,d0	;CHECK IF LEFT WAS PRESSED
	beq     .check_right	;IF NOT GO TO .check_reset

	lea	start_data,a0
	sub.w	#1,XPOS(a0)

.check_right:
	btst.l  #JOY_RIGHT,d0	;CHECK IF LEFT WAS PRESSED
	beq     .check_reset	;IF NOT GO TO .check_reset

	lea	start_data,a0
	add.w	#1,XPOS(a0)

;SAMPLE RESET CHECK CODE FOR * AND #
.check_reset:
	btst.l  #KEY_STAR,d0	;CHECK IF * WAS PRESSED
	beq     .no_reset	;IF NOT JUMP TO .no_reset
	btst.l  #KEY_HASH,d0	;CHECK IF # WAS PRESSED
	bne     game_code	;IF TRUE, THE JUMP BACK TO game_code
.no_reset:                      ;(OR WHATEVER YOU WANT TO DO, WHEN * AND # ARE PRESSED TOGETHER)
        rts			;RETURN TO SUBROUTINE (main IN THIS CASE)



;max 28 zeichen pro zeile.


.QPHRASE
text_list:
dc.l	message1	;0-4	MESSAGE
dc.l	user_memory+MEM_TXT_IMAGE		;12-16  DESTINATION
dc.w	$ffff           ;4-6	TEXTCOLOR
dc.w	5               ;6-8	TEXTX
dc.w 	20              ;8-10   TEXTY
dc.w	0               ;10-12  DUMMY_TXT
;/////////////////////////////////////////
dc.l	message1	;0-4	MESSAGE
dc.l	user_memory+MEM_TXT_IMAGE		;12-16  DESTINATION
dc.w	$fdff           ;4-6	TEXTCOLOR
dc.w	5               ;6-8	TEXTX
dc.w 	25              ;8-10   TEXTY
dc.w	0               ;10-12  DUMMY_TXT
;/////////////////////////////////////////
dc.l	0		;0-4	MESSAGE
dc.l	0		;12-16  DESTINATION
dc.w	0           ;4-6	TEXTCOLOR
dc.w	0               ;6-8	TEXTX
dc.w 	0              ;8-10   TEXTY
dc.w	0               ;10-12  DUMMY_TXT
;/////////////////////////////////////////

QPHRASE
message1:	dc.b	'Starcat Developments Libary',1,'V1.3.',0



;******************************************************************************
        .QPHRASE
        include "gpu_prog.s"

        .QPHRASE
	include "ice.s"
	include	"jaguar.s"
        include "score.s"

	include "clut.s"
;******************************************************************************
;******************************************************************************
 .QPHRASE
olist1_branch:
                rept    4
                dc.l    0	; 2 Branch Objekte
                endr

olist1:
                rept    ((8*TOTAL_OBJS)+2)
                dc.l 0
                endr

olist1_stop:    dc.l    0	; 1 Teil STOP Objekt
                dc.l    4	; 2 Teil STOP Objekt



 .QPHRASE
olist2_branch:
                rept    4
                dc.l    0	;2 Branch Objekte
                endr

olist2:
            	rept    ((8*TOTAL_OBJS)+2)
            	dc.l    0
            	endr

olist2_stop:    dc.l    0	; 1 Teil STOP Objekt
		dc.l    4	; 2 Teil STOP Objekt
;******************************************************************************


;******************************************************************************
;OUR OBJECT LIST DATA
        .QPHRASE
start_data:
	dc.w    21+20      ; (O_XPOS)      X-Pos Object auf dem Bildschirm
        dc.w    42+40     ; (O_YPOS)      Y-Pos Object auf dem Bildschirm
        dc.l    user_memory+MEM_DATA  ; (O_DATA)      Adresse der Object Daten
        dc.w    100-1     ; (O_HEIGHT)    Hoehe des Objects in Pixel
        dc.w    256/8   ; (O_IWIDTH)    Breite des Objects in Phrases
        dc.w    256/8   ; (O_DWIDTH)    Offset zur nchsten Linie des Objects in Phrases
        dc.b    0       ; (O_FLAGS)     Flags wie Object gezeichnet werden soll
        dc.b    0       ; (O_FIRSTPIX)  wieviele Bits am Anfang der Object Daten uebergehen
        dc.b    0       ; (O_TYPE)      Object Flags (0=Bitmap, 1=Scale, 2=GPU, 3=Branch, 4=Stop)
        dc.b    3       ; (O_DEPTH)     Anzahl Farben des Objects
        dc.b    1       ; (O_PITCH)     Pitch
        dc.b    0       ; (O_INDEX)     Index in CLUT fuer Objecte mit Farbpalette
        dc.w    $20     ; (O_SCALE)     Remainder
        dc.b    30      ;               Y-Scaling Faktor
        dc.b    30      ;               X-Skaling Faktor

	dc.w	1	; ACTIVE
	dc.b	0	; KIND
	dc.b	0	; HITS
	dc.w	0	; REAL_WIDTH
	dc.w	0	; REAL_HEIGHT
	dc.w	0	; D_X
	dc.w	0	; D_Y
	dc.w	0	; FREE1
	dc.w	0	; FREE2
	dc.w	0	; FREE3
	dc.w	0	; FREE4
	dc.w	0	; FREE5
	dc.b	0	; FREE6
	dc.b	0	; SCALE_COUNTER
	dc.l	0	; ANIMATION
	dc.l	0	; SCALING
;******************************************************************************
        dc.w    21      ; (O_XPOS)      X-Pos Object auf dem Bildschirm
        dc.w    42     ; (O_YPOS)      Y-Pos Object auf dem Bildschirm
        dc.l    user_memory+MEM_TXT_IMAGE  ; (O_DATA)      Adresse der Object Daten
        dc.w    240     ; (O_HEIGHT)    Hoehe des Objects in Pixel
        dc.w    320/4   ; (O_IWIDTH)    Breite des Objects in Phrases
        dc.w    320/4   ; (O_DWIDTH)    Offset zur nchsten Linie des Objects in Phrases
        dc.b    4       ; (O_FLAGS)     Flags wie Object gezeichnet werden soll
        dc.b    0       ; (O_FIRSTPIX)  wieviele Bits am Anfang der Object Daten uebergehen
        dc.b    0       ; (O_TYPE)      Object Flags (0=Bitmap, 1=Scale, 2=GPU, 3=Branch, 4=Stop)
        dc.b    4       ; (O_DEPTH)     Anzahl Farben des Objects
        dc.b    1       ; (O_PITCH)     Pitch
        dc.b    0       ; (O_INDEX)     Index in CLUT fuer Objecte mit Farbpalette
        dc.w    $20     ; (O_SCALE)     Remainder
        dc.b    30      ;               Y-Scaling Faktor
        dc.b    30      ;               X-Skaling Faktor

	dc.w	1	; ACTIVE
	dc.b	0	; KIND
	dc.b	0	; HITS
	dc.w	0	; REAL_WIDTH
	dc.w	0	; REAL_HEIGHT
	dc.w	0	; D_X
	dc.w	0	; D_Y
	dc.w	0	; FREE1
	dc.w	0	; FREE2
	dc.w	0	; FREE3
	dc.w	0	; FREE4
	dc.w	0	; FREE5
	dc.b	0	; FREE6
	dc.b	0	; SCALE_COUNTER
	dc.l	0	; ANIMATION
	dc.l	0	; SCALING
;******************************************************************************
;********************************************************
;			MEMORY USAGE
MEM_TXT_IMAGE	EQU	0				;MEM_TXT_IMAGE - USED FOR TEXT
MEM_SCORE_IMAGE	EQU	MEM_TXT_IMAGE+((320*240))	;MEM_SCORE_IMAGE - USED FOR SCORE
MEM_DATA	EQU	MEM_SCORE_IMAGE+((192*240)*2)	;MEM_DATA - CAN BE USED FOR GRAPHIC DATA
MEM_END		EQU	MEM_DATA+((320*240)*2)		;MEM_END - SAY WHERE YOUR MEMORY SHOULD END
;*********************************************************
.QPHRASE
user_memory:
	rept	((MEM_END)/4)
	dc.l	0
	endr

;***********************************************************************
;FILE INCLUDES
.QPHRASE
font:	incbin	"gfx/font.rgb" ;FONT GRAPHIC 16-BIT
.QPHRASE
zahlen: incbin	"gfx/zahlen.rgb" ;SCORE GRAPHIC 16-BIT
.QPHRASE
logo_ice:	incbin  "gfx/logo_8.ice" ;256x100





QPHRASE
gpu_text:	dc.l	0
.QPHRASE
anz_objects:    dc.w    0
.QPHRASE
gpu_obj_data:	dc.l	start_data
.QPHRASE
gpu_a_vdb:	dc.l	0

.QPHRASE
end_of_code:
END

