;********************************************
; 68000 Memory Test by Gordon Lawton - Version 1.0
; Last Modified: 22/8/2000  Jaguar Alpine Version 1.0 by Glenn Bruner
;********************************************
; This code runs a suite of memory tests over a specified memory
; area.  The tests are as follows:
;
; data r/w
; data/address connectivity
; memory fill test
; walking 1/0s test
;
; This program is a basic no-frills memory tester.  Must start the
; development system with the STUB running in DRAM.  To enable this
; feature, turn the system on with button A held down on controller 1.
;
; A fuller description of the code is given in the subroutines.
;*******************************************
; <C> Copyright Motorola 1994
; Change History:  Ver 1.0  Initial release
;*******************************************
; Initial conditions: none
; Final conditions:  Memory tested
;
; Input parameters:  none
; Output parameters: Test results in D1
;              Pass: $12345678 in D1
;              Fail: $DEADDEAD in D1
;*******************************************
; Definitions of constants used in the code
;*******************************************
	.include	'jaguar.inc'

MEMST   .equ    $800000         ;Beginning of Alpine board RAM
MEMEND  .equ    $BFFFFC         ;End address for 2MB Alpine mem test
; Change MEMEND to $BFFFFC for a 4MB Alpine board
; Change MEMEND to $9FFFFC for a 2MB Alpine board
PATTERNA .equ	$AAAAAAAA	;Test pattern A
PATTERNB .equ	$55555555	;Test pattern B
PATTERNC .equ   $FFFFFFFF	;Test pattern C
PASS     .equ   $12345678       ;Pass Indicator
FAIL     .equ   $DEADDEAD       ;Fail Indicator
;*******************************************
; XRAM_Test
; All memory tests are called from this routine.
; The exit TRAP requires to be altered depending
; on the system used.
;*******************************************


START:
	MOVEA.L		#MEMST,A0	;load start address
	MOVEA.L		#MEMEND,A1	;load end address
;        pea             msg1            ;push msg address onto stack
;        bsr             stub_trp        ;display msg on host computer
	BSR		XRAMDRW		;do RAM data r/w test
	BSR		XRAMDA		;do RAM data address test
	BSR		XRAMMF		;do RAM memory fill test
	BSR		XRAMWALK	;do RAM walking 1/0s test
        MOVE.L          #PASS,D1        ;put pattern in d1 if passed
EXIT:
	illegal				;exit back to probe debugger
;*******************************************
; RAM_Data_R/W
;
; Test writes a data pattern to memory then reads
; it back to check it has been written correctly.
; This test is run for 00000000, 55555555, AAAAAAAA
; and FFFFFFFF.  It will verify correct storage
; operation of the RAM.
;
; Initial conditions: None
; Final conditions:  Pass: then return
;                    Fail: then error routine
; Input parameters:  A0 = MEMST, A1 = MEMEND
; Output parameters: None
;*******************************************
XRAMDRW:
	MOVE.L		A0,A2		;copy start address
	CLR.L		D4		;clear to write 0s
FILL1:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL1		;at end of block?
	MOVE.L		A0,A2		;copy start address
COMP1:
	CMP.L		(A2)+,D4	;check written ok
        BNE             XDRERR          ;quit on error
	CMPA.L		A2,A1		;check location
	BPL		COMP1		;at end of block?
	MOVE.L		A0,A2		;copy start address
	MOVE.L		#PATTERNB,D4	;This time write 5s
FILL2:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL2		;at end of block?
	MOVE.L		A0,A2		;copy start address
COMP2:
	CMP.L		(A2)+,D4	;check written ok
        BNE           XDRERR          ;quit on error
	CMPA.L		A2,A1		;check location
	BPL		COMP2		;at end of block?
	MOVE.L		A0,A2		;copy start address
	MOVE.L		#PATTERNA,D4	;This time write A's
FILL3:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL3		;at end of block?
	MOVE.L		A0,A2		;copy start address
COMP3:
	CMP.L		(A2)+,D4	;check written ok
        BNE           XDRERR          ;quit on error
	CMPA.L		A2,A1		;check location
	BPL		COMP3		;at end of block?
	MOVE.L		A0,A2		;copy start address
	MOVE.L		#PATTERNC,D4	;This time write F's
FILL4:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL4		;at end of block?
	MOVE.L		A0,A2		;copy start address
COMP4:
	CMP.L		(A2)+,D4	;check written ok
        BEQ             XDROK           ;quit on error
XDRERR:
	BSR		XRAMERR		;jump to error routine
XDROK:
	CMPA.L		A2,A1		;check location
	BPL		COMP4		;at end of block?
	RTS				;Return to do next test
;*******************************************
; RAM_Data_Address
; This test uses the current memory address
; as a data value to store at the address.
; The data is read back and compared thus tests
; the address lines.
;
; Initial conditions: None
; Final conditions:  Pass: then return
;                    Fail: then error routine
; Input parameters:  A0 = MEMST, A1 = MEMEND
; Output parameters: None
;*******************************************
XRAMDA:
	MOVE.L		A0,A2		;copy start address
FILL5:
	MOVE.L		A2,(A2)+	;write addr as data to addr
	CMPA.L		A2,A1		;check location
	BPL		FILL5		;at end of block?
	MOVE.L		A0,A2		;copy start address
COMP5:
	CMPA.L		(A2),A2		;write address as data to itself
        BNE             XDAERR          ;quit on error
	TST.L		(A2)+		;ignore test, increment address
	CMPA.L		A2,A1		;check location
	BPL		COMP5		;at end of block?
	BRA		XDAOK		;skip error call if here
XDAERR:
	BSR		XRAMERR		;jump to error routine
XDAOK:
	RTS				;Return to do next test
;*******************************************
; RAM_Memory_Fill
; After memory is filled with a background of 0s
; a single location is written with a pattern.
; This checks if the data and address lines are
; connected correctly.
;
; Initial conditions: None
; Final conditions:  Pass: then return
;                    Fail: then error routine
; Input parameters:  A0 = MEMST, A1 = MEMEND
; Output parameters: None
;*******************************************
XRAMMF:
	MOVE.L		A0,A2		;copy start address
	CLR.L		D4		;clear to write 0s
FILL6:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL6		;at end of block?
	MOVE.L		A1,A2		;copy end address
	SUBA.L		A0,A2		;start-end = block length
	MOVE.L		A2,D4		;put length in D4 for shift
	LSR.L		#$4,D4		;divide by 16 to get offset
	LSL.L		#$2,D4		;mult by 4 - long word aligned
	MOVE.L		#PATTERNA,D5	;copy A's pattern
	MOVE.L		D5,0(A0,D4.L)	;write patA to start+offset
	LEA.L		0(A0,D4.L),A3	;copy address of offset
	MOVE.L		A0,A2		;copy start address
COMP6:
	TST.L		(A2)		;make sure location is 0
	BEQ		MFPASS		;ok if 0
	CMPA.L		A3,A2		;at offset?
	BNE		XMFERR		;quit if not correct
MFPASS:
	TST.L		(A2)+		;increment address
	CMP.L		A2,A1		;check location
	BPL		COMP6		;at end of block?
	BRA		XMFOK		;skip error call if here
XMFERR:
	BSR		XRAMERR		;jump to error routine
XMFOK:
	RTS				;Return to do next test
;*******************************************
; RAM_Walking_1/0's
; After block filling the memory with 1s
; every bit is set to 0, tested, and set back to 1.
;
; Initial conditions: None
; Final conditions:  Pass: then return
;                    Fail: then error routine
; Input parameters:  A0 = MEMST, A1 = MEMEND
; Output parameters: None
;*******************************************
XRAMWALK:
        MOVE.L         A0,A2           ;copy start address
	MOVE.L		#PATTERNC,D4	;this time write F's
FILL7:
	MOVE.L		D4,(A2)+	;write to memory
	CMPA.L		A2,A1		;check location
	BPL		FILL7		;at end of block?
	MOVE.L		A0,A2		;copy start address
	MOVE.L		#$FFFFFFFE,D4	;blank LSB
COMP7:
	MOVE.L		#$1F,D5		;count of 31
WALKLOOP:
        MOVE.L         D4,(A2)         ;write next bit memory
	CMP.L		(A2),D4		;bit o.k.?
	BNE		XWKERR		;error if not the same
	ROL.L		#$1,D4		;blank next bit
	DBF		D5,WALKLOOP	;at last bit?
	MOVE.L		#PATTERNC,(A2)+ ;clear last bit, inc address
	CMP.L		A2,A1		;check location
	BPL		COMP7		;at end of block?
	BRA		XWKOK		;skip error call if here
XWKERR:
	BSR		XRAMERR		;jump to error routine
XWKOK:
	RTS				;return to main routine

stub_trp:
        move.W        #$f000,-(sp)
	move.l		#$000b0005,-(sp)
	trap		#14
	rts

;*******************************************
; ERROR HANDLING ROUTINE
; Set error pattern in D1
;
; Initial conditions: Failure
; Final conditions:  Error condition set
; Input parameters: None
; Output parameters:  D1 = $DEADDEAD
;*******************************************
XRAMERR:
        MOVE.L          #FAIL,D1        ;set error pattern
	BRA		EXIT		;exit

msg1:
	.dc.b		"Beginning of RAM test program.",0

	.END
