;*========================================
; 3D Library Data File
;*========================================


	.include	'jaguar.inc'

	.data
	.globl	_radardata
_radardata:
	dc.w	84		;Number of faces
	dc.w	70		;Number of points
	dc.w	6		;Number of materials
	dc.w	0		; reserved word
	dc.l	.facelist
	dc.l	.vertlist
	dc.l	.matlist
	.phrase
.facelist:
;* Face 0
	dc.w	$d807,$0,$31fb,$ffed	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	0, $00ff	; Point index, texture coordinates
	dc.w	2, $00ff	; Point index, texture coordinates
	dc.w	3, $00ff	; Point index, texture coordinates
	dc.w	1, $00ff	; Point index, texture coordinates

;* Face 1
	dc.w	$fd08,$c386,$14bc,$ffe2	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	8, $00ff	; Point index, texture coordinates
	dc.w	6, $00ff	; Point index, texture coordinates
	dc.w	7, $00ff	; Point index, texture coordinates

;* Face 2
	dc.w	$f778,$c196,$b4d,$ffe0	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	8, $00ff	; Point index, texture coordinates
	dc.w	5, $00ff	; Point index, texture coordinates
	dc.w	6, $00ff	; Point index, texture coordinates

;* Face 3
	dc.w	$fff9,$c0e4,$aa6,$ffe1	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	5, $00ff	; Point index, texture coordinates
	dc.w	8, $00ff	; Point index, texture coordinates
	dc.w	9, $00ff	; Point index, texture coordinates
	dc.w	4, $00ff	; Point index, texture coordinates

;* Face 4
	dc.w	$d8c9,$1573,$2dce,$fff4	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	6, $00ff	; Point index, texture coordinates
	dc.w	1, $00ff	; Point index, texture coordinates
	dc.w	7, $00ff	; Point index, texture coordinates

;* Face 5
	dc.w	$da97,$168c,$2ec7,$fff6	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	6, $00ff	; Point index, texture coordinates
	dc.w	0, $00ff	; Point index, texture coordinates
	dc.w	1, $00ff	; Point index, texture coordinates

;* Face 6
	dc.w	$fd09,$3c7a,$14ba,$1	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	12, $00ff	; Point index, texture coordinates
	dc.w	14, $00ff	; Point index, texture coordinates
	dc.w	13, $00ff	; Point index, texture coordinates

;* Face 7
	dc.w	$f779,$3e6a,$b4d,$0	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	11, $00ff	; Point index, texture coordinates
	dc.w	14, $00ff	; Point index, texture coordinates
	dc.w	12, $00ff	; Point index, texture coordinates

;* Face 8
	dc.w	$fffb,$3f1c,$aa6,$2	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	15, $00ff	; Point index, texture coordinates
	dc.w	14, $00ff	; Point index, texture coordinates
	dc.w	11, $00ff	; Point index, texture coordinates
	dc.w	10, $00ff	; Point index, texture coordinates

;* Face 9
	dc.w	$d8ca,$ea7d,$2dc7,$ffe9	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	3, $00ff	; Point index, texture coordinates
	dc.w	12, $00ff	; Point index, texture coordinates
	dc.w	13, $00ff	; Point index, texture coordinates

;* Face 10
	dc.w	$da9a,$e965,$2ec2,$ffea	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	2, $00ff	; Point index, texture coordinates
	dc.w	12, $00ff	; Point index, texture coordinates
	dc.w	3, $00ff	; Point index, texture coordinates

;* Face 11
	dc.w	$0,$c000,$0,$ffe3	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	16, $00ff	; Point index, texture coordinates
	dc.w	19, $00ff	; Point index, texture coordinates
	dc.w	18, $00ff	; Point index, texture coordinates
	dc.w	17, $00ff	; Point index, texture coordinates

;* Face 12
	dc.w	$ee5b,$0,$c27b,$ffee	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	20, $ff53	; Point index, texture coordinates
	dc.w	24, $ffac	; Point index, texture coordinates
	dc.w	25, $90ac	; Point index, texture coordinates
	dc.w	21, $9053	; Point index, texture coordinates

;* Face 13
	dc.w	$d85b,$0,$cdc2,$ffec	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	21, $9053	; Point index, texture coordinates
	dc.w	25, $90ac	; Point index, texture coordinates
	dc.w	2, $00ac	; Point index, texture coordinates
	dc.w	0, $0053	; Point index, texture coordinates

;* Face 14
	dc.w	$264b,$0,$3348,$13	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	1, $0453	; Point index, texture coordinates
	dc.w	3, $04ac	; Point index, texture coordinates
	dc.w	26, $8cac	; Point index, texture coordinates
	dc.w	22, $8c53	; Point index, texture coordinates

;* Face 15
	dc.w	$11b5,$0,$3d81,$10	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	22, $8c53	; Point index, texture coordinates
	dc.w	26, $8cac	; Point index, texture coordinates
	dc.w	27, $fbac	; Point index, texture coordinates
	dc.w	23, $fb53	; Point index, texture coordinates

;* Face 16
	dc.w	$f105,$d889,$cfe5,$ffe4	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	4, $eb00	; Point index, texture coordinates
	dc.w	21, $9053	; Point index, texture coordinates
	dc.w	5, $8105	; Point index, texture coordinates

;* Face 17
	dc.w	$f1ec,$d96b,$ceea,$ffe5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	4, $eb00	; Point index, texture coordinates
	dc.w	20, $ff53	; Point index, texture coordinates
	dc.w	21, $9053	; Point index, texture coordinates

;* Face 18
	dc.w	$ddb5,$d68f,$dd53,$ffe0	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	5, $8105	; Point index, texture coordinates
	dc.w	0, $0053	; Point index, texture coordinates
	dc.w	6, $0423	; Point index, texture coordinates

;* Face 19
	dc.w	$df0b,$dc6f,$d63b,$ffe3	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	5, $8105	; Point index, texture coordinates
	dc.w	21, $9053	; Point index, texture coordinates
	dc.w	0, $0053	; Point index, texture coordinates

;* Face 20
	dc.w	$22b1,$2354,$288d,$1c	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	7, $0824	; Point index, texture coordinates
	dc.w	22, $8c53	; Point index, texture coordinates
	dc.w	8, $7d07	; Point index, texture coordinates

;* Face 21
	dc.w	$1c93,$2a9b,$2644,$1d	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	7, $0824	; Point index, texture coordinates
	dc.w	1, $0453	; Point index, texture coordinates
	dc.w	22, $8c53	; Point index, texture coordinates

;* Face 22
	dc.w	$f26,$26d0,$3095,$1a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	8, $7d07	; Point index, texture coordinates
	dc.w	23, $fb53	; Point index, texture coordinates
	dc.w	9, $e602	; Point index, texture coordinates

;* Face 23
	dc.w	$dd1,$2804,$3000,$1a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	8, $7d07	; Point index, texture coordinates
	dc.w	22, $8c53	; Point index, texture coordinates
	dc.w	23, $fb53	; Point index, texture coordinates

;* Face 24
	dc.w	$f0fd,$2765,$cfd9,$fff9	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	25, $90ac	; Point index, texture coordinates
	dc.w	10, $ebff	; Point index, texture coordinates
	dc.w	11, $81fa	; Point index, texture coordinates

;* Face 25
	dc.w	$f1e8,$2680,$cedb,$fff8	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	24, $ffac	; Point index, texture coordinates
	dc.w	10, $ebff	; Point index, texture coordinates
	dc.w	25, $90ac	; Point index, texture coordinates

;* Face 26
	dc.w	$dda8,$2953,$dd3b,$fff5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	2, $00ac	; Point index, texture coordinates
	dc.w	11, $81fa	; Point index, texture coordinates
	dc.w	12, $04dc	; Point index, texture coordinates

;* Face 27
	dc.w	$df01,$2379,$d62e,$fff5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	25, $90ac	; Point index, texture coordinates
	dc.w	11, $81fa	; Point index, texture coordinates
	dc.w	2, $00ac	; Point index, texture coordinates

;* Face 28
	dc.w	$22b9,$dcc4,$289c,$a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	26, $8cac	; Point index, texture coordinates
	dc.w	13, $08db	; Point index, texture coordinates
	dc.w	14, $7df8	; Point index, texture coordinates

;* Face 29
	dc.w	$1ca3,$d583,$265a,$7	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	3, $04ac	; Point index, texture coordinates
	dc.w	13, $08db	; Point index, texture coordinates
	dc.w	26, $8cac	; Point index, texture coordinates

;* Face 30
	dc.w	$f2e,$d947,$30a4,$6	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	27, $fbac	; Point index, texture coordinates
	dc.w	14, $7df8	; Point index, texture coordinates
	dc.w	15, $e6fd	; Point index, texture coordinates

;* Face 31
	dc.w	$dd5,$d80e,$300e,$5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	26, $8cac	; Point index, texture coordinates
	dc.w	14, $7df8	; Point index, texture coordinates
	dc.w	27, $fbac	; Point index, texture coordinates

;* Face 32
	dc.w	$27f9,$0,$31fb,$ffed	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	31, $00ff	; Point index, texture coordinates
	dc.w	30, $00ff	; Point index, texture coordinates
	dc.w	28, $00ff	; Point index, texture coordinates
	dc.w	29, $00ff	; Point index, texture coordinates

;* Face 33
	dc.w	$2f8,$c386,$14bc,$ffe2	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	33, $00ff	; Point index, texture coordinates
	dc.w	35, $00ff	; Point index, texture coordinates
	dc.w	34, $00ff	; Point index, texture coordinates

;* Face 34
	dc.w	$888,$c196,$b4d,$ffe0	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	32, $00ff	; Point index, texture coordinates
	dc.w	35, $00ff	; Point index, texture coordinates
	dc.w	33, $00ff	; Point index, texture coordinates

;* Face 35
	dc.w	$7,$c0e4,$aa6,$ffe1	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	9, $00ff	; Point index, texture coordinates
	dc.w	35, $00ff	; Point index, texture coordinates
	dc.w	32, $00ff	; Point index, texture coordinates
	dc.w	4, $00ff	; Point index, texture coordinates

;* Face 36
	dc.w	$2737,$1573,$2dce,$fff4	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	29, $00ff	; Point index, texture coordinates
	dc.w	33, $00ff	; Point index, texture coordinates
	dc.w	34, $00ff	; Point index, texture coordinates

;* Face 37
	dc.w	$2569,$168c,$2ec7,$fff6	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	28, $00ff	; Point index, texture coordinates
	dc.w	33, $00ff	; Point index, texture coordinates
	dc.w	29, $00ff	; Point index, texture coordinates

;* Face 38
	dc.w	$2f7,$3c7a,$14ba,$1	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	39, $00ff	; Point index, texture coordinates
	dc.w	37, $00ff	; Point index, texture coordinates
	dc.w	38, $00ff	; Point index, texture coordinates

;* Face 39
	dc.w	$887,$3e6a,$b4d,$0	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	39, $00ff	; Point index, texture coordinates
	dc.w	36, $00ff	; Point index, texture coordinates
	dc.w	37, $00ff	; Point index, texture coordinates

;* Face 40
	dc.w	$5,$3f1c,$aa6,$2	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	36, $00ff	; Point index, texture coordinates
	dc.w	39, $00ff	; Point index, texture coordinates
	dc.w	15, $00ff	; Point index, texture coordinates
	dc.w	10, $00ff	; Point index, texture coordinates

;* Face 41
	dc.w	$2736,$ea7d,$2dc7,$ffe9	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	37, $00ff	; Point index, texture coordinates
	dc.w	31, $00ff	; Point index, texture coordinates
	dc.w	38, $00ff	; Point index, texture coordinates

;* Face 42
	dc.w	$2566,$e965,$2ec2,$ffea	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	37, $00ff	; Point index, texture coordinates
	dc.w	30, $00ff	; Point index, texture coordinates
	dc.w	31, $00ff	; Point index, texture coordinates

;* Face 43
	dc.w	$11a5,$0,$c27b,$ffee	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	42, $90ac	; Point index, texture coordinates
	dc.w	24, $ffac	; Point index, texture coordinates
	dc.w	20, $ff53	; Point index, texture coordinates
	dc.w	40, $9053	; Point index, texture coordinates

;* Face 44
	dc.w	$27a5,$0,$cdc2,$ffec	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	30, $00ac	; Point index, texture coordinates
	dc.w	42, $90ac	; Point index, texture coordinates
	dc.w	40, $9053	; Point index, texture coordinates
	dc.w	28, $0053	; Point index, texture coordinates

;* Face 45
	dc.w	$d9b5,$0,$3348,$12	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	43, $8cac	; Point index, texture coordinates
	dc.w	31, $04ac	; Point index, texture coordinates
	dc.w	29, $0453	; Point index, texture coordinates
	dc.w	41, $8c53	; Point index, texture coordinates

;* Face 46
	dc.w	$ee4b,$0,$3d81,$10	; face normal
	dc.w	4		; number of points
	dc.w	1		; material RADAR1B
	dc.w	27, $fbac	; Point index, texture coordinates
	dc.w	43, $8cac	; Point index, texture coordinates
	dc.w	41, $8c53	; Point index, texture coordinates
	dc.w	23, $fb53	; Point index, texture coordinates

;* Face 47
	dc.w	$efb,$d889,$cfe5,$ffe4	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	40, $9053	; Point index, texture coordinates
	dc.w	4, $eb00	; Point index, texture coordinates
	dc.w	32, $8105	; Point index, texture coordinates

;* Face 48
	dc.w	$e14,$d96b,$ceea,$ffe5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	20, $ff53	; Point index, texture coordinates
	dc.w	4, $eb00	; Point index, texture coordinates
	dc.w	40, $9053	; Point index, texture coordinates

;* Face 49
	dc.w	$224b,$d68f,$dd53,$ffe0	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	28, $0053	; Point index, texture coordinates
	dc.w	32, $8105	; Point index, texture coordinates
	dc.w	33, $0423	; Point index, texture coordinates

;* Face 50
	dc.w	$20f5,$dc6f,$d63b,$ffe3	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	40, $9053	; Point index, texture coordinates
	dc.w	32, $8105	; Point index, texture coordinates
	dc.w	28, $0053	; Point index, texture coordinates

;* Face 51
	dc.w	$dd4f,$2354,$288d,$1c	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	41, $8c53	; Point index, texture coordinates
	dc.w	34, $0824	; Point index, texture coordinates
	dc.w	35, $7d07	; Point index, texture coordinates

;* Face 52
	dc.w	$e36d,$2a9b,$2644,$1d	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	29, $0453	; Point index, texture coordinates
	dc.w	34, $0824	; Point index, texture coordinates
	dc.w	41, $8c53	; Point index, texture coordinates

;* Face 53
	dc.w	$f0da,$26d0,$3095,$1a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	23, $fb53	; Point index, texture coordinates
	dc.w	35, $7d07	; Point index, texture coordinates
	dc.w	9, $e602	; Point index, texture coordinates

;* Face 54
	dc.w	$f22f,$2804,$3000,$1a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	41, $8c53	; Point index, texture coordinates
	dc.w	35, $7d07	; Point index, texture coordinates
	dc.w	23, $fb53	; Point index, texture coordinates

;* Face 55
	dc.w	$f03,$2765,$cfd9,$fff9	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	10, $ebff	; Point index, texture coordinates
	dc.w	42, $90ac	; Point index, texture coordinates
	dc.w	36, $81fa	; Point index, texture coordinates

;* Face 56
	dc.w	$e18,$2680,$cedb,$fff8	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	10, $ebff	; Point index, texture coordinates
	dc.w	24, $ffac	; Point index, texture coordinates
	dc.w	42, $90ac	; Point index, texture coordinates

;* Face 57
	dc.w	$2258,$2953,$dd3b,$fff5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	36, $81fa	; Point index, texture coordinates
	dc.w	30, $00ac	; Point index, texture coordinates
	dc.w	37, $04dc	; Point index, texture coordinates

;* Face 58
	dc.w	$20ff,$2379,$d62e,$fff5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	36, $81fa	; Point index, texture coordinates
	dc.w	42, $90ac	; Point index, texture coordinates
	dc.w	30, $00ac	; Point index, texture coordinates

;* Face 59
	dc.w	$dd47,$dcc4,$289c,$a	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	38, $08db	; Point index, texture coordinates
	dc.w	43, $8cac	; Point index, texture coordinates
	dc.w	39, $7df8	; Point index, texture coordinates

;* Face 60
	dc.w	$e35d,$d583,$265a,$7	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	38, $08db	; Point index, texture coordinates
	dc.w	31, $04ac	; Point index, texture coordinates
	dc.w	43, $8cac	; Point index, texture coordinates

;* Face 61
	dc.w	$f0d2,$d947,$30a4,$6	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	39, $7df8	; Point index, texture coordinates
	dc.w	27, $fbac	; Point index, texture coordinates
	dc.w	15, $e6fd	; Point index, texture coordinates

;* Face 62
	dc.w	$f22b,$d80e,$300e,$5	; face normal
	dc.w	3		; number of points
	dc.w	1		; material RADAR1B
	dc.w	39, $7df8	; Point index, texture coordinates
	dc.w	43, $8cac	; Point index, texture coordinates
	dc.w	27, $fbac	; Point index, texture coordinates

;* Face 63
	dc.w	$3fbb,$fa1d,$0,$fffc	; face normal
	dc.w	4		; number of points
	dc.w	4		; material RADAR1D
	dc.w	17, $a200	; Point index, texture coordinates
	dc.w	18, $5d00	; Point index, texture coordinates
	dc.w	46, $00ff	; Point index, texture coordinates
	dc.w	45, $feff	; Point index, texture coordinates

;* Face 64
	dc.w	$c045,$fa1d,$0,$fffc	; face normal
	dc.w	4		; number of points
	dc.w	4		; material RADAR1D
	dc.w	19, $5d00	; Point index, texture coordinates
	dc.w	16, $a200	; Point index, texture coordinates
	dc.w	44, $feff	; Point index, texture coordinates
	dc.w	47, $00ff	; Point index, texture coordinates

;* Face 65
	dc.w	$0,$fa1d,$c045,$fffc	; face normal
	dc.w	4		; number of points
	dc.w	4		; material RADAR1D
	dc.w	16, $5c00	; Point index, texture coordinates
	dc.w	17, $a000	; Point index, texture coordinates
	dc.w	45, $fcff	; Point index, texture coordinates
	dc.w	44, $00ff	; Point index, texture coordinates

;* Face 66
	dc.w	$0,$fa1d,$3fbb,$fffc	; face normal
	dc.w	4		; number of points
	dc.w	4		; material RADAR1D
	dc.w	18, $a000	; Point index, texture coordinates
	dc.w	19, $5c00	; Point index, texture coordinates
	dc.w	47, $00ff	; Point index, texture coordinates
	dc.w	46, $fcff	; Point index, texture coordinates

;* Face 67
	dc.w	$0,$0,$4000,$1	; face normal
	dc.w	4		; number of points
	dc.w	5		; material RADAR1E
	dc.w	48, $7801	; Point index, texture coordinates
	dc.w	53, $7801	; Point index, texture coordinates
	dc.w	54, $8701	; Point index, texture coordinates
	dc.w	49, $8701	; Point index, texture coordinates

;* Face 68
	dc.w	$2f2a,$0,$2b43,$0	; face normal
	dc.w	4		; number of points
	dc.w	5		; material RADAR1E
	dc.w	49, $8701	; Point index, texture coordinates
	dc.w	54, $8701	; Point index, texture coordinates
	dc.w	55, $ffc1	; Point index, texture coordinates
	dc.w	50, $ffc1	; Point index, texture coordinates

;* Face 69
	dc.w	$13f1,$0,$c32f,$fff0	; face normal
	dc.w	4		; number of points
	dc.w	5		; material RADAR1E
	dc.w	50, $ffc1	; Point index, texture coordinates
	dc.w	55, $ffc1	; Point index, texture coordinates
	dc.w	56, $80ff	; Point index, texture coordinates
	dc.w	51, $80ff	; Point index, texture coordinates

;* Face 70
	dc.w	$ec0f,$0,$c32f,$fff0	; face normal
	dc.w	4		; number of points
	dc.w	5		; material RADAR1E
	dc.w	51, $80ff	; Point index, texture coordinates
	dc.w	56, $80ff	; Point index, texture coordinates
	dc.w	57, $00c1	; Point index, texture coordinates
	dc.w	52, $00c1	; Point index, texture coordinates

;* Face 71
	dc.w	$d0d6,$0,$2b43,$0	; face normal
	dc.w	4		; number of points
	dc.w	5		; material RADAR1E
	dc.w	52, $00c1	; Point index, texture coordinates
	dc.w	57, $00c1	; Point index, texture coordinates
	dc.w	53, $7801	; Point index, texture coordinates
	dc.w	48, $7801	; Point index, texture coordinates

;* Face 72
	dc.w	$0,$c000,$0,$ffee	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	48, $7801	; Point index, texture coordinates
	dc.w	51, $80ff	; Point index, texture coordinates
	dc.w	52, $00c1	; Point index, texture coordinates

;* Face 73
	dc.w	$0,$c000,$0,$ffee	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	51, $80ff	; Point index, texture coordinates
	dc.w	48, $7801	; Point index, texture coordinates
	dc.w	49, $8701	; Point index, texture coordinates
	dc.w	50, $ffc1	; Point index, texture coordinates

;* Face 74
	dc.w	$0,$4000,$0,$f	; face normal
	dc.w	3		; number of points
	dc.w	3		; material RADAR1C
	dc.w	56, $80ff	; Point index, texture coordinates
	dc.w	53, $7801	; Point index, texture coordinates
	dc.w	57, $00c1	; Point index, texture coordinates

;* Face 75
	dc.w	$0,$4000,$0,$f	; face normal
	dc.w	4		; number of points
	dc.w	3		; material RADAR1C
	dc.w	54, $8701	; Point index, texture coordinates
	dc.w	53, $7801	; Point index, texture coordinates
	dc.w	56, $80ff	; Point index, texture coordinates
	dc.w	55, $ffc1	; Point index, texture coordinates

;* Face 76
	dc.w	$0,$f339,$3eb6,$fff9	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	58, $00fe	; Point index, texture coordinates
	dc.w	60, $1c00	; Point index, texture coordinates
	dc.w	61, $e300	; Point index, texture coordinates
	dc.w	59, $fffe	; Point index, texture coordinates

;* Face 77
	dc.w	$c9b1,$f339,$1f5b,$fff9	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	59, $00fe	; Point index, texture coordinates
	dc.w	61, $1c00	; Point index, texture coordinates
	dc.w	63, $e300	; Point index, texture coordinates
	dc.w	62, $fffe	; Point index, texture coordinates

;* Face 78
	dc.w	$c99c,$f343,$e0c4,$fff8	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	62, $00fe	; Point index, texture coordinates
	dc.w	63, $1c00	; Point index, texture coordinates
	dc.w	65, $e300	; Point index, texture coordinates
	dc.w	64, $fffe	; Point index, texture coordinates

;* Face 79
	dc.w	$0,$f339,$c14a,$fff8	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	64, $00fe	; Point index, texture coordinates
	dc.w	65, $1c00	; Point index, texture coordinates
	dc.w	67, $e300	; Point index, texture coordinates
	dc.w	66, $fffe	; Point index, texture coordinates

;* Face 80
	dc.w	$364f,$f339,$e0a5,$fff8	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	66, $00fe	; Point index, texture coordinates
	dc.w	67, $1c00	; Point index, texture coordinates
	dc.w	69, $e300	; Point index, texture coordinates
	dc.w	68, $fffe	; Point index, texture coordinates

;* Face 81
	dc.w	$364f,$f339,$1f5b,$fff8	; face normal
	dc.w	4		; number of points
	dc.w	0		; material TURRET1B
	dc.w	68, $00fe	; Point index, texture coordinates
	dc.w	69, $1c00	; Point index, texture coordinates
	dc.w	60, $e300	; Point index, texture coordinates
	dc.w	58, $fffe	; Point index, texture coordinates

;* Face 82
	dc.w	$0,$c000,$0,$3	; face normal
	dc.w	4		; number of points
	dc.w	2		; material RADAR1A
	dc.w	61, $8000	; Point index, texture coordinates
	dc.w	67, $80ff	; Point index, texture coordinates
	dc.w	65, $01c3	; Point index, texture coordinates
	dc.w	63, $0140	; Point index, texture coordinates

;* Face 83
	dc.w	$0,$c000,$0,$3	; face normal
	dc.w	4		; number of points
	dc.w	2		; material RADAR1A
	dc.w	60, $fe40	; Point index, texture coordinates
	dc.w	69, $fec2	; Point index, texture coordinates
	dc.w	67, $80ff	; Point index, texture coordinates
	dc.w	61, $8000	; Point index, texture coordinates

	.long
.vertlist:
;* Vertex 0
	dc.w	-32,-22,-1	; coordinates
	dc.w	$c20b,$f0f4,$058a	; vertex normal

;* Vertex 1
	dc.w	-31,-22,0	; coordinates
	dc.w	$fd88,$12b1,$3d29	; vertex normal

;* Vertex 2
	dc.w	-32,-11,-1	; coordinates
	dc.w	$c543,$0e36,$eaef	; vertex normal

;* Vertex 3
	dc.w	-31,-11,0	; coordinates
	dc.w	$ed67,$ee07,$3a8b	; vertex normal

;* Vertex 4
	dc.w	0,-33,-10	; coordinates
	dc.w	$0000,$c973,$de87	; vertex normal

;* Vertex 5
	dc.w	-15,-32,-6	; coordinates
	dc.w	$ee75,$c512,$ee3d	; vertex normal

;* Vertex 6
	dc.w	-30,-28,4	; coordinates
	dc.w	$d792,$d842,$1db4	; vertex normal

;* Vertex 7
	dc.w	-29,-28,5	; coordinates
	dc.w	$08e1,$1063,$3d3a	; vertex normal

;* Vertex 8
	dc.w	-14,-32,-4	; coordinates
	dc.w	$10a3,$e915,$3965	; vertex normal

;* Vertex 9
	dc.w	0,-33,-8	; coordinates
	dc.w	$0000,$ce03,$27f7	; vertex normal

;* Vertex 10
	dc.w	0,0,-10	; coordinates
	dc.w	$0000,$3684,$de79	; vertex normal

;* Vertex 11
	dc.w	-15,-1,-6	; coordinates
	dc.w	$ee6e,$3ae8,$ee31	; vertex normal

;* Vertex 12
	dc.w	-30,-4,4	; coordinates
	dc.w	$d785,$27b4,$1daf	; vertex normal

;* Vertex 13
	dc.w	-29,-5,5	; coordinates
	dc.w	$08eb,$efaf,$3d3d	; vertex normal

;* Vertex 14
	dc.w	-14,-1,-4	; coordinates
	dc.w	$10a4,$16f8,$395f	; vertex normal

;* Vertex 15
	dc.w	0,0,-8	; coordinates
	dc.w	$0000,$31fe,$27f6	; vertex normal

;* Vertex 16
	dc.w	-1,-29,-1	; coordinates
	dc.w	$ebfc,$d241,$d7f8	; vertex normal

;* Vertex 17
	dc.w	1,-29,-1	; coordinates
	dc.w	$31ab,$e02e,$e72b	; vertex normal

;* Vertex 18
	dc.w	1,-29,1	; coordinates
	dc.w	$1404,$d241,$2808	; vertex normal

;* Vertex 19
	dc.w	-1,-29,1	; coordinates
	dc.w	$ce55,$e02e,$18d5	; vertex normal

;* Vertex 20
	dc.w	0,-22,-18	; coordinates
	dc.w	$0000,$f200,$c18d	; vertex normal

;* Vertex 21
	dc.w	-15,-22,-14	; coordinates
	dc.w	$e3a6,$ebbc,$ca52	; vertex normal

;* Vertex 22
	dc.w	-15,-22,-12	; coordinates
	dc.w	$1b0c,$1528,$3602	; vertex normal

;* Vertex 23
	dc.w	0,-22,-16	; coordinates
	dc.w	$0000,$1c8f,$3946	; vertex normal

;* Vertex 24
	dc.w	0,-11,-18	; coordinates
	dc.w	$0000,$1508,$c38e	; vertex normal

;* Vertex 25
	dc.w	-15,-11,-14	; coordinates
	dc.w	$e79b,$142f,$c862	; vertex normal

;* Vertex 26
	dc.w	-15,-11,-12	; coordinates
	dc.w	$1eae,$eaf3,$3413	; vertex normal

;* Vertex 27
	dc.w	0,-11,-16	; coordinates
	dc.w	$0000,$ea6d,$3c41	; vertex normal

;* Vertex 28
	dc.w	32,-22,-1	; coordinates
	dc.w	$3df5,$f0f4,$058a	; vertex normal

;* Vertex 29
	dc.w	31,-22,0	; coordinates
	dc.w	$0278,$12b1,$3d29	; vertex normal

;* Vertex 30
	dc.w	32,-11,-1	; coordinates
	dc.w	$3abd,$0e36,$eaef	; vertex normal

;* Vertex 31
	dc.w	31,-11,0	; coordinates
	dc.w	$1299,$ee07,$3a8b	; vertex normal

;* Vertex 32
	dc.w	14,-32,-6	; coordinates
	dc.w	$118b,$c512,$ee3d	; vertex normal

;* Vertex 33
	dc.w	29,-28,4	; coordinates
	dc.w	$286e,$d842,$1db4	; vertex normal

;* Vertex 34
	dc.w	28,-28,5	; coordinates
	dc.w	$f71f,$1063,$3d3a	; vertex normal

;* Vertex 35
	dc.w	14,-32,-4	; coordinates
	dc.w	$ef5d,$e915,$3965	; vertex normal

;* Vertex 36
	dc.w	14,-1,-6	; coordinates
	dc.w	$1192,$3ae8,$ee31	; vertex normal

;* Vertex 37
	dc.w	29,-4,4	; coordinates
	dc.w	$287b,$27b4,$1daf	; vertex normal

;* Vertex 38
	dc.w	28,-5,5	; coordinates
	dc.w	$f715,$efaf,$3d3d	; vertex normal

;* Vertex 39
	dc.w	14,-1,-4	; coordinates
	dc.w	$ef5c,$16f8,$395f	; vertex normal

;* Vertex 40
	dc.w	15,-22,-14	; coordinates
	dc.w	$1c5a,$ebbc,$ca52	; vertex normal

;* Vertex 41
	dc.w	15,-22,-12	; coordinates
	dc.w	$e4f4,$1528,$3602	; vertex normal

;* Vertex 42
	dc.w	15,-11,-14	; coordinates
	dc.w	$1865,$142f,$c862	; vertex normal

;* Vertex 43
	dc.w	15,-11,-12	; coordinates
	dc.w	$e152,$eaf3,$3413	; vertex normal

;* Vertex 44
	dc.w	-4,3,-4	; coordinates
	dc.w	$c731,$f821,$e398	; vertex normal

;* Vertex 45
	dc.w	4,3,-4	; coordinates
	dc.w	$1c68,$f821,$c731	; vertex normal

;* Vertex 46
	dc.w	4,3,4	; coordinates
	dc.w	$38cf,$f821,$1c68	; vertex normal

;* Vertex 47
	dc.w	-4,3,4	; coordinates
	dc.w	$e398,$f821,$38cf	; vertex normal

;* Vertex 48
	dc.w	-1,-18,-1	; coordinates
	dc.w	$f237,$da96,$320f	; vertex normal

;* Vertex 49
	dc.w	1,-18,-1	; coordinates
	dc.w	$1b93,$da96,$2c00	; vertex normal

;* Vertex 50
	dc.w	11,-18,-13	; coordinates
	dc.w	$29bd,$e150,$da6c	; vertex normal

;* Vertex 51
	dc.w	0,-18,-17	; coordinates
	dc.w	$fb32,$d1bc,$d40a	; vertex normal

;* Vertex 52
	dc.w	-11,-18,-13	; coordinates
	dc.w	$c935,$e150,$0c54	; vertex normal

;* Vertex 53
	dc.w	-1,-15,-1	; coordinates
	dc.w	$e46d,$256a,$2c00	; vertex normal

;* Vertex 54
	dc.w	1,-15,-1	; coordinates
	dc.w	$0dc9,$256a,$320f	; vertex normal

;* Vertex 55
	dc.w	11,-15,-13	; coordinates
	dc.w	$36cb,$1eb0,$0c54	; vertex normal

;* Vertex 56
	dc.w	0,-15,-17	; coordinates
	dc.w	$04ce,$2e44,$d40a	; vertex normal

;* Vertex 57
	dc.w	-11,-15,-13	; coordinates
	dc.w	$d643,$1eb0,$da6c	; vertex normal

;* Vertex 58
	dc.w	8,26,13	; coordinates
	dc.w	$1469,$f197,$3aec	; vertex normal

;* Vertex 59
	dc.w	-8,26,13	; coordinates
	dc.w	$d72e,$f197,$2f23	; vertex normal

;* Vertex 60
	dc.w	5,3,8	; coordinates
	dc.w	$1d97,$d2b0,$222b	; vertex normal

;* Vertex 61
	dc.w	-5,3,8	; coordinates
	dc.w	$f3c1,$cc12,$2359	; vertex normal

;* Vertex 62
	dc.w	-15,26,0	; coordinates
	dc.w	$c2bd,$f1a2,$f450	; vertex normal

;* Vertex 63
	dc.w	-10,3,0	; coordinates
	dc.w	$ca83,$de6c,$0a5e	; vertex normal

;* Vertex 64
	dc.w	-8,26,-13	; coordinates
	dc.w	$eb95,$f1a3,$c512	; vertex normal

;* Vertex 65
	dc.w	-5,3,-9	; coordinates
	dc.w	$e25a,$d2b0,$dde2	; vertex normal

;* Vertex 66
	dc.w	8,26,-13	; coordinates
	dc.w	$28d3,$f197,$d0dd	; vertex normal

;* Vertex 67
	dc.w	5,3,-9	; coordinates
	dc.w	$0c3f,$cc12,$dca7	; vertex normal

;* Vertex 68
	dc.w	15,26,0	; coordinates
	dc.w	$3d3c,$f197,$0bc9	; vertex normal

;* Vertex 69
	dc.w	10,3,0	; coordinates
	dc.w	$357e,$de67,$f5b5	; vertex normal


	.extern	_turret1b
	.extern	_radar1b
	.extern	_radar1a
	.extern	_radar1d
	.extern	_radar1e
	.phrase
.matlist:

; Material 0: TURRET1B
	dc.w	$9841, 0
	dc.l	._turret1b_bitmap	; texture

; Material 1: RADAR1B
	dc.w	$9827, 0
	dc.l	._radar1b_bitmap	; texture

; Material 2: RADAR1A
	dc.w	$8722, 0
	dc.l	._radar1a_bitmap	; texture

; Material 3: RADAR1C
	dc.w	$783e, 0
	dc.l	0		; no texture

; Material 4: RADAR1D
	dc.w	$a81c, 0
	dc.l	._radar1d_bitmap	; texture

; Material 5: RADAR1E
	dc.w	$a811, 0
	dc.l	._radar1e_bitmap	; texture

._turret1b_bitmap:
	.dc.w	32, 48
	.dc.l	PITCH1|PIXEL16|WID32
	.dc.l	_turret1b
._radar1b_bitmap:
	.dc.w	64, 64
	.dc.l	PITCH1|PIXEL16|WID64
	.dc.l	_radar1b
._radar1a_bitmap:
	.dc.w	32, 32
	.dc.l	PITCH1|PIXEL16|WID32
	.dc.l	_radar1a
._radar1d_bitmap:
	.dc.w	24, 96
	.dc.l	PITCH1|PIXEL16|WID24
	.dc.l	_radar1d
._radar1e_bitmap:
	.dc.w	32, 24
	.dc.l	PITCH1|PIXEL16|WID32
	.dc.l	_radar1e

