
	.include "jaguar.inc"
	.include "vidstuff.inc"

	.text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.extern	BPEGInitTable	; subroutine for create/init table
	.extern	BPEGInit	; Copy over GPU code into GPU RAM
	.extern	BPEGDecode	; Execute decode routines
	.extern	BPEGStatus	; semaphore for "finished decoding" status

	.extern	fish_jpg	; picture #1
	.extern	pat_jpg		; picture #2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

test_jagpeg::
	bsr	BPEGInitTable	; create/init 8k table
	bsr	BPEGInit	; copy over GPU code

.show_fish:
	lea	fish_jpg,a0		; Address of compressed picture data
	lea	bitmap_addr,a1		; Get destination address
	move.l	#((WIDTH*DEPTH)/8),d0	; Width of destination bitmap, in bytes
	bsr	BPEGDecode		; Decode image

.wait_fish:
	tst.l	BPEGStatus		; Wait for decompression to finish
	bmi.s	.wait_fish		; before continuing...

	lea	pat_jpg,a0		; Address of compressed picture data
	lea	bitmap_addr,a1		; Get destination address
	move.l	#((WIDTH*DEPTH)/8),d0	; Width of destination bitmap, in bytes
	bsr	BPEGDecode		; Decode image

.wait_patrick:
	tst.l	BPEGStatus		; Wait for decompression to finish
	bmi.s	.wait_patrick		; before continuing...

	bra	.show_fish	; Switch back and forth
	rts			; til reset or powerdown.

	.phrase

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.bss

DataBitsBuffer::		; RAM buffer used by BPEG routines...
	.ds.b	8192		; for a variety of things...

