;*======================================================================*
;*                TITLE:                  JOYPAD.INC                    *
;*                Function:               Joypad bit definitions        *
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                Programmer:             Rob Zdybel                    *
;*                                                                      *
;*                MODIFIED:               Andrew J Burgess  04/13/93    *
;*                                                                      *
;*              COPYRIGHT 1993 Atari Computer Corporation               *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*

	JOYIN		equ	$F14000
	JOYOUT		equ	$F14000

	NUM_PLAYERS	equ	1
;
;	Format = xxAPxxBx RLDU147* xxCxxxOx 2580369#
;
	JOY_UP		equ	20		;joypad
	JOY_DOWN		equ	21
	JOY_LEFT		equ	22
	JOY_RIGHT		equ	23

	FIRE_A		equ	29		;fire buttons
	FIRE_B		equ	25
	FIRE_C		equ	13
	OPTION		equ	9
	PAUSE		equ	28

	KEY_STAR		equ	16		;keypad
	KEY_7		equ	17
	KEY_4		equ	18
	KEY_1		equ	19

	KEY_0		equ	4
	KEY_8		equ	5
	KEY_5		equ	6
	KEY_2		equ	7

	KEY_HASH		equ	0
	KEY_9		equ	1
	KEY_6		equ	2
	KEY_3		equ	3

	ANY_JOY		equ	$00F00000		;and joyedge with this - joypad was pressed if result is not 0
	ANY_FIRE		equ	$32002200		;and joyedge with this - A,B C, Option or Pause was pressed if result is not 0
	ANY_KEY		equ	$000F00FF		;and joyedge with this - 123456789*0# was pressed if result is not 0

;*======================================================================*
;*                              EOF
;*======================================================================*

