;**************************************************************************
;
;	OBJLIST.INC  Hardware Equates for JAGUAR System
;
;	Copyright 1992 Atari U.S. Corp.
;
;**************************************************************************
;offsets for each object in the user object list
O_XPOS		equ	0	;word	object xpos
O_YPOS		equ	2	;word	object ypos in half lines
O_DATA		equ	4	;long	phrase aligned address of object data
O_HEIGHT		equ	8	;word	height of object in pixels
O_DWIDTH		equ	10	;word	phrases per line of data in object (bytes per line / 8)
O_IWIDTH		equ	12	;word	phrases per line (bytes per line / 8)
					;this is how many phrases of data to draw per line
					;this should be the same as O_DWIDTH to draw the whole object
O_FLAGS		equ	14	;byte	flags for reflect, RMW, transparent, release
					;settings for bits in O_FLAGS byte
					HFLIP_OFF		equ	0
					HFLIP_ON		equ	1	;bit 0 = horizontal flip (reflect)
					RMW_OFF		equ	0
					RMW_ON		equ	2	;bit 1 = RMW flag
					TRANS_OFF		equ	0
					TRANS_ON		equ	4	;bit 2 = transparent flag
					RELEASE_OFF	equ	0
					RELEASE_ON	equ	8	;bit 3 = release
O_FIRSTPIX	equ	15	;byte	first pixel to be displayed in one line of an object
					;pixels to skip = O_FIRSTPIX / bits per pixel
O_TYPE		equ	16	;byte	object type
					;0 = bit mapped object
					;1 = scaled bit mapped object
					;2 = graphics processor object
					;3 = branch object
					;4 = stop object
DELETE_OBJ	equ	$80	;if negative bit is set in O_TYPE, object is not included in the final object list
O_DEPTH		equ	17	;byte	pixel depth
					;0 = 1 bit per pixel
					;1 = 2 bits per pixel
					;2 = 4 bits per pixel
					;3 = 8 bits per pixel
					;4 = 16 bits per pixel (CRY)
					;5 = 24 bits per pixel
O_PITCH		equ	18	;byte	pitch
					;how many phrases to skip each time a new phrase is fetched
					;0 = repeat the same phrase
					;1 = contiguous data
					;2 = get every other phrase
					;3 = get every third phrase, etc.
O_INDEX		equ	19	;byte	palette index
					;4 bits per pixel objects can use 0 - 120 (multiples of 8 only)
					;2 bits per pixel objects can use 0 - 126 (multiples of 2 only)
					;1 bit  per pixel objects can use 0 - 127
					;starting color number will be index * 2
O_DESC		equ	20	;word	object description (can be set to anything by user - this is not used by object list builder)
O_SCALE		equ	22	;long	scaling information to write in 2nd long of phrase 3
					;1st byte is unused
O_REMAINDER	equ	23	;2nd byte is remainder, same as vscale
O_VSCALE		equ	24	;3rd byte is vscale, 3 bits + 5 bit fraction
O_HSCALE		equ	25	;4th byte is hscale, 3 bits + 5 bit fraction

OBJ_SIZE		equ	26	;total bytes used for one object


