;*======================================================================*
;*                TITLE:    VIDEO.S                                     *
;*                Function: Video and Object Processor Routines         *
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                                                                      *
;*                Programmer:             Leonard Tramiel               *
;*                                        Andrew J Burgess              *
;*                                        Rob Zdybel                    *
;*                                                                      *
;*              COPYRIGHT 1992,1993 Atari U.S. Corporation              *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*

	.title	"VIDEO.S - video initialization and VBLANK routines"

BAR_ON	EQU	0
CHRO_CLK	equ	$f10014	; Chroma clock control

	.include	"jaguar.inc"
	.include	"defs.inc"
	.include	"video.inc"

;*======================================================================*
;*	EXTERNAL SYMBOLS
;*======================================================================*

	.extern	disp_ptr		;* Display buffer ptr
;	.extern	sync			;* interrupt synchronization
	.extern	rate			;* frame rate specifier
	.extern	ratecnt			;* frame rate count
	.extern	framecnt		;* Count of Video Frames
	.extern	_wrkaJlist
	.extern	_wrkbJlist
	.extern _flagJlist


;*======================================================================*
;*	EXTERNAL ROUTINES
;*======================================================================*

;	.extern	_copyJlist
	.extern	_vcopyJlist

;*======================================================================*
;*	PUBLIC SYMBOLS
;*======================================================================*



;*======================================================================*
;*	PUBLIC ROUTINES
;*======================================================================*

	.globl	vblank
	.globl	vidinit
	.globl	vblinit

;*======================================================================*
;*	LOCAL EQUATES
;*======================================================================*

PHRASE		EQU	8
SCRNADDR	EQU	PHRASE
OBJSIZE		EQU	3*2

;additional defs by spock of TNG for three demo
;	VIDEO DEFINES
;
;vclk		EQU	399
vclk		EQU	376

horiz_per	EQU	317778
sync_per	EQU	46050
eq_per		EQU	23500
front_porch	EQU	17450
line_blank	EQU	109500


;disp_width	EQU	963	; own
;disp_width	EQU	1155	; from joypad example

; disp_width	EQU	1152	;this is in pixels (Leonard Uses)
; disp_width	EQU	1280	;this is in pixels (Leonard Advocates)
disp_width	EQU	1356	;this is in pixels (Gives best center)
; disp_width	EQU	1330	;

disp_height	EQU	200	;this is in lines
;disp_height	EQU	288	;this is in lines

; Horizontal computations

;n_hp		EQU	(horiz_per/vclk)-1
;n_hp		EQU	horiz_per/vclk-1
n_hp		EQU	horiz_per/vclk

n_hbb		EQU	((horiz_per-sync_per-front_porch)/vclk)+$400
n_hbe		EQU	(line_blank-sync_per-front_porch)/vclk
n_hs		EQU	((horiz_per-sync_per)/vclk)+$400
n_hvs		EQU	(horiz_per-(2*sync_per))/vclk
n_heq		EQU	(horiz_per-eq_per)/vclk
n_hde		EQU	((disp_width/2)-1)+$400
n_hdb1		EQU	((n_hp)-(disp_width/2))
n_hdb2		EQU	n_hdb1

; Vertical

n_vp		EQU	523
n_vee		EQU	6
n_vbe		EQU	40
n_vdb		EQU	n_vbe+4
;n_vdb		EQU	n_vbe+26-20
n_vde		EQU	n_vdb+(disp_height*2)
n_vbb		EQU	n_vde+40
n_vs		EQU	n_vp-10
n_veb		EQU	n_vs-n_vee
;end of addition by Spock of TNG for three demo

;*======================================================================*
;*	SUBROUTINE AREA
;*======================================================================*


;*======================================================================*
;*	VIDINIT   Initialize Video to 320x288 NTSC
;*
;*	Given:make
;*		Control
;*
;*	Returns:
;*		Video Disabled, but ready for 320x288 NTSC
;*
;*	Register Usage:
;*		None
;*
;*	Externals:
;*		None
;*
;*======================================================================*
	;; 
vidinit:			
	move.w	#0,VMODE	; Stop the Video (I want to get off)
  
;	clr.l	framecnt
;	move.w	#R60Hz,rate
;	clr.w	ratecnt
;	clr.w	sync

	move.w	#n_hp,HP
	move.w	#n_hbb,HBB
	move.w	#n_hbe,HBE
	move.w	#n_hs,HS
	move.w	#n_hvs,HVS
	move.w	#n_heq,HEQ
	move.w	#n_hde,HDE
	move.w	#n_hdb1,HDB1
	move.w	#n_hdb2,HDB2

	move.w	#n_vp,VP
	move.w	#n_vee,VEE
	move.w	#n_vbe,VBE
	move.w	#n_vdb,VDB
	move.w	#n_vde,VDE
	move.w	#n_vbb,VBB
	move.w	#n_veb,VEB
	move.w	#n_vs,VS

;	move.w	#$8000,$f10014

;	move.w	#$35cc,MEMCON2	;* do the old endian thing
;	move.w	#$8000,CHRO_CLK

	move.w	#$7c0,BG	; set the background color
	move.w	#$0,BORD1	; set the border color

	rts

;*======================================================================*
;*	VIDINIT   Initialize Video to 320x288 NTSC
;*
;*	Given:
;*		Control
;*
;*	Returns:
;*		Video Disabled, but ready for 320x288 NTSC
;*
;*	Register Usage:
;*		None
;*
;*	Externals:
;*		None
;*
;*======================================================================*
;	.text
;	.phrase
;; THESE ARE THE NTSC DEFINITIONS
;ntsc_width	equ	1409
;ntsc_hmid	equ	823

;ntsc_height	equ	241
;ntsc_vmid	equ	266

; THESE ARE THE PAL DEFINITIONS
;pal_width	equ	1381
;pal_hmid	equ	843	

;pal_height	equ	287
;pal_vmid	equ	322

;*======================================================================*
;*	LOCAL EQUATES
;*======================================================================*

;OBJECT_HEIGHT	EQU	(400/2)		; half 400 pixels high
;OBJECT_WIDTH	EQU	(320*4)		; 320 pixels across


;vidinit:
; Check if NTSC or PAL
; For now assume NTSC

;	movem.l	d0-d6,-(sp)

;	move.w	#0,VMODE	; Stop the Video (I want to get off)
;	move.w	CONFIG,d0
;	and.w	#$10,d0
;	beq	ispal

;	move.w	#ntsc_hmid,d2
;	move.w	#ntsc_width,d0

;	move.w	#ntsc_vmid,d6
;	move.w	#ntsc_height,d4

;	;move.w	#1,_VideoMode
;	;move.w	#60,_VideoFPS
;	bra	doit

;ispal:
;	move.w	#pal_hmid,d2
;	move.w	#pal_width,d0

;	move.w	#pal_vmid,d6
;	move.w	#pal_height,d4

;	;move.w	#2,_VideoMode
;	;move.w	#50,_VideoFPS
;doit:
	;------------------------------
					; calculate the x position
;	move.w	d0,d1			; video_x = ( width - object_width ) / 8
;	sub.w	#OBJECT_WIDTH,d1	; 4 for the cycles
;	lsr.w	#3,d1			; 2 for half the screen
;	move.w	d1,video_x
					
;	move.w	d6,d1			; calculate y position - these are in half pixels
;	sub.w	#OBJECT_HEIGHT,d1	; object height is half of the height ( 400 / 2 )
;	move.w	d1,video_y		; video_y = ( vmid - object_height ) in half pixels
	
	;------------------------------


;	move.w	d0,width
;	move.w	d4,height

;	move.w	d0,d1
;	asr	#1,d1			; Max width/2

;	sub.w	d1,d2			; middle-width/2
;	add.w	#4,d2			; (middle-width/2)+4
	
;	sub.w	#1,d1			; Width/2-1
;	or.w	#$400,d1		; (Width/2-1)|$400

;	move.w	d1,a_hde
;	move.w	d1,HDE

;	move.w	d2,a_hdb
;	move.w	d2,HDB1
;	move.w	d2,HDB2

;	move.w	d6,d5
;	sub.w	d4,d5			; already in half lines
;	move.w	d5,a_vdb

;	add.w	d4,d6
;	move.w	d6,a_vde

;	move.w	a_vdb,VDB
;	move.w	#$FFFF,VDE

; Also lets set up some default colors
;	move.w	#$8000,$f10014

;	;move.w	#$35cc,MEMCON2	; do the old endian thing
;	;move.w	#$8000,CHRO_CLK

;	move.w	#$7c0,BG	; set the background color
;	move.w	#$0,BORD1	; set the border color
;	movem.l	(sp)+,d0-d6
;	rts

;*======================================================================*
;*	VBLANK   Vertical Sync Interrupt Handler
;*
;*	Given:
;*		Control
;*
;*	Returns:
;*		Object List restored for next frame
;*
;*	Register Usage:
;*		All Registers Preserved
;*
;*	Externals:
;*		framecnt, disp_ptr, olist_ptr
;*
;*======================================================================*
vblank:
	movem.l	a0-a6/d0-d7,-(sp)

	move.w	INT1,d0
	cmp.w	#1,d0		;* is this a video interrupt?
	bne	odone
	tst.w	_toggleJlist	; there are two copies of the obj list
	bne	.takeB		; one is displayed while the other one gets
	move.l	_wrkaJlist, d1	; restored
	move.w	#2, _flagJlist
	bra	.goon
.takeB:	move.l	_wrkbJlist, d1
	move.w	#1, _flagJlist
.goon:
	swap	d1			;* and set the OLP
	move.l	d1,OLP
	eori.w	#1, _toggleJlist

odone:
	move.w	#$101,INT1	;* enable Video interrupt and clear all others pending
	move.w	#0,INT2

	movem.l	(sp)+,d0-d7/a0-a6
	rte

;
;
; This will set up the VI (Vertical line counter Interrupt)
; Or it would if the low order bit of INT1 REALLY was the VI interrupt
;
;
vblinit:

	movem.l	d0,-(sp)

	move.l	#vblank,LEVEL0

	move.w	#(n_vde | 1 ),VI
	move.w	#$1,INT1

	move.w	sr,d0
	and.w	#$f8ff,d0
	move.w	d0,sr

	movem.l	(sp)+,d0

	rts

	.68000
	.data

_toggleJlist:	.dc.w	0

	.phrase
	.bss
	.phrase
height:
	ds.w	1
a_vdb:
	ds.w	1
a_vde:
	ds.w	1
width:
	ds.w	1
a_hdb:
	ds.w	1
a_hde:
	ds.w	1
video_x:
	.ds.w	1
video_y:
	.ds.w	1
	.phrase
	.end

;*======================================================================*
;*				EOF
;*======================================================================*
