;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Jaguar Example Source Code
; Copyright (c)1994 Atari Corp.
; ALL RIGHTS RESERVED
;
; Program: hv.cof
;  Module: hv_joy.s   	- Main Program Loop
;
; Revision History:
; 9/2/94   - SDS: Created
;
		.include	"jaguar.inc"
		.include	"hv2.inc"

; Globals
		.globl		JoyLoop

; Externals
		.extern		JAGPIC
		.extern		chopper
		.extern		stillife

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: JoyLoop
;
JoyLoop:
		jsr		ReadJoypads			; Read Joypad 1 and 2
		jsr		ParseInput			; React on Joy-Events

		bra		JoyLoop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: ReadJoypads
;
;	Read both joypads and update state variables!
;
; Store a bitmask of the current state of the joysticks in joy1cur
; and joy2cur. The variables joy1edge and joy2edge stores a state
; bitmap of new key 'down' events (never 'up' events) since the last
; time ReadJoypads was called.
;
; The code below may be altered by removing two AND instructions so
; that joy1edge and joy2edge contain a bitmap of keys that have changed
; (not pressed). If desired, this data could be compared to joy1cur and
; joy2cur to determine the actual button state.
;
ReadJoypads:
		movem.l	d0-d2/a0,-(sp)

		lea			JOYSTICK,a0

		move.l	#$f0fffffc,d1	; d1 = Joypad data mask
		moveq.l	#-1,d2		 		; d2 = Cumulative joypad reading

		move.w	#$81fe,(a0)
		move.l	(a0),d0		 		; Read joypad, pause button, A button
		or.l		d1,d0					; Mask off unused bits
		ror.l		#4,d0
		and.l		d0,d2					; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
		move.w	#$81fd,(a0)
		move.l	(a0),d0				; Read *741 keys, B button
		or.l		d1,d0					; Mask off unused bits
		ror.l		#8,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
		move.w	#$81fb,(a0)
		move.l	(a0),d0				; Read 2580 keys, C button
		or.l		d1,d0					; Mask off unused bits
		rol.l		#6,d0
		rol.l		#6,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
		move.w	#$81f7,(a0)
		move.l	(a0),d0				; Read 369# keys, Option button
		or.l		d1,d0					; Mask off unused bits
		rol.l		#8,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

		moveq.l	#-1,d1
		eor.l		d2,d1					; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

		move.l	joy1cur,d0		; old joycur needed for determining the new joyedge
		move.l	d1,joy1cur		; Current joypad reading stored into joycur
		eor.l		d1,d0

		and.l		d1,d0					; REMOVE IF DESIRED (AS DOCUMENTED ABOVE)
		
		move.l	d0,joy1edge		;joypad, buttons, keys that were just pressed

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Now scan for player 2
;
		move.l	#$0ffffff3,d1	; d1 = Joypad data mask
		moveq.l	#-1,d2				; d2 = Cumulative joypad reading

		move.w	#$817f,(a0)
		move.l	(a0),d0				; Read joypad, pause button, A button
		or.l		d1,d0					; Mask off unused bits
		rol.b		#2,d0					; note the size of rol
		ror.l		#8,d0
		and.l		d0,d2					; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
		move.w	#$81bf,(a0)
		move.l	(a0),d0				; Read *741 keys, B button
		or.l		d1,d0					; Mask off unused bits
		rol.b		#2,d0					; note the size of rol
		ror.l		#8,d0
		ror.l		#4,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
		move.w	#$81df,(a0)
		move.l	(a0),d0				; Read 2580 keys, C button
		or.l		d1,d0					; Mask off unused bits
		rol.b		#2,d0					; note the size of rol
		rol.l		#8,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
		move.w	#$81ef,(a0)
		move.l	(a0),d0				; Read 369# keys, Option button
		or.l		d1,d0					; Mask off unused bits
		rol.b		#2,d0					; note the size of rol
		rol.l		#4,d0
		and.l		d0,d2					; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

		moveq.l	#-1,d1
		eor.l		d2,d1					; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

		move.l	joy2cur,d0		; Old joycur needed for determining the new joyedge
		move.l	d1,joy2cur		; Current joypad reading stored into joycur
		eor.l		d1,d0

		and.l		d1,d0					; REMOVE IF DESIRED (AS DOCUMENTED ABOVE)

		move.l	d0,joy2edge		;joypad, buttons, keys that were just pressed

		movem.l	(sp)+,d0-d2/a0
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: ParseInput
;
ParseInput:
		movem.l	d0-d1/a0-a1,-(sp)

		move.l	#upd_freqx1,a0
		move.l	#upd_freqy1,a1

		move.l	joy1edge,d0
ck_up1:
		btst.l	#JOY_UP,d0
		beq.b		ck_down1
		sub.w		#1,(a1)
		bra.b		ck_left1
ck_down1:
		btst.l	#JOY_DOWN,d0
		beq.b		ck_left1
		add.w		#1,(a1)
ck_left1:
		btst.l	#JOY_LEFT,d0
		beq.b		ck_right1
		add.w		#1,(a0)
		bra			ck_joy_2player
ck_right1:
		btst.l	#JOY_RIGHT,d0
		beq.b		ck_fireABC1
		sub.w		#1,(a0)

ck_fireABC1:
		move.l	#img_adr1,a0

		move.l	joy1cur,d0

ck_fireA1:
		btst.l	#FIRE_A,d0
		beq.b		ck_fireB1

		move.l	#JAGPIC,(a0)
ck_fireB1:
		btst.l	#FIRE_B,d0
		beq.b		ck_fireC1
		move.l	#chopper,(a0)
ck_fireC1:
		btst.l	#FIRE_C,d0
		beq.b		ck_joy_2player
		move.l	#stillife,(a0)

ck_joy_2player:
		move.l	#bmp_hscl2,a0
		move.l	#bmp_vscl2,a1

		move.l	joy2edge,d0
ck_up2:
		btst.l	#JOY_UP,d0
		beq.b		ck_down2
		sub.w		#1,(a1)
		bra.b		ck_left2
ck_down2:
		btst.l	#JOY_DOWN,d0
		beq.b		ck_left2
		add.w		#1,(a1)
ck_left2:
		btst.l	#JOY_LEFT,d0
		beq.b		ck_right2
		sub.w		#1,(a0)
		bra			end_joy
ck_right2:
		btst.l	#JOY_RIGHT,d0
		beq.b		ck_fireABC2
		add.w		#1,(a0)
ck_fireABC2:
		move.l	#img_adr2,a0

		move.l	joy2cur,d0
ck_fireA2:
		btst.l	#FIRE_A,d0
		beq.b		ck_fireB2
		move.l	#JAGPIC,(a0)
ck_fireB2:
		btst.l	#FIRE_B,d0
		beq.b		ck_fireC2
		move.l	#chopper,(a0)
ck_fireC2:
		btst.l	#FIRE_C,d0
		beq.b		end_joy
		move.l	#stillife,(a0)

end_joy:
		movem.l	(sp)+,d0-d1/a0-a1
		rts

		.data
upd_freqx1:	dc.l	50
upd_freqy1:	dc.l	50
bmp_hscl2:	dc.l	10
bmp_vscl2:	dc.l	10
img_adr1:	dc.l	100
img_adr2:	dc.l	100

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Uninitialized Data!!!
;
		.bss

joy1edge:	.ds.l		1
joy1cur:	.ds.l		1
joy2edge:	.ds.l		1
joy2cur:	.ds.l		1

	.end