	.text
	.68000

RED	equ	$f800
GREEN	equ	$003f
BLUE	equ	$07c0
YELLOW	equ	RED|GREEN
PURPLE	equ	RED|BLUE
CYAN	equ	BLUE|GREEN
WHITE	equ	$ffff
BLACK	equ	0

	;; another example of use of The Removers Libraries
	;; this time, it is a blitter tutorial :D
	
.macro	wait_blitter
.\~:
	move.l	B_CMD,\1
	ror.w	#1,\1
	bcc.s	.\~
.endm

	
.macro	imul16_16
	;; \1 = registre contenant la valeur 16.16
	;; \2 = registre contenant un entier POSITIF sur 16 bits (15 bits donc)
	;; \3 = registre temporaire pour calcul intermediaire
	;; \1 est intacte apres l'operation
	;; le resultat est stocke dans \2
	move.w	\2,\3
	mulu.w	\1,\3		; partie fractionnaire
	swap	\1
	muls.w	\1,\2		; partie entiere
	swap	\1
	swap	\2		; decale de 16
	clr.w	\2
	add.l	\3,\2		; ajoute la partie fractionnaire
.endm
	
		
	include	"prelude.s"

WSo	equ	64
WSoBLIT	equ	WID64
HSo	equ	44
		
WTa	equ	128
WTaBLIT	equ	WID128
HTa	equ	128

	;; initialisation GPU, DSP
	init_prg_state
	;; initialisation memoire
	move.l	#INITSTACK,a7	; initialise la pile
	move.l	#Bss_end,a0
	move.l	#INITSTACK-4*1024,a1
	bsr	mm_init		;  initialise le memory manager
	;; initialisation video
	bsr	VideoIni                    ;initialiser le systeme video
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	move.w	#RGB16|CSYNC|BGEN|PWIDTH4|VIDEN,VMODE
	bsr	IntIni

	move.w	width,d0
	lsr.w	#2,d0
	sub.w	#320,d0
	lsr.w	#1,d0
	add.w	#16,d0
	move.w	d0,base_x
	move.w	#16,d0
	move.w	d0,base_y
	
	bsr	init_sprite_manager

	bsr	new_sprite_list
	move.l	a0,sprite_list

	move.l	#jaguar_sprite,a1
	move.w	base_x,SPRITE_XPOS(a1)
	move.w	base_y,SPRITE_YPOS(a1)
	move.l	sprite_list,a0
	moveq	#0,d0
	bsr	cons_sprite_at_depth

	move.l	#image_sprite,a1
	move.w	#320,d0
	sub.w	#WTa,d0
	asr.w	#1,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200,d0
	sub.w	#HTa,d0
	asr.w	#1,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.l	sprite_list,a0
	moveq	#1,d0
	bsr	cons_sprite_at_depth

	move.l	#CLUT,a5
	;; a et b
	move.w	#BLACK,(a5)+
	move.w	#BLUE,(a5)+
	
	move.l	#transform_a_sprite,a1
	move.w	#0*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-24,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#0,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth
	
	move.l	#transform_b_sprite,a1
	move.w	#1*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-24,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#0,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth

	;; c et d
	move.w	#BLACK,(a5)+
	move.w	#RED,(a5)+
	
	move.l	#transform_c_sprite,a1
	move.w	#0*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-12,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#1,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth
	
	move.l	#transform_d_sprite,a1
	move.w	#1*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-12,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#1,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth

	;; e et f
	move.w	#BLACK,(a5)+
	move.w	#WHITE,(a5)+
	
	move.l	#transform_e_sprite,a1
	move.w	#2*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-24,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#2,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth
	
	move.l	#transform_f_sprite,a1
	move.w	#2*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-12,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#2,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth

	;; angle
	move.w	#BLACK,(a5)+
	move.w	#GREEN,(a5)+
	
	move.l	#angle_sprite,a1
	move.w	#3*9*8,d0
	add.w	base_x,d0
	move.w	d0,SPRITE_XPOS(a1)
	move.w	#200-16,d0
	add.w	base_y,d0
	move.w	d0,SPRITE_YPOS(a1)
	move.w	#3,SPRITE_INDEX(a1)
	move.l	sprite_list,a0
	moveq	#2,d0
	bsr	cons_sprite_at_depth
	
	move.l	#transform_a,current_val
	move.l	#transform_a_gfx,current_val_gfx
	move.w	#0,current_scale

	move.l	sprite_list,a0
	bsr	install_sprite_list
main:
	bsr	read_joypads
	bsr	WaitVbl	; attend la VBL
	bsr	refresh_sprite_list
	bsr	transform
	bsr	update_vals
*	move.w	#YELLOW,BG
	bsr	refresh_vals
*	move.w	#BLACK,BG
	bra.s	main

update_vals:
	move.l	joypad_1,d0
	btst.l	#JOYPAD_1,d0
	beq	.set_val_a
	btst.l	#JOYPAD_2,d0
	beq	.set_val_b
	btst.l	#JOYPAD_3,d0
	beq	.set_val_e
	btst.l	#JOYPAD_4,d0
	beq	.set_val_c
	btst.l	#JOYPAD_5,d0
	beq	.set_val_d
	btst.l	#JOYPAD_6,d0
	beq	.set_val_f
	move.w	#0,d1
	btst.l	#JOYPAD_7,d0
	beq	.set_scale
	move.w	#4,d1
	btst.l	#JOYPAD_8,d0
	beq	.set_scale
	move.w	#8,d1
	btst.l	#JOYPAD_9,d0
	beq	.set_scale
	move.w	#12,d1
	btst.l	#JOYPAD_0,d0
	beq	.set_scale
	moveq	#1,d1
	btst.l	#JOYPAD_UP,d0
	beq	.upd_val
	moveq	#-1,d1
	btst.l	#JOYPAD_DOWN,d0
	beq	.upd_val
	moveq	#1,d1
	btst.l	#JOYPAD_RIGHT,d0
	beq	.upd_angle
	moveq	#-1,d1
	btst.l	#JOYPAD_LEFT,d0
	beq	.upd_angle
	btst.l	#JOYPAD_A,d0
	beq	.zoom_out
	btst.l	#JOYPAD_C,d0
	beq	.zoom_in
	btst.l	#JOYPAD_STAR,d0
	bne.s	.no_reset
	btst.l	#JOYPAD_SHARP,d0
	beq	.go_reset
.no_reset:	
	rts
.set_val_a:
	move.l	#transform_a,current_val
	move.l	#transform_a_gfx,current_val_gfx
	rts
.set_val_b:
	move.l	#transform_b,current_val
	move.l	#transform_b_gfx,current_val_gfx
	rts
.set_val_c:
	move.l	#transform_c,current_val
	move.l	#transform_c_gfx,current_val_gfx
	rts
.set_val_d:
	move.l	#transform_d,current_val
	move.l	#transform_d_gfx,current_val_gfx
	rts
.set_val_e:
	move.l	#transform_e,current_val
	move.l	#transform_e_gfx,current_val_gfx
	rts
.set_val_f:
	move.l	#transform_f,current_val
	move.l	#transform_f_gfx,current_val_gfx
	rts
.set_scale:
	move.w	d1,current_scale
	rts
.upd_val:
	move.l	current_val,a0
	move.l	(a0),d0
	move.w	current_scale,d2
	lsl.l	d2,d1
	add.l	d1,d0
	move.l	d0,(a0)
	rts
.upd_angle:
	btst.l	#JOYPAD_B,d0
	bne.s	.no_upd_angle
	add.w	angle,d1
	and.w	#$ff,d1
	move.w	d1,angle
	bsr	get_cos_and_sin
	move.l	d1,transform_a
	move.l	d1,transform_d
	move.l	d2,transform_b
	neg.l	d2
	move.l	d2,transform_c
.no_upd_angle:		
	rts
.zoom_out:
	move.l	transform_a,d0
	asr.l	#1,d0
	move.l	d0,transform_a
	move.l	transform_b,d0
	asr.l	#1,d0
	move.l	d0,transform_b
	move.l	transform_c,d0
	asr.l	#1,d0
	move.l	d0,transform_c
	move.l	transform_d,d0
	asr.l	#1,d0
	move.l	d0,transform_d
	rts
.zoom_in:
	move.l	transform_a,d0
	lsl.l	#1,d0
	move.l	d0,transform_a
	move.l	transform_b,d0
	lsl.l	#1,d0
	move.l	d0,transform_b
	move.l	transform_c,d0
	lsl.l	#1,d0
	move.l	d0,transform_c
	move.l	transform_d,d0
	lsl.l	#1,d0
	move.l	d0,transform_d
	rts
.go_reset:
	move.w	#0,angle
	move.l	#$10000,transform_a
	move.l	#0,transform_b
	move.l	#0,transform_c
	move.l	#$10000,transform_d
	move.l	#0,transform_e
	move.l	#0,transform_f
	rts
	
refresh_vals:
	move.l	#transform_a_gfx,a0
	move.l	transform_a,d5
	bsr	draw_long

	move.l	#transform_b_gfx,a0
	move.l	transform_b,d5
	bsr	draw_long

	move.l	#transform_c_gfx,a0
	move.l	transform_c,d5
	bsr	draw_long

	move.l	#transform_d_gfx,a0
	move.l	transform_d,d5
	bsr	draw_long

	move.l	#transform_e_gfx,a0
	move.l	transform_e,d5
	bsr	draw_long

	move.l	#transform_f_gfx,a0
	move.l	transform_f,d5
	bsr	draw_long

	move.l	#angle_gfx,a0
	move.w	angle,d5
	moveq	#8,d3		; 8 caracteres
	bsr	draw_word
	rts
	
transform:
	;; clear the target image
	wait_blitter	d0
	move.w	#YELLOW,BG
	move.l	#target_gfx,A1_BASE
	move.l	#PIXEL16|XADDPHR|PITCH1|WTaBLIT,A1_FLAGS
	move.l	#0,A1_PIXEL
	
	move.w	#1,d0
	swap	d0
	move.w	#-WTa,d0
	move.l	d0,A1_STEP
	
	move.w	#HTa,d0
	swap	d0
	move.w	#WTa,d0
	move.l	d0,B_COUNT

	move.l	#0,B_PATD
	move.l	#0,B_PATD+4

	move.l	#UPDA1|PATDSEL,B_CMD
	;; compute the target image
	wait_blitter	d0
	move.l	#target_gfx,A2_BASE
	move.l	#PIXEL16|XADDPIX|PITCH1|WTaBLIT,A2_FLAGS
	move.l	#0,A2_PIXEL

	move.w	#1,d0
	swap	d0
	move.w	#-WTa,d0
	move.l	d0,A2_STEP

	move.l	#source_gfx,A1_BASE
	move.l	#PIXEL16|XADDINC|PITCH1|WSoBLIT,A1_FLAGS
	
	move.w	#HSo,d0
	swap	d0
	move.w	#WSo,d0
	move.l	d0,A1_CLIP

	;; X = a X' + b Y' + e
	;; Y = c X' + d Y' + f
	move.l	transform_a,d1
	move.l	transform_b,d2
	move.l	transform_c,d3
	move.l	transform_d,d4
	move.l	transform_e,d5
	move.l	transform_f,d6
	
	move.w	d3,d0
	swap	d3
	swap	d0
	move.w	d1,d0
	swap	d1
	move.l	d0,A1_FINC

	move.w	d3,d0
	swap	d3
	swap	d0
	move.w	d1,d0
	swap	d1
	move.l	d0,A1_INC

	move.w	d6,d0
	swap	d6
	swap	d0
	move.w	d5,d0
	swap	d5
	move.l	d0,A1_FPIXEL

	move.w	d6,d0
	swap	d0
	move.w	d5,d0
	move.l	d0,A1_PIXEL

	move.w	#WTa,d5
	imul16_16	d1,d5,d7 ; a * W
	move.l	d2,d6
	sub.l	d5,d6		; b - a * W

	move.w	#WTa,d5
	imul16_16	d3,d5,d7 ; c * W
	move.l	d4,d7
	sub.l	d5,d7		; d - c * W

	move.w	d7,d0
	swap	d7
	swap	d0
	move.w	d6,d0
	swap	d6
	move.l	d0,A1_FSTEP

	move.w	d7,d0
	swap	d0
	move.w	d6,d0
	move.l	d0,A1_STEP

	move.w	#HTa,d0
	swap	d0
	move.w	#WTa,d0
	move.l	d0,B_COUNT

	move.w	#RED,BG
	move.l	#CLIP_A1|UPDA1|UPDA1F|UPDA2|LFU_REPLACE|SRCEN|DSTA2,B_CMD
	wait_blitter	d0
	move.w	#BLACK,BG
	rts

draw_long:
	;; a0: adresse de l'image
	;; d5.l: entier a ecrire
	moveq	#8,d3
	moveq	#0,d2
	move.l	a0,a1
	move.w	d3,d1
	subq.w	#1,d1
.clr:
	move.l	d2,(a0)+
	move.l	d2,(a0)+
	dbf	d1,.clr
	move.w	d3,d1
	subq.w	#1,d3
	move.w	d3,d2
	add.w	d2,a1
.draw:
	move.w	d5,d4
	and.w	#$f,d4
	lsr.l	#4,d5
	cmp.w	#$a,d4
	blt.s	.figure
.letter:
	add.w	#'A'-'0'-$a,d4
.figure:	
	add.w	#'0',d4
	lsl.w	#3,d4
	move.l	#fonte+8,a3	; adresse de la fonte
	lea	(a3,d4.w),a0	; adresse du caractere
	bsr	draw_char
	subq.w	#1,a1
	dbf	d3,.draw
	rts

draw_word:
	;; a0: adresse de l'image
	;; d3: largeur en caracteres
	;; d5.w: entier a ecrire
	moveq	#0,d2
	move.l	a0,a1
	move.w	d3,d1
	subq.w	#1,d1
.clr:
	move.l	d2,(a0)+
	move.l	d2,(a0)+
	dbf	d1,.clr
	swap	d5
	clr.w	d5
	swap	d5
	move.w	d3,d1
	subq.w	#1,d3
	move.w	d3,d2
	add.w	d2,a1
.draw:
	divu.w	#10,d5
	swap	d5
	move.w	d5,d4		; reste
	clr.w	d5
	swap	d5
	add.w	#'0',d4		;
	lsl.w	#3,d4
	move.l	#fonte+8,a3	; adresse de la fonte
	lea	(a3,d4.w),a0	; adresse du caractere
	bsr	draw_char
	subq.w	#1,a1
	tst.w	d5
	dbeq	d3,.draw
	rts

draw_char:	
	;; a0: adresse du caractere
	;; a1: adresse de l'image
	;; d0: couleur
	;; d1: pour passer a la ligne suivante dans l'image
	movem.l	d2/a0-a1,-(sp)
	moveq	#8-1,d2
.one_line:
	move.b	(a0)+,(a1)
	add.w	d1,a1
	dbf	d2,.one_line
	movem.l	(sp)+,d2/a0-a1
	rts

	include	"cosinus.s"	

	.data

	data_simple_sprite	jaguar_sprite,source_gfx,WSo,HSo,O_DEPTH16

	data_simple_sprite	image_sprite,target_gfx,WTa,HTa,O_DEPTH16

	data_simple_sprite	transform_a_sprite,transform_a_gfx,8*8,8,O_DEPTH1
	data_simple_sprite	transform_b_sprite,transform_b_gfx,8*8,8,O_DEPTH1
	data_simple_sprite	transform_c_sprite,transform_c_gfx,8*8,8,O_DEPTH1
	data_simple_sprite	transform_d_sprite,transform_d_gfx,8*8,8,O_DEPTH1
	data_simple_sprite	transform_e_sprite,transform_e_gfx,8*8,8,O_DEPTH1
	data_simple_sprite	transform_f_sprite,transform_f_gfx,8*8,8,O_DEPTH1
	
	data_simple_sprite	angle_sprite,angle_gfx,8*8,8,O_DEPTH1
		
	gfx_data	source_gfx,"jaguar.rgb"

	.phrase
fonte:
	incbin	"ascii8x8.fnt"
	
	.long
transform_a:	dc.l	$00010000
transform_b:	dc.l	$00000000
transform_c:	dc.l	$00000000
transform_d:	dc.l	$00010000
transform_e:	dc.l	$00000000
transform_f:	dc.l	$00000000

angle:	dc.w	0
				
	.bss
	;; videos
base_x:	ds.w	1
base_y:	ds.w	1

	;;
	.long
sprite_list:	ds.l	1
	
	.phrase
target_gfx:	ds.w	WTa*HTa

	.phrase
transform_a_gfx:	ds.b	8*8
	.phrase
transform_b_gfx:	ds.b	8*8	
	.phrase
transform_c_gfx:	ds.b	8*8
	.phrase
transform_d_gfx:	ds.b	8*8
	.phrase
transform_e_gfx:	ds.b	8*8
	.phrase
transform_f_gfx:	ds.b	8*8
	.phrase
angle_gfx:		ds.b	8*8
	
	.long
current_val:	ds.l	1
current_val_gfx:	ds.l	1
current_scale:	ds.w	1
			
Bss_end:
