; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.
	
	.if	^^defined	INIT_H
	.print	"init.s already included"
	end
	.endif

INIT_H	equ	1
	.print	"including init.s"
	
.macro	init_prg_state
        ;; initialisation GPU, DSP
        move.w  #$100,JOYSTICK  ;mettre le son sur mute
        move.l  #0,G_CTRL       ;arreter le GPU
        move.l  #0,D_CTRL       ;arreter le DSP
        move.l  #0,G_FLAGS      ;initialiser les FLAGS du GPU
        move.l  #0,D_FLAGS      ;initialiser les FLAGS du DSP
        move.l  #$00070007,G_END        ;GPU en mode BigEndian (mode compatible 68000)
        move.l  #$00070007,D_END        ;DSP en mode BigEndian
        move.w  #%11010111001100,MEMCON2        ;memoire en mode BigEndian
        move.w  #$ffff,VI       ; disable video interrupts
        ;; initialisation memoire
        move.l  #INITSTACK,a7   ; initialise la pile
.endm

copy_code:
	;; d0: taille du code en octets (multiple de 4)
	;; a0: adresse du code
	;; a1: adresse ou copier
	move.w	d0,-(sp)
	lsr.w	#2,d0
	subq.w	#1,d0
.copy:
	move.l	(a0)+,(a1)+
	dbf	d0,.copy
	move.w	(sp)+,d0
	and.w	#%10,d0
	beq.s	.end_copy
	move.w	(a0)+,(a1)+
.end_copy:	
        rts
		
;; routines d'initialisation
VideoIni:
	movem.l	d0-d6,-(sp)
	move.w	CONFIG,d0	; Also is joystick register
	andi.w	#VIDTYPE,d0	;0=PAL,1=NTSC
	beq	.palvals
	move.w	#NTSC_HMID,d2
	move.w	#NTSC_WIDTH,d0
	move.w	#NTSC_VMID,d6
	move.w	#NTSC_HEIGHT,d4
	bra	.calc_vals
.palvals:
	move.w	#PAL_HMID,d2
	move.w	#PAL_WIDTH,d0
	move.w	#PAL_VMID,d6
	move.w	#PAL_HEIGHT,d4
.calc_vals:
	move.w	d0,width
	move.w	d4,height
	move.w	d0,d1
	asr.w	#1,d1		;Width/2
	sub.w	d1,d2		;Mid-Width/2
	add.w	#4,d2		;(Mid-Width/2)+4
	sub.w	#1,d1		;Width/2-1
	ori.w	#$400,d1	;(Width/2-1)|$400
	move.w	d1,a_hde
	move.w	d1,HDE
	move.w	d2,a_hdb
	move.w	d2,HDB1
	move.w	d2,HDB2
	move.w	d6,d5
	sub.w	d4,d5
	move.w	d5,a_vdb
	add.w	d4,d6
	move.w	d6,a_vde
	move.w	a_vdb,VDB
*	move.w	#$FFFF,VDE
	move.w	a_vde,VDE
	move.l	#0,BORD1	;Blackborder
	move.l	#0,BG
	clr.w	y_origin
	movem.l	(sp)+,d0-d6
	rts

.macro	installVblRoutine
	;; le premier argument contient l'adresse de la routine que l'on souhaite mettre en VBL
	;; la routine doit conserver la valeur de tous les registres sauf eventuellement d0 et a0
	move.l	\1,VblRoutineAddr
.endm

.macro	clearVblRoutine
	clr.l	VblRoutineAddr
.endm
	
IntIni:
	clearVblRoutine
	move.l	#VblRoutine,LEVEL0
	move.w	a_vde,d0
	or.w	#1,d0
	move.w	d0,VI
	or.w	#C_VIDENA,INT1
	and.w	#$f8ff,sr
	rts

.macro  align32nop
        .if     !((*-\1) % 4 = 0)
        .print  "Adding padding nop"
        nop
        .endif
.endm
	
VblRoutine:
	st	VblFlag
	movem.l	d0/a0,-(sp)
	move.l	VblRoutineAddr,d0
	beq.s	.noVblRoutine
	move.l	d0,a0
	jsr	(a0)
.noVblRoutine:
	movem.l	(sp)+,d0/a0
	move.w	#$101,INT1
	move.w	#0,INT2
	rte

WaitVbl:
	move.l	a0,-(sp)
	move.l	#VblFlag,a0
	sf	(a0)
.wait:
	tst.b	(a0)
	beq.s	.wait
	move.l	(sp)+,a0
	rts

	.bss

	.even
height:	ds.w    1
a_vdb:	ds.w    1
a_vde:	ds.w    1
width:	ds.w    1
a_hdb:	ds.w    1
a_hde:	ds.w    1
y_origin:	ds.w	1
VblFlag:	ds.w	1
	.long
VblRoutineAddr:	ds.l	1
	.text

