; Joypad reading, v 0.1
; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.
	
	.if	^^defined	JOYPAD_H
	.print	"joypad.s already included"
	end
	.endif

JOYPAD_H	equ	1
	.print	"including joypad.s"
	
	;; xxxxxxxxOFCEBDAP369#2580147*RLDU

	;; Standard Controller
JOYPAD_UP	equ	0
JOYPAD_DOWN	equ	1
JOYPAD_LEFT	equ	2
JOYPAD_RIGHT	equ	3
JOYPAD_STAR	equ	4
JOYPAD_7	equ	5
JOYPAD_4	equ	6
JOYPAD_1	equ	7
JOYPAD_0	equ	8
JOYPAD_8	equ	9
JOYPAD_5	equ	10
JOYPAD_2	equ	11
JOYPAD_SHARP	equ	12
JOYPAD_9	equ	13
JOYPAD_6	equ	14
JOYPAD_3	equ	15
JOYPAD_PAUSE	equ	16
JOYPAD_A	equ	17
JOYPAD_D	equ	18
JOYPAD_B	equ	19
JOYPAD_E	equ	20
JOYPAD_C	equ	21
JOYPAD_F	equ	22
JOYPAD_OPTION	equ	23

	;; Pro Controller
JOYPAD_L	equ	JOYPAD_4
JOYPAD_R	equ	JOYPAD_6
JOYPAD_X	equ	JOYPAD_9
JOYPAD_Y	equ	JOYPAD_8
JOYPAD_Z	equ	JOYPAD_7
		
read_joypads:
	movem.l	d0-d5/a0-a2,-(sp)
	move.l	#joypad_1,a0
	lea	joypad_2-joypad_1(a0),a1
	move.l	#JOYSTICK,a2
	move.l	#$0f000003,d4	; masque pour le port 1
	move.l	#$f000000c,d5	; masque pour le port 2
	;; lecture joypad 1 et 2
	move.w	#($81 << 8)|(%0111 << 4)|(%1110),(a2) ; (A Pause) + (Right Left Down Up)
	move.l	(a2),d0
	move.l	d0,d1
	and.l	d4,d0		; port 1
	and.l	d5,d1		; port 2
	swap	d0
	ror.w	#8,d0		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	ror.w	#2,d1
	swap	d1
	rol.w	#4,d1		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	move.w	#($81 << 8)|(%1011 << 4)|(%1101),(a2) ; (B D) + (1 4 7 *)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#2,d2
	swap	d2
	ror.w	#4,d2
	or.l	d2,d0		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	swap	d3
	rol.w	#8,d3
	or.l	d3,d1		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	move.w	#($81 << 8)|(%1101 << 4)|(%1011),(a2) ; (C E) + (2 5 8 0)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#4,d2
	swap	d2
	or.l	d2,d0		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	rol.w	#2,d3
	swap	d3
	ror.w	#4,d3
	or.l	d3,d1		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	move.w	#($81 << 8)|(%1110 << 4)|(%0111),(a2) ; (Option F) + (3 6 9 #)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2
	and.l	d5,d3
	rol.w	#6,d2
	swap	d2
	rol.w	#4,d2
	or.l	d2,d0		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	rol.w	#4,d3
	swap	d3
	or.l	d3,d1		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	move.l	d0,(a0)+
	move.l	d1,(a1)+
	;; lecture joypad 3 et 6
	move.w	#($81 << 8)|(%0000 << 4)|(%0000),(a2) ; (A Pause) + (Right Left Down Up)
	move.l	(a2),d0
	move.l	d0,d1
	and.l	d4,d0		; port 1
	and.l	d5,d1		; port 2
	swap	d0
	ror.w	#8,d0		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	ror.w	#2,d1
	swap	d1
	rol.w	#4,d1		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	move.w	#($81 << 8)|(%1000 << 4)|(%0001),(a2) ; (B D) + (1 4 7 *)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#2,d2
	swap	d2
	ror.w	#4,d2
	or.l	d2,d0		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	swap	d3
	rol.w	#8,d3
	or.l	d3,d1		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	move.w	#($81 << 8)|(%0100 << 4)|(%0010),(a2) ; (C E) + (2 5 8 0)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#4,d2
	swap	d2
	or.l	d2,d0		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	rol.w	#2,d3
	swap	d3
	ror.w	#4,d3
	or.l	d3,d1		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	move.w	#($81 << 8)|(%1100 << 4)|(%0011),(a2) ; (Option F) + (3 6 9 #)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2
	and.l	d5,d3
	rol.w	#6,d2
	swap	d2
	rol.w	#4,d2
	or.l	d2,d0		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	rol.w	#4,d3
	swap	d3
	or.l	d3,d1		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	move.l	d0,(a0)+
	move.l	d1,(a1)+
	;; lecture joypad 4 et 7
	move.w	#($81 << 8)|(%0010 << 4)|(%0100),(a2) ; (A Pause) + (Right Left Down Up)
	move.l	(a2),d0
	move.l	d0,d1
	and.l	d4,d0		; port 1
	and.l	d5,d1		; port 2
	swap	d0
	ror.w	#8,d0		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	ror.w	#2,d1
	swap	d1
	rol.w	#4,d1		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	move.w	#($81 << 8)|(%1010 << 4)|(%0101),(a2) ; (B D) + (1 4 7 *)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#2,d2
	swap	d2
	ror.w	#4,d2
	or.l	d2,d0		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	swap	d3
	rol.w	#8,d3
	or.l	d3,d1		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	move.w	#($81 << 8)|(%0110 << 4)|(%0110),(a2) ; (C E) + (2 5 8 0)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#4,d2
	swap	d2
	or.l	d2,d0		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	rol.w	#2,d3
	swap	d3
	ror.w	#4,d3
	or.l	d3,d1		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	move.w	#($81 << 8)|(%0001 << 4)|(%1000),(a2) ; (Option F) + (3 6 9 #)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2
	and.l	d5,d3
	rol.w	#6,d2
	swap	d2
	rol.w	#4,d2
	or.l	d2,d0		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	rol.w	#4,d3
	swap	d3
	or.l	d3,d1		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	move.l	d0,(a0)+
	move.l	d1,(a1)+
	;; lecture joypad 5 et 8
	move.w	#($81 << 8)|(%1001 << 4)|(%1001),(a2) ; (A Pause) + (Right Left Down Up)
	move.l	(a2),d0
	move.l	d0,d1
	and.l	d4,d0		; port 1
	and.l	d5,d1		; port 2
	swap	d0
	ror.w	#8,d0		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	ror.w	#2,d1
	swap	d1
	rol.w	#4,d1		; xxxxxxxxxxxxxxAPxxxxxxxxxxxxRLDU
	move.w	#($81 << 8)|(%0101 << 4)|(%1010),(a2) ; (B D) + (1 4 7 *)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#2,d2
	swap	d2
	ror.w	#4,d2
	or.l	d2,d0		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	swap	d3
	rol.w	#8,d3
	or.l	d3,d1		; xxxxxxxxxxxxBDAPxxxxxxxx147*RLDU
	move.w	#($81 << 8)|(%0011 << 4)|(%1100),(a2) ; (C E) + (2 5 8 0)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2		; port 1
	and.l	d5,d3		; port 2
	rol.w	#4,d2
	swap	d2
	or.l	d2,d0		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	rol.w	#2,d3
	swap	d3
	ror.w	#4,d3
	or.l	d3,d1		; xxxxxxxxxxCEBDAPxxxx2580147*RLDU
	move.w	#($81 << 8)|(%1111 << 4)|(%1111),(a2) ; (Option F) + (3 6 9 #)
	move.l	(a2),d2
	move.l	d2,d3
	and.l	d4,d2
	and.l	d5,d3
	rol.w	#6,d2
	swap	d2
	rol.w	#4,d2
	or.l	d2,d0		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	rol.w	#4,d3
	swap	d3
	or.l	d3,d1		; xxxxxxxxOFCEBDAP369#2580147*RLDU
	move.l	d0,(a0)+
	move.l	d1,(a1)+
	;; et voila!
	movem.l	(sp)+,d0-d5/a0-a2
	rts

	.bss
	
	;; joypad
	;; le joueur 1 est le premier joy sur le premier team tap
	;; le joueur 2 est le premier joy sur le second teamp tap
	.long
joypad_1:	ds.l	1
joypad_3:	ds.l	1
joypad_4:	ds.l	1
joypad_5:	ds.l	1
joypad_2:	ds.l	1
joypad_6:	ds.l	1
joypad_7:	ds.l	1
joypad_8:	ds.l	1

	.text

