	.68000
	.text

	;; example of use of The Removers libraries
	;; we do NB_BLOBS blobs with help of RMW mode of sprites

RED	equ	$f800
GREEN	equ	$003f
BLUE	equ	$07c0
YELLOW	equ	RED|GREEN
			
BLOB_W	equ	48
BLOB_H	equ	48
BLOB_RADIUS	equ	BLOB_W/2

	;; unfortunately, the OP cannot manage more than that
NB_BLOBS	equ	27

SIZE_STACK	equ	4*1024

	include	"prelude.s"

	;; init state
	init_prg_state
	;; memory init
	;; the heap starts at the end of the BSS section
	move.l	#Bss_end,a0
	move.l	#INITSTACK-SIZE_STACK,a1
	bsr	mm_init	
	;; video init
	bsr	VideoIni

	;; for the moment, nothing to display
	move.l	#stop_object,d0
	swap	d0
	move.l	d0,OLP
	
	;; changing video mode
	move.w	#CRY16|CSYNC|BGEN|PWIDTH4|VIDEN,VMODE
	
	;; interrupts init
	bsr	IntIni

	;; background color (BLACK in CRY)
	move.w	#$8800,BG
main:
	;; init the PRNG 
	bsr	random_init
	;; init the sprite manager
	bsr	init_sprite_manager
	;; init the blobs
	bsr	init_blobs
	;; install the list
	move.l	sm_list,a0
	bsr	install_sprite_list
	;; we put the refresh routine in VBL
	;; we can instead also call it after WaitVbl
	installVblRoutine	#refresh_sprite_list	
.loop:
*	move.w	#$8888,BG	; to see available 68k time!
	bsr	WaitVbl
*	move.w	#$8800,BG
	;; computing next frame
	bsr	do_blobs
	bra.s	.loop
	rts

init_blobs:
	;; compute center coordinates and clipping coordinates
	move.l	#blob_array,a3
	move.w	width,d0
	lsr.w	#2,d0		; PWIDTH4
	move.w	d0,d1
	sub.w	#2*BLOB_RADIUS,d1
	move.w	d1,xmax
	lsr.w	#1,d0
	sub.w	#BLOB_RADIUS,d0
	move.w	d0,xcenter
	move.w	height,d0
	move.w	d0,d1
	sub.w	#2*BLOB_RADIUS,d1
	move.w	d1,ymax
	lsr.w	#1,d0
	sub.w	#BLOB_RADIUS,d0
	move.w	d0,ycenter
	;; allocate the blobs sprites
	moveq	#NB_BLOBS-1,d7
.create_blob:
	move.l	#blob48_0_gfx,a0
	move.w	#BLOB_W/4,d0
	move.w	#BLOB_H,d1
	move.w	xcenter,d2
	move.w	ycenter,d3
	move.w	#O_DEPTH16,d4
	bsr	new_simple_sprite
	move.l	#O_TRANS|O_RMW,SPRITE_RELEASE_TRANS_RMW_REFLECT(a0)
	move.l	#O_RMW,SPRITE_RELEASE_TRANS_RMW_REFLECT(a0)
	move.l	a0,(a3)+
	move.l	#blob48_animation,a1
	bsr	random_next
	move.l	-4(a3),a0
	and.w	#%11,d0			; random speed
	bsr	set_sprite_animation	; animate each blob
	dbf	d7,.create_blob
	;; we now build the list through the sprite manager
	;; get a new SM-structure
	bsr	new_sprite_list
	move.l	a0,sm_list	; save the address
	;; inserts every blob
	move.l	#blob_array,a3
	moveq	#NB_BLOBS-1,d7
.create_list:
	move.l	(a3)+,a1	; blob sprite
	moveq	#0,d0		; at level 0
	bsr	cons_sprite_at_depth ; add it!
	dbf	d7,.create_list
	rts

do_blobs:
	;; compute next frame
	move.l	#blob_array,a3
	moveq	#NB_BLOBS-1,d7
	moveq	#0,d6
.refresh:
	;; get a 32 bit random number
	bsr	random_next
	move.w	d0,d1
	;; modulo 8
	and.w	#$7,d0
	;; divide by two
	lsr.w	#1,d0
	;; add the rotated bit 
	addx.w	d6,d0
	;; we have then a random number between 0 and 5 in d0
	;; we get another random number between 0 and 5 in d1
	lsr.w	#8,d1
	and.w	#$7,d1
	lsr.w	#1,d1
	addx.w	d6,d1
	;; here it is
	;; we now translate them in -2 .. 3
	subq.w	#2,d0
	subq.w	#2,d1
	;; get the blob sprite
	move.l	(a3)+,a0
	;; get x
	move.w	SPRITE_XPOS(a0),d2
	;; add random number
	add.w	d0,d2
	;; and clip it
	ble.s	.reset_x
	cmp.w	xmax,d2
	ble.s	.ok_x
.reset_x:
	move.w	xcenter,d2
.ok_x:
	;; save x
	move.w	d2,SPRITE_XPOS(a0)
	;; same for y
	move.w	SPRITE_YPOS(a0),d3
	add.w	d1,d3
	ble.s	.reset_y
	cmp.w	ymax,d3
	ble.s	.ok_y
.reset_y:
	move.w	ycenter,d3
.ok_y:
	move.w	d3,SPRITE_YPOS(a0)
	;; that's it!
	dbf	d7,.refresh
	rts

	.data

	.phrase
blob48_0_gfx:	incbin	"blob48_0.cry"
	.phrase
blob48_1_gfx:	incbin	"blob48_1.cry"
	.phrase
blob48_2_gfx:	incbin	"blob48_2.cry"
	.phrase
blob48_3_gfx:	incbin	"blob48_3.cry"
	.phrase
blob48_4_gfx:	incbin	"blob48_4.cry"
	.phrase
blob48_5_gfx:	incbin	"blob48_5.cry"
	.phrase
blob48_6_gfx:	incbin	"blob48_6.cry"
	.phrase
blob48_7_gfx:	incbin	"blob48_7.cry"
	.phrase
blob48_8_gfx:	incbin	"blob48_8.cry"
	.phrase
blob48_9_gfx:	incbin	"blob48_9.cry"
	.phrase
blob48_10_gfx:	incbin	"blob48_10.cry"
	.phrase
blob48_11_gfx:	incbin	"blob48_11.cry"
	.phrase
blob48_12_gfx:	incbin	"blob48_12.cry"

blob48_animation:
	;; ping-pong animation for the blobs
	dc.l	blob48_0_gfx
	dc.l	blob48_1_gfx
	dc.l	blob48_2_gfx
	dc.l	blob48_3_gfx
	dc.l	blob48_4_gfx
	dc.l	blob48_5_gfx
	dc.l	blob48_6_gfx
	dc.l	blob48_7_gfx
	dc.l	blob48_8_gfx
	dc.l	blob48_9_gfx
	dc.l	blob48_10_gfx
	dc.l	blob48_11_gfx
	dc.l	blob48_12_gfx
	dc.l	blob48_11_gfx
	dc.l	blob48_10_gfx
	dc.l	blob48_9_gfx
	dc.l	blob48_8_gfx
	dc.l	blob48_7_gfx
	dc.l	blob48_6_gfx
	dc.l	blob48_5_gfx
	dc.l	blob48_4_gfx
	dc.l	blob48_3_gfx
	dc.l	blob48_2_gfx
	dc.l	blob48_1_gfx
	dc.l	0

	.bss
	.even
xmax:		ds.w	1
xcenter:	ds.w	1
ymax:		ds.w	1
ycenter:	ds.w	1
	;;
	.long
sm_list:	ds.l	1
	;; blobs
	.long
blob_array:	ds.l	NB_BLOBS
Bss_end:

