; Memory manager v 1.0
; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.
	
	.if	^^defined MEMORY_H
	.print	"memory.s already included"
	end
	.endif
	
MEMORY_H	equ	1
	.print	"including memory.s"
	
	;; gestionnaire de memoire
	;; utilise la technique du first-fit (voir par exemple Tanenbaum)
	;; les blocs libres font partie d'une liste chainee
	;; pour initialiser le gestionnaire, appeler mm_init
	;; ensuite, pour allouer de la memoire, appeler mm_alloc
	;; et pour liberer de la memoire, appeler mm_free
	;; (aucune verification n'est faite sur l'adresse des
	;;  blocs  liberer)
	;; on peut aussi reinitialiser le gestionnaire avec mm_reset 
	;; c'est pratique pour tout liberer d'un coup
	
MM_OK		equ	0
MM_ERROR	equ	-1

	.offset	0
	;; header des cellules de mmoire
MM_CELL_NEXT:	ds.l	1
MM_CELL_SIZE:	ds.l	1
MM_CELL_SIZEOF:	ds.l	0	

	.text

MM_ALIGN	equ	5	; aligne sur 32 octets
MM_ALIGN_BYTES	equ	(1<<MM_ALIGN)
MM_ALIGN_MASK	equ	~(MM_ALIGN_BYTES-1)

MM_CELL_SIZEOF_ALIGNED	equ	(MM_CELL_SIZEOF+MM_ALIGN_BYTES-1)&MM_ALIGN_MASK

	.print	MM_CELL_SIZEOF_ALIGNED
	
	.macro	mm_align
	add.l	#MM_ALIGN_BYTES-1,\1
	and.l	#MM_ALIGN_MASK,\1
	.endm

mm_init:
	;; input
	;; a0: adresse debut memoire libre
	;; a1: adresse fin memoire libre
	;; output
	;; d0: MM_OK ou MM_ERROR
	;; registres utilises:	d0-d2,a0-a1
	move.l	a0,d0
	mm_align d0	; aligne au multiple superieur
	move.l	a1,d1
	and.l	#MM_ALIGN_MASK,d1 ; aligne au multiple inferieur
	move.l	d0,d2
	add.l	#MM_CELL_SIZEOF_ALIGNED,d2
	cmp.l	d2,d1	; a-t-on assez de place pour au moins une cellule?
	bls.s	.mm_init_error
.mm_init_ok:
	move.l	d0,mm_start_address
	move.l	d1,mm_end_address
	move.l	d0,mm_free_blocks
	move.l	d0,a0
	clr.l	MM_CELL_NEXT(a0) ; ni apres
	sub.l	d0,d1		;  taille du bloc (> taille d'une cellule)
	move.l	d1,MM_CELL_SIZE(a0) ; taille du bloc
	moveq	#MM_OK,d0
	rts
.mm_init_error:
	clr.l	mm_free_blocks
	clr.l	mm_start_address
	clr.l	mm_end_address
	moveq	#MM_ERROR,d0
	rts

mm_reset:
	;; input
	;; aucun
	;; output
	;; d0:	MM_OK ou MM_ERROR
	;; registres utilises:	d0-d2,a0-a1
	move.l	mm_start_address,a0
	move.l	mm_end_address,a1
	bra.s	mm_init

mm_alloc_clear:
	;; input
	;; d0: taille a allouer
	;; output
	;; a0: adresse du bloc alloue
	bsr	mm_alloc
	move.l	a0,-(sp)
	move.l	MM_CELL_SIZE-MM_CELL_SIZEOF_ALIGNED(a0),d0
	sub.l	#MM_CELL_SIZEOF_ALIGNED,d0	
	moveq	#0,d2
.clear_phrase:
	move.l	d2,(a0)+
	move.l	d2,(a0)+
	subq.l	#8,d0
	bhi.s	.clear_phrase
	move.l	(sp)+,a0
	rts
	
mm_alloc:
	;; input
	;; d0: taille a allouer
	;; output
	;; a0: adresse du bloc alloue ou 0 si impossible
	;; registres utilises:	d0-d2,a0-a2
	mm_align	d0
	add.l	#MM_CELL_SIZEOF_ALIGNED,d0 ;  taille reelle a allouer
	move.l	mm_free_blocks,d1
	beq.s	.mm_alloc_not_found
	sub.l	a1,a1
.mm_alloc_find_loop:
	move.l	d1,a0
	cmp.l	MM_CELL_SIZE(a0),d0
	bls.s	.mm_alloc_found
	move.l	a0,a1
	move.l	MM_CELL_NEXT(a0),d1
	bne.s	.mm_alloc_find_loop
.mm_alloc_not_found:
	sub.l	a0,a0
	illegal
	rts
.mm_alloc_found:
	;; ici, on a trouve un bloc assez grand
	;; son adresse est contenue dans a0
	;; la cellule precedente est pointee par a1
	move.l	MM_CELL_SIZE(a0),d1 	;  taille du bloc
	move.l	MM_CELL_NEXT(a0),a2	; cellule suivante	
	sub.l	d0,d1			; taille restante
	cmp.l	#MM_CELL_SIZEOF_ALIGNED,d1 	; > taille d'une cellule ?
	bhi.s	.mm_alloc_split_cell
.mm_ok_next:
	;; ici, la taille restante serait plus petite que la taille
	;; d'une cellule, on alloue donc toute la cellule
	add.l	d1,d0		; corrige la taille allouee
	bra.s	.mm_alloc_set_previous
.mm_alloc_split_cell:
	;; ici, on est oblige de couper le bloc en 2
	lea	(a0,d0.l),a2	; adresse de la prochaine cellule
	move.l	MM_CELL_NEXT(a0),MM_CELL_NEXT(a2) ; next
	move.l	d1,MM_CELL_SIZE(a2) ; taille
	cmp.l	#0,a1
	bne.s	.mm_alloc_ok_fix
	bra.s	.mm_alloc_chg_hd
.mm_alloc_set_previous:
	;; ici, a1 pointe sur la precedente
	;; et a2 sur la suivante	
	cmp.l	#0,a1
	beq.s	.mm_alloc_chg_hd
	move.l	a2,MM_CELL_NEXT(a1)	; next(previous) = next
	bra.s	.mm_alloc_ok_fix
.mm_alloc_chg_hd:
	move.l	a2,mm_free_blocks
.mm_alloc_ok_fix:
	;; ici, la liste est corrige
	;; la cellule courante a ete retire
	move.l	d0,MM_CELL_SIZE(a0) ; corrige la taille de la cellule
	clr.l	MM_CELL_NEXT(a0)
	add.l	#MM_CELL_SIZEOF_ALIGNED,a0 ; ajoute la taille de l'entete
	rts			; on est bon!

mm_free:
	;; input
	;; a0: adresse du bloc a liberer (pas de verifications poussees de consistance)
	;; output
	;; aucun
	;; registres utilises:	d0-d2,a0-a2
	sub.l	#MM_CELL_SIZEOF_ALIGNED,a0
	move.l	mm_free_blocks,d2
	beq.s	.mm_free_found_head
	cmp.l	d2,a0		; si a1 > a0, la liste des blocs libres commence apres le bloc a liberer
	blo.s	.mm_free_found_head
.mm_free_find:
	move.l	d2,a1
	;; ici, on sait que a1 <= a0
	cmp.l	MM_CELL_NEXT(a1),a0 ; si next(a1) > a0, on a trouve l'endroit o inserer la cellule a liberer
	blo.s	.mm_free_found
	move.l	MM_CELL_NEXT(a1),d2 ; sinon, on continue a parcourir la liste
	bne.s	.mm_free_find
.mm_free_found_tail:
	;; ici, on doit inserer (fusionner) en toute fin de liste
	;; a1 pointe sur la derniere cellule (non nulle)
	move.l	MM_CELL_SIZE(a1),d0
	lea	(a1,d0.l),a2
	cmp.l	a0,a2
	bne.s	.mm_free_found_tail_no_fusion
	add.l	MM_CELL_SIZE(a0),d0
	move.l	d0,MM_CELL_SIZE(a1)
	rts
.mm_free_found_tail_no_fusion:
	move.l	a0,MM_CELL_NEXT(a1)
	clr.l	MM_CELL_NEXT(a0) ; derniere cellule de la liste
	rts
.mm_free_found_head:	
	;; ici, on doit inserer (fusionner) en tete
	move.l	d2,a1			; tete de la liste
	move.l	a0,mm_free_blocks	; nouvelle tete de liste
	move.l	MM_CELL_SIZE(a0),d0
	lea	(a0,d0.l),a2
	cmp.l	a1,a2
	bne.s	.mm_free_found_head_no_fusion
	add.l	MM_CELL_SIZE(a1),d0
	move.l	d0,MM_CELL_SIZE(a0)
	move.l	MM_CELL_NEXT(a1),MM_CELL_NEXT(a0)
	rts
.mm_free_found_head_no_fusion:
	move.l	a1,MM_CELL_NEXT(a0)
	rts
.mm_free_found:
	;; ici, on doit inserer (fusionner) au milieu
	;; a1 pointe sur la cellule precedente
	move.l	MM_CELL_SIZE(a1),d0	; taille cellule precedente
	lea	(a1,d0.l),a2
	move.l	MM_CELL_NEXT(a1),d2	; cellule suivante (sauvegarde)
	cmp.l	a0,a2			; est-ce la fin de la precedente?
	bne.s	.mm_free_found_no_fusion_left ; non
.mm_free_found_fusion_left:
	add.l	MM_CELL_SIZE(a0),d0	; ajoute la taille 
	move.l	d0,MM_CELL_SIZE(a1)	; met a jour 
	move.l	a1,a0			; on remplace pour la suite
	bra.s	.mm_free_found_go_fusion_right
.mm_free_found_no_fusion_left:
	move.l	a0,MM_CELL_NEXT(a1)	; si on ne fusionne pas, on insere 
.mm_free_found_go_fusion_right:	
	move.l	d2,a2			; ancien next 
	move.l	MM_CELL_SIZE(a0),d0
	lea	(a0,d0.l),a1		; va-t-on jusqu'au debut de la
	cmp.l	a1,a2			; cellule suivante?
	bne.s	.mm_free_found_no_fusion_right
.mm_free_found_fusion_right:
	move.l	MM_CELL_NEXT(a2),a1
	move.l	a1,MM_CELL_NEXT(a0)
	add.l	MM_CELL_SIZE(a2),d0
	move.l	d0,MM_CELL_SIZE(a0)
	rts
.mm_free_found_no_fusion_right:
	move.l	a2,MM_CELL_NEXT(a0)
	rts

	.bss
mm_free_blocks:		ds.l	1
mm_start_address:	ds.l	1
mm_end_address:		ds.l	1

	.text

