; Pseudo-random numbers generator, v 0.2
; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.
	
	;; D'apres l'article "Chaotic Random Number Generators with Random Cycle Lengths"
	;; de Agner Fog

	.if	^^defined	RANDOM_H
	.print	"random.s already included"
	end
	.endif

RANDOM_H	equ	1
	.print	"including random.s"

		
RANDGEN_J	equ	3
RANDGEN_MOD	equ	3
RANDGEN_K	equ	(1<<RANDGEN_MOD)-1	; k > j (doit etre le predecesseur d'une puissance de 2)
RANDGEN_R	equ	5

RANDTEST	equ	0

	.if	RANDTEST
	.data
VC:	dc.w	$2718
HC:	dc.w	$2818
	.text

	bsr	random_init
	moveq	#10,d7
.rand1:	
	bsr	random_next
	dbf	d7,.rand1

	bsr	random_init
	moveq	#10,d7
.rand2:
	bsr	random_next_bis
	dbf	d7,.rand2

	clr.w	-(sp)
	trap	#1
	.endif
		
	.text
	.68000
random_init:
	movem.l	d0-d2/a0,-(sp)
	move.l	#random_seeds,a0
	move.w	VC,d1
	swap	d1
	move.w	HC,d1
	moveq	#RANDGEN_K,d0
.init_seeds:
	eor.l	#$31415926,d1
	move.l	d1,(a0)+
	ror.l	#8,d1
	ror.l	#5,d1
	move.w	VC,d2
	swap	d2
	move.w	HC,d2
	add.l	d2,d1
	dbf	d0,.init_seeds
	move.w	#RANDGEN_K*4,random_index
	movem.l	(sp)+,d0-d2/a0
	rts

random_next:
	move.w	random_index,d1
	move.w	d1,d2
	sub.w	#(RANDGEN_J-RANDGEN_K)*4,d2
	and.w	#RANDGEN_K<<2,d2
	move.l	#random_seeds,a0
	move.l	(a0,d1.w),d0
	add.l	(a0,d2.w),d0
	ror.l	#RANDGEN_R,d0
	move.l	d0,(a0,d1.w)
	subq.w	#4,d1
	and.w	#RANDGEN_K<<2,d1
	move.w	d1,random_index
	rts

.macro	gpu_random_next
	;; \1 = r14 ou r15
	;; \2, \3 deux registres pour les calculs intermediaires
	;; \4 = pour mettre le resultat
	movei	#random_index,\1
	loadw	(\1),\2
	move	\2,\3
	addq	#(RANDGEN_K-RANDGEN_J)*4,\2
	addq	#4,\1
	shlq	#32-RANDGEN_MOD,\2
	load	(\1+\3),\4
	shrq	#30-RANDGEN_MOD,\2
	load	(\1+\2),\2
	add	\2,\4
	rorq	#RANDGEN_R,\4
	store	\4,(\1+\3)
	subq	#4,\3
	subq	#4,\1
	shlq	#32-RANDGEN_MOD,\3
	shrq	#30-RANDGEN_MOD,\3
	storew	\3,(\1)
.endm

	.bss
	.long
random_index:
	ds.w	1
	ds.w	1
random_seeds:
	ds.l	RANDGEN_K+1


