; Sprite manager v 0.1
; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.
	
	.if	^^defined	SPRITE_MANAGER_H
	.print	"sprite_manager.s already included"
	end
	.endif
	
SPRITE_MANAGER_H	equ	1

	.print	"including sprite_manager.s"

GPU_STACK_RAM	equ	0

	.if	GPU_STACK_RAM
GPU_STACK_SIZE	equ	1024	; 4 ko devrait (largement) suffire
	.else
	.print	"Warning: the GPU stack is only 4 bytes long!!"
	.endif

GPU_BENCH	equ	0
NO_GPU_INTERRUPT	equ	0
PROJECT_TEMPEST	equ	0
	.if	PROJECT_TEMPEST
GPU_IT	equ	0
	.else
GPU_IT	equ	3
	.endif
 	.if	NO_GPU_INTERRUPT
GPU_IT_CPU	equ	0
GPU_IT_OP	equ	0
 	.else
GPU_IT_CPU	equ	(GPU_IT = 0)
GPU_IT_OP	equ	(GPU_IT = 3)
 	.endif
	
	include	"object_list.s"
	include	"memory.s"	
	
	.text

SM_MAX_DEPTH_BIT	equ	4
SM_MAX_DEPTH		equ	(1<<SM_MAX_DEPTH_BIT)
SM_MAX_DEPTH_MASK	equ	((1<<SM_MAX_DEPTH_BIT)-1)

	.offset	0
SM_OLIST1:	ds.l	1	; adresse du GPU object
SM_OLIST2:	ds.l	1	; adresse du debut reel de la liste
SM_LOCK:	ds.w	1	; lock pour le rafraichissement
	.long
SM_ARRAY:	ds.l	2*(SM_MAX_DEPTH+1)
SM_SIZEOF:	ds.l	0

	.offset	0
SM_CELL_OBJ:	ds.l	1
SM_CELL_NEXT:	ds.l	1
SM_CELL_PREV:	ds.l	1
SM_CELL_SIZEOF:	ds.l	0
	
	.text

; on organise les sprites par couches (profondeur des sprites)
; on utilise un tableau aussi grand que le nombre maximal de couches
; chaque entree du tableau contient une liste doublement chainee des sprites
; composant la couche en question
; une couche est liee a la suivante grace a un branch object
; a l'avenir, si on veut court-circuiter une partie des sprites d'une
; couche, il faudra justement utiliser ces branch objects (proxy)
; on sera du coup sur qu'un sprite a un unique predecesseur 

new_sprite_list:
	;; renvoie dans a0 l'adresse d'une nouvelle SM-structure
	movem.l	d0-d2/d6-d7/a1-a2,-(sp)
	move.l	#SM_SIZEOF,d0
	bsr	mm_alloc
	lea	SM_ARRAY(a0),a2
	moveq	#SM_MAX_DEPTH+1,d7
	move.w	d7,d6
	subq.w	#1,d6
	lsl.w	#3,d7
	add.w	d7,a2		; se place en fin de tableau
	move.l	#stop_object,a0	; la fin pointe sur le stop
.init_array:
	move.l	a0,a1		; on pointe sur le niveau suivant
	move.w	#$7ff,d0	; brA
	move.l	#O_BREQ,d1	; brA
	bsr	new_branch_object
	move.l	a0,-(a2)
	clr.l	-(a2)
	dbf	d6,.init_array
	lea	-SM_ARRAY(a2),a2 ; on revient au debut du buffer alloue
	move.l	a0,a1
	move.l	#stop_object,a0
	move.w	a_vdb,d0
	move.w	a_vde,d1
	bsr	first_branch_object
	move.l	a0,SM_OLIST2(a2)
	.if	GPU_IT_OP
	move.w	a_vde,d0
	subq.w	#2,d0
	move.w	a_vdb,d0
	addq.w	#2,d0
	.else
	move.w	#0,d0
	.endif
	move.l	a2,d1		; adresse de la SM-structure (parametre pour le GPU object)
	moveq	#0,d2		; parametre nul
	bsr	new_gpu_object
	move.l	a0,SM_OLIST1(a2)
	move.l	a2,a0		; adresse de la structure
	clr.w	SM_LOCK(a0)
	movem.l	(sp)+,d0-d2/d6-d7/a1-a2
	rts

wait_refresh_list:
	;; a0: adresse de la SM-structure
.wait_lock:	
	tst.w	SM_LOCK(a0)
	bne.s	.wait_lock
	move.w	#$2713,SM_LOCK(a0)
	rts
	
cons_sprite_at_depth:
	;; a0: adresse de la SM-structure
	;; a1: adresse du sprite
	;; d0: couche ou inserer le sprite
	move.l	a0,-(sp)
	movem.l	d0-d2/a1-a2,-(sp)
	moveq	#SM_CELL_SIZEOF,d0
	bsr	mm_alloc
	movem.l	(sp)+,d0-d2/a1-a2
	move.l	a1,SM_CELL_OBJ(a0)
	move.l	a0,OBJECT_CELL_ADDR(a1)
	move.l	a0,a1
	move.l	(sp)+,a0
cons_sprite_cell_at_depth:
	;; a0: adresse de la SM-structure
	;; a1: adresse de la cellule
	;; d0: couche ou inserer la cellule
	movem.l	d0-d2/a0-a2,-(sp)
	and.l	#SM_MAX_DEPTH_MASK,d0
	lsl.l	#3,d0
	lea	SM_ARRAY(a0,d0.l),a2	; on est positionne sur la bonne couche
	clr.l	SM_CELL_PREV(a1) ; insertion en tete
	move.l	12(a2),-(sp)	; next level (si liste vide)
	move.l	(a2),d0
	beq.s	.cons_empty	; liste vide?
	move.l	d0,a0		; non
	move.l	a1,SM_CELL_PREV(a0) ; on met le previous
	move.l	SM_CELL_OBJ(a0),(sp) ; next = suivant dans le level
.cons_empty:	
	move.l	d0,SM_CELL_NEXT(a1) ; insertion en tete de liste
	move.l	SM_CELL_OBJ(a1),a0
	move.l	(sp)+,a1
	move.l	a0,OBJECT_PREVIOUS_OBJ(a1) ; met a jour le champ previous de l'objet suivant
	bsr	finalize_sprite_object ; sprite a jour
	move.l	a0,a1
	move.l	4(a2),a0	; adresse du branch du level courant
	move.l	a0,OBJECT_PREVIOUS_OBJ(a1) ; met a jour le champ previous de l'objet courant
	move.l	a1,d0
	bsr	put_link_of_first_object ; change le link
	move.l	OBJECT_CELL_ADDR(a1),(a2)+ ; insere dans la SM-structure
	movem.l	(sp)+,d0-d2/a0-a2
	rts

remove_sprite:
	;; a0: adresse du sprite
	movem.l	d0-d1/a0-a2,-(sp)
	move.l	OBJECT_CELL_ADDR(a0),d0	; une cellule existe?
	beq.s	.nothing_to_remove
	clr.l	OBJECT_CELL_ADDR(a0)	; efface la cellule
	move.l	d0,a1
	move.l	SM_CELL_NEXT(a1),d1
	move.l	SM_CELL_PREV(a1),d0
	beq.s	.remove_first	; une cellule avant?
	move.l	d0,a2		; oui, on update son champ next
	move.l	d1,SM_CELL_NEXT(a2)
.remove_first:
	tst.l	d1		; une cellule apres?
	beq.s	.remove_last
	move.l	d1,a2
	move.l	d0,SM_CELL_PREV(a2)	
.remove_last:
	bsr	get_link_of_first_object
	move.l	d0,a2
	move.l	OBJECT_PREVIOUS_OBJ(a0),a0
	move.l	a0,OBJECT_PREVIOUS_OBJ(a2)
	bsr	put_link_of_first_object
	move.l	a1,a0
	bsr	mm_free		; libere la cellule
.nothing_to_remove:	
	movem.l	(sp)+,d0-d1/a0-a2
	rts

delete_sprite_list:
	;; a0: adresse de la SM-structure
	movem.l	d0-d2/d6-d7/a0-a4,-(sp)
	move.l	a0,-(sp)
 	moveq	#SM_MAX_DEPTH,d7
 	lea	SM_ARRAY(a0),a3
.delete_all_levels:
 	move.l	(a3)+,d6	; adresse liste
 	beq.s	.level_deleted	; nulle?
.delete_level:	
 	move.l	d6,a0
	move.l	SM_CELL_NEXT(a0),d6
	bsr	mm_free		; efface la cellule
	tst.l	d6
 	bne.s	.delete_level	; fin de liste?
.level_deleted:
	move.l	(a3)+,a0	; le branch du niveau
	bsr	mm_free
 	dbf	d7,.delete_all_levels
	move.l	(sp),a0
	move.l	SM_OLIST2(a0),a0	; le premier branch
	bsr	mm_free
	move.l	(sp),a0
	move.l	SM_OLIST1(a0),a0	; le GPU object
	bsr	mm_free
	move.l	(sp)+,a0		; et la SM-structure
	bsr	mm_free
	movem.l	(sp)+,d0-d2/d6-d7/a0-a4
	rts
		
install_sprite_list:
	;; installe la liste de sprites correspondant a la SM-structure
	;; dont l'adresse est contenue dans a0
	move.l	d0,-(sp)
	.if	(NO_GPU_INTERRUPT | GPU_IT_CPU)
	move.l	a0,current_sprite_list
	.endif
	move.l	SM_OLIST1(a0),d0
	clr.w	SM_LOCK(a0)
	swap	d0
	move.l	d0,OLP
	move.l	(sp)+,d0
	rts

	.long
gpu_sm_driver:
	.gpu
	.org	G_RAM
gpu_sm_driver_begin:
	.if	NO_GPU_INTERRUPT
	.else
	.if	GPU_IT_CPU
	movei	#.gpu_interrupt_handler,r10
	jump	t,(r10)
	nop
	.endif
	.endif
.gpu_sm_driver_init:
GPU_INIT_ADDR		equ	.gpu_sm_driver_init
	;; on suppose que la bank 1 est active
	;; la bank 0 est reservee pour l'interruption
	;; (les registres ne sont pas sauvegardees!)
	.if	GPU_STACK_RAM
	movei	#gpu_isp+(GPU_STACK_SIZE*4),r31 ; init ISP
	.else
	movei	#.gpu_isp+4,r31 ; init ISP
	.endif
	moveta	r31,r31				; ISP
	.if	GPU_STACK_RAM
	movei	#gpu_usp+(GPU_STACK_SIZE*4),r31 ; init USP
	.else
	movei	#.gpu_usp+4,r31 ; init USP
	.endif
	movei	#.gpu_sm_driver_param,r1
	moveq	#0,r2
	movei	#.gpu_sm_driver_start,r0
	store	r2,(r1)		; efface le mutex
	jump	t,(r0)
	nop
	
	.long
.gpu_sm_driver_param:
	;; parametre pour le driver GPU (adresse routine ou brancher ou null)
	;; aussi utilise comme mutex lors de l'initialisation
	dc.l	0

GPU_SUBROUT_ADDR	equ	.gpu_sm_driver_param

	.if	!(GPU_STACK_RAM)
	.long
.gpu_isp:	
	dc.l	0

	.long
.gpu_usp:
	dc.l	0
	.endif

	.if	NO_GPU_INTERRUPT
	.else
	.if	GPU_IT_OP
	.print	((G_RAM+(3*16))-*)," bytes available for GPU driver"
	.if	((G_RAM+(3*16)) >= *)
	.rept	(((G_RAM+(3*16))-*)/2)
	nop
	.endr
	.else
	.print	"Sorry: GPU driver too big!"
	.fail
	.endif
	.endif
	
.gpu_interrupt_handler:
	.print	"G_RAM = ",G_RAM," G_RAM + $30 = ",(G_RAM+(3*16))," Handler = ",.gpu_interrupt_handler
	movei	#G_FLAGS,r30	; Enable other ints
	load	(r30),r29

	.if	GPU_IT_OP
	movei	#OB2,r1		; parametre du GPU object
	movei	#OBF,r2         ; Write any value to OBF
	load	(r1),r1		; adresse de la SM-structure
	moveq	#0,r0
	rorq	#16,r1		; little endian!!
	storew	r0,(r2)         ; to restart Object Processor
	.endif
	.endif
.refresh_sprite_list_gpu_start:
GPU_REFRESH_LIST_ADDR	equ	.refresh_sprite_list_gpu_start
	.if	GPU_BENCH
	movei	#BG,r19
	.if	NO_GPU_INTERRUPT
	movei	#PURPLE,r20
	.else
	.if	GPU_IT_CPU
	movei	#RED,r20
	.else
	movei	#GREEN,r20
	.endif
	.endif
	storew	r20,(r19)
	.endif

	.if	NO_GPU_INTERRUPT
 	movei	#current_sprite_list,r1	; SM-structure courante
	moveq	#SM_MAX_DEPTH,r2 ; nombre de niveaux
 	load	(r1),r1		; adresse de la SM-structure
	.else
 	.if	GPU_IT_OP
 	moveq	#SM_MAX_DEPTH,r2 ; nombre de niveaux
 	.else
 	movei	#current_sprite_list,r1	; SM-structure courante
	moveq	#SM_MAX_DEPTH,r2 ; nombre de niveaux
 	load	(r1),r1		; adresse de la SM-structure
 	.endif
	.endif	
	movei	#.no_animation,r23
	movei	#.refresh_all_levels,r24
	movei	#y_origin,r22
	move	r1,r27
	loadw	(r22),r22	; y_origin
	movei	#.level_refreshed,r25
	shlq	#4,r22		; 2*y_origin << 3
	addq	#SM_LOCK,r27	; adresse lock
	movei	#.refresh_level,r26
	addq	#SM_ARRAY,r1	; se place sur le tableau
	movei	#MASK_XPOS,r3		; masque X
	movei	#MASK_YPOS<<3,r4	; masque Y	 
	movei	#MASK_DATA<<11,r5	; masque DATA
	movei	#MASK_HEIGHT<<14,r6	; masque HEIGHT
	not	r4
	not	r5
	not	r6
.refresh_all_levels:
	load	(r1),r14	; adresse liste du niveau
	addq	#8,r1		; avance dans le tableau
	cmpq	#0,r14
	jump	eq,(r25)	; liste vide -> rien a faire
	nop
.refresh_level:
	load	(r14+(SM_CELL_OBJ/4)),r15 ; adresse de l'objet (sprite)
	load	(r14+(SM_CELL_NEXT/4)),r14 ; next cell dans le niveau
	;; 2eme mot long
	load	(r15+1),r10
	moveq	#0,r16				; decalage dans DATA (0 si Y >= 0)
	btst	#0,r10		; est-ce un scaled sprite?
	jr	eq,.not_scaled	; non
	load	(r15+(SPRITE_XPOS/4)),r11	; !!! X | Y (au lieu de nop) !!!
	;; 6eme mot long
	load	(r15+(SPRITE_ZOOM_DATA/4)),r12
	or	r12,r12		; !!! attention a l'ecriture suivante (scoreboard failure) !!!
	store	r12,(r15+5)
.not_scaled:	
	load	(r15+(SPRITE_DWIDTH/4)),r13	; W | H
	move	r13,r17
	shlq	#16,r13				; H | 0
	shrq	#16,r17				; 0 | W
	shrq	#16-14,r13
	and	r4,r10				; efface ancien YPOS
	move	r11,r12
	and	r6,r10				; efface ancien HEIGHT	 
	shlq	#16,r11				; Y | 0
	shrq	#16,r12				; 0 | X
	not	r6
	sharq	#16-4,r11			; Y*2 << 3
	jr	pl,.ypos_positive
	not	r4		; !!! au lieu de nop !!!
	shlq	#10,r11		; YPOS << 14
	move	r17,r16		; DWIDTH
	add	r11,r13		; + HEIGHT << 14 
	sharq	#14,r11		; YPOS
	neg	r11
	mult	r11,r16		; offset en phrases (|Y| * DWIDTH)
	shlq	#3,r16		; en octets
	cmpq	#0,r13
	jr	pl,.ypos_positive
	moveq	#0,r11		; !!! YPOS = 0 !!!
	moveq	#0,r13		; HEIGHT = 0
.ypos_positive:
	add	r22,r11		; ajoute 2*y_origin
	and	r6,r13		; masque HEIGHT
	and	r4,r11		; masque YPOS
	not	r4
	or	r11,r10
	not	r6
	or	r13,r10
	store	r10,(r15+1)
	;; 1er mot long
	load	(r15),r10
	load	(r15+(SPRITE_DATA/4)),r11	; adresse DATA
	and	r5,r10				; efface ancien DATA
	add	r16,r11				; ajoute offset calcule precedemment 
	shlq	#11-3,r11
	not	r5
	and	r5,r11
	not	r5
	or	r11,r10
	store	r10,(r15)
	;; 4eme mot long
	load	(r15+3),r10
	and	r3,r12
	not	r3
	and	r3,r10				; efface ancien XPOS
	not	r3
	or	r12,r10
	store	r10,(r15+3)
	;; animation
	load	(r15+(SPRITE_ANIM_ARRAY/4)),r10	; adresse du tableau des animations
	cmpq	#0,r10
	jump	eq,(r23)	; pas d'animation si nulle
	btst	#0,r10
	jump	ne,(r23)	; animation inactive si bit de poids faible mis
	nop
	load	(r15+(SPRITE_ANIM_DATA/4)),r11 ; C | S | L:IDX.W
	move	r11,r12
	shrq	#24,r11		; 0 | 0 | 0 | C
	subq	#1,r11		; decremente le compteur
	jr	eq,.animate	; si nul, on anime
	shlq	#8,r12		; !!! S | L:IDX.W | 0 (au lieu de nop) !!!
	shlq	#24,r11		; C | 0 | 0 | 0
	shrq	#8,r12		; 0 | S | L:IDX.W
	or	r12,r11		; C | S | L:IDX.W
	store	r11,(r15+(SPRITE_ANIM_DATA/4))
	jump	t,(r23)		; fini pour cette fois-ci
	nop
.animate:
	move	r12,r11		; S | L:IDX.W | 0
	shrq	#8,r12		; 0 | S | L:IDX.W
	shrq	#24,r11		; 0 | 0 | 0 | S
	shlq	#24,r11		; S | 0 | 0 | 0
	or	r11,r12		; C | S | L:IDX.W 
	move	r12,r11		; C | S | L:IDX.W
	shlq	#17,r12		; IDX.W | 0 | 0
	shrq	#15,r11		; 0 | 0 | C | S | L:
	move	r12,r13		; sauve IDX
	shrq	#17-2,r12	; 4*IDX (tableau de longs)
	shlq	#15,r11		; C | S | L:0 | 0
	add	r10,r12		; pointe sur l'adresse du sprite
	load	(r12),r16	; adresse du sprite
	shrq	#17,r13		; 0 | 0 | 0:IDX.W
	cmpq	#0,r16		; fin du tableau?
	jr	ne,.not_end_array
	addq	#1,r13		; prochain sprite
	load	(r10),r16	; adresse du sprite
	bset	#15,r11		; on boucle
	moveq	#1,r13		; prochain sprite
.not_end_array:
	or	r13,r11		; C | S | IDX.W
	store	r16,(r15+(SPRITE_DATA/4)) ; change adresse du sprite
	store	r11,(r15+(SPRITE_ANIM_DATA/4))
.no_animation:
	cmpq	#0,r14		; next = null ?
	jump	ne,(r26)	; no!
	nop
.level_refreshed:
	subq	#1,r2
	jump	ne,(r24)
	nop
.return_from_refresh:
	.if	GPU_BENCH
	movei	#BG,r19
	.if	NO_GPU_INTERRUPT
	movei	#CYAN,r20
	.else
	movei	#BLUE,r20
	.endif
	storew	r20,(r19)
	.endif
	.if	NO_GPU_INTERRUPT
	load	(r31),r0
	addq	#4,r31
	jump	t,(r0)
	nop
	.else
	bclr	#3,r29		; Clear IMASK
	load	(r31),r28	; Address of last instruction
	bset	#9+GPU_IT,r29	; Clear pending interrupt
	addq	#2,r28		; +2 to point to next
	addq	#4,r31		; Correct stack
	jump	t,(r28)		; return from interrupt
	store	r29,(r30)	; restore flags
	.endif
.gpu_sm_driver_start:		
	movei	#GPU_SUBROUT_ADDR,r0
	movei	#.gpu_sm_driver_start,r1 ; adresse retour
	load	(r0),r3		; lit param
	moveq	#0,r2
	cmpq	#0,r3
	jr	eq,.gpu_sm_driver_start	; param nul => boucle
	nop
	subq	#4,r31		; sinon
	store	r2,(r0)		; efface param
	jump	t,(r3)		; execute la procedure
	store	r1,(r31)	; !!! empile adresse de retour (au lieu d'un nop) !!!
	align32nop	gpu_sm_driver_begin
gpu_sm_driver_end:	
	.print	"GPU Sprite Manager size: ",gpu_sm_driver_end-gpu_sm_driver_begin

GPU_FREE_RAM	equ	gpu_sm_driver_end	

.macro	JumpGPUSubRoutine
	move.l	\1,GPU_SUBROUT_ADDR
.endm
		
	.68000
	.text
init_sprite_manager:
	.if	(NO_GPU_INTERRUPT | GPU_IT_CPU)
	clr.l	current_sprite_list
	.endif
	move.l	#gpu_sm_driver,a0
	move.l	#G_RAM,a1
	move.l	#gpu_sm_driver_end-gpu_sm_driver_begin,d0
	bsr	copy_code

	.if	NO_GPU_INTERRUPT
	move.l	#REGPAGE,G_FLAGS
	.else
	.if	GPU_IT_OP
	move.l	#G_OPENA|REGPAGE,G_FLAGS
	.else
	move.l	#G_CPUENA|REGPAGE,G_FLAGS
	.endif
	.endif
	move.l	#GPU_SUBROUT_ADDR,a0
	move.l	#$ffffffff,(a0)			; synchronisation avec le GPU 
	move.l	#GPU_INIT_ADDR,G_PC
	move.l	#GPUGO,G_CTRL
	.if	GPU_BENCH
	move.w	#YELLOW,BG
	.endif
.wait:
	tst.l	(a0)		; GPU driver ok?
	bne.s	.wait		; non => on attend
	move.w	a_vdb,d0
	lsr.w	#1,d0
	move.w	d0,y_origin
	rts

refresh_sprite_list:
	;; a0: adresse de la SM-structure
	.if	1
	.if	NO_GPU_INTERRUPT
 	tst.l	current_sprite_list
 	beq.s	.no_refresh
	JumpGPUSubRoutine	#GPU_REFRESH_LIST_ADDR
.no_refresh:
	.else
	.if	GPU_IT_CPU
	move.l	G_CTRL,d0
	or.l	#%100,d0
	move.l	d0,G_CTRL
	.else
	nop
	.endif
	.endif
	.else
	.if	(NO_GPU_INTERRUPT | GPU_IT_CPU)
	.print	"68k version ok"
	.else
	.print	"68k version not available with GPU interrupt"
	.fail
	.endif	
 	movem.l	d0-d2/d7/a0-a3,-(sp)
	move.l	current_sprite_list,a0
 	moveq	#SM_MAX_DEPTH-1,d7
 	lea	SM_ARRAY(a0),a2
.refresh_all_levels:
 	move.l	(a2)+,d0
 	beq.s	.level_refreshed
.refresh_level:	
 	move.l	d0,a3
 	move.l	SM_CELL_OBJ(a3),a0
 	bsr	refresh_sprite_object
 	move.l	SM_CELL_NEXT(a3),d0
 	bne.s	.refresh_level
.level_refreshed:
 	addq.w	#4,a2
 	dbf	d7,.refresh_all_levels
	move.l	current_sprite_list,a0
	clr.w	SM_LOCK(a0)
 	movem.l	(sp)+,d0-d2/d7/a0-a3
	.endif
	rts
	
	.data

	data_stop_object	stop_object

	.bss

	.if	(NO_GPU_INTERRUPT | GPU_IT_CPU)
	.long
current_sprite_list:	ds.l	1
	.endif

	.if	GPU_STACK_RAM	
	.long
gpu_usp:	ds.l	GPU_STACK_SIZE
gpu_isp:	ds.l	GPU_STACK_SIZE
	.endif

