; Object-List management, v 0.2
; Copyright (c) 2006, Seb/The Removers
; http://removers.atari.org
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following
; conditions are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above
; copyright notice, this list of conditions and the following
; disclaimer in the documentation and/or other materials
; provided with the distribution.
; * Neither the name of the Removers nor the names of its
; contributors may be used to endorse or promote products
; derived from this software without specific prior written
; permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
; NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
; FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
; SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
; THE POSSIBILITY OF SUCH DAMAGE.

	.if	^^defined	OBJECT_LIST_H
	.print	"object_list.s already included"
	end
	.endif
	
OBJECT_LIST_H	equ	1
	.print	"including object_list.s"

	include	"memory.s"
		
	.offset	0
OBJECT_PHRASE1:	ds.l	2
OBJECT_PHRASE2:	ds.l	2
OBJECT_PHRASE3:	ds.l	2
OBJECT_PHRASE4:	ds.l	2
OBJECT_CELL_ADDR:	ds.l	1	; adresse de la cellule dans la liste 
OBJECT_PREVIOUS_OBJ:	ds.l	1	; valide uniquement pour les sprites (mais utilise par tous les objets)
OBJECT_SIZEOF:	ds.l	0

	.if	!(OBJECT_SIZEOF % 8 = 0)
	.print	"invalid object size"
	.fail
	.endif
	
	.offset	0
	;; donnees d'un sprite
	;; vu que de toute faon on aligne sur 32 octets,
	;; on s'y donne a coeur joie et on n'economise pas specialement la memoire
	;; mais bon, ca reste raisonnable quand meme
SPRITE_OBJ:	ds.b	OBJECT_SIZEOF
SPRITE_RESTORE:	ds.l	2	; 2 longs a restaurer apres affichage (copie de la premiere phrase)
SPRITE_DATA:	ds.l	1	; adresse de l'image
SPRITE_PITCH:	ds.l	1	; distance entre deux phrases de l'image (O_NOGAP, O_1GAP, O_2GAP, ..., O_6GAP) : !! ATTENTION au .l !!
SPRITE_RELEASE_TRANS_RMW_REFLECT:	ds.l	1	; disjonction des flags (O_REFLECT ou bien 0), (O_RMW ou bien 0), (O_TRANS ou bien 0) ou (O_RELEASE ou bien 0)
							; O_REFLECT si on veut faire un miroir vertical (penser a corriger XPOS)
							; O_RMW pour ajouter les pixels au lieu de les copier
							; O_TRANS si le sprite est transparent
							; O_RELEASE pour que l'OP relache le bus
							; !! ATTENTION:	le tout est sur un mot long !!
SPRITE_TYPE:	ds.w	1	; soit BITOBJ soit SCBITOBJ
SPRITE_DEPTH:	ds.w	1	; profondeur (1 bit, 2 bits, ..., 16 bits, 24 bits) (O_DEPTH1, O_DEPTH2, ..., O_DEPTH32)
SPRITE_IWIDTH:	ds.w	1	; largeur du sprite en phrases (partie visible de l'image)
	.long
SPRITE_XPOS:	ds.w	1	; x
SPRITE_YPOS:	ds.w	1	; y
	
SPRITE_DWIDTH:	ds.w	1	; largeur de l'image en phrases
SPRITE_HEIGHT:	ds.w	1	; hauteur du sprite
	
SPRITE_INDEX:	ds.w	1	; index de palette
SPRITE_FIRSTPIX:	ds.w	1	; premier pixel a afficher

	.long
SPRITE_ZOOM_DATA:	ds.b	1	; padding
SPRITE_REMAINDER:	ds.b	1	; reste (3 bits),(5 bits)
SPRITE_VSCALE:		ds.b	1	; vscale (3 bits),(5 bits)
SPRITE_HSCALE:		ds.b	1	; hscale (3 bits),(5 bits)

SPRITE_ANIM_ARRAY:	ds.l	1	; tableau de l'adresse des sprites
SPRITE_ANIM_DATA:	
SPRITE_ANIM_COUNTER:	ds.b	1	; compteur pour animer
SPRITE_ANIM_SPEED:	ds.b	1	; vitesse de l'animation 
SPRITE_ANIM_INDEX:	ds.w	1	; index du sprite de l'animation + flag de bouclage
SPRITE_SIZEOF:		ds.l	0

	.text

MASK_DATA	equ	$1fffff	; 21 bits
MASK_LINK	equ	$7ffff	; 19 bits
MASK_HEIGHT	equ	$3ff	; 10 bits
MASK_WIDTH	equ	$3ff	; 10 bits
MASK_XPOS	equ	$fff	; 12 bits
MASK_YPOS	equ	$7ff	; 11 bits
MASK_INDEX	equ	$7f	; 7 bits
MASK_FIRSTPIX	equ	$3f	; 6 bits

.macro	gfx_data
	;; \1 = nom du label
	;; \2 = nom du fichier
	.phrase
\1:
	incbin	\2
.endm
	
.macro	data_phrase_width
	;; \1 = largeur en octets
	.if	!(\1 % 8 = 0)
	.print	"invalid width (not phrase aligned)"
	.fail
	.else
	.print	"phrase width: ",(\1/8)
	dc.w	(\1/8)
	.endif
.endm
	
.macro	data_width_depth
	;; calcule la largeur en phrase
	;; en fonction de la largeur de l'image
	;; et le profondeur des donnees
	;; \1 = largeur
	;; \2 = profondeur
	.if	(\2=O_DEPTH1)
	.print	"1 bit"
	.if	\1%8
	.fail	"1 bit, invalid width"
	.else
	data_phrase_width	(\1/8)
	.endif
	.else
	.if	(\2=O_DEPTH2)
	.print	"2 bits"
	.if	\1%4
	.fail	"2 bits, invalid width"
	.else
	data_phrase_width	(\1/4)
	.endif
	.else
	.if	(\2=O_DEPTH4)
	.print	"4 bits"
	.if	\1%2
	.fail	"4 bits, invalid width"
	.else
	data_phrase_width	(\1/2)
	.endif
	.else
	.if	(\2=O_DEPTH8)
	.print	"8 bits"
	data_phrase_width	\1
	.else
	.if	(\2=O_DEPTH16)
	.print	"16 bits"
	data_phrase_width	(\1*2)
	.else
	.if	(\2=O_DEPTH32)
	.print	"32 bits"
	data_phrase_width	(\1*4)
	.else
	.fail	"invalid depth"
	.endif
	.endif
	.endif
	.endif
	.endif
	.endif
.endm

.macro	data_object
	rept	OBJECT_SIZEOF
	dc.b	0
	endr
.endm
	
.macro	data_simple_sprite
	;; fait un sprite en zone data
	;; \1 = nom du label
	;; \2 = adresse de l'image
	;; \3 = largeur (en pixels)
	;; \4 = hauteur (en pixels)
	;; \5 = profondeur de l'image
	;; arguments optionnels
	;; \6 = x
	;; \7 = y
	.data
	.print	"Simple sprite in DATA section"
	.qphrase
\1:
	data_object
	dc.l	0,0		; sauvegarde
	dc.l	\2		; donnees graphiques
	dc.l	O_NOGAP
	dc.l	O_TRANS		; transparent
	dc.w	BITOBJ		; simple Bitmap object
	dc.w	\5		; profondeur des donnees
	data_width_depth	\3,\5 ; largeur
	.long
	.if	\?6
	dc.w	\6		; x
	.else
	dc.w	0		; x
	.endif
	.if	\?7
	dc.w	\7
	.else
	dc.w	0		; y
	.endif
	data_width_depth	\3,\5 ; largeur
	dc.w	\4		; hauteur
	dc.w	0		; index
	dc.w	0		; firstpix
	.long
	dc.b	0		; padding
	dc.b	1<<4		; remainder
	dc.b	1<<5		; vscale
	dc.b	1<<5		; hscale
	.long
	dc.l	0		; pas d'animations
	dc.l	0
	.if	!((*-\1)=SPRITE_SIZEOF)
	.print	"wrong data sprite"
	.fail
	.endif
.endm

.macro	data_stop_object
	.data
	.phrase
\1:	
	dc.l	0,STOPOBJ	; phrase 1
	dc.l	0,0		; phrase 2
	dc.l	0,0		; phrase 3
	dc.l	0,0		; phrase 4
	dc.l	0,0		; reserved
	.if	!((*-\1)=OBJECT_SIZEOF)
	.print	"wrong stop object"
	.fail
	.endif
.endm		
			
.macro	format_link
	;; \1 est un registre de donnee contenant l'adresse du lien (sur 19+3 = 22 bits, les 3 derniers valant 0)
	;; \2 est un registre (different de \1) qui contiendra les 32 bits de poids faible
	;; dans \1 on mettra les 32 bits de poids fort
	swap	\1
	rol.l	#5,\1
	move.l	\1,\2
	and.l	#$ff000000,\2	; poids faible (bits 3 a 10 dans bits 24 a 31)
	and.l	#$7ff,\1	; poids fort (bits 11 a 21 dans bits 0 a 10)
.endm

new_branch_object:
	;; input
	;; a0 contient l'adresse de l'objet si on branche (link)
	;; a1 contient l'adresse de l'objet si on ne branche pas (link)
	;; d0 contient YPOS
	;; d1 contient le code condition (CC) (deja decale)
	;; output
	;; renvoie dans a0 l'adresse de l'objet
	;; d0 d1 a0 a1 sont modifies
	;; le stop object de la troisieme phrase permet de distinguer entre un branch et le first branch
	movem.l	d2/a2,-(sp)
	and.l	#MASK_YPOS,d0	; masque YPOS (11 bits)
	lsl.w	#3,d0		; decale de 3 bits
	or.l	d1,d0		; ajoute le code condition (qu'on suppose correct sur les bits 14, 15 et 16) ** FIX **
	or.w	#BRANCHOBJ,d0	; branch object (c'est bien sur 16 bits)
	move.l	a0,d2		; charge le then link dans d2
	format_link	d2,d1	; met a dans les 64 bits formes par d2:d1
	or.w	d0,d1		; d2:d1 contient maintenant le branch object de tete
	movem.l	d1-d2/a1,-(sp)
	moveq	#OBJECT_SIZEOF,d0	; reserve un nouvel objet (1ere phrase: branch object voulu, 2eme phrase: branch object else, 3eme phrase: stop object)
	bsr	mm_alloc
	movem.l	(sp)+,d1-d2/a1
	move.l	d2,(a0)+
	move.l	d1,(a0)+	; premier branch object
	move.l	a1,d0		; charge le else link dans d0
	format_link	d0,d1	; d0:d1 contient le link formate
	or.w	#O_BREQ|($7ff<<3)|BRANCHOBJ,d1 ; construit un branchement inconditionnel
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	clr.l	(a0)+		; stop object
	move.l	#STOPOBJ,(a0)+
	movem.l	(sp)+,d2/a2
	sub.w	#3*8,a0		; se recale au debut de l'object
	rts

first_branch_object:
	;; input
	;; a0 contient l'adresse du stop object
	;; a1 contient l'adresse de la liste d'objets
	;; d0 contient a_vdb
	;; d1 contient a_vde
	movem.l	d2-d3/a2,-(sp)
	and.l	#MASK_YPOS,d0
	and.l	#MASK_YPOS,d1
	lsl.w	#3,d0
	or.w	#O_BRGT,d0
	or.w	#BRANCHOBJ,d0
	move.l	a0,d2
	format_link	d2,d3	; adresse du stop object dans d2:d3
	or.w	d0,d3		; d2:d3 contient maintenant le branch object
	movem.l	d1-d2/a1,-(sp)
	moveq	#OBJECT_SIZEOF,d0 ; reserve un nouvel objet (1ere phrase: comparaison avec a_vdb, 2eme phrase: comparaison avec a_vde, 3eme phrase: branchement inconditionnel)
	bsr	mm_alloc
	movem.l	(sp)+,d1-d2/a1
	move.l	d2,(a0)+
	move.l	d3,(a0)+
	clr.w	d3
	lsl.w	#3,d1
	or.w	#O_BRLT,d1
	or.w	#BRANCHOBJ,d1
	or.w	d1,d3
	move.l	d2,(a0)+
	move.l	d3,(a0)+
	move.l	a1,d2
	format_link	d2,d3	; adresse de la liste dans d2:d3
	or.w	#O_BREQ|($7ff<<3)|BRANCHOBJ,d3 ; construit un branchement inconditionnel
	move.l	d2,(a0)+
	move.l	d3,(a0)+
	movem.l	(sp)+,d2-d3/a2
	sub.w	#3*8,a0
	rts

new_gpu_object:
	;; input
	;; a0 contient l'adresse de la liste d'objets
	;; d0 contient YPOS
	;; d1 est une valeur 32 bits mappe sur les 32 bits de poids fort du GPU object
	;; d2 est une valeur 16 bits mappe sur les 16 bits de poids fort du long de poids faible du GPU object
	;; output
	;; a0 adresse de l'objet
	move.l	a1,-(sp)
	move.l	a0,a1		; sauve link
	movem.l	d0-d2/a1-a2,-(sp)
	moveq	#OBJECT_SIZEOF,d0
	bsr	mm_alloc	; reserve un nouvel objet (1ere phrase:	YPOS == ?, 2eme phrase: branchement inconditionnel, 3eme phrase: GPU object, 4eme phrase: branchement inconditionnel)
	movem.l	(sp)+,d0-d2/a1-a2
	move.l	d1,OBJECT_PHRASE3(a0) ; DATA pour le GPU object
	swap	d2
	move.w	#GPUOBJ,d2
	move.l	d2,OBJECT_PHRASE3+4(a0)	; DATA pour le GPU object et GPU obj
	move.l	a1,d1
	format_link	d1,d2	; adresse du link dans d1:d2
	or.w	#O_BREQ|($7ff<<3)|BRANCHOBJ,d2 ; branchement inconditionnel
	movem.l	d1-d2,OBJECT_PHRASE2(a0)
	movem.l	d1-d2,OBJECT_PHRASE4(a0)
	addq.w	#1,d0
	and.w	#~%1,d0
	and.l	#MASK_YPOS,d0
	lsl.w	#3,d0
	or.w	#O_BREQ|BRANCHOBJ,d0
	move.l	a0,d1
	add.l	#2*8,d1
	format_link	d1,d2	; adresse GPU object
	or.w	d0,d2
	move.l	d1,(a0)
	move.l	d2,4(a0)
	move.l	(sp)+,a1
	rts
		
get_link_of_first_object:
	;; input
	;; a0: adresse de l'objet
	;; output
	;; renvoie dans d0 le link
	move.l	2(a0),d0	; on se fie aux valeurs sauvees
	lsr.l	#8,d0
	and.l	#MASK_LINK,d0	; on ne garde que 19 bits
	lsl.l	#3,d0		; remet sur 22 bits
	rts

put_link_of_first_object:
	;; input
	;; a0: adresse de l'objet
	;; d0: adresse du nouveau link
	movem.l	d0-d1,-(sp)
	lsr.l	#3,d0		; aligne sur une phrase
	and.l	#MASK_LINK,d0	; on ne garde que 19 bits
	lsl.l	#8,d0		; decale
	move.l	2(a0),d1
	and.l	#~(MASK_LINK<<8),d1 ; efface l'ancien link
	or.l	d0,d1		; met le nouveau
	move.l	d1,2(a0)	; sauve
	movem.l	(sp)+,d0-d1
	rts
	
update_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; ici, on appelle finalize_sprite_object 
	;; mais en gardant la meme valeur pour link
	;; utile si on a mis a jour des valeurs (genre x, y, ...)
	;; output
	;; en retour, on obtient dans a1 la valeur de link et 
	;; a0 continue de pointer sur le sprite
	move.l	d0,-(sp)
	move.l	2(a0),d0	; on lit les bits 16 a 47
	lsr.l	#8,d0		; on decale de maniere a mettre le bit 24 tout a droite
	and.l	#MASK_LINK,d0	; on ne garde que 19 bits
	lsl.l	#3,d0		; on remet sur 22 bits
	move.l	d0,a1
	move.l	(sp)+,d0
finalize_sprite_object:
	;; input
	;; a0 contient l'adresse du sprite (structure le decrivant)
	;; a1 contient l'adresse de l'objet suivant (link)
	;; output
	;; a0 contient l'adresse du sprite
	;; cette fonction calcule les 3 phrases qu'il faut pour la Jag
	;; en fonction des autres infos contenues dans la structure
	;; a1 n'est pas modifie
	movem.l	d0-d4/a0,-(sp)
	;; calcul de la premiere phrase
	.if	1
	moveq	#0,d2		; offset pour gerer le Y < 0
	moveq	#0,d1
	moveq	#0,d0
	move.w	SPRITE_HEIGHT(a0),d1 ; hauteur
	move.w	SPRITE_YPOS(a0),d0
*	sub.w	y_origin,d0
	bpl.s	.ypos_positive
	neg.w	d0
	move.w	SPRITE_DWIDTH(a0),d2
	mulu.w	d0,d2		; offset dans l'image
	sub.w	d0,d1		; corrige la hauteur
	bpl.s	.height_positive
	moveq	#0,d1		; hauteur nulle
.height_positive:
	moveq	#0,d0		; Y = 0
.ypos_positive:
	add.w	y_origin,d0
	;; ici, d0 contient YPOS
	;; d1 contient HEIGHT
	;; et d2 contient l'offset a ajouter a DATA
	add.l	SPRITE_DATA(a0),d2 ; adresse des DATA
	move.l	a1,d3
	format_link	d3,d4	; d3:d4 contient le link formate
	lsl.l	#8,d2		; decale de 8 (+3=11 car les 3 bits de poids faible sont ignores)
	and.l	#MASK_DATA<<11,d2 ; masque les 21 bits de poids fort
	or.l	d2,d3
	move.l	d3,(a0)+	; ecrit le premier long mot (data+11 bits de poids fort de link)
	and.w	#MASK_HEIGHT,d1	; 10 bits
	swap	d1		; decale de 16 bits a gauche
	ror.l	#2,d1		; mais il n'en fallait que 14
	or.l	d4,d1		; d1 contient les 8 bits de poids faible de link + la hauteur
	and.w	#MASK_YPOS>>1,d0; 10 bits
	lsl.w	#4,d0		; *2 car en demi-lignes (on a donc garde 11 bits) puis decale de 3 bits
	or.w	d0,d1		; d0 contient les 8 bits de poids faible de link + la hauteur + y_pos
	or.w	SPRITE_TYPE-4(a0),d1
	move.l	d1,(a0)+	; on ecrit le deuxieme long mot
	.else
	move.l	a1,d0
	format_link	d0,d1	;  d0:d1 contient le link formate
	move.l	SPRITE_DATA(a0),d2
	lsl.l	#8,d2		; decale de 8 (+3=11 car les 3 bits de poids faible sont ignores)
	and.l	#$fffff800,d2	; masque les 21 bits de poids fort
	or.l	d2,d0
	move.l	d0,(a0)+	; ecrit le premier long mot (data+11 bits de poids fort de link)
	moveq	#0,d0		; un d0 tout propre
	move.w	SPRITE_HEIGHT-4(a0),d0 ; hauteur (offset-4 car on a avance en ecrivant le premier long mot)
	and.w	#MASK_HEIGHT,d0	; 10 bits
	swap	d0		; decale de 16 bits a gauche
	ror.l	#2,d0		; mais il ne fallait que 14 bits
	or.l	d1,d0		; d0 contient les 8 bits de poids faible de link + la hauteur
	move.w	SPRITE_YPOS-4(a0),d2 ; y
	and.w	#MASK_YPOS>>1,d2	; 10 bits	** BUGFIX **
	lsl.w	#4,d2		; *2 car en demi-lignes (donc en fait 11 bits) puis decale de 3 bits
	or.w	d2,d0		; d0 contient les 8 bits de poids faible de link + la hauteur + y_pos
	or.w	SPRITE_TYPE-4(a0),d0 ; d0 est fin pret
	move.l	d0,(a0)+	; on ecrit le deuxieme long mot
	.endif
	;; calcul de la deuxieme phrase (a0 a ete incremente de 8)
	moveq	#0,d0		; un peu de menage 
	moveq	#0,d1
	moveq	#0,d2
	move.w	SPRITE_FIRSTPIX-8(a0),d0 ;  first pixel
	and.w	#MASK_FIRSTPIX,d0		; 6 bits
	add.w	d0,d0		; decale de 1 bit
	swap	d0		; puis de 16 donc 17 au total
	or.l	SPRITE_RELEASE_TRANS_RMW_REFLECT-8(a0),d0	; d0 contient firstpix + release + trans + rmw + reflect
	move.w	SPRITE_INDEX-8(a0),d1 ; index
	and.w	#MASK_INDEX,d1		; 7 bits
	lsl.w	#6,d1		; decale de 6 bits
	or.w	d1,d0		; d0 contient en plus l'index
	move.w	SPRITE_IWIDTH-8(a0),d1 ; largeur du sprite en phrases
	and.w	#MASK_WIDTH,d1	; 10 bits
	ror.l	#4,d1		; decale de 4 bits afin d'avoir les 6 bits de poids fort en bas
	or.w	d1,d0		; d0 est pret
	move.l	d0,(a0)+	; paf, on l'ecrit
	move.w	SPRITE_DWIDTH-12(a0),d2	; largeur des donnees en phrases
	and.w	#MASK_WIDTH,d2	; 10 bits
	lsl.w	#2,d2		; decale de 2 bits
	swap	d2		; puis de 16 donc 18 bits au total
	or.l	d2,d1		; d1 contient les 4 bits de poids faible de IWIDTH et les 10 bits de DWIDTH
	or.l	SPRITE_PITCH-12(a0),d1 ; on rajoute le pitch
	or.w	SPRITE_DEPTH-12(a0),d1 ; et la profondeur
	move.w	SPRITE_XPOS-12(a0),d0
	and.w	#MASK_XPOS,d0	; 12 bits
	or.w	d0,d1		; d1 est pret
	move.l	d1,(a0)+
	;; calcul de la troisieme phrase (toujours fait meme si l'objet n'est pas un scaled bitmap object) (a0 a ete incremente de 16)
	clr.l	(a0)+		; inutilises
	move.l	SPRITE_ZOOM_DATA-20(a0),(a0)+
	movem.l	(sp)+,d0-d4/a0
	move.l	(a0),SPRITE_RESTORE(a0)	; les donnees effaces par l'OP
	move.l	4(a0),SPRITE_RESTORE+4(a0)
	rts

.macro	fast_refresh_nonscaled_sprite_object
	;; \1 pointe sur le sprite et est modifie
	move.l	SPRITE_RESTORE(\1),(\1)+
	move.l	SPRITE_RESTORE(\1),(\1)+
.endm

.macro	fast_refresh_scaled_sprite_object
	;; \1 pointe sur le sprite et est modifie
	fast_refresh_nonscaled_sprite_object	\1
	move.l	SPRITE_ZOOM_DATA-8(\1),20-8(\1)
.endm
	
refresh_sprite_object:
	;; a0: adresse du sprite
	;; la, c'est tres bete, on recopie les valeurs qu'on avait sauvegarde avant
	;; modifie a0
	fast_refresh_scaled_sprite_object	a0
	rts

.macro	fast_refresh_coords_nonscaled_sprite_object
	move.l	SPRITE_RESTORE(\1),(\1)+
	move.l	SPRITE_RESTORE(\1),\2
	and.l	#~(MASK_YPOS<<3),\2
	move.w	SPRITE_YPOS-4(\1),\3
	and.w	#MASK_YPOS>>1,\3
	lsl.w	#4,\3
	or.w	\3,\2
	move.l	\2,SPRITE_RESTORE(\1)
	move.l	\2,(\1)+
	addq.w	#6,\1
	move.w	(\1),\2
	and.w	#~(MASK_XPOS),\2
	move.w	SPRITE_XPOS-14(\1),\3
	and.w	#MASK_XPOS,\3
	or.w	\3,\2
	move.w	\2,(\1)
.endm

.macro	fast_refresh_coords_scaled_sprite_object
	fast_refresh_coords_nonscaled_sprite_object	\1,\2,\3
	move.l	SPRITE_ZOOM_DATA-14(\1),20-14(\1)
.endm

.macro	fast_refresh_coords_gfx_nonscaled_sprite_object
	move.l	SPRITE_RESTORE(\1),\2
	move.l	SPRITE_DATA(\1),\3
	lsl.l	#8,\3		; decale de 8 (+3 = 11)
	and.l	#$fffff800,\3	; masque les 21 bits de poids fort
	and.l	#$000007ff,\2	; fait la place pour data
	or.l	\3,\2
	move.l	\2,SPRITE_RESTORE(\1)
	move.l	\2,(\1)+	
	move.l	SPRITE_RESTORE(\1),\2
	and.l	#~(MASK_YPOS<<3),\2
	move.w	SPRITE_YPOS-4(\1),\3
	and.w	#MASK_YPOS>>1,\3
	lsl.w	#4,\3
	or.w	\3,\2
	move.l	\2,SPRITE_RESTORE(\1)
	move.l	\2,(\1)+
	addq.w	#6,\1
	move.w	(\1),\2
	and.w	#~(MASK_XPOS),\2
	move.w	SPRITE_XPOS-14(\1),\3
	and.w	#MASK_XPOS,\3
	or.w	\3,\2
	move.w	\2,(\1)
.endm

.macro	fast_refresh_coords_gfx_scaled_sprite_object
	fast_refresh_coords_gfx_nonscaled_sprite_object	\1,\2,\3
	move.l	SPRITE_ZOOM_DATA-14(\1),20-14(\1)
.endm
	
	;; met a jour le sprite en tenant compte d'un changement de coordonnees
	;; plus rapide que update_object
refresh_coords_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; modifie a0, d0, d1
	fast_refresh_coords_scaled_sprite_object	a0,d0,d1
	rts

	;; met a jour l'adresse de l'image du sprite
refresh_gfx_sprite_object:
	;; input
	;; a0: adresse du sprite
	lea	SPRITE_RESTORE(a0),a1
	move.l	(a1),d1
	move.l	SPRITE_DATA(a0),d0
	lsl.l	#8,d0		; decale de 8 (+3=11 car les 3 bits de poids faible sont ignores)
	and.l	#$fffff800,d0	; masque les 21 bits de poids fort
	and.l	#$000007ff,d1	; fait la place pour data
	or.l	d0,d1
	move.l	d1,(a1)+
	move.l	d1,(a0)+
	move.l	(a1)+,(a0)+
	move.l	SPRITE_ZOOM_DATA-8(a0),20-8(a0)
	rts
				
new_simple_sprite:
	;; input
	;; a0: adresse des donnees
	;; d0: largeur en phrase
	;; d1: hauteur
	;; d2: x
	;; d3: y
	;; d4: profondeur du sprite
	;; output
	;; a0 contient l'adresse de la structure decrivant le sprite
	;; construit un sprite transparent a l'endroit avec IWIDTH = DWIDTH
	;; sans rien de special donc
	;; seul est modifie le registre a0 
	move.l	a1,-(sp)
	movem.l	d0-d2/a0/a2,-(sp)	; pour le mm_alloc
	moveq	#SPRITE_SIZEOF,d0
	bsr	mm_alloc
	movem.l	(sp)+,d0-d2/a1/a2	; on a bouge l'adresse de l'image dans a1
	move.w	#BITOBJ,SPRITE_TYPE(a0)
	move.l	a1,SPRITE_DATA(a0)
	move.w	d4,SPRITE_DEPTH(a0)
	move.w	d0,SPRITE_DWIDTH(a0)
	move.l	#O_NOGAP,SPRITE_PITCH(a0)
	move.w	d2,SPRITE_XPOS(a0)
	move.w	d3,SPRITE_YPOS(a0)
	move.w	d0,SPRITE_IWIDTH(a0)
	move.w	d1,SPRITE_HEIGHT(a0)
	clr.w	SPRITE_INDEX(a0)
	move.l	#O_TRANS,SPRITE_RELEASE_TRANS_RMW_REFLECT(a0) ; juste transparent par defaut
	clr.w	SPRITE_FIRSTPIX(a0)
	clr.b	SPRITE_ZOOM_DATA(a0) ; padding
	move.b	#1<<4,SPRITE_REMAINDER(a0)
	move.b	#1<<5,SPRITE_HSCALE(a0)	; x 1
	move.b	#1<<5,SPRITE_VSCALE(a0)	; x 1
	clr.l	SPRITE_ANIM_ARRAY(a0)
	clr.l	SPRITE_ANIM_DATA(a0)
	clr.l	OBJECT_CELL_ADDR(a0)
	clr.l	OBJECT_PREVIOUS_OBJ(a0)
	move.l	(sp)+,a1
	rts

set_sprite_animation:
	;; a0: adresse du sprite
	;; a1: adresse de l'animation
	;; d0.b: vitesse de l'animation
	clr.l	SPRITE_ANIM_ARRAY(a0)
	move.l	(a1),SPRITE_DATA(a0)
	move.b	d0,SPRITE_ANIM_SPEED(a0)
	move.b	#1,SPRITE_ANIM_COUNTER(a0)
	clr.w	SPRITE_ANIM_INDEX(a0)
	move.l	a1,SPRITE_ANIM_ARRAY(a0)
	rts

.macro	clear_sprite_animation
	;; \1: adresse du sprite
	clr.l	SPRITE_ANIM_ARRAY(\1)
.endm

.macro	sprite_animation_off
	;; \1: adresse du sprite
	or.b	#%1,SPRITE_ANIM_ARRAY+3(\1)
.endm

.macro	sprite_animation_on
	;; \1: adresse du sprite
	and.b	#$fe,SPRITE_ANIM_ARRAY+3(\1)
.endm
