;********************************************************************
;************************* JAGUAR-defines ***************************
;********************************************************************
phrase	MACRO
	CNOP 0,16
	ENDM

dphrase	MACRO
	CNOP 0,32
	ENDM

;Memory configuration
MEMCON1   equ $f00000
MEMCON2   equ $f00002

INT       equ $f10020	; DSP
INT1      equ $f000e0
INT2      equ $f000e2
;Programmable Timer
PIT	equ $f00050
ONESECOND	equ $195CA6C

OLP       equ $f00020

BORD      equ $f0002a
BORD1     equ $f0002a                   ; same as BORD ?
BG        equ $f00058
VMODE     equ $f00028
HP        equ $f0002e
HBB       equ $f00030
HBE       equ $f00032
HS        equ $f00034
HVS       equ $f00036
HDB1      equ $f00038
HDB2      equ $f0003a
HDE       equ $f0003c
HEQ       equ $f00054
VP        equ $f0003e
VBB       equ $f00040
VBE       equ $f00042
VS        equ $f00044
VDB       equ $f00046
VDE       equ $f00048
VEB       equ $f0004a
VEE       equ $f0004c
CLUT      equ $f00400
HC        equ $f00004
VC        equ $f00006
VI        equ $f0004e
LPH       equ $f00008
LPV       equ $f0000a
LBUFA     equ $f00800
LBUFB     equ $f01000
LBUFC     equ $f01000

JOYSTICK  equ $f14000
JOYBUTS   equ $f14002
ANAJOY    equ $f17c00

FIRE_A    equ 29
FIRE_B    equ 25
FIRE_C    equ 13
KEY_P     equ 28
KEY_C1    equ 24
KEY_C2    equ 12
KEY_C3    equ 8
KEY_R     equ 23
KEY_L     equ 22
KEY_D     equ 21
KEY_U     equ 20
KEY_O     equ 9
KEY_ASTERISK equ 16
KEY_NUMBER equ 0
KEY_0 equ 4
KEY_1 equ 19
KEY_2 equ 7
KEY_3 equ 3
KEY_4 equ 18
KEY_5 equ 6
KEY_6 equ 2
KEY_7 equ 17
KEY_8 equ 5
KEY_9 equ 1

O_XPOS    equ 0
O_YPOS    equ 2
O_DATA    equ 4
O_HEIGHT  equ 8
O_DWIDTH  equ 10
O_IWIDTH  equ 12
O_FLAGS   equ 14
O_FIRSTPIX          equ 15
O_TYPE    equ 16
O_DEPTH   equ 17
O_PITCH   equ 18
O_INDEX   equ 19
O_DESC    equ 20
O_SCALE   equ 22

OBJSIZE   equ 34 ; 24
;*********** End of VIDEO ***********************************************
;EEPROM:
EEPROM_RMODE	equ	$f14800
EEPROM_READ	equ	$f14800
EEPROM_WRITE	equ	$f15000
EEPROM_RDATA	equ	$f14000
EEPROM_WDATA	equ	$f14800

;Blitter:
A1_BASE		equ $F02200
A1_FLAGS	equ $F02204
A1_CLIP		equ $F02208
A1_PIXEL	equ $F0220C
A1_STEP		equ $F02210
A1_FSTEP	equ $F02214
A1_FPIXEL	equ $F02218
A1_INC		equ $F0221C
A1_FINC		equ $F02220

A2_BASE		equ $F02224
A2_FLAGS	equ $F02228
A2_MASK		equ $F0222C
A2_PIXEL	equ $F02230
A2_STEP		equ $F02234

B_CMD		equ $F02238
B_STATUS	equ $F02238
B_COUNT		equ $F0223C
B_SRCD		equ $F02240
B_DSTD		equ $F02248
B_DESTZ		equ $F02250
B_SRCZINT	equ $F02258
B_SRCZFRAC	equ $F02260
B_PATD		equ $F02268
B_IINC		equ $F02270
B_ZINC		equ $F02274
B_STOP		equ $F02278
B_COLLISION	equ $F02278

PITCH1	equ $00000000
PITCH2	equ $00000001
PITCH4	equ $00000002
PITCH8	equ $00000003
PIXEL1	equ $00000000
PIXEL2	equ $00000008
PIXEL4	equ $00000010
PIXEL8	equ $00000018
PIXEL16	equ $00000020
PIXEL32	equ $00000028
XADDPHR	equ $00000000
XADDPIX	equ $00010000
XADD0	equ $00020000
XADDINC	equ $00030000
YADD0	equ $00000000
YADD1	equ $00040000
XSIGNADD	equ $00000000
XSIGNSUB	equ $00080000
YSIGNADD	equ $00000000
YSIGNSUB	equ $00100000
WIDTH16		equ 512*16
WIDTH32		equ 512*20
WIDTH64		equ 512*24
WIDTH128	equ 512*28
WIDTH160	equ 512*29
WIDTH320	equ 512*33

SRCEN	equ $00000001
SRCENZ	equ $00000002
SRCENX	equ $00000004
DSTEN	equ $00000008
DSTENZ	equ $00000010
DSTWRZ	equ $00000020
CLIP_A1	equ $00000040
UPDA1	equ $00000100
UPDA1F	equ $00000200
UPDA2	equ $00000400
DSTA2	equ $00000800
GOURD	equ $00001000
ZBUFF	equ $00002000
TOPBEN	equ $00004000
TOPNEN	equ $00008000
PATDSEL	equ $00010000
ZMODELT	equ $00040000
ZMODEEQ	equ $00080000
ZMODEGT	equ $00100000

LFU_NAN	equ $00200000
LFU_NA	equ $00400000
LFU_AN	equ $00800000
LFU_A	equ $01000000

LFU_ZERO	equ $00000000
LFU_CLEAR	equ $00000000
LFU_NSAND	equ $00200000
LFU_NSAD	equ $00400000
LFU_NOTS	equ $00600000
LFU_SAND	equ $00800000
LFU_NOTD	equ $00A00000
LFU_N_SXORD	equ $00C00000
LFU_NSORND	equ $00E00000
LFU_SAD		equ $01000000
LFU_SXORD	equ $01200000
LFU_XOR		equ $01200000
LFU_D		equ $01400000
LFU_NSORD	equ $01600000
LFU_S		equ $01800000
LFU_REPLACE	equ $01800000
LFU_SORND	equ $01A00000
LFU_SORD	equ $01C00000
LFU_ONE		equ $01E00000

CMPDST		equ $02000000
BCOMPEN		equ $04000000
DCOMPEN		equ $08000000
BKGWREN		equ $10000000
BUSHI		equ $20000000
SRCSHADE	equ $40000000

;SOUND
R_DAC	equ $F1A148
L_I2S	equ $F1A148
L_DAC	equ $F1A14C
R_I2S	equ $F1A14C
SCLK	equ $F1A150
HZ45072	equ 8
HZ31960	equ 12
HZ25000 equ 16
SMODE	equ $F1A154

;Clocks
CLK1		equ $f10010
CLK2		equ $f10012
CHRO_CLK	equ $f10014
JPI		equ $f10000

;Networking
ASIDATA	equ $f10030
ASICTRL	equ $f10032
ASISTAT	equ $f10032
ASICLK	equ $f10034


; DSP
D_FLAGS		equ	$f1a100
D_MTXC		equ	$f1a104
D_MTXA		equ	$f1a108
D_END		equ	$f1a10c
D_PC		equ	$f1a110
D_CTRL		equ	$f1a114
D_MOD		equ	$f1a118
D_DIVCTRL	equ	$f1a11c
D_REMAIN	equ	$f1a11c
D_MACHI		equ	$f1a120

; GPU
G_FLAGS		equ	$f02100
G_MTXC		equ	$f02104
G_MTXA		equ	$f02108
G_END		equ	$f0210c
G_PC		equ	$f02110
G_CTRL		equ	$f02114
G_HIDATA	equ	$f02118
G_DIVCTRL	equ	$f0211c
G_REMAIN	equ	$f0211c

