;########### for the seriell EEPROM on the Cartridge #########
write_eeprom:	
	movem.l	d1-d3/a0,-(sp)
	clr.w	d1		; cell counter
	clr.w	d2		; checksum
.wcopy:
	move.w	(a0)+,d0	; copy into buffer
	add.w	d0,d2
	move.w	d0,d3
	bsr	eeprom_w_word
	bsr	eeprom_r_word
	cmp.w	d0,d3		; write successfully?
	beq.s	.wsuccess	; yes
	bra.s	.nosuccess	; no
.wsuccess:
	addq.w	#1,d1
	cmp.w	#$3f,d1		; do 0 to $3e, $3f is for checksum!
	blt.b	.wcopy
	eori.w	#$ffff,d2
	move.w	d2,d0
	bsr	eeprom_w_word
	bsr	eeprom_r_word
	cmp.w	d0,d2
	bne	.nosuccess
	moveq	#0,d0
	bra.s	.wend
.nosuccess:
	moveq	#1,d0
.wend:
	movem.l	(sp)+,d1-d3/a0
	rts

;***********************************************
read_eeprom:
	clr.w	d1		; cell counter
	clr.w	d2		; chksum counter
.rcopy:	
	jsr	eeprom_r_word
	add.w	d0,d2
	move.w	d0,(a0)+	; copy into buffer
	addq.w	#1,d1
	cmp.w	#$3f,d1		; do 0 to $3e
	blt.b	.rcopy

	eori.w	#$ffff,d2	; calc checksum
	bsr	eeprom_r_word	; compare with last cell
	cmp.w	d0,d2		; OK?
	bne	.checksum_err
	moveq	#0,d0
	rts

.checksum_err:
	moveq	#-1,d0
	rts


eeprom_r_word:
	movem.l	a0/d1-d3,-(sp)
	lea.l	$f14000,a0
	tst.w	$1000(a0)	; read from EEPROM_WRITE
	andi.w	#$3f,d1		; adjust cell number
	ori.w	#$180,d1	; set prepare to read bits
	move.w	d1,d2		; and write it out
	bsr	eeprom_w_9bit

	moveq	#0,d0
	moveq	#$f,d2		; do 16 bits
.readbit:	
	tst.w	$800(a0)	; read from EEPROM_READ
	nop
	move.w	(a0),d1		; read bit from EEPROM_RDATA
	lsr.w	#1,d1		; get LSB into X
	addx.w	d0,d0		; shift left and add X
	nop
	nop
	nop
	nop
	nop
	nop
	dbf	d2,.readbit
	movem.l	(sp)+,a0/d1-d3
	rts

eeprom_w_16bit:
	rol.w	#1,d2		; make MSB the LSB
	moveq	#$f,d3		; wanna do 16 bits
	bra.b	_writebit

eeprom_w_9bit:
	rol.w	#8,d2		; move 9th bit into LSB
	moveq	#8,d3		; wanna do 9 bits

_writebit:
	move.w	d2,$800(a0) ; write bit into EEPROM_WDATA
	nop
	nop
	nop
	nop
	nop
	rol.w	#1,d2
	dbf	d3,_writebit
	rts

;*****************************
eeprom_w_word:
	movem.l	d0-d3/a0,-(sp)
	lea.l	$f14000,a0
	tst.w	$1000(a0)	; EEPROM_WRITE
	move.w	#$0130,d2
	bsr	eeprom_w_9bit
	tst.w	$1000(a0)	; EEPROM_WRITE
	andi.w	#$3f,d1		; adjust cell number
	ori.w	#$0140,d1
	move.w	d1,d2
	bsr	eeprom_w_9bit
	move.w	d0,d2
	bsr	eeprom_w_16bit
	tst.w	$1000(a0)
	move.w	#$1493,d0	; loop counter
.waitl:	nop
	nop
	nop
	nop
	nop
	nop
	dbra	d0,.waitl
	move.w	#$0100,d2
	bsr	eeprom_w_9bit
	tst.w	$1000(a0)
	movem.l	(sp)+,d0-d3/a0
	rts


;================================================================================================
readpad:
	;movem.l	d0-d2,-(sp)
;scan for player 1 on TTPort A of Joyport 1
          move.l    #$f0fffffc,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$81fe,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81fd,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81fb,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #6,d0
          rol.l     #6,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81f7,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur1A,d0           ; old joycur needed for determining the new joyedge
          move.l    d1,joycur1A           ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge1A          ;joypad,buttons,keys that were just pressed

;scan for player 2 on TTPortB of Joyport 1
          move.l    #$f0fffffc,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$81f0,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81f1,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81f2,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #6,d0
          rol.l     #6,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81f3,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur1B,d0           ; old joycur needed for determining the new joyedge
          move.l    d1,joycur1B           ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge1B          ;joypad,buttons,keys that were just pressed

;scan for player 3 on TTPortC of Joyport 1
          move.l    #$f0fffffc,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$81f4,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81f5,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81f6,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #6,d0
          rol.l     #6,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81f8,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur1C,d0           ; old joycur needed for determining the new joyedge
          move.l    d1,joycur1C           ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge1C          ;joypad,buttons,keys that were just pressed

;scan for player 4 on TTPortD of Joyport 1
          move.l    #$f0fffffc,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$81f9,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81fa,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81fc,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #6,d0
          rol.l     #6,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81ff,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur1D,d0           ; old joycur needed for determining the new joyedge
          move.l    d1,joycur1D           ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge1D          ;joypad,buttons,keys that were just pressed


;******************************** Joyport 2 *******************************************
;
;scan for player 1 on TTPort A of Joyport 2
          move.l    #$0ffffff3,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$817f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81bf,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$81df,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81ef,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur2A,d0         ; old joycur needed for determining the new joyedge
          move.l    d1,joycur2A         ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge2A        ;joypad,buttons,keys that were just pressed

;scan for player 2 on TTPort B of Joyport 2
          move.l    #$0ffffff3,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$810f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$818f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$814f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81cf,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur2B,d0         ; old joycur needed for determining the new joyedge
          move.l    d1,joycur2B         ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge2B        ;joypad,buttons,keys that were just pressed

;scan for player 3 on TTPort C of Joyport 2
          move.l    #$0ffffff3,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$812f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$81af,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$816f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$811f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur2C,d0         ; old joycur needed for determining the new joyedge
          move.l    d1,joycur2C         ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge2C        ;joypad,buttons,keys that were just pressed

;scan for player 4 on TTPort D of Joyport 2
          move.l    #$0ffffff3,d1       ; d1 = Joypad data mask
          moveq.l   #-1,d2              ; d2 = Cumulative joypad reading

          move.w    #$819f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read joypad,pause button,A button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
          move.w    #$815f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read *741 keys,B button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          ror.l     #8,d0
          ror.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
          move.w    #$813f,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 2580 keys,C button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #8,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
          move.w    #$81ff,JOYSTICK
          move.l    JOYSTICK,d0         ; Read 369# keys,Option button
          or.l      d1,d0               ; Mask off unused bits
          rol.b     #2,d0               ; note the size of rol
          rol.l     #4,d0
          and.l     d0,d2               ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

          moveq.l   #-1,d1
          eor.l     d2,d1               ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

          move.l    joycur2D,d0         ; old joycur needed for determining the new joyedge
          move.l    d1,joycur2D         ; Current joypad reading stored into joycur
          eor.l     d1,d0
          and.l     d1,d0
          move.l    d0,joyedge2D        ;joypad,buttons,keys that were just pressed


	;movem.l	(sp)+,d0-d2
          rts       


joyedge:		; Which button has changed compared to the last read?
joyedge1A:  DC.l 0	; 4 ports of first TeamTap
joyedge1B:  DC.l 0
joyedge1C:  DC.l 0
joyedge1D:  DC.l 0
joyedge2A:  DC.l 0	; 4 ports of second TeamTap
joyedge2B:  DC.l 0
joyedge2C:  DC.l 0
joyedge2D:  DC.l 0

joycur:			; current button-state
joycur1A:  DC.l 0	; 4 ports of first TeamTap
joycur1B:  DC.l 0
joycur1C:  DC.l 0
joycur1D:  DC.l 0
joycur2A:  DC.l 0	; 4 ports of second TeamTap
joycur2B:  DC.l 0
joycur2C:  DC.l 0
joycur2D:  DC.l 0

;*********************************************************
copy_olist:         
          lea.l     olist_ram,a0        ;beginning of olist_ram
          lea.l     olist,a1            ;beginning of olist
.10:      move.l    (a0),(a1)+          ;copy olist_ram to olist
          cmpi.l    #4,(a0)+            ;see if we are at the stop object
          bne.s     .10
          rts       

;================================================================================================

build:              ;pack the object data into olist_ram
;A1 = need address of first object
;D6 = total number of objects to be processed

;register use
;A0 is the address of the object list used by the object processor
;A2 is the address of the object list being built
;D0 holds the long being built
;D1 is used for temporary calculations
;D2 is the lines off screen,calculated in set_odata,used by set_oheight
;D3 is #12 for shifting d0
;D4 is #10 for shifting d0
;D5 is #11 for shifting d0
;D6 counts the objects being processed
;D7 is the address of the boject used by the object processor divided by 8
	movem.l	d0-d7/a0-a3,-(sp)

          moveq.l   #12,d3              ;for doing lsl.l on d0
          moveq.l   #10,d4              ;for doing lsl.l on d0
          moveq.l   #11,d5              ;for doing lsl.l on d0
          move.l    #olist,d7           ;address of packed olist
          lsr.l     #3,d7               ;divide by 8 for object processor
          lea.l     olist_ram,a2        ;address of copy of packed olist
          subi.w    #1,d6               ;start dbra counter at total objects - 1
proc_obj:           ;process an object
          tst.b     O_TYPE(a1)          ;check the delete flag for this object
          bmi       next_obj            ;skip this object if negative bit is set

;PHRASE 1
set_odata:          
;if the object is above top line of the screen,
;the data pointer is set to the first line of the object that is on screen
          move.l    O_DATA(a1),d0       ;get normal data address
          move.w    #SCRN_TOP-1,d2
	move.w	O_YPOS(a1),d1

          ;sub.w     O_YPOS(a1),d2       ;top of screen - ypos = half lines off top of screen
	sub.w	d1,d2
          bpl.s     .05                 ;if object is above top of screen,use normal data address
	
.01:      clr.w     d2                  ;0 lines off screen,use normal data address
          bra.s     .10
.05:      lsr.w     #1,d2               ;convert half lines to lines
          move.w    O_DWIDTH(a1),d1     ;get phrases per line of data in the object
          lsl.w     #3,d1               ;multiply phrases * 8 bytes per phrase
          mulu.w    d2,d1               ;lines off screen * bytes per line in the object
          add.l     d1,d0               ;skip the total bytes that are off the top of the screen
.10:      lsr.l     #3,d0               ;divide by 8
          lsl.l     d5,d0               ;shift left 11 bits to make room for link pointer

;set the link pointer to the next object
          addi.l    #4,d7               ;next object is 4 phrases ahead
          move.l    d7,d1               ;get address in olist of next object

          lsr.l     #8,d1               ;the rightmost 8 bits go in the next long,so remove them
          or.l      d1,d0               ;or with data pointer
          move.l    d0,(a2)+            ;save first long in phrase 1,advance the pointer to next long

          move.b    d7,d0               ;get the low 8 bits of the link pointer that was saved earlier
          lsl.l     d4,d0               ;shift left 10 bits to make room for height

set_oheight:        
;d2.w is set to the number of lines that are above the top of the screen
;if part of the object is above the top line of the screen,
;the height is reduced by the number of lines off the top of the screen
          move.w    O_HEIGHT(a1),d1     ;get the height of the object
          cmpi.b    #1,O_TYPE(a1)       ;see if this is a scaled bit map object
          bne.s     .10                 ;branch if object is not scaled
          subi.w    #1,d1               ;an extra line is displayed at the bottom of the object if this is not here
.10:      sub.w     d2,d1               ;subtract lines off screen from scaled height
          bmi.s     .20                 ;if lines off screen > height,make height 0 instead of negative
          or.w      d1,d0               ;or with link pointer in second half of phrase 1
.20:      lsl.l     d5,d0               ;shift left 11 bits to make room for ypos

set_oypos:          
;if ypos is negative,it gets set to 0
;set_odata and set_oheight will adjust the data pointer and height accordingly
          move.w    O_YPOS(a1),d1
          bmi.s     .10                 ;if ypos is negative,object would not be displayed,so set ypos to 0
          andi.w    #$7ff,d1            ;only write 11 bits for ypos
          or.w      d1,d0               ;or with link pointer and height
.10:      lsl.l     #3,d0               ;shift left 3 bits to make room for type

set_otype:          
          or.b      O_TYPE(a1),d0       ;object type
          move.l    d0,(a2)+            ;write second half of phrase 1

;PHRASE 2
set_ofirstpix:      
          move.b    O_FIRSTPIX(a1),d0
          lsl.l     #4,d0               ;shift left 4 bits to make room for release,transparent,rmw,reflect bits

set_flags:          
          or.b      O_FLAGS(a1),d0      ;or with firstpix
          lsl.l     #7,d0               ;shift left 7 bits to make room for index

set_oindex:         
          or.b      O_INDEX(a1),d0      ;or with firstpix and flags
          lsl.l     #6,d0               ;shift left 6 bits to make room for part of iwidth

set_oiwidth:        
          move.w    O_IWIDTH(a1),d1
          lsr.w     #4,d1               ;right 4 bits go in the next long,so remove them
          or.b      d1,d0
          move.l    d0,(a2)+            ;write first long of phrase 2

          move.w    O_IWIDTH(a1),d0
          andi.w    #$f,d0              ;get low 4 bits of iwidth
          lsl.l     d4,d0               ;shift left 10 bits to make room for dwidth

set_odwidth:        
          or.w      O_DWIDTH(a1),d0     ;or with part of iwidth
          lsl.l     #3,d0               ;shift left 3 bits to make room for pitch

set_opitch:         
          or.b      O_PITCH(a1),d0      ;or with dwidth and iwidth
          lsl.l     #3,d0               ;shift left 3 bits to make room for depth

set_odepth:         
          or.b      O_DEPTH(a1),d0      ;or with dwidth,iwidth,pitch
          lsl.l     d3,d0               ;shift left 12 bits to make room for xpos

set_oxpos:          
          move.w    O_XPOS(a1),d1       ;object xpos
          andi.w    #$fff,d1            ;only write 12 bits for xpos
          or.w      d1,d0               ;or with the rest of the stuff
          move.l    d0,(a2)+            ;write second half of phrase 2

;PHRASE 3
;for scaled bit map object only
          move.l    O_SCALE(a1),4(a2)   ;write remainder,vscale,hscale bytes in 2nd long of phrase 3
          adda.l    #16,a2              ;move pointer past the last 2 phrases for current object

next_obj:           ;jump to here if delete flag is on
          adda.l    #OBJSIZE,a1         ;point to next object in pseudo object list
          dbra      d6,proc_obj         ;repeat until all objects have been processed

;write a stop object at the end of the list
          move.l    #0,(a2)+
          move.l    #4,(a2)             ;write object type 4 (stop object)

	movem.l	(sp)+,d0-d7/a0-a3

          rts       

