;********************************************************************
;***           TTTest.s                                          ****
;********************************************************************

;********************************************************************
TestForTeamTap:
	; test for TeamTap on Joyport 1
        move.w	#$81fa,JOYSTICK	; read from Port 3 (D), Row 1
        move.w	JOYBUTS,d0	; Read B button, C1
	btst	#0,d0	; test only button0 (C1)
	bne.s	C1notset	; reverse logic !
C1set:
	; TeamTap connected
	or.b	#$01,ttconnected
	move.l	#wABC,text_font
	move.b	#11,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTfound,text_adr
	bsr	do_text2
	bra.s	C1goon
C1notset:
	; TeamTap not connected
	move.l 	#wTTMarked1A,ttbmadr	; no artwork available, so show as Port 1A -Joypad
	and.b	#$fe,ttconnected
	move.l	#wABC,text_font
	move.b	#11,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTnotfound,text_adr
	bsr	do_text2
	;bra.s	C1goon

C1goon:
	; test for TeamTap on Joyport 2
        move.w	#$815f,JOYSTICK	; read from Port 3 (D), Row 1
        move.w	JOYBUTS,d0	; Read B button, C1
	btst	#2,d0	; test only button2 (C1)
	bne.s	C1notset2	; reverse logic !
C1set2:
	; TeamTap connected
	or.b	#$02,ttconnected
	move.l	#wABC,text_font
	move.b	#13,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTfound,text_adr
	bsr	do_text2
	bra.s	C1goon2
C1notset2:
	; TeamTap not connected
	move.l 	#wTTMarked1A,ttbmadr	; no artwork available, so show as Port 1A -Joypad
	and.b	#$fd,ttconnected
	move.l	#wABC,text_font
	move.b	#13,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTnotfound,text_adr
	bsr	do_text2
	;bra.s	C1goon2

C1goon2:
	rts

;*****************************************************************
ShowTTPort:
	movem.l	d0-d1,-(sp)

	;***move.b	ttconnected,d0
	;***bne.s	tt1isconnected	
	;***move.w	#0,tth		; hide TeamTap-image
	;***move.w	#0,ttph		; hide TeamTap-Port-image
	;***jmp	test_ttport_end

tt1isconnected:
	;***move.w	#78,tth		; show TeamTap-image
	;move.w	#8,ttph		; is always set later

	move.b	#$ff,ttport	; no port
	
testPort1A:
	cmp.l	#0,joyedge1A
	beq.s	testPort1B
	move.b	#0,ttport
	move.b	#0,ttport_old
	jmp	testPort1End

testPort1B:
	cmp.l	#0,joyedge1B
	beq.s	testPort1C
	move.b	#1,ttport
	move.b	#1,ttport_old
	jmp	testPort1End

testPort1C:
	cmp.l	#0,joyedge1C
	beq.s	testPort1D
	move.b	#2,ttport
	move.b	#2,ttport_old
	jmp	testPort1End

testPort1D:
	cmp.l	#0,joyedge1D
	beq.s	testPort1End
	move.b	#3,ttport
	move.b	#3,ttport_old
	;jmp	testPort1End

testPort1End:

testPort2A:
	cmp.l	#0,joyedge2A
	beq.s	testPort2B
	move.b	#4,ttport
	move.b	#4,ttport_old
	jmp	testPort2End

testPort2B:
	cmp.l	#0,joyedge2B
	beq.s	testPort2C
	move.b	#5,ttport
	move.b	#5,ttport_old
	jmp	testPort2End

testPort2C:
	cmp.l	#0,joyedge2C
	beq.s	testPort2D
	move.b	#6,ttport
	move.b	#6,ttport_old
	jmp	testPort2End

testPort2D:
	cmp.l	#0,joyedge2D
	beq.s	testPort2End
	move.b	#7,ttport
	move.b	#7,ttport_old
	;jmp	testPort2End

testPort2End:

	move.b	ttport_old,d0	; Show this port

test_ttport1A:
	cmp.b	#0,d0
        bne.s   test_ttport1B

	move.l 	#wTTMarked1A,ttbmadr
	move.l 	#wTTPortA,ttpadr
	move.w	#64+15,ttpx
	move.w	#28+2*66,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1B:
	cmp.b	#1,d0
        bne.s   test_ttport1C

	move.l 	#wTTMarked1B,ttbmadr
	move.l 	#wTTPortB,ttpadr
	move.w	#64+52,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1C:
	cmp.b	#2,d0
        bne.s   test_ttport1D

	move.l 	#wTTMarked1C,ttbmadr
	move.l 	#wTTPortC,ttpadr
	move.w	#64+93,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1D:
	cmp.b	#3,d0
        bne.s   test_ttport1_end

	move.l 	#wTTMarked1D,ttbmadr
	move.l 	#wTTPortD,ttpadr
	move.w	#64+134,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1_end:
test_ttport2A:
	cmp.b	#4,d0
        bne.s   test_ttport2B

	move.l 	#wTTMarked2A,ttbmadr
	move.l 	#wTTPortA,ttpadr
	move.w	#64+15,ttpx
	move.w	#28+2*66,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2B:
	cmp.b	#5,d0
        bne.s   test_ttport2C

	move.l 	#wTTMarked2B,ttbmadr
	move.l 	#wTTPortB,ttpadr
	move.w	#64+52,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2C:
	cmp.b	#6,d0
        bne.s   test_ttport2D

	move.l 	#wTTMarked2C,ttbmadr
	move.l 	#wTTPortC,ttpadr
	move.w	#64+93,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2D:
	cmp.b	#7,d0
        bne.s   test_ttport2_end

	move.l 	#wTTMarked2D,ttbmadr
	move.l 	#wTTPortD,ttpadr
	move.w	#64+134,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2_end:
test_ttport_end:

	movem.l	(sp)+,d0-d1
	rts
;*****************************************************************
; 
joystick:
	movem.l	d0-d1/a0,-(sp)

	; hide object
	move.w	#0,avp2h

	;move.l	joycur,d0

	move.b	ttport_old,d0
	;cmp.b	#$ff,d0
	;bne.s	joy_goon
	;jmp	test_end	;!!!!!!!!!!!!!!!!!!!!!!!

joy_goon:

	moveq.l	#0,d0
	move.b	ttport_old,d0
	asl.b	#2,d0
	lea	joycur,a0
	move.l	(a0,d0),d0

test_keyU:
        btst    #KEY_U,d0
        beq.s   test_keyD

	move.l 	#wCursorU,avp2adr
	move.w	#64+25,avp2x
	move.w	#28+2*80+2*11,avp2y	(#78+2*80+2*11)
	move.w	#24,avp2h
	move.w	#(32*2/8),avp2dw
	move.w	#(32*2/8),avp2iw

test_keyD:
	btst    #KEY_D,d0
	beq.s   test_keyL

	move.l 	#wCursorD,avp2adr
	move.w	#64+25,avp2x
	move.w	#28+2*80+2*11,avp2y	(78+ )
	move.w	#24,avp2h
	move.w	#(32*2/8),avp2dw
	move.w	#(32*2/8),avp2iw


test_keyL:	
	btst    #KEY_L,d0
	beq.s   test_keyR

	move.l 	#wCursorL,avp2adr
	move.w	#64+25,avp2x
	move.w	#28+2*80+2*11,avp2y	(78+ )
	move.w	#24,avp2h
	move.w	#(32*2/8),avp2dw
	move.w	#(32*2/8),avp2iw


test_keyR:	
	btst    #KEY_R,d0
	beq.s   test_keyP

	move.l 	#wCursorR,avp2adr
	move.w	#64+25,avp2x
	move.w	#28+2*80+2*11,avp2y	(78+ )
	move.w	#24,avp2h
	move.w	#(32*2/8),avp2dw
	move.w	#(32*2/8),avp2iw

;********************************************************
test_keyP:	
	btst    #KEY_P,d0
	beq.s   test_keyO

	move.l 	#wPause,avp2adr
	move.w	#64+66,avp2x
	move.w	#28+2*80+2*28,avp2y	; (#78+)
	move.w	#16,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_keyO:	
	btst    #KEY_O,d0
	beq.s   test_keyA

	move.l 	#wOption,avp2adr
	move.w	#64+81,avp2x
	move.w	#28+2*80+2*28,avp2y	; (#78+)
	move.w	#16,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_keyA:	
	btst    #FIRE_A,d0
	beq.s   test_keyB

	move.l 	#wButtonA,avp2adr
	move.w	#64+128,avp2x
	move.w	#28+2*80+2*8,avp2y	; (#78+)
	move.w	#20,avp2h
	move.w	#(24*2/8),avp2dw
	move.w	#(24*2/8),avp2iw

test_keyB:	
	btst    #FIRE_B,d0
	beq.s   test_keyC

	move.l 	#wButtonB,avp2adr
	move.w	#64+118,avp2x
	move.w	#28+2*80+2*17,avp2y	; (#78+)
	move.w	#20,avp2h
	move.w	#(24*2/8),avp2dw
	move.w	#(24*2/8),avp2iw

test_keyC:
	btst    #FIRE_C,d0
	beq.s   test_key1

	move.l 	#wButtonC,avp2adr
	move.w	#64+108,avp2x
	move.w	#28+2*80+2*31,avp2y	; (#78+)
	move.w	#20,avp2h
	move.w	#(24*2/8),avp2dw
	move.w	#(24*2/8),avp2iw

;**************************************************************
test_key1:
	btst    #KEY_1,d0
	beq.s   test_key2

	move.l 	#wButtonX,avp2adr
	move.w	#64+54,avp2x
	move.w	#28+2*80+2*75,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key2:
	btst    #KEY_2,d0
	beq.s   test_key3

	move.l 	#wButtonX,avp2adr
	move.w	#64+80,avp2x
	move.w	#28+2*80+2*75,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key3:
	btst    #KEY_3,d0
	beq.s   test_key4

	move.l 	#wButtonX,avp2adr
	move.w	#64+105,avp2x
	move.w	#28+2*80+2*76,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

;**************************************************************
test_key4:
	btst    #KEY_4,d0
	beq.s   test_key5

	move.l 	#wButtonX,avp2adr
	move.w	#64+54,avp2x
	move.w	#28+2*80+2*93,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key5:
	btst    #KEY_5,d0
	beq.s   test_key6

	move.l 	#wButtonX,avp2adr
	move.w	#64+80,avp2x
	move.w	#28+2*80+2*94,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key6:
	btst    #KEY_6,d0
	beq.s   test_key7

	move.l 	#wButtonX,avp2adr
	move.w	#64+105,avp2x
	move.w	#28+2*80+2*94,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

;**************************************************************
test_key7:
	btst    #KEY_7,d0
	beq.s   test_key8

	move.l 	#wButtonX,avp2adr
	move.w	#64+55,avp2x
	move.w	#28+2*80+2*111,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key8:
	btst    #KEY_8,d0
	beq.s   test_key9

	move.l 	#wButtonX,avp2adr
	move.w	#64+80,avp2x
	move.w	#28+2*80+2*111,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key9:
	btst    #KEY_9,d0
	beq.s   test_keyAsterisk

	move.l 	#wButtonX,avp2adr
	move.w	#64+105,avp2x
	move.w	#28+2*80+2*111,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

;**************************************************************
test_keyAsterisk:
	btst    #KEY_ASTERISK,d0
	beq.s   test_key0

	move.l 	#wButtonX,avp2adr
	move.w	#64+55,avp2x
	move.w	#28+2*80+2*128,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_key0:
	btst    #KEY_0,d0
	beq.s   test_keyNumber

	move.l 	#wButtonX,avp2adr
	move.w	#64+80,avp2x
	move.w	#28+2*80+2*128,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_keyNumber:
	btst    #KEY_NUMBER,d0
	beq.s   test_keyEnd

	move.l 	#wButtonX,avp2adr
	move.w	#64+104,avp2x
	move.w	#28+2*80+2*128,avp2y	; (#78+)
	move.w	#6,avp2h
	move.w	#(16*2/8),avp2dw
	move.w	#(16*2/8),avp2iw

test_keyEnd:

test_reset:
	btst    #KEY_NUMBER,d0
        beq.s   test_end
        btst    #KEY_ASTERISK,d0
        beq.s   test_end
        move.w  #1,exit
	move.b	#0,status

test_end:
	movem.l	(sp)+,d0-d1/a0
	rts
