;********************************************************************
;***           Joypad-Test program  for the Atari Jaguar         ****
;***                                                             ****
;***  Purpose: Shows the first depressed button on the first     ****
;***           joypad                                            ****
;***                                                             ****
;***  Author:  Matthias Domin                                    ****
;***  Date:    August 22, 2000                                   ****
;***                                                             ****
;***  Mail to: Matthias.Domin@t-online.de                        ****
;********************************************************************
	
	OUTPUT c:\develop\jaguar\spiele\teamtap.JAG

SCRN_TOP equ $2e
	
	include "jaguar.h"

down      equ $5000 ;Download            ;adress in Jaguar.
start     equ $5000 ;Start               ;adress in Jaguar.


	OPT D-   ; No debugging

; The JagServer-Header:
;
c_down:   DC.b 'JAGR'                  ; Magic to skip Devpac Header.

          DC.w 3                       ; JagOS 3 - Receive & Run. 
          DC.l down                    ; Download adress.
          ;DC.l c_end-c_start           ; Lenght of Jaguar Code.
          DC.l 0                        ; A dc.l 0 is also possible
          DC.l start                   ; Start adress.

 ORG start   ; Position dependent code.

;================================================================================================

TOTAL_OBJS	equ 7	(Background+ScaledBackground+Textscreen)

;================================================================================================
c_start:            ;Jaguar code start .....

	move.w    #$35cc,MEMCON2      ; Do the old endian thing
	move.w    #$8000,CHRO_CLK

	move.l    #0,$f02114
	move.l    #0,$f03f00          ;Clear    it.

	jsr	make_fonts


	lea.l     mypal,a0
	jsr       set_palette         ; load in the palette


;***** 18.04.98: PAL- and NTSC-support ******	
	btst	#4,$00f14003
	beq.s	setPAL
setNTSC:
	jsr	to60hz
	move.w	#$1f0+1,n_vde_value	; used for VBL-Interrupt
	bra.s	setIRQ

setPAL:
	jsr	to50hz
	move.w	#$20e+1,n_vde_value
;	bra.s	setIRQ


setIRQ:
          jsr       IntInit

;***************************************************************
; Just do once to ensure audio is audible
          move.w    #$100,JOYSTICK      ; turns off audio mute
;***************************************************************

	move.w    #TOTAL_OBJS,d6
	lea.l     obj_data,a1
	jsr       build               ; initialize the object lists
	jsr       copy_olist
	move.l    #olist,d0           ; get address of start of object list
	swap.w    d0
	move.l    d0,OLP



; clear the bitmap
	move.l	#score_bmp,a1
	move.l	#(320/2*240)/4-1,d0
	moveq.l	#0,d1
clear1:	move.l	d1,(a1)+
	dbf	d0,clear1


	move.w    #$4c1,VMODE         ; CRY-Mode ->Turn on the display

	move.l    #$00ff0000,BG		; blue background
	move.l    #$000000ff,BORD1	; blue border
	;move.l    #$00ff0000,BORD1	; red border


; now print some text into the text-screen:
	move.l	#score_bmp,text_bmp	; where to copy the text

	; White text
	move.l	#wABC,text_font
	move.b	#8,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#hellotext,text_adr
	bsr	do_text2

	move.b	#9,zeil
	move.l	#author,text_adr
	bsr	do_text2

	move.l	#wABC2,text_font		; use font of other colour
	move.b	#10,zeil
	move.l	#text1,text_adr
	bsr	do_text2

	move.b	#12,zeil
	move.l	#text2,text_adr
	bsr	do_text2
textende:

	; initialize some important variables
	move.w	#0,spr_y	; background sprite position
	move.w	#0,spr_x

	move.b	#0,ttport
	move.b	#$8f,markercol	; start with green
	move.b	#5,colcycle	; change colour only every 5. frame
	move.b	#0,ttconnected

        move.w  #0,exit
	move.b	#1,status	

; Wait some time for ejection of BJL-cable.
; if connected, the program may detect the reset condition ("*" + "#")
;
;	move.w	#500,sek_wait
;waitloop:
;	jsr     wait_int	; wait for next VBL, destroys d0!!!!
;	sub.w	#1,sek_wait
;	bne.s	waitloop


;********************************************************
mainloop: 
	jsr     wait_int	; wait for next VBL, destroys d0!!!!

	; rebuild the screen:

;******* Do a colour palette cycling for the Teamtap-marker-object
	move.b	colcycle,d0
	subq.b	#1,d0
	move.b	d0,colcycle
	cmp.b	#0,d0
	bne.s	endofcolcycling

	move.b	#5,colcycle
	move.b	markercol,d0
	add.b	#$10,d0
	move.b	d0,markercol
	lea	CLUTmarkedTeamTap,a0
	move.l	#2*(16-1),d1
colcycling:
	move.b	d0,(a0,d1)
	subq.l	#2,d1
	bpl.s	colcycling
		
	lea.l     mypal,a0
	jsr       set_palette         ; load in the palette
endofcolcycling:
;******* end of  colour palette cycling

	; rebuild the objectlist:
	move.w	#TOTAL_OBJS,d6      ; number of Object Headers
	lea.l	obj_data,a1         ; beginning of object list
	jsr	build               ; rebuild the object list

	bsr	TestForTeamTap
        ; get user input
        bsr     readpad		; All 4 ports of Joypad-Port 1+2
	bsr	ShowTTPort
        bsr     joystick	; process it, needs the TT-Port!


do_loop:
;	cmp.b	#1,status	; user pressed * + # ?
;	beq	mainloop	; no, so go on
	bra	mainloop	; Jaguar needs to be HW-reseted to stop the program


;*********************************************************
; Exit the program
back:
	move.l	#$0,D_CTRL	; hold DSP 
	move.w	#0,SCLK		; stop Sound
	move.w	#$00,SMODE	;

	move.l    s_level2,LEVEL2
	move.l    s_vi,VI
	move.l    s_int1,INT1
	move.w    s_sr,sr
	move.l    #0,$f02114
	move.w    #$4c0,VMODE

	rts       


;**********************************************************************
	include	"TTTest.s"	; contains the several tests for
				; displaying Teamtap-images and
				; highlightning of joypad-buttons

	include "jaguar.s"	; reading/writing to E2PROM and
				; reading _all_ joypads

	include	"jagvideo.s"	; video-settings

	include	"mytext.s"	; text-output, font-converting

;******** DATA ********************************************************
	dphrase

mypal:  
	dc.w $0000	; 0=Black (also the transparenzy colour!)
	dc.w $0000	; 1=
	dc.w $ff70	; 2=Dark Yellow
	dc.w $ffff	; 3=Light Yellow
	dc.w $8f70	; 4=Dark Green
	dc.w $8fff	; 5=Light Green
	dc.w $0000	; 6=
	dc.w $0000	; 7=
	dc.w $88ff	; 8=White for wABC-font
	dc.w $f8f0	; 9=Orange
	dc.w $0000	;10=
	dc.w $0000	;11=
	DC.w $0000	;12=
	dc.w $0000	;13=
	dc.w $0000	;14=
	dc.w $88ff	;15=White

          DC.w $34ff,$0fff,$f0ff,$f8ff,$8fff,$55ff,$2eff,$e2ff,$08ff,$09ff,$0aff,$0bff,$0cff,$0dff,$0eff,$0fff

; The Colours for the Teamtap: O_INDEX = 16
CLUTTeamTap:
	dc.w $88ff, $884c, $88a4, $8870, $8892, $8890, $8854, $885c, $886c, $8884, $8874, $8884, $887c, $8860, $88ac, $882c

; The Colours for the markedTeamtap: O_INDEX = 24
CLUTmarkedTeamTap:
	dc.w $8fff, $8f4c, $8fa4, $8f70, $8f92, $8f90, $8f54, $8f5c, $8f6c, $8f84, $8f74, $8f84, $8f7c, $8f60, $8fac, $8f2c

; Original 256 CLUT
          DC.w $00ff,$01ff,$02ff,$03ff,$04ff,$05ff,$06ff,$07ff,$08ff,$09ff,$0aff,$0bff,$0cff,$0dff,$0eff,$0fff
          DC.w $10ff,$11ff,$12ff,$13ff,$14ff,$15ff,$16ff,$17ff,$18ff,$19ff,$1aff,$1bff,$1cff,$1dff,$1eff,$1fff
          DC.w $20ff,$21ff,$22ff,$23ff,$24ff,$25ff,$26ff,$27ff,$28ff,$29ff,$2aff,$2bff,$2cff,$2dff,$2eff,$2fff
          DC.w $30ff,$31ff,$32ff,$33ff,$34ff,$35ff,$36ff,$37ff,$38ff,$39ff,$3aff,$3bff,$3cff,$3dff,$3eff,$3fff
          DC.w $40ff,$41ff,$42ff,$43ff,$44ff,$45ff,$46ff,$47ff,$48ff,$49ff,$4aff,$4bff,$4cff,$4dff,$4eff,$4fff
          DC.w $50ff,$51ff,$52ff,$53ff,$54ff,$55ff,$56ff,$57ff,$58ff,$59ff,$5aff,$5bff,$5cff,$5dff,$5eff,$5fff
          DC.w $60ff,$61ff,$62ff,$63ff,$64ff,$65ff,$66ff,$67ff,$68ff,$69ff,$6aff,$6bff,$6cff,$6dff,$6eff,$6fff
          DC.w $70ff,$71ff,$72ff,$73ff,$74ff,$75ff,$76ff,$77ff,$78ff,$79ff,$7aff,$7bff,$7cff,$7dff,$7eff,$7fff
          DC.w $80ff,$81ff,$82ff,$83ff,$84ff,$85ff,$86ff,$87ff,$88ff,$89ff,$8aff,$8bff,$8cff,$8dff,$8eff,$8fff
          DC.w $90ff,$91ff,$92ff,$93ff,$94ff,$95ff,$96ff,$97ff,$98ff,$99ff,$9aff,$9bff,$9cff,$9dff,$9eff,$9fff
          DC.w $a0ff,$a1ff,$a2ff,$a3ff,$a4ff,$a5ff,$a6ff,$a7ff,$a8ff,$a9ff,$aaff,$abff,$acff,$adff,$aeff,$afff
          DC.w $b0ff,$b1ff,$b2ff,$b3ff,$b4ff,$b5ff,$b6ff,$b7ff,$b8ff,$b9ff,$baff,$bbff,$bcff,$bdff,$beff,$bfff
          DC.w $c0ff,$c1ff,$c2ff,$c3ff,$c4ff,$c5ff,$c6ff,$c7ff,$c8ff,$c9ff,$caff,$cbff,$ccff,$cdff,$ceff,$cfff
          DC.w $d0ff,$d1ff,$d2ff,$d3ff,$d4ff,$d5ff,$d6ff,$d7ff,$d8ff,$d9ff,$daff,$dbff,$dcff,$ddff,$deff,$dfff
          DC.w $e0ff,$e1ff,$e2ff,$e3ff,$e4ff,$e5ff,$e6ff,$e7ff,$e8ff,$e9ff,$eaff,$ebff,$ecff,$edff,$eeff,$efff
          DC.w $f0ff,$f1ff,$f2ff,$f3ff,$f4ff,$f5ff,$f6ff,$f7ff,$f8ff,$f9ff,$faff,$fbff,$fcff,$fdff,$feff,$ffff


	dphrase
clock_tab1:		; from 50hz.s sample program
	dc.w	$e2,$352,$6af,$9e
	dc.w	$6d5,$259,$313,$6a0
	dc.w	$a6,$a6,$26f,6
	dc.w	$22,$2e,$20e,$258
	dc.w	$265,$26a


clock_tab2:		; from 60hz.s sample program
	dc.w	$b5,$34c,$6b1,$7d
	dc.w	$6cd,$28b,$310,$6a0
	dc.w	$a6,$a6,$20b,6
	dc.w	$18,$2e,$1f0,$1f4
	dc.w	$1ff,$205



	dphrase
	
;****************************************************
; Attention:
; If the screen looks corrupted, than enlarge the space
; for olist and olist_ram !!!!!!!!!!!!
;****************************************************
olist:    
          DS.l ((8*TOTAL_OBJS)+2)      ;object list used by object processor
;need 8 longs for each object
;and 2 longs for a stop object

	dphrase
olist_ram:          
          DS.l ((8*TOTAL_OBJS)+2)      ;packed version of objects in obj_data
;need 8 longs for each object
;and 2 longs for a stop object


	dphrase
;================================================================================================
;  Cursor and Font graphic data
	EVEN
bild:     DS.l 1

spal:     DS.b 1	; Text row
zeil:     DS.b 1	; Text column
ttport:	ds.b	1	; Welcher TeamTap-Port
ttport_old:	ds.b	1	; Welcher TeamTap-Port war zuletzt benutzt worden?
markercol:	ds.b 1	; Actual highlightning colour
colcycle:	ds.b	1	; change colour every 5. frame
ttconnected	ds.b	1	; bitfield:
				; bit0 set = TT at Joyport 1, bit1 set = TT at Joyport 2
	even
sek_wait:	ds.w	1
levelsek:	ds.w	1
uebersek:	ds.w	1

spr_y:	ds.w	1 ;The sprite-positon
spr_x:	ds.w	1

        even
n_vde_value: ds.w	1	; PAL or NTSC-value

ret_tast:       ds.w    1
al_string:      ds.l    1
zeisatz:        ds.l    1

text_font: ds.l 1	; address of the actual font
text_adr: DS.l 1	; address of the actual text
text_bmp: ds.l 1	; address of the output bitmap

	even
wABC:	incbin "abc3.img"	; the original font

	dphrase
;********************* Images for the Joypad ****************************
wMyBMP:	incbin "joypadsm.cry"	; My background bitmap

wCursorU:	incbin "cursoru.cry"	; Up
wCursorD:	incbin "cursord.cry"	; Down
wCursorL:	incbin "cursorl.cry"	; Left
wCursorR:	incbin "cursorr.cry"	; Right

wPause:	incbin "pause2.cry"	; Pause
wOption:	incbin "option2.cry"	; Option

wButtonA:	incbin "ButtonA2.cry"	; Firebutton A
wButtonB:	incbin "ButtonB2.cry"	; Firebutton B
wButtonC:	incbin "ButtonC2.cry"	; Firebutton C

wButtonX:	incbin "ButtonX2.cry"	; Buttons 0-9,*,#

;****************** Images for the TeamTap-device ***********************
wTeamTap:	incbin "teamtaps.cry"	; the Teamtap itself
wTTPortA:	incbin "ttporta2.cry"	; Port A of the TT
wTTPortB:	incbin "ttportb2.cry"	; Port B of the TT
wTTPortC:	incbin "ttportc2.cry"	; Port C of the TT
wTTPortD:	incbin "ttportd2.cry"	; Port D of the TT

;****************** Images connection sketch ***********************
wTTSketch:	incbin "tt8box16.cry"	; the Teamtap itself

wTTMarked1A:	incbin "tt8box1A.cry"	; the Teamtap itself
wTTMarked1B:	incbin "tt8box1B.cry"	; the Teamtap itself
wTTMarked1C:	incbin "tt8box1C.cry"	; the Teamtap itself
wTTMarked1D:	incbin "tt8box1D.cry"	; the Teamtap itself

wTTMarked2A:	incbin "tt8box2A.cry"	; the Teamtap itself
wTTMarked2B:	incbin "tt8box2B.cry"	; the Teamtap itself
wTTMarked2C:	incbin "tt8box2C.cry"	; the Teamtap itself
wTTMarked2D:	incbin "tt8box2D.cry"	; the Teamtap itself

	EVEN

wABC2:	ds.b	5760	; Space for 96 characters (15 bitlines with 4 Bytes = 8 4bit pixels)


	even
hellotext:	dc.b	"Joypad-Tester",0

	even
author:	dc.b	"By Matthias Domin",0

	even
text1:	dc.b	"Joyport 1:",0
text2:	dc.b	"Joyport 2:",0

TTfound:	dc.b	"TeamTap found!    ",0
TTnotfound:	dc.b	"TeamTap not found!",0
	dphrase

;================================================================================================
;  Object List Headers
;	1. object:	Joypad-image
;	2. object:	highlighted button the Joypad
;	3. object:	TeamTap-image
;	4. object:	highlighted port of TeamTap
;	5. object:	image of a Jaguar with 2 TeamTaps and 8 Joypads
;	6. object:	highlighted Joypad-Teamtap-Jaguar-connection
;	7. object:	text screen (320*240 4bit)

          dphrase
obj_data:		; start of a TOTAL_OBJS object structs

;*****************************************************************************
; The 1. object in this program: 
; The Joypad
avpx	DC.w 64 ; o_xpos, align this to the right edge of the text screen
avpy	DC.w 28+2*80	; o_ypos	(78+2*80)
avpadr	DC.l wMyBMP	; o_data
          DC.w 143	; o_height
          DC.w (174*2)/8	; o_dwidth 174 16bit pixels phrase aligned
          DC.w (174*2)/8	; o_iwidth 174 16bit pixels phrase aligned = 268
          DC.b 0	; o_flags	
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; Bitmap (non-scaled)
          DC.b 4	; o_depth	; 65536 colours / 16Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 0	; o_index
          DC.w 0	; o_desc

avpmodif	DC.w 20
avpyscale	DC.b $20
avpxscale	DC.b $20

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

; The highlighted button:
;
avp2x	DC.w 64		; o_xpos, align this to the left edge of the text screen
avp2y	DC.w 28+2*80 	; o_ypos, align this to the middle off the text screen
avp2adr	DC.l wMyBMP	; o_data
avp2h	DC.w 143	; o_height
avp2dw	DC.w (174*2)/8	; o_dwidth 174 16bit pixels phrase aligned
avp2iw	DC.w (174*2)/8	; o_iwidth 174 16bit pixels phrase aligned
          DC.b 0	; o_flags	
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; 1 =Bitmap (scaled)
          DC.b 4	; o_depth	; 65536 colours / 16Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 0	; o_index
          DC.w 0	; o_desc

avp2modif	DC.w 20
avp2yscale	DC.b $40	; 200% 
avp2xscale	DC.b $40	; in both directions

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode


;*****************************************************************************
; The 3. object in this program:
; The TeamTap-device
;
ttx	DC.w 64 ; o_xpos, align this to the right edge of the text screen
tty	DC.w 28	; o_ypos	(78)
ttadr	DC.l wTeamTap	; o_data
tth       DC.w 78	; o_height
          DC.w (172*2)/8	; o_dwidth 172 16bit pixels phrase aligned
          DC.w (172*2)/8	; o_iwidth 172 16bit pixels phrase aligned
          DC.b 0	; o_flags	
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; Bitmap (non-scaled)
          DC.b 4	; o_depth	; 65536 colours / 16Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 0	; o_index
          DC.w 0	; o_desc

ttmodif         DC.w 20
ttyscale	DC.b $20
ttxscale	DC.b $20

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

;*****************************************************************************
; The 4. object in this program:
; The highlighted port of the TeamTap-device
;
ttpx	DC.w 64		; o_xpos
ttpy	DC.w 28 	; o_ypos	(78)
ttpadr	DC.l wTeamTap	; o_data
ttph	DC.w 78	; o_height
ttpdw	DC.w (172*2)/8	; o_dwidth 172 16bit pixels phrase aligned
ttpiw	DC.w (172*2)/8	; o_iwidth 172 16bit pixels phrase aligned
          DC.b 0	; o_flags	
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; 1=Bitmap (scaled)
          DC.b 4	; o_depth	; 65536 colours / 16Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 0	; o_index
          DC.w 0	; o_desc

ttpmodif	DC.w 20
ttpyscale	DC.b $20	; 100
ttpxscale	DC.b $20	; in both directions

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

;*****************************************************************************
; The 5. object in this program: 
; The Jaguar with 2 Teamtaps and 8 Joypads
;
ttbx	DC.w 64+174 ; o_xpos, align this to the right edge of the 3. object
ttby	DC.w 78	; o_ypos
ttbadr	DC.l wTTSketch	; o_data
          DC.w 99	; 100. line wasn't converted	; o_height
          DC.w (144/2)/8	; o_dwidth 144 4bit pixels phrase aligned
          DC.w (144/2)/8	; o_iwidth 144 4bit pixels phrase aligned
          DC.b 4	; o_flags	; transparency
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; Bitmap (non-scaled)
          DC.b 2	; o_depth	; 16 colours / 4Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 16	; o_index	; DWORD-index into clut (CLUTTeamTap)
          DC.w 0	; o_desc

ttbmodif	DC.w 20
ttbyscale	DC.b $20
ttbxscale	DC.b $20

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

;*****************************************************************************
; The 6. object in this program: 
; The highlighted Jaguar-Teamtap-Joypad-connection
;
ttbmx	DC.w 64+174 ; o_xpos, align this to the right edge of the text screen
ttbmy	DC.w 78	; o_ypos
ttbmadr	DC.l wTTMarked1A	; o_data
          DC.w 99	;100. wasn't converted	; o_height
          DC.w (144/2)/8	; o_dwidth 144 4bit pixels phrase aligned
          DC.w (144/2)/8	; o_iwidth 144 4bit pixels phrase aligned
          DC.b 4	; o_flags	; transparency
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; Bitmap (non-scaled)
          DC.b 2	; o_depth	; 16 colours / 4Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 24	; o_index	; DWORD-index into clut (CLUTmarkedTeamTap)
          DC.w 0	; o_desc

ttbmmodif	DC.w 20
ttbmyscale	DC.b $20
ttbmxscale	DC.b $20

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

;*************************************************
; The 7. object: the text screen:
; A 320*240 4bit per pixel bitmap
;
startx		DC.w 64 ; o_xpos
starty		DC.w 78-20*2	; o_ypos
startadr	DC.l score_bmp ; o_data
          DC.w 240	; o_height
          DC.w (320/2)/8	; o_dwidth 
          DC.w (320/2)/8	; o_iwidth
          DC.b 4	; o_flags	transparent
          DC.b 0	; o_firstpix
          DC.b 0	; o_type	; Bitmap (non-scaled)
          DC.b 2	; o_depth	; 16 colours / 4Bit per Pixel
          DC.b 1	; o_pitch
          DC.b 0	; o_index
          DC.w 0	; o_desc

startmodif	DC.w 20
startyscale	DC.b $20
startxscale	DC.b $20

          DC.l 0   ; o_rom
          DC.l 0   ; o_mode

;---------------------------------------------------------------------
          dphrase

s_level2: DS.l 1
s_vi:     DS.l 1
s_int1:   DS.l 1
s_sr:     DS.w 1

exit:	DS.w 1

status:	DS.b 1


	dphrase
score_bmp:	; here resides the text screen

         END