;***************** Jagvideo.s ***********************
to60hz:
	lea	clock_tab2,a0
	bra	SetVideoregs
to50hz:
	lea	clock_tab1,a0
SetVideoregs:
	move.w	(a0)+,$f10012.l	;
	move.w	(a0)+,$f0002e.l	; HP
	move.w	(a0)+,$f00030.l	; HBB
	move.w	(a0)+,$f00032.l	; HBE
	move.w	(a0)+,$f00034.l	; HS
	move.w	(a0)+,$f00036.l	; HVS
	move.w	(a0)+,$f00054.l	; HEQ
	move.w	(a0)+,$f0003c.l	; HDE
	move.w	(a0)+,$f00038.l	; HDB1
	move.w	(a0)+,$f0003a.l	; HDB2
	move.w	(a0)+,$f0003e.l	; VP
	move.w	(a0)+,$f0004c.l	; VEE
	move.w	(a0)+,$f00042.l	; VBE
	move.w	(a0)+,$f00046.l	; VDB
	move.w	(a0)+,$f00048.l	; VDE
	move.w	(a0)+,$f00040.l	; VBB
	move.w	(a0)+,$f0004a.l	; VEB
	move.w	(a0)+,$f00044.l	; VS
	rts
;************************************************
set_palette:        
;A0 must be the address of the palette data
;palette data is 256 words of colors
          lea.l     CLUT,a1             ;get address of color lookup table
          move.w    #255,d0             ;number of colors to set
.10:      move.w    (a0)+,(a1)+         ;put color value into color lookup table
          dbra      d0,.10              ;continue through palette table
          rts       
;-------------------------------------------------------------------------------
wait_int: 
          move.b    framecnt,d0
.10:      cmp.b     intcount,d0
          bgt.s     .10
          clr.b     intcount
          rts       


intcount: DC.b 0
framecnt: DC.b 1   ;50 frames per second


LEVEL2    equ 4*$40

IRQS_HANDLED equ $101	;	; $101 = VBLANK, $909 = VBLANK und TIMER

IntInit:  
          move.l    LEVEL2,s_level2
          move.l    VI,s_vi
          move.l    INT1,s_int1
          move.w    sr,s_sr

          move.l    #Frame,LEVEL2	; Adresse die bei jedem IRQ angesprungen werden soll
          ;move.w    #n_vde+1,VI	; 18.04.98 for NTSC-support
	move.w	n_vde_value,VI

          ;move.w    #1,INT1
	move.w	#IRQS_HANDLED&$ff,INT1	; enable VBLANK + TIMER
	;move.w	#$0000,PIT+2		; Zuerst das Hi_Word und
	;move.w	#$0200,PIT		; dann das Lo_Word !!!!
	move.w	#32,INT		; for I2S-Interrupt of the DSP
          move.w    sr,d0
          andi.w    #$f8ff,d0
          move.w    d0,sr
          rts       
Frame:    
          movem.l   d0-d6/a0-a6,-(sp)
	move.w	INT1,d0
	btst	#0,d0
	beq.s	no_blank
blank:
          jsr       copy_olist
          addi.b    #1,intcount

no_blank:       
          move.w    #IRQS_HANDLED,INT1
          move.w    #0,INT2
          movem.l   (sp)+,d0-d6/a0-a6
          rte       
