;********************************************************************
;***           TTTest.s                                          ****
;********************************************************************

;********************************************************************
TestForTeamTap:
	; test for TeamTap on Joyport 1
        move.w	#$81fa,JOYSTICK	; read from Port 3 (D), Row 1
        move.w	JOYBUTS,d0	; Read B button, C1
	btst	#0,d0	; test only button0 (C1)
	bne.s	C1notset	; reverse logic !
C1set:
	; TeamTap connected
	or.b	#$01,ttconnected
	move.l	#wABC,text_font
	move.b	#11,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTfound,text_adr
	bsr	do_text2
	bra.s	C1goon
C1notset:
	; TeamTap not connected
	move.l 	#wTTMarked1A,ttbmadr	; no artwork available, so show as Port 1A -Joypad
	and.b	#$fe,ttconnected
	move.l	#wABC,text_font
	move.b	#11,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTnotfound,text_adr
	bsr	do_text2
	;bra.s	C1goon

C1goon:
	; test for TeamTap on Joyport 2
        move.w	#$815f,JOYSTICK	; read from Port 3 (D), Row 1
        move.w	JOYBUTS,d0	; Read B button, C1
	btst	#2,d0	; test only button2 (C1)
	bne.s	C1notset2	; reverse logic !
C1set2:
	; TeamTap connected
	or.b	#$02,ttconnected
	move.l	#wABC,text_font
	move.b	#13,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTfound,text_adr
	bsr	do_text2
	bra.s	C1goon2
C1notset2:
	; TeamTap not connected
	move.l 	#wTTMarked1A,ttbmadr	; no artwork available, so show as Port 1A -Joypad
	and.b	#$fd,ttconnected
	move.l	#wABC,text_font
	move.b	#13,zeil
	move.b	#22,spal	; > 176 pixel
	move.l	#TTnotfound,text_adr
	bsr	do_text2
	;bra.s	C1goon2

C1goon2:
	rts

;*****************************************************************
ShowTTPort:
	movem.l	d0-d1,-(sp)

	;***move.b	ttconnected,d0
	;***bne.s	tt1isconnected	
	;***move.w	#0,tth		; hide TeamTap-image
	;***move.w	#0,ttph		; hide TeamTap-Port-image
	;***jmp	test_ttport_end

tt1isconnected:
	;***move.w	#78,tth		; show TeamTap-image
	;move.w	#8,ttph		; is always set later

	move.b	#$ff,ttport	; no port
	
testPort1A:
	cmp.l	#0,joyedge1A
	beq.s	testPort1B
	move.b	#0,ttport
	move.b	#0,ttport_old
	jmp	testPort1End

testPort1B:
	cmp.l	#0,joyedge1B
	beq.s	testPort1C
	move.b	#1,ttport
	move.b	#1,ttport_old
	jmp	testPort1End

testPort1C:
	cmp.l	#0,joyedge1C
	beq.s	testPort1D
	move.b	#2,ttport
	move.b	#2,ttport_old
	jmp	testPort1End

testPort1D:
	cmp.l	#0,joyedge1D
	beq.s	testPort1End
	move.b	#3,ttport
	move.b	#3,ttport_old
	;jmp	testPort1End

testPort1End:

testPort2A:
	cmp.l	#0,joyedge2A
	beq.s	testPort2B
	move.b	#4,ttport
	move.b	#4,ttport_old
	jmp	testPort2End

testPort2B:
	cmp.l	#0,joyedge2B
	beq.s	testPort2C
	move.b	#5,ttport
	move.b	#5,ttport_old
	jmp	testPort2End

testPort2C:
	cmp.l	#0,joyedge2C
	beq.s	testPort2D
	move.b	#6,ttport
	move.b	#6,ttport_old
	jmp	testPort2End

testPort2D:
	cmp.l	#0,joyedge2D
	beq.s	testPort2End
	move.b	#7,ttport
	move.b	#7,ttport_old
	;jmp	testPort2End

testPort2End:

	move.b	ttport_old,d0	; Show this port

test_ttport1A:
	cmp.b	#0,d0
        bne.s   test_ttport1B

	move.l 	#wTTMarked1A,ttbmadr
	move.l 	#wTTPortA,ttpadr
	move.w	#64+15,ttpx
	move.w	#28+2*66,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1B:
	cmp.b	#1,d0
        bne.s   test_ttport1C

	move.l 	#wTTMarked1B,ttbmadr
	move.l 	#wTTPortB,ttpadr
	move.w	#64+52,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1C:
	cmp.b	#2,d0
        bne.s   test_ttport1D

	move.l 	#wTTMarked1C,ttbmadr
	move.l 	#wTTPortC,ttpadr
	move.w	#64+93,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1D:
	cmp.b	#3,d0
        bne.s   test_ttport1_end

	move.l 	#wTTMarked1D,ttbmadr
	move.l 	#wTTPortD,ttpadr
	move.w	#64+134,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport1_end:
test_ttport2A:
	cmp.b	#4,d0
        bne.s   test_ttport2B

	move.l 	#wTTMarked2A,ttbmadr
	move.l 	#wTTPortA,ttpadr
	move.w	#64+15,ttpx
	move.w	#28+2*66,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2B:
	cmp.b	#5,d0
        bne.s   test_ttport2C

	move.l 	#wTTMarked2B,ttbmadr
	move.l 	#wTTPortB,ttpadr
	move.w	#64+52,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2C:
	cmp.b	#6,d0
        bne.s   test_ttport2D

	move.l 	#wTTMarked2C,ttbmadr
	move.l 	#wTTPortC,ttpadr
	move.w	#64+93,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2D:
	cmp.b	#7,d0
        bne.s   test_ttport2_end

	move.l 	#wTTMarked2D,ttbmadr
	move.l 	#wTTPortD,ttpadr
	move.w	#64+134,ttpx
	move.w	#28+2*67,ttpy	; (#78+)
	move.w	#8,ttph
	move.w	#(20*2/8),ttpdw
	move.w	#(20*2/8),ttpiw

test_ttport2_end:
test_ttport_end:

	movem.l	(sp)+,d0-d1
	rts
;*****************************************************************
; 
joystick:
	movem.l	d0-d1/a0,-(sp)

	; hide objects
    move.w  #0,d0
    move.w  d0,KEY_Uh
    move.w  d0,KEY_Dh
    move.w  d0,KEY_Lh
    move.w  d0,KEY_Rh
    move.w  d0,KEY_Oh
    move.w  d0,KEY_Ph
	move.w	d0,KEY_Ah
    move.w  d0,KEY_Bh
    move.w  d0,KEY_Ch
    move.w  d0,KEY_1h
    move.w  d0,KEY_2h
    move.w  d0,KEY_3h
    move.w  d0,KEY_4h
    move.w  d0,KEY_5h
    move.w  d0,KEY_6h
    move.w  d0,KEY_7h
    move.w  d0,KEY_8h
    move.w  d0,KEY_9h
    move.w  d0,KEY_ASTERISKh
    move.w  d0,KEY_0h
    move.w  d0,KEY_NUMBERh

	;move.l	joycur,d0

	move.b	ttport_old,d0
	;cmp.b	#$ff,d0
	;bne.s	joy_goon
	;jmp	test_end	;!!!!!!!!!!!!!!!!!!!!!!!

joy_goon:

	moveq.l	#0,d0
	move.b	ttport_old,d0
	asl.b	#2,d0
	lea	joycur,a0
	move.l	(a0,d0),d0

test_keyU:
    btst    #KEY_U,d0
    beq.s   test_keyD
    move.w  #6,KEY_Uh
test_keyD:
	btst    #KEY_D,d0
	beq.s   test_keyL
    move.w  #6,KEY_Dh
test_keyL:	
	btst    #KEY_L,d0
	beq.s   test_keyR
    move.w  #6,KEY_Lh
test_keyR:	
	btst    #KEY_R,d0
	beq.s   test_keyP
    move.w  #6,KEY_Rh

;********************************************************
test_keyP:	
	btst    #KEY_P,d0
	beq.s   test_keyO
    move.w  #16,KEY_Ph

test_keyO:	
	btst    #KEY_O,d0
	beq.s   test_keyA
    move.w  #16,KEY_Oh


test_keyA:	
	btst    #FIRE_A,d0
	beq.s   test_keyB
    move.w  #20,KEY_Ah

test_keyB:	
	btst    #FIRE_B,d0
	beq.s   test_keyC
    move.w  #20,KEY_Bh

test_keyC:
	btst    #FIRE_C,d0
	beq.s   test_key1
    move.w  #20,KEY_Ch

;**************************************************************
test_key1:
	btst    #KEY_1,d0
	beq.s   test_key2
    move.w  #6,KEY_1h

test_key2:
	btst    #KEY_2,d0
	beq.s   test_key3
    move.w  #6,KEY_2h

test_key3:
	btst    #KEY_3,d0
	beq.s   test_key4
    move.w  #6,KEY_3h

;**************************************************************
test_key4:
	btst    #KEY_4,d0
	beq.s   test_key5
    move.w  #6,KEY_4h

test_key5:
	btst    #KEY_5,d0
	beq.s   test_key6
    move.w  #6,KEY_5h

test_key6:
	btst    #KEY_6,d0
	beq.s   test_key7
    move.w  #6,KEY_6h

;**************************************************************
test_key7:
	btst    #KEY_7,d0
	beq.s   test_key8
    move.w  #6,KEY_7h

test_key8:
	btst    #KEY_8,d0
	beq.s   test_key9
    move.w  #6,KEY_8h

test_key9:
	btst    #KEY_9,d0
	beq.s   test_keyAsterisk
    move.w  #6,KEY_9h

;**************************************************************
test_keyAsterisk:
	btst    #KEY_ASTERISK,d0
	beq.s   test_key0
    move.w  #6,KEY_ASTERISKh

test_key0:
	btst    #KEY_0,d0
	beq.s   test_keyNumber
    move.w  #6,KEY_0h

test_keyNumber:
	btst    #KEY_NUMBER,d0
	beq.s   test_keyEnd
    move.w  #6,KEY_NUMBERh

test_keyEnd:

test_reset:
	btst    #KEY_NUMBER,d0
        beq.s   test_end
        btst    #KEY_ASTERISK,d0
        beq.s   test_end
        move.w  #1,exit
	move.b	#0,status

test_end:
	movem.l	(sp)+,d0-d1/a0
	rts


;*************************************************************
ShowControllerTypes:

;********
; PORT 1:
;********
    move.b  #'1',tabrow1A+0
    move.b  #'1',tabrow1A+2
    move.b  #'1',tabrow1A+4

    move.l  joycur1A,d0
.test_1AC1:
    btst    #KEY_C1,d0
    beq.s   .test_1AC2
    move.b  #'0',tabrow1A+0
.test_1AC2:
    btst    #KEY_C2,d0
    beq.s   .test_1AC3
    move.b  #'0',tabrow1A+2
.test_1AC3:  
    btst    #KEY_C3,d0
    beq.s   .test_1Aend
    move.b  #'0',tabrow1A+4
.test_1Aend:


    move.b  #'1',tabrow1B+0
    move.b  #'1',tabrow1B+2
    move.b  #'1',tabrow1B+4

    move.l  joycur1B,d0
.test_1BC1:
    btst    #KEY_C1,d0
    beq.s   .test_1BC2
    move.b  #'0',tabrow1B+0
.test_1BC2:
    btst    #KEY_C2,d0
    beq.s   .test_1BC3
    move.b  #'0',tabrow1B+2
.test_1BC3:  
    btst    #KEY_C3,d0
    beq.s   .test_1Bend
    move.b  #'0',tabrow1B+4
.test_1Bend:


    move.b  #'1',tabrow1C+0
    move.b  #'1',tabrow1C+2
    move.b  #'1',tabrow1C+4

    move.l  joycur1C,d0
.test_1CC1:
    btst    #KEY_C1,d0
    beq.s   .test_1CC2
    move.b  #'0',tabrow1C+0
.test_1CC2:
    btst    #KEY_C2,d0
    beq.s   .test_1CC3
    move.b  #'0',tabrow1C+2
.test_1CC3:  
    btst    #KEY_C3,d0
    beq.s   .test_1Cend
    move.b  #'0',tabrow1C+4
.test_1Cend:


    move.b  #'1',tabrow1D+0
    move.b  #'1',tabrow1D+2
    move.b  #'1',tabrow1D+4

    move.l  joycur1D,d0
.test_1DC1:
    btst    #KEY_C1,d0
    beq.s   .test_1DC2
    move.b  #'0',tabrow1D+0
.test_1DC2:
    btst    #KEY_C2,d0
    beq.s   .test_1DC3
    move.b  #'0',tabrow1D+2
.test_1DC3:  
    btst    #KEY_C3,d0
    beq.s   .test_1Dend
    move.b  #'0',tabrow1D+4
.test_1Dend:

;********
; PORT 2:
;********
    move.b  #'1',tabrow2A+0
    move.b  #'1',tabrow2A+2
    move.b  #'1',tabrow2A+4

    move.l  joycur2A,d0
.test_2AC1:
    btst    #KEY_C1,d0
    beq.s   .test_2AC2
    move.b  #'0',tabrow2A+0
.test_2AC2:
    btst    #KEY_C2,d0
    beq.s   .test_2AC3
    move.b  #'0',tabrow2A+2
.test_2AC3:  
    btst    #KEY_C3,d0
    beq.s   .test_2Aend
    move.b  #'0',tabrow2A+4
.test_2Aend:


    move.b  #'1',tabrow2B+0
    move.b  #'1',tabrow2B+2
    move.b  #'1',tabrow2B+4

    move.l  joycur2B,d0
.test_2BC1:
    btst    #KEY_C1,d0
    beq.s   .test_2BC2
    move.b  #'0',tabrow2B+0
.test_2BC2:
    btst    #KEY_C2,d0
    beq.s   .test_2BC3
    move.b  #'0',tabrow2B+2
.test_2BC3:  
    btst    #KEY_C3,d0
    beq.s   .test_2Bend
    move.b  #'0',tabrow2B+4
.test_2Bend:


    move.b  #'1',tabrow2C+0
    move.b  #'1',tabrow2C+2
    move.b  #'1',tabrow2C+4

    move.l  joycur2C,d0
.test_2CC1:
    btst    #KEY_C1,d0
    beq.s   .test_2CC2
    move.b  #'0',tabrow2C+0
.test_2CC2:
    btst    #KEY_C2,d0
    beq.s   .test_2CC3
    move.b  #'0',tabrow2C+2
.test_2CC3:  
    btst    #KEY_C3,d0
    beq.s   .test_2Cend
    move.b  #'0',tabrow2C+4
.test_2Cend:


    move.b  #'1',tabrow2D+0
    move.b  #'1',tabrow2D+2
    move.b  #'1',tabrow2D+4

    move.l  joycur2D,d0
.test_2DC1:
    btst    #KEY_C1,d0
    beq.s   .test_2DC2
    move.b  #'0',tabrow2D+0
.test_2DC2:
    btst    #KEY_C2,d0
    beq.s   .test_2DC3
    move.b  #'0',tabrow2D+2
.test_2DC3:  
    btst    #KEY_C3,d0
    beq.s   .test_2Dend
    move.b  #'0',tabrow2D+4
.test_2Dend:


    rts