
/*
	BJL-uploader for Linux
	Copyright (c) 1997, Joe Britt
	
	Freely distributable and modifiable.
	I only ask that if you use this as the basis of some other work,
	you give me credit for this original version.  Thanks.

	Special thanks to 42Bastian, for being extremely helpful in debugging
	the communication with the BJL-ROM in the Jag.  He's the man!

  JOE       Joe Britt <britt@spies.com>
  42BS      42Bastian Schick <elw5basc(at)gp.fht-esslingen.de>
  JBS       John Sohn
  
	Change History:

		30 Oct 97	JOE			First version.
    31 Oct 97 42BS    added DJGPP support, but don't know if it works...
     1 Dec 97 JBS			added Win95 console support and enhanced DGJPP functionality
    12 Dec 97 42BS    bug in the JagServer section: type 3-header has 18 bytes     
*/

#include <stdio.h>

#ifndef _WIN32
	#include <unistd.h>
	#include <sys/time.h>
#endif

#ifdef DJGPP
#  include <pc.h>
#  define outb(data,port) outp((port),(data))
#  define inb(port)       inp(port)
#  define ioperm(a,b,c)   (0)
#elif _WIN32
#  include <windows.h>
#  include <conio.h>
#  define outb(data,port) _outp((port),(data))
#  define inb(port)       _inp(port)
#  define ioperm(a,b,c)   (0)
#  define sleep           Sleep
#else
#  include <asm/io.h>
#endif


typedef unsigned char uchar;
typedef unsigned char Boolean;
typedef unsigned long ulong;    // 42BS
typedef unsigned short ushort;  // 42BS

#define true                1
#define false               0

#define kLPT1Base           0x378
#define kLPT2Base           0x278

/*
from http://www.paranoia.com/~filipg/HTML/LINK/PORTS/F_PARALLEL5.html#PARALLEL_008

STATUS
        7 6 5 4 3 2 1 0
        * . . . . . . .  Busy . . (pin 11), high=0, low=1 (inverted)
        . * . . . . . .  Ack  . . (pin 10), high=1, low=0 (true)
        . . * . . . . .  No paper (pin 12), high=1, low=0 (true)
        . . . * . . . .  Selected (pin 13), high=1, low=0 (true)
        . . . . * . . .  Error. . (pin 15), high=1, low=0 (true)
        . . . . . * * *  Undefined

CONTROL
        7 6 5 4 3 2 1 0
        * * . . . . . .  Unused (undefined on read, ignored on write)
        . . * . . . . .  Bidirectional control, see below
        . . . * . . . .  Interrupt control, 1=enable, 0=disable
        . . . . * . . .  Select . . (pin 17), 1=low, 0=high (inverted)
        . . . . . * . .  Initialize (pin 16), 1=high, 0=low (true)
        . . . . . . * .  Auto Feed  (pin 14), 1=low, 0=high (inverted)
        . . . . . . . *  Strobe . . (pin 1),  1=low, 0=high (inverted)
*/

#define	kDataReg			0
#define	kStatusReg			1		/* BUSY is bit 7 */
#define	kControlReg			2		/* STB is bit 0 */

void SendLong( ulong w );
void SendByte( uchar c );
ulong relocate(uchar * pdata, ulong * len, ulong *addr,ulong skip);


void SendFile( char *fn, ulong addr, ulong skip );

ulong ReverseEndian(ulong d);
ulong ReverseEndian(ulong d)
{
    return  ((d << 24) |
            ((d & 0x0000ff00) << 8) |
            ((d & 0x00ff0000) >> 8) |
            (d >> 24));
}

#define BE_TO_LE(_x)    ReverseEndian(_x)
#define LE_TO_BE(_x)    ReverseEndian(_x)

/*
// 42BS {
#define BE_TO_LE(_x)\
            ((ulong)(\
            (((_x) << 24) |\
            (((_x) & 0x0000ff00) << 8) |\
            (((_x) & 0x00ff0000) >> 8) |\
            ((_x) >> 24))))
            
#define LE_TO_BE(_x)    BE_TO_LE(_x)
*/

#define BE_TO_LEW(_x)    ( (ushort)( ((_x)>>8)|((_x)<<8) ) )
#define LE_TO_BEW(_x)    BE_TO_LEW(_x)
// }

Boolean ParseCmds( ulong argc, char *argv[] );
void ArgValue( char *s, ulong *value );


ulong gBase = kLPT2Base;			/* default to LPT2 */

ulong gBaseAddr = 0x4000;			/* default base */
ulong gHeaderSkip = 0;				/* default header size */ /* was 28,changed 42BS */

char *gImageName = "Joe Britt";


main( int argc,char *argv[] )
{
	if ( !ParseCmds( argc, argv ) )
	{
		printf("usage: loader [-s skipbytes] [-b baseaddr] [-p lptbase] -f <filename>\n");
		printf("       skipbytes is # bytes in header to skip.   default = %ld\n", gHeaderSkip); 
		printf("       baseaddr is addr to upload to.            default = 0x%08lx\n", gBaseAddr);
		printf("       lptbase specifies base addr of LPT port.  default = 0x%lx\n", gBase); 

		return -1;
	}

    if ( ioperm(gBase, 3, true) == 0 )
    {
		outb( 0x20, gBase+kControlReg );		/* input, /STB is high */

		SendFile( gImageName, gBaseAddr, gHeaderSkip );

		ioperm(gBase, 3, false);
	}
    else
        printf("### ioperm() FAILED!\n\n");
}


void ArgValue( char *s, ulong *value )
{
    if ( isdigit(s[0]) ) 
	{
        if ( s[1] == 'x' )
            sscanf( s, "%x", value );
        else
            sscanf( s, "%d", value );
    }
	else
		*value = 0;
}


Boolean ParseCmds( unsigned long argc, char *argv[] )
{
    char *s;
    ulong cnt;

    if ( argc != 1 ) 
	{
        for ( cnt = 1; cnt < argc; cnt++ ) 
		{
            s = argv[cnt];
            switch ( s[1] ) 
			{
              case 's':	cnt++;
                        	ArgValue( argv[cnt], &gHeaderSkip );
                        	break;

            	case 'b':	cnt++;
                        	ArgValue( argv[cnt], &gBaseAddr );
                        	break;

            	case 'p':	cnt++;
                        	ArgValue( argv[cnt], &gBase );
                        	break;

            	case 'f':	cnt++;
							gImageName = argv[cnt];
							break;	
            }
        }
	
		return true;
    }
	else
		return false;
}



void SendFile( char *fn, ulong addr, ulong skip )
{
	FILE *fp;
	ulong len;
	uchar *buf;
	long *copy;
	long cksum = 0;
	long data;

	if ( fp = fopen( fn, "rb" ) )
	{
		fseek(fp, 0, SEEK_END);
		len = ftell(fp);

		printf("%s is %ld bytes long\n", fn, len);

// 42BS
//		fseek( fp, skip, SEEK_SET );
//		len -= skip;
//
//		len = ((len + 3) & ~3);			/* round up */
//		printf("len = %ld\n", len);

    fseek( fp, 0, SEEK_SET );   /* 42BS */

		buf = (uchar*)malloc( len );

		if ( buf )
		{
		  uchar * save_buf = buf;   /* 42BS */
		  
			fread( buf, sizeof(char), len, fp ); 			

      skip = relocate( buf, &len , &addr, skip);    /* 42BS added this */

      buf += skip;                // skip some byte

      len -= skip;                                  /* 42BS */

		  len = ((len + 3) & ~3);			/* round up */

			SendLong( 0x22071970 );		  /* send magic number */
			SendLong( addr );			      /* send starting addr */
			SendLong( len+4 );		    	/* send length */

			len >>= 2;					        /* bytes -> words */ /* lets say :32-bit words :-) */
			copy = (ulong*)buf;

			while ( len-- )
			{
				data = BE_TO_LE(*copy++);	
				cksum += data;
				SendLong( data );
			} 
	
			printf("cksum = %08lx\n", cksum);
			SendLong( -cksum );	/* send checksum */

			free( save_buf );     /* 42BS */
		}
		else
			printf("SendFile: couldn't alloc buf!\n");

		fclose( fp );
	}
	else
		printf("Couldn't open file %s!\n", fn);
}

/* This expects a little-endian long. */
/* It big-endian-ifies it on the way out. */

void SendLong( ulong w )
{
	SendByte( (uchar)w );
	SendByte( (uchar)(w >> 8) );
	SendByte( (uchar)(w >> 16) );
	SendByte( (uchar)(w >> 24) );
}


/*
From LOADER.DOC:

1) Wait for BUSY to be low => inactive
2) Send LSB
3) Set /STROBE to low => active
4) Wait for BUSY high => active
5) Set /STROBE to high
6) continue for the next three bytes
*/

void SendByte( uchar c )
{
  sleep(0);
	while( !(inb( gBase+kStatusReg ) & 0x80) ) 	/* wait for BUSY = 0 */
		;
  sleep(0);

	outb( c, gBase+kDataReg );					/* drive data */
	outb( 0x01, gBase+kControlReg );			/* output, /STB = 0 */
	outb( c, gBase+kDataReg );					/* drive data */
	outb( c, gBase+kDataReg );					/* drive data */

	while( (inb( gBase+kStatusReg ) & 0x80) ) 	/* wait for BUSY = 1 */
		;

	outb( 0x20, gBase+kControlReg );			/* input, /STB is high */
}

/**********************/
/* GEMDOS - relocator */
/**********************/
/* this function sees if it finds a GEMDOS or JServer - header
   if so, skip,addr and len are adjusted
*/

ulong relocate( uchar * pdata, ulong *len , ulong *addr, ulong skip)
{
  if ( *((ushort *)pdata) != BE_TO_LEW(0x601a) )  // GEMDOS - header
  {
    printf("No Gemdos-header !\n");
    return (skip);                    /* skip user-defined bytes */
  }

  if ( *((ulong *)(pdata+28)) == BE_TO_LE(0x4a414752) ) /* JAGR */
  {
    ushort type = BE_TO_LEW(*((ushort *)(pdata+32)));
    ulong new_len;
    
    if ( type != 2 && type != 3 )
    {
      printf("Unsupported JServer-Header !\nLeaving ...\n");
      exit(-1);
    }
    
    *addr = BE_TO_LE( *(ulong *)(pdata+34) );  // dest and start address
    
    if ( (new_len = BE_TO_LE( *(ulong *)(pdata+38) ) ))
      *len = new_len;

    if ( type == 2)
      return ( 28 + 14 );      // skip GEMDOS and JServer-header
    else
      return ( 28 + 18 );
  }
//
// BJL - program
//
  {
    ulong textlen,datalen,symblen;   /* header info */
    ulong offset;
    ulong addr2 = *addr;
    uchar * reloptr, * pdata2;

    textlen = BE_TO_LE(*(ulong *)(pdata+2));
    datalen = BE_TO_LE(*(ulong *)(pdata+6));
//  bss_len = BE_TO_LE(*(ulong *)(pdata+10));   no need for this, yet
    symblen = BE_TO_LE(*(ulong *)(pdata+14));

    reloptr = pdata + textlen + datalen + symblen + 28;

    offset = *(ulong *)reloptr;   // first long to relocate
    
    reloptr += 4;                 // from now only bytes as offset
    
    pdata2 = pdata + offset;      // ptr to it

    while ( offset )              // until offset == 0
    {
      // compute new address , things are so simple on BE-machine ;-)
      
      *(ulong *)pdata2 = LE_TO_BE(BE_TO_LE( *(ulong *)pdata2 ) + addr2);
      
      // as long as offset is 1 skip 254 byte
      do
      {
        offset = (ulong) *reloptr;
        ++reloptr;
        if (! --offset)
          pdata2 += 254;
      }while ( !offset );
      pdata2 += offset+1;           // next address
    }

    *len = textlen + datalen;     // send only text and data , no symbols ...
    return ( 28 );                // skip GEMDOS header
  }
}

