//
// Jaguar Wavetable ROM
//
// In a real Jaguar, these are 16-bit values that are sign-extended to 32 bits.
// Each entry has 128 values (e.g., SINE goes from F1D200-F1D3FF)
//

// NOTE: This can probably be converted to 32-bit table, since I don't think
//       that unaligned access is allowed...

const unsigned char wave_table[4096] =
{
    0xFF, 0xFF, 0xC2, 0x01, 0xFF, 0xFF, 0xC4, 0x01, 0xFF, 0xFF, 0xC6, 0x01, 0xFF, 0xFF, 0xC8, 0x01, 
    0xFF, 0xFF, 0xCA, 0x01, 0xFF, 0xFF, 0xCC, 0x01, 0xFF, 0xFF, 0xCE, 0x01, 0xFF, 0xFF, 0xD0, 0x01, 
    0xFF, 0xFF, 0xD2, 0x01, 0xFF, 0xFF, 0xD4, 0x01, 0xFF, 0xFF, 0xD6, 0x01, 0xFF, 0xFF, 0xD8, 0x01, 
    0xFF, 0xFF, 0xDA, 0x01, 0xFF, 0xFF, 0xDC, 0x01, 0xFF, 0xFF, 0xDE, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 
    0xFF, 0xFF, 0xE2, 0x01, 0xFF, 0xFF, 0xE4, 0x01, 0xFF, 0xFF, 0xE6, 0x01, 0xFF, 0xFF, 0xE8, 0x01, 
    0xFF, 0xFF, 0xEA, 0x01, 0xFF, 0xFF, 0xEC, 0x01, 0xFF, 0xFF, 0xEE, 0x01, 0xFF, 0xFF, 0xF0, 0x01, 
    0xFF, 0xFF, 0xF2, 0x01, 0xFF, 0xFF, 0xF4, 0x01, 0xFF, 0xFF, 0xF6, 0x01, 0xFF, 0xFF, 0xF8, 0x01, 
    0xFF, 0xFF, 0xFA, 0x01, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x05, 0xFF, 0x00, 0x00, 0x07, 0xFF, 
    0x00, 0x00, 0x09, 0xFF, 0x00, 0x00, 0x0B, 0xFF, 0x00, 0x00, 0x0D, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 
    0x00, 0x00, 0x11, 0xFF, 0x00, 0x00, 0x13, 0xFF, 0x00, 0x00, 0x15, 0xFF, 0x00, 0x00, 0x17, 0xFF, 
    0x00, 0x00, 0x19, 0xFF, 0x00, 0x00, 0x1B, 0xFF, 0x00, 0x00, 0x1D, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 
    0x00, 0x00, 0x21, 0xFF, 0x00, 0x00, 0x23, 0xFF, 0x00, 0x00, 0x25, 0xFF, 0x00, 0x00, 0x27, 0xFF, 
    0x00, 0x00, 0x29, 0xFF, 0x00, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0x2D, 0xFF, 0x00, 0x00, 0x2F, 0xFF, 
    0x00, 0x00, 0x31, 0xFF, 0x00, 0x00, 0x33, 0xFF, 0x00, 0x00, 0x35, 0xFF, 0x00, 0x00, 0x37, 0xFF, 
    0x00, 0x00, 0x39, 0xFF, 0x00, 0x00, 0x3B, 0xFF, 0x00, 0x00, 0x3D, 0xFF, 0x00, 0x00, 0x3F, 0xFF, 
    0x00, 0x00, 0x3D, 0xFF, 0x00, 0x00, 0x3B, 0xFF, 0x00, 0x00, 0x39, 0xFF, 0x00, 0x00, 0x37, 0xFF, 
    0x00, 0x00, 0x35, 0xFF, 0x00, 0x00, 0x33, 0xFF, 0x00, 0x00, 0x31, 0xFF, 0x00, 0x00, 0x2F, 0xFF, 
    0x00, 0x00, 0x2D, 0xFF, 0x00, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0x29, 0xFF, 0x00, 0x00, 0x27, 0xFF, 
    0x00, 0x00, 0x25, 0xFF, 0x00, 0x00, 0x23, 0xFF, 0x00, 0x00, 0x21, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 
    0x00, 0x00, 0x1D, 0xFF, 0x00, 0x00, 0x1B, 0xFF, 0x00, 0x00, 0x19, 0xFF, 0x00, 0x00, 0x17, 0xFF, 
    0x00, 0x00, 0x15, 0xFF, 0x00, 0x00, 0x13, 0xFF, 0x00, 0x00, 0x11, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 
    0x00, 0x00, 0x0D, 0xFF, 0x00, 0x00, 0x0B, 0xFF, 0x00, 0x00, 0x09, 0xFF, 0x00, 0x00, 0x07, 0xFF, 
    0x00, 0x00, 0x05, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFA, 0x01, 0xFF, 0xFF, 0xF8, 0x01, 
    0xFF, 0xFF, 0xF6, 0x01, 0xFF, 0xFF, 0xF4, 0x01, 0xFF, 0xFF, 0xF2, 0x01, 0xFF, 0xFF, 0xF0, 0x01, 
    0xFF, 0xFF, 0xEE, 0x01, 0xFF, 0xFF, 0xEC, 0x01, 0xFF, 0xFF, 0xEA, 0x01, 0xFF, 0xFF, 0xE8, 0x01, 
    0xFF, 0xFF, 0xE6, 0x01, 0xFF, 0xFF, 0xE4, 0x01, 0xFF, 0xFF, 0xE2, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 
    0xFF, 0xFF, 0xDE, 0x01, 0xFF, 0xFF, 0xDC, 0x01, 0xFF, 0xFF, 0xDA, 0x01, 0xFF, 0xFF, 0xD8, 0x01, 
    0xFF, 0xFF, 0xD6, 0x01, 0xFF, 0xFF, 0xD4, 0x01, 0xFF, 0xFF, 0xD2, 0x01, 0xFF, 0xFF, 0xD0, 0x01, 
    0xFF, 0xFF, 0xCE, 0x01, 0xFF, 0xFF, 0xCC, 0x01, 0xFF, 0xFF, 0xCA, 0x01, 0xFF, 0xFF, 0xC8, 0x01, 
    0xFF, 0xFF, 0xC6, 0x01, 0xFF, 0xFF, 0xC4, 0x01, 0xFF, 0xFF, 0xC2, 0x01, 0xFF, 0xFF, 0xC0, 0x01, 
    0x00, 0x00, 0x06, 0x47, 0x00, 0x00, 0x0C, 0x8B, 0x00, 0x00, 0x12, 0xC7, 0x00, 0x00, 0x18, 0xF8, 
    0x00, 0x00, 0x1F, 0x19, 0x00, 0x00, 0x25, 0x27, 0x00, 0x00, 0x2B, 0x1E, 0x00, 0x00, 0x30, 0xFB, 
    0x00, 0x00, 0x36, 0xB9, 0x00, 0x00, 0x3C, 0x56, 0x00, 0x00, 0x41, 0xCD, 0x00, 0x00, 0x47, 0x1C, 
    0x00, 0x00, 0x4C, 0x3F, 0x00, 0x00, 0x51, 0x33, 0x00, 0x00, 0x55, 0xF4, 0x00, 0x00, 0x5A, 0x81, 
    0x00, 0x00, 0x5E, 0xD6, 0x00, 0x00, 0x62, 0xF1, 0x00, 0x00, 0x66, 0xCE, 0x00, 0x00, 0x6A, 0x6C, 
    0x00, 0x00, 0x6D, 0xC9, 0x00, 0x00, 0x70, 0xE1, 0x00, 0x00, 0x73, 0xB5, 0x00, 0x00, 0x76, 0x40, 
    0x00, 0x00, 0x78, 0x83, 0x00, 0x00, 0x7A, 0x7C, 0x00, 0x00, 0x7C, 0x29, 0x00, 0x00, 0x7D, 0x89, 
    0x00, 0x00, 0x7E, 0x9C, 0x00, 0x00, 0x7F, 0x61, 0x00, 0x00, 0x7F, 0xD7, 0x00, 0x00, 0x7F, 0xFF, 
    0x00, 0x00, 0x7F, 0xD7, 0x00, 0x00, 0x7F, 0x61, 0x00, 0x00, 0x7E, 0x9C, 0x00, 0x00, 0x7D, 0x89, 
    0x00, 0x00, 0x7C, 0x29, 0x00, 0x00, 0x7A, 0x7C, 0x00, 0x00, 0x78, 0x83, 0x00, 0x00, 0x76, 0x40, 
    0x00, 0x00, 0x73, 0xB5, 0x00, 0x00, 0x70, 0xE1, 0x00, 0x00, 0x6D, 0xC9, 0x00, 0x00, 0x6A, 0x6C, 
    0x00, 0x00, 0x66, 0xCE, 0x00, 0x00, 0x62, 0xF1, 0x00, 0x00, 0x5E, 0xD6, 0x00, 0x00, 0x5A, 0x81, 
    0x00, 0x00, 0x55, 0xF4, 0x00, 0x00, 0x51, 0x33, 0x00, 0x00, 0x4C, 0x3F, 0x00, 0x00, 0x47, 0x1C, 
    0x00, 0x00, 0x41, 0xCD, 0x00, 0x00, 0x3C, 0x56, 0x00, 0x00, 0x36, 0xB9, 0x00, 0x00, 0x30, 0xFB, 
    0x00, 0x00, 0x2B, 0x1E, 0x00, 0x00, 0x25, 0x27, 0x00, 0x00, 0x1F, 0x19, 0x00, 0x00, 0x18, 0xF8, 
    0x00, 0x00, 0x12, 0xC7, 0x00, 0x00, 0x0C, 0x8B, 0x00, 0x00, 0x06, 0x47, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xFF, 0xF9, 0xB9, 0xFF, 0xFF, 0xF3, 0x75, 0xFF, 0xFF, 0xED, 0x39, 0xFF, 0xFF, 0xE7, 0x08, 
    0xFF, 0xFF, 0xE0, 0xE7, 0xFF, 0xFF, 0xDA, 0xD9, 0xFF, 0xFF, 0xD4, 0xE2, 0xFF, 0xFF, 0xCF, 0x05, 
    0xFF, 0xFF, 0xC9, 0x47, 0xFF, 0xFF, 0xC3, 0xAA, 0xFF, 0xFF, 0xBE, 0x33, 0xFF, 0xFF, 0xB8, 0xE4, 
    0xFF, 0xFF, 0xB3, 0xC1, 0xFF, 0xFF, 0xAE, 0xCD, 0xFF, 0xFF, 0xAA, 0x0C, 0xFF, 0xFF, 0xA5, 0x7F, 
    0xFF, 0xFF, 0xA1, 0x2A, 0xFF, 0xFF, 0x9D, 0x0F, 0xFF, 0xFF, 0x99, 0x32, 0xFF, 0xFF, 0x95, 0x94, 
    0xFF, 0xFF, 0x92, 0x37, 0xFF, 0xFF, 0x8F, 0x1F, 0xFF, 0xFF, 0x8C, 0x4B, 0xFF, 0xFF, 0x89, 0xC0, 
    0xFF, 0xFF, 0x87, 0x7D, 0xFF, 0xFF, 0x85, 0x84, 0xFF, 0xFF, 0x83, 0xD7, 0xFF, 0xFF, 0x82, 0x77, 
    0xFF, 0xFF, 0x81, 0x64, 0xFF, 0xFF, 0x80, 0x9F, 0xFF, 0xFF, 0x80, 0x29, 0xFF, 0xFF, 0x80, 0x01, 
    0xFF, 0xFF, 0x80, 0x29, 0xFF, 0xFF, 0x80, 0x9F, 0xFF, 0xFF, 0x81, 0x64, 0xFF, 0xFF, 0x82, 0x77, 
    0xFF, 0xFF, 0x83, 0xD7, 0xFF, 0xFF, 0x85, 0x84, 0xFF, 0xFF, 0x87, 0x7D, 0xFF, 0xFF, 0x89, 0xC0, 
    0xFF, 0xFF, 0x8C, 0x4B, 0xFF, 0xFF, 0x8F, 0x1F, 0xFF, 0xFF, 0x92, 0x37, 0xFF, 0xFF, 0x95, 0x94, 
    0xFF, 0xFF, 0x99, 0x32, 0xFF, 0xFF, 0x9D, 0x0F, 0xFF, 0xFF, 0xA1, 0x2A, 0xFF, 0xFF, 0xA5, 0x7F, 
    0xFF, 0xFF, 0xAA, 0x0C, 0xFF, 0xFF, 0xAE, 0xCD, 0xFF, 0xFF, 0xB3, 0xC1, 0xFF, 0xFF, 0xB8, 0xE4, 
    0xFF, 0xFF, 0xBE, 0x33, 0xFF, 0xFF, 0xC3, 0xAA, 0xFF, 0xFF, 0xC9, 0x47, 0xFF, 0xFF, 0xCF, 0x05, 
    0xFF, 0xFF, 0xD4, 0xE2, 0xFF, 0xFF, 0xDA, 0xD9, 0xFF, 0xFF, 0xE0, 0xE7, 0xFF, 0xFF, 0xE7, 0x08, 
    0xFF, 0xFF, 0xED, 0x39, 0xFF, 0xFF, 0xF3, 0x75, 0xFF, 0xFF, 0xF9, 0xB9, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0xFF, 
    0x00, 0x00, 0x01, 0x8E, 0x00, 0x00, 0x02, 0x3A, 0x00, 0x00, 0x03, 0x04, 0x00, 0x00, 0x03, 0xEB, 
    0x00, 0x00, 0x04, 0xEC, 0x00, 0x00, 0x06, 0x08, 0x00, 0x00, 0x07, 0x3D, 0x00, 0x00, 0x08, 0x88, 
    0x00, 0x00, 0x09, 0xE9, 0x00, 0x00, 0x0B, 0x5E, 0x00, 0x00, 0x0C, 0xE4, 0x00, 0x00, 0x0E, 0x7B, 
    0x00, 0x00, 0x10, 0x1F, 0x00, 0x00, 0x11, 0xCF, 0x00, 0x00, 0x13, 0x88, 0x00, 0x00, 0x15, 0x48, 
    0x00, 0x00, 0x17, 0x0E, 0x00, 0x00, 0x18, 0xD5, 0x00, 0x00, 0x1A, 0x9C, 0x00, 0x00, 0x1C, 0x61, 
    0x00, 0x00, 0x1E, 0x20, 0x00, 0x00, 0x1F, 0xD8, 0x00, 0x00, 0x21, 0x85, 0x00, 0x00, 0x23, 0x26, 
    0x00, 0x00, 0x24, 0xB7, 0x00, 0x00, 0x26, 0x36, 0x00, 0x00, 0x27, 0xA1, 0x00, 0x00, 0x28, 0xF5, 
    0x00, 0x00, 0x2A, 0x30, 0x00, 0x00, 0x2B, 0x4F, 0x00, 0x00, 0x2C, 0x50, 0x00, 0x00, 0x2D, 0x31, 
    0x00, 0x00, 0x2D, 0xF0, 0x00, 0x00, 0x2E, 0x8B, 0x00, 0x00, 0x2F, 0x00, 0x00, 0x00, 0x2F, 0x4D, 
    0x00, 0x00, 0x2F, 0x70, 0x00, 0x00, 0x2F, 0x69, 0x00, 0x00, 0x2F, 0x35, 0x00, 0x00, 0x2E, 0xD3, 
    0x00, 0x00, 0x2E, 0x43, 0x00, 0x00, 0x2D, 0x83, 0x00, 0x00, 0x2C, 0x93, 0x00, 0x00, 0x2B, 0x71, 
    0x00, 0x00, 0x2A, 0x1E, 0x00, 0x00, 0x28, 0x99, 0x00, 0x00, 0x26, 0xE2, 0x00, 0x00, 0x24, 0xFA, 
    0x00, 0x00, 0x22, 0xE0, 0x00, 0x00, 0x20, 0x94, 0x00, 0x00, 0x1E, 0x19, 0x00, 0x00, 0x1B, 0x6E, 
    0x00, 0x00, 0x18, 0x94, 0x00, 0x00, 0x15, 0x8C, 0x00, 0x00, 0x12, 0x59, 0x00, 0x00, 0x0E, 0xFB, 
    0x00, 0x00, 0x0B, 0x74, 0x00, 0x00, 0x07, 0xC7, 0x00, 0x00, 0x03, 0xF4, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xFF, 0xFB, 0xEB, 0xFF, 0xFF, 0xF7, 0xB9, 0xFF, 0xFF, 0xF3, 0x6B, 0xFF, 0xFF, 0xEF, 0x06, 
    0xFF, 0xFF, 0xEA, 0x8B, 0xFF, 0xFF, 0xE5, 0xFE, 0xFF, 0xFF, 0xE1, 0x63, 0xFF, 0xFF, 0xDC, 0xBC, 
    0xFF, 0xFF, 0xD8, 0x0D, 0xFF, 0xFF, 0xD3, 0x5A, 0xFF, 0xFF, 0xCE, 0xA6, 0xFF, 0xFF, 0xC9, 0xF5, 
    0xFF, 0xFF, 0xC5, 0x4B, 0xFF, 0xFF, 0xC0, 0xAB, 0xFF, 0xFF, 0xBC, 0x19, 0xFF, 0xFF, 0xB7, 0x99, 
    0xFF, 0xFF, 0xB3, 0x2F, 0xFF, 0xFF, 0xAE, 0xDF, 0xFF, 0xFF, 0xAA, 0xAC, 0xFF, 0xFF, 0xA6, 0x9B, 
    0xFF, 0xFF, 0xA2, 0xAF, 0xFF, 0xFF, 0x9E, 0xEC, 0xFF, 0xFF, 0x9B, 0x56, 0xFF, 0xFF, 0x97, 0xF0, 
    0xFF, 0xFF, 0x94, 0xBF, 0xFF, 0xFF, 0x91, 0xC4, 0xFF, 0xFF, 0x8F, 0x04, 0xFF, 0xFF, 0x8C, 0x82, 
    0xFF, 0xFF, 0x8A, 0x41, 0xFF, 0xFF, 0x88, 0x44, 0xFF, 0xFF, 0x86, 0x8D, 0xFF, 0xFF, 0x85, 0x20, 
    0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0x83, 0x2B, 0xFF, 0xFF, 0x82, 0xA8, 0xFF, 0xFF, 0x82, 0x77, 
    0xFF, 0xFF, 0x82, 0x9A, 0xFF, 0xFF, 0x83, 0x11, 0xFF, 0xFF, 0x83, 0xDF, 0xFF, 0xFF, 0x85, 0x05, 
    0xFF, 0xFF, 0x86, 0x82, 0xFF, 0xFF, 0x88, 0x59, 0xFF, 0xFF, 0x8A, 0x88, 0xFF, 0xFF, 0x8D, 0x10, 
    0xFF, 0xFF, 0x8F, 0xF1, 0xFF, 0xFF, 0x93, 0x2A, 0xFF, 0xFF, 0x96, 0xBB, 0xFF, 0xFF, 0x9A, 0xA2, 
    0xFF, 0xFF, 0x9E, 0xDF, 0xFF, 0xFF, 0xA3, 0x6F, 0xFF, 0xFF, 0xA8, 0x51, 0xFF, 0xFF, 0xAD, 0x83, 
    0xFF, 0xFF, 0xB3, 0x03, 0xFF, 0xFF, 0xB8, 0xCE, 0xFF, 0xFF, 0xBE, 0xE1, 0xFF, 0xFF, 0xC5, 0x39, 
    0xFF, 0xFF, 0xCB, 0xD3, 0xFF, 0xFF, 0xD2, 0xAC, 0xFF, 0xFF, 0xD9, 0xC0, 0xFF, 0xFF, 0xE1, 0x0A, 
    0xFF, 0xFF, 0xE8, 0x87, 0xFF, 0xFF, 0xF0, 0x32, 0xFF, 0xFF, 0xF8, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x09, 0x69, 0x00, 0x00, 0x12, 0xC2, 0x00, 0x00, 0x1B, 0xF7, 0x00, 0x00, 0x24, 0xF9, 
    0x00, 0x00, 0x2D, 0xB7, 0x00, 0x00, 0x36, 0x22, 0x00, 0x00, 0x3E, 0x29, 0x00, 0x00, 0x45, 0xBE, 
    0x00, 0x00, 0x4C, 0xD5, 0x00, 0x00, 0x53, 0x61, 0x00, 0x00, 0x59, 0x57, 0x00, 0x00, 0x5E, 0xAE, 
    0x00, 0x00, 0x63, 0x5D, 0x00, 0x00, 0x67, 0x5E, 0x00, 0x00, 0x6A, 0xAB, 0x00, 0x00, 0x6D, 0x40, 
    0x00, 0x00, 0x6F, 0x1B, 0x00, 0x00, 0x70, 0x3D, 0x00, 0x00, 0x70, 0xA5, 0x00, 0x00, 0x70, 0x56, 
    0x00, 0x00, 0x6F, 0x55, 0x00, 0x00, 0x6D, 0xA7, 0x00, 0x00, 0x6B, 0x53, 0x00, 0x00, 0x68, 0x61, 
    0x00, 0x00, 0x64, 0xDB, 0x00, 0x00, 0x60, 0xCC, 0x00, 0x00, 0x5C, 0x3F, 0x00, 0x00, 0x57, 0x42, 
    0x00, 0x00, 0x51, 0xE2, 0x00, 0x00, 0x4C, 0x2C, 0x00, 0x00, 0x46, 0x31, 0x00, 0x00, 0x3F, 0xFF, 
    0x00, 0x00, 0x39, 0xA5, 0x00, 0x00, 0x33, 0x34, 0x00, 0x00, 0x2C, 0xBA, 0x00, 0x00, 0x26, 0x47, 
    0x00, 0x00, 0x1F, 0xE9, 0x00, 0x00, 0x19, 0xAF, 0x00, 0x00, 0x13, 0xA8, 0x00, 0x00, 0x0D, 0xDF, 
    0x00, 0x00, 0x08, 0x61, 0x00, 0x00, 0x03, 0x3A, 0xFF, 0xFF, 0xFE, 0x74, 0xFF, 0xFF, 0xFA, 0x17, 
    0xFF, 0xFF, 0xF6, 0x2A, 0xFF, 0xFF, 0xF2, 0xB4, 0xFF, 0xFF, 0xEF, 0xBB, 0xFF, 0xFF, 0xED, 0x42, 
    0xFF, 0xFF, 0xEB, 0x4A, 0xFF, 0xFF, 0xE9, 0xD5, 0xFF, 0xFF, 0xE8, 0xE2, 0xFF, 0xFF, 0xE8, 0x6E, 
    0xFF, 0xFF, 0xE8, 0x76, 0xFF, 0xFF, 0xE8, 0xF5, 0xFF, 0xFF, 0xE9, 0xE5, 0xFF, 0xFF, 0xEB, 0x3D, 
    0xFF, 0xFF, 0xEC, 0xF6, 0xFF, 0xFF, 0xEF, 0x06, 0xFF, 0xFF, 0xF1, 0x62, 0xFF, 0xFF, 0xF3, 0xFF, 
    0xFF, 0xFF, 0xF6, 0xD1, 0xFF, 0xFF, 0xF9, 0xCA, 0xFF, 0xFF, 0xFC, 0xDF, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x03, 0x21, 0x00, 0x00, 0x06, 0x36, 0x00, 0x00, 0x09, 0x2F, 0x00, 0x00, 0x0C, 0x01, 
    0x00, 0x00, 0x0E, 0x9E, 0x00, 0x00, 0x10, 0xFA, 0x00, 0x00, 0x13, 0x0A, 0x00, 0x00, 0x14, 0xC3, 
    0x00, 0x00, 0x16, 0x1B, 0x00, 0x00, 0x17, 0x0B, 0x00, 0x00, 0x17, 0x8A, 0x00, 0x00, 0x17, 0x92, 
    0x00, 0x00, 0x17, 0x1E, 0x00, 0x00, 0x16, 0x2B, 0x00, 0x00, 0x14, 0xB6, 0x00, 0x00, 0x12, 0xBE, 
    0x00, 0x00, 0x10, 0x45, 0x00, 0x00, 0x0D, 0x4C, 0x00, 0x00, 0x09, 0xD6, 0x00, 0x00, 0x05, 0xE9, 
    0x00, 0x00, 0x01, 0x8C, 0xFF, 0xFF, 0xFC, 0xC6, 0xFF, 0xFF, 0xF7, 0x9F, 0xFF, 0xFF, 0xF2, 0x21, 
    0xFF, 0xFF, 0xEC, 0x58, 0xFF, 0xFF, 0xE6, 0x51, 0xFF, 0xFF, 0xE0, 0x17, 0xFF, 0xFF, 0xD9, 0xB9, 
    0xFF, 0xFF, 0xD3, 0x46, 0xFF, 0xFF, 0xCC, 0xCC, 0xFF, 0xFF, 0xC6, 0x5B, 0xFF, 0xFF, 0xC0, 0x01, 
    0xFF, 0xFF, 0xB9, 0xCF, 0xFF, 0xFF, 0xB3, 0xD4, 0xFF, 0xFF, 0xAE, 0x1E, 0xFF, 0xFF, 0xA8, 0xBE, 
    0xFF, 0xFF, 0xA3, 0xC1, 0xFF, 0xFF, 0x9F, 0x34, 0xFF, 0xFF, 0x9B, 0x25, 0xFF, 0xFF, 0x97, 0x9F, 
    0xFF, 0xFF, 0x94, 0xAD, 0xFF, 0xFF, 0x92, 0x59, 0xFF, 0xFF, 0x90, 0xAB, 0xFF, 0xFF, 0x8F, 0xAA, 
    0xFF, 0xFF, 0x8F, 0x5B, 0xFF, 0xFF, 0x8F, 0xC3, 0xFF, 0xFF, 0x90, 0xE5, 0xFF, 0xFF, 0x92, 0xC0, 
    0xFF, 0xFF, 0x95, 0x55, 0xFF, 0xFF, 0x98, 0xA2, 0xFF, 0xFF, 0x9C, 0xA3, 0xFF, 0xFF, 0xA1, 0x52, 
    0xFF, 0xFF, 0xA6, 0xA9, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFF, 0xB3, 0x2B, 0xFF, 0xFF, 0xBA, 0x42, 
    0xFF, 0xFF, 0xC1, 0xD7, 0xFF, 0xFF, 0xC9, 0xDE, 0xFF, 0xFF, 0xD2, 0x49, 0xFF, 0xFF, 0xDB, 0x07, 
    0xFF, 0xFF, 0xE4, 0x09, 0xFF, 0xFF, 0xED, 0x3E, 0xFF, 0xFF, 0xF6, 0x97, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x07, 0x04, 0x00, 0x00, 0x0F, 0x79, 0x00, 0x00, 0x19, 0x4E, 0x00, 0x00, 0x24, 0x67, 
    0x00, 0x00, 0x30, 0x92, 0x00, 0x00, 0x3D, 0x8B, 0x00, 0x00, 0x4A, 0xF0, 0x00, 0x00, 0x58, 0x42, 
    0x00, 0x00, 0x64, 0xE0, 0x00, 0x00, 0x70, 0x09, 0x00, 0x00, 0x78, 0xE3, 0x00, 0x00, 0x7E, 0x7E, 
    0x00, 0x00, 0x7F, 0xE5, 0x00, 0x00, 0x7C, 0x35, 0x00, 0x00, 0x72, 0xB3, 0x00, 0x00, 0x62, 0xF1, 
    0x00, 0x00, 0x4C, 0xEA, 0x00, 0x00, 0x31, 0x29, 0x00, 0x00, 0x10, 0xE2, 0xFF, 0xFF, 0xEE, 0x00, 
    0xFF, 0xFF, 0xCB, 0x1A, 0xFF, 0xFF, 0xAB, 0x5D, 0xFF, 0xFF, 0x92, 0x3E, 0xFF, 0xFF, 0x83, 0x1E, 
    0xFF, 0xFF, 0x80, 0xC8, 0xFF, 0xFF, 0x8C, 0xE4, 0xFF, 0xFF, 0xA7, 0x6D, 0xFF, 0xFF, 0xCE, 0x4C, 
    0xFF, 0xFF, 0xFD, 0x34, 0x00, 0x00, 0x2D, 0xE1, 0x00, 0x00, 0x58, 0xCA, 0x00, 0x00, 0x76, 0x40, 
    0x00, 0x00, 0x7F, 0xEF, 0x00, 0x00, 0x72, 0x6A, 0x00, 0x00, 0x4E, 0x79, 0x00, 0x00, 0x19, 0xBD, 
    0xFF, 0xFF, 0xDE, 0x4A, 0xFF, 0xFF, 0xA9, 0x08, 0xFF, 0xFF, 0x86, 0xFC, 0xFF, 0xFF, 0x81, 0xE4, 
    0xFF, 0xFF, 0x9D, 0x07, 0xFF, 0xFF, 0xD3, 0x39, 0x00, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x55, 0x5F, 
    0x00, 0x00, 0x7B, 0x06, 0x00, 0x00, 0x7A, 0x8A, 0x00, 0x00, 0x51, 0xD7, 0x00, 0x00, 0x0C, 0x8B, 
    0xFF, 0xFF, 0xC1, 0xA4, 0xFF, 0xFF, 0x8C, 0x61, 0xFF, 0xFF, 0x82, 0x3B, 0xFF, 0xFF, 0xA9, 0x77, 
    0xFF, 0xFF, 0xF4, 0x95, 0x00, 0x00, 0x45, 0xA2, 0x00, 0x00, 0x79, 0x85, 0x00, 0x00, 0x77, 0x6B, 
    0x00, 0x00, 0x3D, 0xC2, 0xFF, 0xFF, 0xE5, 0xAF, 0xFF, 0xFF, 0x99, 0x75, 0xFF, 0xFF, 0x80, 0x8C, 
    0xFF, 0xFF, 0xAA, 0x4D, 0x00, 0x00, 0x02, 0xF1, 0x00, 0x00, 0x5B, 0x06, 0x00, 0x00, 0x7F, 0xFF, 
    0x00, 0x00, 0x59, 0xFC, 0xFF, 0xFF, 0xFD, 0x0F, 0xFF, 0xFF, 0xA0, 0xEF, 0xFF, 0xFF, 0x80, 0x8C, 
    0xFF, 0xFF, 0xB3, 0x67, 0x00, 0x00, 0x1A, 0x51, 0x00, 0x00, 0x70, 0x1C, 0x00, 0x00, 0x77, 0x6B, 
    0x00, 0x00, 0x28, 0x32, 0xFF, 0xFF, 0xBA, 0x5E, 0xFF, 0xFF, 0x80, 0x84, 0xFF, 0xFF, 0xA9, 0x77, 
    0x00, 0x00, 0x17, 0xC4, 0x00, 0x00, 0x73, 0x9F, 0x00, 0x00, 0x6F, 0xC6, 0x00, 0x00, 0x0C, 0x8B, 
    0xFF, 0xFF, 0x9D, 0x97, 0xFF, 0xFF, 0x85, 0x76, 0xFF, 0xFF, 0xDC, 0xAF, 0x00, 0x00, 0x55, 0x5F, 
    0x00, 0x00, 0x7D, 0xE9, 0x00, 0x00, 0x2C, 0xC7, 0xFF, 0xFF, 0xAE, 0xD7, 0xFF, 0xFF, 0x81, 0xE4, 
    0xFF, 0xFF, 0xD6, 0x51, 0x00, 0x00, 0x56, 0xF8, 0x00, 0x00, 0x7B, 0x7A, 0x00, 0x00, 0x19, 0xBD, 
    0xFF, 0xFF, 0x9A, 0xE3, 0xFF, 0xFF, 0x8D, 0x96, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x76, 0x40, 
    0x00, 0x00, 0x5C, 0x31, 0xFF, 0xFF, 0xD2, 0x1F, 0xFF, 0xFF, 0x80, 0x09, 0xFF, 0xFF, 0xCE, 0x4C, 
    0x00, 0x00, 0x5C, 0x65, 0x00, 0x00, 0x73, 0x1C, 0xFF, 0xFF, 0xF1, 0xF1, 0xFF, 0xFF, 0x83, 0x1E, 
    0xFF, 0xFF, 0xBE, 0x28, 0x00, 0x00, 0x54, 0xA3, 0x00, 0x00, 0x74, 0x8D, 0xFF, 0xFF, 0xEE, 0x00, 
    0xFF, 0xFF, 0x81, 0x20, 0xFF, 0xFF, 0xCE, 0xD7, 0x00, 0x00, 0x66, 0x4E, 0x00, 0x00, 0x62, 0xF1, 
    0xFF, 0xFF, 0xC7, 0x33, 0xFF, 0xFF, 0x83, 0xCB, 0x00, 0x00, 0x05, 0x0D, 0x00, 0x00, 0x7E, 0x7E, 
    0x00, 0x00, 0x2A, 0x0E, 0xFF, 0xFF, 0x8F, 0xF7, 0xFF, 0xFF, 0xB1, 0x37, 0x00, 0x00, 0x58, 0x42, 
    0x00, 0x00, 0x67, 0xC3, 0xFF, 0xFF, 0xC2, 0x75, 0xFF, 0xFF, 0x89, 0x95, 0x00, 0x00, 0x24, 0x67, 
    0x00, 0x00, 0x7D, 0x78, 0xFF, 0xFF, 0xF0, 0x87, 0xFF, 0xFF, 0x80, 0x33, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xFF, 0xC6, 0x95, 0xFF, 0xFF, 0xCB, 0x25, 0xFF, 0xFF, 0xC9, 0xBC, 0xFF, 0xFF, 0xCD, 0x56, 
    0xFF, 0xFF, 0xCD, 0x2E, 0xFF, 0xFF, 0xCE, 0x03, 0xFF, 0xFF, 0xCE, 0xC0, 0xFF, 0xFF, 0xD1, 0xAC, 
    0xFF, 0xFF, 0xD6, 0x81, 0xFF, 0xFF, 0xD7, 0xD8, 0xFF, 0xFF, 0xD6, 0x23, 0xFF, 0xFF, 0xD9, 0xA3, 
    0xFF, 0xFF, 0xD9, 0x6F, 0xFF, 0xFF, 0xDE, 0x63, 0xFF, 0xFF, 0xE1, 0x8B, 0xFF, 0xFF, 0xE0, 0x2F, 
    0xFF, 0xFF, 0xDE, 0x31, 0xFF, 0xFF, 0xE6, 0xBA, 0xFF, 0xFF, 0xED, 0x65, 0xFF, 0xFF, 0xEA, 0x39, 
    0xFF, 0xFF, 0xEB, 0xAB, 0xFF, 0xFF, 0xED, 0x8B, 0xFF, 0xFF, 0xF0, 0xBA, 0xFF, 0xFF, 0xF4, 0xC5, 
    0xFF, 0xFF, 0xF5, 0x99, 0xFF, 0xFF, 0xF4, 0x3B, 0xFF, 0xFF, 0xF6, 0x89, 0xFF, 0xFF, 0xF8, 0xDF, 
    0xFF, 0xFF, 0xF8, 0xAE, 0xFF, 0xFF, 0xFE, 0x67, 0xFF, 0xFF, 0xFE, 0x69, 0x00, 0x00, 0x02, 0xF5, 
    0x00, 0x00, 0x01, 0x88, 0x00, 0x00, 0x06, 0xEF, 0x00, 0x00, 0x02, 0x17, 0x00, 0x00, 0x0B, 0x0F, 
    0x00, 0x00, 0x06, 0x9D, 0x00, 0x00, 0x09, 0x67, 0x00, 0x00, 0x0D, 0x64, 0x00, 0x00, 0x0C, 0x6F, 
    0x00, 0x00, 0x11, 0xFC, 0x00, 0x00, 0x14, 0x09, 0x00, 0x00, 0x17, 0x68, 0x00, 0x00, 0x16, 0x07, 
    0x00, 0x00, 0x19, 0x7E, 0x00, 0x00, 0x1B, 0x11, 0x00, 0x00, 0x1D, 0xD6, 0x00, 0x00, 0x1F, 0x99, 
    0x00, 0x00, 0x1E, 0x69, 0x00, 0x00, 0x25, 0x8E, 0x00, 0x00, 0x23, 0x5F, 0x00, 0x00, 0x24, 0x44, 
    0x00, 0x00, 0x26, 0x01, 0x00, 0x00, 0x2C, 0x11, 0x00, 0x00, 0x2B, 0x65, 0x00, 0x00, 0x32, 0xBC, 
    0x00, 0x00, 0x2F, 0x1F, 0x00, 0x00, 0x31, 0x21, 0x00, 0x00, 0x34, 0x14, 0x00, 0x00, 0x32, 0xF5, 
    0x00, 0x00, 0x36, 0x92, 0x00, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x3C, 0xE4, 0x00, 0x00, 0x3D, 0x5F, 
    0x00, 0x00, 0x38, 0x91, 0x00, 0x00, 0x39, 0x21, 0x00, 0x00, 0x36, 0x58, 0x00, 0x00, 0x37, 0xD6, 
    0x00, 0x00, 0x35, 0xE4, 0x00, 0x00, 0x32, 0xA6, 0x00, 0x00, 0x30, 0x6E, 0x00, 0x00, 0x2F, 0x1E, 
    0x00, 0x00, 0x2A, 0x3D, 0x00, 0x00, 0x2A, 0x7D, 0x00, 0x00, 0x27, 0x24, 0x00, 0x00, 0x27, 0xA4, 
    0x00, 0x00, 0x23, 0xC2, 0x00, 0x00, 0x25, 0xC2, 0x00, 0x00, 0x20, 0xA0, 0x00, 0x00, 0x20, 0xD0, 
    0x00, 0x00, 0x1C, 0x6E, 0x00, 0x00, 0x17, 0xBF, 0x00, 0x00, 0x19, 0x64, 0x00, 0x00, 0x16, 0x6B, 
    0x00, 0x00, 0x12, 0x42, 0x00, 0x00, 0x13, 0x6F, 0x00, 0x00, 0x11, 0x9D, 0x00, 0x00, 0x0E, 0x80, 
    0x00, 0x00, 0x0F, 0xEA, 0x00, 0x00, 0x09, 0xE2, 0x00, 0x00, 0x07, 0xB8, 0x00, 0x00, 0x07, 0x98, 
    0x00, 0x00, 0x06, 0x73, 0x00, 0x00, 0x02, 0xD5, 0x00, 0x00, 0x01, 0x63, 0xFF, 0xFF, 0xFD, 0xF2, 
    0x00, 0x00, 0x01, 0xED, 0xFF, 0xFF, 0xFF, 0xE5, 0xFF, 0xFF, 0xF7, 0x69, 0xFF, 0xFF, 0xFC, 0x16, 
    0xFF, 0xFF, 0xF4, 0xCD, 0xFF, 0xFF, 0xF4, 0x06, 0xFF, 0xFF, 0xF3, 0xC2, 0xFF, 0xFF, 0xF0, 0x30, 
    0xFF, 0xFF, 0xF1, 0x72, 0xFF, 0xFF, 0xEF, 0x53, 0xFF, 0xFF, 0xE8, 0x12, 0xFF, 0xFF, 0xE7, 0x2D, 
    0xFF, 0xFF, 0xE5, 0xDC, 0xFF, 0xFF, 0xE6, 0x34, 0xFF, 0xFF, 0xE2, 0xAE, 0xFF, 0xFF, 0xE2, 0xF2, 
    0xFF, 0xFF, 0xE0, 0x23, 0xFF, 0xFF, 0xDB, 0xDF, 0xFF, 0xFF, 0xDC, 0x2B, 0xFF, 0xFF, 0xD8, 0x95, 
    0xFF, 0xFF, 0xD6, 0xE8, 0xFF, 0xFF, 0xD8, 0xDA, 0xFF, 0xFF, 0xD1, 0x2C, 0xFF, 0xFF, 0xCE, 0x93, 
    0xFF, 0xFF, 0xD1, 0x70, 0xFF, 0xFF, 0xCB, 0xA6, 0xFF, 0xFF, 0xCC, 0x70, 0xFF, 0xFF, 0xCB, 0x45, 
    0xFF, 0xFF, 0xC8, 0x65, 0xFF, 0xFF, 0xC5, 0xEC, 0xFF, 0xFF, 0xC4, 0xBF, 0xFF, 0xFF, 0xC5, 0x80, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x5F, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 
    0x00, 0x00, 0x5F, 0xFF, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xFF, 0xEF, 0xA6, 0x00, 0x00, 0x0F, 0x80, 0xFF, 0xFF, 0xF0, 0x04, 0x00, 0x00, 0x0E, 0xA6, 
    0xFF, 0xFF, 0xED, 0x75, 0x00, 0x00, 0x1E, 0x84, 0x00, 0x00, 0x04, 0xC7, 0x00, 0x00, 0x28, 0xD4, 
    0x00, 0x00, 0x08, 0x39, 0x00, 0x00, 0x16, 0x30, 0x00, 0x00, 0x21, 0x11, 0x00, 0x00, 0x0B, 0x1E, 
    0xFF, 0xFF, 0xF6, 0x1E, 0xFF, 0xFF, 0xFD, 0x1F, 0xFF, 0xFF, 0xE7, 0x51, 0xFF, 0xFF, 0xCB, 0x57, 
    0x00, 0x00, 0x03, 0xD6, 0x00, 0x00, 0x0D, 0xE0, 0x00, 0x00, 0x06, 0x83, 0xFF, 0xFF, 0xF8, 0x23, 
    0xFF, 0xFF, 0xF5, 0x53, 0x00, 0x00, 0x1D, 0x19, 0x00, 0x00, 0x0A, 0x04, 0x00, 0x00, 0x29, 0x17, 
    0x00, 0x00, 0x15, 0x24, 0x00, 0x00, 0x25, 0xA4, 0xFF, 0xFF, 0xDC, 0xB4, 0xFF, 0xFF, 0xF9, 0x57, 
    0x00, 0x00, 0x19, 0x77, 0x00, 0x00, 0x2E, 0xF3, 0xFF, 0xFF, 0xD4, 0x13, 0x00, 0x00, 0x02, 0x39, 
    0x00, 0x00, 0x32, 0x10, 0x00, 0x00, 0x04, 0x22, 0xFF, 0xFF, 0xEF, 0xE8, 0xFF, 0xFF, 0xDB, 0x2B, 
    0xFF, 0xFF, 0xFE, 0x4C, 0x00, 0x00, 0x09, 0x8E, 0x00, 0x00, 0x05, 0x90, 0xFF, 0xFF, 0xFB, 0x68, 
    0x00, 0x00, 0x00, 0xA8, 0x00, 0x00, 0x10, 0x6F, 0x00, 0x00, 0x17, 0xA1, 0xFF, 0xFF, 0xD8, 0x31, 
    0x00, 0x00, 0x10, 0xFC, 0xFF, 0xFF, 0xF0, 0x66, 0x00, 0x00, 0x0E, 0x78, 0xFF, 0xFF, 0xF0, 0x5E, 
    0x00, 0x00, 0x1F, 0x83, 0x00, 0x00, 0x19, 0x74, 0xFF, 0xFF, 0xEB, 0x6F, 0xFF, 0xFF, 0xF0, 0xDE, 
    0x00, 0x00, 0x2B, 0x4D, 0x00, 0x00, 0x18, 0x67, 0xFF, 0xFF, 0xCE, 0x98, 0x00, 0x00, 0x0D, 0x20, 
    0x00, 0x00, 0x0A, 0x13, 0xFF, 0xFF, 0xE8, 0xD3, 0xFF, 0xFF, 0xDF, 0x60, 0x00, 0x00, 0x08, 0xDF, 
    0xFF, 0xFF, 0xE1, 0x68, 0x00, 0x00, 0x11, 0x14, 0xFF, 0xFF, 0xFE, 0x44, 0xFF, 0xFF, 0xD3, 0x92, 
    0x00, 0x00, 0x14, 0xA4, 0xFF, 0xFF, 0xE8, 0x95, 0xFF, 0xFF, 0xF2, 0xD8, 0x00, 0x00, 0x30, 0x8A, 
    0xFF, 0xFF, 0xF9, 0x85, 0xFF, 0xFF, 0xFB, 0x89, 0x00, 0x00, 0x19, 0x0E, 0x00, 0x00, 0x21, 0x02, 
    0xFF, 0xFF, 0xF2, 0x6B, 0xFF, 0xFF, 0xEE, 0x43, 0xFF, 0xFF, 0xE9, 0xFE, 0x00, 0x00, 0x0D, 0x8A, 
    0xFF, 0xFF, 0xFA, 0x2B, 0x00, 0x00, 0x09, 0xA5, 0x00, 0x00, 0x1F, 0x45, 0x00, 0x00, 0x1C, 0x1D, 
    0xFF, 0xFF, 0xEA, 0x2A, 0xFF, 0xFF, 0xE8, 0xDB, 0x00, 0x00, 0x11, 0xE2, 0x00, 0x00, 0x0C, 0x5A, 
    0x00, 0x00, 0x14, 0xC7, 0x00, 0x00, 0x08, 0x64, 0xFF, 0xFF, 0xD7, 0x61, 0xFF, 0xFF, 0xE8, 0x6E, 
    0xFF, 0xFF, 0xF0, 0x47, 0xFF, 0xFF, 0xF7, 0x6F, 0x00, 0x00, 0x02, 0x0E, 0xFF, 0xFF, 0xFE, 0xC9, 
    0xFF, 0xFF, 0xF0, 0x44, 0x00, 0x00, 0x06, 0x27, 0x00, 0x00, 0x03, 0x33, 0xFF, 0xFF, 0xFA, 0x47, 
    0xFF, 0xFF, 0xF5, 0xFE, 0xFF, 0xFF, 0xDC, 0x9F, 0x00, 0x00, 0x1B, 0x8D, 0x00, 0x00, 0x20, 0x7F, 
    0x00, 0x00, 0x0C, 0x79, 0xFF, 0xFF, 0xE7, 0x85, 0x00, 0x00, 0x0B, 0x90, 0xFF, 0xFF, 0xDF, 0xE8, 
    0x00, 0x00, 0x06, 0x90, 0x00, 0x00, 0x0A, 0xC8, 0x00, 0x00, 0x1A, 0xAF, 0x00, 0x00, 0x1E, 0xF3, 
    0x00, 0x00, 0x13, 0xFD, 0xFF, 0xFF, 0xE1, 0xCC, 0x00, 0x00, 0x19, 0xA2, 0xFF, 0xFF, 0xE5, 0xC4, 
    0xFF, 0xFF, 0xE4, 0xF3, 0x00, 0x00, 0x49, 0xEC, 0xFF, 0xFF, 0xF9, 0x26, 0xFF, 0xFF, 0xF3, 0x7F, 
    0x00, 0x00, 0x0A, 0xBC, 0xFF, 0xFF, 0xEC, 0xFD, 0x00, 0x00, 0x0E, 0xAA, 0xFF, 0xFF, 0xFC, 0x53, 
    0xFF, 0xFF, 0xFB, 0xFD, 0xFF, 0xFF, 0xF0, 0x58, 0x00, 0x00, 0x02, 0x91, 0xFF, 0xFF, 0xE3, 0x83, 
    0x00, 0x00, 0x18, 0x80, 0xFF, 0xFF, 0xF1, 0x35, 0xFF, 0xFF, 0xF3, 0x0C, 0xFF, 0xFF, 0xE6, 0xD6, 
};
