; Object-List management, v 0.1
; Copyright (C) 2006 Seb/The Removers
; http://removers.atari.org
	
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.

; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
	.offset	0
	;; donnees d'un sprite
	;; vu que de toute faon on aligne sur 32 bits,
	;; on s'y donne a coeur joie et on n'economise pas specialement la memoire
	;; mais bon, a reste raisonnable quand meme
SPRITE_OBJ:	ds.l	2*3	; 3 phrases
SPRITE_RESTORE:	ds.l	3	; 3 longs a restaurer apres affichage (copie de la premiere phrase et derniere demi-phrase)
SPRITE_TYPE:	ds.w	1	; soit BITOBJ soit SCBITOBJ
SPRITE_DATA:	ds.l	1	; adresse de l'image
SPRITE_DEPTH:	ds.w	1	; profondeur (1 bit, 2 bits, ..., 16 bits, 24 bits) (O_DEPTH1, O_DEPTH2, ..., O_DEPTH32)
SPRITE_DWIDTH:	ds.w	1	; largeur de l'image en phrases
SPRITE_PITCH:	ds.l	1	; distance entre deux phrases de l'image (O_NOGAP, O_1GAP, O_2GAP, ..., O_6GAP) : !! ATTENTION au .l !!
SPRITE_XPOS:	ds.w	1	; x
SPRITE_YPOS:	ds.w	1	; y
SPRITE_IWIDTH:	ds.w	1	; largeur du sprite en phrases (partie visible de l'image)
SPRITE_HEIGHT:	ds.w	1	; hauteur du sprite
SPRITE_INDEX:	ds.w	1	; index de palette
SPRITE_RELEASE_TRANS_RMW_REFLECT:	ds.l	1	; disjonction des flags (O_REFLECT ou bien 0), (O_RMW ou bien 0), (O_TRANS ou bien 0) ou (O_RELEASE ou bien 0)
							; O_REFLECT si on veut faire un miroir vertical (penser a corriger XPOS)
							; O_RMW pour ajouter les pixels au lieu de les copier
							; O_TRANS si le sprite est transparent
							; O_RELEASE pour que l'OP relache le bus apres avoir traite le flag
							; !! ATTENTION:	le tout est sur un mot long !!
SPRITE_FIRSTPIX:	ds.w	1 ; premier pixel a afficher 
SPRITE_HSCALE:	ds.w	1	; hscale (3 bits),(5 bits)
SPRITE_VSCALE:	ds.w	1	; vscale (3 bits),(5 bits)
SPRITE_REMAINDER:	ds.w	1 ; reste (3 bits),(5 bits)
SPRITE_SIZEOF:	ds.l	0

MASK_LINK	equ	$7ffff	; 19 bits
MASK_HEIGHT	equ	$3ff	; 10 bits
MASK_WIDTH	equ	$3ff	; 10 bits
MASK_XPOS	equ	$fff	; 12 bits
MASK_YPOS	equ	$7ff	; 11 bits
MASK_INDEX	equ	$7f	; 7 bits
MASK_FIRSTPIX	equ	$3f	; 6 bits
	
	.text
	
.macro	format_link
	;; \1 est un registre de donnee contenant l'adresse du lien (sur 19+3 = 22 bits, les 3 derniers valant 0)
	;; \2 est un registre (different de \1) qui contiendra les 32 bits de poids faible
	;; dans \1 on mettra les 32 bits de poids fort
	swap	\1
	rol.l	#5,\1
	move.l	\1,\2
	and.l	#$ff000000,\2	; poids faible (bits 3 a 10 dans bits 24 a 31)
	and.l	#$7ff,\1	; poids fort (bits 11 a 21 dans bits 0 a 10)
.endm

.macro	fast_refresh_nonscaled_sprite_object
	;; \1 pointe sur le sprite et est modifie
	move.l	SPRITE_RESTORE(\1),(\1)+
	move.l	SPRITE_RESTORE(\1),(\1)+
.endm

.macro	fast_refresh_scaled_sprite_object
	;; \1 pointe sur le sprite et est modifie
	fast_refresh_nonscaled_sprite_object	\1
	move.l	SPRITE_RESTORE(\1),20-8(\1)
.endm
		
new_stop_object:
	;; input
	;; d0:d1 contient le DATA field sur 64 bits (en fait, 61 bits) : d0 poids fort
	;; output
	;; renvoie dans a0 l'adresse de l'objet
	;; d0 et d1 sont modifies
	move.l	d2,-(sp)
	movem.l	d0-d1/a1-a2,-(sp) ; sauve les registres pour le mm_alloc
	moveq	#1*8,d0		; reserve une phrase
	bsr	mm_alloc	
	movem.l	(sp)+,d0-d1/a1-a2
	moveq	#%111,d2	; 3 bits
	lsl.l	#3,d0		; fait de la place
	rol.l	#3,d1
	and.w	d1,d2		; recupere les 3 bits de poids fort de d1 dans d2
	or.w	d2,d0		; les mets en bit de poids faible de d0
	and.w	#~%111,d1	; efface les 3 bits 
	or.w	#STOPOBJ,d1
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	(sp)+,d2
	subq.w	#8,a0		; se recale au debut de l'object
	rts

new_branch_object:
	;; input
	;; a0 contient l'adresse de l'objet si on branche (link)
	;; a1 contient l'adresse de l'objet si on ne branche pas (link)
	;; d0 contient YPOS
	;; d1 contient le code condition (CC) (deja decale)
	;; output
	;; renvoie dans a0 l'adresse de l'objet
	;; d0 d1 a0 a1 sont modifies
	movem.l	d2/a2,-(sp)
	and.l	#MASK_YPOS,d0	; masque YPOS (11 bits)
	lsl.w	#3,d0		; decale de 3 bits
	or.w	d1,d0		; ajoute le code condition (qu'on suppose correct sur les bits 14 et 15)
	or.w	#BRANCHOBJ,d0	; branch object (c'est bien sur 16 bits)
	move.l	a0,d2		; charge le then link dans d2
	format_link	d2,d1	; met a dans les 64 bits formes par d2:d1
	or.w	d0,d1		; d2:d1 contient maintenant le branch object de tete
	movem.l	d1-d2/a1,-(sp)
	moveq	#3*8,d0 ; reserve 3 phrases (1ere phrase: branch object voulu, 2eme phrase: branch object else, 3eme phrase: stop object par securite)
	bsr	mm_alloc
	movem.l	(sp)+,d1-d2/a1
	move.l	d2,(a0)+
	move.l	d1,(a0)+	; premier branch object
	move.l	a1,d0		; charge le else link dans d0
	format_link	d0,d1	; d0:d1 contient le link formate
	or.w	#O_BREQ|($7ff<<3)|BRANCHOBJ,d1 ; construit un branchement inconditionnel
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	clr.l	(a0)+		; puis met un stop object par securite
	move.l	#STOPOBJ,(a0)+
	movem.l	(sp)+,d2/a2
	sub.w	#3*8,a0		; se recale au debut de l'object
	rts

new_gpu_object:
	;; input
	;; a0 contient l'adresse de l'objet suivant
	;; d0 contient YPOS
	;; d1:d2 contient le champ DATA sur 50 bits (d1 poids fort)
	;; output
	;; renvoie dans a0 l'adresse de l'objet
	;; d0, d1, d2, a0 sont modifies
	movem.l	d3/a1-a2,-(sp)
	and.l	#MASK_YPOS,d0	; ne garde que 11 bits
	lsl.w	#3,d0		; decale de 3 bits
	or.w	#GPUOBJ,d0	; gpu object
	swap	d1		; decale de 16 bits
	ror.l	#2,d1		; mais on ne voulait que 14 bits
	swap	d2		; meme traitement
	ror.l	#2,d2
	and.l	#$ffffa000,d1	; efface les 14 bits de poids faible
	move.l	d2,d3
	and.l	#$ffffa000,d2	; efface les 14 bits de poids faible
	or.l	d2,d0		; deuxieme phrase prete
	and.w	#$3fff,d3	; ils vont dans d1 ceux la
	or.w	d3,d1		; voila voila
	move.l	a0,d2
	format_link	d2,d3	; le link est dans d2:d3
	movem.l	d0-d3,-(sp)
	moveq	#3*8,d0		; 3 phrases: GPU object, branch object inconditionnel, stop object par securite
	bsr	mm_alloc
	movem.l	(sp)+,d0-d3
	move.l	d1,(a0)+
	move.l	d0,(a0)+	; le gpu object est ecrit
	or.w	#O_BREQ|($7ff<<3)|BRANCHOBJ,d3 ; saut inconditionnel
	move.l	d2,(a0)+
	move.l	d3,(a0)+
	clr.l	(a0)+		; puis met un stop object
	move.l	#STOPOBJ,(a0)+
	movem.l	(sp)+,d3/a1-a2
	sub.w	#3*8,a0
	rts

get_link_of_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; output
	;; renvoie dans d0 et a1 le link
	move.l	SPRITE_RESTORE+2(a0),d0	; on se fie aux valeurs sauvees
	lsr.l	#8,d0
	and.l	#MASK_LINK,d0	; on ne garde que 19 bits
	lsl.l	#3,d0		; remet sur 22 bits
	move.l	d0,a1
	rts
	
put_link_of_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; a1: adresse du nouveau link
	;; output
	;; a0 pointe toujours sur le sprite
	;; d0, d1 sont modifies
	move.l	SPRITE_RESTORE+2(a0),d0
	move.l	a1,d1
	lsr.l	#3,d1		; ignore les 3 bits de poids faible
	and.l	#MASK_LINK,d1	; on ne garde que 19 bits
	lsl.l	#8,d1		; decale
	and.l	#~(MASK_LINK<<8),d0	; efface l'ancien lien
	or.l	d1,d0
	move.l	d0,SPRITE_RESTORE+2(a0)	; met a jour
	move.l	d0,2(a0)
	rts
			
update_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; ici, on appelle finalize_sprite_object 
	;; mais en gardant la meme valeur pour link
	;; utile si on a mis a jour des valeurs (genre x, y, ...)
	;; output
	;; en retour, on obtient dans a1 la valeur de link et 
	;; a0 continue de pointer sur le sprite
	move.l	d0,-(sp)
	move.l	SPRITE_RESTORE+2(a0),d0	; on se fie aux valeurs sauves, on lit les bits 16 a 47
	lsr.l	#8,d0		; on decale de maniere a mettre le bit 24 tout a droite
	and.l	#MASK_LINK,d0	; on ne garde que 19 bits
	lsl.l	#3,d0		; on remet sur 22 bits
	move.l	d0,a1
	move.l	(sp)+,d0
finalize_sprite_object:
	;; input
	;; a0 contient l'adresse du sprite (structure le decrivant)
	;; a1 contient l'adresse de l'objet suivant (link)
	;; output
	;; a0 contient l'adresse du sprite
	;; cette fonction calcule les 3 phrases qu'il faut pour la Jag
	;; en fonction des autres infos contenues dans la structure
	;; a1 n'est pas modifie
	movem.l	d0-d2/a0,-(sp)
	;; calcul de la premiere phrase
	move.l	a1,d0
	format_link	d0,d1	;  d0:d1 contient le link formate
	move.l	SPRITE_DATA(a0),d2
	lsl.l	#8,d2		; decale de 8 (+3=11 car les 3 bits de poids faible sont ignores)
	and.l	#$fffff800,d2	; masque les 21 bits de poids fort
	or.l	d2,d0
	move.l	d0,(a0)+	; ecrit le premier long mot (data+11 bits de poids fort de link)
	moveq	#0,d0		; un d0 tout propre
	move.w	SPRITE_HEIGHT-4(a0),d0 ; hauteur (offset-4 car on a avance en ecrivant le premier long mot)
	and.w	#MASK_HEIGHT,d0	; 10 bits
	swap	d0		; decale de 16 bits a gauche
	ror.l	#2,d0		; mais il ne fallait que 14 bits
	or.l	d1,d0		; d0 contient les 8 bits de poids faible de link + la hauteur
	move.w	SPRITE_YPOS-4(a0),d2 ; y
	and.w	#MASK_YPOS>>1,d0	; 10 bits
	lsl.w	#4,d2		; *2 car en demi-lignes (donc en fait 11 bits) puis decale de 3 bits
	or.w	d2,d0		; d0 contient les 8 bits de poids faible de link + la hauteur + y_pos
	or.w	SPRITE_TYPE-4(a0),d0 ; d0 est fin pret
	move.l	d0,(a0)+	; on ecrit le deuxieme long mot
	;; calcul de la deuxieme phrase (a0 a ete incremente de 8)
	moveq	#0,d0		; un peu de menage 
	moveq	#0,d1
	moveq	#0,d2
	move.w	SPRITE_FIRSTPIX-8(a0),d0 ;  first pixel
	and.w	#MASK_FIRSTPIX,d0		; 6 bits
	add.w	d0,d0		; decale de 1 bit
	swap	d0		; puis de 16 donc 17 au total
	or.l	SPRITE_RELEASE_TRANS_RMW_REFLECT-8(a0),d0	; d0 contient firstpix + release + trans + rmw + reflect
	move.w	SPRITE_INDEX-8(a0),d1 ; index
	and.w	#MASK_INDEX,d1		; 7 bits
	lsl.w	#6,d1		; decale de 6 bits
	or.w	d1,d0		; d0 contient en plus l'index
	move.w	SPRITE_IWIDTH-8(a0),d1 ; largeur du sprite en phrases
	and.w	#MASK_WIDTH,d1	; 10 bits
	ror.l	#4,d1		; decale de 4 bits afin d'avoir les 6 bits de poids fort en bas
	or.w	d1,d0		; d0 est pret
	move.l	d0,(a0)+	; paf, on l'ecrit
	move.w	SPRITE_DWIDTH-12(a0),d2	; largeur des donnees en phrases
	and.w	#MASK_WIDTH,d2	; 10 bits
	lsl.w	#2,d2		; decale de 2 bits
	swap	d2		; puis de 16 donc 18 bits au total
	or.l	d2,d1		; d1 contient les 4 bits de poids faible de IWIDTH et les 10 bits de DWIDTH
	or.l	SPRITE_PITCH-12(a0),d1 ; on rajoute le pitch
	or.w	SPRITE_DEPTH-12(a0),d1 ; et la profondeur
	move.w	SPRITE_XPOS-12(a0),d0
	and.w	#MASK_XPOS,d0	; 12 bits
	or.w	d0,d1		; d1 est pret
	move.l	d1,(a0)+
	;; calcul de la troisieme phrase (toujours fait meme si l'objet n'est pas un scaled bitmap object) (a0 a ete incremente de 16)
	clr.l	(a0)+		; inutilises
	move.w	SPRITE_REMAINDER-16(a0),d0
	and.w	#$ff,d0
	swap	d0
	move.w	SPRITE_VSCALE-16(a0),d0
	lsl.w	#8,d0
	move.w	SPRITE_HSCALE-16(a0),d1
	and.w	#$ff,d1
	or.w	d1,d0
	move.l	d0,(a0)+
	movem.l	(sp)+,d0-d2/a0
	move.l	(a0),SPRITE_RESTORE(a0)	; les donnees effaces par l'OP
	move.l	4(a0),SPRITE_RESTORE+4(a0)
	move.l	20(a0),SPRITE_RESTORE+8(a0)
	rts

refresh_sprite_object:
	;; a0: adresse du sprite
	;; la, c'est tres bete, on recopie les valeurs qu'on avait sauvegarde avant
	lea	SPRITE_RESTORE(a0),a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,20-8(a0)
	rts
	
	;; met a jour le sprite en tenant compte d'un changement de coordonnees
	;; plus rapide que update_object
refresh_coords_sprite_object:
	;; input
	;; a0: adresse du sprite
	;; modifie a0, a1, d0, d1
	lea	SPRITE_RESTORE(a0),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),d0
	and.l	#~(MASK_YPOS<<3),d0	; efface YPOS
	move.w	SPRITE_YPOS-4(a0),d1
	and.w	#MASK_YPOS>>1,d1
	lsl.w	#4,d1
	or.w	d1,d0
	move.l	d0,(a1)+
	move.l	d0,(a0)+
	addq.w	#6,a0
	move.w	(a0),d0
	and.w	#~(MASK_XPOS),d0	; efface XPOS
	move.w	SPRITE_XPOS-14(a0),d1
	and.w	#MASK_XPOS,d1
	or.w	d1,d0
	move.w	d0,(a0)
	move.l	(a1)+,20-14(a0)
	rts
			
new_simple_sprite:
	;; input
	;; a0: adresse des donnees
	;; d0: largeur en phrase
	;; d1: hauteur
	;; d2: x
	;; d3: y
	;; d4: profondeur du sprite
	;; output
	;; a0 contient l'adresse de la structure decrivant le sprite
	;; construit un sprite transparent a l'endroit avec IWIDTH = DWIDTH
	;; sans rien de special donc
	;; seul est modifie le registre a0 
	move.l	a1,-(sp)
	movem.l	d0-d2/a0/a2,-(sp)	; pour le mm_alloc
	moveq	#SPRITE_SIZEOF,d0
	bsr	mm_alloc
	movem.l	(sp)+,d0-d2/a1/a2	; on a bouge l'adresse de l'image dans a1
	move.w	#BITOBJ,SPRITE_TYPE(a0)
	move.l	a1,SPRITE_DATA(a0)
	move.w	d4,SPRITE_DEPTH(a0)
	move.w	d0,SPRITE_DWIDTH(a0)
	move.l	#O_NOGAP,SPRITE_PITCH(a0)
	move.w	d2,SPRITE_XPOS(a0)
	move.w	d3,SPRITE_YPOS(a0)
	move.w	d0,SPRITE_IWIDTH(a0)
	move.w	d1,SPRITE_HEIGHT(a0)
	clr.w	SPRITE_INDEX(a0)
	move.l	#O_TRANS,SPRITE_RELEASE_TRANS_RMW_REFLECT(a0) ; juste transparent par defaut
	clr.w	SPRITE_FIRSTPIX(a0)
	clr.w	SPRITE_HSCALE(a0)
	clr.w	SPRITE_VSCALE(a0)
	clr.w	SPRITE_REMAINDER(a0)
	move.l	(sp)+,a1
	rts

