	;;***********************************************************************
	;;
	;;		Project Name	:	NATIVE DEMO
	;;
	;;		COPYRIGHT 1996,1997,1998 Duranik Software
	;;	  UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
	;;	   PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR
	;;	 THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
	;;			    ALL RIGHTS RESERVED.
	;;
	;;	   NATIVE SPIRIT Adaptation Produced by Jason Keith Data
	;;	2007 Revision released under an Educational Community License
	;;			Copyright  2007 Zentanyx
	;;
	;;***********************************************************************

	.org	$f03000
        .gpu
        include "../DURANIK/INCLUDE/JAGUAR.INC"
        include "../DURANIK/INCLUDE/NATIVE.INC"

	olist		equ 	$f03f40	; Adresse OP-Liste	
	olist_ram	equ 	$f03f44	; Adresse Copy OP-Liste
	obj_data	equ 	$f03f48	; Adresse Objecte fr OP
	TOTAL_OBJS	equ 	$f03f4c	; Anzahl Objecte
	obj_gegner	equ	$f03f50	; Startadresse Gegnerdaten fr OP
	x_pos		equ	$f03f54	; X-Pos im Spiel
	gegner		equ	$f03f58	; Startadresse Gegnerdaten
	x1		equ	$f03f5c	; X-Pos linkes Hintergrundbild
	x2		equ	$f03f60	; X-Pos rechtes Hintergrundbild
	iwidth2		equ	$f03f64	; Breite rechtes Hintergrundbild
	lev_speed	equ	$f03f68	; Geschwindigkeit fr Hintergrundscrolling
	level_daten	equ	$f03f6c	; Daten fr Hintergrundgrafiken
	obj_enemy	equ	$f03f70	; Adresse Platz fr Hintergrund Gegnersprites
	r_type_kurve	equ	$f03f74	; Kollisionskurve R-Type nach Lebensverlust
	x3		equ	$f03f78	; X-Pos unteres linkes Vordergrundbild
	x4		equ	$f03f7c	; X-Pos unteres rechtes Vordergrundbild
	scr_unten	equ	$f03f80	; Adresse Daten aus Vordergrundbliste unteres Scrolling
	x5		equ	$f03f84	; X-Pos oberes linkes Vordergrundbild
	x6		equ	$f03f88	; X-Pos oberes rechtes Vordergrundbild
	scr_oben	equ	$f03f8c ; Adresse Daten aus Vordergrundliste oberes Scrolling
	pause		equ	$f03f90	; Adresse Pause
	x		equ	$f03f94	; X-Pos R-Type
	obj_shot	equ	$f03f98	; Adresse Schudaten Spieler
	score1		equ	$f03f9c	; Adresse Score Player 1
	shoot_data1	equ	$f03fa0	; Schudaten Player 1
	shoot_count	equ	$f03fa4	; Counter fr Schuroutine
	y_pos		equ	$f03fa8	; Y-Pos im Spiel
	obj_extra	equ	$f03fac	; Adresse Extras
	money_player1	equ	$f03fb0	; Geld Player 1
	sample_daten	equ	$f03fb4	; Startadresse Sampledaten
	r_type_kurve1	equ	$f03fb8	; Alte X-Pos und Y-Pos R-Type
	r_type_anim1	equ	$f03fbc	; Animation R-Type nach Kollision
	life_player1	equ	$f03fc0	; Anzahl Leben Player 1

; **** GPU initalisieren *********
; GPU luft auf Registerbank 1
        movei	#G_FLAGS,r17          
        load	(r17),r18                
        bset	#3,r18			; Keine Interrupts bitte
        bclr	#14,r18                  
        store	r18,(r17)               

; Stackpointer setzen
	movei	#$f03f00,r31
	moveta	r31,r31
; ********************************

	movei	#pause,r0		; Adresse Pause
	movei	#op_liste,r3		; Adresse UP OP-Liste erstellen
	load	(r0),r2			; Adresse Pause im RAM laden
	loadw	(r2),r1			; Pause laden 0=nicht aktiv, 1=aktiv, 2=kein Hintergrundscrolling
	cmpq	#0,r1			; Ist Pause aktiv ?
	jr	EQ,scroll0		; Nein
	cmpq	#1,r1			; Ist Pause aktiv ?
	jump	EQ,(r3)			; Ja, dann nur OP-Liste erstellen
	nop
	movei	#create_enemy,r3	; Adresse UP Gegner aktivieren
	jump	T,(r3)			; Scrolling Routinen nicht ausfhren	
	nop


************************************************************************
*                Function: Hintergrund Scrolling zeichnen              *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   22.2.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
scroll0:
	movei	#x1,r0			; Adresse Gegnersprites
	load	(r0),r13		; Adresse Gegnersprites laden
	movei	#x2,r0			; Adresse Gegnerdaten fr OP
	load	(r0),r12		; Adresse Gegnerdaten fr OP laden
	movei	#iwidth2,r0		; Adresse Anzahl Objecte
	load	(r0),r9			; Anzahl Objecte laden
	movei	#lev_speed,r0		; Adresse X-Pos im ges. Spiel
	load	(r0),r10 		; X-Pos im ges. Spiel laden
	movei	#level_daten,r0
	load	(r0),r8

	movei	#scroll1,r19
        movei   #scroll2,r20
        movei   #scroll3,r21
        movei	#scroll4,r22
	
; Hintergrund fr Parallaxscrolling zeichnen
scroll:	loadw	(r10),r0		; Speed fr Scrolling laden
	subq	#1,r0			; Speed fr Scrolling verringern
	jump	NE,(r20)		; Nicht scrollen wenn Speed > 0
	nop				; Wegen Sprungbefehl
        moveq   #2,r0                   ; Speed fr Scrolling neu setzen

        loadw   (r12),r2                ; X-Pos rechtes Hintergrundbild laden
	subq	#1,r2			; X-Pos verringern
        jump    EQ,(r21)                ; Wenn X-Pos = 0 alles neu setzen
	nop				; wegen Sprungbefehl
	storew	r2,(r12)		; X-Pos rechtes Hintergrundbild schreiben

        loadw   (r13),r2                ; X-Pos linkes Hintergrundbild laden
        subq    #1,r2                   ; X-Pos verringern
        move    r2,r3                   ; X-Pos retten
        shrq    #2,r2                   ; X-Pos / 4
        shlq    #2,r2                   ; X-Pos * 4
        cmp	r2,r3                   ; wenn gleich, dann ist X-Pos durch 4 teilbar
        jump    NE,(r19)	        ; nicht durch 4 teilbar
	nop				; wegen Sprungbefehl
	
	moveq	#0,r3			; X-Pos neu festlegen (=0)
        move    r13,r14                 ; Adresse retten
        addq    #O_DATA-O_XPOS,r14      ; Auf Adresse linkes Hintergrundbild setzen
        load    (r14),r2                ; Adresse linkes Hintergrundbild laden
        addq    #8,r2                   ; Adresse anpassen
        store   r2,(r14)                ; Adresse linkes Hintergrundbild schreiben

        addq    #O_IWIDTH-O_DATA,r14    ; Adresse Breite linkes Hintergrundbild
        loadw   (r14),r2                ; Breite laden
        subq    #1,r2                   ; Breite um 1 Phrase verringern
        storew  r2,(r14)                ; Breite schreiben

        loadw   (r9),r2                 ; Breite laden
        addq    #1,r2                   ; Breite um 1 Phrase erhhen
        storew  r2,(r9)                 ; Breite schreiben
scroll1:storew  r3,(r13)                ; X-Pos linkes Hintergrundbild schreiben
scroll2:storew  r0,(r10)                ; Speed fr Scrolling schreiben
	jump	T,(r22)			; Ende Scrolling Routine
	nop				; wegen Sprungbefehl

scroll3:storew  r0,(r10)                ; Speed fr Scrolling schreiben
        movei   #320,r0                 ; neue X-Pos rechtes Hintergrundbild (=320)
	moveq	#0,r3			; neue X-Pos linkes Hintergrundbild (=0)
        storew  r0,(r12)                ; neue X-Pos rechtes Hintergrundbild schreiben
        storew  r3,(r13)                ; neue X-Pos linkes Hintergrundbild schreiben        
        addq    #O_DATA-O_XPOS,r12      ; Auf Adresse rechtes Hintergrundbild setzen
        addq    #O_DATA-O_XPOS,r13      ; Auf Adresse linkes Hintergrundbild setzen
        load    (r12),r1                ; Adresse rechtes Hintergrundbild laden
        store   r1,(r13)                ; Adresse linker Hintergrund neu setzen (= Adresse rechter Hintergrund)

	load	(r8),r15		; akt. Adresse Leveldaten laden
        load    (r15),r1                ; neue Adresse rechtes Hintergrundbild
        store   r1,(r12)                ; Adresse rechtes Hintergrundbild neu setzen
	addq	#4,r15			; Adresse fr Leveldaten erhhen
	store	r15,(r8)		; neue Startadresse fr Leveldaten
	
	addq	#1,r3			; Neue Breite fr rechtes Hintergrundbild ( 0 + 1 = 1 Phrase)
	shrq	#2,r0			; Neue Breite fr linkes Hintergrundbild (320 / 4 = 80 Phrases)
	addq	#O_IWIDTH-O_DATA,r12	; Auf Breite rechtes Hintergrundbild setzen
	addq	#O_IWIDTH-O_DATA,r13	; Auf Breite linkes Hintergrundbild setzen
	storew	r3,(r12)		; Neue Breite rechtes Hintergrundbild schreiben
	storew	r0,(r13)		; Neue Breite linkes Hintergrundbild schreiben		
scroll4:



************************************************************************
*                Function: unteres Vordergrund Scrolling mit 	       *
*			   Clipping zeichnen   			       *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   14.5.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; In:	x3		$f03f78
;	level_daten2	$f03f7c
;	scr_unten	$f03f80

	movei	#x3,r0			; X-Pos unteres linkes Vordergrundbild
	load	(r0),r13		; Adresse X-Pos unteres linkes Vordergrundbild
	movei	#x4,r0			; X-Pos unteres rechtes Vordergrundbild
	load	(r0),r12		; Adresse X-Pos unteres rechtes Vordergrundbild
	movei	#scr_unten,r0		; Daten fr untere Vordergrundgrafik
	load	(r0),r11		; Adresse Daten fr untere Vordergrundgrafik

	movei	#scr_vu1,r20		; X-Pos nicht durch 4 teilbar, keine Adressen anpassen
        movei   #scr_vu2,r21		; Adresse alles neu setzen
        movei	#scr_vu3,r22		; Ende Scrolling Routine
	
; unteren Vordergrund fr Parallaxscrolling zeichnen
        loadw   (r12),r2                ; X-Pos rechtes Vordergrundbild laden
	subq	#1,r2			; X-Pos verringern
        jump    EQ,(r21)                ; Wenn X-Pos = 0 alles neu setzen
	nop				; wegen Sprungbefehl
	storew	r2,(r12)		; X-Pos rechtes Vordergrundbild schreiben

        loadw   (r13),r2                ; X-Pos linkes Vordergrundbild laden
        subq    #1,r2                   ; X-Pos verringern
        move    r2,r3                   ; X-Pos retten
        shrq    #2,r2                   ; X-Pos / 4
        shlq    #2,r2                   ; X-Pos * 4
        cmp	r2,r3                   ; wenn gleich, dann ist X-Pos durch 4 teilbar
        jump    NE,(r20)	        ; nicht durch 4 teilbar
	nop				; wegen Sprungbefehl

; Clipping vornehmen	
	moveq	#0,r3			; X-Pos neu festlegen (=0)
        move    r13,r14                 ; Adresse retten
        addq    #O_DATA-O_XPOS,r14      ; Auf Adresse linkes Vordergrundbild setzen
        load    (r14),r2                ; Adresse linkes Vordergrundbild laden
        addq    #8,r2                   ; Adresse anpassen
        store   r2,(r14)                ; Adresse linkes Vordergrundbild schreiben

        addq    #O_IWIDTH-O_DATA,r14    ; Adresse Breite linkes Vordergrundbild
        loadw   (r14),r2                ; Breite laden
        subq    #1,r2                   ; Breite um 1 Phrase verringern
        storew  r2,(r14)                ; Breite schreiben

        addq    #O_IWIDTH-O_XPOS,r12    ; Adresse Breite rechtes Vordergrundbild
        loadw   (r12),r2                ; Breite laden
        addq    #1,r2                   ; Breite um 1 Phrase erhhen
        storew  r2,(r12)                ; Breite schreiben
scr_vu1:storew  r3,(r13)                ; X-Pos linkes Vordergrundbild schreiben
	jump	T,(r22)			; Ende Scrolling Routine
	nop				; wegen Sprungbefehl

; Alles neu setzen
scr_vu2:movei   #320,r0                 ; neue X-Pos rechtes Vordergrundbild (=320)
	moveq	#0,r3			; neue X-Pos linkes Vordergrundbild (=0)
        storew  r0,(r12)                ; neue X-Pos rechtes Vordergrundbild schreiben
        storew  r3,(r13)                ; neue X-Pos linkes Vordergrundbild schreiben        
        addq    #O_DATA-O_XPOS,r12      ; Auf Adresse rechtes Vordergrundbild setzen
        addq    #O_DATA-O_XPOS,r13      ; Auf Adresse linkes Vordergrundbild setzen
        load    (r12),r1                ; Adresse rechtes Vordergrundbild laden
        store   r1,(r13)                ; Adresse linker Vordergrund neu setzen (= Adresse rechter Vordergrund)

	load	(r11),r10		; Adresse fr nchste Leveldaten
        load    (r10),r1                ; neue Adresse rechtes Vordergrundbild
        store   r1,(r12)                ; Adresse rechtes Vordergrundbild neu setzen
	addq	#4,r10			; Adresse auf Hhe setzen
	addq	#O_HEIGHT-O_DATA,r12	; Auf Hhe rechtes Vordergrundbild setzen
	addq	#O_HEIGHT-O_DATA,r13	; Auf Hhe linkes Vordergrundbild setzen
	loadw	(r12),r1		; Hhe rechtes Vordergrundbild laden
	storew	r1,(r13)		; Hhe linkes Vordergrundbild neu setzen (=Hhe rechtes Vordergrundbild)
	loadw	(r10),r1		; neue Hhe rechtes Vordergrundbild laden
	storew	r1,(r12)		; Hhe rechtes Vordergrundbild neu setzen
	addq	#2,r10			; Adresse auf Objekt Typ setzen
	
        subq    #O_HEIGHT-O_YPOS,r12    ; Auf Y-Pos rechtes Vordergrundbild setzen
        subq    #O_HEIGHT-O_YPOS,r13    ; Auf Y-Pos linkes Vordergrundbild setzen
        loadw   (r12),r2                ; Y-Pos rechtes Vordergrundbild laden
        storew  r2,(r13)                ; Y-Pos linkes Vordergrundbild neu setzen
        movei   #42+MAX_Y+(226*2),r2	; Variable fr unteren Bildschirmrand
        add     r1,r1                   ; Hhe rechtes Vodergrundbild * 2
        sub     r1,r2                   ; neue Y-Pos rechtes Vordergrundbild berechnen
        storew  r2,(r12)                ; Y-Pos rechtes Vordergrundbild neu setzen

	addq	#1,r3			; Neue Breite fr rechtes Vordergrundbild ( 0 + 1 = 1 Phrase)
	shrq	#2,r0			; Neue Breite fr linkes Vordergrundbild (320 / 4 = 80 Phrases)
	addq	#O_IWIDTH-O_YPOS,r12	; Auf Breite rechtes Vordergrundbild setzen
	addq	#O_IWIDTH-O_YPOS,r13	; Auf Breite linkes Vordergrundbild setzen
	storew	r3,(r12)		; Neue Breite rechtes Vordergrundbild schreiben
	storew	r0,(r13)		; Neue Breite linkes Vordergrundbild schreiben		

	addq	#O_TYPE-O_IWIDTH,r12	; Auf Objekt Typ rechtes Vordergrundbild setzen
	addq	#O_TYPE-O_IWIDTH,r13	; Auf Objekt Typ linkes Vordergrundbild setzen
	loadb	(r12),r1		; Objekt Typ rechtes Vordergrundbild laden
	storeb	r1,(r13)		; Objekt Typ linkes Vordergrundbild neu setzen (=Objekt Typ rechtes Vordergrundbild)
	loadw	(r10),r1		; neue Objekt Typ rechtes Vordergrundbild laden
	storeb	r1,(r12)		; Objekt Typ rechtes Vordergrundbild neu setzen
	addq	#2,r10			; Adresse nchste Leveldaten
	store	r10,(r11)		; neue Adresse fr Leveldaten zurckschreiben	
scr_vu3:


************************************************************************
*                Function: oberes Vordergrund Scrolling mit 	       *
*			   Clipping zeichnen   			       *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   14.5.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; In:	x5		$f03f84
;	x6		$f03f88
;	scr_oben	$f03f8C

	movei	#x5,r0			; X-Pos unteres linkes Vordergrundbild
	load	(r0),r13		; Adresse X-Pos unteres linkes Vordergrundbild
	movei	#x6,r0			; X-Pos unteres rechtes Vordergrundbild
	load	(r0),r12		; Adresse X-Pos unteres rechtes Vordergrundbild
	movei	#scr_oben,r0		; Daten fr untere Vordergrundgrafik
	load	(r0),r11		; Adresse Daten fr untere Vordergrundgrafik

	movei	#scr_vo1,r20		; X-Pos nicht durch 4 teilbar, keine Adressen anpassen
        movei   #scr_vo2,r21		; Adresse alles neu setzen
        movei	#scr_vo3,r22		; Ende Scrolling Routine
	
; oberen Vordergrund fr Parallaxscrolling zeichnen
        loadw   (r12),r2                ; X-Pos rechtes Vordergrundbild laden
	subq	#1,r2			; X-Pos verringern
        jump    EQ,(r21)                ; Wenn X-Pos = 0 alles neu setzen
	nop				; wegen Sprungbefehl
	storew	r2,(r12)		; X-Pos rechtes Vordergrundbild schreiben

        loadw   (r13),r2                ; X-Pos linkes Vordergrundbild laden
        subq    #1,r2                   ; X-Pos verringern
        move    r2,r3                   ; X-Pos retten
        shrq    #2,r2                   ; X-Pos / 4
        shlq    #2,r2                   ; X-Pos * 4
        cmp	r2,r3                   ; wenn gleich, dann ist X-Pos durch 4 teilbar
        jump    NE,(r20)	        ; nicht durch 4 teilbar
	nop				; wegen Sprungbefehl

; Clipping vornehmen	
	moveq	#0,r3			; X-Pos neu festlegen (=0)
        move    r13,r14                 ; Adresse retten
        addq    #O_DATA-O_XPOS,r14      ; Auf Adresse linkes Vordergrundbild setzen
        load    (r14),r2                ; Adresse linkes Vordergrundbild laden
        addq    #8,r2                   ; Adresse anpassen
        store   r2,(r14)                ; Adresse linkes Vordergrundbild schreiben

        addq    #O_IWIDTH-O_DATA,r14    ; Adresse Breite linkes Vordergrundbild
        loadw   (r14),r2                ; Breite laden
        subq    #1,r2                   ; Breite um 1 Phrase verringern
        storew  r2,(r14)                ; Breite schreiben

        addq    #O_IWIDTH-O_XPOS,r12    ; Adresse Breite rechtes Vordergrundbild
        loadw   (r12),r2                ; Breite laden
        addq    #1,r2                   ; Breite um 1 Phrase erhhen
        storew  r2,(r12)                ; Breite schreiben
scr_vo1:storew  r3,(r13)                ; X-Pos linkes Vordergrundbild schreiben
	jump	T,(r22)			; Ende Scrolling Routine
	nop				; wegen Sprungbefehl

; Alles neu setzen
scr_vo2:movei   #320,r0                 ; neue X-Pos rechtes Vordergrundbild (=320)
	moveq	#0,r3			; neue X-Pos linkes Vordergrundbild (=0)
        storew  r0,(r12)                ; neue X-Pos rechtes Vordergrundbild schreiben
        storew  r3,(r13)                ; neue X-Pos linkes Vordergrundbild schreiben        
        addq    #O_DATA-O_XPOS,r12      ; Auf Adresse rechtes Vordergrundbild setzen
        addq    #O_DATA-O_XPOS,r13      ; Auf Adresse linkes Vordergrundbild setzen
        load    (r12),r1                ; Adresse rechtes Vordergrundbild laden
        load	(r13),r2		; Adresse linkes Vordergrundbild laden
        sub	r0,r2			; Offset zum Anfang der Grafik berechnen (320 abziehen)
        sub	r0,r2			; dto.
	addq	#8,r2			; Sonst wird neue Startadresse falsch berechnet
        store   r1,(r13)                ; Adresse linker Vordergrund neu setzen (= Adresse rechter Vordergrund)
	store	r2,(r12)		; Adresse rechtes Vordergrundbild neu setzen (=Adresse linker Vordergrund)

	load	(r11),r10		; Adresse fr nchste Leveldaten
	addq	#4,r10			; Adresse auf Hhe setzen
	addq	#O_HEIGHT-O_DATA,r12	; Auf Hhe rechtes Vordergrundbild setzen
	addq	#O_HEIGHT-O_DATA,r13	; Auf Hhe linkes Vordergrundbild setzen
	loadw	(r12),r1		; Hhe rechtes Vordergrundbild laden
	storew	r1,(r13)		; Hhe linkes Vordergrundbild neu setzen (=Hhe rechtes Vordergrundbild)
	loadw	(r10),r1		; neue Hhe rechtes Vordergrundbild laden
	storew	r1,(r12)		; Hhe rechtes Vordergrundbild neu setzen
	addq	#2,r10			; auf nchste Leveldaten setzen

	addq	#1,r3			; Neue Breite fr rechtes Vordergrundbild ( 0 + 1 = 1 Phrase)
	shrq	#2,r0			; Neue Breite fr linkes Vordergrundbild (320 / 4 = 80 Phrases)
	addq	#O_IWIDTH-O_HEIGHT,r12	; Auf Breite rechtes Vordergrundbild setzen
	addq	#O_IWIDTH-O_HEIGHT,r13	; Auf Breite linkes Vordergrundbild setzen
	storew	r3,(r12)		; Neue Breite rechtes Vordergrundbild schreiben
	storew	r0,(r13)		; Neue Breite linkes Vordergrundbild schreiben		

	addq	#O_TYPE-O_IWIDTH,r12	; Auf Objekt Typ rechtes Vordergrundbild setzen
	addq	#O_TYPE-O_IWIDTH,r13	; Auf Objekt Typ linkes Vordergrundbild setzen
	loadb	(r12),r1		; Objekt Typ rechtes Vordergrundbild laden
	storeb	r1,(r13)		; Objekt Typ linkes Vordergrundbild neu setzen (=Objekt Typ rechtes Vordergrundbild)
	loadw	(r10),r1		; neue Objekt Typ rechtes Vordergrundbild laden
	storeb	r1,(r12)		; Objekt Typ rechtes Vordergrundbild neu setzen
	addq	#2,r10			; Adresse nchste Leveldaten
	store	r10,(r11)		; neue Adresse fr Leveldaten zurckschreiben	
scr_vo3:


************************************************************************
*                Function: Neue Gegner aktivieren/		       *
*                          neue Farbpaletten setzen                    *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   14.2.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; In:	obj_gegner	$f03f50		; Startadresse Gegnerdaten fr OP
;	x_pos		$f03f54		; Adresse von x_pos
;	gegner		$f03f58		; Startadresse Gegnerdaten

; R18	Magic Wert Sample Daten
; R19	Magic Wert Color Daten
; R20	Magic Wert gepackte Daten

create_enemy:
	movei	#gegner,r30		; Adresse Gegnersprites
	load	(r30),r14		; Adresse Gegnersprites laden
	movei	#obj_gegner,r0		; Adresse Gegnerdaten fr OP
	load	(r0),r16		; Adresse Gegnerdaten fr OP laden
	movei	#x_pos,r0		; Adresse X-Pos im ges. Spiel
	load	(r0),r10 		; X-Pos im ges. Spiel laden

; Register vorbelegen
	movei	#OBJSIZE,r21		; fr freie Pos. ermitteln
	movei	#create_enemy0,r22	; Sprungadresse
	movei	#create_enemy0_1,r23	; Sprungadresse
	movei	#create_end,r24		; Sprungadresse Ende CRT_ENMY
	movei	#create_color,r25	; Sprungadresse create_color
	movei	#SAMPLE,r18		; Magic Wert Sample Daten
	movei	#COLOR,r19		; Magic Wert Color Daten
	movei	#PACKED,r20		; Magic Wert gepackte Daten

;create_enemy:
	loadw	(r10),r3		; X-Pos im ges. Spiel laden
	addq	#1,r3			; X-Pos im ges. Spiel erhhen
	storew	r3,(r10)		; X-Pos im ges. Spiel schreiben

create_enemy0:
	load	(r14),r0		; X-Pos wo Gegner erscheint laden
	cmpq	#0,r0			; Letzter Gegner ? (0=Ja)
	jump	EQ,(r24)		; Ja, dann Ende GPU-Routine
	cmp	r3,r0			; X-Pos wo Gegner erscheint = X-Pos im ges. Spiel ?
	jump	HI,(r24)		; Nein, dann Ende GPU-Routine
	nop				; Wegen Sprungbefehl

; Neuer Gegner 
create_start:
	addq	#4,r14			; Auf Vorder/Hintergrund Offset setzen
	loadw	(r14),r17		; Vorder/Hintergrund Offset laden
	addq	#2,r14			; Auf Anzahl Spritepos. setzen
	loadw	(r14),r12		; Anzahl Spritepos. laden
	addq	#2,r14			; Auf O_XPOS setzen
	loadw	(r14),r0		; X-Pos Gegner laden
	cmp	r19,r0			; neue Farbpalette setzen? (=4444)
	jump	EQ,(r25)		; Ja
	cmp	r18,r0			; neuen Sample aktivieren? (=3333)
	jr	EQ,create_sample	; Ja	
	cmp	r20,r0			; neue Daten entpacken? (=5555)
	jump	NE,(r23)		; Nein
	nop				; wegen Sprungbefehl

; Neue Daten entpacken
	subq	#4,r14			; auf Zieladresse entpackte Daten setzen
	movei	#ICE_SOURCE,r15		; DSP RAM Adresse Ziel entpackte Daten
	load	(r14),r1		; Zieladresse entpackte Daten laden
	load	(r14+2),r0		; Startadresse gepackte Daten laden
	store	r1,(r15+1)		; Adresse entpackte Daten schreiben
	store	r0,(r15)		; Adresse gepackte Daten schreiben
	jump	T,(r22)			; Weiter mit nchstem Gegner
	addq	#12,r14			; Auf nchsten Gegner setzen

; Neuen Sample aktivieren
create_sample:
	addq	#4,r14			; Auf Adresse Sampledaten setzen
	movei	#sample_daten,r0	; GPU RAM Adresse Start Sampledaten
	load	(r0),r0			; RAM Adresse Start Sampledaten
	load	(r14),r1		; Offset Sampledaten laden
	add	r1,r0			; Offset addieren
	movei	#SAM1_START,r1		; Startadresse Sampleregister 1
	loadp	(r0),r2			; Sampleadressen laden
	storep	r2,(r1)			; Sampleadressen speichern
	jump	T,(r22)			; Weiter mit nchstem Gegner
	addq	#4,r14			; Auf nchsten Gegner setzen

; Neue Farbpalette setzen (Adresse Farbpalette mu durch 8 teilbar sein)
create_color:
	addq	#4,r14			; Auf Adresse Farbpalette setzen
	load	(r14),r0		; Adresse Farbpalette laden
	movei	#CLUT,r1		; Adresse Farbregister des OP
	rept	256/4			; Anzahl Wiederholungen
	loadp	(r0),r2			; 4 Farben lesen
	storep	r2,(r1)			; 4 Farben schreiben
	addq	#8,r0			; Adresse anpassen
	addq	#8,r1			; Adresse anpassen
	endr
	jump	T,(r22)			; Weiter mit nchstem Gegner
	addq	#4,r14			; Auf nchsten Gegner setzen

; Freie Position suchen
; Achtung freie Pos. mssen mit 5 initalisiert werden
create_enemy0_1:
	move	r16,r15			; Startadresse Gegnerdaten fr OP
	add	r17,r15			; Vorder/Hintergrund Offset addieren
	addq	#O_TYPE,r15		; Adresse auf O_TYPE setzen (bei den nchsten wird immer OBJSIZE addiert, damit kommt man automatisch wieder auf O_TYPE)
create_enemy1:
	loadb	(r15),r0		; Objecttyp des Gegners laden (5=freie Position
	cmpq	#5,r0			; Ist Position frei ?
	jr	EQ,create_enemy2_1	; Ja				
	nop				; <== Ohrensausen NOP (20.2.97)
	add	r21,r15			; auf nchste O_TYPE setzen
	subq	#1,r12			; Anzahl Objecte - 1
	jr	NE,create_enemy1	; Wiederhole sol. Anzahl Objekte > 0
	nop				; Wegen Sprungbefehl
	jump	T,(r24)			; Ende wenn keine freie Pos. gefunden wurde
	nop				; Wegen Sprungbefehl

; Neuen Gegner aktivieren	
create_enemy2_1:
	subq	#O_TYPE,r15		; Auf O_XPOS setzen
	rept	72/8			; Anzahl Wiederholungen
	loadp	(r14),r0		; 8 Bytes lesen
	storep	r0,(r15)		; 8 Bytes schreiben
	addq	#8,r14			; Adresse anpassen
	addq	#8,r15			; Adresse anpassen
	endr
	jump	T,(r22)			; Weiter mit nchstem Gegner
	nop
create_end:
	store	r14,(r30)		; neue Adresse Gegnersprites schreiben


************************************************************************
*                Function: Kollision mit festen Hintergrnden          *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   24.6.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; Achtung !!! Die Hhe und Breite des R-Type sind direkt im Programm
; angegeben.
; Es werden die 4 Ecken des R-Type auf Kollisionen mit einer Hintergrund-
; grafik getestet und bei einer Kollision die Energie des R-Type
; verringert.
; Registerbelegung
; R29	640 Bytes pro Zeile / 8 fr Multiplikation
; R28	Offset zur nchsten Kurvenliste
; R27	Sprungadresse Collb6
; R25	Sprungadresse Collb1
; R23	Anzahl Hintergrundteile
; R24	Sprungadresse Collb10
; R21	Offset zu den nchsten Spritedaten (OBJSIZE)
; R18	Kurvenliste fr R-Type Kollision retten
; R17	Offset zur nchsten Kurvenliste * 4
; R16	Startadresse Spritedaten
; R15	Energieabzug R-Type init
; R14	Arbeitsregister
; R5	Y-Pos + Hhe R-Type
; R4	X-Pos + Breite R-Type
; R3	Y-Pos R-Type
; R2	X-Pos R-Type
; R0	Arbeitsregister

collb:	movei	#80,r29			; 640 Bytes pro Zeile / 8 fr Multiplikation (nur Wort * Wort multiplikation, des. max 65535. 320 Byte weil die Y-Pos bereits * 2 vorliegt)
	movei	#collb6,r27		; Sprungadresse Pixel testen
	movei	#OBJSIZE,r21		; Offset zu den nchsten Spritedaten
	movei	#collb1,r25		; Sprungadresse
	movei	#collb10,r24		; Sprungadresse
	movei	#64,r28			; Offset zur nchsten Kurvenliste
	movei	#64*4,r17		; Offset zur nchsten Kurvenliste * 4
	moveq	#0,r15			; Energieabzug R-Type initalisieren

	movei	#r_type_kurve1,r0	; GPU-Ram Adresse Kollisionskurven R-Type
	load	(r0),r20		; RAM Adresse Kollisionskurven R-Type

	movei	#x,r0			; GPU-RAM Adresse X-Pos R-Type
	load	(r0),r22		; RAM Adresse X-Pos R-Type
	loadw	(r22),r2		; X-Pos R-Type laden
	addq	#O_YPOS-O_XPOS,r22	; Adresse Y-Pos R-Type
	loadw	(r22),r3		; Y-Pos R-Type laden
	shrq	#1,r3			; Y-Pos R-Type / 2
	addq	#2,r2			; X-Pos + 2
	addq	#2,r3			; Y-Pos + 2
	move	r2,r4			; fr X-Pos + Breite
	move	r3,r5			; fr Y-Pos + Breite
	addq	#32-4,r4		; X-Pos + Breite - 4 (was #36-4,r4 JKD)
	addq	#16-4,r5		; Y-Pos + Hhe - 4

	movei	#x5,r0			; GPU-RAM Adresse X-Pos Hintergrundgrafik
	load	(r0),r16		; Adresse X-Pos Hintergrundgrafik
	
	moveq	#4,r23			; Anzahl Hintergrundteile
collb1:	move	r20,r18			; Adresse Kurvenliste retten
	move	r16,r14			; Adresse Hintergrundgrafik retten
	addq	#O_TYPE-O_XPOS,r14	; Adresse auf Objekt Typ setzen
	loadb	(r14),r0		; Objekt Typ laden
	cmpq	#5,r0			; Objekt aktiv? (5 = nein)
	jump	EQ,(r24)		; nein, dann weiter mit nchster Hintergrundgrafik

	subq	#O_TYPE-O_XPOS,r14	; Adresse auf X-Pos setzen
	loadw	(r14),r10		; X-Pos laden
	load	(r14+1),r19		; Adresse akt. Spritedaten laden
	addq	#O_YPOS-O_XPOS,r14	; Adresse Y-Pos Hintergrundgrafik
	loadw	(r14),r11		; Y-Pos laden
	shrq	#1,r11			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r14	; Adresse Hhe Hintergrundgrafik
	loadw	(r14),r13		; Hhe laden
	addq	#O_IWIDTH-O_HEIGHT,r14	; Adresse Breite Hintergrundgrafik
	loadw	(r14),r12		; Breite in Phrases laden
	shlq	#2,r12			; Breite in Pixel berechnen

	add	r11,r13			; Y-Pos + Hhe berechnen
	add	r10,r12			; X-Pos + Breite berechnen

; linke obere Ecke			
	cmp	r12,r2			; X-Pos R-Type > X-Pos Hintergrund + Breite
	jr	HI,collb2		; Ja, keine Kollision	
	cmp	r13,r3			; Y-Pos R-Type > Y-Pos Hintergrund + Hhe
	jr	HI,collb2		; Ja, keine Kollision
	cmp	r2,r10			; X-Pos Gegner > X-Pos R-Type
	jr	HI,collb2		; Ja, keine Kollision
	cmp	r3,r11			; Y-Pos Gegner > Y-Pos R-Type
	jr	HI,collb2		; Ja, keine Kollision
	nop

	movei	#collb2,r30		; Rcksprungadresse
	move	r2,r0			; X-Pos R-Type retten
	jump	T,(r27)			; UP Pixel testen
	move	r3,r1			; Y-Pos R-Type retten

; rechte obere Ecke	
collb2:	add	r28,r18			; auf nchste Kurvenliste setzen
	cmp	r12,r4			; X-Pos R-Type > X-Pos Hintergrund + Breite
	jr	HI,collb3		; Ja, keine Kollision	
	cmp	r13,r3			; Y-Pos R-Type > Y-Pos Hintergrund + Hhe
	jr	HI,collb3		; Ja, keine Kollision
	cmp	r4,r10			; X-Pos Gegner > X-Pos R-Type
	jr	HI,collb3		; Ja, keine Kollision
	cmp	r3,r11			; Y-Pos Gegner > Y-Pos R-Type
	jr	HI,collb3		; Ja, keine Kollision
	nop

	movei	#collb3,r30		; Rcksprungadresse
	move	r4,r0			; X-Pos R-Type retten
	jump	T,(r27)			; UP Pixel testen
	move	r3,r1			; Y-Pos R-Type retten

; linke untere Ecke	
collb3:	add	r28,r18			; auf nchste Kurvenliste setzen
	cmp	r12,r2			; X-Pos R-Type > X-Pos Hintergrund + Breite
	jr	HI,collb4		; Ja, keine Kollision	
	cmp	r13,r5			; Y-Pos R-Type > Y-Pos Hintergrund + Hhe
	jr	HI,collb4		; Ja, keine Kollision
	cmp	r2,r10			; X-Pos Gegner > X-Pos R-Type
	jr	HI,collb4		; Ja, keine Kollision
	cmp	r5,r11			; Y-Pos Gegner > Y-Pos R-Type
	jr	HI,collb4		; Ja, keine Kollision
	nop

	movei	#collb4,r30		; Rcksprungadresse
	move	r2,r0			; X-Pos R-Type retten
	jump	T,(r27)			; UP Pixel testen
	move	r5,r1			; Y-Pos R-Type retten

; rechte untere Ecke	
collb4: add	r28,r18			; auf nchste Kurvenliste setzen
	cmp	r12,r4			; X-Pos R-Type > X-Pos Hintergrund + Breite
	jump	HI,(r24)		; Ja, keine Kollision	
	cmp	r13,r5			; Y-Pos R-Type > Y-Pos Hintergrund + Hhe
	jump	HI,(r24)		; Ja, keine Kollision
	cmp	r4,r10			; X-Pos Gegner > X-Pos R-Type
	jump	HI,(r24)		; Ja, keine Kollision
	cmp	r5,r11			; Y-Pos Gegner > Y-Pos R-Type
	jump	HI,(r24)		; Ja, keine Kollision
	nop

	move	r24,r30			; Rcksprungadresse
	move	r4,r0			; X-Pos R-Type retten
	move	r5,r1			; Y-Pos R-Type retten

; R-Type im Grafikbereich, Pixel auf schwarz testen	
; In:	R0	X-Pos R-Type
;	R1	Y-Pos R-Type
;	R30	Rcksprungadresse

collb6:	move	r10,r8			; X-Pos Hintergrund retten
	move	r11,r9			; Y-Pos Hintergrund retten
	sub	r9,r1			; Y-Pos des Treffer ermitteln (als Offset vom Start der Grafik)

collb7:
	cmpq	#0,r8			; X-Pos linkes Teil < 0 ?
	jr	PL,collb8		; Nein (Achtung !!! PipeLine)
	mult	r29,r1			; Y-Pos * 640 Bytes pro Zeile / 8
	neg	r8			; X-Pos linkes Teil negieren
	jr	T,collb9		; Achtung !!! PipeLine
	add	r8,r0			; X-Pos linkes Teil + X-Pos R-Type
	
collb8:	sub	r8,r0			; X-Pos Hintergrund - X-Pos R-Type, weil im 2 Bild ja nicht von 0 angefangen wird zu zhlen
collb9:	add	r0,r0			; X-Pos * 2
	add	r19,r0			; Start der Grafik + X-Pos berechnen
	shlq	#3,r1			; Y-Pos * 8 damit es eine multiplikation mit 640 ergibt
	add	r0,r1			; X-Pos + Y-Pos berechnen

	loadw	(r1),r0			; Pixel laden
	cmpq	#0,r0			; Ist Pixel schwarz ?
	jump	EQ,(r30)		; Keine Kollision (RTS)
	nop

; Kollision erkannt
	addq	#1,r15			; Energieverlust R-Type +1

	addq	#O_TYPE-O_YPOS,r22	; Adresse auf Objekt Typ setzen
	moveq	#0,r0			; neuer Objekt Typ R-Type
	storeb	r0,(r22)		; neuer Objekt Typ schreiben
	
	addq	#40-O_TYPE,r22		; Adresse Start Spritedaten
	movei	#r_type_anim1,r0	; GPU-Ram Adresse Animationsliste R-Type
	load	(r0),r0			; RAM Adresse Animationsliste R-Type	
	store	r0,(r22)		; Adresse akt. Animationsliste R-Type schreiben
	addq	#4,r22			; auf Adresse Animationsliste R-Type setzen
	store	r0,(r22)		; Adresse Animationsliste R-Type schreiben		
	addq	#4,r22			; Adresse auf Start Kurvenliste
	store	r18,(r22)		; neuer Start Kurvenliste schreiben

;<<<<<<<<<<<<<< Trefferstelle rot markieren >>>>>>>>>>>>>>
;	movei	#$F0FF,r0		; Treffer rot markieren
;	storew	r0,(r1)

;	movei	#pause,r0
;	load	(r0),r0
;	moveq	#1,r1
;	storew	r1,(r0)
;<<<<<<<<<<<<<<<<<<<<<<<<< Ende >>>>>>>>>>>>>>>>>>

	jr	T,collb11		; Ende Kollisionsabfrage
	nop
collb10:
	add	r17,r20			; auf nchste Kurvenliste fr R-Type Kollision setzen
	subq	#1,r23			; Anzahl Teile - 1
	jump	NE,(r25)		; Wiederholen sol. nicht 0
	add	r21,r16			; auf nchsten Sprite setzen
collb11:


************************************************************************
*                Function: Kollisionsabfrage fr NATIVE                *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   1.6.97                        *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; In:	TOTAL_OBJS	$f03f4c
; 	obj_enemy	$f03f50


; Registerbelegung
; R31	Wert Gegner ist nicht aktiv
; R30	Adresse Gegnerdaten
; R29	Adresse Schudaten
; R28	Score Player 1
; R27	Offset ob Gegner zerstrbar ist von Objekt Typ
; R26	Anzahl Gegner
; R25	Anzahl Schsse
; R24	Sprungadresse Coll_12
; R23	Sprungadresse Coll_11
; R22	Sprungadresse Create_new1
; R21	Gre eines Objektes in Byte (OBJSIZE)
; R20	Offset zu X-Pos Gegner von Energie 
; R18	Sprungadresse Coll_1
; R17	Sprungadresse Coll_6_1
; R16	Sprungadresse Create_new
; R15	Energie R-Type (von vorheriger Kollisionsabfrage initalisiert)
; R14	Arbeitsregister
; R13	Y-Pos + Hhe R-Type
; R12	X-Pos + Breite R-Type
; R11	Y-Pos R-Type
; R10	X-Pos R-Type
; R9	Y-Pos + Hhe Schu
; R8	X-Pos + Breite Schu
; R7	Y-Pos Schu
; R6	X-Pos Schu
; R5	Y-Pos + Hhe Gegner
; R4	X-Pos + Breite Gegner
; R3	Y-Pos Gegner
; R2	X-Pos Gegner
; R1	Wert ob Gegner zerstrbar ist
; R0	Arbeitsregister
; Registerbank 2
; R0	Offset ob Gegner zerstrbar ist
; R1	Wert Gegner ist nicht zerstrbar

coll:	movei	#OBJSIZE,r21		; **** evtl. von vorher schon gesetzt
	movei	#56-O_TYPE,r27		; Offset ob Gegner zerstrbar ist
	movei	#TOTAL_ENEMY,r26	; Anzahl Gegner
	movei	#56-O_XPOS,r20		; Offset X-Pos Gegner
	
	movei	#obj_enemy,r0		; GPU-Ram Adresse Start Gegnersprites
	load	(r0),r30		; Start Gegnersprites laden
	
	movei	#x,r0			; GPU-Ram Adresse X-Pos R-Type
	load	(r0),r28		; RAM Adresse X-Pos R-Type
	loadw	(r28),r10		; X-Pos R-Type laden
	addq	#O_YPOS-O_XPOS,r28	; Adresse auf Y-Pos R-Type setzen
	loadw	(r28),r11		; Y-Pos R-Type laden
	shrq	#1,r11			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r28	; Adresse auf Hhe R-Type setzen
	loadw	(r28),r13		; Hhe R-Type laden
	addq	#O_DWIDTH-O_HEIGHT,r28	; Adresse auf Breite R-Type setzen
	loadw	(r28),r12		; Breite R-Type in Phrases laden
	shlq	#2,r12			; Breite R-Type in Pixeln berechnen
	add	r11,r13			; Y-Pos + Hhe
	add	r10,r12			; X-Pos + Breite

	movei	#create_new1,r22	; Sprungadresse
	movei	#coll11,r23		; Sprungadresse
	movei	#coll12,r24		; Sprungadresse
	movei	#coll1,r18		; Sprungadresse
	movei	#coll6_1,r17		; Sprungadresse
	movei	#create_new,r16		; Sprungadresse
	moveq	#5,r31			; Wert Gegner ist nicht aktiv
	
	movei	#score1,r0		; GPU RAM Adresse Score Player 1
	load	(r0),r0			; RAM Adresse Score Player 1
	load	(r0),r28		; Score Player 1 laden

	movei	#56-O_HEIGHT,r0		; Offset ob Gegner zerstrbar ist
	moveta	r0,r0			; In 2 Registerbank speichern
	movei	#DESTROY,r0		; Wert Gegner nicht zerstrbar
	moveta	r0,r1			; In 2 Registerbank speichern

	addq	#O_TYPE,r30		; Adresse auf Objekt Typ setzen
coll1:	move	r30,r14			; Adresse retten
	loadb	(r14),r0		; Objekt Typ laden
	cmpq	#5,r0			; 5 = Gegner ist nicht aktiv
	jump	EQ,(r24)		; Gegner ist nicht aktiv
	nop

	add	r27,r14			; Adresse ob Gegner zerstrbar ist	
	loadw	(r14),r1		; Wert ob Gegner zerstrbar ist
	movefa	r1,r0			; Wert Gegner nicht zerstrbar laden
	cmp	r0,r1			; DESTROY = Gegner ist nicht zerstrbar
	jump	EQ,(r24)		; Gegner ist nicht zerstrbar
	nop

	load	(r14+3),r4		; Breite Gegner in Pixel laden
	sub	r20,r14			; Adresse auf X-Pos Gegner setzen
	loadw	(r14),r2		; X-Pos Gegner laden
	add	r2,r4			; X-Pos + Breite berechnen
	addq	#O_YPOS-O_XPOS,r14	; Adresse auf Y-Pos Gegner setzen
	loadw	(r14),r3		; Y-Pos Gegner laden
	shrq	#1,r3			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r14	; Adresse auf Hhe Gegner setzen
	loadw	(r14),r5		; Hhe Gegner laden
	add	r3,r5			; Y-Pos + Hhe berechnen

; Kollision R-Type mit Gegner an X-Achse ?
	cmp	r2,r10			; X-Pos R-Type > X-Pos Gegner ?
	jr	HI,coll2		; Ja

; X-Pos Gegner grer	
	cmp	r12,r2			; X-Pos Gegner > X-Pos + Breite R-Type ?
	jr	HI,coll6		; Ja, Keine Kollision
	nop
	jr	T,coll3			; weiter mit Y-Achse

; X-Pos R-Type grer
coll2:	cmp	r4,r10			; X-Pos R-Type > X-Pos + Breite Gegner ?
	jr	HI,coll6		; Ja, keine Kollision

; Kollision R-Type mit Gegner an Y-Achse ?
coll3:	cmp	r3,r11			; Y-Pos R-Type > Y-Pos Gegner ?
	jr	HI,coll4		; Ja	

; Y-Pos Gegner grer	
	cmp	r13,r3			; Y-Pos Gegner > Y-Pos + Hhe R-Type ?
	jr	HI,coll6		; Ja, keine Kollision	
	nop
	jr	T,coll5			; Kollision hat stattgefunden	

; Y-Pos R-Type grer
coll4:	cmp	r5,r11			; Y-Pos R-Type > Y-Pos + Hhe Gegner ?
	jr	HI,coll6		; Ja, keine Kollision
	nop

; Kollision R-Type mit Gegner
coll5:	addq	#1,r15			; Energieverlust R-Type +1
	subq	#1,r1			; bentigte Feuerkraft Gegner - 1
coll6:	cmpq	#0,r1			; bentigte Feuerkraft Gegner < 0 ?
	jump	MI,(r16)		; < 0, Gegner wurde zerstrt
	nop

	movei	#obj_shot,r0		; GPU-Ram Adresse Start Schudaten
	load	(r0),r29		; Start Schudaten laden
	moveq	#TOTAL_SHOT1,r25	; Anzahl Schsse
; Kollision mit Schssen testen
coll6_1:
	move	r29,r19			; Startadr. Schudaten retten
	addq	#O_TYPE,r19		; Adresse auf Objekt Typ setzen
	loadb	(r19),r0		; Objekt Typ laden
	cmpq	#5,r0			; 5 = Schu ist nicht aktiv
	jump	EQ,(r23)		; Schu ist nicht aktiv
	nop
	
	subq	#O_TYPE-O_XPOS,r19	; Adresse auf X-Pos Schu setzen
	loadw	(r19),r6		; X-Pos Schu laden
	addq	#O_YPOS-O_XPOS,r19	; Adresse auf Y-Pos Schu setzen
	loadw	(r19),r7		; Y-Pos Schu laden
	shrq	#1,r7			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r19	; Adresse auf Hhe Schu setzen
	loadw	(r19),r9		; Hhe Schu laden
	addq	#O_DWIDTH-O_HEIGHT,r19	; Adresse auf Breite setzen
	add	r7,r9			; Y-Pos + Hhe berechnen
	loadw	(r19),r8		; Breite in Phrases laden
	shlq	#2,r8			; Breite in Pixeln berechnen
	add	r6,r8			; X-Pos + Breite berechnen
	
; Kollision Schu mit Gegner an X-Achse ?
	cmp	r2,r6			; X-Pos Schu > X-Pos Gegner ?
	jr	HI,coll7		; Ja, dann von X-Pos Gegner ausgehen
	nop

; X-Pos Gegner grer	
	cmp	r8,r2			; X-Pos Gegner > X-Pos + Breite Schu ? 
	jump	HI,(r23)		; Ja, keine Kollision	
	nop
	jr	coll8			; weiter mit Y-Achse
	cmp	r3,r7			; Y-Pos Schu > Y-Pos Gegner ?

; X-Pos Schu grer
coll7:	cmp	r4,r6			; X-Pos Schu > X-Pos + Breite Gegner ?
	jump	HI,(r23)		; Ja, keine Kollision (coll11)
	nop

; Kollision Schu mit Gegner an Y-Achse ?
	cmp	r3,r7			; Y-Pos Schu > Y-Pos Gegner ?
coll8:	jr	HI,coll9		; Ja, dann von Y-Pos Gegner ausgehen	
	nop

; Y-Pos Gegner grer	
	cmp	r9,r3			; Y-Pos Gegner > Y-Pos + Breite Schu ?
	jump	HI,(r23)		; Ja, keine Kollision (coll11)
	nop
	jr	coll10			; Ende Kollisionsabfrage	

; Y-Pos Schu grer
coll9:	cmp	r5,r7			; Y-Pos Schu > Y-Pos + Breite Gegner ?
	jr	HI,coll11		; Ja, keine Kollision
	nop

coll10:	addq	#O_TYPE-O_DWIDTH,r19	; Adresse auf Objekt Typ setzen
	add	r27,r19			; Adresse Feuerkraft des Schusses
	loadw	(r19),r0		; Feuerkraft des Schusses laden
	move	r1,r8			; bentigte Feuerkraft Gegner retten
	sub	r0,r1			; bentigte Feuerkraft Gegner - Feuerkraft des Schusses

; Die Formel fr neue Schustrke wurde von Chefchen beim Singen von
; Sunset Boulevard ermittelt.	
	sub	r8,r0			; Feuerkraft Schu - Energie Gegner
	subq	#1,r0			; Weil Gegner auch auf 0 sein kann
	jr	PL,coll10_1		; > 0, Schu wurde nicht zerstrt
	storew	r0,(r19)		; neue Feuerkraft Schu schreiben

	sub	r27,r19			; Adresse auf Objekt Typ setzen
	storeb	r31,(r19)		; Schu nicht mehr aktiv (=5)

coll10_1:	
	cmpq	#0,r1			; < 0, Gegner wurde zerstrt
	jump	MI,(r16)		; Ja, dann Folgesprite aktivieren

coll11:	subq	#1,r25			; Anzahl Schsse - 1
	jump	NE,(r17)		; Wiederholen fr Anzahl Schsse
	add	r21,r29			; auf nchste Schudaten setzen
	movefa	r0,r0			; Offset zur bentigten Feuerkraft
	add	r0,r14			; Adresse bentigte Feuerkraft
	storew	r1,(r14)		; bentigte Feuerkraft Gegner zurckschreiben

coll12:	subq	#1,r26			; Anzahl Gegner - 1
	jump	NE,(r18)		; Wiederholen fr Anzahl Gegner
	add	r21,r30			; + OBJSIZE, dann kommt man beim nchsten Gegner auf O_TYPE

	movei	#create_new4,r24	; Ende Kollisionsabfrage
	movei	#x,r0			; GPU-Ram Adresse X-Pos R-Type
	load	(r0),r0			; RAM Adresse X-Pos R-Type
	move	r0,r14			; RAM-Adresse X-Pos R-Type retten
; <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<	
	addq	#O_TYPE-O_XPOS,r0	; Adresse auf Objekt Type setzen
	loadb	(r0),r1			; Objekt Type R-Type laden
	cmpq	#6,r1			; R-Type aktiv ( 6 = Ja ) ?	
	jump	NE,(r24)		; Ende Kollisionsabfrage, da R-Type unverwundbar ist
	move	r14,r0			; Adresse auf X-Pos setzen
; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>	
	add	r20,r0			; Offset addieren zur Energie R-Type
	loadw	(r0),r1			; Energie R-Type laden
	sub	r15,r1			; verlorene Energie abziehen
	jr	MI,coll13		; R-Type explodiert, wenn Energie < 0
	storew	r1,(r0)			; Energie R-Type zurckschreiben
	jump	T,(r24)			; Ende Kollisionsabfrage
	nop
; R-Type inaktivieren und Explosion aktivieren
coll13:	movei	#life_player1,r0	; GPU-RAM Adresse Anzahl Leben Player 1
	load	(r0),r0			; RAM Adresse Anzahl Leben Player 1
	loadw	(r0),r1			; Anzahl Leben Player 1 laden
	subq	#1,r1			; Anzahl Leben Player 1 verringern
	storew	r1,(r0)			; Anzahl Leben Player 1 schreiben
	move	r10,r2			; X-Pos R-Type fr Explosion
	move	r11,r3			; Y-Pos R-Type fr Explosion
	addq	#O_HEIGHT-O_XPOS,r14	; Adresse auf Hhe setzen

; Neuen Folgesprite aktivieren
create_new:	
	shlq	#1,r3			; Y-Pos Gegner * 2
	movei	#obj_gegner,r0		; Adresse Gegnerdaten fr OP
	load	(r0),r6			; Adresse Gegnerdaten fr OP laden

	addq	#O_TYPE-O_HEIGHT,r14	; Adresse auf O_TYPE setzen
	storeb	r31,(r14)		; Gegner nicht mehr aktiv/R-Type unverwundbar
	
	movei	#58-O_TYPE,r0		; Offset Punkte fr Gegner
	add	r0,r14			; Adresse Punkte fr Gegner
	loadw	(r14),r0		; Punkte laden

	addq	#2,r14			; Offset Adresse Daten Folgesprite
	load	(r14),r14		; Adresse Daten Folgesprite laden                
	cmpq	#0,r14			; Neue Folgesprites aktivieren (0 = Nein)
	jump	EQ,(r24)		; Nein
	add	r0,r28			; Punkte zu Score Player 1 addieren

create_new1:
	load	(r14),r0		; X-Pos wo neuer Sprite erscheint laden
	cmpq	#0,r0			; Letzter neuer Sprite ? (0 = Ja)
	jump	EQ,(r24)		; Ja, dann weiter mit nchstem Gegner
	nop				; Wegen Sprungbefehl

; Neuer Gegner 
	addq	#4,r14			; Auf Vorder/Hintergrund Offset setzen
	loadw	(r14),r19		; Vorder/Hintergrund Offset laden
	addq	#2,r14			; Auf Anzahl Spritepos. setzen
	loadw	(r14),r9		; Anzahl Spritepos. laden
	addq	#2,r14			; Auf O_XPOS setzen
	
; Freie Position suchen (freie Pos. mssen mit 5 initalisiert sein)
	move	r6,r8			; Startadresse Gegnerdaten fr OP
	add	r19,r8			; Vorder/Hintergrund Offset addieren
	addq	#O_TYPE,r8		; Adresse auf O_TYPE setzen (bei den nchsten wird immer OBJSIZE addiert, damit kommt man automatisch wieder auf O_TYPE)
create_new2:
	loadb	(r8),r0			; Objecttyp des Gegners laden (5=freie Position
	cmpq	#5,r0			; Ist Position frei ?
	jr	EQ,create_new3		; Ja				
	nop				; <== Ohrensausen NOP (20.2.97)
	subq	#1,r9			; Anzahl Objecte - 1
	jr	NE,create_new2		; Wiederhole sol. Anzahl Objekte > 0
; **** Achtung wird noch ausgefhrt wegen PipeLine **********************
	add	r21,r8			; auf nchste O_TYPE setzen
	jump	T,(r24)			; Ende wenn keine freie Pos. gefunden wurde
	nop				; Wegen Sprungbefehl

; Neuen Gegner aktivieren	
create_new3:
	subq	#O_TYPE,r8		; Auf O_XPOS setzen
	
	loadw	(r14),r0		; X-Pos neuer Sprite laden
	add	r2,r0			; X-Pos des zerstrten Gegners addieren
	storew	r0,(r8)			; neue X-Pos schreiben
	addq	#2,r14			; Auf O_YPOS setzen
	addq	#2,r8			; Auf O_YPOS setzen

	loadw	(r14),r0		; Y-Pos neuer Sprite laden
	add	r3,r0			; Y-Pos des zerstrten Gegners addieren
	storew	r0,(r8)			; neue X-Pos schreiben
	addq	#2,r14			; Auf O_DATA setzen
	addq	#2,r8			; Auf O_DATA setzen
	
	load	(r14),r0		; Startadresse Spritedaten laden
	store	r0,(r8)			; Startadresse Spritedaten schreiben		
	addq	#4,r14			; Adresse anpassen
	addq	#4,r8			; Adresse anpassen

	rept	64/8			; Anzahl Wiederholungen
	loadp	(r14),r0		; 8 Bytes lesen
	storep	r0,(r8)			; 8 Bytes schreiben
	addq	#8,r14			; Adresse anpassen
	addq	#8,r8			; Adresse anpassen
	endr

	jump	T,(r22)			; Weiter mit nchstem Gegner
	nop
create_new4:
	movei	#score1,r0		; Adresse GPU RAM Score Player 1           
	load	(r0),r0			; RAM Adresse Score Player 1 laden                  
	store	r28,(r0)		; Score Player 1 schreiben                




************************************************************************
*                Function: Geldroutine fr NATIVE                      *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   9.8.97                        *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; Registerbelegung
; R30	Adresse Extrasprites
; R29	Offset Geld fr Extra
; R28	Adresse Geld Player 1
; R27	Geld Player 1
; R26	Anzahl Extras
; R25	Wert Objekt nicht aktiv
; R24	Sprungadresse Extra1
; R23	Sprungadresse Extra6
; R21	Gre eines Objektes in Byte
; R10	X-Pos R-Type
; R11	Y-Pos R-Type
; R12	X-Pos R-Type + Breite R-Type
; R14	Adresse Start Extrasprites
; R13	Y-Pos R-Type + Hhe R-Type
; R5	Y-Pos Extra + Hhe Extra
; R4	X-Pos Extra + Breite Extra
; R3	Y-Pos Extra
; R2	X-Pos Extra
; R1	Arbeitsregister
; R0	Arbeitsregister

extra:	movei	#OBJSIZE,r21		; Gre eines Objektes in Byte
	movei	#58-O_TYPE,r29		; Offset Geld fr Extra
	movei	#obj_extra,r0		; GPU-Ram Adresse Start Extrasprites
	load	(r0),r30		; Ram Adresse Start Extrasprites
	
	movei	#money_player1,r0	; GPU-Ram Adresse Geld Player 1
	load	(r0),r28		; Ram Adresse Geld Player 1
	loadw	(r28),r27		; Geld Player 1 laden
	
	moveq	#TOTAL_EXTRA,r26	; Anzahl Extras
	moveq	#5,r25			; Wert Objekt nicht aktiv
	movei	#extra1,r24		; Sprungadresse
	movei	#extra6,r23		; Sprungadresse
			
	movei	#x,r0			; GPU-Ram Adresse X-Pos R-Type
	load	(r0),r1			; Ram Adresse X-Pos R-Type
	loadw	(r1),r10		; X-Pos R-Type laden
	addq	#O_YPOS-O_XPOS,r1	; Adresse auf Y-Pos R-Type setzen
	loadw	(r1),r11		; Y-Pos R-Type laden
	shrq	#1,r11			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r1	; Adresse auf Hhe R-Type setzen
	loadw	(r1),r13		; Hhe R-Type laden
	addq	#O_DWIDTH-O_HEIGHT,r1	; Adresse auf Breite R-Type setzen
	loadw	(r1),r12		; Breite R-Type in Phrases laden
	shlq	#2,r12			; Breite R-Type in Pixeln berechnen
	add	r11,r13			; Y-Pos + Hhe
	add	r10,r12			; X-Pos + Breite

extra1:	move	r30,r14			; Adresse Extrasprites retten
	addq	#O_TYPE,r14		; Adresse auf Objekt Typ setzen
	loadb	(r14),r0		; Objekt Typ laden
	cmpq	#5,r0			; 0 = Extra ist nicht aktiv
	jump	EQ,(r23)		; Extra ist nicht aktiv
	
	subq	#O_TYPE-O_XPOS,r14	; Adresse auf X-Pos setzen
	loadw	(r14),r2		; X-Pos Extra laden 
	addq	#O_YPOS-O_XPOS,r14	; Adresse auf Y-Pos setzen
	loadw	(r14),r3		; Y-Pos Extra laden
	shrq	#1,r3			; Y-Pos / 2
	addq	#O_HEIGHT-O_YPOS,r14	; Adresse auf Hhe Extra setzen
	loadw	(r14),r5		; Hhe Extra laden
	addq	#O_DWIDTH-O_HEIGHT,r14	; Adresse auf Breite Extra setzen
	loadw	(r14),r4		; Breite Extra in Phrases laden
	shlq	#2,r4			; Breite R-Type in Pixeln berechnen
	add	r3,r5			; Y-Pos + Hhe
	add	r2,r4			; X-Pos + Breite
	
; Kollision Extra mit Gegner an X-Achse?
	cmp	r2,r10			; X-Pos R-Type > X-Pos Extra ?
	jr	HI,extra2		; Ja
	
; X-Pos Extra grer
	cmp	r12,r2			; X-Pos Extra > X-Pos + Breite R-Type	
	jump	HI,(r23)		; Ja, keine Kollision
	nop
	jr	T,extra3		; weiter mit Y-Achse
	
; X-Pos R-Type grer	
extra2:	cmp	r4,r10			; X-Pos R-Type > X-Pos + Breite Extra
	jr	HI,extra6		; Ja, keine Kollision
	
; Kollision R-Type mit Extra an Y-Achse?
extra3:	cmp	r3,r11			; Y-Pos R-Type > Y-Pos Extra?
	jr	HI,extra4		; Ja, keine Kollision
	
; Y-Pos Extra grer
	cmp	r13,r3			; Y-Pos Extra > Y-Pos + Hhe R-Type?
	jr	HI,extra6		; Ja, keine Kollision
	nop
	jr	T,extra5		; Kollision hat stattgefunden
	
; Y-Pos R-Type grer
extra4:	cmp	r5,r11			; Y-Pos R-Type > Y-Pos + Hhe Extra?
	jr	HI,extra6		; Ja, keine Kollision
	nop
	
; Kollision R-Type mit Extra
extra5:	addq	#O_TYPE-O_DWIDTH,r14	; Adresse auf Objekt Typ setzen
	storeb	r25,(r14)		; Extra nicht mehr aktiv
	add	r29,r14			; Adresse auf Geld fr Extra
	loadw	(r14),r0		; Geld fr Extra laden
	add	r0,r27			; Geld fr Extra zu ges. Geld addieren
extra6:	subq	#1,r26			; Anzahl Extras - 1
	jump	NE,(r24)		; Wiederholen fr Anzahl Extras
	add	r21,r30			; auf nchstes Extra setzen

	storew	r27,(r28)		; Geld Player 1 zurckschreiben


************************************************************************
*                Function: Schuverwaltung fr NATIVE                  *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   10.7.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
shoot:	movei	#shoot4,r22		; Ende Schuverwaltung
	movei	#shoot_count,r0		; GPU RAM Adresse Schucounter
	load	(r0),r24		; RAM Adresse Schucounter
	load	(r24),r25		; Schucounter laden
	subq	#1,r25			; Schucounter verringern
	jump	NE,(r22)		; Ende Schuverwaltung sol > 0
	nop	

	moveq	#SHOOT_SPEED,r25	; Schucounter neu setzen
	movei	#OBJSIZE,r21		; Gre eines Objektes in Byte
	movei	#shoot1,r23		; Sprungadresse
	movei	#shoot_data1,r0		; GPU RAM Adresse Schu Player 1
	load	(r0),r1			; RAM Adresse Schudaten Player 1
	load	(r1),r14		; Adresse Schudaten Player 1 laden
	cmpq	#0,r14			; 0 = kein Schu von Player 1 abgefeuert
	jump	EQ,(r22)		; Ende Schuverwaltung
	nop
	
; Neuen Schu aktivieren
	moveq	#0,r0			; Var. init
	store	r0,(r1)			; Schudaten Player 1 lschen
	movei	#obj_gegner,r0		; Adresse Gegnerdaten fr OP
	load	(r0),r6			; Adresse Gegnerdaten fr OP laden

	movei	#x,r0			; GPU-Ram Adresse X-Pos R-Type
	load	(r0),r1			; RAM Adresse X-Pos R-Type
	loadw	(r1),r10		; X-Pos R-Type laden
	addq	#O_YPOS-O_XPOS,r1	; Adresse auf Y-Pos R-Type setzen
	loadw	(r1),r11		; Y-Pos R-Type laden

shoot1:	load	(r14),r0		; X-Pos wo neuer Sprite erscheint laden
	cmpq	#0,r0			; Letzter neuer Sprite ? (0=Ja)
	jump	EQ,(r22)		; Ja, dann Ende Schuverwaltung
	nop				; Wegen Sprungbefehl

; Neuer Gegner 
	addq	#4,r14			; Auf Vorder/Hintergrund Offset setzen
	loadw	(r14),r1		; Vorder/Hintergrund Offset laden
	addq	#2,r14			; Auf Anzahl Spritepos. setzen
	loadw	(r14),r2		; Anzahl Spritepos. laden
	addq	#2,r14			; Auf O_XPOS setzen
	
	move	r6,r8			; Startadresse Gegnerdaten fr OP retten
	add	r1,r8			; Vorder/Hintergrund Offset addieren
	addq	#O_TYPE,r8		; Adresse auf O_TYPE setzen (bei den nchsten wird immer OBJSIZE addiert, damit kommt man automatisch wieder auf O_TYPE)

shoot2:	loadb	(r8),r0			; Objecttyp des Gegners laden (5=freie Position
	cmpq	#5,r0			; Ist Position frei ?
	jr	EQ,shoot3		; Ja				
	nop
	subq	#1,r2			; Anzahl Objecte - 1
	jr	NE,shoot2		; Wiederhole sol. Anzahl Objekte > 0
; **** Achtung wird noch ausgefhrt wegen PipeLine **********************
	add	r21,r8			; auf nchste O_TYPE setzen
	jump	T,(r22)			; Ende wenn keine freie Pos. gefunden wurde

; Neuen Schu aktivieren	
shoot3:	subq	#O_TYPE,r8		; Auf O_XPOS setzen
	loadw	(r14),r0		; X-Pos neuer Sprite laden
	add	r10,r0			; X-Pos R-Type addieren
	storew	r0,(r8)			; neue X-Pos schreiben
	addq	#2,r14			; Auf O_YPOS setzen
	addq	#2,r8			; Auf O_YPOS setzen

	loadw	(r14),r0		; Y-Pos neuer Sprite laden
	add	r11,r0			; Y-Pos R-Type addieren
	storew	r0,(r8)			; neue X-Pos schreiben
	addq	#2,r14			; Auf O_DATA setzen
	addq	#2,r8			; Auf O_DATA setzen
	
	load	(r14),r0		; Startadresse Spritedaten laden
	store	r0,(r8)			; Startadresse Spritedaten schreiben		
	addq	#4,r14			; Adresse anpassen
	addq	#4,r8			; Adresse anpassen

	rept	64/8			; Anzahl Wiederholungen
	loadp	(r14),r0		; 8 Bytes lesen
	storep	r0,(r8)			; 8 Bytes schreiben
	addq	#8,r14			; Adresse anpassen
	addq	#8,r8			; Adresse anpassen
	endr

	jump	T,(r23)			; Weiter mit nchsten Schudaten
	nop
shoot4:	store	r25,(r24)		; Schucounter zurckschreiben
	

************************************************************************
*                Function: Animieren der Sprites                       *
*                                                                      *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   9.2.97                        *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; Registerbelegung
; R26	Sprungadresse Draw_Enemy6
; R25	Startadresse obj_gegner fr UP
; R24	Rcksprungadresse UP (Draw_Enemy5)
; R23	Wert fr Ende Kurvenliste ($6719)
; R22	Sprungadresse Create_New1
; R21	Gre eines Objektes in Byte (OBJSIZE)
; R20	Anzahl Objekte (TOTAL_OBJS)
; R19	***** wird von UP genutzt *****
; R18	Wert Sprite nicht mehr aktiv
; R17	Sprungadresse Draw_Enemy1
; R16	Sprungadresse Draw_Enemey9
; R15	Adresse Gegnersprites
; R14	***** wird von UP genutzt *****
; R13	Adresse Gegnersprites
; R11	Offset Geschwindigkeit Animation
; R10	Offset zu Spritedaten
; R9	***** wird von UP genutzt *****
; R8	***** wird von UP genutzt *****
; R6	***** wird von UP genutzt *****
; R5	Arbeitsregister
; R4	Objekt Typ des Sprites
; R3	Y-Pos Sprite
; R2	X-Pos Sprite
; R1	Arbeitsregister
; R0	Arbeitsregister

	movei	#obj_gegner,r0		; GPU-RAM Adresse Start Gegnersprites
	load	(r0),r13		; RAM Adresse Start Gegnersprites
	move	r13,r25			; fr UP
	
	movei	#TOTAL_OBJS,r0		; GPU-RAM Adresse Anzahl Objekte
	load	(r0),r20		; Anzahl Objekte laden	
	subq	#4,r20			; Anzahl Objekte - 4 feste Objekte
	
	movei	#64-32,r11		; Offset Geschwindigkeit der Animation
	movei	#draw_enemy9,r16	; Sprungadresse
	movei	#draw_enemy1,r17	; Sprungadresse
	moveq	#5,r18			; Wert Sprite nicht mehr aktiv
	movei	#$6719,r23		; letzter Wert in Kurvenliste
	movei	#draw_enemy5,r24	; Rcksprungadresse UP
	movei	#create_new1,r22	; Sprungadresse UP
	movei	#40-O_DATA,r10		; Offset Spritedaten
	movei	#OBJSIZE,r21		; Gre eines Objektes in Byte
	movei	#draw_enemy6,r26	; Sprungadresse

draw_enemy1:
	move	r13,r15			; Adresse Start Gegnersprites wiederherstellen
	addq	#O_TYPE,r15		; Adresse auf Objekt Typ setzen
	loadb	(r15),r4		; Objekt Typ laden
	cmpq	#4,r4			; Objekt aktiv? (> 4 Objekt nicht aktiv, bzw. keine Listen)
	jump	HI,(r16)		; Keine Animation zeichnen
	nop

; Skalierung **********************************************************
	addq	#O_SCALE-O_TYPE,r15	; Adresse Skalierangaben
	cmpq	#1,r4			; Sprite skalierbar? (1 = ja)
	jr	NE,draw_enemy3		; Nein
	nop
	
	load	(r15+1),r0		; Angabe ob Sprite skalierbar laden
	load	(r0),r1			; Skalierangaben laden
	cmpq	#0,r1			; letzter Wert in Skalierliste? (0 = ja)
	jr	NE,draw_enemy2		; Nein			
	nop
	load	(r15+2),r0		; Adresse akt. Skalierangaben neu laden
	load	(r0),r1			; Skalierangaben laden
draw_enemy2:	
	addq	#4,r0			; auf nchste Skalierangaben setzen
	store	r0,(r15+1)		; Adresse akt. Skalierangaben neu schreiben
	store	r1,(r15)		; Skalierangaben schreiben

; Kurvenliste Sprite **************************************************
draw_enemy3:
	load	(r15+7),r0		; Adresse auf Kurvenliste
	loadw	(r0),r1			; Wert fr X-Pos laden
	cmp	r23,r1			; letzer Wert in Kurvenliste? (ja = $6719)
	jr	NE,draw_enemy4		; Nein
	addq	#2,r0			; auf Wert fr Y-Pos setzen

	subq	#O_SCALE-O_TYPE,r15	; auf Objekt Typ setzen
	storeb	r18,(r15)		; 5 => Sprite nicht mehr aktiv
	jump	T,(r16)			; Weiter mit nchstem Sprite
	nop

draw_enemy4:	
	loadw	(r0),r5			; Wert fr Y-Pos laden
	addq	#2,r0			; auf nchste Werte fr Kurvenliste
	store	r0,(r15+7)		; neue Adresse fr Kurvenliste schreiben
	
	subq	#O_SCALE-O_XPOS,r15	; Adresse X-Pos Sprite
	loadw	(r15),r2		; X-Pos Sprite laden
	add	r1,r2			; neue X-Pos berechnen
	storew	r2,(r15)		; X-Pos Sprite schreiben
	
	addq	#O_YPOS-O_XPOS,r15	; Adresse Y-Pos Sprite
	loadw	(r15),r3		; Y-Pos Sprite laden
	add	r5,r3			; neue Y-Pos berechnen
	storew	r3,(r15)		; Y-Pos Sprite schreiben

; Schu aktivieren ****************************************************
	addq	#32-O_YPOS,r15		; Adresse Schudaten
	load	(r15),r0		; Schudaten laden
	cmpq	#0,r0			; Schu aktivieren? (0 = nein)
	jump	EQ,(r26)		; Nein
	nop

	load	(r15+1),r1		; Schucounter laden
	subq	#1,r1			; Schucounter verringern
	jr	NE,draw_enemy5		; kein neuer Schu sol. Counter > 0
	nop
; Neuen Schu aktivieren **********************************************
	load	(r0),r14		; Adresse Schutabelle laden
	addq	#8,r0			; auf nchste Schuadresse setzen
	load	(r14),r5		; Check, ob es letzter Wert ist
	cmpq	#0,r5			; 0 = ja
	jr	EQ,draw_enemy4_1
	nop
	move	r0,r5			; Nein, dann Adresse retten	
			
draw_enemy4_1:	
	store	r5,(r15)		; neue Schuadresse schreiben
	addq	#4,r0			; auf nchsten Schucounter setzen
	load	(r0),r1			; neuen Schucounter laden
	
	move	r25,r6			; Startadresse obj_gegner
	jump	T,(r22)			; Neue Schsse aktivieren
	nop
draw_enemy5:
	store	r1,(r15+1)		; neuen Schucounter schreiben

; Animation Sprite ****************************************************
draw_enemy6:
	add	r11,r15			; auf Geschwindigkeit setzen
	loadw	(r15),r0		; Geschwindigkeit laden
	subq	#1,r0			; Geschwindigkeit verringern
	jr	EQ,draw_enemy7		; Geschwindigkeit = 0 (neue Animation)
	nop
	jump	T,(r16)			; keine neue Animation zeichnen
	storew	r0,(r15)		; Geschwindigkeit schreiben
	
draw_enemy7:
	addq	#2,r15			; auf neue Geschwindigkeit setzen
	loadw	(r15),r0		; neue Geschwindigkeit laden
	subq	#2,r15			; auf alte Geschwindigkeit setzen
	storew	r0,(r15)		; neue Geschwindigkeit schreiben
	
	subq	#64-40,r15		; auf Adresse akt. Spritedaten setzen
	load	(r15),r0		; Startadresse Spritedaten laden
	load	(r0),r1			; akt. Spritedaten laden
	cmpq	#0,r1			; letzte Spritedaten? (0 = ja)
	jr	NE,draw_enemy8		; nein
	nop

	load	(r15+1),r0		; Startadresse Spritedaten neu festlegen
	load	(r0),r1			; akt. Spritedaten laden	
draw_enemy8:
	addq	#4,r0			; Adresse akt. Spritedaten erhhen
	store	r0,(r15)		; Startadresse Spritedaten schreiben
	sub	r10,r15			; auf akt. Spritedaten setzen
	store	r1,(r15)		; neue Startadresse akt. Spritedaten

; Ende, wiederholen fr Anzahl Sprite **********************************
draw_enemy9:
	subq	#1,r20			; Anzahl Objekte - 1
	jump	NE,(r17)		; Wiederholen sol. > 0
	add	r21,r13			; auf nchstes Objekt setzen


************************************************************************
*                Function: Spriteliste fr den Object Processor        *
*                          erstellen.                                  *
*                                                                      *
*                Project #:              NATIVE                        *
*                                                                      *
*                Programmer:             Roland Graf                   *
*                Date:                   28.1.97                       *
*                                                                      *
*              COPYRIGHT 1996,1997 Duranik Software                    *
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
*                            ALL RIGHTS RESERVED.                      *
*                                                                      *
************************************************************************
; Am Anfang zwei Branch Objecte einbauen, damit nicht sichtbarer Bereich
; keine Rechenzeit bentigt.

op_liste:
	movei	#OBJSIZE,r3		; Gre eines Objects in Byte (am Ende steht man auf O_SCALE, also nur noch Differenz zur eigentl. Lnge addieren) 
	movei	#$FFEC,r5		; Offset fr Y-Pos R-Type unverwundbar (-20)
		
	movei	#x,r0			; GPU-Ram Adresse X-Pos R-Type
	load	(r0),r1			; RAM Adresse X-Pos R-Type
	move	r1,r4			; RAM Adresse X-Pos R-Type retten
	loadw	(r1),r2			; X-Pos R-Type laden
	add	r3,r4			; X-Pos R-Type unverwundbar
	addq	#2,r2			; X-Pos + Offset
	storew	r2,(r4)			; X-Pos schreiben
	
	addq	#O_YPOS-O_XPOS,r1	; auf Y-Pos setzen
	addq	#O_YPOS-O_XPOS,r4	; auf Y-Pos setzen
	
	loadw	(r1),r2			; Y-Pos R-Type laden
	add	r5,r2			; Y-Pos + Offset
	storew	r2,(r4)			; Y-Pos schreiben
	
	addq	#O_TYPE-O_YPOS,r1	; Adresse auf Objekt Typ setzen
	loadb	(r1),r2			; Objekt Typ laden
	cmpq	#5,r2			; R-Type zerstrt ?
	jr	NE,op_liste1		; Nein
	moveq	#6,r2			; neuer Objekt Type R-Type = 6
	storeb	r2,(r1)			; neuen Objekt Typ schreiben
op_liste1:
        movei   #obj_data,r0		; Adresse Daten fr OP-Liste
	load	(r0),r11		; Adresse laden
        movei   #olist_ram,r0		; Adresse Kopie OP-Liste im RAM
	load	(r0),r12		; Adresse laden
	move	r12,r7			; Adresse OP-Liste retten
	shrq	#3,r7			; geteilt / 8 fr OP
	movei	#TOTAL_OBJS,r0		; Adresse Anzahl Objecte
	load	(r0),r6			; Anzahl Objecte laden
	move	r11,r13			; Kopie Adresse Daten fr OP-Liste
	movei	#proc_obj,r5		; Sprungadresse fr Zhlschleife
	movei	#next_obj,r4		; Sprungadresse fr Object Check
	movei	#y_pos,r0		; GPU-RAM Adresse Offset Y-Scrolling
	load	(r0),r0			; RAM Adresse Offset Y-Scrolling
	load	(r0),r29		; Wert fr Y-Scrolling laden

; Register vorbelegen
	movei	#proc_obj3,r17		; Sprungadresse
	movei	#$FFFF0000,r18		; Variable um Zahl negativ zu machen
	movei	#32768,r19		; Variable fr Check ob Zahl negativ ist
        movei   #$ff,r20                ; Byte ausmaskieren
        movei   #$ffff,r21              ; Wort ausmaskieren 
        movei   #$7ff,r22               ; um O_YPOS zu ermitteln
	moveq	#$f,r23			; um O_IWIDTH zu ermitteln
	movei	#$fff,r24		; Um O_XPOS zu ermitteln
	moveq	#4,r25			; fr STOP Object
	movei	#n_vdb,r26		; Y-Pos erste Bildschirmzeile

; **** PHRASE 1	******************
proc_obj:
	addq	#O_TYPE,r11		; Adresse auf O_TYPE setzen
        loadb   (r11),r2		; O_TYPE laden
        cmpq	#5,r2			; Ist Object aktiv ? (5 = nein)
        jump    EQ,(r4)			; Nein, weiter mit nchstem Object
        nop                     	; Wegen Sprungbefehl
	cmpq	#6,r2			; 6 = Object ohne Animlisten (R-Type Sprite)
	jr	NE,proc_obj1		; Nein, dann weiter
	nop				; Wegen Sprungbefehl
	moveq	#0,r2			; O_TYPE fr Sprite auf 0 setzen

; Object Daten
proc_obj1:
	subq	#O_TYPE-O_DATA,r11	; Adresse auf O_DATA setzen
        load    (r11),r0	 	; Adresse der Spritedaten

	addq	#O_DWIDTH-O_DATA,r11	; Adresse auf O_DWIDTH setzen
	loadw	(r11),r28		; Breite in Phrases laden

	move	r26,r27			; Y-Pos erste Bildschirmzeile retten
	subq	#O_DWIDTH-O_YPOS,r11	; Adresse auf Y-Pos setzen
	loadw	(r11),r30		; Y-Pos Objekt laden

	cmpq	#7,r2			; Objekt, das feste Y-Pos hat (z.B Leben,Punkte)
	jr	NE,proc_obj1_0		; Nein
	nop
	moveq	#0,r27			; keine Bildschirmzeilen auserhalb sichtbarem Bereich
	jump	T,(r17)			; Ja, dann Offset Y-Scrolling nicht addieren
	moveq	#0,r2			; O_TYPE fr Sprite auf 0 setzen

; Check ob Y-Pos negativ ist	
proc_obj1_0:
	cmp	r19,r30			; Ist Y-Pos negativ
	jr	CS,proc_obj1_1		; Nein
	nop
	or	r18,r30			; Y-Pos negativ machen

proc_obj1_1:	
	add	r29,r30			; Offset Y-Scrolling addieren
	sub	r30,r27			; halbe Bildschirmzeilen auserhalb sichtbarem Bereich
	jr	PL,proc_obj2
	nop
	moveq	#0,r27			; keine Bildschirmzeilen auserhalb sichtbarem Bereich
	jr	T,proc_obj3
	nop
proc_obj2:
	movei	#0,r30			; Y-Pos auf Bildschirmanfang setzen
	shrq	#1,r27			; ganze Bildschirmzeilen auserhalb sichtbarem Bereich
	shlq	#3,r28			; Breite in Phrases * 8 Byte pro Phrase
	mult	r27,r28			; Bildschirmzeilen auserhalb * Bytes pro Zeile
	add	r28,r0			; nicht sichtbare Bytes bergehen		
proc_obj3:
        shrq    #3,r0           	; Adresse / 8
        shlq    #11,r0          	; Platz fr Link Pointer schaffen

; Link Pointer fr nchstes Object setzen
        addq    #4,r7	          	; nchstes Object ist 4 Phrases weiter
        move    r7,r1	          	; Adresse in Object Liste fr nchstes Object

        shrq    #8,r1                   ; rechte 8 Bits ins nchste Langwort
        or      r1,r0           	; OR mit Data Pointer
        store   r0,(r12)        	; 1 Langwort Phrase 1 sichern
	addq	#4,r12			; Adresse anpasssen

	move	r7,r0			; Adresse Link Pointer
	and	r20,r0			; 1 Byte ausmaskieren
	shlq	#10,r0			; 10 Bits verschieben fr O_HEIGHT
	
; Hhe setzen
	addq	#O_HEIGHT-O_YPOS,r11	; Adresse auf O_HEIGHT setzen
	cmpq	#1,r2			; Scaled Bitmap Objekt?
	jr	NE,proc_obj4		; Nein
	loadw	(r11),r1		; Object Hhe laden
	subq	#1,r1			; Extra Zeile am unteren Rand bei Scaled Bitmap Objekt
proc_obj4:
	sub	r27,r1			; Hhe - nicht sichtbare Zeilen
	jr	PL,proc_obj5		; Weiter sol. Hhe nicht negativ
	nop	
	moveq	#0,r1			; Hhe auf 0 setzen
proc_obj5:	
	and	r21,r1			; 1 Wort ausmaskieren
	or	r1,r0			; OR mit Link Pointer
        shlq    #11,r0                  ; 11 Bits verschieben fr O_YPOS

; Y-Pos setzen
	and	r22,r30			; Nur 11 Bits fr Y-Pos benutzen	
	or	r30,r0			; OR mit Link Pointer und Hhe
	shlq	#3,r0			; 3 Bits verschieben fr O_TYPE
	
; O-Type setzen
	or	r2,r0			; OR mit Object Type
	store	r0,(r12)		; 2 Langwort Phrase 1 schreiben		
	addq	#4,r12			; Adresse anpasssen

	
; **** PHRASE 2	******************
; O-Firstpix setzen
	addq	#O_FIRSTPIX-O_HEIGHT,r11 ; Adresse O_FIRSTPIX laden
	loadb	(r11),r0		; Object Firstpix laden
	shlq	#4,r0			; 4 Bits verschieben
	
	
; Object Flags setzen
	subq	#O_FIRSTPIX-O_FLAGS,r11	; Adresse O_FLAGS setzen
	loadb	(r11),r1		; Object Flags laden
	or	r1,r0			; OR mit Object Flags
	shlq	#7,r0			; 7 Bits verschieben fr INDEX	

; Object Index setzen
	addq	#O_INDEX-O_FLAGS,r11	; Adresse O_INDEX setzen
	loadb	(r11),r1		; Object Index laden
	or	r1,r0			; OR mit Object Index
	shlq	#6,r0			; 6 Bits verschieben
	
; Object Breite setzen
	subq	#O_INDEX-O_IWIDTH,r11	; Adresse O_IWIDTH setzen
	loadw	(r11),r1		; Object Breite laden
	move	r1,r2			; Object Breite merken
	shrq	#4,r1			; 4 Bits gehen ins nchtse Langwort
	or	r1,r0			; OR 
; Damit es nicht den Wert $00000004 ergibt, sonst bricht INT Kopierroutine ab
	bset	#31,r0	

	store	r0,(r12)		; 1 Langwort Phrase 2 schreiben
	addq	#4,r12			; Adresse anpasssen
	
	and	r23,r2			; unterste 4 Bits von O_IWIDTH
	shlq	#10,r2			; 10 Bits verschieben fr O_DWIDTH
	
; Object Breite 2 setzen
	subq	#O_IWIDTH-O_DWIDTH,r11	; Adresse O_DWIDTH setzen
	loadw	(r11),r0		; Object Breite 2 laden
	or	r2,r0			; OR mit O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr PITCH
	
; Object Pitch setzen
	addq	#O_PITCH-O_DWIDTH,r11	; Adresse O_PITCH setzen
	loadb	(r11),r1		; Object Pitch laden
	or	r1,r0			; OR mit O_IWIDTH und O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr O_DEPTH
	
; Object Depth setzen
	subq	#O_PITCH-O_DEPTH,r11	; Adresse O_DEPTH setzen
	loadb	(r11),r1		; Object Depth laden
	or	r1,r0			; OR mit O_IWIDTH, O_DWIDTH und O_PITCH
	shlq	#12,r0			; 12 Bits verschieben fr O_XPOS
	
; Object X-Pos setzen	
	subq	#O_DEPTH-O_XPOS,r11	; Adresse O_XPOS setzen
	loadw	(r11),r1		; Object X-Pos laden

; ***** Test *****
;	addq	#18,r1			; Bild nach rechts verschieben


	and	r24,r1			; Nur 12 Bits fr O_XPOS benutzen
	or	r1,r0			; OR
	store	r0,(r12)		; 2 Langwort Phrase 2 schreiben
	addq	#8,r12			; Adresse anpasssen (+8 wegen O_SCALE)
				
; **** PHRASE 3	******************
	addq	#O_SCALE-O_XPOS,r11	; Adresse O_SCALE setzen
	load	(r11),r0		; Object Scale laden
	store	r0,(r12)		; Object Scale schreiben
	addq	#12,r12			; Adresse anpassen

next_obj:
	add	r3,r13			; Auf nchstes Object setzen (+ OBJSIZE)
	move	r13,r11			; Arbeitsregister wiederherstellen
	subq	#1,r6			; Anzahl Objecte - 1
	jump	NE,(r5)			; Wiederholen sol. > 0
	nop				; Wegen Sprungbefehl
	
; STOP Object am Ende der Liste schreiben
	addq	#4,r12			; Adresse anpassen
	store	r25,(r12)		; Object Type 4 (STOP OBJECT) schreiben		

; GPU stoppen
	moveq   #0,r30
	movei   #G_CTRL,r31
	store   r30,(r31)
	.end
