	;;***********************************************************************
	;;
	;;		Project Name	:	NATIVE SPIRIT
	;;		FILENAME	:	JERRY.INC (Controller)
	;;
 	;;	JERRY Hardware Equates for JAGUAR System
	;;
	;;	COPYRIGHT  1995 Atari Computer Corporation
	;;	UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,
	;;	PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR
	;;	THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.
	;;	ALL RIGHTS RESERVED.
 	;;
 	;; Revision History:
 	;; * 9/19/94 - Consolidated several files into first master JAGUAR.INC (SDS)
 	;; * 2/16/95 - MF
 	;; * 4/24/95 - Added UART Error Control and Mask definitions (NBK)
 	;; * 5/16/95 - Added Asynchronous Serial/DAC Synonyms (SDS)
 	;; * 8/08/95 - Fixed two Blitter LFU Equates, added ProController equates,
 	;;           added blitter BLITMASK flag, removed MOD_MASK/DSPINT0.
	;;
	;;	   NATIVE SPIRIT Adaptation Produced by Jason Keith Data
	;;	2007 Revision released under an Educational Community License
	;;			Copyright  2006 Zentanyx
	;;
	;;***********************************************************************

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	JERRY REGISTERS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

JPIT1		EQU	BASE + $10000	; Timer 1 Pre-Scaler
JPIT2		EQU	BASE + $10002	; Timer 1 Divider
JPIT3		EQU	BASE + $10004	; Timer 2 Pre-Scaler
JPIT4		EQU	BASE + $10006	; Timer 2 Divider

J_INT		EQU     BASE + $10020   ; Jerry Interrupt control (to TOM)
		
JOYSTICK	EQU     BASE + $14000   ; Joystick register and mute
JOYBUTS		EQU	BASE + $14002	; Joystick register
CONFIG		EQU	BASE + $14002	; Also has NTSC/PAL

;MOD_MASK	EQU	BASE + $1A118	; Mask for ADDQ(SUBQ)MOD

SCLK		EQU	BASE + $1A150	; SSI Clock Frequency
SMODE		EQU	BASE + $1A154	; SSI Control

L_I2S		EQU	BASE + $1A148	; I2S LEFT Serial Interface	
R_I2S		EQU	BASE + $1A14C	; I2S RIGHT Serial Interface
LTXD		EQU	BASE + $1A148	; Synonyms
RTXD		EQU	BASE + $1A14C	;
LRXD		EQU	BASE + $1A148	;
RRXD		EQU	BASE + $1A14C	;

ASICLK		EQU	BASE + $F10034	; Async Clock Register (Network Transfer Speed)
ASICTRL         EQU 	BASE + $F10032	; Async Control Register (Network Control)
ASISTAT		EQU	BASE + $F10032	; Async Status Register
ASIDATA         EQU 	BASE + $F10030	; Async Data Register (Network Receive)

;;;
;;; Jerry Interrupt Control Flags
;;;

J_EXTENA	EQU	$0001		; Enable external interrupts
J_DSPENA	EQU	$0002		; Enable DSP interrupts
J_TIM1ENA	EQU	$0004		; Enable Timer 1 interrupts
J_TIM2ENA	EQU	$0008		; Enable Timer 2 interrupts
J_ASYNENA	EQU	$0010		; Enable Asyncronous Serial interrupts
J_SYNENA	EQU	$0020		; Enable Syncronous Serial interrupts

J_EXTCLR	EQU	$0100		; Clear pending external interrupts
J_DSPCLR	EQU	$0200		; Clear pending DSP interrupts
J_TIM1CLR	EQU	$0400		; Clear pending Timer 1 interrupts
J_TIM2CLR	EQU	$0800		; Clear pending Timer 2 interrupts
J_ASYNCLR	EQU	$1000		; Clear pending Asynch. Serial interrupts
J_SYNCLR	EQU	$2000		; Clear pending Synch. Serial interrupts


;;;
;;;	ROM Tables built into Jerry - 128 samples each
;;;	16 bit samples sign extended to 32
;;;

ROM_TABLE   	EQU	BASE + $1D000	; Base of tables

ROM_TRI     	EQU	BASE + $1D000	; A triangle wave
ROM_SINE    	EQU	BASE + $1D200	; Full amplitude SINE
ROM_AMSINE  	EQU	BASE + $1D400	; Linear (?) ramp SINE
ROM_12W 	EQU	BASE + $1D600	; SINE(X)+SINE(2*X) : (was ROM_SINE12W)
ROM_CHIRP16 	EQU	BASE + $1D800	; SHORT SWEEP
ROM_NTRI    	EQU	BASE + $1DA00	; Triangle w/NOISE
ROM_DELTA   	EQU	BASE + $1DC00	; Positive spike
ROM_NOISE   	EQU	BASE + $1DE00	; Guess

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	JERRY Registers (DSP)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

D_FLAGS		EQU	BASE + $1A100	; DSP Flags
D_MTXC		EQU	BASE + $1A104	; DSP Matrix Control
D_MTXA		EQU	BASE + $1A108	; DSP Matrix Address
D_END		EQU	BASE + $1A10C	; DSP Data Organization
D_PC		EQU	BASE + $1A110	; DSP Program Counter
D_CTRL		EQU	BASE + $1A114	; DSP Operation Control/Status
D_MOD		EQU     BASE + $1A118   ; DSP Modulo Instruction Mask
D_REMAIN 	EQU	BASE + $1A11C	; DSP Division Remainder
D_DIVCTRL 	EQU	BASE + $1A11C	; DSP Divider control
D_MACHI		EQU     BASE + $1A120   ; DSP Hi byte of MAC operations
D_RAM		EQU	BASE + $1B000	; DSP Internal RAM
D_ENDRAM	EQU	D_RAM +(8*1024)	; 8K bytes

;;;
;;; JERRY Flag Register Equates
;;;

D_CPUENA	EQU	$00000010	; CPU Interrupt Enable Bit
D_I2SENA	EQU	$00000020	; I2S Interrupt Enable Bit
D_TIM1ENA	EQU	$00000040	; Timer 1 Interrupt Enable Bit
D_TIM2ENA	EQU	$00000080	; Timer 2 Interrupt Enable Bit
D_EXT0ENA	EQU	$00000100	; External Interrupt 0 Enable Bit
D_EXT1ENA	EQU	$00010000	; External Interrupt 1 Enable Bit

D_CPUCLR	EQU	$00000200	; CPU Interrupt Clear Bit
D_I2SCLR	EQU	$00000400	; I2S Interrupt Clear Bit
D_TIM1CLR	EQU	$00000800	; Timer 1 Interrupt Clear Bit
D_TIM2CLR	EQU	$00001000	; Timer 2 Interrupt Clear Bit
D_EXT0CLR	EQU	$00002000	; External Interrupt 0 Clear Bit
D_EXT1CLR	EQU	$00020000	; External Interrupt 1 Clear Bit

;;;
;;; JERRY Control/Status Register
;;;

DSPGO		EQU	$00000001	; Start DSP
;DSPINT0		EQU	$00000004	; Generate a DSP Interrupt 0

D_CPULAT	EQU	$00000040	; Interrupt Latches
D_I2SLAT	EQU	$00000080
D_TIM1LAT	EQU	$00000100
D_TIM2LAT	EQU	$00000200
D_EXT1LAT	EQU	$00000400
D_EXT2LAT	EQU	$00010000

;;;
;;; JERRY Modulo Instruction Masks
;;;

MODMASK2	EQU	$FFFFFFFE	; 2 byte circular buffer
MODMASK4	EQU	$FFFFFFFC	; 4 byte circular buffer
MODMASK8	EQU	$FFFFFFF8	; 8 byte circular buffer
MODMASK16	EQU	$FFFFFFF0	; 16 byte circular buffer
MODMASK32	EQU	$FFFFFFE0	; 32 byte circular buffer
MODMASK64	EQU	$FFFFFFC0	; 64 byte circular buffer
MODMASK128	EQU	$FFFFFF80	; 128 byte circular buffer
MODMASK256	EQU	$FFFFFF00	; 256 byte circular buffer
MODMASK512	EQU	$FFFFFE00	; 512 byte circular buffer
MODMASK1K	EQU	$FFFFFC00	; 1k circular buffer 
MODMASK2K	EQU	$FFFFF800	; 2k circular buffer
MODMASK4K	EQU	$FFFFF000	; 4k circular buffer
MODMASK8K	EQU	$FFFFE000	; 8k circular buffer
MODMASK16K	EQU	$FFFFC000	; 16k circular buffer
MODMASK32K	EQU	$FFFF8000	; 32k circular buffer
MODMASK64K	EQU	$FFFF0000	; 64k circular buffer
MODMASK128K	EQU	$FFFE0000	; 128k circular buffer
MODMASK256K	EQU	$FFFC0000	; 256k circular buffer
MODMASK512K	EQU	$FFF80000	; 512k circular buffer
MODMASK1M	EQU	$FFF00000	; 1M circular buffer

;;;
;;;  A2 Mask Enable Bit
;;;

BLITMASK	EQU	$00008000

;;;
;;; UART Definitions (new in this file as of 24-Apr-95)
;;;
;;; UART control register Masks
;;; All unused bits in the control register need to be written as zeros !
;;; With exception of U_CLRERR these are valid for read in ASISTAT, too
;;;

U_MODD		EQU	(1<<0)		; selects odd parity
U_MPAREN	EQU	(1<<1)		; enable parity
U_MTXOPOL	EQU	(1<<2)		; transmit output polarity (if set: active low)
U_MRXIPOL	EQU	(1<<3)		; receive input polarity (if set: invert input)
U_MTINTEN	EQU	(1<<4)		; enable transmitter interrupts
U_MRINTEN	EQU	(1<<5)		; enable reciever interrupts

U_MCLRERR	EQU	(1<<6)		; Mask clear error (only use if U_SERIN is
					; inactive otherwise the UART locks up.
					; By default input is active low. This
					; depends on U_MRXIPOL)

U_MTXBRK	EQU	(1<<14)		; transmit break

;;;
;;; UART control AND status register (SHARED) bit numbers
;;;

U_ODD		EQU	0		; selects odd parity
U_PAREN		EQU	1		; enable parity
U_TXOPOL	EQU	2		; transmit output polarity (if set: active low)
U_RXIPOL	EQU	3		; receive input polarity (if set: invert input)
U_TINTEN	EQU	4		; enable transmitter interrupts
U_RINTEN	EQU	5		; enable reciever interrupts

U_CLRERR	EQU	6		; Clear error UART control register (ONLY) bit numbers

U_TXBRK		EQU	14		; transmit break

;;;
;;; UART status register (ONLY) bit number
;;;

U_ERR		EQU	15		; error condition exists
U_SERIN		EQU	13		; state of UART1 Pin (serial input data)
U_OE		EQU	11		; overrun error
U_FE		EQU	10		; frame error
U_PE		EQU	9		; parity error
U_TBE		EQU	8		; transitter buffer empty
U_RBF		EQU	7		; receiver buffer full

;*======================================================================*
;*                TITLE:                  JOYPAD.INC                    *
;*                Function:               Joypad bit definitions	*
;*                                                                      *
;*                Project #:              JAGUAR\SYLVESTER              *
;*                Programmer:             Rob Zdybel                    *
;*                                                                      *
;*              COPYRIGHT 1993 Atari Computer Corporation               *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*
; CHANGES
; nbk 93-Nov-23 inserting this comment
;
; the following definitions from OLDER versions of JOYPAD.INC do NO LONGER 
; EXIST and should be REPLACED (instead of redefined) in older sourcecode
; JOYDEFS.INC is even more outdated. DO NOT USE IT ANY LONGER. It contains
; bit number definitions that do not reflect the current hardware any
; more.
;
; instead of	use
; OLD NAME	NEW NAME
; ----------------------
; JOYIN		JOYSTICK	; this is a LONG variable
; JOYOUT	JOYSTICK	
; JOYSTICK	PROPAD		; JKD Synonym
; JOYIN and JOYOUT are found under name JOYSTICK in JAGUAR.INC
;
; despite of all DONT'S here some hints for sources relying on old JOYDEFS.INC
; instead of	use
; OLD NAME	NEW NAME
; ----------------------
; JOY_DOWN	JOY_PUSH	; Forward is DOWN * INVERTED - JKD
; JOY_UP	JOY_PULL	; Backward is UP * INVERTED - JKD
; FIRE_A_BIT	FIRE_A		; most bits have a new bit number
; FIRE_B_BIT	FIRE_B		; not only new names 
; FIRE_C_BIT	FIRE_C		; check thoroughly with the definitions 
; OPTION_BIT	OPTION		; following later in this file
; PAUSE_BIT	PAUSE
; KEY_S		KEY_STAR
; KEY_P		KEY_HASH
;
; OLD NAMES NO LONGER PREDEFINED, below. Put into your own code.
;
; YES
; NO		
; NUM_OF_PLAYERS
; TWO_PLAYERS
;
;- nbk 93-Nov-23
;- JKD 07-Dec-07
;=======================================================================*
; Jerry PRO CONTROL Reading Equates;
; Format = xxApxxBx RLDU147* xxCxxxox 2580369#
;*======================================================================*

PROPAD		EQU	$F14000

;;;
;;; Thumbpad
;;;
;JOY_UP		EQU     20	; 20 -  PORT RUDDER (Bank Left) Starship LIFT YOKE
JOY_PULL        EQU     20   	; 20 - PORT RUDDER (Bank Left) Starship LIFT YOKE

;JOY_DOWN	EQU     21	; 21 - STARBOARD RUDDER (Bank Right) Starship DESCENT
JOY_PUSH	EQU     21	; 21 - STARBOARD RUDDER (Bank Right) Starship DESCENT
       		
JOY_LEFT        EQU     22		; Cut Thrust, Drift BACKWARD
JOY_RIGHT       EQU     23		; Throddle Up, FORWARD 

;;;
;;; Menu Buttons
;;;

PAUSE           EQU     28		; PAUSED (no graphic yet)
OPTION          EQU     9		; n/a

;;;
;;; Fire Buttons
;;;

FIRE_A          EQU     29              ; Rapid Fire
FIRE_B          EQU     25		; Rapid Fire
FIRE_C          EQU     13		; Rapid Fire

;;;
;;; Pro Controller Mappings - JKD
;;;

SHIFT_R		EQU	2	; RIGHT Trigger	......(equ KEY_6)
FIRE_X          EQU     1	; button above FIRE_A (equ KEY_9)

FIRE_Y          EQU     5	; button above FIRE_B (equ KEY_5)

SHIFT_L		EQU	18	; LEFT Trigger	......(equ KEY_4)
FIRE_Z          EQU     17	; button above FIRE_C (equ KEY_7)

;;;
;;; Keypad
;;;

KEY_STAR        EQU     16              
KEY_7           EQU     17
KEY_4           EQU     18
KEY_1           EQU     19

KEY_0           EQU     4
KEY_8           EQU     5
KEY_5           EQU     6
KEY_2           EQU     7

KEY_HASH        EQU     0
KEY_9           EQU     1
KEY_6           EQU     2
KEY_3           EQU     3

ANY_JOY         EQU     $00F00000       ; AND joyEDGE with joypad if result is not 0
ANY_FIRE        EQU     $32002200       ; AND joyEDGE with A,B C, Option or Pause if result is not 0
ANY_KEY         EQU     $000F00FF       ; AND joyEDGE with this... 123456789*0# if result is not 0

;B2MASK(a)	EQU	(1UL<<(a))	; Convert bit to joystick mask?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;
;; EOF ;;
;;;;;;;;;
