*************************************************************************
*									*
*                Project Name	:	NATIVE				*
*                Function	: 	spezielle EQU's for NATIVE	*
*									*
*                Programmer	:	Roland Graf			*
*                Date		:	9.2.97				*
*                Editor		:   	Jason K. Data			*
*		LAST UPDATE	:	November 17, 2007		*
*									*
*                  COPYRIGHT 1996,1997 Duranik Software 		*
*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,		*
*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR		*
*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.	*
*                            ALL RIGHTS RESERVED.			*
*									*
*	EQUates exclusive to NATIVE included from DURANIK JAGUAR.inc	*
*									*
*	   NATIVE SPIRIT Adaptation Produced by Jason Keith Data	*
*	2007 Revision Licensed under an Educational Community License	*
*			Copyright (c)2007 Zentanyx			*
*									*
*************************************************************************
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       TOM REGISTERS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;; NATIVE ONLY TOM
;;;
;
;PIT             EQU $F00050   		; Programmable Timer

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;      OBJECT PROCESSOR EQUATES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;; NATIVE OBJECT PROCESSOR (OP)
;;;
;
;OB              EQU $F00010     	; Not what you think, it's the Object Data

;;;
;;; NATIVE Sonstige miscellaneous
;;;

LEVEL2		EQU	$0100       	; NATIVE Interrupt Adresse

;;; LEVEL2		EQU	4*$40		; DEMO.S EQU in NS0023

;;;
;;; Gegner definition for NATIVE
;;;

TOTAL_BACK	EQU	15		; Anzahl Hintergrundgrafiken
TOTAL_ENEMY	EQU	32		; Anzahl Gegner im Hintergrund + Gegnerschsse
TOTAL_ENEMY1	EQU	9	;8	; Anzahl Gegner im Vordergrund
TOTAL_EXPLO	EQU	57	;56   	; Anzahl Explosionen (PYROTECH for Asteroids)
TOTAL_SHOT1	EQU	18		; Anzahl Schsse Player 1
TOTAL_STATIC	EQU	10		; Anzahl feste Sprites (z.B Hintergrnde)
TOTAL_EXTRA	EQU	6		; Anzahl Geldstcke

; TOTAL_OBJS	EQU	TOTAL_ENEMY+TOTAL_ENEMY1+TOTAL_EXPLO+TOTAL_SHOT1+TOTAL_STATIC+TOTAL_EXTRA ; see NS#.s

DESTROY		EQU	$FFFF		; -1 = Gegner ist nicht zerstrbar
SHOOT_SPEED	EQU	60/5		; Geschwindigkeit wie oft die Schuroutine aufgerufen wird
KURVE_ENDE	EQU	$6719		; letzter Wert in einer Kurvenliste
SAMPLE		EQU	$3333		; Magic Wert fr Sample Daten
COLOR		EQU	$4444		; Magic Wert fr Color Daten
PACKED		EQU	$5555		; Magic Wert fr gepackte Daten

;;;
;;; Offset Definitionen for Object Processor
;;;

O_XPOS          EQU 0
O_YPOS          EQU 2
O_DATA          EQU 4
O_HEIGHT        EQU 8
O_DWIDTH        EQU 10
O_IWIDTH        EQU 12
O_FLAGS         EQU 14
O_FIRSTPIX      EQU 15
O_TYPE          EQU $10
O_DEPTH         EQU $11
O_PITCH         EQU $12
O_INDEX         EQU $13
O_SCALE         EQU $14
OBJSIZE		EQU 72			; Gre eines Objektes in Byte

;;;
;;; Video Subsystem
;;;

vclk		EQU 376
horiz_per	EQU 317778
sync_per	EQU 46050
eq_per		EQU 23500
front_porch	EQU 17450
line_blank	EQU 109500

disp_width	EQU 1209		; (1281 x 226 Duranik definition 13.10.97) 1409 = ( pixel width + 1) * 3
disp_height	EQU 226			; this is in lines

;;;
;;; Horizontal computations
;;;

n_hp		EQU horiz_per/vclk
n_hbb		EQU ((horiz_per-sync_per-front_porch)/vclk)+$400
n_hbe		EQU (line_blank-sync_per-front_porch)/vclk
n_hs		EQU ((horiz_per-sync_per)/vclk)+$400
n_hvs		EQU (horiz_per-(2*sync_per))/vclk
n_heq		EQU (horiz_per-eq_per)/vclk
n_hde		EQU ((disp_width/2)-1)+$400
n_hdb1		EQU ((n_hp)-(disp_width/2))
n_hdb2		EQU n_hdb1

n_vp		EQU 523
n_vee		EQU 6
n_vbe		EQU 40
n_vdb		EQU n_vbe+4		
; n_vdb		EQU n_vbe+26		; fr 320 * 200
n_vde		EQU n_vdb+(disp_height*2)
n_vbb		EQU n_vde+40
n_vs		EQU n_vp-10
n_veb		EQU n_vs-n_vee

SCRN_TOP	EQU n_vdb		; ypos of first line at top of screen
SCRN_BOTTOM	EQU n_vde		; xpos of first line below screen
MAX_Y		EQU 10*2		; max. Wert fr Y-Scrolling

;;;
;;; Adressen for 4 Samplestimmen
;;;

SAM1_START	EQU	$f1cf00		; Startadresse Sample 1
SAM1_END	EQU	$f1cf00+4	; Endadresse Sample 1
SAM2_START	EQU	$f1cf00+8	; Startadresse Sample 2
SAM2_END	EQU	$f1cf00+12	; Endadresse Sample 2
SAM3_START	EQU	$f1cf00+16	; Startadresse Sample 3
SAM3_END	EQU	$f1cf00+20	; Endadresse Sample 3
SAM4_START	EQU	$f1cf00+24	; Startadresse Sample 4
SAM4_END	EQU	$f1cf00+28	; Endadresse Sample 4

;;;
;;; Adressen for ICE Depack
;;;

ICE_SOURCE	EQU	$f1cf00+32	; Quelladresse gepackten Daten
ICE_DEST	EQU	$f1cf00+36	; Zieladresse entpackte Daten
ICE_BUSY	EQU	$f1cf00+40	; DSP belegt/frei
ICE_PRIORITY	EQU	$f1cf00+60	; Prioritten fr DSP

;;;
;;; Definition for JagPeg GPU Routinen
;;;

DEHUFF_ADDR	equ	$140000
DEHUFF_SIZE	equ	1400

;;;
;;; NATIVE JERRY
;;;
;
;ANAJOY          EQU $F17C00     ; Analog Joystick
