;;======================================================================================*
;;											*
;;			Project Name	:	NATIVE SPIRIT				*
;;			FILENAME	:	NS0029.s				*
;;											*
;;			Programmer	:	Roland Graf             		*
;;			Graphics	:	Johannes Graf				*
;;			Ice Decrunch	:	Gordon Gibson				*
;;											*
;;			COPYRIGHT 1996,1997,1998 Duranik Software			*
;;		  UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,			*
;;	  	 PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR			*
;;	 	THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.			*
;;				    ALL RIGHTS RESERVED.				*
;;											*
;;		REV.	DATE		AUTHOR		REVISION HISTORY		*
;;		~~~~~	~~~~~~~~~~~~	~~~~~~~~~~~~	~~~~~~~~~~~~~~~~~~~~~		*
;;		000	11-12-96	DURANIK		NATIVE.s 1st Release		*
;;		001	03-28-07	Zentanyx	SPIRIT.s 1st Revision		*
;;		002	12-28-07	Zentanyx	NS0029.s 2nd Revision		*
;;											*
;;	Modification and Anomaly Report							*
;;	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~						*
;;	* 2nd Ranger stops periodically during end of sector gameplay			*
;;	* TOP BORDER pop-up late in background						*
;;	* CHECK Draw_Beam  (SHIFT_R charge by 2 pads or when R2 paused)			*
;;	* CHECK easter egg (without pressing 'o')					*
;;	* PAUSE graphic (not yet implemented)	R2 PAUSE not WORKING with d-pad		*
;;											*
;;		   NATIVE SPIRIT Adaptation Produced by Jason Keith Data		*
;;	   This revision has been released under an Educational Community License	*
;;				Copyright  2007 Zentanyx				*
;;											*
;;======================================================================================*
	.text
	.68000
	.noclear

	INCLUDE "../DURANIK/INCLUDE/TOM.INC"		; EQUates for JAGUAR Video
	INCLUDE	"../DURANIK/INCLUDE/JERRY.INC"		; EQUates for JAGUAR Controllers
	INCLUDE	"../DURANIK/INCLUDE/NATIVE.INC"		; EQUates for NATIVE Exclusively
	INCLUDE	"../DURANIK/INCLUDE/PACKED.INC"		; EQUates for Packed Images (Daten)
	INCLUDE	"../DURANIK/INCLUDE/DEJAG.INC"		; EQUates for JagPeg Routine
	
down		EQU	$5000		; Download Address in Jaguar
start		EQU	$5000		; Start address in Jaguar
TOTAL_OBJS	EQU	TOTAL_BACK+TOTAL_ENEMY+TOTAL_ENEMY1+TOTAL_EXPLO+TOTAL_SHOT1+TOTAL_STATIC+TOTAL_EXTRA

;MuteSnd		EQU	D_RAM+$1FFC	; KEY_0 mute sound

c_start:				; Start Jaguar Programm

	move.l	#$00070007,G_END	; GPU Big Endian Mode
	move.l	#$00070007,D_END	; DSP Big Endian Mode
	move.w	#$35cc,MEMCON2		; Big Endian Mode

	move.l	#0,G_CTRL		; GPU stoppen
	move.l	#0,G_FLAGS
	move.l	#0,D_CTRL		; DSP stoppen
	move.l	#0,D_FLAGS

	move.l	VI,s_vi			; Alte Adresse VI retten
	move.w	#$FFFF,VI		; Video Interrupt
	move.l	sp,s_sp			; alten Stackpointer retten
	move.l  #INITSTACK,sp           ; Stackpointer festlegen


; Branch Objekte fr die 2 OP-Listen erstellen
	lea	olist1_branch,a0	; Adresse Branch Objekt
	move.l	#olist1_stop,d2		; Adresse Stop Objekt
	bsr	create_branch		; Branch Objekt erstellen

	lea	olist2_branch,a0	; Adresse Branch Objekt
	move.l	#olist2_stop,d2		; Adresse Stop Objekt
	bsr	create_branch		; Branch Objekt erstellen


;-----------------------------------------------------------------------
; Variablen initalisieren
;-----------------------------------------------------------------------
	move.l	#olist1,olist		; Adresse aktive OP-Liste
	move.l	#olist2,olist_ram	; Adresse zu erstellende OP-Liste
	move.l	#title1_daten,gegner	; Start der Gegnerdaten festlegen
	move.w	#2,PausAddr		; Scrolling nicht aktiv
	clr.w	x_pos			; X-Pos im ges. Spiel	
	move.l	#0,y_pos		; Y-Pos im Spiel
	move.w	#3,life_player1		; Anzahl Leben Player 1


;-----------------------------------------------------------------------
; Greetings und Titelbild entpacken
;-----------------------------------------------------------------------
	lea	djag_gpu,a0		; Adresse JPEG-GPU Routinen
	bsr	copy_binfile		; JPEG-GPU Routinen kopieren
	bsr	copy_dehuff		; JPEG Huffmann Tabelle kopieren

	move.l	#title,In_Adr		; Adresse gepackte Daten
	move.l	#$150000,Out_Adr	; Adresse wohin entpackt wird
	move.l	#DEHUFF_ADDR,Dehuff_Adr	; Adresse Huffmann Tabelle
	move.l	#(384/8),Out_Width	; Breite Bild in Blcken
	move.l	#WID384,Out_E_Width	; Breite Bild in Pixeln
	bsr	start_gpu		; JPEG-GPU Routinen starten

wait_for_gpu:
	move.l	All_Done,d0
	cmpi.l	#$12345678,d0
	bne.s	wait_for_gpu

;-----------------------------------------------------------------------
; Adressen an GPU bergeben und Programm in GPU Ram kopieren
;-----------------------------------------------------------------------
	move.l	olist,$f03f40		; Adresse olist
	move.l	olist_ram,$f03f44	; Adresse olist_ram	
	move.l	#obj_data,$f03f48	; Adresse obj_data
	move.l	#TOTAL_OBJS,$f03f4C	; Anzahl Objekte (TOTAL_OBJS)
	move.l	#obj_gegner,$f03f50	; Adresse obj_gegner
	move.l	#x_pos,$f03f54		; Adresse X-Pos im Spiel
	move.l	gegner,$f03f58		; Startadresse Gegnerdaten
	move.l	#x1,$f03f5C		; X-Pos linkes Hintergrundbild
	move.l	#x2,$f03f60		; X-Pos rechtes Hintergrundbild
	move.l	#breit2,$f03f64		; Breite rechtes Hintergrundbild
	move.l	#lev_speed,$f03f68	; Geschwindigkeit fr Hintergrundscrolling
	move.l	#level_daten,$f03f6C	; Daten fr Hintergrundgrafiken
	move.l	#obj_enemy,$f03f70	; Adresse Platz fr Hintergrund Gegnersprites
	move.l	#r_type_kurve,$f03f74	; Kollisionskurve R-Type nach Lebensverlust
	move.l	#x3,$f03f78		; Adresse X-Pos linkes unteres Vordergrundbild
	move.l	#x4,$f03f7C		; Adresse X-Pos rechtes unteres Vodergrundbild
	move.l	#scr_unten,$f03f80	; Adresse Daten fr unteres Vordergrundscrolling
	move.l	#x5,$f03f84		; Adresse X-Pos linkes oberes Vordergrundbild
	move.l	#x6,$f03f88		; Adresse X-Pos rechtes oberes Vordergrundbild
	move.l	#scr_oben,$f03f8C	; Adresse Daten fr unteres Vordergrundscrolling
	move.l	#PausAddr,$f03f90	; Adresse Pause
	move.l	#x,$f03f94		; Adresse X-Pos R-Type
	move.l	#obj_shoot,$f03f98	; Adresse Schudaten Spieler
	move.l	#score1,$f03f9c		; Adresse Score Player 1
	move.l	#shoot_data1,$f03fa0	; Schudaten Player 1
	move.l	#shoot_count,$f03fa4	; Counter fr Schuroutine
	move.l	#y_pos,$f03fa8		; Y-Pos im Spiel
	move.l	#obj_extra,$f03fac	; Adresse Extras
	move.l	#money_player1,$f03fb0	; Geld Player 1
	move.l	#sample_daten,$f03fb4	; Startadresse Sampledaten
	move.l	#r_type_kurve1,$f03fb8	; Kollisionskurven R-Type
	move.l	#r_type_anim1,$f03fbc	; Animation R-Type nach Kollision
	move.l	#life_player1,$f03fc0	; Anzahl Leben Player 1

	lea	gpu_prog,a0		; Adresse GPU Routinen
	bsr	copy_binfile		; GPU Routinen kopieren

	move.l	#0,ICE_SOURCE		; auspacken nicht aktiv
	move.l	#0,SAM1_START		; Sample 1 nicht aktiv
	lea	dsp_prog,a0		; Adresse DSP Routinen
	bsr	copy_binfile		; DSP Routinen kopieren
	bsr	start_dsp		; DSP Routinen starten


;-----------------------------------------------------------------------
; Video system initalization
;-----------------------------------------------------------------------
	lea	olist1,a0		; Adresse OP Liste
	move.l	#0,(a0)+		; 1 Teil STOP Objekt schreiben
	move.l	#4,(a0)+		; 2 Teil STOP Objekt schreiben

	lea	olist2,a0		; Adresse OP Liste
	move.l	#0,(a0)+		; 1 Teil STOP Objekt schreiben
	move.l	#4,(a0)+		; 2 Teil STOP Objekt schreiben

	jsr	VideoIni		; Videosubsystem initalisieren
	jsr	IntInit			; Interrupts initalisieren

	move.l	#olist1_stop,d0		; Adresse der Objekt Liste
	swap	d0			; Adresse vertauschen fr OP
	move.l	d0,OLP			; Adresse fr OP einstellen
	move.w  #$6C7,VMODE 		; Video Init 400x216 16 Bit RGB

;-----------------------------------------------------------------------
; Audio system initalization
;-----------------------------------------------------------------------

	move.w	#$100,PROPAD		; turns mute off once to ensure audio is audible
;	move.l	#0,MuteSnd		; MuteSound initialized

;-----------------------------------------------------------------------
; Title Build und Greetings 
;-----------------------------------------------------------------------
	move.l	#1,ICE_PRIORITY		; DSP Prioritt erhhen
; Explosionen entpacken
	move.l	#a,ICE_DEST		; Zieladresse gepackte Daten
	move.l	#schrift_ice,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist
	move.l	#0,ICE_PRIORITY		; DSP Prioritt heruntersetzen

	clr.w	bewegung1		; Kein Feuerknopf gedrckt
title1:	bsr	cnc			; Scan command and control
	bsr	testp1			; TEST response system

	bsr	start_gpu		; GPU Routinen starten
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	cmp.w	#Gonzales,x_pos		; WATCH FOR FALLING IMAGES
        beq.s	title2			; Ja
	tst.w	bewegung1		; Feuerknopf gedrckt?
	beq.s	title1			; Nein

; titlebild anzeigen bis Button gedrckt wurde
title2:	bsr	clear_sprites		; Alle Sprites ausschalten
	clr.w	x_pos			; X-Pos im ges. Spiel	
        clr.w   bewegung1               ; Kein Feuerknopf gedrckt
        move.l  #titel_daten,gegner     ; Start der titlebilddaten festlegen
	move.l	gegner,$f03f58		; Startadresse Gegnerdaten
	bsr	start_gpu		; GPU Routinen starten
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	move.w  #$4C7,VMODE 		; Video Init 384x216 16 Bit RGB
title3: bsr     cnc			; Scan command and conrol
	bsr	testp1			; TEST response system

        bsr     start_gpu               ; GPU Routinen starten
        stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
        cmp.w	#480,x_pos		; Ist Bild vollstndig hereingezoomt ?
        bne.s	title4			; Nein	
	lea	obj_gegner,a0
	add.l	#O_TYPE,a0
	move.b	#6,(a0)        
title4:	tst.w   bewegung1               ; Feuerknopf gedrckt?
        beq.s   title3                  ; Nein

	move.l	#1,ICE_PRIORITY		; DSP Prioritt erhhen
; immer bentigte Grafiken entpacken
	move.l	#explo,ICE_DEST		; Zieladresse gepackte Daten
	move.l	#native1,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist


;-----------------------------------------------------------------------
; Scrolling initalisieren
;-----------------------------------------------------------------------
init_game:
	lea	level_daten1,a0		; Daten Hintergrundscrolling
	move.l	(a0)+,pic1		; Grafik linker Hintergrund
	move.l	(a0)+,pic2		; Grafik rechter Hintergrund	
	clr.w	x1			; X-Pos linker Hintergrund
	move.w	#320,x2			; X-Pos rechter Hintergrund
	move.w	#0,y1			; Y-Pos linker Hintergrund (was 42,y1 JKD)
	move.w	#0,y2			; Y-Pos rechter Hintergrund (was 42,y2 JKD)
	move.w	#320/4,breit1		; Breite linker Hintergrund
	move.w	#320/4,breit2		; Breite rechter Hintergrund
	move.w	#320/4,offs1		; Offset Breite linker Hintergrund
	move.w	#320/4,offs2		; Offset Breite rechter Hintergrund
	move.l	a0,level_daten		; Daten Hintergrundscrolling		

	move.w	#42+MAX_Y+(226*2),d2	; fr Y-Pos berechnen
	lea	level_daten2,a0		; Daten unteres Vordergrundscrolling	
	move.l	(a0)+,pic3		; Grafik linker unterer Vordergrund
	move.w	(a0)+,d0		; Hhe linker unterer Vordergrund
	move.w	(a0)+,d1		; Objekt Typ linker unterer Vordergrund
	move.b	d1,type3		; Objekt Typ linker unterer Vordergrund
	move.w	d0,high3		; Hhe linker unterer Vordergrund
	add.w	d0,d0			; Hhe * 2
	sub.w	d0,d2			; Y-Pos linker unterer Vordergrund berechnen
	move.w	d2,y3			; Y-Pos linker unterer Vordergrund schreiben
	clr.w	x3			; X-Pos linker unter Vordergrund
	move.w	#320/4,breit3		; Breite linker unter Vordergrund
	move.w	#320/4,offs3		; Offset Breite linker unter Vordergrund

	move.w	#42+MAX_Y+(226*2),d2	; fr Y-Pos berechnen
	move.l	(a0)+,pic4		; Grafik rechter unterer Vordergrund
	move.w	(a0)+,d0		; Hhe rechter unterer Vordergrund
	move.w	(a0)+,d1		; Objekt Typ rechter unterer Vordergrund
	move.b	d1,type4		; Objekt Typ rechter unterer Vordergrund
	move.w	d0,high4		; Hhe linker unterer Vordergrund
	add.w	d0,d0			; Hhe * 2
	sub.w	d0,d2			; Y-Pos linker unterer Vordergrund berechnen
	move.w	d2,y4			; Y-Pos linker unterer Vordergrund schreiben
	move.l	a0,scr_unten		; Daten unteres Vordergrundscrolling
	move.w	#320,x4			; X-Pos rechter unter Vordergrund
	move.w	#320/4,breit4		; Breite rechter unter Vordergrund
	move.w	#320/4,offs4		; Offset Breite rechter unter Vordergrund
	
	lea	level_daten3,a0		; Daten oberes Vordergrundscrolling	
	addq.l	#4,a0			; Grafik bergehen
	move.w	(a0)+,high5		; Hhe linker oberer Vordergrund
	move.w	(a0)+,d0		; Objekt Typ linker oberer Vordergrund
	move.b	d0,type5		; Objekt Typ linker oberer Vordergrund
	addq.l	#4,a0			; Grafik bergehen
	move.w	(a0)+,high6		; Hhe rechter oberer Vordergrund
	move.w	(a0)+,d0		; Objekt Typ rechter oberer Vordergrund
	move.b	d0,type6		; Objekt Typ rechter oberer Vordergrund
	move.l	a0,scr_oben		; Daten oberes Vordergrundscrolling
	clr.w	x5			; X-Pos linker oberer Vordergrund
	move.w	#320/4,breit5		; Breite linker oberer Vordergrund
	move.w	#320/4,offs5		; Offset Breite linker oberer Vordergrund
	move.w	#320,x6			; X-Pos rechter oberer Vordergrund
	move.w	#320/4,breit6		; Breite rechter oberer Vordergrund
	move.w	#320/4,offs6		; Offset Breite rechter oberer Vordergrund

; Geld Anzeige lschen
	lea	anzeige1+124,a0	
	moveq	#8,d0			; Hhe
init_game1:
	move.w	#8*3,d1			; Breite in Pixeln	
init_game2:
	move.w	#0,(a0)+
	dbra	d1,init_game2		; Wiederholen fr Breite
	lea	208(a0),a0
	dbra	d0,init_game1		; Wiederholen fr Hhe


;-----------------------------------------------------------------------
; Variablen fr Spiel initalisieren
;-----------------------------------------------------------------------
	bsr	clear_sprites		; Alle Sprites ausschalten
	cmp.w	#99,life_player1	; Ja, dann Cheatmode
	beq.s	init_game3
	move.w	#3,life_player1		; Anzahl Leben Player 1
init_game3:	
	move.w	#$FFFF,VI		; Video Interrupt ausschalten
	clr.w	x_pos			; X-Pos im ges. Spiel	
	move.l	#0,y_pos		; Y-Pos im Spiel
	clr.w	PausAddr			; Pause nicht aktiv
	move.w	#2,lev_speed		; 60 / 2 Bilder fr Hintergrund
	move.l	#0,score1		; Score Player 1 Init
	move.l	#10000,score2		; Highscore Init
	move.w	#0,money_player1	; Geld Player 1
	move.l	#SHOOT_SPEED,shoot_count	; Counter wie oft Schuroutine aufgerufen wird
	move.w	#7,power1		; Energie Player 1 setzen
	move.w	#9,rtype_anim1		; Welcher R-Type Sprite ( 9 = Standardsprite)
	clr.w	bewegung1		; Keine Bewegung aktiv
	clr.w	beam_player1		; Schustrke Player 1

	move.l	#level_daten,$f03f6C	; Daten fr Hintergrundgrafiken
	move.l	#gegner_daten,gegner	; Start der Gegnerdaten festlegen
	move.l	gegner,$f03f58		; Startadresse Gegnerdaten
	move.l	#scr_unten,$f03f80	; Adresse Daten fr unteres Vordergrundscrolling
	move.l	#scr_oben,$f03f8C	; Adresse Daten fr unteres Vordergrundscrolling
	move.b	#6,type1		; linkes Hintergrundbild
	move.b	#6,type2		; rechtes Hintergrundbild
	move.b	#7,type7		; Objekt Type obere Anzeige
	move.b	#7,type8		; Objekt Type untere Anzeige
	move.b	#0,p1_typ		; Objekt Type R-Type Sprite


;-----------------------------------------------------------------------
; Grafiken entpacken
;-----------------------------------------------------------------------
	move.l	#1,ICE_PRIORITY		; DSP Prioritt erhhen
;;;
;;; Starfield unpacked
;;;
	move.l	#whnNASA,ICE_DEST	; Zieladresse gepackte Daten
	move.l	#whnNASA_ice,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist
;;;
;;; Paused unpacked
;;;
	move.l	#pausejkd,ICE_DEST	; Zieladresse gepackte Daten
	move.l	#pausejkd_ice,ICE_SOURCE; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist

; Leiter senkrecht entpacken
	move.l	#leiterbs,ICE_DEST	; Zieladresse gepackte Daten
	move.l	#leiterbs_ice,ICE_SOURCE; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist

; S_CRA entpacken
	move.l	#s_cra,ICE_DEST		; Zieladresse gepackte Daten
	move.l	#s_cra_ice,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist
;;;
;;; ROTG entpacken
;;;
	move.l	#rotg,ICE_DEST		; Zieladresse gepackte Daten
	move.l	#rotg_ice,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist

;-----------------------------------------------------------------------
; Hauptprogramm
;-----------------------------------------------------------------------
	move.w	#n_vde+1,VI		; 
	move.w  #$6C1,VMODE 		; Video Init 320x226 16 Bit CRY

	bsr	flip_first		; Oberen Vordergrund 1 x komplett spiegeln
main:	move.l	#0,ICE_PRIORITY		; DSP Prioritt heruntersetzen

	tst.w	PausAddr		; Ist Pause aktiv ?
	bne.s	main1			; <> 0, Ja
	bsr	flip			; 1 Spalte oberen Vordergrund spiegeln

main1:	bsr	cnc			; Scan command and control
	bsr	parse_inpt		; GAME Response System

	bsr	scr_y			; Scrolling in Y-Richtung
	bsr	anim			; Animation R-Type Sprite
	bsr	start_gpu		; GPU Routinen starten
	bsr	life			; Anzahl Leben anzeigen
	bsr	draw_energy		; Energie Player 1 anzeigen
	bsr	draw_beam		; Beam Animation anzeigen

	move.l	score1,d5		; Score Player 1
	lea	anzeige,a0		; Startadresse Bildschirmspeicher	
	lea	54(a0),a0		; X=27, Y=0 (Breite Anzeige 192)
	lea	zahlen,a1		; Adresse der blauen Zahlen
	bsr	scr			; Score berechnen

	move.l	score1,d6		; Score Player 1
	move.l	score2,d5		; Highscore
	cmp.l	d5,d6			; Score Player 1 > Highscore ?
	bls.s	main2			; Nein
	move.l	d6,d5			; Score Player 1 => neuer Highscore
	move.l	d6,score2		; neuen Highscore zurckschreiben
		
main2:	lea	anzeige,a0		; Startadresse Bildschirmspeicher
	lea	282(a0),a0		; X=141, Y=0 (Breite Anzeige 192)
	lea	zahlen1,a1		; Adresse der roten Zahlen
	bsr	scr			; Score berechnen

	bsr	money0			; Geld Player 1 anzeigen

	move.l	#1,ICE_PRIORITY		; DSP Prioritt erhhen
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	cmp.w	#33333,x_pos		; Spiel beendet ? (14500)
	bne	main			; Nein, dann wiederholen	
	bsr	game_over		; Spiel wurde gelst


;-----------------------------------------------------------------------
; Programm Ende, zurck zum JagServer
;-----------------------------------------------------------------------
ende:	move.l	s_sp,sp			; alten Stackpointer wiederherstellen
	move.l	s_level2,LEVEL2.l	; Alte Interrupt Adresse wiederherstellen
	move.l	s_vi,VI
	move.l	s_int1,INT1
	move.w	s_sr,sr			; Statusreg. wiederherstellen
	move.l	#0,G_CTRL		; GPU Programm beenden
	move.l	#0,D_CTRL		; DSP Programm beenden
	move.w	#$4C0,VMODE		; Alte Auflsung wieder einstellen
	rts				; asta, la vista Baby


;--------------------------------------------------------------------------
; Warten bis Daten entpackt wurden
;--------------------------------------------------------------------------
ice_busy:
	move.l	#ICE_BUSY,a0		; Adresse DSP belegt/frei
ice_busy1:
	cmp.l	#0,(a0)			; ist DSP frei?
	bne.s	ice_busy1		; Nein
	rts


;--------------------------------------------------------------------------
; Alle Sprites ausschalten
;--------------------------------------------------------------------------
clear_sprites:
	lea	obj_data,a0		; Startadresse Sprite Bnke
	move.w	#TOTAL_OBJS-1,d0	; Anzahl Sprites
	add.l	#O_TYPE,a0		; auf Objekt Type setzen
clear_sprites1:
	move.b	#5,(a0)			; Sprite ausschalten
	add.l	#OBJSIZE,a0		; auf nchsten Sprite setzen
	dbra	d0,clear_sprites1	; Wiederholen fr Anzahl Sprites
	rts
	

;--------------------------------------------------------------------------
; UP fr JagPeg Routinen
;--------------------------------------------------------------------------
copy_dehuff:
	lea	dhuf_abs,a0
	lea	DEHUFF_ADDR,a1
	move.l	#(DEHUFF_SIZE/4),d0	; Divide by 4 so we can copy longs
copy_dehuff1:
	move.l	(a0)+,(a1)+
	dbra	d0,copy_dehuff1

	lea	dq75_abs,a0
	lea	DQ_Adr,a1
	move.w	#(320/4),d0		; Divide by 4 so we can copy longs
copy_dq1:
	move.l	(a0)+,(a1)+
	dbra	d0,copy_dq1
	rts


;--------------------------------------------------------------------------
; Branch Objekte fr Objekt Listen erstellen
;--------------------------------------------------------------------------
; In:	A0	; Adresse Branch Objekt
; 	D2	; Adresse Stop Objekt
create_branch:
; Erstes BRANCH Objekt (branch if a_vde < VC)
	clr.l   d1
	move.l  #(BRANCHOBJ|O_BRGT),d0  ; YPOS < VC

; Format Link erstellen
	movem.l d0-d7,-(sp)		;d2-d3
	andi.l  #$3FFFF8,d2             ; Ensure alignment/valid address
	move.l  d2,d3                   ; Make a copy
	
	swap    d2                      ; This section places bits 10-3
	clr.w   d2                      ; in bits 31-24. It saves cycles
	lsl.l   #5,d2                   ; over using three shifts.
	or.l    d2,d0

	lsr.l   #8,d3                   ; Put bits 21-11 in bits 42-32
	lsr.l   #3,d3
	or.l    d3,d1
;;;	movem.l (sp)+,d0-d7             ; Restore regs d2-d3
; Ende Format Link erstellen

	move.w	#SCRN_TOP,d3		; oberer Rand
	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+                                
	move.l  d0,(a0)+                ; First OBJ is done.

; Zweites BRANCH Objekt (branch if a_vdb > a_vdb)   
	andi.l  #$FF000007,d0           ; Mask off CC and YPOS
	ori.l   #O_BRLT,d0              ; $8000 = YPOS < VC
	move.w  #(disp_height)*2+SCRN_TOP,d3	; unterer Rand

	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+                ; Second OBJ is done
	move.l  d0,(a0)+

	movem.l (sp)+,d0-d7             ; Restore regs d2-d3  
	rts


;-----------------------------------------------------------------------
; Scrolling in Y-Pos
;-----------------------------------------------------------------------
scr_y:	move.l	y_pos,d0		; Y-Pos im Spiel
	moveq	#0,d1
	move.w	bewegung1,d1		; Bewegung Player 1
	ext.l	d1			; D1 auf Langwort erweitern (wegen negativen Zahlen)
	add.l	d1,d1			; Bewegung * 2
	add.l	d1,d0			; Bewegung + Y-Pos berechnen

	cmp.l	#-30,d0		
	bge.s	scr_y1
	moveq	#-30,d0
scr_y1:	cmp.l	#30,d0
	ble.s	scr_y2
	moveq	#30,d0
scr_y2:	move.l	d0,y_pos		
	rts
	

;-----------------------------------------------------------------------
; R-Type animieren und Clipping
;-----------------------------------------------------------------------
anim:	move.w	rtype_anim1,d0		; Animation Player 1
	move.w	bewegung1,d1		; Bewegung Player 1
	beq.s	anim2			; Keine Bewegung
	add.w	d1,d0			; Bewegung nur Animation addieren	
	bpl.s	anim1			; erster Animationsprite ?
	moveq	#0,d0			; Animation auf 1 Sprite setzen
anim1:	cmp.w	#19-1,d0		; letzter Animationssprite ? (was #18-1,d0)
	bls.s	anim4			; Ja
	moveq	#19-1,d0		; Animation auf letzten Sprite setzen (was #18-1,d0)
	bra.s	anim4

; Keine Bewegung, zurck in Ausgangsstellung 
anim2:	cmp.w	#9,d0			; Animation in Ausgangsstellung ?
	beq.s	anim4			; Ja, dann nicht anpassen
	cmp.w	#9,d0			; Animation nach unten
	bls.s	anim3			; Ja
	subq.w	#1,d0			; zurck in Ausgansgstellung
	bra.s	anim4
anim3:	addq.w	#1,d0			; zurck in Ausgansgstellung

anim4:	move.w	d0,rtype_anim1		; Animation Player 1 zurckschreiben
	lea	NBLR3JKD,a0		; Adresse R-Type Sprites
	mulu.w	#32*16*2,d0		; Offset zum R-Type Start berechnen
	add.w	d0,a0			; neue R-Type Adresse berechnen
	move.l	a0,player		; neue R-Type Adresse zurckschreiben
	clr.w	bewegung1		; Bewegung nicht mehr aktiv

; Clipping
	move.w	x,d0			; X-Pos R-Type
	move.w	y,d1			; Y-Pos R-Type
	cmp.w	#320,d0			; X-Pos am rechten Rand ?
	ble.s	anim5			; Nein
	move.w	#320,d0			; X-Pos begrenzen
anim5:	tst.w	d0			; X-Pos am linken Rand ?
	bge.s	anim6			; Nein
	moveq	#0,d0			; X-Pos begrenzen

anim6:	cmp.w	#226*2+42,d1		; Y-Pos am unteren Rand ?
	ble.s	anim7			; Nein
	move.w	#226*2+42,d1		; Y-Pos begrenzen
anim7:	cmp.w	#42-10,d1		; Y-Pos am linken Rand ?
	bge.s	anim8			; Nein
	moveq	#42-10,d1		; Y-Pos begrenzen
anim8:	move.w	d0,x			; X-Pos zurckschreiben
	move.w	d1,y			; Y-Pos zurckschreiben
	tst.b	p1_typ			; R-Type unverwundbar ?
	bne.s	anim9			; Nein
	move.l	p1_ani1,a1		; Adresse aktuelle Animationsliste
	move.l	a0,(a1)			; neue R-Type Adresse zurckschreiben
anim9:	rts

;-----------------------------------------------------------------------
; Animation fr Beamschu zeichnen
;-----------------------------------------------------------------------
draw_beam:
	move.l  B_CMD,d0        	; Ist Blitter frei ?
	andi.l  #1,d0			
	beq.s	draw_beam

	move.l	#anzeige1,A1_BASE	; Zieladresse
	move.l	#PIXEL16|XADDPIX|WID128|PITCH1,A1_FLAGS
	move.l	#$D0000|66,A1_PIXEL	; X=66, Y=13
	move.l	#$10000|$FFCC,A1_STEP	; 1 Zeile nach unten, 52 Pixel nach vorne

	lea	beam_s,a0
	move.w	beam_player1,d0
	cmp.w	#48,d0			; Max. Schustrke erreicht ?
	bls.s	beam_draw1		; Nein
	moveq	#48,d0			; auf max. Schustrke setzen
beam_draw1:	
	move.w	d0,beam_player1		; Max. Schustrke zurckschreiben
	lsr.w	#1,d0			; / 2
	mulu.w	#52*1*2,d0
	add.w	d0,a0
	move.l	a0,A2_BASE		; Quelladresse
	move.l	#PIXEL16|XADDPIX|WID128|PITCH1,A2_FLAGS
	move.l	#0,A2_PIXEL
	move.l	#$0|$FFCC,A2_STEP	; 52 Pixel nach links

	move.l	#$60000|52,B_COUNT	; 6 Zeilen, 52 Pixel
	move.l	#LFU_REPLACE|UPDA1|UPDA2|SRCEN,B_CMD
	rts


;-----------------------------------------------------------------------
; Vordergrund fr oben spiegeln
;-----------------------------------------------------------------------
flip_first:
	move.l  B_CMD,d0        	; Ist Blitter aktiv ?
	andi.l  #1,d0			
	beq.s	flip_first		; Ja, dann weiter abfragen

	move.l	scr_oben,a0		; Adresse Daten fr oberes Scrolling
	sub.l	#16,a0			; Auf Daten linkes oberes Vordergrundbild setzen
	move.l	(a0)+,a1		; Quelladresse Grafik
	move.w	(a0),d0			; Hhe der Grafik
	move.w	d0,d2

; Angaben fr Blitter
	swap	d0			; Hhe ins obere Wort
	move.w	#320,d0			; 320 Pixel pro Zeile
	move.l	d0,B_COUNT

; Angaben fr Ziel
	move.l	pic5,A1_BASE		; Zieladresse
	move.l	#PIXEL16|XADDPIX|WID320|PITCH1,A1_FLAGS
	move.l	#0,A1_PIXEL

	move.w	#1,d1			; 1 Zeile nach unten
	swap	d1
	move.w	#-320,d1		; 320 Pixel nach links
	move.l	d1,A1_STEP

; Angaben fr Quelle
	move.l	a1,A2_BASE		; Quelladresse
	move.l	#PIXEL16|XADDPIX|WID320|PITCH1,A2_FLAGS
	
	subq.w	#1,d2
	swap	d2
	move.w	#0,d2			; X-Pos 0
	move.l	d2,A2_PIXEL		

	move.w	#-1,d1			; 1 Zeile nach oben
	swap	d1
	move.w	#-320,d1		; 320 Pixel nach links
	move.l	d1,A2_STEP

	move.l	#LFU_REPLACE|UPDA2|UPDA1|SRCEN,B_CMD	; go Blitter go...
	rts


;-----------------------------------------------------------------------
; 1 Spalte oberen Vordergrund spiegeln 
;-----------------------------------------------------------------------
flip:	move.l  B_CMD,d0        	; Ist Blitter aktiv ?
	andi.l 	#1,d0			
	beq.s	flip			; Ja, dann weiter abfragen

	move.l	scr_oben,a0		; Adresse Daten fr oberes Scrolling
	subq.l	#8,a0
	cmp.w	#5,6(a0)		; Objekt aktiv? (5 = nein)
	beq.s	flip1			; Nein
	move.l	(a0)+,a1		; Quelladresse Grafik
	move.w	(a0),d0			; Hhe der Grafik
	move.w	d0,d3			; Hhe retten

; Angaben fr Blitter
	swap	d0			; Hhe ins obere Wort
	move.w	#1,d0			; 1 Pixel pro Zeile
	move.l	d0,B_COUNT

; Angaben fr Ziel
	move.l	pic6,A1_BASE		; Zieladresse
	move.l	#PIXEL16|XADDPIX|WID320|PITCH1,A1_FLAGS

	move.l	#320,d2			; Breite eines Bildes in Pixeln
	sub.w	x6,d2			; X-Pos wo Grafik angezeigt wird
	move.l	d2,A1_PIXEL

	move.w	#1,d1			; 1 Zeile nach unten
	swap	d1
	move.w	#-1,d1			; 1 Pixel nach links
	move.l	d1,A1_STEP

; Angaben fr Quelle
	move.l	a1,A2_BASE		; Quelladresse
	move.l	#PIXEL16|XADDPIX|WID320|PITCH1,A2_FLAGS

	subq	#1,d3			; Hhe - 1
	swap	d3			; Hhe ins obere Wort
	move.w	d2,d3			; X-Pos wo Grafik angezeigt wird
	move.l	d3,A2_PIXEL		

	move.l	#$FFFFFFFF,A2_STEP	; 1 Zeile nach oben, 1 Pixel nach links
	move.l	#LFU_REPLACE|UPDA2|UPDA1|DSTEN|SRCEN,B_CMD	; go Blitter go...
flip1:	rts


;-----------------------------------------------------------------------
; Scores berechnen
;-----------------------------------------------------------------------
; In:	D5: Player Score				(L)
;	A0: Bildschirmspeicher um Zahlen zu zeichnen	(L)
;	A1: Adresse der Zahlengrafik			(L)
; Out:	-
scr:	cmp.l	#999999,d5		; Score auf max. Gre prfen
	bls.s	scr0			; Score kleiner
	move.l	#999999,d5		; Score auf max. Gre setzen
scr0:	lea     scr_daten(PC),a3	; Zahlen um Score zu berechnen
	moveq   #6-1,d6			; Anzahl Score Stellen
scr1:	move.l  (a3)+,d7		; Variable um Score zu berechnen z.B. 10,100,1000 usw.
	movea.l a1,a2			; Adresse Zahlen initalisieren
scr2:	sub.l   d7,d5			; Wieviel mal z.B 10,100 usw. hineinpat ermitteln
	bmi.s   scr3			; Wenn Negativ ist Anzahl ermittelt
	lea     128(a2),a2		; Adresse auf nchste Zahl setzen
	bra.s   scr2			; Wiederholen bis Zahl ermittelt ist
scr3:	add.l   d7,d5			; Score wieder richtig einstellen
	moveq   #8-1,d0			; Hhe 8 Pixel
scr4:	movem.l	(a2)+,d1-d4		; 8 Pixel lesen
	movem.l	d1-d4,(a0)		; 8 Pixel schreiben	
	lea	192*2(a0),a0		; auf nchste Zeile setzen
	dbra	d0,scr4			; Wiederholen fr Hhe einer Zahl
	lea     -3056(a0),a0		; Offset zur nchsten Zahl addieren
	dbra    d6,scr1			; Wiederholen fr Anzahl Stellen
	rts

; Zahlen um Score zu berechnen
scr_daten:
	DC.L 100000
	DC.L 10000
	DC.L 1000
	DC.L 100
	DC.L 10
	DC.L 1
	even

;-----------------------------------------------------------------------
; Geld berechnen
;-----------------------------------------------------------------------
money0:	lea	anzeige1+124,a0		; X=62, Y=0 (Breite Anzeige 128) Startadresse Bildschirmspeicher
	lea	zahlen,a1		; Adresse der roten Zahlen
	moveq	#0,d5			; Variable Init
	move.w	money_player1,d5	; Geld Player 1
	lea     scr_daten+12(PC),a3	; Zahlen um Score zu berechnen
	moveq	#0,d4			; fr Check auf fhrende Nullen
	moveq   #3-1,d6			; Anzahl Score Stellen
	cmp.w	#999,d5			; Geld auf max. Gre prfen
	bls.s	money1			; Geld kleiner
	move.w	#999,d5			; Geld auf max. Gre setzen
money1:	move.l  (a3)+,d7		; Variable um Score zu berechnen z.B. 10,100,1000 usw.
	movea.l a1,a2			; Adresse Zahlen initalisieren
money2:	sub.l   d7,d5			; Wieviel mal z.B 10,100 usw. hineinpat ermitteln
	bmi.s   money3			; Wenn Negativ ist Anzahl ermittelt
	lea     128(a2),a2		; Adresse auf nchste Zahl setzen
	addq	#1,d4			; sol. 0, ist es eine fhrende Null
	bra.s   money2			; Wiederholen bis Zahl ermittelt ist
money3:	add.l   d7,d5			; Score wieder richtig einstellen
	moveq   #8-1,d0			; Hhe 8 Pixel
	tst.w	d6			; letzte Stelle?
	beq.s	money4			; Ja, dann darstellen
	tst.w	d4			; 0 = fhrende Null
	beq.s	money5			; nicht zeichnen, da fhrende Null
money4:	movem.l	(a2)+,d1-d3/a4		; 8 Pixel lesen
	movem.l	d1-d3/a4,(a0)		; 8 Pixel schreiben	
	lea	128*2(a0),a0		; auf nchste Zeile setzen
	dbra	d0,money4		; Wiederholen fr Hhe einer Zahl
	lea     -2032(a0),a0		; Offset zur nchsten Zahl addieren
money5:	dbra    d6,money1		; Wiederholen fr Anzahl Stellen
	rts


;-----------------------------------------------------------------------
; Energie anzeigen
;-----------------------------------------------------------------------
draw_energy:
	move.l  B_CMD,d0        	; Ist Blitter frei ?
	andi.l  #1,d0			
	beq.s	draw_energy		; Ja, dann weiter abfragen
	
	lea	energy,a0		; Adresse Energie Anzeige
	move.w	power1,d0		; Energie Player1 laden

draw_energy1:
	move.l	#anzeige,A1_BASE	; Zieladresse
	move.l	#PIXEL16|XADDPIX|WID192|PITCH1,A1_FLAGS
	move.l	#$210000|56,A1_PIXEL	; X=56, Y=33
	move.l	#$10000|$FFE0,A1_STEP	; 1 Zeile nach unten, 32 Pixel nach vorne

	mulu.w	#32*4*2,d0		; Offset Energie Anzeige ermitteln
	add.w	d0,a0			; Offset zur Adresse addieren
	move.l	a0,A2_BASE
	move.l	#PIXEL16|XADDPIX|PITCH1,A2_FLAGS
	move.l	#0,A2_PIXEL

	move.l	#$40000|32,B_COUNT	; 4 Zeilen, 32 Pixel
	move.l	#LFU_REPLACE|UPDA1|SRCEN,B_CMD
	rts


;-----------------------------------------------------------------------
; Anzahl Leben anzeigen
;-----------------------------------------------------------------------
life:	move.w	life_player1,d0		; Anzahl Leben Player 1
	beq.s	game_over		; Spielende wenn Anzahl Leben = 0
	cmp.w	#9,d0			; Anzahl Leben > 9 ?
	bls.s	life1			; Nein
	moveq	#9,d0			; Max. 9 anzeigen	
life1:	move.w	#8*11*2,d1		; Gre einer Zahl in Byte
	mulu.w	d0,d1			; Start der Zahl ermitteln
	lea	anzeige,a0		; Startadresse Bildschirmspeicher	
	lea	4698(a0),a0		; X=45, Y=12 (Breite Anzeige 192)
	lea	zahlen2,a1		; Adresse der groen Zahlen
	add.w	d1,a1			; Startadresse ermitteln			
	moveq	#11-1,d0		; Hhe einer Zahl
life2:	movem.l	(a1)+,d1-d4		; 8 Pixel lesen
	movem.l	d1-d4,(a0)		; 8 Pixel schreiben
	lea	192*2(a0),a0		; auf nchste Zeile setzen
	dbra	d0,life2		; Wiederholen fr Anzahl Zeilen
	rts


;-----------------------------------------------------------------------
; Game Over
;-----------------------------------------------------------------------
game_over:
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	move.w	#2,PausAddr		; Scrolling nicht aktiv
	clr.w	x_pos			; X-Pos im ges. Spiel	
	move.l	#0,y_pos		; Y-Pos im Spiel
	move.w	#-60,x			; X-Pos R-Type Sprite neu festlegen
	
	move.l	#1,ICE_PRIORITY		; DSP Prioritt erhhen
	move.l	#scrbdjkd,ICE_DEST	; Zieladresse gepackte Daten
	move.l	#scrbdjkd_ice,ICE_SOURCE; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist

	move.l	#btnjkd,ICE_DEST	; Zieladresse gepackte Daten
	move.l	#btnjkd_ice,ICE_SOURCE	; Startadresse gepackte Daten
	bsr	ice_busy		; warten bis DSP fertig ist
	move.l	#0,ICE_PRIORITY		; DSP Prioritt heruntersetzen

        move.l  #ende_daten,gegner     ; Start der titlebilddaten festlegen
	move.l	gegner,$f03f58		; Startadresse Gegnerdaten
	clr.w	bewegung1		; Kein Feuerknopf gedrckt
	bsr	start_gpu		; GPU Routinen starten
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
game_over1:
	bsr	cnc			; Joypad command and control
	bsr.s	testp1			; Joypad action test

	bsr	start_gpu		; GPU Routinen starten
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	tst.w	bewegung1		; Feuerknopf gedrckt?
	beq.s	game_over1		; Nein
	bsr	clear_sprites		; Alle Sprites ausschalten
	bsr	start_gpu		; GPU Routinen starten
	stop	#$2000			; 68K Anhalten bis zum nchsten IRQ
	add.l	#4,sp			; Stack anpassen, da direkt zurckgesprungen wird
	bra	init_game		; Prog beenden * und # gedrckt

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;	Procedure: TEST Input for TITLE SCREEN / SCOREBOARD
;;;	Wait for fire buttons to continue & LIFE easter egg 
;;;
;;;       3        2	    1
;;;      10987654 32109876 54321098 76543210
;;; d0 = xxAPxxBx RLDU741* xxCxxxOx 2580369#
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

testp1:
	movem.l	d0-d7,-(sp)		; begin stackpointer

	move.l	joy1cur,d0		; Current Ranger 1
	move.l	joy1edge,d1		; Fire Ranger 1

	btst.l	#KEY_0,d1		; Ranger 1 Taste Key '0'
	beq.s	titlepad		; titlepad for Ranger 1
	move.w	#99,life_player1	; Still Alive... and Well?
;	bne	testp2			; Ranger 2 Scan

titlepad:
	btst.l  #FIRE_A,d1		; Ranger 1 A
	bne.s   test_finale		; End Test
	btst.l	#FIRE_B,d1		; Ranger 1 B
	bne.s   test_finale		; End Test
	btst.l	#FIRE_C,d1		; Ranger 1 C
	bne.s   test_finale		; End Test
	bra	testp2			; next function

testp2:
	move.l	joy2cur,d0		; Current Ranger 2
	move.l	joy2edge,d1		; Fire Ranger 2

	btst.l	#KEY_0,d1		; Ranger 2 Taste Key '0'
	bne.s	title2pad		; titlepad for Ranger 2
	move.w	#99,life_player1	; Still Alive... and Well?

title2pad:
	btst.l  #FIRE_A,d1		; R2 A
	bne.s   test_finale
	btst.l	#FIRE_B,d1		; R2 B
	bne.s   test_finale
	btst.l	#FIRE_C,d1		; R2 C
	bne.s   test_finale
	bra	ck_reset		; Reset

test_finale:
	move.w  #1,bewegung1            ; End Test
	movem.l	(sp)+,d0-d7		; end stackpointer & restore registers
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: Parse Input
;	     Use joystick inputs to update objects
;
;       3          2          1
;      10987654 32109876 54321098 76543210
; d0 = xxAPxxBx RLDU741* xxCxxxOx 2580369# 
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
parse_inpt:
	movem.l	d0-d7,-(sp)		; begin stackpointer

	move.l	joy1cur,d0		; Ranger 1 Thumb cur
	move.l	joy1edge,d1		; Ranger 1 Thumb edge

	tst.w	PausAddr		; If pause is still active...
	bne	ck_reset		; Dead End until pause is deactivated

;;;
;;;  Evaluate (***INVERTED***) Thumbstick status and execute code
;;;

ck_up:
	btst.l	#JOY_PUSH,d0		; STARBOARD Starship DESCENT
	beq.s	ck_down			; Nein
	sub.w	#4,y			; 2 Pixel nach oben
	move.w	#1,bewegung1		; Background Movement Bottom? (Bewegung des Raumschiffs nach oben)
	bra.s	ck_left			; Skip ck_down 
ck_down:
	btst.l	#JOY_PULL,d0		; PORT Starship ASCENT
	beq.s	ck_left			; Nein			
	add.w	#4,y			; 2 Pixel nach unten
	move.w	#-1,bewegung1		; Background Movement Top? (Bewegung des Raumschiffs nach unten)	
ck_left:
	btst.l	#JOY_LEFT,d0		; Cut Thrust, Drift BACKWARD
	beq.s	ck_right		; Nein
	sub.w	#1,x			; back 1 pixel at a time	
ck_right:
	btst.l	#JOY_RIGHT,d0		; Throddle Up, Thrust FORWARD
	beq.s	fire_a			; Nein
	add.w	#2,x			; forward 2 pixels at a time

;;;
;;;  Evaluate each fire (bolt) button status and execute code
;;;

fire_a:
	btst.l	#FIRE_A,d0		; Standard Rapid Fire
	beq.s	shift_r			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
	bra.s	s_blast_r
shift_r:	
	btst.l	#SHIFT_R,d0		; Shift Fire
	beq.s	s_blast_r		; Nein
	add.w	#1,beam_player1		; Schustrke Player 1 erhhen
	bne	ck_reset
s_blast_r:
	move.w	beam_player1,d1		; Schustrke Player 1 laden
	beq.s	fire_b			; 0 = kein Beam aufgeladen	
	lea	beam_daten,a0		; Adresse fr Beamschsse laden
	lsr.w	#3,d1			; Schustrke Player 1 / 8
	lsl.w	#2,d1			; fr Adressberechnung * 4
	move.l	0(a0,d1.w),shoot_data1	; Neuen Beamschu aktivieren
	clr.w	beam_player1		; Kein Beam Schu mehr aktiv
	move.l	#1,shoot_count		; Schucounter auf 1, damit Beam sofort aktiv wird
fire_b:
	btst.l	#FIRE_B,d0		; Standard Rapid Fire
	beq.s	fire_c			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
fire_c:
	btst.l	#FIRE_C,d0		; Standard Rapid Fire
	beq.s	shift_l			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
	bra.s	s_blast_l
shift_l:	
	btst.l	#SHIFT_L,d0		; Shift Fire
	beq.s	s_blast_l		; Nein
	add.w	#1,beam_player1		; Schustrke Player 1 erhhen
	bne	ck_reset
s_blast_l:
	move.w	beam_player1,d1		; Schustrke Player 1 laden
	beq.s	fire_x			; 0 = kein Beam aufgeladen	
	lea	beam_daten,a0		; Adresse fr Beamschsse laden
	lsr.w	#3,d1			; Schustrke Player 1 / 8
	lsl.w	#2,d1			; fr Adressberechnung * 4
	move.l	0(a0,d1.w),shoot_data1	; Neuen Beamschu aktivieren
	clr.w	beam_player1		; Kein Beam Schu mehr aktiv
	move.l	#1,shoot_count		; Schucounter auf 1, damit Beam sofort aktiv wird
fire_x:
	btst.l	#FIRE_X,d0		; Standard Rapid Fire
	beq.s	fire_y			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
fire_y:
	btst.l	#FIRE_Y,d0		; Standard Rapid Fire
	beq.s	fire_z			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
fire_z:
	btst.l	#FIRE_Z,d0		; Standard Rapid Fire
	beq.s	ck_key1			; Nein
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren

;;;
;;;  Evaluate each keypad button and execute code independently.
;;;

;	  ======================================================
;	 |	*ck_key1	*ck_key2	*ck_key3	|
;	 |	*unused		*unused		*unused 	|
;	[							 ]
;	 |	ck_key4		* Standard	ck_key6		|
;	 |	SHIFT_L		* ProControl	SHIFT_R		|
;	 |							|
;	 |	ck_key7		ck_key8		ck_key9		|
;	 |	FIRE_Z		fIRE_Y		FIRE_X		|
;	[							 ]
;	 |	ck_keyS		ck_key0		ck_keyH		|
;	 |	(reset+H)     (lives/clap)	(reset+S)	|
;	  ======================================================

ck_key1:
	btst.l	#KEY_1,d0		; (*) Standard Rapid Fire
	beq.s	ck_key2			; Next check
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
ck_key2:
	btst.l	#KEY_2,d0		; (*) Standard Rapid Fire
	beq.s	ck_key3			; Next check
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
ck_key3:
	btst.l	#KEY_3,d0		; (*) Standard Rapid Fire
	beq.s	ck_key5			; Next check
	move.l	#schuss_daten1,shoot_data1; neuen Schu aktivieren
;=========================================================================;
;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;;
;=========================================================================;
ck_key5:
		btst.l	#KEY_5,d1
		beq.b	ck_pause
		move.l	#ende_daten,pausejkd	; display 'PAUSED'
;=========================================================================;
;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;; TEST ;;;
;=========================================================================;
ck_pause:
	btst.l	#PAUSE,d1		; PAUSE Button
	beq.s	ck_reset		; Reset
	tst.w	PausAddr		; Ist Pause aktiv ?
	bne.s	no_pause		; Ja, dann inaktiveren
	move.w	#1,PausAddr		; Pause aktivieren
	bra	inpt_exit		; Ende Joypad Abfrage
	
no_pause:	
	clr.w	PausAddr		; keine Pause mehr aktiv

;;;ck_option:
;	btst.l	#OPTION,d1		; OPTION Button
;	beq.s	ck_reset		; Reset
;	tst.w	PausAddr		; Ist Pause aktiv ?
;	bne.s	no_pause		; Ja, dann inaktiveren
;	move.w	#1,PausAddr		; Pause aktivieren
;;;	bra	inpt_exit		; Ende Joypad Abfrage

;ck_mute:
;		btst.l	#KEY_0,d1		; Clap on. Clap off...
;		beq	ck_pause		; Test when sound is added
;		move.l	MuteSnd,d6		; Test when sound is added
;		bchg.l	#0,d6			; Test when sound is added
;		move.l	d6,MuteSnd		; Test when sound is added
;;;		bra	rangecheck		; mod from scalvars cpkdemo

ck_reset:
		btst.l	#KEY_HASH,d0		; ProPad #
		beq.s	ck_Ranger2		; Next Port
		btst.l	#KEY_STAR,d0		; ProPad *
		beq.s	ck_Ranger2		; Next Port
		add.l	#KEY_0,sp		; Stack anpassen, da direkt zurckgesprungen wird
		bra	init_game		; Restart Mission

ck_Ranger2:
		lea	NBLR3JKD,a0	; did we just do pad 1 or 2?
		cmpa.l	a0,a1
		beq.b	inpt_exit

		lea	NBLR3JKD,a1	; Ranger 2 Active?
		move.l	joy2cur,d0	; necessary to perform following modulo 32 BTST
		add.l	joy2edge,d1	; necessary to perform following modulo 32 BTST
		bra	ck_up		; Begin D-PAD Loop for Ranger 2

inpt_exit:				; handle input end
	movem.l	(sp)+,d0-d7		; end stackpointer & restore registers
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: Command and Control (cnc) modified from JOYPAD/DEMO.S Example
;	      Read both joypads and update state variables.
;
; This example code demonstrates how to interrogate the input matrix (for 2 players)
; and how to process the results. Store a bitmask of the current state of the joysticks
; in joy1cur and joy2cur. The variables joy1edge and joy2edge stores a state bitmap of
; new key 'down' events (never 'up' events) since the last time "cnc" was called.
;
; The code below may be altered by removing two AND instructions so that
; joy1edge and joy2edge contain a bitmap of keys that have changed (not
; pressed). If desired, this data could be compared to joy1cur and joy2cur
; to determine the actual button state.
;
;  IMPORTANT MODIFICATION:
;	8/3/93 JS - The masks which are stored in JOYOUT and then retrieved via JOYIN now
; ensure that bit #8 is high which is imperitive for audio to be audible.  Your initialization
; routine should store $100 into (JOYSTICK/JOYOUT/JOYIN) in case your "readpad" function is
; not called right away (I can see it now, "HEY, why isn't my title screen music playing???").
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cnc:
;scan for propad 1
	movem.l	d0-d7,-(sp)			; begin stackpointer

	move.l	#$f0fffffc,d1			; d1 = Propad data mask
	moveq.l	#-1,d2				; d2 = Cumulative Propad reading

	move.w	#$81fe,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read Propad, pause button, A button
	or.l	d1,d0				; Mask off unused bits
	ror.l	#4,d0
	and.l	d0,d2				; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx

	move.w	#$81fd,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read *741 keys, B button
	or.l	d1,d0				; Mask off unused bits
	ror.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx

	move.w	#$81fb,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read 2580 keys, C button
	or.l	d1,d0				; Mask off unused bits
	rol.l	#6,d0
	rol.l	#6,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx

	move.w	#$81f7,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read 369# keys, Option button
	or.l	d1,d0				; Mask off unused bits
	rol.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxOx

	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = Inputs active high
;;;
	move.l	joy1cur,d0		; old joycur needed for determining the new joyedge
	move.l	d1,joy1cur		; Current Propad reading stored into joycur
	eor.l	d1,d0			; return values
	and.l	d1,d0			; return values
	move.l	d0,joy1edge		; Propad,buttons,keys that were just pressed
;;;
;	move.l	(sp)+,d0-d2		; stackpointer
;	move.l	d1,d0			; C return values must go here

; scan for propad 2
	move.l	#$0FFFFFF3,d1			; d1 = Propad data mask
	moveq.l	#-1,d2				; d2 = Cumulative Propad reading

	move.w	#$817f,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read Propad, pause button, A button
	or.l	d1,d0				; Mask off unused bits
	rol.b	#2,d0				; note the size of rol
	ror.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx

	move.w	#$81bf,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read *741 keys, B button
	or.l	d1,d0				; Mask off unused bits
	rol.b	#2,d0				; note the size of rol
	ror.l	#8,d0
	ror.l	#4,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx

	move.w	#$81df,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read 2580 keys, C button
	or.l	d1,d0				; Mask off unused bits
	rol.b	#2,d0				; note the size of rol
	rol.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx

	move.w	#$81ef,PROPAD			; JOYOUT
	move.l	PROPAD,d0			; JOYIN  Read 369# keys, Option button
	or.l	d1,d0				; Mask off unused bits
	rol.b	#2,d0				; note the size of rol
	rol.l	#4,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxOx 

	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = Inputs active high
;;;
	move.l	joy2cur,d0		; old joycur needed for determining the new joyedge
	move.l	d1,joy2cur		; Current Propad reading stored into joycur
	eor.l	d1,d0			; return values
	and.l	d1,d0			; return values
	move.l	d0,joy2edge		; Propad,buttons,keys that were just pressed
;;;
;	move.l	(sp)+,d0-d2		; stackpointer
;	move.l	d1,d0			; C return values must go here

	movem.l	(sp)+,d0-d7		; end stackpointer & restore registers
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Uninitialized cnc Data!!!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

joy1cur:	dc.l	0	; cnc1
joy1edge:	dc.l	0	; cnc1
joy2cur:	dc.l	0	; cnc2
joy2edge:	dc.l	0	; cnc2

		even

;-------------------------------------------------------------------------
; This copies the BIN file at location (a0) to its intended destination.
;-------------------------------------------------------------------------
copy_binfile:
	move.l	(a0)+,a1	; Get starting address (destination)
	move.l	(a0)+,d0	; Get length of code segment...
	asr	#2,d0		; Divide by 4 (do longs)
.loop:	move.l	(a0)+,(a1)+
	dbra	d0,.loop
	rts


;-------------------------------------------------------------------------
; GPU starten
;-------------------------------------------------------------------------
start_gpu:
	move.l	#G_RAM,G_PC	; Start up GPU
	move.l	#1,G_CTRL
	rts


;-------------------------------------------------------------------------
; DSP starten
;-------------------------------------------------------------------------
start_dsp:
	move.l	#D_RAM,D_PC		; Start up GPU
	move.l	#1,D_CTRL
	rts

   	move.w	#n_hp,HP		; Horizontal Period
	move.w	#n_hbb,HBB		; Horizontal Blanking Begin
	move.w	#n_hbe,HBE		; Horizontal Blanking End
	move.w	#n_hs,HS		; Horizontal Sync (off)
	move.w	#n_hvs,HVS		; Horizontal Verticle Sync (off)
	move.w	#n_heq,HEQ		; Horizontal Equilization

	move.w	#n_vp,VP		; Vertical Period
	move.w	#n_vbb,VBB		; Vertical Blanking Begin
	move.w	#n_vbe,VBE		; Vertical Blanking End
	move.w	#n_vs,VS		; Vertical Sync
	move.w	#n_veb,VEB		; Vertical Equalization Begin
	move.w	#n_vee,VEE		; Vertical Equilization End

VideoIni:

	move.w	#n_hdb1,HDB1		; Horizontal Display Begin 1
	move.w	#n_hdb2,HDB2		; Horizontal Display Begin 2
	move.w	#n_hde,HDE		; Horizontal Display End
	move.w	#n_vdb,VDB		; Vertical Display Begin
	move.w	#n_vde,VDE		; Vertical Display End

	move.w	#$0,BG			; Background Color Black (Hintergrundfarbe schwarz)
	move.l	#$0,BORD1		; Color for Linebuffer Black (Farbe fr Linebuffer schwarz)
	rts

;-------------------------------------------------------------------------
; VBL-Interrupt abwarten
;-------------------------------------------------------------------------
wait_int:
	move.b	framecnt,d0
wait_int10:
	cmp.b	intcount,d0
	bgt.b	wait_int10
	clr.b	intcount
	rts
intcount:	dc.b	0
framecnt:	dc.b	1		; 60 frames per second
	even

;-------------------------------------------------------------------------
; Interrupts initalisieren
;-------------------------------------------------------------------------
IntInit:
	move.l	LEVEL2.l,s_level2
	move.l	VI,s_vi			
	move.l	INT1,s_int1
	move.w	sr,s_sr

	move.l	#Frame,LEVEL2.l
	move.w	#n_vde+1,VI
	move.w	#1,INT1
	move.w	sr,d0
	andi.w	#$f8ff,d0
	move.w	d0,sr
	rts

;-------------------------------------------------------------------------	
; Interrupt Routine
;-------------------------------------------------------------------------	
Frame:
	movem.l	d0-d7,-(sp)		; d0-d1
	move.l	olist_ram,d0		; Adresse neue OP-Liste laden
	move.l	olist,d1		; Adresse aktive OP-Liste laden
	move.l	d1,olist_ram		; Adresse neue OP-Liste = Adresse aktive OP-Liste
	move.l	d0,olist		; Adresse aktive OP-Liste = Adresse neue OP-Liste

	move.l	d0,$f03f40		; Adresse olist fr GPU
	move.l	d1,$f03f44		; Adresse olist_ram fr GPU	

	subq.l	#4,d0			; Adresse OP-Liste auf Branch Objekt
	swap	d0			; Adresse vertauschen fr OP
	move.l	d0,OLP			; Adresse fr OP einstellen

	add.b	#1,intcount
	move.w	#$101,INT1
	move.w	#0,INT2
	movem.l	(sp)+,d0-d7		;d0-d1
	rte


;-------------------------------------------------------------------------	
; Platz fr OP Liste
;-------------------------------------------------------------------------	
	.QPHRASE	
		dc.l	0
		dc.l	0
		dc.l	0
		dc.l	0

olist1_branch:	dc.l	0			; 2 Branch Objekte
		dc.l	0
		dc.l	0
		dc.l	0

olist1:
		rept	((8*TOTAL_OBJS)+2)
		dc.l	0			; Objekt Liste fr OP
		endr

olist1_stop:	dc.l	0			; 1 Teil STOP Objekt
		dc.l	4			; 2 Teil STOP Objekt


	.QPHRASE
		dc.l	0
		dc.l	0
		dc.l	0
		dc.l	0
		
olist2_branch:	dc.l	0			; 2 Branch Objekte
		dc.l	0
		dc.l	0
		dc.l	0
		
olist2:
		rept	((8*TOTAL_OBJS)+2)
		dc.l	0			; Objekt Liste fr OP
		endr

olist2_stop:	dc.l	0			; 1 Teil STOP Objekt
		dc.l	4			; 2 Teil STOP Objekt


;-------------------------------------------------------------------------
; Object Liste
;-------------------------------------------------------------------------
	.QPHRASE				; Phrase alignment
; 1 Hintergrundbild fr Parallaxscrolling
obj_data:
x1:	dc.w	0			; o_xpos	
y1:	dc.w	0			; o_ypos (was 42 JKD)
pic1:	dc.l	whnNASA           	; o_data
	dc.w	256			; o_height
offs1:	dc.w	320/4			; o_iwidth
breit1:	dc.w	320/4			; o_dwidth
flags1:	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
type1:	dc.b	5			; o_type
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

; 2 Hintergrundbild fr Parallaxscrolling
x2:	dc.w	320			; o_xpos	
y2:	dc.w	0			; o_ypos (was 42 JKD)
pic2:	dc.l	whnNASA           	; o_data
	dc.w	256			; o_height
offs2:	dc.w	320/4			; o_iwidth
breit2:	dc.w	320/4			; o_dwidth
flags2:	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
type2:	dc.b	5			; o_type
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

obj_gegner:
; Hintergrund Grafiken
	rept	TOTAL_BACK		 
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; Hintergrund Gegnersprites (Hinter eigenem Raumschiff)
obj_enemy:
	rept	TOTAL_ENEMY		 
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; Explosionen
obj_explo:
	rept	TOTAL_EXPLO
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; Schsse
obj_shoot:
	rept	TOTAL_SHOT1
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; Geldstcke
obj_extra:
	rept	TOTAL_EXTRA
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; R-Type Sprite Player1
obj_rtype:
x:	dc.w	-60			; X-Pos
y:	dc.w	SCRN_TOP+226		; Y-Pos
player:	dc.l	NBLR3JKD		; Spritedaten
	dc.w	16			; Hhe
	dc.w	32/4			; Breite
	dc.w	32/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
p1_typ:	dc.b	5			; Object Typ 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadresse Skalierangaben
	dc.l	0			; Startadresse Schudaten
	dc.l	0			; Counter Schudaten
p1_ani1: dc.l	r_type_anim		; Adresse akt. Spriteliste
p1_ani2: dc.l	r_type_anim		; Startadresse Spriteliste
p1_kurv: dc.l	r_type_kurve2		; Start Kurvenliste
	dc.l	0			; Sample
power1:	dc.w	7			; Energy R-Type
	dc.w	0			; Punkte
	dc.l	rtype_explo		; Startadresse Daten Folgesprites
	dc.w	8			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	8			; Geschwindigkeit fr Neustart
	dc.l	32			; Breite Sprite in Pixeln

; Unverwundbarkeit R-Type Sprite Player1
obj_rtype1:
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln


; oberer Vordergrund linkes Bild fr Parallaxscrolling
x5:	dc.w	0			; o_xpos	
y5:	dc.w	42-MAX_Y		; o_ypos
pic5:	dc.l	grafic_end           	; o_data
high5:	dc.w	0			; o_height
offs5:	dc.w	320/4			; o_dwidth
breit5:	dc.w	320/4			; o_iwidth
flags5:	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type5:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

; oberer Vordergrund rechtes Bild fr Parallaxscrolling
x6:	dc.w	320			; o_xpos	
y6:	dc.w	42-MAX_Y		; o_ypos
pic6:	dc.l	grafic_end+(320*88*2)  	; o_data
high6:	dc.w	0			; o_height
offs6:	dc.w	320/4			; o_dwidth
breit6:	dc.w	320/4			; o_iwidth
flags6:	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type6:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

; unterer Vordergrund linkes Bild fr Parallaxscrolling
x3:	dc.w	0			; o_xpos	
y3:	dc.w	42+MAX_Y+(226*2)-(88*2)	; o_ypos
pic3:	dc.l	0	           	; o_data
high3:	dc.w	0			; o_height
offs3:	dc.w	320/4			; o_dwidth
breit3:	dc.w	320/4			; o_iwidth
flags3:	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type3:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

; unterer Vordergrund rechtes Bild fr Parallaxscrolling
x4:	dc.w	320			; o_xpos	
y4:	dc.w	42+MAX_Y+(226*2)-(40*2)	; o_ypos
pic4:	dc.l	0	           	; o_data
high4:	dc.w	0			; o_height
offs4:	dc.w	320/4			; o_dwidth
breit4:	dc.w	320/4			; o_iwidth
flags4:	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type4:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	320			; Breite Sprite in Pixeln

; Vordergrund Gegnersprites (Vor eigenem Raumschiff)
obj_enemy1:
	rept	TOTAL_ENEMY1		; Platz fr Anzahl Objekte - 6 feste
	dc.w	0			; o_xpos	
	dc.w	0			; o_ypos
	dc.l	0	           	; o_data
	dc.w	0			; o_height
	dc.w	0			; o_iwidth
	dc.w	0			; o_dwidth
	dc.b	0			; o_flags
	dc.b	0			; o_firstpix
	dc.b	5			; o_type
	dc.b	0			; o_depth
	dc.b	0			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	0			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	0			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	0			; Geschwindigkeit fr Neustart
	dc.l	0			; Breite Sprite in Pixeln
	endr

; Obere Anzeige
	dc.w	8			; o_xpos	
	dc.w	42+26			; o_ypos
	dc.l	anzeige		      	; o_data
	dc.w	38			; o_height
	dc.w	192/4			; o_dwidth
	dc.w	192/4			; o_iwidth
	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type7:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	192			; Breite Sprite in Pixeln

; Untere Anzeige
	dc.w	8			; o_xpos	
	dc.w	42+(194*2)		; o_ypos
	dc.l	anzeige1	      	; o_data
	dc.w	20			; o_height
	dc.w	128/4			; o_dwidth
	dc.w	128/4			; o_iwidth
	dc.b	4			; o_flags
	dc.b	0			; o_firstpix
type8:	dc.b	5			; o_type (Object, das keine Animlisten usw. hat z.B. R-Type Sprite)
	dc.b	4			; o_depth
	dc.b	1			; o_pitch
	dc.b	0			; o_index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	0			; Endadr. Skalierangaben
	dc.l	0			; Adr. akt. Spriteliste
	dc.l	0			; Startadresse Spriteliste
	dc.l	0			; Endadresse Spriteliste
	dc.l	0			; Start Flugbahn
	dc.l	0			; Ende Flugbahn
	dc.w	DESTROY			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Punkte
	dc.l	0			; Startadresse Daten Folgesprites
	dc.w	2			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	2			; Geschwindigkeit fr Neustart
	dc.l	128			; Breite Sprite in Pixeln



	.QPHRASE
; Daten fr Hintergrund Parallaxscrolling
level_daten1:
	rept	54			;(was 9 JKD)
	dc.l	whnNASA
	endr
;	rept	24			;(was 60 JKD)
;	dc.l	whnNASA			;(was back1 JKD)
;	endr


	.QPHRASE
; Daten fr unteren Vordergrund Parallaxscrolling
; Adresse des Bildes		(L)
; Hhe des Bildes		(W)
; Objekt Typ			(W)
level_daten2:
	dc.l	0			; Adresse Grafik
	dc.w	88			; Hhe Grafik
	dc.w	5			; Objekt Typ (5 = nicht aktiv, 6 = keine Animlisten)

	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	11
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5			

	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5
	
	
	dc.l	0
	dc.w	11
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5			

	dc.l	0
	dc.w	11
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	11
	dc.w	5
	
	dc.l	0
	dc.w	11
	dc.w	5

; L1_2	
	dc.l	0
	dc.w	88
	dc.w	5			
	
	dc.l	0
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5
	
	
	dc.l	0
	dc.w	24
	dc.w	5

; L1_3	
	dc.l	0		; Anfang		
	dc.w	40
	dc.w	5
	
		
	dc.l	0		
	dc.w	24
	dc.w	5
	
	
	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0		
	dc.w	40
	dc.w	5	
	
	dc.l	0		
	dc.w	24
	dc.w	5
	
	dc.l	0		
	dc.w	40
	dc.w	5
	
	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0		; Letztes Teil
	dc.w	24
	dc.w	5

; L1_4
	dc.l	0
	dc.w	56
	dc.w	5			

	dc.l	0
	dc.w	64
	dc.w	5
		
	dc.l	0
	dc.w	64
	dc.w	5
	
	dc.l	0
	dc.w	64
	dc.w	5

	dc.l	0	
	dc.w	56
	dc.w	5


	dc.l	0		
	dc.w	24
	dc.w	5
	
	
	dc.l	0		; Letztes Teil	
	dc.w	24
	dc.w	5

; L1_5	
	dc.l	0
	dc.w	40
	dc.w	5			
		
	dc.l	0
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

; L1_5	again
	dc.l	0
	dc.w	40
	dc.w	5			
		
	dc.l	0
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

; L1_5	MORE
	dc.l	0
	dc.w	40
	dc.w	5			
		
	dc.l	0
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

; L1_5	even MORE again
	dc.l	0
	dc.w	40
	dc.w	5			
		
	dc.l	0
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5


	.QPHRASE
; Daten fr oberen Vordergrund Parallaxscrolling
; Adresse des Bildes		(L)
; Hhe des Bildes		(W)
; Objekt Typ			(W)
level_daten3:
	dc.l	0			; Adresse Grafik
	dc.w	88			; Hhe Grafik
	dc.w	5			; Objekt Typ (5 = nicht aktiv, 6 = keine Animlisten)

	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	11
	dc.w	5
		
	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	11
	dc.w	5
		
	dc.l	0
	dc.w	42
	dc.w	5
	
	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	50
	dc.w	5

	dc.l	0
	dc.w	42
	dc.w	5

	dc.l	0
	dc.w	11
	dc.w	5
	
	dc.l	0
	dc.w	11
	dc.w	5

; L1_2	
	dc.l	0
	dc.w	88
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

; L1_3 Daten
	dc.l	0		; Anfang	
	dc.w	40
	dc.w	5
	
	
	dc.l	0		
	dc.w	70
	dc.w	5
	
	
	dc.l	0		
	dc.w	70
	dc.w	5
	
	
	dc.l	0			
	dc.w	40
	dc.w	5
	
	
	dc.l	0			
	dc.w	40
	dc.w	5
		
	
	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0		
	dc.w	24
	dc.w	5
		
	dc.l	0		; Letztes Teil	
	dc.w	24
	dc.w	5

; L1_4
	dc.l	0
	dc.w	56
	dc.w	5		

	dc.l	0
	dc.w	64
	dc.w	5
		
	dc.l	0
	dc.w	64
	dc.w	5
	
	dc.l	0
	dc.w	64
	dc.w	5

	dc.l	0		
	dc.w	56
	dc.w	5

	dc.l	0	
	dc.w	24
	dc.w	5
	
	dc.l	0		; Letztes Teil	
	dc.w	24
	dc.w	5
	
; L1_5	
	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0	
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5
; L1_5	
	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0	
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5

; L1_5	MORE
	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0	
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5

; L1_5	even MORE again
	dc.l	0
	dc.w	40
	dc.w	5

	dc.l	0
	dc.w	40
	dc.w	5
		
	dc.l	0
	dc.w	24
	dc.w	5
	
	dc.l	0
	dc.w	24
	dc.w	5

	dc.l	0	
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5
	
	dc.l	0
	dc.w	40
	dc.w	5

	.QPHRASE
; Daten fr Samples
sample_daten:
;	dc.l	sample1_start		; Sample = 0
;	dc.l	0			;sample1_end


;---------------------------------------------------------------------
; Definitionen fr R-Type
;---------------------------------------------------------------------
	.QPHRASE
r_type_anim:
	dc.l	NBLR3JKD+(32*16*2*9)
	dc.l	0		; Ende Animationsliste


	.QPHRASE
r_type_kurve:
	rept	180
	dc.w	0,0
	endr
	dc.w	KURVE_ENDE	; Ende Kurvenliste


	.QPHRASE
r_type_kurve2:
	rept	240
	dc.w	0,0
	endr
	dc.w	KURVE_ENDE	; Ende Kurvenliste
	

	.QPHRASE
r_type_anim1:
.i	set	9
	rept	9
	dc.l	NBLR3JKD+(32*16*2*.i)
.i	set	.i-1	
	endr
	rept	9
	dc.l	NBLR3JKD+(32*16*2*.i)
.i	set	.i+1
	endr	
	dc.l	0		; Ende Animationsliste

	.QPHRASE
r_type_kurve1:
; Achtung !!! nderungen an der Kurvenlnge sind im GPU Programm
; bei Kollision Hintergrund anzupassen.
; Obere Vordergrundgrafiken
; R-Type nach rechts unten ablenken
	rept	4
	dc.w	4,4
	dc.w	3,3
	dc.w	2,2
	dc.w	2,2
	dc.w	1,1
	dc.w	2,2
	dc.w	1,1
	dc.w	2,2
	dc.w	1,1
	dc.w	1,1
	dc.w	1,1
	dc.w	1,1
	dc.w	1,1
	dc.w	1,1
	dc.w	0,0
	dc.w	KURVE_ENDE,0	; Ende Kurvenliste
; R-Type nach links unten ablenken
	dc.w	-4,4
	dc.w	-3,3
	dc.w	-2,2
	dc.w	-2,2
	dc.w	-1,1
	dc.w	-2,2
	dc.w	-1,1
	dc.w	-2,2
	dc.w	-1,1
	dc.w	-1,1
	dc.w	-1,1
	dc.w	-1,1
	dc.w	-1,1
	dc.w	-1,1
	dc.w	-0,0
	dc.w	KURVE_ENDE,0	; Ende Kurvenliste
	endr

; Untere Vordergrundgrafik
; R-Type nach rechts oben ablenken
	rept	4
	dc.w	4,-4
	dc.w	3,-3
	dc.w	2,-2
	dc.w	2,-2
	dc.w	1,-1
	dc.w	2,-2
	dc.w	1,-1
	dc.w	2,-2
	dc.w	1,-1
	dc.w	1,-1
	dc.w	1,-1
	dc.w	1,-1
	dc.w	1,-1
	dc.w	1,-1
	dc.w	0, 0
	dc.w	KURVE_ENDE,0	; Ende Kurvenliste
; R-Type nach links oben ablenken
	dc.w	-4,-4
	dc.w	-3,-3
	dc.w	-2,-2
	dc.w	-2,-2
	dc.w	-1,-1
	dc.w	-2,-2
	dc.w	-1,-1
	dc.w	-2,-2
	dc.w	-1,-1
	dc.w	-1,-1
	dc.w	-1,-1
	dc.w	-1,-1
	dc.w	-1,-1
	dc.w	-1,-1
	dc.w	 0, 0
	dc.w	KURVE_ENDE,0	; Ende Kurvenliste
	endr

;---------------------------------------------------------------------
; Variablen fr Gegner
;---------------------------------------------------------------------
	.QPHRASE
	INCLUDE	"../DURANIK/NATIVE/REV002/SHOOTING.S"

	.QPHRASE
	INCLUDE	"../DURANIK/NATIVE/REV002/PYROTECH.S"

	.QPHRASE
gegner_daten:
	INCLUDE "../DURANIK/NATIVE/REV002/NSS1.S"
	INCLUDE	"../DURANIK/NATIVE/REV002/ACME.S"

	.QPHRASE
ende_daten:
	INCLUDE	"../DURANIK/NATIVE/REV002/GAMEOVER.S"

;---------------------------------------------------------------------
; Beamschsse festlegen
;---------------------------------------------------------------------
	.QPHRASE
beam_daten:
	dc.l	schuss_daten1	; Adresse normaler Schu
	dc.l	beam_daten1	; Adresse 1 Beamschu
	dc.l	beam_daten2	; Adresse 2 Beamschu
	dc.l	beam_daten3	; Adresse 3 Beamschu
	dc.l	beam_daten4	; Adresse 4 Beamschu
	dc.l	beam_daten5	; Adresse 5 Beamschu
	dc.l	beam_daten6	; Adresse 6 Beamschu


;---------------------------------------------------------------------
; Variablen festlegen
;---------------------------------------------------------------------
	.QPHRASE
olist:		dc.l	0	; Adresse aktive OP-Liste
olist_ram:	dc.l	0	; Adresse zu erstellende OP-Liste
level_daten:	dc.l	0
scr_unten:	dc.l	0	; fr unteres Vordergrundscrolling
scr_oben:	dc.l	0	; fr oberes Vordergrundscrolling
score1:		dc.l	0	; Score Player 1
score2:		dc.l	0	; Highscore im Spiel
shoot_count:	dc.l	0	; Counter wie oft Schuroutine aufgerufen wird
shoot_data1:	dc.l	0	; Schudaten Player 1
gegner:		dc.l	0	; Adresse wo Gegnerdaten beginnen
y_pos:		dc.l	0	; Y-Pos im Spiel
s_sp:		dc.l	0	; Adresse alter Stackpointer
s_level2:	dc.l	0
s_vi:		dc.l	0
s_int1:		dc.l	0

	.QPHRASE
PausAddr:		dc.w	0	; cnc pause, 0 = nicht aktiv, 1 = aktiv
s_sr:		dc.w	0
grow:		dc.w	0
x_pos:		dc.w	0	; X-Pos im gesamten Spiel (wird zum festlegen der Gegner benutzt).
lev_speed:	dc.w	0	; Geschwindigkeit Hintergrund Parallaxscrolling
life_player1:	dc.w	0	; Anzahl Leben Player 1
rtype_anim1:	dc.w	0	; Welcher R-Type Sprite
bewegung1:	dc.w	0	; Bewegung Player 1 ( 0 = keine, 1 = oben, -1 = unten )
beam_player1:	dc.w	0	; Strke Schu Player 1
money_player1:	dc.w	0	; Geld Player 1


;-------------------------------------------------------------------------
; Daten und Grafiken
;-------------------------------------------------------------------------
	.QPHRASE
bright:
.cr	set	$0
.lum	set	$0
	rept	6
	dc.b	.cr,.lum,.cr,.lum,.cr,.lum,.cr,.lum
.cr	set	.cr+$10
	endr
	rept	60
	dc.b	.cr,.lum,.cr,.lum,.cr,.lum,.cr,.lum
.lum	set	.lum+1			
	endr	
	.QPHRASE
gpu_prog:	incbin		"../DURANIK/GPU/GPU_PROG.BIN"
	.QPHRASE
dsp_prog:	incbin		"../DURANIK/DSP/DSP_PROG.BIN"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;	NSS1 Ice Packed
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.QPHRASE
s_cra_ice:	incbin		"../duranik/native/REV002/s_cra.ice"
	.QPHRASE
renNASA_ice:	incbin		"../duranik/native/REV002/renNASA.ice"
	.QPHRASE
lens1_ice:	incbin		"../duranik/native/REV002/lens1.ice"
	.QPHRASE
lens2_ice:	incbin		"../duranik/native/REV002/lens2.ice"
	.QPHRASE
leiter_f_ice:	incbin		"../duranik/native/REV002/leiter_f.ice"
	.QPHRASE
leiterbs_ice:	incbin		"../duranik/native/REV002/leiterbs.ice"
	.QPHRASE
rocket_b_ice:	incbin		"../duranik/native/REV002/rocket_b.ice"
	.QPHRASE
schutz_ice:	incbin		"../duranik/native/REV002/schutz.ice"
	.QPHRASE
b_mike_ice:	incbin		"../duranik/native/REV002/b_mike.ice"
	.QPHRASE
leiterq1_ice:	incbin		"../duranik/native/REV002/leiterq1.ice"
	.QPHRASE
RylosJKD_ice:	incbin		"../duranik/native/REV002/RYLOSJKD.ice"
	.QPHRASE
whnNASA_ice:	incbin		"../duranik/native/REV002/whnNASA.ice"
	.QPHRASE
meteor_1_ice:	incbin		"../duranik/native/REV002/meteor_1.ice"

;	.QPHRASE
;baut1_n_ice:	incbin		"../duranik/native/builder/ice/baut1_n.ice"
;	.QPHRASE
;baut2_n_ice:	incbin		"../duranik/native/builder/ice/baut2_n.ice"
;	.QPHRASE
;baut3_n_ice:	incbin		"../duranik/native/builder/ice/baut3_n.ice"


;	.QPHRASE
;back0_ice:	incbin		"../duranik/native/builder/ice/back0.ice"
;	.QPHRASE
;back1_ice:	incbin		"../duranik/native/builder/ice/back1.ice"
;	.QPHRASE
;teil0_ice:	incbin		"../duranik/native/builder/ice/teil0.ice"
;	.QPHRASE	
;teil1_ice:	incbin		"../duranik/native/builder/ice/teil1.ice"
;	.QPHRASE	
;teil6_ice:	incbin		"../duranik/native/builder/ice/teil6.ice"
;	.QPHRASE		
;zahn_gross_ice:	incbin		"../duranik/native/sprites/ice/zahn_1.ice"
;	.QPHRASE
;zahn_klein_ice:	incbin		"../duranik/native/sprites/ice/zahn_2.ice"
;	.QPHRASE
;nebel_ice:	incbin		"../duranik/native/builder/ice/nebel.ice"
;	.QPHRASE
;gesch1_ice:	incbin		"../duranik/native/sprites/ice/gesch1.ice"
;	.QPHRASE
;gesch1k_ice:	incbin		"../duranik/native/sprites/ice/gesch1k.ice"
	.QPHRASE	
crawler_ice:	incbin		"../duranik/native/REV002/crawler.ice"
;	.QPHRASE
;ape2_ice:	incbin		"../duranik/native/sprites/ice/ape2.ice"
	.QPHRASE
q_bomb_ice:	incbin		"../duranik/native/REV002/q_bomb.ice"	

; *** Daten Level 3 ***************************************************
;	.QPHRASE
;teil5_ice:	incbin		"../duranik/native/builder/ice/teil5.ice"
;	.QPHRASE	
;eye_ice:	incbin		"../duranik/native/sprites/ice/eye.ice"
;	.QPHRASE
;gasglas_ice:	incbin		"../duranik/native/sprites/ice/gasglas.ice"
;	.QPHRASE
;haltglas_ice:	incbin		"../duranik/native/sprites/ice/haltglas.ice"
;	.QPHRASE
;hugger_ice:	incbin		"../duranik/native/sprites/ice/hugger.ice"
;	.QPHRASE
;glas_ice:	incbin		"../duranik/native/sprites/ice/glas1.ice"
;	.QPHRASE
;wurm_ice:	incbin		"../duranik/native/sprites/ice/wurm.ice"
;	.QPHRASE			
;ape_ice:	incbin		"../duranik/native/sprites/ice/ape.ice"
;	.QPHRASE
;wurm2_ice:	incbin		"../duranik/native/sprites/ice/wurm2.ice"
	.QPHRASE
rotg_ice:	incbin		"../duranik/native/REV002/rotg.ice"
	.QPHRASE		
ball_ice:	incbin		"../duranik/native/REV002/ball.ice"
	.QPHRASE
spike_ice:	incbin		"../duranik/native/REV002/spike.ice"
	
; *** Daten Level 4 ***************************************************
;	.QPHRASE
;teil3_ice:	incbin		"../duranik/native/builder/ice/teil3.ice"
;	.QPHRASE
;teil3b_ice:	incbin		"../duranik/native/builder/ice/teil3b.ice"
;	.QPHRASE
;teil4_ice:	incbin		"../duranik/native/builder/ice/teil4.ice"	
;	.QPHRASE
;kolben_o_ice:	incbin 		"../duranik/native/sprites/ice/kolben_o.ice"
;	.QPHRASE
;kolben_u_ice:	incbin		"../duranik/native/sprites/ice/kolben_u.ice"
;	.QPHRASE	
;pleuel_2_ice:	incbin		"../duranik/native/sprites/ice/pleuel_2.ice"
;	.QPHRASE
;m_end_li_ice:	incbin		"../duranik/native/sprites/ice/m_end_li.ice"
;	.QPHRASE
;m_end_re_ice:	incbin		"../duranik/native/sprites/ice/m_end_re.ice"
;	.QPHRASE
;presse_o_ice:	incbin		"../duranik/native/sprites/ice/presse_o.ice"
;	.QPHRASE
;presse_u_ice:	incbin		"../duranik/native/sprites/ice/presse_u.ice"	

	.QPHRASE	
point_ice:	incbin		"../duranik/native/REV002/point.ice"
	
;	.QPHRASE
;schlauch_ice:	incbin		"../duranik/native/sprites/ice/schlauch.ice"

; *** Daten Level 5 ***************************************************
;	.QPHRASE
;oran_u_ice:	incbin		"../duranik/native/sprites/ice/oran_u.ice"
;	.QPHRASE
;oran_u_k_ice:	incbin		"../duranik/native/sprites/ice/oran_u_k.ice"
;	.QPHRASE	
;oran_o_ice:	incbin		"../duranik/native/sprites/ice/oran_o.ice"
;	.QPHRASE
;oran_o_k_ice:	incbin		"../duranik/native/sprites/ice/oran_o_k.ice"
;	.QPHRASE		
;runner_ice:	incbin		"../duranik/native/sprites/ice/runner.ice"
;	.QPHRASE
;runner_j_ice:	incbin		"../duranik/native/sprites/ice/runner_j.ice"
	.QPHRASE		
resort_ice:	incbin		"../duranik/native/REV002/resort.ice"

; *** Include Part 6 ************* NOT SHOWN IN ORIGINAL DEMO *** JKD ***
;	.QPHRASE
;walker_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/Walker.ice"
;	.QPHRASE
;turb_au_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/Turb_au.ice"
;	.QPHRASE
;turbine_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/Turbine.ice"
;	.QPHRASE
;zahn_k_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/zahn_k.ice"
;	.QPHRASE
;blase_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/blase.ice"
;	.QPHRASE
;blase_k1_daten	:	incbin		"../DURANIK/NATIVE/DATEN/blase_k1.dat"
;	.QPHRASE
;blase_k2_daten	:	incbin		"../DURANIK/NATIVE/DATEN/blase_k2.dat"
;	.QPHRASE
;schleim1_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/Schleim1.cry"
;	.QPHRASE
;schleim2_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/Schleim2.cry"
;	.QPHRASE
;schleim3_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/Schleim3.cry"
;	.QPHRASE
;Welle_ice	:	incbin		"../DURANIK/NATIVE/SPRITES/ICE/Welle.ice"

; *** Daten die immer bentigt werden *********************************
	.QPHRASE
native1:	incbin		"../duranik/native/REV002/Native1.ICE"

; *** Daten und Programme fr titlebild *******************************
	.QPHRASE			
djag_gpu:	incbin		"../duranik/jagpeg/dejag16.bin"
	.QPHRASE
dq75_abs:	incbin		"../duranik/jagpeg/dq75.dat"
	.QPHRASE
dhuf_abs:	incbin		"../duranik/jagpeg/dehuff.dat"
	.QPHRASE
title:		incbin		"../duranik/native/REV002/TITLEJKD.jag"

; *** Grafiken fr Greetings ******************************************
	.QPHRASE
schrift_ice:	incbin		"../duranik/native/title/ice/schrift.ice"	
	.QPHRASE
title1_daten:	INCLUDE		"../DURANIK/DESIGN/title1.S"

;;;================================
;;; REV002
;;;================================
	.QPHRASE
scrbdjkd_ice:	incbin		"../duranik/native/REV002/scrbdjkd.ice"
	.QPHRASE
btnjkd_ice:	incbin		"../duranik/native/REV002/btnjkd.ice"
	.QPHRASE
pausejkd_ice:	incbin		"../duranik/native/REV002/pausejkd.ice"
	.QPHRASE
mercjkd_ice:	incbin		"../duranik/native/REV002/mercjkd.ice"
	.QPHRASE
venusjkd_ice:	incbin		"../duranik/native/REV002/venusjkd.ice"
	.QPHRASE
earthjkd_ice:	incbin		"../duranik/native/REV002/earthjkd.ice"
	.QPHRASE
marsjkd_ice:	incbin		"../duranik/native/REV002/marsjkd.ice"
	.QPHRASE
vestajkd_ice:	incbin		"../duranik/native/REV002/vestajkd.ice"
	.QPHRASE
ceresjkd_ice:	incbin		"../duranik/native/REV002/ceresjkd.ice"
	.QPHRASE
pallajkd_ice:	incbin		"../duranik/native/REV002/pallajkd.ice"
	.QPHRASE
hygiejkd_ice:	incbin		"../duranik/native/REV002/hygiejkd.ice"
	.QPHRASE
davidjkd_ice:	incbin		"../duranik/native/REV002/davidjkd.ice"
	.QPHRASE
interjkd_ice:	incbin		"../duranik/native/REV002/interjkd.ice"
	.QPHRASE
junojkd_ice:	incbin		"../duranik/native/REV002/junojkd.ice"

c_end:				; Jaguar Programm Ende
	end
