;;======================================================================================*
;;											*
;;              Project		:	NATIVE SPIRIT					*
;;		FILENAME	:	NSS1.s						*
;;              Function	:	Sector 1 Layout					*
;;              Programmer	:	Johannes Graf					*
;;											*
;;		         COPYRIGHT 1996,1997 Duranik Software				*
;;		UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,			*
;;		PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR			*
;;		THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.			*
;;               	            ALL RIGHTS RESERVED.				*
;;											*
;;		REV.	DATE		AUTHOR		REVISION HISTORY		*
;;		~~~~~	~~~~~~~~~~~~	~~~~~~~~~~~~	~~~~~~~~~~~~~~~~~~~~~		*
;;		000	06-07-97	DURANIK		L1_1D.s 1st Release		*
;;		000	10-03-97	DURANIK		L1_2D.s Part 2 (3D,4D,5D...)	*
;;		002	12-28-07	Zentanyx	NSS1.s 2nd Revision		*
;;											*
;;	Modification and Anomaly Report							*
;;	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~						*
;;	* Dwarf/Minor Planets placeholders in Asteroid Belt				*
;;	* reintroduced "resort" at end of cp3 & cp5					*
;;	* explo3_daten no longer used (check others)					*
;;	* DRAW BEAM : ROTG@SATURN Draw Beam on Ranger 1 while R2 non-responsive...	*
;;			Ranger 2 paused moves and draw beam works when R1 does not	*
;;	* initial bkgd offscreen check screen width					*
;;	* Recalculated "EXTRA" for player scores (See checkpoint breakdown)		*
;;	* New pos/pacing for Old Enemies with extended playfield 33333\5(about 9 min.)	*
;;	* "meteor" explosions added in Asteroid Field (now use explo1_daten)		*
;;	* "hugger," "eye," (REMOVED) "resort" and *TEILBAR* pop-up in background?	*
;;	* PYROTECH.S replaced gegner1.s (Inactive bonuses REMOVED - changed explosions)	*
;;											*
;;		   NATIVE SPIRIT Adaptation Produced by Jason Keith Data		*
;;	   This revision has been released under an Educational Community License	*
;;				Copyright  2007 Zentanyx				*
;;											*
;;======================================================================================*

m2_speed	set     2			; meteor_1 movement rate in Asteroid Field
m3_speed	set     3
m4_speed	set     4
m5_speed	set     5

layer1		set	0			; Background object
layer2		set	(obj_enemy-obj_gegner)	; Object behind ship in collision/gunner path
layer3		set	(obj_enemy1-obj_gegner)	; Object in front of player's ship

; ...Checkpoint Breakdown...			; Checkpoint I: Tyr's Declaration
						;;; opnt = s_cra(10), rocket_b(15), b_mike(20), meteor_1(50)
						;;; bkgd = treffer, leiter_f, leiterq1, leiterbs, RylosJKD (Mars)

.cp2		set	6666			; Checkpoint II: Odin's Slippery Ring
						;;; opnt = *meteor_1, crawler(100), q_bomb(150), *s_cra, *rocket_b
						;;; bkgd = *treffer, *RylosJKD (Jupiter)

.cp3		set	13333			; Checkpoint III: Midgard
						;;; opnt = ball(150), *q_bomb, spike(175), resort(???)
						;;; bkgd = n/a

.cp4		set	19999			; Checkpoint IV: Frigga's Fortune Cookie
						;;; opnt = * spike, point(200), *crawler
						;;; bkgd = *RylosJKD (Saturn)

.cp5		set	26666			; Checkpoint V: Saturation Point
						;;; opnt = schutz(250), ROTG (250), *resort
						;;; bkgd = Rotten Egg Nebula

;;;=============================================================================
;;;
;;;	Checkpoint I: Tyr's Declaration	
;;;	.cp1 = 0000
;;;
;;;=============================================================================
;;; s_cra "V Formation" Wave 1		


; Welle oben
	dc.l	180			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	65*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	200			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	10			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

		
	dc.l	220			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	230			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	105*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	240			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;======================================
;;; s_cra "V Formation" Wave 2
;;;======================================

	dc.l	540			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	560			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	15			; Start adress of shooting list
	dc.l	gegner_shoot3		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	560			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	30			; Start adress of shooting list
	dc.l	gegner_shoot5		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	dc.l	580			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	580			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=====================================
;;; rockets away
;;;=====================================

; rocket_b entpacken
	dc.l	920			; X-Pos where CLUT will be activated
	dc.l	rocket_b		; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	rocket_b_ice		; CLUT address for packed data


	dc.l	925			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels

; Planet MERCURY unpacked
	dc.l	931			; X-pos where data is unpacked (2400*0.388)
	dc.l	mercjkd			; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	mercjkd_ice		; Start address packed data

; Planet MERCURY
	dc.l	931			; X-Pos (AU*0.388) where MERCURY appears
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	mercjkd			; Start address of Sprite data
	dc.w	37			; Height 
	dc.w	36/4			; Width 
	dc.w	36/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	mercjkd_anim		; Address active acme list
	dc.l	mercjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	2			; Speed of 30 pictures per second
	dc.w	2			; Speed for restart
	dc.l	36			; Width in pixels


	dc.l	935			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	940			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	945			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	950			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

;;;=====================================
;;; s_cra "V Formation" Wave 3
;;;=====================================

	dc.l	1010			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	15			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	1050			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	1050			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
;;;
;;; Rockets Away
;;;
	dc.l	1050			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	1060			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1065			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1070			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	1075			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1075			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	1075			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	210*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	
		
	dc.l	1085			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1085			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1090			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1090			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels
;;;=====================================
;;; Another "V Formation"
;;;=====================================
	dc.l	1090			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	1090			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	1095			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1095			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	1100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1325			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	1335			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1340			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1345			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	1350			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1475			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels

	
	dc.l	1475			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	190*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	
	
	dc.l	1480			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1480			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1485			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1485			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1490			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1490			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1495			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1495			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	1500			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	1500			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


; Planet VENUS unpacked
	dc.l	1733			; X-pos where data is unpacked (2400*0.722)
	dc.l	venusjkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	venusjkd_ice		; Start address packed data

; Planet VENUS
	dc.l	1733			; X-Pos (AU*0.722) where VENUS appears
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	venusjkd		; Start address of Sprite data
	dc.w	68			; Height 
	dc.w	68/4			; Width 
	dc.w	68/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	venusjkd_anim		; Address active acme list
	dc.l	venusjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	2			; Speed of 30 pictures per second
	dc.w	2			; Speed for restart
	dc.l	68			; Width in pixels
;;;
;;; b_mike unpacked
;;;
	dc.l	1840			; X-Pos where CLUT will be activated
	dc.l	b_mike			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	b_mike_ice		; CLUT address for packed data


; B_Mike Welle 1
	dc.l	1850			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	10			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	1865			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	1880			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	1895			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	1910			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	1925			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	1940			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;=====================================
;;; "V Formation" Party
;;;=====================================

	dc.l	2130			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2150			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2150			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2190			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2190			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=====================================
;;; B_Mike Double Trouble
;;;=====================================

	dc.l	2250			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2265			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2280			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	2295			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2310			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2325			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;=====================================

	dc.l	2325			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2340			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2355			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	2370			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2385			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Planet EARTH unpacked
	dc.l	2400			; X-pos where EARTH is unpacked
	dc.l	earthjkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	earthjkd_ice		; Start address packed data

; Planet EARTH
	dc.l	2400			; X-Pos where EARTH appears
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	earthjkd		; Start address of Sprite data
	dc.w	100			; Height 
	dc.w	100/4			; Width 
	dc.w	100/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	earthjkd_anim		; Address active acme list
	dc.l	earthjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	2			; Speed of 30 pictures per second
	dc.w	2			; Speed for restart
	dc.l	100			; Width in pixels


	dc.l	2400			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;=====================================
;;; "V Formation" rocketeer RENEGADES
;;;=====================================
	dc.l	2450			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	rocket_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2450			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	rocket_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2500			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	rocket_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	2500			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	110*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	rocket_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=====================================
;;; Foreground Antenna Linkin' Logs
;;;=====================================

; Leiter senkrecht schmal 2 unpacked
	dc.l	2500			; X-pos where data is unpacked (2400*0.388)
	dc.l	leiterbs		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	leiterbs_ice		; Start address packed data


; Leiterq1 entpacken
	dc.l	2510			; X-Pos where CLUT will be activated
	dc.l	leiterq1		; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	leiterq1_ice		; CLUT address for packed data


; Leiter senkrecht schmal 2
	dc.l	2520			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiterbs		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterbs_anim		; Address of actual object list
	dc.l	leiterbs_anim		; Start address of object list
	dc.l	leiterbs_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Leiter waagrecht 1
	dc.l	2529			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	52*2+42			; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


; Leiter waagrecht 2
	dc.l	2529			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=====================================
;;; trailing B_Mike
;;;=====================================

	dc.l	2550			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2565			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	110*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2580			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	2595			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2610			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


; Leiter senkrecht schmal 3
	dc.l	2615			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiterbs		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterbs_anim		; Address of actual object list
	dc.l	leiterbs_anim		; Start address of object list
	dc.l	leiterbs_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Leiter waagrecht hinten1
	dc.l	2624			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	52*2+42			; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


; Leiter waagrecht hinten2
	dc.l	2624			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

; Leiter gro entpacken
	dc.l	2650			; X-Pos where CLUT will be activated
	dc.l	leiter_f		; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	leiter_f_ice		; CLUT address for packed data

; Leiter gro 3
	dc.l	2690			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiter_f		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	132/4			; Image Width
	dc.w	132/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiter_f_anim		; Address of actual object list
	dc.l	leiter_f_anim		; Start address of object list
	dc.l	leiter_f_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	132			; Image Width in Pixels


; Leiter senkrecht schmal 4
	dc.l	2702			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiterbs		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterbs_anim		; Address of actual object list
	dc.l	leiterbs_anim		; Start address of object list
	dc.l	leiterbs_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

;;;=====================================
;;; B_Mike Tail 2
;;;=====================================

	dc.l	2850			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2865			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2880			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	2895			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2910			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	2925			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	20			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	3550			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiter_f		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	132/4			; Image Width
	dc.w	132/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiter_f_anim		; Address of actual object list
	dc.l	leiter_f_anim		; Start address of object list
	dc.l	leiter_f_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	132			; Image Width in Pixels


; Leiter senkrecht schmal 2
	dc.l	3600			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiterbs		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterbs_anim		; Address of actual object list
	dc.l	leiterbs_anim		; Start address of object list
	dc.l	leiterbs_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

; Leiter waagrecht 1
	dc.l	3609			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	52*2+42			; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


; Leiter waagrecht 2
	dc.l	3609			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	leiterq1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	200/4			; Image Width
	dc.w	200/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterq1_anim		; Address of actual object list
	dc.l	leiterq1_anim		; Start address of object list
	dc.l	leiterq1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

; Planet MARS unpacked
	dc.l	3658			; X-pos where ROUNDED data is unpacked (2400*1.524)
	dc.l	marsjkd			; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	marsjkd_ice		; Start address packed data

; Planet MARS
	dc.l	3658			; X-Pos (AU*01.524) where MARS appears
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	marsjkd			; Start address of Sprite data
	dc.w	48			; Height 
	dc.w	48/4			; Width 
	dc.w	48/4			; Offset 
	dc.b	4			; Transition Flags
; standard (normal display)= 0 
; HFLIP (Horizontal FLIP)= 1 
; RMW (Read Modify Write "transparency")= 2 
; TRANS (don't display color 0 "transition")= 4 
; RELEASE = 8Transition Flags 4 = transparent black
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	marsjkd_anim		; Address active acme list
	dc.l	marsjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	2			; Speed of 30 pictures per second
	dc.w	2			; Speed for restart
	dc.l	48			; Width in pixels


	dc.l	3695			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiterbs		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiterbs_anim		; Address of actual object list
	dc.l	leiterbs_anim		; Start address of object list
	dc.l	leiterbs_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Leiter gro 3
	dc.l	3700			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	leiter_f		; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	132/4			; Image Width
	dc.w	132/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	leiter_f_anim		; Address of actual object list
	dc.l	leiter_f_anim		; Start address of object list
	dc.l	leiter_f_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	132			; Image Width in Pixels

;;;=====================================
;;; Martian B-Mike Welle
;;;=====================================
	dc.l	3850			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	3865			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	3880			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	3895			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	3910			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	3925			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	3940			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	b_mike			; Start adress for object graphic data
	dc.w	31			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	b_mike_anim		; Address of actual object list
	dc.l	b_mike_anim		; Start address of object list
	dc.l	b_mike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	6			; Frame period each second
	dc.w	6			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
;;;=====================================
;;; Tripple play s_cra
;;;=====================================
	dc.l	4090			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	4110			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	4130			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
;;;
;;; Rockets Away
;;;
	dc.l	4550			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	4560			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4565			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4570			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	4575			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4575			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	4575			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	210*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	
		
	dc.l	4585			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4585			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4590			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	4590			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

;;;======================================
;;; Martian 2 s_cra "V Formation"
;;;======================================

; Welle S_Cra_Zoom
	dc.l	4650			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	4700			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	15			; Start adress of shooting list
	dc.l	gegner_shoot3		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	4700			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	30			; Start adress of shooting list
	dc.l	gegner_shoot5		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	dc.l	4750			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	4750			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;======================================
;;; Martian s_cra "V Formation" Wave III
;;;======================================

; Welle S_Cra_Zoom
	dc.l	5050			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	5100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	15			; Start adress of shooting list
	dc.l	gegner_shoot3		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	5100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	30			; Start adress of shooting list
	dc.l	gegner_shoot5		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	dc.l	5150			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	5150			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=============================================================================
;;;
;;;	Asteroid Belt
;;;
;;;=============================================================================
;;; explosive y-pos: 64, 128, 102, 10, 84, 195, 107, 100, 15, 52, 95, 114, 45, 92, 180, 50

; Meteor_1 unpacked
	dc.l	5314			; X-Pos where CLUT will be activated
	dc.l	meteor_1		; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	meteor_1_ice		; CLUT address for packed data


	dc.l	5400			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Startadresse Shot_daten
	dc.l	0			; Shot_counter
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid 

	dc.l	5410			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	64*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	5420			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	5425			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	5430			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m4_speed		; Frame period each second
	dc.w	m4_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	5435			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	10*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	5440			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	dc.l	5450			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	103*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor2_scale		; Adress actual scaling list
	dc.l	meteor2_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor2_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
		
	dc.l	5460			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	84*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
; Explosive Asteroid
	
	dc.l	5475			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	195*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
	dc.l	5500			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	88*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
	dc.l	5550			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	84*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	5580			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	107*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	5600			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid		
							
	dc.l	5650			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Minor Planet VESTA unpacked
	dc.l	5668			; X-pos where data is unpacked (2400=AU)
	dc.l	vestajkd			; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	vestajkd_ice		; Start address packed data

; Minor Planet VESTA
	dc.l	5668			; X-Pos (AU*2.362) Aphelion 2.572 Perihelion 2.151
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	120*2+42		; Y-Pos
	dc.l	vestajkd		; Start address of Sprite data
	dc.w	68			; Height 
	dc.w	68/4			; Width 
	dc.w	68/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	vestajkd_anim		; Address active acme list
	dc.l	vestajkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	68			; Width in pixels

	
	dc.l	5675			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	119*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m4_speed		; Frame period each second
	dc.w	m4_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
       	dc.l	5700			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor2_scale		; Adress actual scaling list
	dc.l	meteor2_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor2_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	5765			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	15*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
			
	
	dc.l	5800			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	132*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
					
	
	dc.l	5900			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	85*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m4_speed		; Frame period each second
	dc.w	m4_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	6000			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	52*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6100			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	

	dc.l	6200			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6300			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	dc.l	6400			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Minor Planet JUNO unpacked
	dc.l	6404			; X-pos where data is unpacked (2400=AU)
	dc.l	junojkd			; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	junojkd_ice		; Start address packed data

; Minor Planet JUNO
	dc.l	6404			; X-Pos (AU*3.167) Aphelion 3.358 Perihelion 1.979
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	120*2+42		; Y-Pos
	dc.l	junojkd			; Start address of Sprite data
	dc.w	32			; Height 
	dc.w	32/4			; Width 
	dc.w	32/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	junojkd_anim		; Address active acme list
	dc.l	junojkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	32			; Width in pixels
	
	
	dc.l	6500			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels



	dc.l	6550			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	6575			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	95*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6600			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	85*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor2_scale		; Adress actual scaling list
	dc.l	meteor2_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor2_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Dwarf Planet CERES unpacked
	dc.l	6638			; X-pos where data is unpacked (2400=AU)
	dc.l	ceresjkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	ceresjkd_ice		; Start address packed data

; Dwarf Planet CERES
	dc.l	6638			; X-Pos (AU*2.766) Aphelion 2.987 Perihelion 2.545
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	20*2+42			; Y-Pos
	dc.l	ceresjkd		; Start address of Sprite data
	dc.w	100			; Height 
	dc.w	100/4			; Width 
	dc.w	100/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	ceresjkd_anim		; Address active acme list
	dc.l	ceresjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	100			; Width in pixels


; Minor Planet PALLAS unpacked
	dc.l	6654			; X-pos where data is unpacked (2400=AU)
	dc.l	pallajkd			; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	pallajkd_ice		; Start address packed data

; Minor Planet PALLAS
	dc.l	6654			; X-Pos (AU*2.772) Aphelion 3.412 Perihelion 2.133
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	120*2+42		; Y-Pos
	dc.l	pallajkd			; Start address of Sprite data
	dc.w	64			; Height 
	dc.w	64/4			; Width 
	dc.w	64/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	pallajkd_anim		; Address active acme list
	dc.l	pallajkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	64			; Width in pixels


;;;=============================================================================
;;;
;;;	Checkpoint II: Odin's Slippery Ring
;;;	.cp2 = 6666
;;;
;;;=============================================================================
	dc.l	6700			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6720			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	152*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6725			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	74*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	6735			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	146*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m4_speed		; Frame period each second
	dc.w	m4_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6800			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	6830			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	81*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
		
	dc.l	6840			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	135*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	dc.l	6850			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	25*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	6865			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	114*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	6875			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	99*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
	dc.l	6900			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	6925			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	43*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
	dc.l	6950			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	184*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid

	dc.l	6980			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	68*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;======================================
;;; Kirkwood Gaps?
;;;======================================

	dc.l	7000			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	7100			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7200			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7250			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	7280			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	45*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7300			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	7325			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	92*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


; Minor Planet INETERAMNIA unpacked
	dc.l	7361			; X-pos where data is unpacked (2400=AU)
	dc.l	interjkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	interjkd_ice		; Start address packed data

; Minor Planet INTERAMNIA
	dc.l	7361			; X-Pos (AU*3.067)
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	120*2+42		; Y-Pos
	dc.l	interjkd		; Start address of Sprite data
	dc.w	44			; Height 
	dc.w	44/4			; Width 
	dc.w	44/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	interjkd_anim		; Address active acme list
	dc.l	interjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	44			; Width in pixels


	dc.l	7450			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	7500			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	72*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Minor Planet HYGIEA unpacked
	dc.l	7529			; X-pos where data is unpacked (2400=AU)
	dc.l	hygiejkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	hygiejkd_ice		; Start address packed data

; Minor Planet HYGIEA
	dc.l	7529			; X-Pos (AU*3.137) Aphelion 3.511 Perihelion 2.763
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	20*2+42			; Y-Pos
	dc.l	hygiejkd		; Start address of Sprite data
	dc.w	60			; Height 
	dc.w	60/4			; Width 
	dc.w	60/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	hygiejkd_anim		; Address active acme list
	dc.l	hygiejkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed		; Speed of 30 pictures per second
	dc.w	m3_speed		; Speed for restart
	dc.l	60			; Width in pixels


	dc.l	7575			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	

; Minor Planet DAVIDA unpacked
	dc.l	7600			; X-pos where data is unpacked (2400=AU)
	dc.l	davidjkd		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	davidjkd_ice		; Start address packed data

; Minor Planet DAVIDA
	dc.l	7600			; X-Pos (AU*3.167) Aphelion 3.754 Perihelion 2.580
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	120*2+42		; Y-Pos
	dc.l	davidjkd			; Start address of Sprite data
	dc.w	48			; Height 
	dc.w	48/4			; Width 
	dc.w	48/4			; Offset 
	dc.b	4			; Transition Flags
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	davidjkd_anim		; Address active acme list
	dc.l	davidjkd_anim		; Start address acme list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	48			; Width in pixels

	
	dc.l	7650			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Explosive Asteroid
	
	dc.l	7675			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	180*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7700			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7750			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
	
	dc.l	7800			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	98*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m5_speed		; Frame period each second
	dc.w	m5_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7850			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	102*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor3_scale		; Adress actual scaling list
	dc.l	meteor3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m2_speed		; Frame period each second
	dc.w	m2_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
	
; Explosive Asteroid
	
	dc.l	7905			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	2			; Firepower to destroy object
	dc.w	50			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	m3_speed		; Frame period each second
	dc.w	m3_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	7950			; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	118*2+42		; Y-Pos
	dc.l	meteor_1		; Start adress for object graphic data
	dc.w	28			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	meteor4_scale		; Adress actual scaling list
	dc.l	meteor4_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	meteor1_anim		; Address of actual object list
	dc.l	meteor1_anim		; Start address of object list
	dc.l	meteor2_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	m4_speed		; Frame period each second
	dc.w	m4_speed		; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;======================================
;;;	Crawler Introductions
;;;======================================	
	
; crawler entpacken
	dc.l	.cp2+1620		; X-Pos where CLUT will be activated
	dc.l	crawler			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	crawler_ice		; CLUT address for packed data


	dc.l	.cp2+1720		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
				
	
	dc.l	.cp2+1820		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


; crawler Welle 1
	dc.l	.cp2+1920		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo5_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2000		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
	

	dc.l	.cp2+2120		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2220		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2300		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2340		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2450		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+2550		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+2600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
	
	
	dc.l	.cp2+2600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+2750		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+2800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+2950		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+2960		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

;;;======================================
;;; q_bomb entpacken
;;;======================================

	dc.l	.cp2+3000		; X-Pos where CLUT will be activated
	dc.l	q_bomb			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	q_bomb_ice		; CLUT address for packed data
;;; Qe1
	dc.l	.cp2+3000		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3050		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3160		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels	
;;; Qe2
	dc.l	.cp2+3280		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3340		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3400		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3460		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels

;;; Qe3
	dc.l	.cp2+3520		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3580		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3640		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+3700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels

;;; Qe4
	dc.l	.cp2+4000		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+4050		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+4100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	110*2+42		; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp2+4160		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels

;;;======================================
;;;	"V Formation" Returns
;;;======================================
	dc.l	.cp2+4280		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp2+4300		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	15			; Start adress of shooting list
	dc.l	gegner_shoot3		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp2+4300		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale1		; Adress actual scaling list
	dc.l	s_cra_scale1		; Start adress of scaling list
	dc.l	30			; Start adress of shooting list
	dc.l	gegner_shoot5		; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve1		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	dc.l	.cp2+4330		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp2+4330		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	s_cra			; Start adress for object graphic data
	dc.w	22			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	s_cra_scale2		; Adress actual scaling list
	dc.l	s_cra_scale2		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	s_cra_anim		; Address of actual object list
	dc.l	s_cra_anim		; Start address of object list
	dc.l	s_cra_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	10			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;======================================
;;; Rockets Away
;;;======================================
	dc.l	.cp2+4350		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	.cp2+4360		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4365		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4370		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	.cp2+4375		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4375		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp2+4375		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	210*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	
		
	dc.l	.cp2+4385		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4385		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4390		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4390		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	dc.l	.cp2+4395		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4395		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	.cp2+4400		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	46*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4400			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	206*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

;;; add 225

	dc.l	.cp2+4625		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp2+4635		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4640		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4645			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	.cp2+4650		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	126*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4675		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels

	
	dc.l	.cp2+4675		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	190*2+42		; Y-Pos
	dc.l	rocket_b		; Start adress for object graphic data
	dc.w	9			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rocket_b_anim		; Address of actual object list
	dc.l	rocket_b_anim		; Start address of object list
	dc.l	rocket_b_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	15			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	
	
	dc.l	.cp2+4680		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4680		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4685			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4685		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4690		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4690		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4695		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4695		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

	
	dc.l	.cp2+4700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	66*2+42			; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels


	dc.l	.cp2+4700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	186*2+42		; Y-Pos
	dc.l	treffer			; Start adress for object graphic data
	dc.w	18			; Object Height
	dc.w	20/4			; Image Width
	dc.w	20/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	treffer_anim		; Address of actual object list
	dc.l	treffer_anim		; Start address of object list
	dc.l	treffer_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	20			; Image Width in Pixels

;;;======================================
;;; Crawler Wave
;;;======================================

	dc.l	.cp2+4720		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
				
	
	dc.l	.cp2+4820		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln



	dc.l	.cp2+4920		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo5_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5000		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
	

	dc.l	.cp2+5120		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5220		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5300		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5340		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5450		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

	
	dc.l	.cp2+5550		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+5600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln
	
	
	dc.l	.cp2+5600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	0*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	10			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	1			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	1			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+5750		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+5800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo7_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

; Planet JUPITER unpacked
	dc.l	12487			; X-pos where JUPITER is unpacked
	dc.l	RylosJKD		; Destination address packed data
	dc.w	PACKED			; Packed Data
	dc.w	0			; Freely
	dc.l	RylosJKD_ice		; Start address packed data


; Planet JUPITER
	dc.l	.cp2+5821		; X-Pos where JUPITER appears (AU*5.203) 12487
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	RylosJKD		; Start address of Sprite data
	dc.w	112			; Height 
	dc.w	112/4			; Width 
	dc.w	112/4			; Offset 
	dc.b	4			; Transition Flags
; standard (normal display)= 0 
; HFLIP (Horizontal FLIP)= 1 
; RMW (Read Modify Write "transparency")= 2 
; TRANS (don't display color 0 "transition")= 4 
; RELEASE = 8Transition Flags 4 = transparent black
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	planet_anim		; Address active Sprite list
	dc.l	planet_anim		; Start address Sprite list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	m3_speed			; Speed of 30 pictures per second
	dc.w	m3_speed			; Speed for restart
	dc.l	112			; Width in pixels


	dc.l	.cp2+5950		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_u		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln


	dc.l	.cp2+5960		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	crawler			; Spritedaten
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Anzahl Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.l	0			; akt. Skalierangaben
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Startadresse Skalierangaben
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	5			; Counter Schudaten
	dc.l	crawler_anim		; Adresse akt. Spriteliste
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve_o		; Start Kurvenliste
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	100			; Punkte
	dc.l	explo2_daten		; Start adress following object
	dc.w	2			; Geschwindigkeit in 60/x Bilder pro Sekunde
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width Sprite in Pixeln

;;; 707 interlude
;;;=============================================================================
;;;
;;;	Checkpoint III: Midgard 
;;;	.cp3 = 13333
;;;
;;;=============================================================================
		
;;; ball entpacken

	dc.l	.cp3			; X-Pos where CLUT will be activated
	dc.l	ball			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	ball_ice		; CLUT address for packed data
	
						
; Ball
	dc.l	.cp3			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


	dc.l	.cp3+15			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
		

	dc.l	.cp3+30			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	
	dc.l	.cp3+45			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	
	dc.l	.cp3+60			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
			
	
	dc.l	.cp3+75			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	44*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
;;;
	dc.l	.cp3+200			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


	dc.l	.cp3+215			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
		

	dc.l	.cp3+230			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	
	dc.l	.cp3+245			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	
	dc.l	.cp3+260			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
			
	
	dc.l	.cp3+275			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	-15*2+42			; Y-Pos
	dc.l	ball			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	ball_scale		; Adress actual scaling list
	dc.l	ball_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	ball_anim		; Address of actual object list
	dc.l	ball_anim		; Start address of object list
	dc.l	ball_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	3			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

;;;Qe4
	dc.l	.cp3+700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+750		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+850		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels	
;;; Qe5
	dc.l	.cp3+1050		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+1100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+1150		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	110*2+42		; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels


	dc.l	.cp3+1200		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos
	dc.l	q_bomb			; Start adress for object graphic data
	dc.w	34			; Object Height
	dc.w	36/4			; Image Width
	dc.w	36/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	q_bomb_scale		; Adress actual scaling list
	dc.l	q_bomb_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	q_bomb_anim		; Address of actual object list
	dc.l	q_bomb_anim		; Start address of object list
	dc.l	q_bomb_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	6			; Firepower to destroy object
	dc.w	150			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	36			; Image Width in Pixels

;;;	Interlude
;;;=============================================================================

;;;
;;; Spike entpacken
;;;
	dc.l	.cp3+1997		; X-Pos where CLUT will be activated
	dc.l	spike			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	spike_ice		; CLUT address for packed data
;;;
	dc.l	.cp3+2480		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	20*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


	dc.l	.cp3+2560		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	

	dc.l	.cp3+2600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	65*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


	dc.l	.cp3+2760		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	dc.l	.cp3+2800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	10*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	

	dc.l	.cp3+2840		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	142*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	90			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

;;;=====================================
;;; TEST
;;;=====================================
; resort_welle entpacken
	dc.l	.cp3+2900		; X-Pos wo Daten entpackt werden
	dc.l	resort			; Zieladresse gepackte Daten
	dc.w	PACKED			; gepackte Daten
	dc.w	0			; frei
	dc.l	resort_ice		; Startadresse gepackte Daten

			
; Doppelwelle Resort oben/unten	
	dc.l	.cp3+2900		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

		
	dc.l	.cp3+2900		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot4		; Startadresse Schudaten
	dc.l	60			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve2		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo2_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp3+2905		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot5		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo4_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

		
	dc.l	.cp3+2905		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot6		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve2		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp3+2910		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot5		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

		
	dc.l	.cp3+2910		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot6		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve2		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo4_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp3+2915		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot7		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo1_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp3+2915		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot6		; Startadresse Schudaten
	dc.l	60			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve2		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp3+2920		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot5		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo4_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp3+2920		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot6		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve2		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

;;;=============================================================================
;;;
;;;	Checkpoint IV: Frigga's Fortune Cookie
;;;	.cp4 = 19999
;;;
;;;=============================================================================
;;; 19999-16173=3826 interlude

	dc.l	.cp4+20			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	195*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
	
	dc.l	.cp4+140			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	dc.l	.cp4+260			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
	
	dc.l	.cp4+380			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	168*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	dc.l	.cp4+400			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	74*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
	
	dc.l	.cp4+470			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	194*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	dc.l	.cp4+520			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	195*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
	
	dc.l	.cp4+640			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	90*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	dc.l	.cp4+760			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
	
	dc.l	.cp4+880			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	168*2+42		; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels

	dc.l	.cp4+900			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	74*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	spike_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
;;;				
;;; ROTG (unpacked) FALLING
;;;
	dc.l	.cp4+1000		; X-Pos where CLUT will be activated
	dc.l	rotg			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	rotg_ice		; CLUT address for packed data

	
	dc.l	.cp4+1070			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	194*2+42			; Y-Pos
	dc.l	spike			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	spike_scale		; Adress actual scaling list
	dc.l	spike_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	spike_anim		; Address of actual object list
	dc.l	spike_anim		; Start address of object list
	dc.l	spike_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	4			; Firepower to destroy object
	dc.w	175			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels
	
;;; ROTG FALLING					
	
	dc.l	.cp4+1080		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	110			; X-Pos
	dc.w	-90*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		
	
	dc.l	.cp4+1080		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	180			; X-Pos
	dc.w	-60*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		
		
	dc.l	.cp4+1080		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	-30*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels

;;; ROTG RISING

	dc.l	.cp4+1920		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	290*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
	
		
	dc.l	.cp4+1950		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	180			; X-Pos
	dc.w	260*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	65			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		
		
	dc.l	.cp4+1980		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	110			; X-Pos
	dc.w	230*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	80			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels

;;;;;;;;;;;;; 320 interlude

; point entpacken
	dc.l	.cp4+2300		; X-Pos where CLUT will be activated
	dc.l	point			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	point_ice		; CLUT address for packed data

;;;	Pointsprite
 
	dc.l	.cp4+2300		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+2350		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+2356		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+2385		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
					

	dc.l	.cp4+2400		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+2465		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+2491		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+2520		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	200*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
		
	
	dc.l	.cp4+2550		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+2600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	75*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	40			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+2650		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+2680		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	125*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;	Pointsprite

	dc.l	.cp4+2700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

 
	dc.l	.cp4+2750		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+2756		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+2785		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
					

	dc.l	.cp4+2800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
				
	
	dc.l	.cp4+2865		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

; Planet SATURN unpacked
;	dc.l	.cp4+2895		; 22894 X-pos where SATURN is unpacked
;	dc.l	RylosJKD		; Destination address packed data
;	dc.w	PACKED			; Packed Data
;	dc.w	0			; Freely
;	dc.l	RylosJKD_ice		; Start address packed data

; Planet SATURN
	dc.l	22894			; X-Pos where SATURN appears (AU*9.539)
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos 
	dc.w	32*2+42			; Y-Pos
	dc.l	RylosJKD		; Start address of Sprite data
	dc.w	112			; Height 
	dc.w	112/4			; Width 
	dc.w	112/4			; Offset 
	dc.b	4			; Transition Flags
; standard (normal display)= 0 
; HFLIP (Horizontal FLIP)= 1 
; RMW (Read Modify Write "transparency")= 2 
; TRANS (don't display color 0 "transition")= 4 
; RELEASE = 8Transition Flags 4 = transparent black
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	dc.b	0			; Firstpix (Bit count to skip at beginning of object data)
	dc.b	0			; Object Type (0=Bmp obj 1=Scaled obj 2=GPU obj 3=Branch obj 4=Stop obj) 
	dc.b	4			; Object Depth is 16 bit (5=24bit 4=16bit 3=8bit CLUT 2=4bit CLUT 1=2bit CLUT 0=1bit CLUT 
	dc.b	1			; Object Pitch (0 = repeat phrase 1 = continuous data 2 = fetch every second phrase 3 = fetch every third phrase)
	dc.b	0			; Index in CLUT for Objects with CLUT
	dc.w 	0			; Scale Remainder
	dc.b	0			; x - Horizontal Scale Value (30=normal Size)
	dc.b	0			; y - Verticle Scale Value (30=normal Size)
	dc.l	0			; Active Object State (1 active 0 not display)
	dc.l	0			; Starting addr. Scaling data
	dc.l	0			; Start address Scaling (Schu) data
	dc.l	0			; Scaling (schu) counter
	dc.l	planet_anim		; Address active Sprite list
	dc.l	planet_anim		; Start address Sprite list
	dc.l	planet_kurve		; Start flight path
	dc.l	0			; Sample
	dc.w	DESTROY			; forces firepower around opponents to destroy
	dc.w	0			; Extra
	dc.l	0			; Start address data consequence of sprites
	dc.w	2			; Speed of 30 pictures per second
	dc.w	2			; Speed for restart
	dc.l	112			; Width in pixels

	
	dc.l	.cp4+2991		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+3020		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	200*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
		
	
	dc.l	.cp4+3050		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+3100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	75*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	40			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+3150		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+3280		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	125*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;======================================
;;;	Crawler Return Wave
;;;======================================

	dc.l	.cp4+3280		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	110*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3310		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3360		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels

		
	dc.l	.cp4+3400		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3440		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3480		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3520		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3560		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	.cp4+3610		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
;;;
	dc.l	.cp4+3640		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3680		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3720		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3760		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	.cp4+3810		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
;;;
	dc.l	.cp4+3880		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	140*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3920		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+3960		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	.cp4+4010		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
;;;
	dc.l	.cp4+4040		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+4080		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+4120		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels


	dc.l	.cp4+4160		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels
	

	dc.l	.cp4+4210		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42		; Y-Pos 
	dc.l	crawler			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	44/4			; Image Width
	dc.w	44/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	crawler_anim		; Address of actual object list
	dc.l	crawler_anim		; Start address of object list
	dc.l	crawler_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	0			; Firepower to destroy object
	dc.w	100			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	44			; Image Width in Pixels

;;;	Pointsprite
	
	dc.l	.cp4+4291		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+4320		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	200*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
		
	
	dc.l	.cp4+4350		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo7_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp4+4400		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	75*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	40			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+4450		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp4+4580		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	125*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;	Pointsprite
 
	dc.l	.cp4+4600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+4650		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+4656		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp4+4685		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
					

	dc.l	.cp4+4700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
				

	dc.l	.cp4+4765		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;	26666-24764=1902 interlude
;;;=============================================================================
;;;
;;;	Checkpoint V: Saturation Point 
;;;	.cp5 = 26666
;;;
;;;=============================================================================
;;;	L1_6D.s NOT INCLUDED IN ORIGINAL DEMO!


; Schutzkugel entpacken
	dc.l	.cp5			; X-Pos where CLUT will be activated
	dc.l	schutz			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	schutz_ice		; CLUT address for packed data

; Schutzkugel
	dc.l	.cp5			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+10			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+20			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+30			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	65*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+40			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+50			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY+8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+60			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY+8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+70			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY+8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+80			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY+8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	15			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+90			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY	; +8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot10		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY	; +8		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


;;;;;;;;;;;;;;;;;;; 500 interlude

	dc.l	.cp5+600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	15			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels



	dc.l	.cp5+600		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels



	dc.l	.cp5+620			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+620		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+640			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+640		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;;;;;;; 360 interlude

;Pfeilkurven fr Schutzkugel oben
	dc.l	.cp5+1000			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	100			; X-Pos
	dc.w	-32*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_oben_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+1010			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	150			; X-Pos
	dc.w	-32*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot6		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_oben_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	.cp5+1020			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	200			; X-Pos
	dc.w	-32*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot7		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_oben_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	.cp5+1030			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	-32*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot8		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_oben_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


;Pfeilkurven fr Schutzkugel unten
	dc.l	.cp5+1100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	100			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_unten_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+1110			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	150			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot12		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_unten_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	.cp5+1120			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	200			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot11		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_unten_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	
	dc.l	.cp5+1130		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot10		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	pfeil_unten_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
		
	dc.l	.cp5+1160			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+1170			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+1180			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	20*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	10			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+1190			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	190*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+2000			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot7		; Start adress of shooting list
	dc.l	25			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+2010			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	180*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot3		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


	dc.l	.cp5+2020			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

	dc.l	.cp5+2030			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+2040			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	65*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;Schutzkugel
	dc.l	.cp5+3000			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3010			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	55*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3020			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3030			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	65*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3040			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	170*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
			

	dc.l	.cp5+3100			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	210*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3110			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
							

	dc.l	.cp5+3120			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	60*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3130			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	165*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				

	dc.l	.cp5+3140			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	15*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels
				
; Schutzkugel Welle

	dc.l	.cp5+3500			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

; Schutzkugel Welle

	dc.l	.cp5+3530			; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	215*2+42		; Y-Pos
	dc.l	schutz			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	schutz_anim		; Address of actual object list
	dc.l	schutz_anim		; Start address of object list
	dc.l	schutz_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo5_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels


;;; Pointsprite 
	dc.l	.cp5+3535		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp5+3650		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	70*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot1		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

 
	dc.l	.cp5+3700		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels


	dc.l	.cp5+3785		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	125*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
					
 
	dc.l	.cp5+3800		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	50*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot2		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
				
	
	dc.l	.cp5+3865		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	150*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp5+3891		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	30			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp5+3920		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	30*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
		

	dc.l	.cp5+4050		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	130*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels
	
	
	dc.l	.cp5+4100		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	75*2+42			; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot5		; Start adress of shooting list
	dc.l	40			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp5+4150		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

	
	dc.l	.cp5+4280		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	125*2+42		; Y-Pos
	dc.l	point			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	28/4			; Image Width
	dc.w	28/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	point_scale		; Adress actual scaling list
	dc.l	point_scale		; Start adress of scaling list
	dc.l	gegner_shoot4		; Start adress of shooting list
	dc.l	20			; Shooting Rate
	dc.l	point_anim		; Address of actual object list
	dc.l	point_anim		; Start address of object list
	dc.l	point_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	200			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	28			; Image Width in Pixels

;;;=====================================
;;; Final ROTG Wave
;;;=====================================

; ROTG entpacken (again)
	dc.l	.cp5+4780		; X-Pos where CLUT will be activated
	dc.l	rotg			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	rotg_ice		; CLUT address for packed data

	dc.l	.cp5+4780		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	110			; X-Pos
	dc.w	-90*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		
	
	dc.l	.cp5+4780		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	180			; X-Pos
	dc.w	-60*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		
		
	dc.l	.cp5+4780		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	-30*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	100			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels


	dc.l	.cp5+4840		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	110			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	50			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
	
		
	dc.l	.cp5+4880		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	180			; X-Pos
	dc.w	276*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	65			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels


	dc.l	.cp5+4900		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	250			; X-Pos
	dc.w	226*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	rotg_shoot		; Start adress of shooting list
	dc.l	80			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve3		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo4_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels


	dc.l	.cp5+4910		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	40*2+42			; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
		

	dc.l	.cp5+4930		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	160*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo1_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
	
	
	dc.l	.cp5+4960		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	80*2+42			; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels
			

	dc.l	.cp5+4970		; Exposition 
	dc.w	layer2			; Layer offset
	dc.w	TOTAL_ENEMY		; PHRASE alignment for total object positions
	dc.w	320			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	rotg			; Start adress for object graphic data
	dc.w	30			; Object Height
	dc.w	60/4			; Image Width
	dc.w	60/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	rotg_anim		; Address of actual object list
	dc.l	rotg_anim		; Start address of object list
	dc.l	rotg_kurve2		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	1			; Firepower to destroy object
	dc.w	250			; Extra
	dc.l	explo2_daten		; Start adress following object
	dc.w	3			; Frame period each second
	dc.w	3			; Speed in pics/second for restart
	dc.l	60			; Image Width in Pixels

;;;=====================================
;;; TEST
;;;=====================================
	dc.l	.cp5+5005		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo2_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5010		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp5+5015		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo1_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5020		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo2_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5025		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5030		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5035		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot4		; Startadresse Schudaten
	dc.l	70			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo5_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp5+5040		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo1_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5045		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo2_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5050		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp5+5055		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo1_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5060		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot1		; Startadresse Schudaten
	dc.l	90			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo2_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5065		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5070		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln
	
	
	dc.l	.cp5+5075		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot4		; Startadresse Schudaten
	dc.l	70			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo5_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln


	dc.l	.cp5+5080		; X-Pos wo Gegner erscheint
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot4		; Startadresse Schudaten
	dc.l	70			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo1_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

	
	dc.l	.cp5+5085		; X-Pos at 17,835 October 8th 2007 (Alpine Accident 7pm)
	dc.w	layer2			; Vorder/Hintergrund Offset
	dc.w	TOTAL_ENEMY		; frei wegen PHRASE alignment
	dc.w	320			; X-Pos
	dc.w	100*2+42		; Y-Pos
	dc.l	resort			; Startadr. Spritedaten
	dc.w	25			; Hhe
	dc.w	16/4			; Breite
	dc.w	16/4			; Offset
	dc.b	4			; Flags 4=transparent
	dc.b	0			; Firstpix
	dc.b	0			; Object Typ 
	dc.b	4			; 65535 Farben
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y-Scale
	dc.b	0			; x-Scale
	dc.l	0			; Adresse akt. Skalierangaben
	dc.l	0			; Startadr. Skalierangaben
	dc.l	gegner_shoot2		; Startadresse Schudaten
	dc.l	120			; Schucounter
	dc.l	resort_anim		; Adr. akt. Spriteliste
	dc.l	resort_anim		; Startadresse Spriteliste
	dc.l	resort_kurve		; Start Flugbahn
	dc.l	0			; Sample
	dc.w	2			; ntige Feuerkraft um Gegner zu vernichten
	dc.w	0			; Extra
	dc.l	explo3_daten		; Startadresse Daten Folgesprites
	dc.w	4			; Geschwindigkeit 30 Bilder pro Sekunde
	dc.w	4			; Geschwindigkeit fr Neustart
	dc.l	16			; Breite in Pixeln

;;;
;;; Rotten Egg Nebula Unpacked
;;;
	dc.l	32282			; X-Pos where CLUT will be activated
	dc.l	renNASA			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	renNASA_ice		; CLUT address for packed data

; Rotten Egg Nebula Display
	dc.l	32282     		; Exposition 
	dc.w	layer1			; Layer offset
	dc.w	TOTAL_BACK		; PHRASE alignment for total object positions
	dc.w	310			; X-Pos
	dc.w	57*2+42			; Y-Pos  58
	dc.l	renNASA			; Start adress for object graphic data
	dc.w	120			; Height
	dc.w	128/4			; Width (Image Width)
	dc.w	128/4			; Offset
	dc.b	4			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens_anim		; Address of actual object list
	dc.l	lens_anim		; Start address of object list
	dc.l	lens_flare_kurve	; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	128			; Image Width in Pixels


; Helligkeit der Lense Flares
	dc.l	32235			; Exposition 
	dc.w	layer3+((TOTAL_ENEMY1-1)*OBJSIZE)	; Layer offset
	dc.w	1			; PHRASE alignment for total object positions
	dc.w	1			; X-Pos
	dc.w	42-MAX_Y		; Y-Pos
	dc.l	bright			; Start adress for object graphic data
	dc.w	256			; Object Height
	dc.w	0			; Offset !!
	dc.w	320/4			; Image Width !!
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	0			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	bright_anim		; Address of actual object list
	dc.l	bright_anim		; Start address of object list
	dc.l	bright_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	4			; Frame period each second
	dc.w	4			; Speed in pics/second for restart
	dc.l	320			; Image Width in Pixels

		
; Lense Flare 1 entpacken
	dc.l	32400			; X-Pos where CLUT will be activated
	dc.l	lens1			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	lens1_ice		; CLUT address for packed data

; Lense Flare 2 entpacken
	dc.l	32400			; X-Pos where CLUT will be activated
	dc.l	lens2			; Address to activate CLUT
	dc.w	PACKED			; Activate color look-up table (CLUT)
	dc.w	0			; Free
	dc.l	lens2_ice		; CLUT address for packed data

; Lense Flare 1
	dc.l	32400			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	-150			; X-Pos
	dc.w	110*2+42		; Y-Pos
	dc.l	lens1			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$32			; Reminder
	dc.b	20			; y - Verticle Scale
	dc.b	20			; x - Horizontal Scale
	dc.l	lens1_scale		; Adress actual scaling list
	dc.l	lens1_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens1_anim		; Address of actual object list
	dc.l	lens1_anim		; Start address of object list
	dc.l	lens1_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Lense Flare 2
	dc.l	32400			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	-470			; X-Pos
	dc.w	120*2+42		; Y-Pos
	dc.l	lens1			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$32			; Reminder
	dc.b	20			; y - Verticle Scale
	dc.b	20			; x - Horizontal Scale
	dc.l	lens2_scale		; Adress actual scaling list
	dc.l	lens2_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens1_anim		; Address of actual object list
	dc.l	lens1_anim		; Start address of object list
	dc.l	lens2_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Lense Flare 3
	dc.l	32400			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	-790			; X-Pos
	dc.w	131*2+42		; Y-Pos
	dc.l	lens1			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$32			; Reminder
	dc.b	20			; y - Verticle Scale
	dc.b	20			; x - Horizontal Scale
	dc.l	lens3_scale		; Adress actual scaling list
	dc.l	lens3_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens1_anim		; Address of actual object list
	dc.l	lens1_anim		; Start address of object list
	dc.l	lens3_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels


; Lense Flare 4
	dc.l	32400			; Exposition 
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	-1110			; X-Pos
	dc.w	150*2+42		; Y-Pos
	dc.l	lens1			; Start adress for object graphic data
	dc.w	40			; Object Height
	dc.w	40/4			; Image Width
	dc.w	40/4			; Offset
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	0			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	0			; Reminder
	dc.b	0			; y - Verticle Scale
	dc.b	0			; x - Horizontal Scale
	dc.l	0			; Adress actual scaling list
	dc.l	0			; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens1_anim		; Address of actual object list
	dc.l	lens1_anim		; Start address of object list
	dc.l	lens4_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	40			; Image Width in Pixels



; Lense Flare 5
	dc.l	32400			; Exposition
	dc.w	layer3			; Layer offset
	dc.w	TOTAL_ENEMY1		; PHRASE alignment for total object positions
	dc.w	-1430			; X-Pos
	dc.w	170*2+42		; Y-Pos
	dc.l	lens2			; Start adress for object graphic data
	dc.w	32			; Object Height
	dc.w	32/4			; Image Width
	dc.w	32/4			; Offset
	dc.b	6			; Transition Flags 4 = transparent black
	dc.b	0			; Firstpix
	dc.b	1			; Object Type 
	dc.b	4			; Depth
	dc.b	1			; Pitch
	dc.b	0			; Index
	dc.w 	$20			; Reminder
	dc.b	32			; y - Verticle Scale
	dc.b	32			; x - Horizontal Scale
	dc.l	lens5_scale		; Adress actual scaling list
	dc.l	lens5_scale		; Start adress of scaling list
	dc.l	0			; Start adress of shooting list
	dc.l	0			; Shooting Rate
	dc.l	lens2_anim		; Address of actual object list
	dc.l	lens2_anim		; Start address of object list
	dc.l	lens5_kurve		; Start adress of curve list
	dc.l	0			; Sample
	dc.w	DESTROY			; Firepower to destroy object
	dc.w	0			; Extra
	dc.l	0			; Start adress following object
	dc.w	2			; Frame period each second
	dc.w	2			; Speed in pics/second for restart
	dc.l	32			; Image Width in Pixels

;-------------------------------------------------------------------------	
; X-pos 33,333 may eventually start Sector II... but not today.
;-------------------------------------------------------------------------
	dc.l	0			; Last Object in Object List
