	.nlist
	.include	"jaguar.inc"
	.include	"blit.inc"
	.list
;
;
;
dlist	equ	$80000
image	equ	$90000
;
;
sessrow	equ	2
sesscol	equ	8
;
;
;
;
start:
	lea	$200000,sp		;set stack at top of memory
	clr.w	linecnt
	clr.w	prevpix

	move.w	#$100,JOY1		;unmute
;
;
	bsr	initdisp		;start-up some display here
;
	bsr	formbuf			;form an image in line buffers
;
;
	suba.l	a6,a6
loop:
	bsr	updisp
;
	adda.w	#289,a6
	move.w	linecnt,d7
	cmpi.w	#170+37,d7
	bcs	loop
;
	illegal
;
;
;
;
;
;  Flush Stella to display up to current color clock count 
;
; a6 - current color clock increment
;
updisp:
	move.l	a6,d0
	move.w	#228,d2
	sub.w	d2,d0		;have we gone into next line?
	bpl.s	.nexlin		;br if so
;
;  on same line
;
	add.w	d2,d0
	move.w	prevpix,d1
	move.w	d0,prevpix
	move.w	#68,d2
	sub.w	d2,d1
	bcc.s	.notedge
	moveq	#0,d1
.notedge:
	sub.w	d2,d0
	bhi.s	.weon
	rts			;nothing to display
;
;
.weon:
	sub.w	d1,d0		;d0 = width, d1= left pixel addr
	move.w	linecnt,d2
	bsr	displn
	rts
;
.nexlin:
	movea.w	d0,a6	
	move.w	prevpix,d1
	sub.w	d1,d2
	move.w	d2,d0
	move.w	linecnt,d2
	subi.w	#68,d1
	bsr	displn
	clr.w	prevpix
	addq.w	#1,linecnt
	bra	updisp
;
;
;  d1 = left pixel addr
;  d0 = width
;  d2 = line # (DSTY)
;
displn:
	subi.w	#37,d2		;displayable line?
	bcc.s	.dispgo
	rts
;
.dispgo:
	lea	BASE,a0			;use relative addressing for economy
;
.waitblit:
	move.l	b_cmd(a0),d3	;if blitter is in use, wait til done
	lsr.w	#1,d3
	bcc	.waitblit
;
	move.l	#image,a1_base(a0)	;ptr to screen for the destination
	move.l	#image,a2_base(a0)	;ptr to screen for the destination

	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a0)
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a2_flags(a0)

test:
;
;  A1 -> DST
;
	ext.l	d0
	swap	d2
	move.w	d1,d2
	move.l	d2,a1_pixel(a0)
	moveq	#1,d2
	swap	d2
	sub.l	d0,d2
	move.l	d2,a1_step(a0)
	moveq	#7,d3
	swap	d3
	move.w	d0,d3
	move.l	d3,b_count(a0)
	neg.l	d0
	move.l	d0,a2_step(a0)
;
;	move.l	#1*$10000-160,a1_step(a0)	;do same line over and over
;
	move.w	#lbufs+6,d2
	swap	d2
	move.w	d1,d2
	move.l	d2,a2_pixel(a0)
;
;	move.l	#(180+6)*$10000+0,a2_pixel(a0)
;
;	
;	move.l	#0*$10000-160,a2_step(a0)
;
;		  height    width
;	move.l	#(7*$10000)+160,b_count(a0)
;
	move.l	#0,b_patd(a0)
;
	move.l	#SRCEN|DCOMPEN|UPDA1|UPDA2|LFU_S,b_cmd(a0) ;do the blit
	rts
;
;
;
;
;
	.if	0
;
	lea	BASE,a0			;use relative addressing for economy
.wtblit:
	move.l	b_cmd(a0),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#21*$10000+0,a1_pixel(a0)	;dst (x,y)
;
	move.l	#2*$10000-160,a1_step(a0)	;do same line over and over
;
;	move.l	#image,a2_base(a0)
;	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a2_flags(a0)
;
	move.l	#20*$10000+0,a2_pixel(a0)

	move.l	#1*$10000-160,a2_step(a0)
;
;		  height    width
	move.l	#(20*$10000)+160,b_count(a0)
;
	move.l	#SRCEN|UPDA1|UPDA2|LFU_S,b_cmd(a0) ;do the blit
;
.wblit:
	move.l	b_cmd(a0),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wblit
;
	lea	fcount,a2
	move.l	(a2),d0
waitfrm:
	cmp.l	(a2),d0
	beq	waitfrm
;
	move.l	pptr,a1
	lea	joycur,a2

	move.l	(a2),d0
	move.l	16(a2),d1
	move.l	d0,16(a2)
	eor.l	d0,d1
	move.l	d0,d2
	and.l	d1,d2
	btst	#25,d2		;down
	bne	dodown

	btst	#24,d2		;up
	bne	doup

	btst	#26,d0		;left
	bne	doleft
;
	btst	#27,d0		;right
	bne	dorite

	bra	loop
;
doleft:
	move.l	a1,a2
	move.b	(a2),d1
	lea	1(a2),a3
	move.w	#158,d0
leftlp:
	move.b	(a3)+,(a2)+
	dbra	d0,leftlp
	move.b	d1,(a2)
	bra	loop
;
dorite:
	lea	160(a1),a2
	lea	-1(a2),a3
	move.b	(a3),d1
	move.w	#158,d0
ritelp:
	move.b	-(a3),-(a2)
	dbra	d0,ritelp
	move.b	d1,-(a2)
	bra	loop
;
dodown:
	add.l	#160,pptr
	bra	loop
doup:
	sub.l	#160,pptr
	bra	loop
;
;
	illegal
;
	.endif
;
;
;  Init the display
;
initdisp:
	lea	dlistROM,a0
	lea	dlist,a1
	moveq	#15,d0
getlist:
	move.l	(a0)+,(a1)+
	dbra	d0,getlist		;copy ROM display list to ram
;
;
	lea	image,a0
	move.l	#$02020202,d0
	move.w	#40*240-1,d1
clearimg:
	move.l	d0,(a0)+
	dbra	d1,clearimg
;
	clr.l	fcount
;
	lea	CLUT,a0
	lea	chroma,a1
	moveq	#15,d2
chrlp0:
	moveq	#7,d0
	moveq	#0,d1
	move.b	(a1)+,d3
	lsl.w	#8,d3
chrlp1:
	move.b	d1,d3
	move.w	d3,(a0)+
	move.w	d3,(a0)+
	add.w	#$20,d1
	dbra	d0,chrlp1
	dbra	d2,chrlp0
;
;
	move.l	#Frame,$100
	move.l	#dlist,d0
	swap	d0
	move.l	d0,OLP			;stop object is here
;
	moveq	#0,d0
	move.l	d0,BORD1
	move.w	d0,BG
	move.w	#-1,VDE
;
	move.w	#$101,INT1
;
	move.w	#$cc1,VMODE
;
	move.w	#%0000000000000000,BG		;black
;
	rts
;
;
;
;  form an image in the line buffers
;
;
formbuf:
;
lbufs	equ	193
;
player0	equ	image+(lbufs*160)
;
	lea	player0,a0
	lea	playset,a1
;
	move.l	a0,a2		;clear all line buffers 1st
	moveq	#0,d0
	move.w	#40*7-1,d1
clearlin:
	move.l	d0,(a2)+
	dbra	d1,clearlin
;
	moveq	#1,d4		;2 players to do
playrlp:
	move.b	(a1)+,d0	;get graphics
	move.b	(a1)+,d1	;color
	moveq	#0,d2
	move.b	(a1)+,d2	;horz position
	addq.l	#1,a1
	moveq	#7,d3
grphlp:
	lsl.b	#1,d0
	bcc.s	grph
	move.b	d1,(a0,d2.w)
grph:
	addq.w	#1,d2
	dbra	d3,grphlp
;
	adda.w	#160,a0
	move.b	(a1)+,d0	;missle graphics
	move.b	(a1)+,d2	;horz position
;
	moveq	#7,d3
misslp:
	lsl.b	#1,d0
	bcc.s	miss
	move.b	d1,(a0,d2.w)
miss:
	addq.w	#1,d2
	dbra	d3,misslp
;
	adda.w	#160,a0
	dbra	d4,playrlp	;go for other player
;
	move.b	(a1)+,d0	;ball graphic
	move.b	(a1)+,d1	;COLUPF
	moveq	#0,d2
	move.b	(a1)+,d2	;horz position
	move.b	(a1)+,d3	;COLUBK
;
	move.b	d1,d4		;4 copies of playfield color
	lsl.w	#8,d4
	move.b	d1,d4
	move.w	d4,d1
	swap	d1
	move.w	d4,d1
;
	move.b	d3,d4		;4 copies of bg color
	lsl.w	#8,d4
	move.b	d3,d4
	move.w	d4,d3
	swap	d3
	move.w	d4,d3
;
	moveq	#7,d4
ballit:
	lsl.b	#1,d0
	bcc.s	ballout
	move.b	d1,(a0,d2.w)
ballout:
	addq.w	#1,d2
	dbra	d4,ballit
;
	adda.w	#160,a0
;
	moveq	#-1,d0
	move.w	(a1)+,d0	;get 12 bits of playfield [11:00]
	move.b	(a1)+,d2	;get last 8 bits
	addq.l	#1,a1
;
	lea	160(a0),a2
	move.l	a2,a3
;
	lsl.w	#4,d0
	moveq	#11,d4
pflp:
;	move.l	d3,d5		;assume bg
	moveq	#0,d5		;always null on this line
	lsl.w	#1,d0
	bcc.s	bgok
	move.l	d1,d5
bgok:
	move.l	d5,-(a2)
	move.l	d5,(a0)+
	dbra	d4,pflp
;
	tst.l	d0
	bpl.s	doneset
	moveq	#0,d0
	move.b	d2,d0
	lsl.w	#8,d0
	moveq	#7,d4
	bra	pflp
doneset:
;
	moveq	#39,d0
bgloop:
	move.l	d3,(a3)+
	dbra	d0,bgloop
;
;
	rts
;
playset:
	dc.b	$a5,$18,120,0	;player0 (GRP0,COLUP0, horz position, dummy)
	dc.b	$c0,37		;missle0 (graphics, horz position
;
	dc.b	$89,$38,39,0	;player1 (GRP1,COLUP1, horz position, dummy)
	dc.b	$80,90		;missle1
;
	dc.b	$f0,$aa,27,$95	;ball graphic, COLUPF, horz position, COLUBK

	dc.b	%1001,%11001001,%01101101,0	;playfield graphics, dummy	
;
;
; V_blank routine
;
Frame:
	movem.l	d0-d2/a0-a1,-(sp)
	lea	dlistROM+32,a0
	lea	dlist+32,a1
	moveq	#3,d0
Flist:
	move.l	(a0)+,(a1)+
	dbra	d0,Flist		;copy ROM display list to ram
;
	move.w	#$0101,INT1		;clear CPU interrupt
	move.w	#0,INT2
;
	addq.l	#1,fcount
;
;
	.if	1
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81ff,d1
	moveq	#$11,d0
Floop:
	eor.w	d1,d0
	move.w	d0,(a1)		;ask for next row
;
	move.l	(a1),d2
	not.l	d2
	move.l	d2,(a0)+
;
	eor.w	d1,d0
	add.w	d0,d0
	cmpi.w	#$110,d0
	bcs	Floop
;
	.endif
	movem.l	(sp)+,d0-d2/a0-a1
;	move.w	#$0101,INT1		;clear CPU interrupt
;	move.w	#0,INT2
rrte:
	rte
;
;
chroma:
	dc.b	$78		;0
	dc.b	$EB		;1
	dc.b	$B6		;2
	dc.b	$A5		;3
	dc.b	$A3		;4
	dc.b	$84		;5
	dc.b	$63		;6
	dc.b	$55		;7
	dc.b	$26		;8
	dc.b	$28		;9
	dc.b	$3a		;A
	dc.b	$2c		;B
	dc.b	$5d		;C
	dc.b	$8b		;D
	dc.b	$7a		;E
	dc.b	$d7		;F
;	
;
;
;
;----------------------------------------------------------
;
;  Object type (Bits 0-2 in 1st 64-bit phrase of object)
; 
BMAPTYP		equ	0	;Bit-Map object
SCALTYP		equ	1	;Scaled Bit-Map object
GPUTYP		equ	2	;Graphics Processor interrupt Object
BRTYP		equ	3	;Branch Object
STOPTYP		equ	4	;Stop Object
;
;
;
;
;   Rom copy of the Object list
;
dlistROM:

OBJTYPE		set	BRTYP	;1st object is a BR object
BCC		set	1	;Br Condition Code (br if YPOS=<VC)
YPOS		set	21	;top branch object
	dc.w	0
	dc.l	(dlist+16) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
YPOS		set	519	;bottom branch object
	dc.w	0
	dc.l	(dlist+32) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
	dc.l	0,STOPTYP
	dc.l	0,STOPTYP
;
;
OBJTYPE		set	BMAPTYP	;1st object is a Scaled Bit-Map object
HEIGHT		set	200*2	;fill the screen
YPOS		set	81	;from the top
XPOS		set	16	;from the left edge
FIRSTPIX	set	0	;no left edge clipping
RELEASE		set	0	;release bus between image data fetches
TRANSPAR	set	0	;make logical color 0 transparent
RMW		set	0	;no read-modify-write
REFLECT		set	0	;no horizontal reflect
INDEX		set	0	;palette offset if 1-4 bits/pix
IWIDTH		set	20	;20 phrases in displayed image
DWIDTH		set	20	;20 phrases in source form
PITCH		set	1	;increment by 1 phrase for next fetch
DEPTH		set	3	;8 bits/pixel (2 color)
;
;  1st Object is a vanilla Bit-map, so it needs a 2 phrase header
;
;  1st phrase
 dc.l	(image << 8) + ((dlist+48) >> 11)
 dc.l	((dlist+48) << 21) + (HEIGHT << 13) + (YPOS << 3) + OBJTYPE 
;
;  2nd phrase
 dc.w (FIRSTPIX << 1) + RELEASE
 dc.w (TRANSPAR << 15) + (RMW << 14) + (REFLECT <<13) + (INDEX << 6) + (IWIDTH >> 4)
 dc.w ((IWIDTH & $0F) << 12) + (DWIDTH << 2) + (PITCH & $06)
 dc.w ((PITCH & 1) << 15) + (DEPTH << 12) + XPOS
;
 dc.l	0,STOPTYP,0,STOPTYP
;
;
;
	.bss
;
;player0:
;	ds.b	160
;missle0:
;	ds.b	160
;player1:
;	ds.b	160
;missle1:
;	ds.b	160
;ball:
;	ds.b	160
;playfld:
;	ds.b	160
;
linecnt:
	ds.w	1
prevpix:
	ds.w	1
;
;
joycur:
	ds.l	4
joyold:
	ds.l	4
fcount:
	ds.l	1
pptr:
	ds.l	1
;
