;
;
;
;  Macros for addressing modes
;
;
;  "zero page"
;
;  use (a0,d1.w) to access data
;
	.macro	zpage
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	.endm
;
;
;  "zero page by x" use (a0,d1.w) to access data
	.macro	zpagex
	moveq	#0,d1
	move.b	1(a0,d0.w),d1
	add.b	d5,d1
	.endm
;
;
;  "zero page by y" use (a0,d1.w) to access data
	.macro	zpagey
	moveq	#0,d1
	move.b	1(a0,d0.w),d1
	add.b	d6,d1
	.endm
	

;
;  "immediate"  data in d1
	.macro	immed
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	.endm
;
;
;  "absolute" use (a0,d1.w) to access data
;
	.macro	absol
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	.endm
;
;
;  "absolute by X" use (a0,d1.w) to access data
;
	.macro	absolx
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	move.w	d1,d0		;need to check page boundary crossing
	add.w	d5,d1		;add x
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.l	#3,a4		;page boundary crossing adds a cycle
	subq.l	#3,a2
.a\~:
	.endm
;
;  "absolute by Y" use (a0,d1.w) to access data
;
	.macro	absoly
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	move.w	d1,d0		;need to check page boundary crossing
	add.w	d6,d1		;add y
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.l	#3,a4		;page boundary crossing adds a cycle
	subq.l	#3,a2
.a\~:
	.endm
;
;  "Indirect by Y"  use (a0,d1.w) to access data
;
	.macro	indy
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	move.b	1(a0,d1.w),d0	;get HI
	lsl.w	#8,d0
	move.b	0(a0,d1.w),d0	; & LO
	andi.w	#$1fff,d0
	move.w	d0,d1		;need to check page boundary crossing
	add.w	d6,d1		;add y
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.l	#3,a4		;page boundary crossing adds a cycle
	subq.l	#3,a2
.a\~:
	.endm


;
;  "indirect by X"
;
;  use (a0,d0.w) to access data
;
	.macro	indx
	moveq	#0,d1		;(n,X)
	move.b	1(a0,d0.w),d1	;get n
	add.b	d5,d1		;add x
	move.b	1(a0,d1.w),d0	;get HI, eff addr
	lsl.w	#8,d0
	move.b	(a0,d1.w),d0	;then LO
	.endm
;
;
;
;  flags N & Z updated
	.macro	flagnz
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	.endm

;
;
;
;  flags N & Z & C updated

	.macro	flagnzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcc.s	.c\~
	bset	#0,d7		;set C flag
.c\~:
	.endm
;
;
;  flags N & V & Z & C updated

	.macro	flagnvzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcc.s	.c\~
	bset	#0,d7		;set C flag
.c\~:
	bvc.s	.d\~
	bset	#6,d7		;set V flag
.d\~:
	.endm
;
;
;  flags N & V & Z & C updated after subtract

	.macro	subnvzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcs.s	.c\~
	bset	#0,d7		;set not C flag
.c\~:
	bvc.s	.d\~
	bset	#6,d7		;set V flag
.d\~:
	.endm
;
;
;  flags N & Z & C updated after compare

	.macro	cmpnzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcs.s	.c\~
	bset	#0,d7		;set not C flag
.c\~:
	.endm
;
;
;  Branch if flag is clear
;
	.macro	brbitclr

	bne.s	.b\~		;br if not taken
	move.b	1(a0,d0.w),d1
	move.w	d2,d0
	ext.w	d1
	add.w	d1,d2		;adjust PC
	moveq	#3,d1		;assume no page boundary crossing
	eor.w	d2,d0
	btst	#8,d0		;cross page boundary?
	beq.s	.a\~
	addq	#3,d1
.a\~:
	adda.w	d1,a4		;advance cycle count
	suba.w	d1,a2
.b\~:
	.endm
;
;
;  Branch if flag is set
;
	.macro	brbitset

	beq.s	.b\~		;br if not taken
	move.b	1(a0,d0.w),d1
	move.w	d2,d0
	ext.w	d1
	add.w	d1,d2		;adjust PC
	moveq	#3,d1		;assume no page boundary crossing
	eor.w	d2,d0
	btst	#8,d0		;cross page boundary?
	beq.s	.a\~
	addq	#3,d1
.a\~:
	adda.w	d1,a4		;advance cycle count
	suba.w	d1,a2
.b\~:
	.endm
;
;
;
;
;  Write check to TIA
;
;
	.macro	d12TIA
	cmpi.w	#$2d,d1
	bcc.s	.a\~
	move.w	d1,a6
	bra.s	.b\~
.a\~:
	cmpi.w	#$80,d1
	bcc.s	.c\~
	move.b	#$ff,(a0,d1.w)
	bra.s	.b\~
.c\~:
	cmpi.w	#$294,d1	;check 6520 write (interval timer)
	bcs.s	.b\~
	cmpi.w	#$298,d1
	bcc.s	.b\~
	subi.w	#$294-$2d,d1
	move.w	d1,a6
.b\~:
	.endm
;
	.macro	d02TIA

	cmpi.w	#$2d,d0
	bcc.s	.a\~
	move.w	d0,a6
	bra.s	.b\~
.a\~:
	cmpi.w	#$80,d0
	bcc.s	.c\~
	move.b	#$ff,(a0,d0.w)
	bra.s	.b\~
.c\~:
	cmpi.w	#$294,d0	;check 6520 write (interval timer)
	bcs.s	.b\~
	cmpi.w	#$298,d0
	bcc.s	.b\~
	subi.w	#$294-$2d,d0
	move.w	d0,a6
.b\~:
	.endm
;
;
;
;
;
;
disp:
	dc.w	op00-disp
	dc.w	op01-disp
	dc.w	op02-disp
	dc.w	op03-disp
	dc.w	op04-disp
	dc.w	op05-disp
	dc.w	op06-disp
	dc.w	op07-disp
	dc.w	op08-disp
	dc.w	op09-disp
	dc.w	op0A-disp
	dc.w	op0B-disp
	dc.w	op0C-disp
	dc.w	op0D-disp
	dc.w	op0E-disp
	dc.w	op0F-disp
;	
	dc.w	op10-disp
	dc.w	op11-disp
	dc.w	op12-disp
	dc.w	op13-disp
	dc.w	op14-disp
	dc.w	op15-disp
	dc.w	op16-disp
	dc.w	op17-disp
	dc.w	op18-disp
	dc.w	op19-disp
	dc.w	op1A-disp
	dc.w	op1B-disp
	dc.w	op1C-disp
	dc.w	op1D-disp
	dc.w	op1E-disp
	dc.w	op1F-disp
;	
	dc.w	op20-disp
	dc.w	op21-disp
	dc.w	op22-disp
	dc.w	op23-disp
	dc.w	op24-disp
	dc.w	op25-disp
	dc.w	op26-disp
	dc.w	op27-disp
	dc.w	op28-disp
	dc.w	op29-disp
	dc.w	op2A-disp
	dc.w	op2B-disp
	dc.w	op2C-disp
	dc.w	op2D-disp
	dc.w	op2E-disp
	dc.w	op2F-disp
;	
	dc.w	op30-disp
	dc.w	op31-disp
	dc.w	op32-disp
	dc.w	op33-disp
	dc.w	op34-disp
	dc.w	op35-disp
	dc.w	op36-disp
	dc.w	op37-disp
	dc.w	op38-disp
	dc.w	op39-disp
	dc.w	op3A-disp
	dc.w	op3B-disp
	dc.w	op3C-disp
	dc.w	op3D-disp
	dc.w	op3E-disp
	dc.w	op3F-disp
;	
	dc.w	op40-disp
	dc.w	op41-disp
	dc.w	op42-disp
	dc.w	op43-disp
	dc.w	op44-disp
	dc.w	op45-disp
	dc.w	op46-disp
	dc.w	op47-disp
	dc.w	op48-disp
	dc.w	op49-disp
	dc.w	op4A-disp
	dc.w	op4B-disp
	dc.w	op4C-disp
	dc.w	op4D-disp
	dc.w	op4E-disp
	dc.w	op4F-disp
;	
	dc.w	op50-disp
	dc.w	op51-disp
	dc.w	op52-disp
	dc.w	op53-disp
	dc.w	op54-disp
	dc.w	op55-disp
	dc.w	op56-disp
	dc.w	op57-disp
	dc.w	op58-disp
	dc.w	op59-disp
	dc.w	op5A-disp
	dc.w	op5B-disp
	dc.w	op5C-disp
	dc.w	op5D-disp
	dc.w	op5E-disp
	dc.w	op5F-disp
;	
	dc.w	op60-disp
	dc.w	op61-disp
	dc.w	op62-disp
	dc.w	op63-disp
	dc.w	op64-disp
	dc.w	op65-disp
	dc.w	op66-disp
	dc.w	op67-disp
	dc.w	op68-disp
	dc.w	op69-disp
	dc.w	op6A-disp
	dc.w	op6B-disp
	dc.w	op6C-disp
	dc.w	op6D-disp
	dc.w	op6E-disp
	dc.w	op6F-disp
;	
	dc.w	op70-disp
	dc.w	op71-disp
	dc.w	op72-disp
	dc.w	op73-disp
	dc.w	op74-disp
	dc.w	op75-disp
	dc.w	op76-disp
	dc.w	op77-disp
	dc.w	op78-disp
	dc.w	op79-disp
	dc.w	op7A-disp
	dc.w	op7B-disp
	dc.w	op7C-disp
	dc.w	op7D-disp
	dc.w	op7E-disp
	dc.w	op7F-disp
;	
	dc.w	op80-disp
	dc.w	op81-disp
	dc.w	op82-disp
	dc.w	op83-disp
	dc.w	op84-disp
	dc.w	op85-disp
	dc.w	op86-disp
	dc.w	op87-disp
	dc.w	op88-disp
	dc.w	op89-disp
	dc.w	op8A-disp
	dc.w	op8B-disp
	dc.w	op8C-disp
	dc.w	op8D-disp
	dc.w	op8E-disp
	dc.w	op8F-disp
;	
	dc.w	op90-disp
	dc.w	op91-disp
	dc.w	op92-disp
	dc.w	op93-disp
	dc.w	op94-disp
	dc.w	op95-disp
	dc.w	op96-disp
	dc.w	op97-disp
	dc.w	op98-disp
	dc.w	op99-disp
	dc.w	op9A-disp
	dc.w	op9B-disp
	dc.w	op9C-disp
	dc.w	op9D-disp
	dc.w	op9E-disp
	dc.w	op9F-disp
;	
	dc.w	opA0-disp
	dc.w	opA1-disp
	dc.w	opA2-disp
	dc.w	opA3-disp
	dc.w	opA4-disp
	dc.w	opA5-disp
	dc.w	opA6-disp
	dc.w	opA7-disp
	dc.w	opA8-disp
	dc.w	opA9-disp
	dc.w	opAA-disp
	dc.w	opAB-disp
	dc.w	opAC-disp
	dc.w	opAD-disp
	dc.w	opAE-disp
	dc.w	opAF-disp
;	
	dc.w	opB0-disp
	dc.w	opB1-disp
	dc.w	opB2-disp
	dc.w	opB3-disp
	dc.w	opB4-disp
	dc.w	opB5-disp
	dc.w	opB6-disp
	dc.w	opB7-disp
	dc.w	opB8-disp
	dc.w	opB9-disp
	dc.w	opBA-disp
	dc.w	opBB-disp
	dc.w	opBC-disp
	dc.w	opBD-disp
	dc.w	opBE-disp
	dc.w	opBF-disp
;	
	dc.w	opC0-disp
	dc.w	opC1-disp
	dc.w	opC2-disp
	dc.w	opC3-disp
	dc.w	opC4-disp
	dc.w	opC5-disp
	dc.w	opC6-disp
	dc.w	opC7-disp
	dc.w	opC8-disp
	dc.w	opC9-disp
	dc.w	opCA-disp
	dc.w	opCB-disp
	dc.w	opCC-disp
	dc.w	opCD-disp
	dc.w	opCE-disp
	dc.w	opCF-disp
;	
	dc.w	opD0-disp
	dc.w	opD1-disp
	dc.w	opD2-disp
	dc.w	opD3-disp
	dc.w	opD4-disp
	dc.w	opD5-disp
	dc.w	opD6-disp
	dc.w	opD7-disp
	dc.w	opD8-disp
	dc.w	opD9-disp
	dc.w	opDA-disp
	dc.w	opDB-disp
	dc.w	opDC-disp
	dc.w	opDD-disp
	dc.w	opDE-disp
	dc.w	opDF-disp
;	
	dc.w	opE0-disp
	dc.w	opE1-disp
	dc.w	opE2-disp
	dc.w	opE3-disp
	dc.w	opE4-disp
	dc.w	opE5-disp
	dc.w	opE6-disp
	dc.w	opE7-disp
	dc.w	opE8-disp
	dc.w	opE9-disp
	dc.w	opEA-disp
	dc.w	opEB-disp
	dc.w	opEC-disp
	dc.w	opED-disp
	dc.w	opEE-disp
	dc.w	opEF-disp
;	
	dc.w	opF0-disp
	dc.w	opF1-disp
	dc.w	opF2-disp
	dc.w	opF3-disp
	dc.w	opF4-disp
	dc.w	opF5-disp
	dc.w	opF6-disp
	dc.w	opF7-disp
	dc.w	opF8-disp
	dc.w	opF9-disp
	dc.w	opFA-disp
	dc.w	opFB-disp
	dc.w	opFC-disp
	dc.w	opFD-disp
	dc.w	opFE-disp
	dc.w	opFF-disp
;
;
;d0 opcode address (68k fixed)
;d1 opcode *2
;
;d2 = pc
;d3 = sp
;d4 = accum
;d5 = x
;d6 = y
;d7 = flags
;
;	
op00:				;BRK
;	move.l	d0,a6
;	move.l	$f00050,d0
;	swap	d0
;	neg.l	d0
;	exg.l	d0,a6
;
	illegal			;***temp

	bset	#4,d7		;set Break flag
	move.w	d2,d0
	addq.w	#1,d0
	rol.w	#8,d0		;LO:HI
	move.b	d0,(a0,d3.w)	;push hi byte
	subq.b	#1,d3		;SP-1 -> SP
	rol.w	#8,d0		;HI:LO
	move.b	d0,(a0,d3.w)	;push lo byte
	subq.b	#1,d3
	move.b	d7,(a0,d3.w)	;push P
	subq.b	#1,d3
;
	move.w	#$1ffe,d0
	move.w	(a0,d0.w),d2
	rol.w	#8,d2
	move.w	#$1fff,d0
	and.w	d2,d0
	bra	retv
;
;
;
op01:				;ORA (n,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	or.b	(a0,d0.w),d4	;ORA to accum
	flagnz
	bra	retv

;
;
op02:
op03:
op04:
op07:
op0B:
op0C:
op0F:
op12:
op13:
op14:
op17:
op1A:
op1B:
op1C:
op1F:
op22:
op23:
op27:
op2B:
op2F:
op32:
op33:
op34:
op37:
op3A:
op3B:
op3C:
op3F:
op42:
op43:
op44:
op47:
op4B:
op4F:
op52:
op53:
op54:
op57:
op5A:
op5B:
op5C:
op5F:
op62:
op63:
op64:
op67:
op6B:
op6F:
op72:
op73:
op74:
op77:
op7A:
op7B:
op7C:
op7F:
op80:
op82:
op83:
op87:
op89:
op8B:			
op8F:
op92:
op93:
op97:
op9B:			
op9C:
op9E:
op9F:
opA3:
opA7:
opAB:
opAF:
opB2:
opB3:
opB7:
opBB:
opBF:
opC2:
opC3:
opC7:
opCB:
opCF:
opD2:
opD3:
opD4:
opD7:
opDA:
opDB:
opDC:
opDF:
opE2:
opE3:
opE7:
opEB:
opEF:
opF2:
opF3:
opF4:
opF7:
opFA:
opFB:
opFC:
opFF:
	illegal			;we never want to get here
;
;
op05:				;ORA n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op06:				;ASL n
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	zpage
	move.b	(a0,d1.w),d0
	asl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op08:				;PHP
	move.b	d7,(a0,d3.w)	;push FLAGS byte
	move.w	d3,d1
	subq.b	#1,d3		;SP-1 -> SP
	d12TIA
	bra	retv	
;
;
op09:				;ORA #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	or.b	d1,d4		;ORA to accum
	flagnz
	bra	retv
;
;
op0A:				;ASL a
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	asl.b	#1,d4	
	flagnzc
	bra	retv
;
;
op0D:				;ORA nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op0E:				;ASL nn
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	absol

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)

	flagnz
	bra	retv
;
;	
op10:				;BPL
	btst	#7,d7		;check N flag
	brbitclr
	bra	retv
;
;
op11:				;ORA (n),y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op15:				;ORA n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op16:				;ASL n,X
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	zpagex

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op18:				;CLC
	bclr	#0,d7
	bra	retv
;
;
op19:				;ORA nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op1D:				;ORA nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	bra	retv
;
;
op1E:				;ASL nn,X
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	absolx

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)

	flagnzc
	d12TIA

	bra	retv
;
;

op20:				;JSR nn
	move.w	d2,d1		;get return address
	move.b	2(a0,d0.w),d2
	lsl.w	#8,d2
	move.b	1(a0,d0.w),d2	;new jump address

	subq.w	#1,d1		;push return address -1
	rol.w	#8,d1		;LO:HI
	move.b	d1,(a0,d3.w)	;push hi byte
	subq.b	#1,d3		;SP-1 -> SP
	rol.w	#8,d1		;HI:LO
	move.b	d1,(a0,d3.w)	;push lo byte
	subq.b	#1,d3
;
	bra	retv
;
;
op21:				;AND (x,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	and.b	(a0,d0.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op24:				;BIT n
	zpage
	move.b	(a0,d1.w),d0	;fetch data
	move.w	d0,d1		;copy
	andi.w	#%00111101,d7	;clear N & V & Z
	andi.w	#%11000000,d0	;copy N & V to flags
	or.w	d0,d7		;
	and.b	d4,d1		;check AND result
	bne.s	op24x
	ori.w	#%00000010,d7	;set Z flag if EQ
op24x:
	bra	retv
;
;
op25:				;AND n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op26:				;ROL n
	zpage
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;	
op28:				;PLP
	addq.w	#1,d3
	move.b	(a0,d3.w),d7
	bra	retv
;
;
op29:				;AND #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	and.b	d1,d4		;AND to accum
	flagnz
	bra	retv
;
;
op2A:				;ROL a
	move.w	d7,d1
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.w	#1,d1
	roxl.b	#1,d4	
	flagnzc
	bra	retv
;
;
op2C:				;BIT nn
	absol
	move.b	(a0,d1.w),d0	;fetch data
	move.w	d0,d1		;copy
	andi.w	#%00111101,d7	;clear N & V & Z
	andi.w	#%11000000,d0	;copy N & V to flags
	or.w	d0,d7		;
	and.b	d4,d1		;check AND result
	bne.s	op2Cx
	ori.w	#%00000010,d7	;set Z flag if EQ
op2Cx:
	bra	retv
;
;
op2D:				;AND nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op2E:				;ROL nn
	absol
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op30:				;BMI
	btst	#7,d7		;check N flag
	brbitset
	bra	retv
;
;
op31:				;AND (n),Y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op35:				;AND n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op36:				;ROL n,X
	zpagex
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op38:				;SEC
	bset	#0,d7
	bra	retv
;
;
op39:				;AND nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op3D:				;AND nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	bra	retv
;
;
op3E:				;ROL xx,X
	absolx
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op40:				;RTI
	addq.b	#1,d3
	move.b	(a0,d3.w),d7	;pop FLAGS
	addq.b	#1,d3
	move.b	(a0,d3.w),d0
	addq.b	#1,d3
	move.b	(a0,d3.w),d2
	lsl.w	#8,d2
	move.b	d0,d2
	bra	retv
;
;
op41:				;EOR (n,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	move.b	(a0,d0.w),d1
	eor.b	d1,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op45:				;EOR n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op46:				;LSR n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	zpage
	move.b	(a0,d1.w),d0
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op48:				;PHA
	move.b	d4,(a0,d3.w)	;push accum
	move.w	d3,d1
	subq.b	#1,d3		;SP-1 -> SP
	d12TIA
	bra	retv
;
;
op49:				;EOR #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	eor.b	d1,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op4A:				;LSR a
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.b	#1,d4	
	flagnzc
	bra	retv
;
;
op4C:				;JMP nn
	move.b	2(a0,d0.w),d2
	lsl.w	#8,d2
	move.b	1(a0,d0.w),d2	;new jump address
	bra	retv
;
;
op4D:				;EOR nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op4E:				;LSR nn
	absol
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	bra	retv
;
;
op50:				;BVC
	btst	#6,d7		;check V flag
	brbitclr
	bra	retv
;
;
op51:				;EOR (n),Y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op55:				;EOR n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex

	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op56:				;LSR n,X
	zpagex
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op58:				;CLI
	bclr	#2,d7
	bra	retv
;
;
op59:				;EOR nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op5D:				;EOR nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	bra	retv
;
;
op5E:				;LSR nn,X
	absolx
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op60:				;RTS
	addq.b	#1,d3
	move.b	(a0,d3.w),d0
	addq.b	#1,d3
	move.b	(a0,d3.w),d2
	lsl.w	#8,d2
	move.b	d0,d2
	addq.w	#1,d2
	bra	retv
;
;
op61:				;ADC (n,X)
	indx
	move.w	d7,d1
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op61d		;br if so
	addx.b	d1,d4	
	bra.s	op61x	
op61d:
	abcd	d1,d4		;decimal mode
op61x:
	flagnvzc
	bra	retv
;
;
op65:				;ADC n
	zpage
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op65d		;br if so
	addx.b	d0,d4	
	bra.s	op65x	
op65d:
	abcd	d0,d4		;decimal mode
op65x:
	flagnvzc
	bra	retv
;
;
op66:				;ROR n
	zpage
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	bra	retv
;
;
op68:				;PLA
	addq.b	#1,d3
	move.b	(a0,d3.w),d4
	flagnz
	bra	retv
;
;
op69:				;ADC #n
	immed
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	btst	#3,d7		;in Decimal mode?
	bne.s	op69d		;br if so
	addx.b	d1,d4	
	bra.s	op69x	
op69d:
	abcd	d1,d4		;decimal mode
op69x:
	flagnvzc
	bra	retv
;
;
op6A:				;ROR a
	move.w	d7,d1
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.w	#1,d1
	roxr.b	#1,d4	
	flagnzc
	bra	retv
;
;
op6C:				;JMP (nn)
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1	;now LO
	addq.b	#1,d1		;this mimics vector on pg boundary bug
	move.b	(a0,d1.w),d2	;get HI
	lsl.w	#8,d2
	subq.b	#1,d1
	move.b	(a0,d1.w),d2	;new PC, let's jump
	bra	retv
;
;
;	
op6D:				;ADC nn
	absol
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op6Dd		;br if so
	addx.b	d0,d4	
	bra.s	op6Dx	
op6Dd:
	abcd	d0,d4		;decimal mode
op6Dx:
	flagnvzc
	bra	retv
;
;
op6E:				;ROR nn
	absol
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op70:				;BVS
	btst	#6,d7		;check V flag
	brbitset
	bra	retv
;
;
op71:				;ADC (n),Y
	indy
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op71d		;br if so
	addx.b	d0,d4	
	bra.s	op71x	
op71d:
	abcd	d0,d4		;decimal mode
op71x:
	flagnvzc
	bra	retv
;
;
op75:				;ADC n,X
	zpagex
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op75d		;br if so
	addx.b	d0,d4	
	bra.s	op75x	
op75d:
	abcd	d0,d4		;decimal mode
op75x:
	flagnvzc
	bra	retv
;
;
op76:				;ROR n,X
	zpagex
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op78:
	bset	#2,d7		;SEI
	bra	retv
;
;
op79:				;ADC nn,Y
	absoly
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op79d		;br if so
	addx.b	d0,d4	
	bra.s	op79x	
op79d:
	abcd	d0,d4		;decimal mode
op79x:
	flagnvzc
	bra	retv
;
;
op7D:				;ADC nn,x
	absolx
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op7Dd		;br if so
	addx.b	d0,d4	
	bra.s	op7Dx	
op7Dd:
	abcd	d0,d4		;decimal mode
op7Dx:
	flagnvzc
	bra	retv
;
;
op7E:				;ROR nn,X
	absolx
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	d12TIA
	bra	retv
;
;
op81:				;STA (n,X)
	indx
	move.b	d4,(a0,d0.w)
	d02TIA
	bra	retv
;
;
op84:				;STY n
	zpage
	move.b	d6,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op85:				;STA n
	zpage
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;	
;
op86:				;STX n
	zpage
	move.b	d5,(a0,d1.w)
	d12TIA	
	bra	retv
;
;	
op88:				;DEY
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,d6
	flagnz
	bra	retv
;
;

op8A:				;TXA
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d5,d4
	flagnz
	bra	retv
;
;
op8C:				;STY nn
	absol
	move.b	d6,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op8D:				;STA nn
	absol
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op8E:				;STX nn
	absol
	move.b	d5,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op90:				;BCC
	btst	#0,d7		;check C flag
	brbitclr
	bra	retv
;
;
op91:				;STA (n),Y
	indy
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op94:				;STY n,X
	zpagex
	move.b	d6,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op95:				;STA n,X
	zpagex
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op96:				;STX n,Y
	zpagey
	move.b	d5,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op98:				;TYA
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d6,d4
	flagnz
	bra	retv
;
;
op99:				;STA nn,Y
	absoly
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
op9A:				;TXS
	move.w	d5,d3
	bra	retv
;
;
op9D:				;STA nn,X
	absolx
	move.b	d4,(a0,d1.w)
	d12TIA	
	bra	retv
;
;
opA0:				;LDY #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d6
	flagnz
	bra	retv
;
;
opA1:				;LDA (n,X)
	indx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d0.w),d4
	flagnz
	bra	retv
;
;
opA2:				;LDX #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d5
	flagnz
	bra	retv
;
;
opA4:				;LDY n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	bra	retv
;
;
opA5:				;LDA n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;
opA6:				;LDX n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	bra	retv
;
;
opA8:				;TAY
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d4,d6
	flagnz
	bra	retv
;
;
opA9:				;LDA #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d4
	flagnz
	bra	retv
;
;
opAA:				;TAX
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d4,d5
	flagnz
	bra	retv
;
;
opAC:				;LDY nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	bra	retv
;
;
opAD:				;LDA nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;
opAE:				;LDX nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	bra	retv
;
;
opB0:				;BCS
	btst	#0,d7		;check C flag
	brbitset
	bra	retv
;
;
opB1:				;LDA (n),Y
	indy
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;
opB4:				;LDY n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	bra	retv
;
;
opB5:				;LDA n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;

opB6:				;LDX n,Y
	zpagey
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	bra	retv
;
;
opB8:				;CLV
	bclr	#6,d7
	bra	retv
;
;
opB9:				;LDA nn,Y
	absoly
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;
opBA:				;TSX
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d3,d5
	flagnz
	bra	retv
;
;
opBC:				;LDY nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	bra	retv
;
;

opBD:				;LDA nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	bra	retv
;
;
opBE:				;LDX nn,Y
	absoly
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	bra	retv
;
;
opC0:				;CPY #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d6
	cmpnzc
	bra	retv
;
;
opC1:				;CMP (n,X)
	indx
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d0.w),d4
	cmpnzc
	bra	retv
;
;
opC4:				;CPY n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d6
	cmpnzc
	bra	retv
;
;
opC5:				;CMP n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opC6:				;DEC n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	sub.b	#1,(a0,d1.w)
	flagnz
	d12TIA	
	bra	retv
;
;
opC8:				;INY
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,d6
	flagnz
	bra	retv
;
;
opC9:				;CMP #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d4
	cmpnzc
	bra	retv
;
;
opCA:				;DEX
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,d5
	flagnz
	bra	retv
;
;
opCC:				;CPY nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d6
	cmpnzc
	bra	retv
;
;
opCD:				;CMP nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opCE:				;DEC nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	d12TIA	
	bra	retv
;
;
opD0:				;BNE
	btst	#1,d7
	brbitclr
	bra	retv
;
;
opD1:				;CMP (n),Y
	zpagey
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opD5:				;CMP n,X
	zpagex
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opD6:				;DEC n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	d12TIA	
	bra	retv
;
;
opD8:				;CLD
	bclr	#3,d7
	bra	retv
;
;	
opD9:				;CMP nn,Y
	absoly
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opDD:				;CMP nn,X
	absolx
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	bra	retv
;
;
opDE:				;DEC nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	d12TIA	
	bra	retv
;
;
opE0:				;CPX #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d5
	cmpnzc
	bra	retv
;
;
opE1:				;SBC (n,X)
	indx
	move.w	d7,d1
	not.w	d1		;invert CY
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE1d		;br if so
	subx.b	d1,d4	
	bra.s	opE1x	
opE1d:
	sbcd	d1,d4		;decimal mode
opE1x:
	subnvzc
	bra	retv
;
;
opE4:				;CPX n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d5
	cmpnzc
	bra	retv
;
;
opE5:				;SBC n
	zpage
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE5d		;br if so
	subx.b	d0,d4	
	bra.s	opE5x	
opE5d:
	sbcd	d0,d4		;decimal mode
opE5x:
	subnvzc
	bra	retv
;
;
opE6:				;INC n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	bra	retv
;
;
opE8:				;INX
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,d5
	flagnz
	bra	retv
;
;
opE9:				;SBC #n
	move.w	d7,d1
	not.w	d1		;invert CY
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	1(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE9d		;br if so
	subx.b	d1,d4	
	bra.s	opE9x	
opE9d:
	sbcd	d1,d4		;decimal mode
opE9x:
	subnvzc
	bra	retv
;
;
opEA:				;NOP
	bra	retv
;
;
opEC:				;CPX nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d5
	cmpnzc
	bra	retv
;
;
opED:				;SBC nn
	absol
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opEDd		;br if so
	subx.b	d0,d4	
	bra.s	opEDx	
opEDd:
	sbcd	d0,d4		;decimal mode
opEDx:
	subnvzc
	bra	retv
;
;
opEE:				;INC nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	bra	retv
;
;
opF0:				;BEQ
	btst	#1,d7		;check Z flag
	brbitset
	bra	retv
;
;
opF1:				;SBC (n),Y
	indy
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF1d		;br if so
	subx.b	d0,d4	
	bra.s	opF1x	
opF1d:
	sbcd	d0,d4		;decimal mode
opF1x:
	subnvzc
	bra	retv
;
;
opF5:				;SBC n,X
	zpagex
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF5d		;br if so
	subx.b	d0,d4	
	bra.s	opF5x	
opF5d:
	sbcd	d0,d4		;decimal mode
opF5x:
	subnvzc
	bra	retv
;
;
opF6:				;INC n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	bra	retv
;
;
opF8:				;SED
	bset	#3,d7
	bra	retv
;
;
opF9:				;SBC nn,Y
	absoly
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF9d		;br if so
	subx.b	d0,d4	
	bra.s	opF9x	
opF9d:
	sbcd	d0,d4		;decimal mode
opF9x:
	subnvzc
	bra	retv
;
;
opFD:				;SBC nn,X
	absolx
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opFDd		;br if so
	subx.b	d0,d4	
	bra.s	opFDx	
opFDd:
	sbcd	d0,d4		;decimal mode
opFDx:
	subnvzc
	bra	retv
;
;
opFE:				;INC nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	bra	retv
;
;
;	
;
;  Cycle counts
;
cyclez:
	.if	0
;
; (in 6502 machine cycles)
	dc.w	7,6,0,0,0,3,5,0,3,2,5,0,0,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,3,3,5,0,4,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	6,6,0,0,0,3,5,0,3,2,2,0,3,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,0,3,5,0,4,2,2,0,5,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	0,6,0,0,3,3,3,0,2,0,2,0,4,4,4,0
	dc.w	2,6,0,0,4,4,4,0,2,5,2,0,0,4,0,0
	dc.w	2,6,2,0,3,3,3,0,2,2,2,0,4,4,4,0
	dc.w	2,5,0,0,4,4,4,0,2,4,2,0,4,4,4,0

	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	.endif
;
;  (in 2600 color clocks)
	dc.w	$15,$12,$00,$00,$00,$09,$0F,$00
	dc.w	$09,$06,$0F,$00,$00,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$0C,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$00,$09,$0F,$00
	dc.w	$09,$06,$06,$00,$09,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$12,$12,$00,$00,$00,$09,$0F,$00
	dc.w	$0C,$06,$06,$00,$0F,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$00,$12,$00,$00,$09,$09,$09,$00
	dc.w	$06,$00,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$12,$00,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0F,$06,$00,$00,$0C,$00,$00
	dc.w	$06,$12,$06,$00,$09,$09,$09,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0F,$00,$00,$0C,$0C,$0C,$00
	dc.w	$06,$0C,$06,$00,$0C,$0C,$0C,$00
	dc.w	$06,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
	dc.w	$06,$12,$00,$00,$09,$09,$0F,$00
	dc.w	$06,$06,$06,$00,$0C,$0C,$12,$00
	dc.w	$06,$0F,$00,$00,$00,$0C,$12,$00
	dc.w	$06,$0C,$00,$00,$00,$0C,$15,$00
;
;	
;  opcode size (in bytes)
;
bytcount:
	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,0,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	3,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

	dc.w	0,2,0,0,2,2,2,0,1,0,1,0,3,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,3,1,0,0,3,0,0
	dc.w	2,2,2,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,3,1,0,3,3,3,0

	dc.w	2,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

;
