;*======================================================================*
;*                TITLE:                  BLIT.INC			*
;*                Function:               Blitter variables		*
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                Programmer:             Andrew J. Burgess		*
;*                                        Rob Zdybel    		*
;*                                        Leonard Tramiel		*
;*                                                                      *
;*			COPYRIGHT 1992 Atari Computer Corporation       *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.			*
;*                                                                      *
;*======================================================================*

;*======================================================================*
;* ADDRESS REGISTERS	- see jaguar.inc
;*======================================================================*
;
;	BLTTER REGISTER OFFSETS -- set address reg to BASE and use nnnn(Ax)
;
a1_base		equ	$2200	; a1 base
a1_flags	equ	$2204	; a1 control 
a1_clip		equ	$2208	; a1 clipping 
a1_pixel	equ	$220c	; a1 pixel pointer
a1_step		equ	$2210	; a1 step (integer part)
a1_fstep	equ	$2214	; a1 step (fractional part)
a1_fpixel	equ	$2218	; a1 pixel pointer (fractional)
a1_inc		equ	$221c	; a1 increment (integer part)
a1_finc		equ	$2220	; a1 increment (fractional part)
a2_base		equ	$2224	; a2 base address
a2_flags	equ	$2228	; a2 control flags
a2_mask		equ	$222c	; a2 address mask
a2_pixel	equ	$2230	; a2 pixel
a2_step		equ	$2234	; a2 step (integer)

b_cmd		equ	$2238	; command
b_count		equ	$223c	; counters
b_srcd		equ	$2240	; source data
b_dstd		equ	$2248	; destination data
b_dstz		equ	$2250	; destination z
b_srcz1		equ	$2258	; source z (integer)
b_srcz2		equ	$2260	; source z (fractional)
b_patd		equ	$2268	; pattern data
b_iinc		equ	$2270	; intensity increment
b_zinc		equ	$2274	; z increment
b_stop		equ	$2278	; Collision stop control
;
b_i3		equ	$227C	; Blitter Intensity 3
b_i2		equ	$2280	; Blitter Intensity 2
b_i1		equ	$2284	; Blitter Intensity 1
b_i0		equ	$2288	; Blitter Intensity 0

b_z3		equ	$228C	; Blitter Z 3
b_z2		equ	$2290	; Blitter Z 2
b_z1		equ	$2294	; Blitter Z 1
b_z0		equ	$2298	; Blitter Z 0

;*======================================================================*
;* BLITTER Command Register equates					*
;*======================================================================*

SRCEN		EQU	$00000001	; d00:     source data read (inner loop)
SRCENZ		EQU	$00000002	; d01:     source Z read (inner loop)
SRCENX		EQU	$00000004	; d02:     source data read (realign)
DSTEN		EQU	$00000008	; d03:     destination data read (inner loop)
DSTENZ		EQU	$00000010	; d04:     destination Z read (inner loop)
DSTWRZ		EQU	$00000020	; d05:     destination Z write (inner loop)
CLIP_A1		EQU	$00000040	; d06:     A1 clipping enable
NOGO		EQU	$00000080	; d07:     diagnostic
UPDA1F		EQU	$00000100	; d08:     A1 update step fraction
UPDA1		EQU	$00000200	; d09:     A1 update step
UPDA2		EQU	$00000400	; d10:     A2 update step
DSTA2		EQU	$00000800	; d11:     reverse usage of A1 and A2
GOURD		EQU	$00001000	; d12:     enable Gouraud shading
ZBUFF		EQU	$00002000	; d13:     polygon Z data updates
TOPBEN		EQU	$00004000	; d14:     intensity carry into byte
TOPNEN		EQU	$00008000	; d15:     intensity carry into nibble
PATDSEL		EQU	$00010000	; d16:     Select pattern data
ADDDSEL		EQU	$00020000	; d17:     diagnostic
					; d18-d20: Z comparator inhibit
ZMODELT		EQU	$00040000	; 	     source < destination
ZMODEEQ		EQU	$00080000	;	     source = destination
ZMODEGT		EQU	$00100000	;	     source > destination
					; d21-d24: Logic function control
LFU_NAN		EQU	$00200000	; 	     !source & !destination
LFU_NA		EQU	$00400000	; 	     !source &  destination
LFU_AN		EQU	$00800000	; 	      source & !destination
LFU_A		EQU	$01000000	; 	      source &  destination

; The following are ALL 16 possible logical operations of the LFUs

LFU_ZERO	EQU	$00000000	; All Zeros
LFU_NSAND	EQU	$00200000	; NOT Source AND NOT Destination
LFU_NSAD	EQU	$00400000	; NOT Source AND Destination
LFU_NOTS	EQU	$00600000	; NOT Source
LFU_SAND	EQU	$00800000	; Source AND NOT Destination
LFU_NOTD	EQU	$00A00000	; NOT Destination
LFU_N_SXORD	EQU	$00C00000	; NOT (Source XOR Destination)
LFU_NSORND	EQU	$00E00000	; NOT Source OR NOT Destination
LFU_SAD		EQU	$01000000	; Source AND Destination
LFU_SXORD	EQU	$01200000	; Source XOR Destination
LFU_D		EQU	$01400000	; Destination
LFU_NSORD	EQU	$01600000	; NOT Source OR Destination
LFU_S		EQU	$01800000	; Source
LFU_SORND	EQU	$01A00000	; Source OR NOT Destination
LFU_SORD	EQU	$01C00000	; Source OR Destination
LFU_ONE		EQU	$01E00000	; All Ones

; These are some common combinations with less boolean names

LFU_REPLACE	EQU	$01800000	; Source REPLACEs destination
LFU_XOR		EQU	$01200000	; Source XOR with destination
LFU_CLEAR	EQU	$00000000	; CLEAR destination

CMPDST		EQU	$02000000	; d25:     pixel compare pattern & dest
BCOMPEN		EQU	$04000000	; d26:     bit compare write inhibit
DCOMPEN		EQU	$08000000	; d27:     data compare write inhibit
BKGWREN		EQU	$10000000	; d28:     data write back

;*======================================================================*
;* BLITTER Flags (A1 or A2) register equates
;*======================================================================*

; Pitch d00-d01:
;	distance between pixel phrases
PITCH1		EQU	$00000000	; 0 phrase gap
PITCH2		EQU	$00000001	; 1 phrase gap
PITCH4		EQU	$00000002	; 3 phrase gap
PITCH8		EQU	$00000003	; 7 phrase gap

; Pixel d03-d05
;	bit depth (2^n)
PIXEL1		EQU	$00000000	; n = 0	0 color
PIXEL2		EQU	$00000008	; n = 1	2 colors
PIXEL4		EQU	$00000010	; n = 2	4 colors 
PIXEL8		EQU	$00000018	; n = 3	8 colors
PIXEL16		EQU	$00000020	; n = 4	16 colors
PIXEL32		EQU	$00000028	; n = 5	32 colors

; Z offset d06-d08
;	offset from phrase of pixel data from its corresponding
;	Z data phrases
ZOFFS0		EQU	$00000000	; offset = 0	UNUSED
ZOFFS1		EQU	$00000040	; offset = 1
ZOFFS2		EQU	$00000080	; offset = 2
ZOFFS3		EQU	$000000C0	; offset = 3
ZOFFS4		EQU	$00000100	; offset = 4
ZOFFS5		EQU	$00000140	; offset = 5
ZOFFS6		EQU	$00000180	; offset = 6
ZOFFS7		EQU	$000001C0	; offset = 7	UNUSED

; Width d09-d14
;	width used for address generation
;	This is a 6-bit floating point value in pixels
;	4-bit unsigned exponent
;	2-bit mantissa with implied 3rd bit of 1
WID2		EQU	$00000800	; 1.00 X 2^1  ( 4<<9)
WID4 		EQU	$00001000	; 1.00 X 2^2  ( 8<<9)
WID6		EQU	$00001400	; 1.10 X 2^2  (10<<9)
WID8		EQU	$00001800	; 1.00 x 2^3  (12<<9)
WID10		EQU	$00001A00	; 1.01 X 2^3  (13<<9)
WID12		EQU	$00001C00	; 1.10 X 2^3  (14<<9)
WID14		EQU	$00001E00	; 1.11 X 2^3  (15<<9)
WID16		EQU	$00002000	; 1.00 X 2^4  (16<<9)
WID20		EQU	$00002200	; 1.01 X 2^4  (17<<9)
WID24		EQU	$00002400	; 1.10 X 2^4  (18<<9)
WID28		EQU	$00002600	; 1.11 X 2^4  (19<<9)
WID32		EQU	$00002800	; 1.00 X 2^5  (20<<9)
WID40		EQU	$00002A00	; 1.01 X 2^5  (21<<9)
WID48		EQU	$00002C00	; 1.10 X 2^5  (22<<9)
WID56		EQU	$00002E00	; 1.11 X 2^5  (23<<9)
WID64		EQU	$00003000	; 1.00 X 2^6  (24<<9)
WID80		EQU	$00003200	; 1.01 X 2^6  (25<<9)
WID96		EQU	$00003400	; 1.10 X 2^6  (26<<9)
WID112		EQU	$00003600	; 1.11 X 2^6  (27<<9)
WID128		EQU	$00003800	; 1.00 X 2^7  (28<<9)
WID160		EQU	$00003A00	; 1.01 X 2^7  (29<<9)
WID192		EQU	$00003C00	; 1.10 X 2^7  (30<<9)
WID224		EQU	$00003E00	; 1.11 X 2^7  (31<<9)
WID256		EQU	$00004000	; 1.00 X 2^8  (32<<9)
WID320		EQU	$00004200	; 1.01 X 2^8  (33<<9)
WID384		EQU	$00004400	; 1.10 X 2^8  (34<<9)
WID448		EQU	$00004600	; 1.11 X 2^8  (35<<9)
WID512		EQU	$00004800	; 1.00 X 2^9  (36<<9)
WID640		EQU	$00004A00	; 1.01 X 2^9  (37<<9)
WID768		EQU	$00004C00	; 1.10 X 2^9  (38<<9)
WID896		EQU	$00004E00	; 1.11 X 2^9  (39<<9)
WID1024		EQU	$00005000	; 1.00 X 2^10 (40<<9)
WID1280		EQU	$00005200	; 1.01 X 2^10 (41<<9)
WID1536		EQU	$00005400	; 1.10 X 2^10 (42<<9)
WID1792		EQU	$00005600	; 1.11 X 2^10 (43<<9)
WID2048		EQU	$00005800	; 1.00 X 2^11 (44<<9)
WID2560		EQU	$00005A00	; 1.01 X 2^11 (45<<9)
WID3072		EQU	$00005C00	; 1.10 X 2^11 (46<<9)
WID3584		EQU	$00005E00	; 1.11 X 2^11 (47<<9)

; X add control d16-d17
;	controls the update of the X pointer on each pass
;	round the inner loop
XADDPHR		EQU	$00000000	; 00 - add phrase width and truncate
XADDPIX		EQU	$00010000	; 01 - add pixel size (add 1)	
XADD0		EQU	$00020000	; 10 - add zero
XADDINC		EQU	$00030000	; 11 - add the increment

; Y add control	d18
;	controls the update of the Y pointer within the inner loop.
;	it is overridden by the X add control if they are in add increment
YADD0		EQU	$00000000	; 00 - add zero
YADD1		EQU	$00040000	; 01 - add 1

; X sign d19
;	add or subtract pixel size if X add control = 01 (XADDPIX)
XSIGNADD	EQU	$00000000	; 0 - add pixel size
XSIGNSUB	EQU	$00080000	; 1 - subtract pixel size

; X sign d20
;	add or subtract pixel size if X add control = 01 (YADD1)
YSIGNADD	EQU	$00000000	; 0 - add 1
YSIGNSUB	EQU	$00100000	; 1 - sub 1

;*======================================================================*
;*	GLOBAL VARIABLES						*
;*======================================================================*
