	.nlist
	.include	"jaguar.inc"
	.include	"cd.inc"
	.list
;
;
;
; Butch's hardware registers
;
;
BUTCH     equ  $DFFF00		;base of Butch=interrupt control register, R/W
;
;  When written (Long):
;
;  bit0 - set to enable interrupts
;  bit1 - enable CD data FIFO half full interrupt
;  bit2 - enable CD subcode frame-time interrupt (@ 2x spped = 7ms.)
;  bit3 - enable pre-set subcode time-match found interrupt
;  bit4 - CD module command transmit buffer empty interrupt
;  bit5 - CD module command receive buffer full
;  bit6 - CIRC failure interrupt
;
;  bit7-31  reserved, set to 0 
;
;
;  When read (Long):
;
;  bit0-8 reserved
;
;  bit9  - CD data FIFO half-full flag pending
;  bit10 - Frame pending
;  bit11 - Subcode data pending
;  bit12 - Command to CD drive pending (trans buffer empty if 1)
;  bit13 - Response from CD drive pending (rec buffer full if 1)
;  bit14 - CD uncorrectable data error pending
;
;
;   Offsets from BUTCH
;
DSCNTRL   equ  4		; DSA control register, R/W
DS_DATA   equ  $A		; DSA TX/RX data, R/W
;
;
;
I2CNTRL   equ  $10		; i2s bus control register, R/W
;
;  When read:
;
;  b0 - I2S data from drive is ON if 1
;  b1 - I2S path to Jerry is ON if 1
;  b2 - reserved
;  b3 - host bus width is 16 if 1, else 32
;  b4 - FIFO state is not empty if 1
;
;
;
;
SBCNTRL   equ  $14		; CD subcode control register, R/W
SUBDATA   equ  $18		; Subcode data register A
SUBDATB   equ  $1C		; Subcode data register B
SB_TIME   equ  $20		; Subcode time and compare enable (D24)
FIFODAT   equ  $24		; i2s FIFO data
I2SDAT2   equ  $28		; i2s FIFO data (old)
;
;
;
;
CDtoc	equ	$2c00			;CD Table o Contents base addr
Keysize	equ	65+3
;
dlist	equ	$4000
image	equ	$4040
;
;
sessrow	equ	2
sesscol	equ	8
;
;
;   GPU enRSA program locations..
;
a_num	equ	G_RAM
b_num	equ	a_num+68
c_num	equ	b_num+68
n_num	equ	c_num+68
m_coe	equ	n_num+68
dramin	equ	m_coe+4
dramine	equ	dramin+4
dramout	equ	dramine+4
;
;
;
;
start:
	lea	$200000,sp		;set stack at top of memory
	move.w	#$100,JOY1		;unmute
;
; the following is test code
;
	lea	postmark,a0
	moveq	#0,d0
	move.w	#$7fff,d1
clrfine:
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	move.l	d0,(a0)+		;clear out all bufs
	dbra	d1,clrfine
;
	move.l	#butchbuf,butchptr
	move.l	#intbuf,intbufpt
;
	move.l	#FileST,rsabeg
	move.l	#FileST+156192,rsaend
;
;
;***********************************
;  start-up our fake video
;
	lea	dlistROM,a0
	lea	dlist,a1
	moveq	#15,d0
getlist:
	move.l	(a0)+,(a1)+
	dbra	d0,getlist		;copy ROM display list to ram
;
;
	lea	image,a0
	moveq	#0,d0
	move.w	#12*240-1,d1
clearimg:
	move.l	d0,(a0)+
	dbra	d1,clearimg
;
	clr.l	fcount

	move.l	#Frame,$100
	move.l	#dlist,d0
	swap	d0
	move.l	d0,OLP			;stop object is here
;
	moveq	#0,d0
	move.l	d0,BORD1
	move.w	d0,BG
	move.w	#-1,VDE
;
	move.w	#$101,INT1
;
	move.w	#$4c7,VMODE
;
;		  RRRRRBBBBBGGGGGG
	move.w	#%0000001111000000,CLUT		;blue
	move.w	#%0111101111011111,CLUT+2
;

	move.w	#%0000001111000000,BG		;blue
;
	lea	signon,a0
	moveq	#sessrow,d0
	moveq	#sesscol,d1
	bsr	stringii		;save in internal ram
	bsr	string
;
;******************************************

	lea	$3000,a0
	lea	cdbios,a1
	move.w	#$3ff,d0
copbios:
	move.l	(a1)+,(a0)+
	dbra	d0,copbios
;
	jsr	CD_setup
	move.w	#3,d0
	jsr	CD_mode
;
DSP_w:
	move.l	D_CTRL,d0
	lsr.l	#1,d0
	bcs	DSP_w
;
	moveq	#0,d0
	move.w	#255,d1
	lea	privy,a0
zeropriv:
	move.l	d0,(a0)+
	dbra	d1,zeropriv
;
	lea	priat,a0
	lea	privat,a1
	move.w	#68-1,d0
rampriv:
	move.w	(a0)+,(a1)+
	dbra	d0,rampriv
;
	lea	getpriv,a0
	moveq	#sessrow+4,d0
	moveq	#sesscol,d1
	bsr	string
;
	lea	privy,a0
	lea	resume(pc),a1
	illegal
;
resume:
;
;   Convert dc.b into binary
;
	lea	privy,a0
	lea	privat+3,a1
privlp:
	move.b	(a0)+,d0
	beq.s	privdone
	cmpi.b	#"$",d0
	bne.s	privlp		;wait for "$"
	moveq	#1,d1
	moveq	#0,d2
twonib:
	lsl.w	#4,d2
	move.b	(a0)+,d0
	subi.b	#"0",d0
	cmpi.b	#10,d0
	bcs.s	gotnib
	subi.b	#7,d0
	cmpi.b	#16,d0
	bcs.s	gotnib
	subi.b	#$20,d0
gotnib:
	or.b	d0,d2
	dbra	d1,twonib
	move.b	d2,(a1)+
	bra	privlp		
privdone:
;
;
; Load, & initialize DSP "gettoc" program
;
DoDSP:
	move.l	#DSP_S,a0
	move.l	#DSP_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#D_RAM,a1
x4loop:
	move.l	(a0)+,(a1)+
        dbra    d0,x4loop
;
	move.l	#D_RAM,D_PC	; Set GPU PC to start of code in SRAM
;
	move.l	#1,D_CTRL	; start GPU
;
	lea	getcdtoc,a0
	moveq	#sessrow+4,d0
	moveq	#sesscol,d1
	bsr	string
;
;
	lea	D_RAM,a0
dwait:
	move.l	(a0),d0		;wait til dsp stuffs 0 here
	bne	dwait
;
	tst.l	BUTCH+I2CNTRL	;clear any error
;
	lea	CDtoc,a1
	move.l	(a1)+,d5	;check for "Disc not present or timeout
	bpl	notTO
;
;  Error condition detected...
;
;  d5.l = $FFFF0000 if time-out (format may be CD-I or other un-recognized)
;	= $FFFFFFFF if disc not present (status = $402 lid closed, no disc)
;
	lea	badisc,a0
	bra	errexit

notTO:
;
;  Inform user of Directory status...
;
	lea	CDtoc,a0
	move.l	(a0)+,d0
	andi.w	#$ff,d0			;last track
	moveq	#0,d2			;init scan track
scantrk:
	addq	#1,d2
	cmp.b	d0,d2
	bcc	notenuf		;exit if not enough tracks to scan 
	addq.l	#8,a0
	move.l	(a0),d1
	rol.l	#8,d1
	cmpi.b	#1,d1			;session #1?
	bne	scantrk
	bra.s	sendst
notenuf:
	lea	trknot,a0
	bra	errexit
;
;
sendst:
;
;  d2.w = 1st track to encrypt
;  d0.w = Last +1 to encrypt
;
	subq.w	#1,d0
	move.w	d2,d3
	move.w	d0,d4		;save start-end track #
;
	lea	statmsg,a0
	lea	statm,a1
copstat:
	move.b	(a1)+,(a0)+
	bne	copstat
;
	lea	statmsg+13,a0
	moveq	#1,d1
statclp:
	andi.l	#$ff,d2
	divu	#10,d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	swap	d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	addq.l	#1,a0
	move.w	d0,d2
	dbra	d1,statclp
;
;  Compute total CD time
;
	lsl.w	#3,d3			;start track
	lsl.w	#3,d4			;end track
	lea	CDtoc+4,a0		;Now, sum the times
	move.l	a0,a1
	adda.w	d3,a0
	adda.w	d4,a1

	moveq	#0,d0			;init sum
	subq.l	#8,a0
sumloop:
	addq.l	#8,a0
	move.l	(a0),d1
	andi.l	#$ffffff,d1		;strip session
;
	add.b	d1,d0			;advance our time by frame increment
	cmp.b	#75,d0			;d3= 00 Am As Af
	bcs.s	frok
	sub.b	#75,d0	
	ori	#$10,ccr		;set x
frok:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = Af 00 Am As
	addx.b	d1,d0
	cmp.b	#60,d0
	bcs.s	secok
	sub.b	#60,d0
	ori	#$10,ccr		;set x
secok:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = As Af 00 Am
	addx.b	d1,d0
	swap	d0			;d0 = 00 M S F
	cmp.l	a1,a0
	bcs	sumloop
;
;  d0 = 00 MM SS FF
;
	moveq	#0,d1
	addi.b	#37,d0			;round off frames
	cmpi.b	#75,d0
	bcs.s	noround
	addq	#1,d1
noround:
	lsr.l	#8,d0
	add.b	d1,d0
	cmpi.b	#60,d0
	bcs.s	norowr
	subi.b	#60,d0
	addi.w	#$100,d0
norowr:
	lea	statmsg+33,a0
	move.l	d0,d2
	lsr.w	#8,d2			;minutes
;
	moveq	#1,d1
timlp:
	andi.l	#$ff,d2
	divu	#10,d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	swap	d2
	addi.b	#"0",d2
	move.b	d2,(a0)+
	addq.l	#1,a0
	move.w	d0,d2
	dbra	d1,timlp
;
	lea	statmsg,a0
	moveq	#sessrow+4,d0		;put out TOC status
	moveq	#sesscol-4,d1
	bsr	stringii
	bsr	string
;
	lea	headmsg,a0
	moveq	#sessrow+6,d0		;put out header line
	moveq	#sesscol-4,d1
	bsr	stringi
	bsr	string
;
	lea	headmsg1,a0
	moveq	#sessrow+7,d0		;with underline
	moveq	#sesscol-4,d1
	bsr	stringi
	bsr	string
;
;
;  Form Header & Tailer
;
	moveq	#$7f,d2
	lea	CDtoc,a0
	and.l	(a0)+,d2
sess1f:
	addq.l	#8,a0
	btst.b	#0,(a0)
	beq	sess1f
;
	move.l	-(a0),d3
	rol.l	#8,d3
	sub.b	d3,d2
	move.b	d2,d3
	addi.b	#" ",d3

	lea	FileST,a0
	move.l	#"ATRI",d0
	moveq	#15,d1
headcp:
	move.l	d0,(a0)+
	dbra	d1,headcp
;
	lea	headstr,a1
	moveq	#7,d1
headcp1:
	move.l	(a1)+,(a0)+
	dbra	d1,headcp1
	move.b	d3,-1(a0)	;stuff rel track
;
	move.w	#$26160/4-1,d1
	move.l	#$C00DADE0,d0
filler:
	move.l	d0,(a0)+
	dbra	d1,filler
;
	moveq	#7,d1
tailcp1:
	move.l	(a1)+,(a0)+
	dbra	d1,tailcp1
	move.b	d3,-1(a0)
;
	move.l	#"ATRI",d0
	moveq	#15,d1
tailcp:
	move.l	d0,(a0)+
	dbra	d1,tailcp
	bra	Do_GPU
;
;
;		 10987654321098765432109876543210
headstr:
	dc.b	"ATARI APPROVED DATA HEADER ATRI "
tailstr:
	dc.b	"ATARI APPROVED DATA TAILER ATRI "
;
;
;  Load GPU program for background RSA computation...
;
;
Do_GPU:
	move.l	#ENRSA_S,a0
	move.l	#ENRSA_E,a1
;
	move.l	a1,d0
	sub.l	a0,d0		; Size in bytes
	addq.l	#3,d0
	asr.l	#2,d0
	move.l	#enRstart,a1
	move.l	a1,d1
	bra.s	xferlpi
xferloop:
	move.l	(a0)+,(a1)+
xferlpi:
        dbra    d0,xferloop
;
	lea	privat,a0
	lea	c_num,a1
	move.w	#Keysize/2-1,d0
keyzin:
	move.l	(a0)+,(a1)+
	dbra	d0,keyzin
;
	move.l	-(a0),d0
	andi.w	#$ff,d0
	lea	coeftab,a0
	move.b	(a0,d0.w),d0
	ext.l	d0
	lea	m_coe,a0
	move.l	d0,(a0)+	;set montgomery coeffiecient
;
	move.l	#resultF+65,dramout
;
	move.l	#enRstart,G_PC
	move.l	#1,G_CTRL	;start it up
;
	lea	RSAsemi,a0
semwait:
	move.l	(a0),d0
	beq	semwait		;wait til semiphore is ready
;
;  Ok, she's ready...
;
;   Now erase any trace of Private key in dRAM
;
	lea	privy,a0
	lea	publicK,a1
	moveq	#0,d0
eraslp:
	move.l	d0,(a0)+
	cmp.l	a1,a0
	bcs	eraslp	
;
;
;
;
DSP_wait:
	move.l	D_CTRL,d0
	lsr.l	#1,d0
	bcs	DSP_wait
;
	lea	finehash,a0
	moveq	#0,d0
	moveq	#6,d1
firsthas:
	move.l	d0,(a0)+
	dbra	d1,firsthas
;
	move.l	a0,curfine		;set up output ptr
	move.l	#finehash+$40,currsa	;set up for RSA operation
;
	bsr	MD5toc		;compute hash for TOC
	lea	finehash+12,a0
	movem.l	d0-d3,(a0)	;save in finehash
;
;
; Load, & initialize DSP program
;
Do_DSP:
	move.l	#ENMD5_S,a0
	move.l	#ENMD5_E,a1
;
	move.l	a0,d1
	move.l	a1,d0
	sub.l	d1,d0		; Size in bytes
	asr.l	#2,d0
	move.l	#D_RAM,a1
xferlp:
	move.l	(a0)+,(a1)+
        dbra    d0,xferlp
;
	move.l	#$14,SMODE
;
	moveq	#1,d0
	jsr	CD_jeri			;send data to Jerry
;
	move.l	#MD5start,D_PC
	move.l	#1,D_CTRL	;start it up
;
;
	clr.l	countRSA
;
;   --------------------------
;  We need to get a track to MD5
;
	lea	CDtoc+8,a0	;start with boot track (1st track on session #1)
findboot:
	move.l	(a0)+,d0
	move.l	(a0)+,d1
	rol.l	#8,d1
	cmpi.b	#1,d1		;session #1
	bne	findboot
;
	subq.l	#8,a0
	move.l	a0,nextrk
;
	moveq	#0,d0
	move.l	d0,BlokT	;clear block total
	move.l	d0,SizeT	;& total size
	move.l	d0,MaxT
	moveq	#-1,d0
	move.l	d0,MinT
;
;  repeat here
;
tracklp:
	move.l	currsa,d0	;get start of next allowed finehash to RSA
	move.l	curfine,d1	;get start of last completed finehash
	sub.l	d0,d1		;any finehash ready for RSA?
	bcs.s	skipRSAe	;br if not
;
	andi.w	#~63,d1		;adjust byte count of span to integer blocks
	tst.l	d1
	beq.s	skipRSAe	;br if less that 1 full block
;
	lea	RSAsemi,a0
	move.l	(a0),d2		;check for busy RSA
	bpl.s	skipRSAe	;skip if RSA is busy
;
	move.l	d0,dramin
	add.l	d1,d0
	move.l	d0,dramine
	moveq	#0,d2
	move.l	d2,(a0)		;start up some more RSA
;
	lsr.l	#6,d1
	move.l	d1,countRSA	;let GPU decrement this for display
	move.l	d0,currsa	;here's where we start next time
skipRSAe:
	move.l	nextrk,a0
	move.l	(a0),d0

	movem.l	a0-a1/d0,-(sp)
;
;  Scroll down any previous data
;
;	lea	image+((sessrow+18)*48*8),a0
;	lea	image+((sessrow+19)*48*8),a1
;	move.w	#12*(8*10)-1,d0
;
	lea	image+((sessrow+25)*48*8),a0
	lea	image+((sessrow+26)*48*8),a1
	move.w	#12*(8*17)-1,d0
scrdwn:
	move.l	-(a0),-(a1)
	dbra	d0,scrdwn
;
	lea	scanmsg,a0
	lea	curmsg,a1
freshmsg:
	move.b	(a0)+,(a1)+		;refresh msg
	bne	freshmsg
;
	lea	curmsg+10,a0
	rol.l	#8,d0
	andi.l	#$ff,d0
	divu	#10,d0
	tst.b	d0
	bne.s	lead0
	move.b	#" ",(a0)+
	bra.s	lead1
lead0:
	addi.b	#"0",d0
	move.b	d0,(a0)+
lead1:
	swap	d0
	addi.b	#"0",d0
	move.b	d0,(a0)+
;	
	lea	curmsg,a0		;put up "Scanning xx" (track #)
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	string
;
	movem.l	(sp)+,a0-a1/d0

	bsr	backup6		;back up d0.l 6 frames
;
	move.l	butchptr,a3
	move.l	d0,(a3)+
	move.l	a3,butchptr

	bset.l	#31,d0
	jsr	CD_read		;go play some hash
;
	jsr	CD_ack
	cmpi.w	#$100,d1	;seek error?
	bne	seeker0		;br if so
;
	tst.l	BUTCH+I2CNTRL	;clear any error
;
	lea	MD5semi,a3
	move.l	#premark,4(a3)	
	move.l	#1,(a3)	;start up pre-hash (potential markers picked)
;
;
;
.check:
	move.l	(a3),d0		;wait til completion
	bpl.s	.check
;
	move.l	BUTCH,d0
	btst.l	#14,d0
	bne	cd_err0		;exit if error
;
	lea	curmsg,a0
	lea	analmsg,a1
getanal:
	move.b	(a1)+,d0
	beq.s	nonanal
	move.b	d0,(a0)+
	bra	getanal
nonanal:
;
;  Convert the potential markers found into legit markers we will use..
;
;  This track's premark has 4-longword records
;
;   +0 marker length (in longs, should be 16)
;   +4 pattern
;   +8 offset from "ATRI" marker at start of track
;   +C unused, reserved
;
;
	move.l	MD5ptr,a2	;get end of list from DSP
	lea	premark,a0	;SRC ptr
	lea	postmark,a1	;DST ptr
;
;  print out # of potential markers found
;
	movem.l	a0/d0-d1,-(sp)
;
	move.l	a2,d0
	sub.l	a0,d0
	lsr.l	#4,d0
	lea	curmsg+13,a6	;start of "Mrk"
	bsr	dec10000	;decimalize for up to 65535
;
	lea	curmsg,a0	;now Analyzing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	string
;
	movem.l	(sp)+,a0/d0-d1
;
	moveq	#0,d0		;starting offset
	move.l	#$20000,d1	;get minimum block size
	moveq	#$10,d3		;get record size
nextmark:
	lea	-8(a0),a3	;point to offset field, & adjust for adda below
;
;  find next mark at least 128k away
;
momark:
	adda.l	d3,a3		;go for next record
	cmp.l	a2,a3		;did we go off the end?
	bcc.s	markoff		;br if so (we put this in as last one)
	move.l	(a3),d2		;get next offset
	sub.l	d0,d2
	cmp.l	d1,d2		;at least 128k further along?
	bcs	momark		;br if not
;
;  we found one at least 128k further along
;
	lea	-8(a3),a4	;go to start of record (marker size in longs)
	moveq	#$10,d2
	cmp.l	(a4),d2		;are we exactly the right size?
	bne	momark		;br if not--we can't use this one
;
;  now, check this patterns' use over previous 128k
;
	move.l	4(a4),d2	;fetch pattern for putative sync mark 
	move.l	8(a4),d4	; and offset too

	move.l	a4,a5		;start checking up to 128k or at previous
patchk:
	suba.l	d3,a5
	cmp.l	a0,a5		;backed up too far?
	bcs.s	goopat		;br if so--this one will be ok
	move.l	d4,d5		;get putative offset
	sub.l	8(a5),d5	;check for 128k or less
	cmp.l	d1,d5
	bcc.s	goopat		;br if >128k
	cmp.l	4(a5),d2	;are we same pattern?
	beq	momark		;br if same pattern found within 128k
	bra	patchk

;
;  a4 -> next pattern we do
;
goopat:
	addq.l	#4,a4		;skip pat length
	move.l	(a4)+,(a1)+	;set terminating pattern
	addq.l	#8,a4
;
	moveq	#63,d5
	add.l	d4,d5
	sub.l	d0,d5
	lsr.l	#6,d5		;this is our block count
;
	move.l	d5,(a1)+	;save block count
;
	lsl.l	#6,d5
	add.l	d0,d5		;offset where hashing ends
;
	moveq	#64,d6
	add.l	d4,d6		;d6 = next begining offset

	move.l	d0,(a1)+	;save start offset	

	move.l	d6,d0		;save next one
;
	sub.l	d5,d6		;skip count (0..64)
	move.l	d6,(a1)+	;save
;
	move.l	a4,a0
	cmp.l	a2,a0		;did we go off the end?
	bcs	nextmark
	bra.s	markdon
;
;  set last one
;
markoff:
	lea	-$18(a3),a4
	move.l	8(a4),d4	;get offset for last sync mark
	bra	goopat
;
;
;  We finished pass 1, now we know which partition markers to use..
;
;  Records in postmark should look like..
; 
;   +0 Terminating pattern
;   +4 Block (64 bytes each) count
;   +8 Absolute starting offset
;   +C Left over offset to skip for next 
;
markdon:
;
; now compute # of blocks, Min/Max block size and total length
;
	moveq	#0,d0		;max
	moveq	#-1,d1		;min
	moveq	#0,d3		;count
	move.l	#"ATRI",d2	;terminating pattern
	lea	postmark-16,a0	;
;
markchk:
	adda.w	#16,a0
	move.l	4(a0),d4	;get size (in $40 byte blocks)
	cmp.l	d4,d0
	bcc.s	notmax
	move.l	d4,d0
notmax:
	cmp.l	d1,d4
	bcc.s	notmin
	move.l	d4,d1
notmin:
	addq.w	#1,d3
	cmp.l	(a0),d2
	bne	markchk
	subq.l	#8,a2
	move.l	(a2),d4		;get length til terminator
;
	move.w	d3,trakblk	;save total # of blocks, this track
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
	cmp.l	MaxT,d0
	bcs.s	notnmax
	move.l	d0,MaxT		;new global max
notnmax:
	cmp.l	MinT,d1
	bcc.s	notnmin
	move.l	d1,MinT		;new global min
notnmin:
	andi.l	#$ffff,d3
	add.l	d3,BlokT
	add.l	d4,SizeT
;
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
	bsr	stuffval	;stuff values on current line
;
	move.l	nextrk,a0	;retry the same track
	move.l	#(2*75),d3	;2 seconds of adjust (if not end of session)

	move.l	4(a0),d0
	move.l	12(a0),d1
	rol.l	#8,d0
	rol.l	#8,d1
	cmp.b	d1,d0		;next track in same session?
	beq.s	check		;br if so
	moveq	#0,d3		;else, adjustment already in
check:
	move.l	4(a0),d0	;get what directory sez is the file size
	move.l	d0,d1
	swap	d1
	andi.w	#$ff,d1
	mulu	#4500,d1
	moveq	#0,d2
	move.b	d0,d2
	add.l	d2,d1
	lsr.w	#8,d0
	mulu	#75,d0
	add.l	d0,d1		;d1=# of frames in trk, according to directory
	sub.l	d3,d1		;subtract 2 seconds worth (if necessary)
	move.w	d1,d0
	mulu	#2352,d0
	swap	d1
	mulu	#2352,d1
	swap	d1
	add.l	d1,d0		;d0 = # of bytes, according to directory
;
	move.b	#"+",d1		;assume measured is greater
	cmp.l	d4,d0		;which is greater, TOC or measured?
	bcc.s	tocgrat		;br if TOC is greater
;
	sub.l	d0,d4
	move.l	d4,d0
	bra.s	absmag	
tocgrat:
	move.b	#"-",d1
	sub.l	d4,d0		;see how much more we got than indicated
absmag:
	cmpi.l	#(10*2352),d0	;if differs by more than 10 frames, put up +/-
	bcs.s	nostar
;
	move.b	d1,curmsg+43
nostar:
;
;  Tell user what's happenin
;
	lea	curmsg,a0
	lea	md5msg,a1
getmd5:
	move.b	(a1)+,d0
	beq.s	nonmd5
	move.b	d0,(a0)+
	bra	getmd5
nonmd5:
;
;  Put in # of Blocks, Min/Max and Size
;
	lea	curmsg,a0		;"MD5ing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	string
;
;
	move.l	#postmark,a0
	move.l	a0,md5src
	move.l	#prehash,md5dst
	move.w	trakblk,d0
	andi.l	#$ffff,d0
	lsl.l	#4,d0
	add.l	d0,a0
	move.l	a0,srcend	;save ptr to end of md5src
;
	move.l	#"ATRI",md5sync
	clr.l	trakoff		;we start at track byte offset 0
;
;
;  check for postmark buffer limit (8 records for test)
;
jerrymax	equ	256	;350 is probably realistic
;
backtrak:
;
;  adjust offset(s) for track byte offset
;
	lea	postmark+8,a0	;start with offset field in md5src
	move.l	srcend,a3	;end ptr (do all just for simplicity)
	move.l	trakoff,d0
	moveq	#16,d1
readj0:
	sub.l	d0,(a0)
	add.l	d1,a0
	cmp.l	a3,a0
	bcs	readj0
;
;  We're offset adjusted, so now do the same for time code...
;
;   convert byte offset to time code
;
	moveq	#-1,d1
	move.l	#2352*60*75,d2	;subtract out minutes
minloop:
	addq.w	#1,d1
	sub.l	d2,d0
	bcc	minloop
	add.l	d2,d0
	swap	d1		;minutes -> [23:16]
;
	move.w	#-1,d1
	move.l	#2352*75,d2	;now do seconds
secloop:
	addq.w	#1,d1
	sub.l	d2,d0
	bcc	secloop
	add.l	d2,d0
	lsl.w	#8,d1		;seconds -> [15:08]
;
	lsr.l	#4,d0
	divu	#588,d0		;d0= frames
	move.b	d0,d1
;
;  d1 = 00mmssff equivalentof offset
;
;
	move.l	nextrk,a0	;retry the same track
	move.l	(a0),d0		;get start time, this track for MD5
	andi.l	#$ffffff,d0
;
;  now add time offset
;
;
	add.b	d1,d0			;advance our time by frame increment
	cmp.b	#75,d0			;d3= 00 Am As Af
	bcs.s	frokx
	sub.b	#75,d0	
	ori	#$10,ccr		;set x
frokx:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = Af 00 Am As
	addx.b	d1,d0
	cmp.b	#60,d0
	bcs.s	secokx
	sub.b	#60,d0
	ori	#$10,ccr		;set x
secokx:
	ror.l	#8,d0
	ror.l	#8,d1			;d1 = As Af 00 Am
	addx.b	d1,d0
	swap	d0			;d0 = 00 M S F
;
	move.l	d0,md5time
;
	move.w	trakblk,d0
	cmpi.w	#jerrymax,d0		;exceed max for po' Jerry?
	bls.s	bcntok			;br if block count is ok
	move.w	#jerrymax,d0
bcntok:
	sub.w	d0,trakblk
	move.w	d0,trakchnk	;save # of records processed this time
;
	andi.l	#$ffff,d0
	cmpi.w	#2,d0
	bcs.s	bcntk
	subq.w	#1,d0
bcntk:
	lsl.l	#4,d0
	move.l	md5src,a3
	move.l	(a3,d0.l),resync	;save next sync mark
	clr.l	(a3,d0.l)	;put in terminator
;
	move.l	md5time,d0
	bsr	backup6		;back up d0.l 6 frames
;
	move.l	butchptr,a3
	move.l	d0,(a3)+
	move.l	a3,butchptr
;
	bset.l	#31,d0
	jsr	CD_read		;go play some hash
;
	jsr	CD_ack
	cmpi.w	#$100,d1
	bne	seeker1		;br to exit if seek error
;
	tst.l	BUTCH+I2CNTRL	;clear any error
;
	lea	MD5semi,a3
	move.l	md5dst,4(a3)	;dst
	move.l	md5src,8(a3)	;src
	move.l	md5sync,12(a3)	;sync mark
	move.l	#0,(a3)	;start up pre-hash (potential markers picked)
;
;
;
;
.check:
	move.l	(a3),d0		;wait til completion
	bpl.s	.check
;
	move.l	BUTCH,d0
	btst.l	#14,d0
	bne	cd_err1
;
;  restore adjusted offset(s)
;
	lea	postmark+8,a0	;start with offset field in md5src
	move.l	srcend,a3	;end ptr (do all just for simplicity)
	move.l	trakoff,d0
	moveq	#16,d1
readj:
	add.l	d0,(a0)
	add.l	d1,a0
	cmp.l	a3,a0
	bcs	readj
;
;
;
bon:
	move.l	md5src,a3
	move.w	trakchnk,d0	;# blocks processed, this pass
	andi.l	#$ffff,d0
	cmpi.w	#2,d0
	bcs.s	bcntk1
	subq.w	#1,d0
bcntk1:
	lsl.l	#4,d0
	add.l	d0,a3
	move.l	resync,d1
	move.l	d1,(a3)		;replace the sync mark we stomped
	move.l	d1,md5sync	;stuff here, just in case
	adda.w	#16,a3
	move.l	a3,md5src	;advance ptr
;
	move.l	8(a3),trakoff	;get next trak offset (in case needed)
;
	move.l	md5dst,a3
	add.l	d0,a3
	adda.w	#16,a3
	move.l	a3,md5dst	;advance dst ptr too
;
;  check trakblk for any postmark block records remaining...
;
bonbon:	
	tst.w	trakblk
	bne	backtrak
;
;		
;
;
;  we use postmark and prehash tables to generate final finehash
;
;   postmark
;
;   +0 - terminating pattern
;   +4 - block count
;   +8 - start absolute offset (from just after 16 x "ATRI")
;   +C - amount to skip before next (not used)
;
;   prehash is 4 longs corresponding to the postmark table of hash
;
;  Now, put some polish to it
;
;
trkcomp:
	lea	postmark,a0	;get start of generated buffer
	lea	prehash,a1	; & hash table
	move.l	curfine,a2	;take up where we left off
	move.l	nextrk,a3
	move.l	(a3),d5		;get track's start time
	andi.l	#$ffffff,d5
;
;  Do first one as special case
;
	move.l	d5,(a2)+	;stuff start time (base track time)
	move.l	#"ATRI",(a2)+	; & start pattern (always start with ATRI)
	move.l	4(a0),(a2)+	;set block count
;
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 1
	move.l	(a1)+,(a2)+	;stuff hash 2
	move.l	(a1)+,(a2)+	;stuff hash 3
;
raw2fin:
	move.l	(a0),d6		;get previous pattern
	adda.w	#16,a0		;advance to next raw record
	cmpi.l	#"ATRI",d6	;are we at end
	beq	raw2finx	;br if so
;
	move.l	8(a0),d0	;get starting offset
;
;  convert to ABS time (use track start time)
;
	moveq	#-1,d1		;init minutes count
minsub:
	addq.l	#1,d1
	sub.l	#(60*75*2352),d0
	bcc	minsub
	add.l	#(60*75*2352),d0
;
;  d1 is minutes
;
	moveq	#-1,d2		;init seconds count
secsub:
	addq.l	#1,d2
	sub.l	#(75*2352),d0
	bcc	secsub
	add.l	#(75*2352),d0
;
;  d2 is seconds
;
	divu	#2352,d0
;
;  d0 is frames
;
	add.b	d5,d0		;add frames
	cmpi.b	#75,d0
	bcs.s	fdone
	subi.b	#75,d0
	addq.w	#1,d2		;carry over to seconds
fdone:
	ror.l	#8,d5
	add.b	d5,d2		;add seconds
	cmpi.b	#60,d2
	bcs.s	sdone
	subi.b	#60,d2
	addq.w	#1,d1		;carry over to minutes
sdone:
	ror.l	#8,d5
	add.b	d5,d1
	swap	d5
	swap	d1
	lsl.w	#8,d2
	or.w	d2,d1
	or.b	d0,d1
;
;
	move.l	d1,(a2)+		;set time
	move.l	d6,(a2)+		;set pattern
	move.l	4(a0),(a2)+		;length (64-byte blocks)
;
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	move.l	(a1)+,(a2)+	;stuff hash 0
	bra	raw2fin
raw2finx:
	move.l	a2,curfine

	lea	curmsg,a0
	lea	donmsg,a1
getdon:
	move.b	(a1)+,d0
	beq.s	nondon
	move.b	d0,(a0)+
	bra	getdon
nondon:
	lea	curmsg,a0		;"Done"
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	stringi	
	bsr	string
;
	move.l	nextrk,a0	;advance to next track
	addq.l	#8,a0
	move.l	a0,nextrk
	tst.l	8(a0)		;check if this is last track
	bne	tracklp
;
;
;
;  Scroll down any previous data
;
;	lea	image+((sessrow+18)*48*8),a0
;	lea	image+((sessrow+19)*48*8),a1
;	move.w	#12*(8*10)-1,d0
;
	lea	image+((sessrow+25)*48*8),a0
	lea	image+((sessrow+26)*48*8),a1
	move.w	#12*(8*17)-1,d0

scrdwn1:
	move.l	-(a0),-(a1)
	dbra	d0,scrdwn1
;
;
;
	lea	finehash,a0
	suba.l	a0,a2
	move.l	a2,d0
	divu	#28,d0
	move.w	d0,2(a0)	;save total partition's count
;
	moveq	#0,d0
	jsr	CD_jeri		;turn off Jerry data
;
	lea	rsamsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	string
;
	move.w	#$200,$dfff0a
;
	move.l	#2,MD5semi		;shut off DSP
;
;  finish any RSA that needs doin..
;
	move.l	currsa,d0	;get start of next allowed finehash to RSA
	move.l	curfine,d1	;get start of last completed finehash
	sub.l	d0,d1		;any finehash ready for RSA?
	bcs.s	sRSAe		;br if not
;
	add.l	#63,d1
	andi.w	#~63,d1		;adjust byte count of span to integer blocks
	tst.l	d1
	beq.s	sRSAe		;br if nothing doing
;
	lea	RSAsemi,a0
;
	move.l	d1,d3
	lsr.l	#6,d3		;# of blocks for next calc
	add.l	d3,countRSA
;
waitR:
	move.l	(a0),d2		;check for busy RSA
	bmi	doneblk		;wait for previous to finish

	movem.l	a0/d0-d1,-(sp)
	bsr	upcount		;put up count of blocks remaining
	movem.l	(sp)+,a0/d0-d1

	bra	waitR

doneblk:
;
	move.l	d0,dramin
	add.l	d0,d1
	move.l	d1,dramine
	moveq	#0,d0
	move.l	d0,(a0)		;start up some more RSA
;
	move.l	d1,currsa	;here's where we start next time
sRSAe:
;
;
waitRx:
	lea	RSAsemi,a0
	move.l	(a0),d2		;check for busy RSA
	bmi.s	onemore
;
	bsr	upcount		;put up count of blocks remaining
;
	bra	waitRx		;wait for previous to finish
onemore:
;
;  Now, lets do the first block that we had to wait all day for...
;
	move.l	dramout,a1	;save our last RSA buffer entry
	move.l	#finehash,dramin
	move.l	#finehash+$40,dramine
	move.l	#resultF,dramout
	moveq	#0,d1
	move.l	d1,(a0)		;do one more
;
waitRy:
	move.l	(a0),d2		;check for busy RSA
	bpl	waitRy		;wait for previous to finish
;
	lea	donemsg,a0
	lea	curmsg,a1
donilp:
	move.b	(a0)+,(a1)+
	bne	donilp
;
	move.l	MaxT,d0
	move.l	MinT,d1
	move.l	BlokT,d3
	move.l	SizeT,d4
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
	bsr	stuffval
	
	lea	curmsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	stringii
	bsr	string
;
	lea	tocmsg,a0
	bsr	stringi
;
	bsr	toci
;
;  Now, erase any trace of private key in GPU
;
	lea	$f03000,a0
	moveq	#0,d0
	move.w	#1023,d1
eras2:
	move.l	d0,(a0)+
	dbra	d1,eras2
;
;
	lea	FileST,a0
	lea	FileEND+$60,a1
	illegal
;
cd_err0:
	lea	cdermsg0,a0
	bra.s	errexit	
cd_err1:
	lea	cdermsg1,a0
	bra.s	errexit	
seeker0:
	lea	seekmsg0,a0
	bra.s	errexit	
seeker1:
	lea	seekmsg1,a0
;  a0-> error message string
;
errexit:
	move.l	a0,-(sp)
	moveq	#sessrow+2,d0
	moveq	#sesscol,d1
	bsr	string
	move.l	(sp)+,a0
;
	move.l	a0,a1
finde:
	tst.b	(a1)+
	bne	finde
	subq.l	#1,a1
	move.b	#13,(a1)+
	move.b	#10,(a1)+
;
	move.l	a0,rsabeg
	move.l	a1,rsaend
	illegal
;
;
;
;  Display countRSA
;
upcount:
	move.l	countRSA,d0	;get counter of blocks
	andi.l	#$ffff,d0
	cmp.w	lastc,d0
	bne.s	upcountx
	rts
upcountx:
	move.w	d0,lastc	;save new value
;
	andi.l	#$ffff,d0
	lea	statmsg,a6
	bsr	dec10000
	addq.l	#1,a6
	clr.b	(a6)
;
	lea	statmsg,a0
	moveq	#sessrow+8,d0
	moveq	#sesscol+24,d1
	bsr	string
	rts
;
;
;  Up to 65535
;
dec10000:
	move.l	d1,-(sp)
	moveq	#0,d1
	swap	d0
	tst.w	d0		;do we have overflo?
	bne.s	decmax
	swap	d0
	divu	#10000,d0
	tst.b	d0
	bne.s	decx0
	move.b	#" ",d0
	bra.s	decx1
decx0:
	moveq	#-1,d1
	addi.b	#"0",d0
decx1:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
	divu	#1000,d0
	tst.b	d0
	bne.s	decx6
	move.b	#" ",d0
	bra.s	decx7
decx6:
	moveq	#-1,d1
	addi.b	#"0",d0
decx7:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
;
	divu	#100,d0
	tst.b	d0
	bne.s	decx2
	tst.l	d1
	bne.s	decx2
	move.b	#" ",d0
	bra.s	decx3
decx2:
	moveq	#-1,d1
	addi.b	#"0",d0
decx3:
	move.b	d0,(a6)+
	clr.w	d0
	swap	d0
	divu	#10,d0
	tst.b	d0
	bne.s	decx4
	tst.l	d1
	bne.s	decx4
	move.b	#" ",d0
	bra.s	decx5
decx4:
	moveq	#-1,d1
	addi.b	#"0",d0
decx5:
	move.b	d0,(a6)+
	swap	d0
	addi.b	#"0",d0
	move.b	d0,(a6)

	move.l	(sp)+,d1
	rts
;
decmax:
	move.b	#" ",(a6)+
	move.b	#">",(a6)+
	move.b	#"6",(a6)+
	move.b	#"4",(a6)+
	move.b	#"k",(a6)
	move.l	(sp)+,d1
	rts
;
;
;  d0 = max block size
;  d1 = min block size
;  d3 = # of blocks
;  d4 = size of track
;
stuffval:
;	addi.l	#$40,d0
;	lsr.l	#7,d0
;	mulu	#10,d0
;	lsr.l	#4,d0
;
	lsr.l	#4,d0
	mulu	#100,d0
	addi.l	#$40,d0		;add 1/2 of a percent for round-off
	lsr.l	#7,d0
	lea	curmsg+29,a6	;start of "Max"
	bsr	dec10000	;decimalize for up to 65535
;
;	addi.l	#$40,d1		;add 1/2 of a 10th for round-off
;	lsr.l	#7,d1
;	mulu	#10,d1
;	lsr.l	#4,d1
;	move.w	d1,d0
;
	move.l	d1,d0
	lsr.l	#4,d0
	mulu	#100,d0
	addi.l	#$40,d0		;add 1/2 of a percent for round-off
	lsr.l	#7,d0
	andi.l	#$ffff,d0
	lea	curmsg+24,a6	;start of "Min"
	bsr	dec10000
;
	move.w	d3,d0
	andi.l	#$ffff,d0
	lea	curmsg+19,a6	;start of "Blok"
	bsr	dec10000
;
	lea	curmsg+35,a6	;start of "size"
	moveq	#7,d1
	moveq	#0,d2
sizelp:
	rol.l	#4,d4		;decode size
	moveq	#$f,d0
	and.w	d4,d0
	bne.s	siz
	tst.l	d2
	bne.s	siz
	tst.w	d1
	beq.s	siz
	move.b	#" ",(a6)+
	bra.s	siz1
siz:
	moveq	#-1,d2
	move.b	hextab(pc,d0.w),(a6)+
siz1:
	dbra	d1,sizelp
	bra.s	ovhexta
hextab:
	dc.b	"0123456789ABCDEF"
ovhexta:
	lea	curmsg,a0	;now Analyzing
	moveq	#sessrow+8,d0
	moveq	#sesscol-4,d1
	bsr	string
	rts
;
;
;-------------------------------------------------
;
; Entry:
;  d0.l = seek time (mm:ss:ff)
;
; Exit:
;  d0.l = 6 frames before seek time
;
backup6:
	andi.l	#$ffffff,d0	;strip track # off [31:24]
;
;	subq.b	#6,d0		;back up 6 frames
	subi.b	#9,d0		;back up 6 frames
	bcc.s	doseek

	addi.b	#75,d0		;adjust for frame underflo
	ror.l	#8,d0		;need to borrow from seconds
	subq.b	#1,d0		;subtract 1 from seconds
	bcc.s	doseek1
;
	addi.b	#60,d0		;adjust for seconds underflo
	ror.l	#8,d0		;need to borrow from minutes
	subq.b	#1,d0		;there better be minutes
	rol.l	#8,d0		; since we don't check min underflo
doseek1:
	rol.l	#8,d0
doseek:
	rts
;
;
;
Frame:
	move.w	#$0101,INT1		;clear CPU interrupt
	move.w	#0,INT2
	movem.l	d0/a0-a1,-(sp)
	lea	dlistROM+32,a0
	lea	dlist+32,a1
	moveq	#3,d0
Flist:
	move.l	(a0)+,(a1)+
	dbra	d0,Flist		;copy ROM display list to ram
;
	addq.l	#1,fcount
;
	.if	0
	lea	$f14000,a0
	move.w	#$81ee,(a0)
	move.l	(a0),d0
	not.l	d0
	move.l	d0,joycur
;
;	.if	0
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81ff,d1
	moveq	#$11,d0
Floop:
	eor.w	d1,d0
	move.w	d0,(a1)		;ask for next row
;
	move.l	(a1),d2
	not.l	d2
	move.l	d2,(a0)+
;
	eor.w	d1,d0
	add.w	d0,d0
	cmpi.w	#$110,d0
	bcs	Floop
;
	.endif
;
	movem.l	(sp)+,d0/a0-a1
;	move.w	#$0101,INT1		;clear CPU interrupt
;	move.w	#0,INT2
rrte:
	rte
;
;
;  d0 - row (0-29)
;  d1 - col (0-47)
;  a0 -> string
;
string:
	movem.l	a1-a4/d0-d3,-(sp)
	lea	font,a1
	lea	image,a2
	mulu	#8*48,d0
	add.l	d0,a2
	adda.w	d1,a2	
	moveq	#0,d0
	move.w	#48,d1
	move.w	#256,d2
strlp:
	move.b	(a0)+,d0
	bne.s	strlp1
	movem.l	(sp)+,a1-a4/d0-d3
	rts
strlp1:
	lea	(a1,d0.w),a3
	move.l	a2,a4
	moveq	#7,d3
strlp2:
	move.b	(a3),(a4)
	adda.w	d1,a4
	adda.w	d2,a3
	dbra	d3,strlp2
	addq.l	#1,a2
	bra	strlp
;
;  Print message to internal buffer
;
stringii:
	movem.l	a0-a1/d0-d1,-(sp)
	moveq	#3,d1			;# of trailing CR desired
	bra.s	stringa
stringi:
	movem.l	a0-a1/d0-d1,-(sp)
	moveq	#1,d1
stringa:
	move.l	intbufpt,a1
stringy:
	move.b	(a0)+,(a1)+
	bne	stringy
	subq.l	#1,a1
	bra.s	strgi
strglp:
	move.b	#13,(a1)+
	move.b	#10,(a1)+
strgi:
	dbra	d1,strglp
	move.l	a1,intbufpt
	movem.l	(sp)+,a0-a1/d0-d1
	rts
;
;   Write TOC to report file
;
toci:
	lea	$2c00,a0
	move.l	intbufpt,a1
	moveq	#$f,d4
toclp:
	moveq	#3,d1
	bra.s	toclp1x
toclp1:
	move.b	#" ",(a1)+
toclp1x:
	move.l	(a0)+,d0
	beq.s	toclpe
	moveq	#7,d2
toclp2:
	rol.l	#4,d0
	move.w	d0,d3
	and.w	d4,d3
	move.b	hext(pc,d3.w),(a1)+
	dbra	d2,toclp2
;
	dbra	d1,toclp1
	move.b	#13,(a1)+
	move.b	#10,(a1)+
	bra	toclp
toclpe:
	move.b	#13,(a1)+
	move.b	#10,(a1)+
	move.l	a1,intbufpt
	rts

hext:
	dc.b	"0123456789ABCDEF"
;
;
;-------------------------------------------------
;	
;
;
;
; d0.l = accum
; d1.l = scratch1
; d2.l = scratch2
; d3.w = index (long aligned) in input buffer (mod 64)
; d4.w = index increment
; d5.w = rotate count index
; d6.w = species (0-futz, 2-grind, 4-hack, 6-ickify)
; 
; a0.l = a
; a1.l = b
; a2.l = cc
; a3.l = d
;
; a4.l = hash table ptr
; a5.l = input buffer ptr (64 bytes)
; a6.l = rotate count table ptr
;
;
;
;
MD5toc:
	lea	initstate(pc),a4
	move.l	(a4)+,a0
	move.l	(a4)+,a1
	move.l	(a4)+,a2
	move.l	(a4)+,a3
;
;
	lea	$2c00,a5	;base addr of CDtoc
;
nextTblk:
	movem.l	a0-a3,-(sp)
;
	lea	hashman(pc),a4	;64-long entry hash table

	lea	rotater(pc),a6	;shift count table ptr
	moveq	#0,d5		;index for above
	moveq	#0,d6		;start with futz
nextspec:
	moveq	#15,d7		;iter 16 times for futz

	move.w	initx(pc,d6),d3	;get initial index into 64-byte input
	move.w	xinc(pc,d6),d4	;& get increment
specloop:
	move.w	spectab(pc,d6.w),d0
	jmp	futz(pc,d0.w)
;
;
initx:
	dc.w	0	;initial index
	dc.w	4
	dc.w	20
	dc.w	0

xinc:
	dc.w	4	;index increment
	dc.w	20
	dc.w	12
	dc.w	28

spectab:
	dc.w	futz-futz
	dc.w	grind-futz	
	dc.w	hack-futz
	dc.w	ickify-futz
	
futz:
;    d0.l = (b & c) | (~b & d)
	move.l	a1,d0	;b -> accum
	move.l	a2,d1	;c -> scratch1
	and.l	d1,d0	;b&c -> accum
	move.l	a1,d1	;b -> scratch1
	move.l	a3,d2	;d -> scratch2
	not.l	d1	;~b
	and.l	d2,d1	;~b&d
	or.l	d1,d0	;OR into result
; end basic futz
	bra.s	endspec
;
;
grind:
;   d0.l = (b & d) | (c & ~d)
	move.l	a1,d0
	move.l	a3,d1
	and.l	d1,d0
	not.l	d1
	move.l	a2,d2
	and.l	d1,d2
	or.l	d2,d0
; end basic grind
	bra.s	endspec
;
hack:
;   d0.l = b ^ c ^ d
	move.l	a3,d0
	move.l	a1,d1
	eor.l	d1,d0
	move.l	a2,d1
	eor.l	d1,d0
; end basic hack
	bra.s	endspec
;
ickify:
;   d0.l = c ^ (b | ~d)
	move.l	a3,d0
	not.l	d0
	move.l	a1,d1
	or.l	d1,d0
	move.l	a2,d1
	eor.l	d1,d0
; end basic ickification

;
endspec:
	add.l	(a5,d3.w),d0	;add next input data entry
;
	add.w	d4,d3		;advance buffer index
	andi.w	#$3f,d3		; mod 64

	add.l	(a4)+,d0	;add next hash table entry
	add.l	a0,d0		;add a
;
	move.w	(a6,d5.w),d1	;get next shift count
	addq.w	#2,d5		;advance shift count index
	andi.w	#7,d5		; mod 8
;
	rol.l	d1,d0		;circular rotate left by count
	add.l	a1,d0		;add b
				;result d0.l is what we should store in a

;
	move.l	a3,a0		;d -> a
	move.l	a2,a3		;cc-> d
	move.l	a1,a2		;b -> cc
	move.l	d0,a1		;new a -> b

	dbra	d7,specloop	;do 16 of these
	addq.l	#8,a6
	addq.l	#2,d6
	cmp.w	#8,d6
	bcs	nextspec
;
	adda.w	#64,a5
;
	movem.l	(sp)+,d0-d3
	add.l	d0,a0
	add.l	d1,a1
	add.l	d2,a2
	add.l	d3,a3
;
	cmp.l	#$3000,a5
	bcs	nextTblk
;
	move.l	a0,d0
	move.l	a1,d1
	move.l	a2,d2
	move.l	a3,d3
	rts
;
;
;
;
;
;
coeftab:
	dc.b $FF,$FF,$55,$55,$33,$33,$49,$49,$C7,$C7,$5D,$5D,$3B,$3B,$11,$11
	dc.b $0F,$0F,$E5,$E5,$C3,$C3,$59,$59,$D7,$D7,$ED,$ED,$CB,$CB,$21,$21
	dc.b $1F,$1F,$75,$75,$53,$53,$69,$69,$E7,$E7,$7D,$7D,$5B,$5B,$31,$31
	dc.b $2F,$2F,$05,$05,$E3,$E3,$79,$79,$F7,$F7,$0D,$0D,$EB,$EB,$41,$41
	dc.b $3F,$3F,$95,$95,$73,$73,$89,$89,$07,$07,$9D,$9D,$7B,$7B,$51,$51
	dc.b $4F,$4F,$25,$25,$03,$03,$99,$99,$17,$17,$2D,$2D,$0B,$0B,$61,$61
	dc.b $5F,$5F,$B5,$B5,$93,$93,$A9,$A9,$27,$27,$BD,$BD,$9B,$9B,$71,$71
	dc.b $6F,$6F,$45,$45,$23,$23,$B9,$B9,$37,$37,$4D,$4D,$2B,$2B,$81,$81
	dc.b $7F,$7F,$D5,$D5,$B3,$B3,$C9,$C9,$47,$47,$DD,$DD,$BB,$BB,$91,$91
	dc.b $8F,$8F,$65,$65,$43,$43,$D9,$D9,$57,$57,$6D,$6D,$4B,$4B,$A1,$A1
	dc.b $9F,$9F,$F5,$F5,$D3,$D3,$E9,$E9,$67,$67,$FD,$FD,$DB,$DB,$B1,$B1
	dc.b $AF,$AF,$85,$85,$63,$63,$F9,$F9,$77,$77,$8D,$8D,$6B,$6B,$C1,$C1
	dc.b $BF,$BF,$15,$15,$F3,$F3,$09,$09,$87,$87,$1D,$1D,$FB,$FB,$D1,$D1
	dc.b $CF,$CF,$A5,$A5,$83,$83,$19,$19,$97,$97,$AD,$AD,$8B,$8B,$E1,$E1
	dc.b $DF,$DF,$35,$35,$13,$13,$29,$29,$A7,$A7,$3D,$3D,$1B,$1B,$F1,$F1
	dc.b $EF,$EF,$C5,$C5,$A3,$A3,$39,$39,$B7,$B7,$CD,$CD,$AB,$AB,$01,$01
;	
;
;
priat:
	dc.b	0,0,0
;
;	.include	"PRIVATE.KEY"
	dc.b	0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
pubicK:
	dc.b	0,0,0
	.include	"PUBLICD.KEY"
;
;
;
;  Constant MD5 data goes here..
;
;  Init state
;
initstate:
	dc.l	$67452301
	dc.l	$EFCDAB89
	dc.l	$98BADCFE
	dc.l	$10325476
;
;
hashman:
;futz
          dc.l      $D76AA478
          dc.l      $E8C7B756
          dc.l      $242070DB
          dc.l      $C1BDCEEE
          dc.l      $F57C0FAF
          dc.l      $4787C62A
          dc.l      $A8304613
          dc.l      $FD469501
          dc.l      $698098D8
          dc.l      $8B44F7AF
          dc.l      $FFFF5BB1
          dc.l      $895CD7BE
          dc.l      $6B901122
          dc.l      $FD987193
          dc.l      $A679438E
          dc.l      $49B40821
;grind
          dc.l      $F61E2562
          dc.l      $C040B340
          dc.l      $265E5A51
          dc.l      $E9B6C7AA
          dc.l      $D62F105D
          dc.l      $02441453
          dc.l      $D8A1E681
          dc.l      $E7D3FBC8
          dc.l      $21E1CDE6
          dc.l      $C33707D6
          dc.l      $F4D50D87
          dc.l      $455A14ED
          dc.l      $A9E3E905
          dc.l      $FCEFA3F8
          dc.l      $676F02D9
          dc.l      $8D2A4C8A
;hack
          dc.l      $FFFA3942
          dc.l      $8771F681
          dc.l      $6D9D6122
          dc.l      $FDE5380C
          dc.l      $A4BEEA44
          dc.l      $4BDECFA9
          dc.l      $F6BB4B60
          dc.l      $BEBFBC70
          dc.l      $289B7EC6
          dc.l      $EAA127FA
          dc.l      $D4EF3085
          dc.l      $04881D05
          dc.l      $D9D4D039
          dc.l      $E6DB99E5
          dc.l      $1FA27CF8
          dc.l      $C4AC5665
;ickify
          dc.l      $F4292244
          dc.l      $432AFF97
          dc.l      $AB9423A7
          dc.l      $FC93A039
          dc.l      $655B59C3
          dc.l      $8F0CCC92
          dc.l      $FFEFF47D
          dc.l      $85845DD1
          dc.l      $6FA87E4F
          dc.l      $FE2CE6E0
          dc.l      $A3014314
          dc.l      $4E0811A1
          dc.l      $F7537E82
          dc.l      $BD3AF235
          dc.l      $2AD7D2BB
          dc.l      $EB86D391
;
;
; ROL counts for each op
rotater:
	dc.w	7
	dc.w	12
	dc.w	17
	dc.w	22

	dc.w	5
	dc.w	9
	dc.w	14
	dc.w	20

	dc.w	4
	dc.w	11
	dc.w	16
	dc.w	23

	dc.w	6
	dc.w	10
	dc.w	15
	dc.w	21
;
;  End MD5 constant data
;
;
;
;
;
;----------------------------------------------------------
;
;  Object type (Bits 0-2 in 1st 64-bit phrase of object)
; 
BMAPTYP		equ	0	;Bit-Map object
SCALTYP		equ	1	;Scaled Bit-Map object
GPUTYP		equ	2	;Graphics Processor interrupt Object
BRTYP		equ	3	;Branch Object
STOPTYP		equ	4	;Stop Object
;
;
;
;
;   Rom copy of the Object list
;
dlistROM:

OBJTYPE		set	BRTYP	;1st object is a BR object
BCC		set	1	;Br Condition Code (br if YPOS=<VC)
YPOS		set	21	;top branch object
	dc.w	0
	dc.l	(dlist+16) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
YPOS		set	519	;bottom branch object
	dc.w	0
	dc.l	(dlist+32) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
	dc.l	0,STOPTYP
	dc.l	0,STOPTYP
;
;
OBJTYPE		set	BMAPTYP	;1st object is a Scaled Bit-Map object
HEIGHT		set	240*2	;fill the screen
YPOS		set	41	;from the top
XPOS		set	30	;from the left edge
FIRSTPIX	set	0	;no left edge clipping
RELEASE		set	0	;release bus between image data fetches
TRANSPAR	set	0	;make logical color 0 transparent
RMW		set	0	;no read-modify-write
REFLECT		set	0	;no horizontal reflect
INDEX		set	0	;palette offset if 1-4 bits/pix
IWIDTH		set	6	;12 phrases in displayed image
DWIDTH		set	6	;12 phrases in source form
PITCH		set	1	;increment by 1 phrase for next fetch
DEPTH		set	0	;1 bits/pixel (2 color)
;
;  1st Object is a vanilla Bit-map, so it needs a 2 phrase header
;
;  1st phrase
 dc.l	(image << 8) + ((dlist+48) >> 11)
 dc.l	((dlist+48) << 21) + (HEIGHT << 13) + (YPOS << 3) + OBJTYPE 
;
;  2nd phrase
 dc.w (FIRSTPIX << 1) + RELEASE
 dc.w (TRANSPAR << 15) + (RMW << 14) + (REFLECT <<13) + (INDEX << 6) + (IWIDTH >> 4)
 dc.w ((IWIDTH & $0F) << 12) + (DWIDTH << 2) + (PITCH & $06)
 dc.w ((PITCH & 1) << 15) + (DEPTH << 12) + XPOS
;
 dc.l	0,STOPTYP,0,STOPTYP
;
;
font:
	.nlist
	include	"font8x8.s"
	.list
;
signon:
	.dc.b	"CD Encryption Utility v.0.7",0
getpriv:
	dc.b	"Insert Private Key Disk in A:...    ",0
getcdtoc:
	dc.b	"Reading Submit CD's Directory...    ",0
badisc:
	dc.b	"Unrecognized or Missing Disc        ",0
;		 01234567890123456789012345678901234567
cdermsg0:
	dc.b	"CD error detected during 1st pass...",0
cdermsg1:
	dc.b	"CD error detected during 2nd pass...",0
seekmsg0:
	dc.b	"Seek error detected during 1st pass.",0
seekmsg1:
	dc.b	"Seek error detected during 2nd pass.",0
statm:
	dc.b	"Encrypt Trks:00-00, Total CDtime 00:00",0
trknot:
	dc.b	"    CD not properly formatted...    ",0
;
;
;
headmsg:
	dc.b	"Activity Trk  Mark  Blok Min% Max%    Size  ",0
;		 0123456789012345678901234567890123456789A  
headmsg1:
	dc.b	"-------- ---  ----  ---- ---- ----    ----  ",0
scanmsg:
	dc.b	"Scanning                                    ",0
analmsg:
	dc.b	"Analyzin ",0
md5msg:
	dc.b	" MD5'ing ",0
donmsg:
	dc.b	"  <done> ",0

;
donemsg:
	dc.b	">>All Done,Totals:                          ",0
rsamsg:
	dc.b	"Finishing RSA computation...      Blks Left ",0
;
tocmsg:
	dc.b	13,10
	dc.b	"----------------------------------------------",13,10,13,10
	dc.b	"CD Directory:",13,10,0
starmsg:
	dc.b	"*",0
;
	.bss
;
;
;dlist:			define this as an equate
	ds.l	16
;
;image:
	ds.b	48*280
;
countRSA:
	ds.l	1
;
nextrk:
	ds.l	1
curfine:
	ds.l	1	;ptr to current finehash position
currsa:
	ds.l	1	;ptr to beg of current RSA session (input from finehash)
endrsa:
	ds.l	1	;ptr to end of current RSA session (+1)
fcount:
	ds.l	1
joycur:
	ds.l	1
;
decdig:
	ds.b	4
;
lastc:
	ds.l	1	;used as word
;
;
statmsg:
	ds.b	128		;put up status message built here
curmsg:
	ds.b	128		;current display meesage
;
BlokT:
	ds.l	1
MinT:
	ds.l	1
MaxT:
	ds.l	1
SizeT:
	ds.l	1
;
md5src:
	ds.l	1		;"postmark" ptr for MD5
md5dst:
	ds.l	1		;"prehash" ptr for MD5
md5sync:
	ds.l	1		;sync mark pattern for MD5
md5time:
	ds.l	1		;time where sync mark can be found
;
trakblk:
	ds.w	1	;# of postmark block records remaining
trakchnk:
	ds.w	1	;# of postmark block records processed, this pass
resync:
	ds.l	1	;next sync marker
;
srcend:
	ds.l	1	;ptr to end of postmark buffer (+1)
trakoff:
	ds.l	1	;byte offset into track seg
intbufpt:
	ds.l	1	;internal message buffer ptr
intbuf:
	ds.b	$2000
;
rsabeg:
	ds.l	1
rsaend:
	ds.l	1
;
privy:
	ds.b	1024
;
privat:
	ds.b	68
publicK:
	ds.b	68
;
;
butchptr:
	ds.l	1
butchbuf:
	ds.l	256
;
postmark:
	ds.b	$20000		;qualified markers to use for hash
prehash:
	ds.b	$20000		;hash records generated
;
;
;
finehash:
	ds.b	$28000		;final hash table to be enRSA'd
FileST:
	ds.b	$60		;header for RSA'd
resultF:
	ds.b	$26160		;RSA'd & formatted & ready to go
FileEND:
	ds.b	$60		;tailer here
;
;  The following buffer can get very big...
;
premark:
	ds.b	$20000		;pre-scan potential markers found
