	.nlist
	.include	"jaguar.inc"
	.include	"blit.inc"
	.list
;
;
;
dlist	equ	$80000
image	equ	$90000
;
pfbuf		equ	204	;playfield SRC regs on this line
lbufs		equ	205	;line buffers start on this line
;
;
;
p0lin		equ	lbufs+0	
m0lin		equ	lbufs+1	
p1lin		equ	lbufs+2	
m1lin		equ	lbufs+3	
pflin		equ	lbufs+4	
ballin		equ	lbufs+5	
bglin		equ	lbufs+6	
;
underlin	equ	37	;underscan lines
screnlin	equ	203	;total displayable lines
;
;
pf0	equ	image+(pfbuf*160)
pf1	equ	pf0+16
pf2	equ	pf1+16
;
;
grp0	equ	pf2+16
grp1	equ	grp0+16
;
;
;
;
;
start:
	lea	$200000,sp		;set stack at top of memory
	move.w	#$100,JOY1		;unmute
;
	clr.w	linecnt
	clr.w	prevpix
;
	bsr	initdisp		;start-up some display here
;
;
;*****************************************************************
;  Now, let's do 6502 emulator
;
	lea	zerop,a0
	moveq	#-1,d0
	move.w	#$400-1,d1		;-1 to 0xxx
initer:
	move.l	d0,(a0)+
	dbra	d1,initer
;
;
	lea	fcount,a0
;
refrm:
	move.l	(a0),d0
frmwait:
	cmp.l	(a0),d0
	beq	frmwait
;
	lea	joycur,a1
	lea	oldjoy,a2

	moveq	#3,d2
packlp:
	move.l	(a1)+,d0
	move.l	(a2),d1
	move.l	d0,(a2)+
	eor.l	d0,d1
	and.l	d0,d1
	rol.l	#8,d1
	lsl.l	#8,d3
	move.b	d1,d3
	dbra	d2,packlp
;
;
;		              147     2580    369
;		   3         2         1     
;		  10987654321098765432109876543210
	andi.l	#%00000000000011100000111100001110,d3
	beq	refrm
	moveq	#9,d0
bitllp:
	move.b	bitb(PC,d0.w),d1
	btst.l	d1,d3
	bne.s	gotone
	dbra	d0,bitllp
	bra	refrm
bitb:
	dc.b	8,19,11,3,18,10,2,17,9,1
;
gotone:
	cmpi.w	#(ovgamez-gamez)/4,d0
	bcc	refrm
;
	add.w	d0,d0
	add.w	d0,d0
	move.l	gamez(pc,d0.w),a0
	bra.s	ovgamez
gamez:
	dc.l	berz
	dc.l	pac
	dc.l	yars
	dc.l	mcomand
ovgamez:
	lea	gamerom,a1
	move.w	#$400-1,d0
looper:
	move.l	(a0)+,(a1)+
	dbra	d0,looper
;
	lea	zerop,a0	;base address of stella
	lea	disp,a1		;base address of opcode dispatch
	sub.l	a2,a2		;interval timer
	lea	cyclez,a3	;table of cycle counts

	sub.l	a4,a4		;current cycle count in a4
	addq.l	#2,a4
	lea	bytcount,a5	;table of opcode sizes (in bytes)
;

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
;
	bset	#2,d7		;reset sets I Flag to 1
;
	move.w	#$1ffc,d2	;pc
	move.w	(a0,d2.w),d2	;reset vector
	rol.w	#8,d2		;big Endian for 68k
	bra.s	tstart
;
;  TIA modified by a 6502 write...
;
tiamod:
;
;  d0.w contains TIA register modified (or 6520 if $2D-$30)
;
	lea	tiadisp(pc),a6
	add.w	d0,d0	
	move.w	(a6,d0.w),d0
	jmp	(a6,d0.w)
;
;
;
;
tstart:
	movea.w	#-1,a6		;indicate TIA not modified
	move.l	#-1,$f00050	;start PIT
retv:
	move.w	a6,d0		;was TIA modified by a write?
	bpl.s	tiamod		;br if so	
retx:
	move.w	d2,d0
	andi.w	#$1fff,d0	;
;
;d0 temp (68k PC)
;d1 temp
;
;d2 = pc
;d3 = sp
;d4 = accum
;d5 = x
;d6 = y
;d7 = flags
;
	moveq	#0,d1
	move.b	(a0,d0.w),d1	;fetch next opcode
	add.w	d1,d1
	swap	d0
	move.w	(a3,d1.w),d0
	adda.w	d0,a4		;advance cycle counter
	cmpa.w	d0,a2		;have we timed out interval timer?
	bpl.s	interon		;br if not
	clr.b	INTIM
	bra.s	interoff
interon:
	suba.w	d0,a2		;decrement interval timer
interoff:
	swap	d0
	add.w	(a5,d1.w),d2	;advance PC
	move.w	(a1,d1.w),d1
	jmp	(a1,d1.w)
;
;
;
	.nlist
	.include	"68k265.s"
	.list
;
;
;
;
Frame:
	movem.l	d0-d2/a0-a1,-(sp)
	lea	dlistROM+32,a0
	lea	dlist+32,a1
	moveq	#3,d0
Flist:
	move.l	(a0)+,(a1)+
	dbra	d0,Flist		;copy ROM display list to ram
;
	move.w	#$0101,INT1		;clear CPU interrupt
	move.w	#0,INT2
;
	addq.l	#1,fcount
;
;
	.if	1
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81ff,d1
	moveq	#$11,d0
Floop:
	eor.w	d1,d0
	move.w	d0,(a1)		;ask for next row
;
	move.l	(a1),d2
	not.l	d2
	move.l	d2,(a0)+
;
	eor.w	d1,d0
	add.w	d0,d0
	cmpi.w	#$110,d0
	bcs	Floop
;
	.else
;
	lea	joycur,a0
	lea	$f14000,a1
	move.w	#$81EE,(a1)		;ask for top row
;
;				  P1   P0                           P1P0
	move.l	(a1),d0		;369# RLDU xxxx xxxx xxxx xxxx xxxx OxAP
	move.l	d0,d2
	swap	d0		;xxxx xxxx xxxx OxAP 369# RLDU xxxx xxxx
	ror.l	#4,d0		;xxxx xxxx xxxx xxxx OxAP 369# RLDU xxxx 
	move.l	d0,(a0)+

	move.w	#$8177,(a1)
;
	ror.w	#2,d2
;				  P1   P0                           P1P0
	move.l	(a1),d1		;RLDU 369# xxxx xxxx xxxx xxxx xxxx APOx
	rol.l	#4,d1		;369# xxxx xxxx xxxx xxxx xxxx APOx RLDU
;
	move.l	d1,(a0)+
;
	move.b	d1,d2
	ori.w	#$7f7f,d2
	move.w	d2,INPT4
;
	andi.w	#$f0,d0
	andi.w	#$0f,d1
	or.w	d1,d0
	move.b	d0,SWCHA	
;
	.endif
	movem.l	(sp)+,d0-d2/a0-a1
;	move.w	#$0101,INT1		;clear CPU interrupt
;	move.w	#0,INT2
rrte:
	rte
;
;
;
;
;  Init the display
;
initdisp:
	lea	dlistROM,a0
	lea	dlist,a1
	moveq	#15,d0
getlist:
	move.l	(a0)+,(a1)+
	dbra	d0,getlist		;copy ROM display list to ram
;
	bsr	fillgrey
;
;
	clr.l	fcount
;
	lea	CLUT,a0
	lea	chroma,a1
	move.w	#127,d2
chrlp0:
	move.w	(a1)+,d3
	move.w	d3,(a0)+
	move.w	d3,(a0)+
	dbra	d2,chrlp0
;
	move.l	#Frame,$100
	move.l	#dlist,d0
	swap	d0
	move.l	d0,OLP			;stop object is here
;
	moveq	#0,d0
	move.l	d0,BORD1
	move.w	d0,BG
	move.w	#-1,VDE
;
	move.w	#$101,INT1
;
	move.w	#$cc1,VMODE
;
	move.w	#%0000000000000000,BG		;black
;
	lea	image+(lbufs*160),a0
	moveq	#0,d0
	move.w	#7*40-1,d1
clerbufz:
	move.l	d0,(a0)+
	dbra	d1,clerbufz
;
	lea	BASE,a0			;use relative addressing for economy
.waitblit:
	move.l	b_cmd(a0),d0	;if blitter is in use, wait til done
	lsr.w	#1,d0
	bcc	.waitblit
;
;
;
	move.l	#image,d0	;all blits use same form
	move.l	d0,a1_base(a0)
	move.l	d0,a2_base(a0)
;
;
	rts
;
;
;
fillgrey:
	lea	image,a0
	move.l	#$02020202,d0
	move.w	#40*240-1,d1
clearimg:
	move.l	d0,(a0)+
	dbra	d1,clearimg
	rts
;
;
;
;
chroma:
	.nlist
	.include	"coltab.s"
	.list
;
;
tiadisp:
	dc.w	tia00-tiadisp	;VSYNC
	dc.w	tia01-tiadisp	;VBLANK
	dc.w	tia02-tiadisp	;WSYNC
	dc.w	tia03-tiadisp	;RSYNC
	dc.w	tia04-tiadisp	;NUSIZ0
	dc.w	tia05-tiadisp	;NUSIZ1
	dc.w	tia06-tiadisp	;COLUP0
	dc.w	tia07-tiadisp	;COLUP1
	dc.w	tia08-tiadisp	;COLUPF
	dc.w	tia09-tiadisp	;COLUBK
	dc.w	tia0a-tiadisp	;CTRLPF
	dc.w	tia0b-tiadisp	;REFP0
	dc.w	tia0c-tiadisp	;REFP1
	dc.w	tia0d-tiadisp	;PF0
	dc.w	tia0e-tiadisp	;PF1
	dc.w	tia0f-tiadisp	;PF2
	dc.w	tia10-tiadisp	;RESP0
	dc.w	tia11-tiadisp	;RESP1
	dc.w	tia12-tiadisp	;RESM0
	dc.w	tia13-tiadisp	;RESM1
	dc.w	tia14-tiadisp	;RESBL
	dc.w	tia15-tiadisp	;AUDC0
	dc.w	tia16-tiadisp	;AUDC1
	dc.w	tia17-tiadisp	;AUDF0
	dc.w	tia18-tiadisp	;AUDF1
	dc.w	tia19-tiadisp	;AUDV0
	dc.w	tia1a-tiadisp	;AUDV1
	dc.w	tia1b-tiadisp	;GRP0
	dc.w	tia1c-tiadisp	;GRP1
	dc.w	tia1d-tiadisp	;ENAM0
	dc.w	tia1e-tiadisp	;ENAM1
	dc.w	tia1f-tiadisp	;ENABL
	dc.w	tia20-tiadisp	;HMP0
	dc.w	tia21-tiadisp	;HMP1
	dc.w	tia22-tiadisp	;HMM0
	dc.w	tia23-tiadisp	;HMM1
	dc.w	tia24-tiadisp	;HMBL
	dc.w	tia25-tiadisp	;VDELP0
	dc.w	tia26-tiadisp	;VDELP1
	dc.w	tia27-tiadisp	;VDELBL
	dc.w	tia28-tiadisp	;RESMP0
	dc.w	tia29-tiadisp	;RESMP1
	dc.w	tia2a-tiadisp	;HMOVE
	dc.w	tia2b-tiadisp	;HMCLR
	dc.w	tia2c-tiadisp	;CXCLR
;
	dc.w	tim1-tiadisp	;interval timer 6520
	dc.w	tim8-tiadisp	;
	dc.w	tim64-tiadisp	;
	dc.w	t1024-tiadisp	;
;
;
;
;
;
tia00:				;VSYNC
	move.b	(a0),d0
	move.b	oldvsync,d1
	move.b	d0,oldvsync
	eor.b	d1,d0
	and.b	d1,d0
	btst	#1,d0		;vsync turned off?
	beq.s	tia00x		;br if not
;
;  read the joystick ala Stella
;
	movem.l	a1/d0-d2,-(sp)
	lea	$f14000,a1
	move.w	#$81EE,(a1)		;ask for top row
;
;				  P1   P0                           P1P0
	move.l	(a1),d0		;369# RLDU xxxx xxxx xxxx xxxx xxxx OxAP
	move.l	d0,d2
	swap	d0		;xxxx xxxx xxxx OxAP 369# RLDU xxxx xxxx
	ror.l	#4,d0		;xxxx xxxx xxxx xxxx OxAP 369# RLDU xxxx 

	move.w	#$8177,(a1)
;
	ror.w	#2,d2
;				  P1   P0                           P1P0
	move.l	(a1),d1		;RLDU 369# xxxx xxxx xxxx xxxx xxxx APOx
	rol.l	#4,d1		;369# xxxx xxxx xxxx xxxx xxxx APOx RLDU
;
	move.b	d1,d2
	ori.w	#$7f7f,d2
	move.w	d2,INPT4
;
	andi.w	#$f0,d0
	andi.w	#$0f,d1
	or.w	d1,d0
	move.b	d0,SWCHA	
;
	swap	d1
	rol.w	#2,d1
	ori.w	#$fffc,d1
	move.b	d1,SWCHB
	movem.l	(sp)+,a1/d0-d2
;
;  top of sync
;
tos:
	clr.w	linecnt		;restart line counter
;	sub.l	a4,a4	
tia00x:
	movea.w	#-1,a6
	bra	retx
;
;
;
tia01:				;VBLANK
	movea.w	#-1,a6
	bra	retx
;
;
;
;
;
tia02:				;WSYNC
	move.w	a4,d0
	move.w	#228,d1
;
	.if	0
	btst.b	#1,1(a0)	;check VBLANK
	beq.s	.t02		;beam is on
;
; if beam is off, increment linecnt 
;
	cmpi.w	#screnlin,linecnt
	bcc.s	.t02
;
	movea.w	linecnt,a4
.t002:
	addq.w	#1,a4
	sub.w	d1,d0
	bpl	.t002
	move.w	a4,linecnt
	sub.l	a4,a4
	bra.s	.t02x
	.endif
.t02:
	sub.w	d1,d0
	bpl	.t02
	suba.w	d0,a4
.t02x:
	adda.w	d0,a2
;
	movea.w	#-1,a6
	bra	retx
;
tia03:				;RSYNC
	movea.w	#-1,a6
	bra	retx
;
tia04:				;NUSIZ0
	bsr	updisp
;
	tst.b	$1b(a0)		;GRP0 have any graphics?
	beq.s	tia04x
;
	moveq	#0,d0		;else, we need to clear
	move.w	#p0lin,d1
	bsr	fillbak		;slam 0 into P0 line
;
tia04x:
	btst.b	#1,$1d(a0)	;is M0 enabled?
	beq.s	tia04xx
;
	moveq	#0,d0		;else, we need to clear
	move.w	#m0lin,d1
	bsr	fillbak		;slam 0 into M0 line
;
tia04xx:
	moveq	#0,d0
	move.b	4(a0),d0
	andi.w	#7,d0
	add.w	d0,d0
	move.w	nusztab0(pc,d0.w),nusizer0+2
	move.w	nusztb0(pc,d0.w),nsizer0+2
;
	movea.w	#-1,a6
	bra	retx
;
nusztab0:
	dc.w	playr00-nusizer0-2
	dc.w	playr00-nusizer0-2
	dc.w	playr00-nusizer0-2
	dc.w	playr03-nusizer0-2
	dc.w	playr00-nusizer0-2
	dc.w	playr00-nusizer0-2
	dc.w	playr00-nusizer0-2
	dc.w	playr00-nusizer0-2
nusztb0:
	dc.w	playr00-nsizer0-2
	dc.w	playr00-nsizer0-2
	dc.w	playr00-nsizer0-2
	dc.w	playr03-nsizer0-2
	dc.w	playr00-nsizer0-2
	dc.w	playr00-nsizer0-2
	dc.w	playr00-nsizer0-2
	dc.w	playr00-nsizer0-2

tia05:				;NUSIZ1
	bsr	updisp

	moveq	#0,d0
	move.b	5(a0),d0
	andi.w	#7,d0
	add.w	d0,d0
	move.w	nusztab1(pc,d0.w),nusizer1+2
	move.w	nusztb1(pc,d0.w),nsizer1+2
	movea.w	#-1,a6
	bra	retx
;
nusztab1:
	dc.w	playr10-nusizer1-2
	dc.w	playr10-nusizer1-2
	dc.w	playr10-nusizer1-2
	dc.w	playr13-nusizer1-2
	dc.w	playr10-nusizer1-2
	dc.w	playr10-nusizer1-2
	dc.w	playr10-nusizer1-2
	dc.w	playr10-nusizer1-2

nusztb1:
	dc.w	playr10-nsizer1-2
	dc.w	playr10-nsizer1-2
	dc.w	playr10-nsizer1-2
	dc.w	playr13-nsizer1-2
	dc.w	playr10-nsizer1-2
	dc.w	playr10-nsizer1-2
	dc.w	playr10-nsizer1-2
	dc.w	playr10-nsizer1-2

tia06:				;COLUP0
	bsr	updisp
	move.b	COLUP0,d0
	ori.b	#1,d0
	move.b	d0,d1
	lsl.w	#8,d1
	move.b	d0,d1
	move.w	d1,d0
	swap	d1
	move.w	d0,d1
	move.l	d1,colup0

	movea.w	#-1,a6
	bra	retx
;
tia07:				;COLUP1
	bsr	updisp
	move.b	COLUP1,d0
	ori.b	#1,d0
	move.b	d0,d1
	lsl.w	#8,d1
	move.b	d0,d1
	move.w	d1,d0
	swap	d1
	move.w	d0,d1
	move.l	d1,colup1

	movea.w	#-1,a6
	bra	retx
;
tia08:				;COLUPF
	bsr	updisp
	move.b	COLUPF,d0
	ori.b	#1,d0
	move.b	d0,d1
	lsl.w	#8,d1
	move.b	d0,d1
	move.w	d1,d0
	swap	d1
	move.w	d0,d1
	move.l	d1,colupf

	movea.w	#-1,a6
	bra	retx
;
tia09:				;COLUBK
	bsr	updisp
	move.b	COLUBK,d0
	ori.w	#1,d0
	move.w	#bglin,d1
	bsr	fillbak		;slam d0.b into background line
;
	movea.w	#-1,a6
	bra	retx
;
tia0a:				;CTRLPF
	bsr	updisp
	bsr	playf0
	bsr	playf1
	bsr	playf2
	movea.w	#-1,a6
	bra	retx
;
tia0b:				;REFP0
	bsr	updisp
	movea.w	#-1,a6
	bra	retx
;
tia0c:				;REFP1
	bsr	updisp
	movea.w	#-1,a6
	bra	retx
;
tia0d:				;PF0
	bsr	updisp
	move.b	$d(a0),d0
	lsr.b	#4,d0
	move.b	d0,pf0
	bsr	playf0
	movea.w	#-1,a6
	bra	retx
;
tia0e:				;PF1
	bsr	updisp
	move.b	$e(a0),pf1
	bsr	playf1
	movea.w	#-1,a6
	bra	retx
;
tia0f:				;PF2
	bsr	updisp
	move.b	$f(a0),pf2
	bsr	playf2
	movea.w	#-1,a6
	bra	retx
;
;
;
tia10:				;RESP0
	bsr	updisp
;	
	moveq	#0,d0		;else, we need to clear
	move.w	#p0lin,d1
	bsr	fillbak		;slam 0 into P0 line
;
	move.w	a4,d0
	subi.w	#63,d0
	move.w	d0,p0hz
;
	bra	tia1b		;exit thru redraw of P0
;	movea.w	#-1,a6
;	bra	retx
;
tia11:				;RESP1
	bsr	updisp

	moveq	#0,d0		;else, we need to clear
	move.w	#p1lin,d1
	bsr	fillbak		;slam 0 into P0 line
;
	move.w	a4,d0
	subi.w	#63,d0
	move.w	d0,p1hz

	bra	tia1c
;
	movea.w	#-1,a6
	bra	retx
;
tia12:				;RESM0
	bsr	updisp

	move.w	a4,d0
	subi.w	#64,d0
	move.w	d0,m0hz

	movea.w	#-1,a6
	bra	retx
;
tia13:				;RESM1
	bsr	updisp

	move.w	a4,d0
	subi.w	#64,d0
	move.w	d0,m1hz

	movea.w	#-1,a6
	bra	retx
;
tia14:				;RESBL
	bsr	updisp
;
	move.w	a4,d0
	subi.w	#64,d0		;ball's new horz position

;	btst.b	#1,$1f(a0)	;ball enabled?
;	beq.s	.tia14x
;
;.tia14x:
;
	move.w	d0,ballhz

	movea.w	#-1,a6
	bra	retx
;
;
;  Audio stuff (ignore for now)
;
tia15:				;AUDC0
	movea.w	#-1,a6
	bra	retx
;
tia16:				;AUDC1
	movea.w	#-1,a6
	bra	retx
;
tia17:				;AUDF0
	movea.w	#-1,a6
	bra	retx
;
tia18:				;AUDF1
	movea.w	#-1,a6
	bra	retx
;
tia19:				;AUDV0
	movea.w	#-1,a6
	bra	retx
;
tia1a:				;AUDV1
	movea.w	#-1,a6
	bra	retx
;
;
;
;
tia1b:				;GRP0
	bsr	updisp
vdelx0:
	bra.s	novdel0		;br if no vdel0
;
; VDELP0 is on
;
	move.b	$1b(a0),grp0d
	bra.s	nusizer0	;br if not
novdel0:
	move.b	$1b(a0),grp0
nusizer0:
	bsr	playr00
;
	btst.b	#0,$26(a0)	;is VDELP1 on?
	beq.s	tia1bx
	move.b	grp1d,grp1
nsizer1:
	bsr	playr10
tia1bx:
	movea.w	#-1,a6
	bra	retx
;
;
;
tia1c:				;GRP1
	bsr	updisp
vdelx1:
	bra.s	novdel1		;br if no vdel0
;
; VDELP1 is on
;
	move.b	$1c(a0),grp1d
	bra.s	nusizer1	;br if not
novdel1:
	move.b	$1c(a0),grp1
nusizer1:
	bsr	playr10
;
	btst.b	#0,$25(a0)	;is VDELP0 on?
	beq.s	tia1cx
	move.b	grp0d,grp0
nsizer0:
	bsr	playr00
tia1cx:
	movea.w	#-1,a6
	bra	retx
;
;
;
;
tia1d:				;ENAM0
	bsr	updisp

	btst.b	#1,$1d(a0)	;enable or disable?
	beq.s	.tia1dx		;br if disable

	lea	image+(m0lin*160),a6
	move.w	m0hz,d0
	adda.w	d0,a6
;
	move.b	4(a0),d1	;NUSIZ0
	lsr.w	#4,d1
	andi.w	#$3,d1
	move.b	ballsz(pc,d1.w),d1
	add.w	d1,d0
	subi.w	#160,d0		;check right hand wrap
	bcs.s	.m0wr
	add.w	d0,d1
.m0wr:
	move.b	6(a0),d0	;COLUP0
.m0lp:
	move.b	d0,(a6)+
	dbra	d1,.m0lp
	bra.s	.tia1dxx
;
.tia1dx:
	move.w	#0,d0
	move.w	#m0lin,d1
	bsr	fillbak
.tia1dxx:
	movea.w	#-1,a6
	bra	retx
;
;
;
tia1e:				;ENAM1
	bsr	updisp
;
	btst.b	#1,$1e(a0)	;enable or disable?
	beq.s	.tia1ex		;br if disable

	lea	image+(m1lin*160),a6
	move.w	m1hz,d0
	adda.w	d0,a6
;
	move.b	5(a0),d1	;NUSIZ1
	lsr.w	#4,d1
	andi.w	#$3,d1
	move.b	ballsz(pc,d1.w),d1
	add.w	d1,d0
	subi.w	#160,d0		;check right hand wrap
	bcs.s	.m1wr
	add.w	d0,d1
.m1wr:
	move.b	7(a0),d0	;COLUP1
.m1lp:
	move.b	d0,(a6)+
	dbra	d1,.m1lp
	bra.s	.tia1exx
;
.tia1ex:
	move.w	#0,d0
	move.w	#m1lin,d1
	bsr	fillbak
.tia1exx:
	movea.w	#-1,a6
	bra	retx
;
;
ballsz:
	dc.b	0,1,3,7		
;
;
;
tia1f:				;ENABL
	bsr	updisp

	btst.b	#1,$1f(a0)	;enable or disable?
	beq.s	.tia1fx		;br if disable

	lea	image+(ballin*160),a6
	adda.w	ballhz,a6
;
	move.b	8(a0),d0	;COLUPF
	move.b	$a(a0),d1	;CTRLPF
	lsr.w	#4,d1
	andi.w	#$3,d1
	move.b	ballsz(pc,d1.w),d1
.balllp:
	move.b	d0,(a6)+
	dbra	d1,.balllp
	bra.s	.tia1fxx
;
.tia1fx:
	move.w	#0,d0
	move.w	#ballin,d1
	bsr	fillbak
.tia1fxx:
	movea.w	#-1,a6
	bra	retx

;
;
tia20:				;HMP0
	moveq	#0,d0
	move.b	$20(a0),d0	;get HMBL
	bpl.s	.tia20x
	ori.w	#$ff0f,d0
.tia20x:
	ror.w	#4,d0
	move.w	d0,hmovep0
;
	movea.w	#-1,a6
	bra	retx
;
;
;
tia21:				;HMP1
	moveq	#0,d0
	move.b	$21(a0),d0	;get HMBL
	bpl.s	.tia21x
	ori.w	#$ff0f,d0
.tia21x:
	ror.w	#4,d0
	move.w	d0,hmovep1
;
	movea.w	#-1,a6
	bra	retx
;
;
;
tia22:				;HMM0
	moveq	#0,d0
	move.b	$22(a0),d0	;get HMBL
	bpl.s	.tia22x
	ori.w	#$ff0f,d0
.tia22x:
	ror.w	#4,d0
	move.w	d0,hmovem0
;
	movea.w	#-1,a6
	bra	retx
;
;
;
tia23:				;HMM1
	moveq	#0,d0
	move.b	$23(a0),d0	;get HMBL
	bpl.s	.tia23x
	ori.w	#$ff0f,d0
.tia23x:
	ror.w	#4,d0
	move.w	d0,hmovem1
;

	movea.w	#-1,a6
	bra	retx
;
tia24:				;HMBL
	moveq	#0,d0
	move.b	$24(a0),d0	;get HMBL
	bpl.s	.tia24x
	ori.w	#$ff0f,d0
.tia24x:
	ror.w	#4,d0
	move.w	d0,hmovebl
;
	movea.w	#-1,a6
	bra	retx
;
;
;
;
tia25:				;VDELP0
	move.w	#$6000+(novdel0-vdelx0-2),d0	;assume no vdel
	btst.b	#0,$25(a0)	;vdel on?
	beq.s	tia25x
	move.w	#$4e71,d0
tia25x:
	move.w	d0,vdelx0	;set-up vdel
;
	movea.w	#-1,a6
	bra	retx
;
;
;
;
tia26:				;VDELP1
	move.w	#$6000+(novdel1-vdelx1-2),d0	;assume no vdel
	btst.b	#0,$26(a0)	;vdel on?
	beq.s	tia26x
	move.w	#$4e71,d0
tia26x:
	move.w	d0,vdelx1	;set-up vdel
;
	movea.w	#-1,a6
	bra	retx
;
;
;
;
tia27:				;VDELBL
	movea.w	#-1,a6
	bra	retx
;
tia28:				;RESMP0
	bsr	updisp
	movea.w	#-1,a6
	bra	retx
;
tia29:				;RESMP1
	bsr	updisp
	movea.w	#-1,a6
	bra	retx
;
;
;
tia2a:				;HMOVE
	bsr	updisp

	move.w	hmovep0,d0	;add HMOVE values to horz positions
	beq.s	.nop0
	sub.w	d0,p0hz

	bpl.s	.nop0wr	
	addi.w	#160,p0hz
.nop0wr:
;
	tst.b	$1b(a0)		;any graphics?
	beq.s	.nop0
;
	move.w	#0,d0
	move.w	#p0lin,d1
	bsr	fillbak
;
.nop0:
	move.w	hmovep1,d0
	beq.s	.nop1

	sub.w	d0,p1hz
	bpl.s	.nop1wr	
	addi.w	#160,p1hz
.nop1wr:
;
	tst.b	$1c(a0)		;any graphics
	beq.s	.nop1
;
	move.w	#0,d0
	move.w	#p1lin,d1
	bsr	fillbak
;
.nop1:
	move.w	hmovem0,d0
	beq.s	.nom0
	sub.w	d0,m0hz

	bpl.s	.nom0wr	
	addi.w	#160,m0hz
.nom0wr:

	btst.b	#1,$1d(a0)
	beq.s	.nom0
;
	move.w	#0,d0
	move.w	#m0lin,d1
	bsr	fillbak
;
;
.nom0:
	move.w	hmovem1,d0
	beq.s	.nom1
	sub.w	d0,m1hz

	bpl.s	.nom1wr	
	addi.w	#160,m1hz
.nom1wr:

	btst.b	#1,$1e(a0)
	beq.s	.nom1
;
	move.w	#0,d0
	move.w	#m1lin,d1
	bsr	fillbak
;
.nom1:
	move.w	hmovebl,d0
	beq.s	.nobl
	sub.w	d0,ballhz

	bpl.s	.noblwr	
	addi.w	#160,ballhz
.noblwr:
	btst.b	#1,$1f(a0)
	beq.s	.nobl
;
	move.w	#0,d0
	move.w	#ballin,d1
	bsr	fillbak
;
.nobl:
	movea.w	#-1,a6
	bra	retx
;
tia2b:				;HMCLR
	clr.w	hmovep0
	clr.w	hmovep1
	clr.w	hmovem0
	clr.w	hmovem1
	clr.w	hmovebl
	movea.w	#-1,a6
	bra	retx
;
tia2c:				;CXCLR
	moveq	#0,d0
	move.l	d0,$30(a0)		;clear these for now
	move.l	d0,$34(a0)
	movea.w	#-1,a6
	bra	retx
;
;
; interval timer init done here
;
tim1:
	moveq	#0,d0
	move.b	TIM1T,d0
	subq.w	#1,d0
	move.b	d0,INTIM
	mulu	#3,d0
	move.l	d0,a2
	movea.w	#-1,a6
	bra	retx
tim8:
	moveq	#0,d0
	move.b	TIM8T,d0
	subq.w	#1,d0
	move.b	d0,INTIM
	mulu	#3*8,d0
	move.l	d0,a2
	movea.w	#-1,a6
	bra	retx
tim64:
	moveq	#0,d0
	move.b	TIM64T,d0
	subq.w	#1,d0
	move.b	d0,INTIM
	mulu	#3*64,d0
	move.l	d0,a2
	movea.w	#-1,a6
	bra	retx
t1024:
	moveq	#0,d0
	move.b	T1024T,d0
	subq.w	#1,d0
	move.b	d0,INTIM
	mulu	#3*1024,d0
	move.l	d0,a2
	movea.w	#-1,a6
	bra	retx
;
;
;*******************************************************************
;
;
;  Flush Stella to display up to current color clock count 
;
; a4 - current color clock increment
;
updisp:
	move.l	a4,d0
	sub.w	#228,d0		;have we gone into next line?
	bpl.s	.nexlin		;br if so
;
;  on same line
;
	add.w	#228,d0
	addq.w	#2,d0		;test
	move.w	prevpix,d1
	move.w	d0,prevpix
	sub.w	#68,d1
	bcc.s	.notedge
	moveq	#0,d1
.notedge:
	sub.w	#68,d0
	bhi.s	.weon
	rts			;nothing to display
;
;
.weon:
	sub.w	d1,d0		;d0 = width, d1= left pixel addr
	bsr	displn
	rts
;
.nexlin:
	movea.w	d0,a4	
	move.w	prevpix,d1
	move.w	#228,d0
	sub.w	d1,d0

	subi.w	#68,d1
	bcc.s	.nedge1
	add.w	d1,d0
	moveq	#0,d1
.nedge1:
	bsr	displn
	clr.w	prevpix
	addq.w	#1,linecnt
	bra	updisp
;
;
;  d1 = left pixel addr
;  d0 = width
;  linecnt (d2) = line # (DSTY)
;
displn:
	swap	d1
	move.w	linecnt,d1
	subi.w	#underlin,d1		;displayable line?
	bcc.s	.dispgo
.dispnog:
	rts
;
.disnn:
	rts
.dispgo:
	cmpi.w	#screnlin,d1		;still displayable?
	bcc	.disnn
;
	lea	BASE,a6			;use relative addressing for economy
	move.l	d2,a2			;we need this reg (restore at end)
;
.waitblit:
	move.l	b_cmd(a6),d2	;if blitter is in use, wait til done
	lsr.w	#1,d2
	bcc	.waitblit
;
;
	move.l	#image,a1_base(a6)	;ptr to screen for the destination
	move.l	#image,a2_base(a6)	;ptr to screen for the destination

	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a2_flags(a6)

test:
;
;  A1 -> DST
;
	swap	d1			;(linecnt-37):left pixel addr
	move.l	d1,a1_pixel(a6)		;destination Y,X

	ext.l	d0			;width extended (unsigned ok)

	moveq	#1,d2
	swap	d2
	sub.l	d0,d2
	move.l	d2,a1_step(a6)	;dst step backs up by width, no y inc 

	moveq	#7,d2		;src has 7 lines (merged to 1)
	swap	d2
	move.w	d0,d2
	move.l	d2,b_count(a6)	;7 lines (Y) and pixel width (X)
	neg.l	d0
	move.l	d0,a2_step(a6)	;moves back up 1 line per outer loop
;
	move.w	#lbufs+6,d2	;lbufs is Y of our temp line buffers
	swap	d2
	move.w	d1,d2
	move.l	d2,a2_pixel(a6)
;
	move.l	#0,b_patd(a6)
;
	move.l	#SRCEN|DCOMPEN|UPDA1|UPDA2|LFU_S,b_cmd(a6) ;do the blit
	move.l	a2,d2			;restore d2
	rts
;
;
;
;
;  Update the playfield
;
;
;
;
;  Update playfield 0
;
playf0:
	lea	BASE,a6
.waitblit:
	move.l	b_cmd(a6),d0	;if blitter is in use, wait til done
	lsr.l	#1,d0
	bcc	.waitblit
;
	move.l	#0,b_dstd(a6)	;0 is background here
;
	move.l	colupf,d0

	move.b	CTRLPF,d1
	btst	#1,d1		;score left/right color select?
	beq.s	.skip0
	move.l	colup0,d0
.skip0:
	move.l	d0,b_patd(a6)	;set left-side color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#(pfbuf*10)*$10000+0,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+4,b_count(a6)
	move.l	#(lbufs+4)*$10000+3,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32|XSIGNSUB,a1_flags(a6)	;quad wide
;
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit

;
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	btst	#1,d1
	beq.s	.skip1
	move.l	colup1,b_patd(a6)
.skip1:

	move.l	#(pfbuf*10)*$10000+0,a2_pixel(a6)
;		  height    width
	move.l	#(1*$10000)+4,b_count(a6)

	btst	#0,d1		;check reflect
	bne.s	.skip2

	move.l	#PITCH1|WID40|XADDPIX|PIXEL32|XSIGNSUB,a1_flags(a6)	;quad wide
	move.l	#(lbufs+4)*$10000+23,a1_pixel(a6)	;dst (x,y)
	bra.s	.skip3
;
.skip2:
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32,a1_flags(a6)	;quad wide
	move.l	#(lbufs+4)*$10000+36,a1_pixel(a6)	;dst (x,y)
.skip3:
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;	
;
;  Update playfield 1
;
playf1:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)

	move.l	colupf,d0

	move.b	CTRLPF,d1
	btst	#1,d1		;score left/right color select?
	beq.s	.skip0
	move.l	colup0,d0
.skip0:
	move.l	d0,b_patd(a6)	;set left-side color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+1)*$10000+0,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.l	#(lbufs+4)*$10000+4,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32,a1_flags(a6)	;quad wide

	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
.watblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.watblit
;
	btst	#1,d1
	beq.s	.skip1
	move.l	colup1,b_patd(a6)
.skip1:

	move.l	#((pfbuf*10)+1)*$10000+0,a2_pixel(a6)
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
;
	btst	#0,d1
	bne.s	.skip2

	move.l	#(lbufs+4)*$10000+24,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32,a1_flags(a6)	;quad wide
	bra.s	.skip3
.skip2:
	move.l	#(lbufs+4)*$10000+35,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32|XSIGNSUB,a1_flags(a6)	;quad wide
.skip3:
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit

	rts
;
;
;
;  Update playfield 2
;
playf2:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)

	move.l	colupf,d0

	move.b	CTRLPF,d1
	btst	#1,d1		;score left/right color select?
	beq.s	.skip0
	move.l	colup0,d0
.skip0:
	move.l	d0,b_patd(a6)	;set left-side color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+2)*$10000+0,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.l	#(lbufs+4)*$10000+19,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32|XSIGNSUB,a1_flags(a6)	;quad wide
;
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
.watblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.watblit
;
	btst	#1,d1
	beq.s	.skip1
	move.l	colup1,b_patd(a6)
.skip1:
;
;	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)

	move.l	#((pfbuf*10)+2)*$10000+0,a2_pixel(a6)
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
;
	btst	#0,d1
	bne.s	.skip2
;
	move.l	#(lbufs+4)*$10000+39,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32|XSIGNSUB,a1_flags(a6)	;quad wide
	bra.s	.skip3
;
.skip2:
	move.l	#(lbufs+4)*$10000+20,a1_pixel(a6)	;dst (x,y)
	move.l	#PITCH1|WID40|XADDPIX|PIXEL32,a1_flags(a6)	;quad wide
.skip3:
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;
;
;
;
fillbak:
	move.w	d1,-(sp)
	lea	BASE,a6
.waitblit:
	move.l	b_cmd(a6),d1	;if blitter is in use, wait til done
	lsr.l	#1,d1
	bcc	.waitblit
	move.w	(sp)+,d1
;

	move.l	d0,b_patd(a6)
;
;		  height    width
	move.l	#(1*$10000)+160,b_count(a6)
	ext.l	d1
	swap	d1
	move.l	d1,a1_pixel(a6)			;dst (x,y)
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)
;
	move.l	#SRCEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
	rts
;
;
;
;
;
;  Update player0, single copy, non-reflected (NUSIZ=0)
;
playr00:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)
	move.l	colup0,b_patd(a6)	;player0 color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+3)*$10000,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.w	#p0lin,d0
	swap	d0
	move.w	p0hz,d0
	move.l	d0,a1_pixel(a6)		;dst (x,y)
;
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)	;quad wide

	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;
;
;  Update player0, triple copy - close (NUSIZ=3)
;
playr03:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)
	move.l	colup0,b_patd(a6)	;player0 color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+3)*$10000,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.w	#p0lin,d0
	swap	d0
	move.w	p0hz,d0
	move.l	d0,a1_pixel(a6)		;dst (x,y)
;
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)	;quad wide

	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	addq.l	#8,d0
	addq.l	#8,d0
.watblit:
	move.l	b_cmd(a6),d1	;wait til done
	lsr.l	#1,d1
	bcc	.watblit
;
	move.l	#((pfbuf*10)+3)*$10000,a2_pixel(a6)

	move.l	#(1*$10000)+8,b_count(a6)
	move.l	d0,a1_pixel(a6)		;dst (x,y)
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit

	addq.l	#8,d0
	addq.l	#8,d0
.wutblit:
	move.l	b_cmd(a6),d1	;wait til done
	lsr.l	#1,d1
	bcc	.wutblit
;
	move.l	#((pfbuf*10)+3)*$10000,a2_pixel(a6)

	move.l	#(1*$10000)+8,b_count(a6)
	move.l	d0,a1_pixel(a6)		;dst (x,y)
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;
;
;  Update player1
;
playr10:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)
	move.l	colup1,b_patd(a6)	;player0 color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+4)*$10000,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.w	#p1lin,d0
	swap	d0
	move.w	p1hz,d0
	move.l	d0,a1_pixel(a6)		;dst (x,y)
;
;	move.l	#PITCH1|WID40|XADDPIX|PIXEL32,a1_flags(a6)	;quad wide
;	move.l	#PITCH1|WID80|XADDPIX|PIXEL16,a1_flags(a6)	;quad wide
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)	;quad wide

	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;
;
;  Update player1, triple copy - close (NUSIZ=3)
;
playr13:
	lea	BASE,a6
.wtblit:
	move.l	b_cmd(a6),d0	;wait til done
	lsr.l	#1,d0
	bcc	.wtblit
;
	move.l	#0,b_dstd(a6)
	move.l	colup1,b_patd(a6)	;player0 color
;
	move.l	#PITCH1|WID128|XADDPIX|PIXEL1,a2_flags(a6)
	move.l	#((pfbuf*10)+4)*$10000,a2_pixel(a6)
;
;		  height    width
	move.l	#(1*$10000)+8,b_count(a6)
	move.w	#p1lin,d0
	swap	d0
	move.w	p1hz,d0
	move.l	d0,a1_pixel(a6)		;dst (x,y)
;
	move.l	#PITCH1|WID160|XADDPIX|PIXEL8,a1_flags(a6)	;quad wide

	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	addq.l	#8,d0
	addq.l	#8,d0
.watblit:
	move.l	b_cmd(a6),d1	;wait til done
	lsr.l	#1,d1
	bcc	.watblit
;
	move.l	#((pfbuf*10)+4)*$10000,a2_pixel(a6)

	move.l	#(1*$10000)+8,b_count(a6)
	move.l	d0,a1_pixel(a6)		;dst (x,y)
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit

	addq.l	#8,d0
	addq.l	#8,d0
.wutblit:
	move.l	b_cmd(a6),d1	;wait til done
	lsr.l	#1,d1
	bcc	.wutblit
;
	move.l	#((pfbuf*10)+4)*$10000,a2_pixel(a6)

	move.l	#(1*$10000)+8,b_count(a6)
	move.l	d0,a1_pixel(a6)		;dst (x,y)
	move.l	#SRCEN|BCOMPEN|BKGWREN|LFU_S|PATDSEL,b_cmd(a6) ;do the blit
;
	rts
;
;
;----------------------------------------------------------
;
;  Object type (Bits 0-2 in 1st 64-bit phrase of object)
; 
BMAPTYP		equ	0	;Bit-Map object
SCALTYP		equ	1	;Scaled Bit-Map object
GPUTYP		equ	2	;Graphics Processor interrupt Object
BRTYP		equ	3	;Branch Object
STOPTYP		equ	4	;Stop Object
;
;
;
;
;   Rom copy of the Object list
;
dlistROM:

OBJTYPE		set	BRTYP	;1st object is a BR object
BCC		set	1	;Br Condition Code (br if YPOS=<VC)
YPOS		set	21	;top branch object
	dc.w	0
	dc.l	(dlist+16) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
YPOS		set	519	;bottom branch object
	dc.w	0
	dc.l	(dlist+32) << 5
	dc.w	(BCC << 14) + (YPOS << 3) + OBJTYPE	;
;
	dc.l	0,STOPTYP
	dc.l	0,STOPTYP
;
;
OBJTYPE		set	BMAPTYP	;1st object is a Scaled Bit-Map object
HEIGHT		set	212*2	;fill the screen
YPOS		set	55	;from the top
XPOS		set	16	;from the left edge
FIRSTPIX	set	0	;no left edge clipping
RELEASE		set	0	;release bus between image data fetches
TRANSPAR	set	0	;make logical color 0 transparent
RMW		set	0	;no read-modify-write
REFLECT		set	0	;no horizontal reflect
INDEX		set	0	;palette offset if 1-4 bits/pix
IWIDTH		set	20	;20 phrases in displayed image
DWIDTH		set	20	;20 phrases in source form
PITCH		set	1	;increment by 1 phrase for next fetch
DEPTH		set	3	;8 bits/pixel (2 color)
;
;  1st Object is a vanilla Bit-map, so it needs a 2 phrase header
;
;  1st phrase
 dc.l	(image << 8) + ((dlist+48) >> 11)
 dc.l	((dlist+48) << 21) + (HEIGHT << 13) + (YPOS << 3) + OBJTYPE 
;
;  2nd phrase
 dc.w (FIRSTPIX << 1) + RELEASE
 dc.w (TRANSPAR << 15) + (RMW << 14) + (REFLECT <<13) + (INDEX << 6) + (IWIDTH >> 4)
 dc.w ((IWIDTH & $0F) << 12) + (DWIDTH << 2) + (PITCH & $06)
 dc.w ((PITCH & 1) << 15) + (DEPTH << 12) + XPOS
;
 dc.l	0,STOPTYP,0,STOPTYP
;
;
;
	.bss
;
;
p0hz:
	ds.w	1
p1hz:
	ds.w	1
m0hz:
	ds.w	1
m1hz:
	ds.w	1
ballhz:
	ds.w	1
;
hmovep0:
	ds.w	1
hmovep1:
	ds.w	1
hmovem0:
	ds.w	1
hmovem1:
	ds.w	1
hmovebl:
	ds.w	1
;
;
grp0d:
	ds.b	1		;vdel0 graphics reg
grp1d:
	ds.b	1		;vdel1 graphics reg
;
;
;collision:
;	ds.b	160
;
;
;pf0:
;	ds.l	2		;PF0
;pf1:
;	ds.l	2		;PF1
;pf2:
;	ds.l	2		;PF2
;
;
colup0:
	ds.l	1
colup1:
	ds.l	1
colupf:
	ds.l	1
colubk:
	ds.l	1
;
;
;
joycur:
	ds.l	4
oldjoy:
	ds.l	4
fcount:
	ds.l	1
;
;
;	
;
TIACHG:
	ds.w	1
;
;
;
cycount:
	ds.w	1	;cycle count
linecnt:
	ds.w	1	;line # last displayed
prevpix:
	ds.w	1	;pixel # last displayed
;
oldvsync:
	ds.w	1	;previously recorded vsync
;
;
;
;
;
;  Stella Address Space here...
;
;
zerop:
VSYNC:	.DS.B	1	; BIT	     1	VERTICAL SYNC SET-CLR
VBLANK:	.DS.B	1	; BIT	     1	VERTICAL BLANK SET-CLR
WSYNC:	.DS.B	1	; STROBE	WAIT FOR HORIZ BLANK
RSYNC:	.DS.B	1	; STROBE	RESET HORIZ SYNC COUNTER
NUSIZ0:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 0
NUSIZ1:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 1
COLUP0:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 0
COLUP1:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 1
COLUPF:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYFIELD
COLUBK:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) BACKGROUND
CTRLPF:	.DS.B	1	; BITS 7 54 210	PLAYFIELD CONTROL
REFP0:	.DS.B	1	; BIT      3	REFLECT PLAYER 0
REFP1:	.DS.B	1	; BIT      3	REFLECT PLAYER 1
PF0:	.DS.B	1	; BITS 7654	PLAYFIELD REG BYTE 0
PF1:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 1
PF2:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 2
RESP0:	.DS.B	1	; STROBE	RESET PLAYER 0
RESP1:	.DS.B	1	; STROBE	RESET PLAYER 1
RESM0:	.DS.B	1	; STROBE	RESET MISSILE 0
RESM1:	.DS.B	1	; STROBE	RESET MISSILE 1
RESBL:	.DS.B	1	; STROBE	RESET BALL
AUDC0:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 0
AUDC1:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 1
AUDF0:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 0
AUDF1:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 1
AUDV0:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 0
AUDV1:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 1
GRP0:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 0
GRP1:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 1
ENAM0:	.DS.B	1	; BIT	     1	ENABLE MISSILE 0
ENAM1:	.DS.B	1	; BIT	     1	ENABLE MISSILE 1
ENABL:	.DS.B	1	; BIT	     1	ENABLE BALL
HMP0:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 0
HMP1:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 1
HMM0:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 0
HMM1:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 1
HMBL:	.DS.B	1	; BITS 7654	HORIZ MOTION BALL
VDELP0:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 0
VDELP1:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 1
VDELBL:	.DS.B	1	; BIT	      0	VERTICAL DELAY BALL
RESMP0:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 0
RESMP1:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 1
HMOVE:	.DS.B	1	; STROBE	ACT ON HORIZ MOTION
HMCLR:	.DS.B	1	; STROBE	CLEAR ALL HM REGISTERS
CXCLR:	.DS.B	1	; STROBE	CLEAR COLLISION LATCHES
	.DS.B	3
*
*  READ ADDRESSES -	BIT 7	BIT 6 (ONLY)
*
CXM0P:	.DS.B	1	;M0.P1	M0.P0
CXM1P:	.DS.B	1	;M1.P0	M1.P1
CXP0FB:	.DS.B	1	;P0.PF	P0.BL
CXP1FB:	.DS.B	1	;P1.PF	P1.BL
CXM0FB:	.DS.B	1	;M0.PF	M0.BL
CXM1FB:	.DS.B	1	;M1.PF	M1.BL
CXBLPF:	.DS.B	1	;BL.PF	NOT USED
CXPPMM:	.DS.B	1	;P0.P1	M0.M1
*
*  PADDLE INPUT PORTS..
*
INPT0:	.DS.B	1
INPT1:	.DS.B	1
INPT2:	.DS.B	1
INPT3:	.DS.B	1
*
*
INPT4:	.DS.B	1	;D7=0 WHEN LEFT JOYSTICK FIREBUTTON PRESSED
INPT5:	.DS.B	1	;D7=0 WHEN RITE JOYSTICK FIREBUTTON PRESSED
*
	ds.b	$242
;
SWCHA:	.DS.B	1	;P0,P1 JOYSTICKS
*
*	LEFT RITE
*	7654 3210
*	---- ----
*	RLDU RLDU
*
CTLSWA:	.DS.B	1	;SWCHA DATA DIRECTION (0=INPUT)
*
SWCHB:	.DS.B	1	;CONSOLE SWITCHES
*
*	D7-RITE DIFFICULTY
*	D6-LEFT DIFFICULTY
*	D5/D4 NOT USED
*	D3-COLOR - B/W
*	D2-NOT USED
*	D1-GAME SELECT
*	D0-GAME RESET
;
CTLSWB:	.DS.B	1	;SWCHB DATA DIRECTION (0=INPUT)
;
INTIM:	.DS.B	1	;INTERVAL TIMER READ
	.DS.B	15
TIM1T:	.DS.B	1	;SET 1    CLK INTERVAL (838   NSEC/INTERVAL)
TIM8T:	.DS.B	1	;SET 8    CLK INTERVAL (6.7   USEC/INTERVAL)
TIM64T:	.DS.B	1	;SET 64   CLK INTERVAL (53.6  USEC/INTERVAL)
T1024T:	.DS.B	1	;SET 1024 CLK INTERVAL (858.2 USEC/INTERVAL)

	ds.b	$1000-$298
gamerom:
	ds.b	$1000
