;
;
;
;
;  Macros for addressing modes
;
;
;  "zero page"
;
;  use (a0,d1.w) to access data
;
	.macro	zpage
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	.endm
;
;
;  "zero page by x" use (a0,d1.w) to access data
	.macro	zpagex
	moveq	#0,d1
	move.b	1(a0,d0.w),d1
	add.b	d5,d1
	.endm
;
;
;  "zero page by y" use (a0,d1.w) to access data
	.macro	zpagey
	moveq	#0,d1
	move.b	1(a0,d0.w),d1
	add.b	d6,d1
	.endm
	

;
;  "immediate"  data in d1
	.macro	immed
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	.endm
;
;
;  "absolute" use (a0,d1.w) to access data
;
	.macro	absol
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	.endm
;
;
;  "absolute by X" use (a0,d1.w) to access data
;
	.macro	absolx
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	move.w	d1,d0		;need to check page boundary crossing
	add.w	d5,d1		;add x
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.w	#1,(a4)		;page boundary crossing adds a cycle
.a\~:
	.endm
;
;  "absolute by Y" use (a0,d1.w) to access data
;
	.macro	absoly
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1
	andi.w	#$1fff,d1
	move.w	d1,d0		;need to check page boundary crossing
	add.w	d6,d1		;add y
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.w	#1,(a4)		;page boundary crossing adds a cycle
.a\~:
	.endm
;
;  "Indirect by Y"  use (a0,d1.w) to access data
;
	.macro	indy
	moveq	#0,d1
	move.b	1(a0,d0.w),d1	;get n
	move.b	2(a0,d1.w),d0	;get HI
	lsl.w	#8,d0
	move.b	1(a0,d1.w),d0	; & LO
	andi.w	#$1fff,d0
	move.w	d0,d1		;need to check page boundary crossing
	add.w	d6,d1		;add y
	eor.w	d1,d0
	btst	#8,d0
	beq.s	.a\~		;br if no page boundary crossing
	addq.w	#1,(a4)		;page boundary crossing adds a cycle
.a\~:
	.endm


;
;  "indirect by X"
;
;  use (a0,d0.w) to access data
;
	.macro	indx
	moveq	#0,d1		;(n,X)
	move.b	1(a0,d0.w),d1	;get n
	add.b	d5,d1		;add x
	move.b	1(a0,d1.w),d0	;get HI, eff addr
	lsl.w	#8,d0
	move.b	(a0,d1.w),d0	;then LO
	.endm
;
;
;
;  flags N & Z updated
	.macro	flagnz
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	.endm

;
;
;
;  flags N & Z & C updated

	.macro	flagnzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcc.s	.c\~
	bset	#0,d7		;set C flag
.c\~:
	.endm
;
;
;  flags N & V & Z & C updated

	.macro	flagnvzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcc.s	.c\~
	bset	#0,d7		;set C flag
.c\~:
	bvc.s	.d\~
	bset	#6,d7		;set V flag
.d\~:
	.endm
;
;
;  flags N & V & Z & C updated after subtract

	.macro	subnvzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcs.s	.c\~
	bset	#0,d7		;set not C flag
.c\~:
	bvc.s	.d\~
	bset	#6,d7		;set V flag
.d\~:
	.endm
;
;
;  flags N & Z & C updated after compare

	.macro	cmpnzc
	bne.s	.a\~
	bset	#1,d7		;set Z flag (doesn't affect 68k N flag)
.a\~:
	bpl.s	.b\~
	bset	#7,d7		;set N flag
.b\~:
	bcs.s	.c\~
	bset	#0,d7		;set not C flag
.c\~:
	.endm
;
;
;  Branch if flag is clear
;
	.macro	brbitclr

	bne.s	.b\~		;br if not taken
	move.b	1(a0,d0.w),d1
	move.w	d2,d0
	ext.w	d1
	add.w	d1,d2		;adjust PC
	moveq	#1,d1		;assume no page boundary crossing
	eor.w	d2,d0
	btst	#8,d0		;cross page boundary?
	beq.s	.a\~
	addq	#2,d1
.a\~:
	add.w	d1,(a4)		;advance cycle count
.b\~:
	.endm
;
;
;  Branch if flag is set
;
	.macro	brbitset

	beq.s	.b\~		;br if not taken
	move.b	1(a0,d0.w),d1
	move.w	d2,d0
	ext.w	d1
	add.w	d1,d2		;adjust PC
	moveq	#1,d1		;assume no page boundary crossing
	eor.w	d2,d0
	btst	#8,d0		;cross page boundary?
	beq.s	.a\~
	addq	#2,d1
.a\~:
	add.w	d1,(a4)		;advance cycle count
.b\~:
	.endm
;
;
;
;
;
;
;
;
;
;  1st stab at 6502 Emulator
;
;
start:
	lea	zerop,a0
	moveq	#-1,d0
	move.w	#$400-1,d1		;-1 to 0xxx
initer:
	move.l	d0,(a0)+
	dbra	d1,initer
;
;
;
	lea	demon,a0
	lea	gamerom,a1
	move.w	#$400-1,d0
looper:
	move.l	(a0)+,(a1)+
	dbra	d0,looper
;
	lea	zerop,a0	;base address of stella
	lea	disp,a1		;base address of opcode dispatch
	lea	retv,a2		;return here
	lea	cyclez,a3	;table of cycle counts
	lea	cycount,a4
	clr.w	(a4)
	lea	bytcount,a5	;table of opcode sizes (in bytes)
;
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
;
	bset	#2,d7		;reset sets I Flag to 1


	move.w	#$1ffc,d2	;pc
	move.w	(a0,d2.w),d2	;reset vector
	rol.w	#8,d2		;big Endian for 68k
;
tstart:
	move.l	#-1,$f00050	;start PIT
retv:
	move.w	d2,d0
	andi.w	#$1fff,d0	;
;
;d0 temp (68k PC)
;d1 temp
;
;d2 = pc
;d3 = sp
;d4 = accum
;d5 = x
;d6 = y
;d7 = flags
;
	moveq	#0,d1
	move.b	(a0,d0.w),d1	;fetch next opcode
	lsl.w	#1,d1		;*2
	swap	d0
	move.w	(a3,d1.w),d0
	add.w	d0,(a4)		;advance cycle counter
	swap	d0
	add.w	(a5,d1.w),d2	;advance PC
	move.w	(a1,d1.w),d1
	jmp	(a1,d1.w)
;
;
;
;
disp:
	dc.w	op00-disp
	dc.w	op01-disp
	dc.w	op02-disp
	dc.w	op03-disp
	dc.w	op04-disp
	dc.w	op05-disp
	dc.w	op06-disp
	dc.w	op07-disp
	dc.w	op08-disp
	dc.w	op09-disp
	dc.w	op0A-disp
	dc.w	op0B-disp
	dc.w	op0C-disp
	dc.w	op0D-disp
	dc.w	op0E-disp
	dc.w	op0F-disp
;	
	dc.w	op10-disp
	dc.w	op11-disp
	dc.w	op12-disp
	dc.w	op13-disp
	dc.w	op14-disp
	dc.w	op15-disp
	dc.w	op16-disp
	dc.w	op17-disp
	dc.w	op18-disp
	dc.w	op19-disp
	dc.w	op1A-disp
	dc.w	op1B-disp
	dc.w	op1C-disp
	dc.w	op1D-disp
	dc.w	op1E-disp
	dc.w	op1F-disp
;	
	dc.w	op20-disp
	dc.w	op21-disp
	dc.w	op22-disp
	dc.w	op23-disp
	dc.w	op24-disp
	dc.w	op25-disp
	dc.w	op26-disp
	dc.w	op27-disp
	dc.w	op28-disp
	dc.w	op29-disp
	dc.w	op2A-disp
	dc.w	op2B-disp
	dc.w	op2C-disp
	dc.w	op2D-disp
	dc.w	op2E-disp
	dc.w	op2F-disp
;	
	dc.w	op30-disp
	dc.w	op31-disp
	dc.w	op32-disp
	dc.w	op33-disp
	dc.w	op34-disp
	dc.w	op35-disp
	dc.w	op36-disp
	dc.w	op37-disp
	dc.w	op38-disp
	dc.w	op39-disp
	dc.w	op3A-disp
	dc.w	op3B-disp
	dc.w	op3C-disp
	dc.w	op3D-disp
	dc.w	op3E-disp
	dc.w	op3F-disp
;	
	dc.w	op40-disp
	dc.w	op41-disp
	dc.w	op42-disp
	dc.w	op43-disp
	dc.w	op44-disp
	dc.w	op45-disp
	dc.w	op46-disp
	dc.w	op47-disp
	dc.w	op48-disp
	dc.w	op49-disp
	dc.w	op4A-disp
	dc.w	op4B-disp
	dc.w	op4C-disp
	dc.w	op4D-disp
	dc.w	op4E-disp
	dc.w	op4F-disp
;	
	dc.w	op50-disp
	dc.w	op51-disp
	dc.w	op52-disp
	dc.w	op53-disp
	dc.w	op54-disp
	dc.w	op55-disp
	dc.w	op56-disp
	dc.w	op57-disp
	dc.w	op58-disp
	dc.w	op59-disp
	dc.w	op5A-disp
	dc.w	op5B-disp
	dc.w	op5C-disp
	dc.w	op5D-disp
	dc.w	op5E-disp
	dc.w	op5F-disp
;	
	dc.w	op60-disp
	dc.w	op61-disp
	dc.w	op62-disp
	dc.w	op63-disp
	dc.w	op64-disp
	dc.w	op65-disp
	dc.w	op66-disp
	dc.w	op67-disp
	dc.w	op68-disp
	dc.w	op69-disp
	dc.w	op6A-disp
	dc.w	op6B-disp
	dc.w	op6C-disp
	dc.w	op6D-disp
	dc.w	op6E-disp
	dc.w	op6F-disp
;	
	dc.w	op70-disp
	dc.w	op71-disp
	dc.w	op72-disp
	dc.w	op73-disp
	dc.w	op74-disp
	dc.w	op75-disp
	dc.w	op76-disp
	dc.w	op77-disp
	dc.w	op78-disp
	dc.w	op79-disp
	dc.w	op7A-disp
	dc.w	op7B-disp
	dc.w	op7C-disp
	dc.w	op7D-disp
	dc.w	op7E-disp
	dc.w	op7F-disp
;	
	dc.w	op80-disp
	dc.w	op81-disp
	dc.w	op82-disp
	dc.w	op83-disp
	dc.w	op84-disp
	dc.w	op85-disp
	dc.w	op86-disp
	dc.w	op87-disp
	dc.w	op88-disp
	dc.w	op89-disp
	dc.w	op8A-disp
	dc.w	op8B-disp
	dc.w	op8C-disp
	dc.w	op8D-disp
	dc.w	op8E-disp
	dc.w	op8F-disp
;	
	dc.w	op90-disp
	dc.w	op91-disp
	dc.w	op92-disp
	dc.w	op93-disp
	dc.w	op94-disp
	dc.w	op95-disp
	dc.w	op96-disp
	dc.w	op97-disp
	dc.w	op98-disp
	dc.w	op99-disp
	dc.w	op9A-disp
	dc.w	op9B-disp
	dc.w	op9C-disp
	dc.w	op9D-disp
	dc.w	op9E-disp
	dc.w	op9F-disp
;	
	dc.w	opA0-disp
	dc.w	opA1-disp
	dc.w	opA2-disp
	dc.w	opA3-disp
	dc.w	opA4-disp
	dc.w	opA5-disp
	dc.w	opA6-disp
	dc.w	opA7-disp
	dc.w	opA8-disp
	dc.w	opA9-disp
	dc.w	opAA-disp
	dc.w	opAB-disp
	dc.w	opAC-disp
	dc.w	opAD-disp
	dc.w	opAE-disp
	dc.w	opAF-disp
;	
	dc.w	opB0-disp
	dc.w	opB1-disp
	dc.w	opB2-disp
	dc.w	opB3-disp
	dc.w	opB4-disp
	dc.w	opB5-disp
	dc.w	opB6-disp
	dc.w	opB7-disp
	dc.w	opB8-disp
	dc.w	opB9-disp
	dc.w	opBA-disp
	dc.w	opBB-disp
	dc.w	opBC-disp
	dc.w	opBD-disp
	dc.w	opBE-disp
	dc.w	opBF-disp
;	
	dc.w	opC0-disp
	dc.w	opC1-disp
	dc.w	opC2-disp
	dc.w	opC3-disp
	dc.w	opC4-disp
	dc.w	opC5-disp
	dc.w	opC6-disp
	dc.w	opC7-disp
	dc.w	opC8-disp
	dc.w	opC9-disp
	dc.w	opCA-disp
	dc.w	opCB-disp
	dc.w	opCC-disp
	dc.w	opCD-disp
	dc.w	opCE-disp
	dc.w	opCF-disp
;	
	dc.w	opD0-disp
	dc.w	opD1-disp
	dc.w	opD2-disp
	dc.w	opD3-disp
	dc.w	opD4-disp
	dc.w	opD5-disp
	dc.w	opD6-disp
	dc.w	opD7-disp
	dc.w	opD8-disp
	dc.w	opD9-disp
	dc.w	opDA-disp
	dc.w	opDB-disp
	dc.w	opDC-disp
	dc.w	opDD-disp
	dc.w	opDE-disp
	dc.w	opDF-disp
;	
	dc.w	opE0-disp
	dc.w	opE1-disp
	dc.w	opE2-disp
	dc.w	opE3-disp
	dc.w	opE4-disp
	dc.w	opE5-disp
	dc.w	opE6-disp
	dc.w	opE7-disp
	dc.w	opE8-disp
	dc.w	opE9-disp
	dc.w	opEA-disp
	dc.w	opEB-disp
	dc.w	opEC-disp
	dc.w	opED-disp
	dc.w	opEE-disp
	dc.w	opEF-disp
;	
	dc.w	opF0-disp
	dc.w	opF1-disp
	dc.w	opF2-disp
	dc.w	opF3-disp
	dc.w	opF4-disp
	dc.w	opF5-disp
	dc.w	opF6-disp
	dc.w	opF7-disp
	dc.w	opF8-disp
	dc.w	opF9-disp
	dc.w	opFA-disp
	dc.w	opFB-disp
	dc.w	opFC-disp
	dc.w	opFD-disp
	dc.w	opFE-disp
	dc.w	opFF-disp
;
;
;d0 opcode address (68k fixed)
;d1 opcode *2
;
;d2 = pc
;d3 = sp
;d4 = accum
;d5 = x
;d6 = y
;d7 = flags
;
;	
op00:				;BRK
	move.l	d0,a6
	move.l	$f00050,d0
	swap	d0
	neg.l	d0
	exg.l	d0,a6

	illegal			;***temp

	bset	#4,d7		;set Break flag
	move.w	d2,d0
	addq.w	#1,d0
	rol.w	#8,d0		;LO:HI
	move.b	d0,(a0,d3.w)	;push hi byte
	subq.b	#1,d3		;SP-1 -> SP
	rol.w	#8,d0		;HI:LO
	move.b	d0,(a0,d3.w)	;push lo byte
	subq.b	#1,d3
	move.b	d7,(a0,d3.w)	;push P
	subq.b	#1,d3
;
	move.w	#$1ffe,d0
	move.w	(a0,d0.w),d2
	rol.w	#8,d2
	move.w	#$1fff,d0
	and.w	d2,d0
	jmp	(a2)	
;
;
;
op01:				;ORA (n,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	or.b	(a0,d0.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
;
op02:
op03:
op04:
op07:
op0B:
op0C:
op0F:
op12:
op13:
op14:
op17:
op1A:
op1B:
op1C:
op1F:
op22:
op23:
op27:
op2B:
op2F:
op32:
op33:
op34:
op37:
op3A:
op3B:
op3C:
op3F:
op42:
op43:
op44:
op47:
op4B:
op4F:
op52:
op53:
op54:
op57:
op5A:
op5B:
op5C:
op5F:
op62:
op63:
op64:
op67:
op6B:
op6F:
op72:
op73:
op74:
op77:
op7A:
op7B:
op7C:
op7F:
op80:
op82:
op83:
op87:
op89:
op8B:			
op8F:
op92:
op93:
op97:
op9B:			
op9C:
op9E:
op9F:
opA3:
opA7:
opAB:
opAF:
opB2:
opB3:
opB7:
opBB:
opBF:
opC2:
opC3:
opC7:
opCB:
opCF:
opD2:
opD3:
opD4:
opD7:
opDA:
opDB:
opDC:
opDF:
opE2:
opE3:
opE7:
opEB:
opEF:
opF2:
opF3:
opF4:
opF7:
opFA:
opFB:
opFC:
opFF:
	illegal			;we never want to get here
;
;
op05:				;ORA n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op06:				;ASL n
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	zpage
	move.b	(a0,d1.w),d0
	asl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op08:				;PHP
	move.b	d7,(a0,d3.w)	;push FLAGS byte
	subq.b	#1,d3		;SP-1 -> SP
	jmp	(a2)
;
;
op09:				;ORA #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	or.b	d1,d4		;ORA to accum
	flagnz
	jmp	(a2)
;
;
op0A:				;ASL a
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	asl.b	#1,d4	
	flagnzc
	jmp	(a2)
;
;
op0D:				;ORA nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op0E:				;ASL nn
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	absol

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)

	flagnz
	jmp	(a2)
;
;	
op10:				;BPL
	btst	#7,d7		;check N flag
	brbitclr
	jmp	(a2)	
;
;
op11:				;ORA (n),y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op15:				;ORA n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op16:				;ASL n,X
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	zpagex

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)

	flagnzc
	jmp	(a2)
;
;
op18:				;CLC
	bclr	#0,d7
	jmp	(a2)
;
;
op19:				;ORA nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op1D:				;ORA nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	or.b	(a0,d1.w),d4	;ORA to accum
	flagnz
	jmp	(a2)
;
;
op1E:				;ASL nn,X
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	absolx

	move.b	(a0,d1.w),d0
	asl.b	#1,d0		;ASL
	move.b	d0,(a0,d1.w)

	flagnzc
	jmp	(a2)
;
;

op20:				;JSR nn
	move.w	d2,d1		;get return address
	move.b	2(a0,d0.w),d2
	lsl.w	#8,d2
	move.b	1(a0,d0.w),d2	;new jump address

	subq.w	#1,d1		;push return address -1
	rol.w	#8,d1		;LO:HI
	move.b	d1,(a0,d3.w)	;push hi byte
	subq.b	#1,d3		;SP-1 -> SP
	rol.w	#8,d1		;HI:LO
	move.b	d1,(a0,d3.w)	;push lo byte
	subq.b	#1,d3
;
	jmp	(a2)	
;
;
op21:				;AND (x,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	and.b	(a0,d0.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op24:				;BIT n
	zpage
	move.b	(a0,d1.w),d0	;fetch data
	move.w	d0,d1		;copy
	andi.w	#%00111101,d7	;clear N & V & Z
	andi.w	#%11000000,d0	;copy N & V to flags
	or.w	d0,d7		;
	and.b	d4,d1		;check AND result
	bne.s	op24x
	ori.w	#%00000010,d7	;set Z flag if EQ
op24x:
	jmp	(a2)
;
;
op25:				;AND n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op26:				;ROL n
	zpage
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;	
op28:				;PLP
	addq.w	#1,d3
	move.b	(a0,d3.w),d7
	jmp	(a2)
;
;
op29:				;AND #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	and.b	d1,d4		;AND to accum
	flagnz
	jmp	(a2)
;
;
op2A:				;ROL a
	move.w	d7,d1
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.w	#1,d1
	roxl.b	#1,d4	
	flagnzc
	jmp	(a2)
;
;
op2C:				;BIT nn
	absol
	move.b	(a0,d1.w),d0	;fetch data
	move.w	d0,d1		;copy
	andi.w	#%00111101,d7	;clear N & V & Z
	andi.w	#%11000000,d0	;copy N & V to flags
	or.w	d0,d7		;
	and.b	d4,d1		;check AND result
	bne.s	op2Cx
	ori.w	#%00000010,d7	;set Z flag if EQ
op2Cx:
	jmp	(a2)
;
;
op2D:				;AND nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op2E:				;ROL nn
	absol
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op30:				;BMI
	btst	#7,d7		;check N flag
	brbitset
	jmp	(a2)	
;
;
op31:				;AND (n),Y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op35:				;AND n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op36:				;ROL n,X
	zpagex
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op38:				;SEC
	bset	#0,d7
	jmp	(a2)
;
;
op39:				;AND nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op3D:				;AND nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	and.b	(a0,d1.w),d4	;AND to accum
	flagnz
	jmp	(a2)
;
;
op3E:				;ROL xx,X
	absolx
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxl.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op40:				;RTI
	addq.b	#1,d3
	move.b	(a0,d3.w),d7	;pop FLAGS
	addq.b	#1,d3
	move.b	(a0,d3.w),d0
	addq.b	#1,d3
	move.b	(a0,d3.w),d2
	lsl.w	#8,d2
	move.b	d0,d2
	jmp	(a2)
;
;
op41:				;EOR (n,X)
	andi.w	#%01111101,d7	;clear N & Z flags
	indx
	move.b	(a0,d0.w),d1
	eor.b	d1,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op45:				;EOR n
	andi.w	#%01111101,d7	;clear N & Z flags
	zpage
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op46:				;LSR n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	zpage
	move.b	(a0,d1.w),d0
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op48:				;PHA
	move.b	d4,(a0,d3.w)	;push accum
	subq.b	#1,d3		;SP-1 -> SP
	jmp	(a2)
;
;
op49:				;EOR #n
	andi.w	#%01111101,d7	;clear N & Z flags
	immed
	eor.b	d1,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op4A:				;LSR a
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.b	#1,d4	
	flagnzc
	jmp	(a2)
;
;
op4C:				;JMP nn
	move.b	2(a0,d0.w),d2
	lsl.w	#8,d2
	move.b	1(a0,d0.w),d2	;new jump address
	jmp	(a2)
;
;
op4D:				;EOR nn
	andi.w	#%01111101,d7	;clear N & Z flags
	absol
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op4E:				;LSR nn
	absol
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op50:				;BVC
	btst	#6,d7		;check V flag
	brbitclr
	jmp	(a2)	
;
;
op51:				;EOR (n),Y
	andi.w	#%01111101,d7	;clear N & Z flags
	indy
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op55:				;EOR n,X
	andi.w	#%01111101,d7	;clear N & Z flags
	zpagex

	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op56:				;LSR n,X
	zpagex
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op58:				;CLI
	bclr	#2,d7
	jmp	(a2)
;
;
op59:				;EOR nn,Y
	andi.w	#%01111101,d7	;clear N & Z flags
	absoly
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op5D:				;EOR nn,X
	andi.w	#%01111101,d7	;clear N & Z flags
	absolx
	move.b	(a0,d1.w),d0
	eor.b	d0,d4		;EOR to accum
	flagnz
	jmp	(a2)
;
;
op5E:				;LSR nn,X
	absolx
	move.b	(a0,d1.w),d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op60:				;RTS
	addq.b	#1,d3
	move.b	(a0,d3.w),d0
	addq.b	#1,d3
	move.b	(a0,d3.w),d2
	lsl.w	#8,d2
	move.b	d0,d2
	addq.w	#1,d2
	jmp	(a2)
;
;
op61:				;ADC (n,X)
	indx
	move.w	d7,d1
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op61d		;br if so
	addx.b	d1,d4	
	bra.s	op61x	
op61d:
	abcd	d1,d4		;decimal mode
op61x:
	flagnvzc
	jmp	(a2)
;
;
op65:				;ADC n
	zpage
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op65d		;br if so
	addx.b	d0,d4	
	bra.s	op65x	
op65d:
	abcd	d0,d4		;decimal mode
op65x:
	flagnvzc
	jmp	(a2)
;
;
op66:				;ROR n
	zpage
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op68:				;PLA
	addq.b	#1,d3
	move.b	(a0,d3.w),d4
	flagnz
	jmp	(a2)
;
;
op69:				;ADC #n
	immed
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	btst	#3,d7		;in Decimal mode?
	bne.s	op69d		;br if so
	addx.b	d1,d4	
	bra.s	op69x	
op69d:
	abcd	d1,d4		;decimal mode
op69x:
	flagnvzc
	jmp	(a2)
;
;
op6A:				;ROR a
	move.w	d7,d1
	andi.w	#%01111100,d7	;clear N, Z, & C flags
	lsr.w	#1,d1
	roxr.b	#1,d4	
	flagnzc
	jmp	(a2)
;
;
op6C:				;JMP (nn)
	move.b	2(a0,d0.w),d1	;get HI
	lsl.w	#8,d1
	move.b	1(a0,d0.w),d1	;now LO
	addq.b	#1,d1		;this mimics vector on pg boundary bug
	move.b	(a0,d1.w),d2	;get HI
	lsl.w	#8,d2
	subq.b	#1,d1
	move.b	(a0,d1.w),d2	;new PC, let's jump
	jmp	(a2)
;
;
;	
op6D:				;ADC nn
	absol
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op6Dd		;br if so
	addx.b	d0,d4	
	bra.s	op6Dx	
op6Dd:
	abcd	d0,d4		;decimal mode
op6Dx:
	flagnvzc
	jmp	(a2)
;
;
op6E:				;ROR nn
	absol
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op70:				;BVS
	btst	#6,d7		;check V flag
	brbitset
	jmp	(a2)	
;
;
op71:				;ADC (n),Y
	indy
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op71d		;br if so
	addx.b	d0,d4	
	bra.s	op71x	
op71d:
	abcd	d0,d4		;decimal mode
op71x:
	flagnvzc
	jmp	(a2)
;
;
op75:				;ADC n,X
	zpagex
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op75d		;br if so
	addx.b	d0,d4	
	bra.s	op75x	
op75d:
	abcd	d0,d4		;decimal mode
op75x:
	flagnvzc
	jmp	(a2)
;
;
op76:				;ROR n,X
	zpagex
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op78:
	bset	#2,d7		;SEI
	jmp	(a2)
;
;
op79:				;ADC nn,Y
	absoly
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op79d		;br if so
	addx.b	d0,d4	
	bra.s	op79x	
op79d:
	abcd	d0,d4		;decimal mode
op79x:
	flagnvzc
	jmp	(a2)
;
;
op7D:				;ADC nn,x
	absolx
	move.w	d7,d0
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	op7Dd		;br if so
	addx.b	d0,d4	
	bra.s	op7Dx	
op7Dd:
	abcd	d0,d4		;decimal mode
op7Dx:
	flagnvzc
	jmp	(a2)
;
;
op7E:				;ROR nn,X
	absolx
	move.b	(a0,d1.w),d0
	swap	d0
	move.w	d7,d0
	andi.w	#%01111100,d7	;clear N & Z & C flags
	lsr.w	#1,d0
	swap	d0
	roxr.b	#1,d0
	move.b	d0,(a0,d1.w)
	flagnzc
	jmp	(a2)
;
;
op81:				;STA (n,X)
	indx
	move.b	d4,(a0,d0.w)
	jmp	(a2)
;
;
op84:				;STY n
	zpage
	move.b	d6,(a0,d1.w)
	jmp	(a2)
;
;
op85:				;STA n
	zpage
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;	
;
op86:				;STX n
	zpage
	move.b	d5,(a0,d1.w)
	jmp	(a2)
;
;	
op88:				;DEY
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,d6
	flagnz
	jmp	(a2)
;
;

op8A:				;TXA
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d5,d4
	flagnz
	jmp	(a2)
;
;
op8C:				;STY nn
	absol
	move.b	d6,(a0,d1.w)
	jmp	(a2)
;
;
op8D:				;STA nn
	absol
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;
;
op8E:				;STX nn
	absol
	move.b	d5,(a0,d1.w)
	jmp	(a2)
;
;
op90:				;BCC
	btst	#0,d7		;check C flag
	brbitclr
	jmp	(a2)	
;
;
op91:				;STA (n),Y
	indy
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;
;
op94:				;STY n,X
	zpagex
	move.b	d6,(a0,d1.w)
	jmp	(a2)
;
;
op95:				;STA n,X
	zpagex
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;
;
op96:				;STX n,Y
	zpagey
	move.b	d5,(a0,d1.w)
	jmp	(a2)
;
;
op98:				;TYA
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d6,d4
	flagnz
	jmp	(a2)
;
;
op99:				;STA nn,Y
	absoly
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;
;
op9A:				;TXS
	move.w	d5,d3
	jmp	(a2)
;
;
op9D:				;STA nn,X
	absolx
	move.b	d4,(a0,d1.w)
	jmp	(a2)
;
;
opA0:				;LDY #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d6
	flagnz
	jmp	(a2)
;
;
opA1:				;LDA (n,X)
	indx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d0.w),d4
	flagnz
	jmp	(a2)
;
;
opA2:				;LDX #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d5
	flagnz
	jmp	(a2)
;
;
opA4:				;LDY n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	jmp	(a2)
;
;
opA5:				;LDA n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;
opA6:				;LDX n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	jmp	(a2)
;
;
opA8:				;TAY
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d4,d6
	flagnz
	jmp	(a2)
;
;
opA9:				;LDA #n
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	1(a0,d0.w),d4
	flagnz
	jmp	(a2)
;
;
opAA:				;TAX
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d4,d5
	flagnz
	jmp	(a2)
;
;
opAC:				;LDY nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	jmp	(a2)
;
;
opAD:				;LDA nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;
opAE:				;LDX nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	jmp	(a2)
;
;
opB0:				;BCS
	btst	#0,d7		;check C flag
	brbitset
	jmp	(a2)	
;
;
opB1:				;LDA (n),Y
	indy
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;
opB4:				;LDY nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	jmp	(a2)
;
;
opB5:				;LDA nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;

opB6:				;LDX nn,Y
	absoly
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	jmp	(a2)
;
;
opB8:				;CLV
	bclr	#6,d7
	jmp	(a2)
;
;
opB9:				;LDA nn,Y
	absoly
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;
opBA:				;TSX
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	d3,d5
	flagnz
	jmp	(a2)
;
;
opBC:				;LDY nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d6
	flagnz
	jmp	(a2)
;
;

opBD:				;LDA nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d4
	flagnz
	jmp	(a2)
;
;
opBE:				;LDX nn,Y
	absoly
	andi.w	#%01111101,d7	;clear N & Z flags
	move.b	(a0,d1.w),d5
	flagnz
	jmp	(a2)
;
;
opC0:				;CPY #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d6
	cmpnzc
	jmp	(a2)
;
;
opC1:				;CMP (n,X)
	indx
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d0.w),d4
	cmpnzc
	jmp	(a2)
;
;
opC4:				;CPY n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d6
	cmpnzc
	jmp	(a2)
;
;
opC5:				;CMP n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opC6:				;DEC n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	sub.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opC8:				;INY
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,d6
	flagnz
	jmp	(a2)
;
;
opC9:				;CMP #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d4
	cmpnzc
	jmp	(a2)
;
;
opCA:				;DEX
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,d5
	flagnz
	jmp	(a2)
;
;
opCC:				;CPY nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d6
	cmpnzc
	jmp	(a2)
;
;
opCD:				;CMP nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opCE:				;DEC nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opD0:				;BNE
	btst	#1,d7
	brbitclr
	jmp	(a2)	
;
;
opD1:				;CMP (n),Y
	zpagey
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opD5:				;CMP n,X
	zpagex
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opD6:				;DEC n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opD8:				;CLD
	bclr	#3,d7
	jmp	(a2)
;
;	
opD9:				;CMP nn,Y
	absoly
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opDD:				;CMP nn,X
	absolx
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d4
	cmpnzc
	jmp	(a2)
;
;
opDE:				;DEC nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	subq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opE0:				;CPX #n
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	1(a0,d0.w),d5
	cmpnzc
	jmp	(a2)
;
;
opE1:				;SBC (n,X)
	indx
	move.w	d7,d1
	not.w	d1		;invert CY
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE1d		;br if so
	subx.b	d1,d4	
	bra.s	opE1x	
opE1d:
	sbcd	d1,d4		;decimal mode
opE1x:
	subnvzc
	jmp	(a2)
;
;
opE4:				;CPX n
	zpage
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d5
	cmpnzc
	jmp	(a2)
;
;
opE5:				;SBC n
	zpage
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE5d		;br if so
	subx.b	d0,d4	
	bra.s	opE5x	
opE5d:
	sbcd	d0,d4		;decimal mode
opE5x:
	subnvzc
	jmp	(a2)
;
;
opE6:				;INC n
	zpage
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opE8:				;INX
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,d5
	flagnz
	jmp	(a2)
;
;
opE9:				;SBC #n
	move.w	d7,d1
	not.w	d1		;invert CY
	lsr.w	#1,d1		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	1(a0,d0.w),d1	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opE9d		;br if so
	subx.b	d1,d4	
	bra.s	opE9x	
opE9d:
	sbcd	d1,d4		;decimal mode
opE9x:
	subnvzc
	jmp	(a2)
;
;
opEA:				;NOP
	jmp	(a2)
;
;
opEC:				;CPX nn
	absol
	andi.w	#%01111100,d7	;clear N & Z & C flags
	cmp.b	(a0,d1.w),d5
	cmpnzc
	jmp	(a2)
;
;
opED:				;SBC nn
	absol
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opEDd		;br if so
	subx.b	d0,d4	
	bra.s	opEDx	
opEDd:
	sbcd	d0,d4		;decimal mode
opEDx:
	subnvzc
	jmp	(a2)
;
;
opEE:				;INC nn
	absol
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opF0:				;BEQ
	btst	#1,d7		;check Z flag
	brbitset
	jmp	(a2)	
;
;
opF1:				;SBC (n),Y
	indy
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF1d		;br if so
	subx.b	d0,d4	
	bra.s	opF1x	
opF1d:
	sbcd	d0,d4		;decimal mode
opF1x:
	subnvzc
	jmp	(a2)
;
;
opF5:				;SBC n,X
	zpagex
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF5d		;br if so
	subx.b	d0,d4	
	bra.s	opF5x	
opF5d:
	sbcd	d0,d4		;decimal mode
opF5x:
	subnvzc
	jmp	(a2)
;
;
opF6:				;INC n,X
	zpagex
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
opF8:				;SED
	bset	#3,d7
	jmp	(a2)
;
;
opF9:				;SBC nn,Y
	absoly
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opF9d		;br if so
	subx.b	d0,d4	
	bra.s	opF9x	
opF9d:
	sbcd	d0,d4		;decimal mode
opF9x:
	subnvzc
	jmp	(a2)
;
;
opFD:				;SBC nn,X
	absolx
	move.w	d7,d0
	not.w	d0		;invert CY
	lsr.w	#1,d0		;set X bit from CY
	andi.w	#%00111100,d7	;clear N & V & Z & C flags
	move.b	(a0,d1.w),d0	;fetch operand
	btst	#3,d7		;in Decimal mode?
	bne.s	opFDd		;br if so
	subx.b	d0,d4	
	bra.s	opFDx	
opFDd:
	sbcd	d0,d4		;decimal mode
opFDx:
	subnvzc
	jmp	(a2)
;
;
opFE:				;INC nn,X
	absolx
	andi.w	#%01111101,d7	;clear N & Z flags
	addq.b	#1,(a0,d1.w)
	flagnz
	jmp	(a2)
;
;
;	
;
;  Cycle counts
;
cyclez:
	dc.w	7,6,0,0,0,3,5,0,3,2,5,0,0,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,3,3,5,0,4,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	6,6,0,0,0,3,5,0,3,2,2,0,3,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	6,6,0,0,0,3,5,0,4,2,2,0,5,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0

	dc.w	0,6,0,0,3,3,3,0,2,0,2,0,4,4,4,0
	dc.w	2,6,0,0,4,4,4,0,2,5,2,0,0,4,0,0
	dc.w	2,6,2,0,3,3,3,0,2,2,2,0,4,4,4,0
	dc.w	2,5,0,0,4,4,4,0,2,4,2,0,4,4,4,0

	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
	dc.w	2,6,0,0,3,3,5,0,2,2,2,0,4,4,6,0
	dc.w	2,5,0,0,0,4,6,0,2,4,0,0,0,4,7,0
;	
;  opcode size (in bytes)
;
bytcount:
	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,0,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	3,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	1,2,0,0,0,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

	dc.w	0,2,0,0,2,2,2,0,1,0,1,0,3,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,3,1,0,0,3,0,0
	dc.w	2,2,2,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,3,1,0,3,3,3,0

	dc.w	2,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0
	dc.w	2,2,0,0,2,2,2,0,1,2,1,0,3,3,3,0
	dc.w	2,2,0,0,0,2,2,0,1,3,0,0,0,3,3,0

;
;
	.bss
;
;
cycount:
	ds.w	1	;cycle count
;
zerop:


VSYNC:	.DS.B	1	; BIT	     1	VERTICAL SYNC SET-CLR
VBLANK:	.DS.B	1	; BIT	     1	VERTICAL BLANK SET-CLR
WSYNC:	.DS.B	1	; STROBE	WAIT FOR HORIZ BLANK
RSYNC:	.DS.B	1	; STROBE	RESET HORIZ SYNC COUNTER
NUSIZ0:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 0
NUSIZ1:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 1
COLUP0:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 0
COLUP1:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 1
COLUPF:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYFIELD
COLUBK:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) BACKGROUND
CTRLPF:	.DS.B	1	; BITS 7 54 210	PLAYFIELD CONTROL
REFP0:	.DS.B	1	; BIT      3	REFLECT PLAYER 0
REFP1:	.DS.B	1	; BIT      3	REFLECT PLAYER 1
PF0:	.DS.B	1	; BITS 7654	PLAYFIELD REG BYTE 0
PF1:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 1
PF2:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 2
RESP0:	.DS.B	1	; STROBE	RESET PLAYER 0
RESP1:	.DS.B	1	; STROBE	RESET PLAYER 1
RESM0:	.DS.B	1	; STROBE	RESET MISSILE 0
RESM1:	.DS.B	1	; STROBE	RESET MISSILE 1
RESBL:	.DS.B	1	; STROBE	RESET BALL
AUDC0:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 0
AUDC1:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 1
AUDF0:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 0
AUDF1:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 1
AUDV0:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 0
AUDV1:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 1
GRP0:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 0
GRP1:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 1
ENAM0:	.DS.B	1	; BIT	     1	ENABLE MISSILE 0
ENAM1:	.DS.B	1	; BIT	     1	ENABLE MISSILE 1
ENABL:	.DS.B	1	; BIT	     1	ENABLE BALL
HMP0:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 0
HMP1:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 1
HMM0:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 0
HMM1:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 1
HMBL:	.DS.B	1	; BITS 7654	HORIZ MOTION BALL
VDELP0:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 0
VDELP1:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 1
VDELBL:	.DS.B	1	; BIT	      0	VERTICAL DELAY BALL
RESMP0:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 0
RESMP1:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 1
HMOVE:	.DS.B	1	; STROBE	ACT ON HORIZ MOTION
HMCLR:	.DS.B	1	; STROBE	CLEAR ALL HM REGISTERS
CXCLR:	.DS.B	1	; STROBE	CLEAR COLLISION LATCHES
	.DS.B	3
*
*  READ ADDRESSES -	BIT 7	BIT 6 (ONLY)
*
CXM0P:	.DS.B	1	;M0.P1	M0.P0
CXM1P:	.DS.B	1	;M1.P0	M1.P1
CXP0FB:	.DS.B	1	;P0.PF	P0.BL
CXP1FB:	.DS.B	1	;P1.PF	P1.BL
CXM0FB:	.DS.B	1	;M0.PF	M0.BL
CXM1FB:	.DS.B	1	;M1.PF	M1.BL
CXBLPF:	.DS.B	1	;BL.PF	NOT USED
CXPPMM:	.DS.B	1	;P0.P1	M0.M1
*
*  PADDLE INPUT PORTS..
*
INPT0:	.DS.B	1
INPT1:	.DS.B	1
INPT2:	.DS.B	1
INPT3:	.DS.B	1
*
*
INPT4:	.DS.B	1	;D7=0 WHEN LEFT JOYSTICK FIREBUTTON PRESSED
INPT5:	.DS.B	1	;D7=0 WHEN RITE JOYSTICK FIREBUTTON PRESSED
*
	ds.b	$242
;
SWCHA:	.DS.B	1	;P0,P1 JOYSTICKS
*
*	LEFT RITE
*	7654 3210
*	---- ----
*	RLDU RLDU
*
CTLSWA:	.DS.B	1	;SWCHA DATA DIRECTION (0=INPUT)
*
SWCHB:	.DS.B	1	;CONSOLE SWITCHES
*
*	D7-RITE DIFFICULTY
*	D6-LEFT DIFFICULTY
*	D5/D4 NOT USED
*	D3-COLOR - B/W
*	D2-NOT USED
*	D1-GAME SELECT
*	D0-GAME RESET
;
CTLSWB:	.DS.B	1	;SWCHB DATA DIRECTION (0=INPUT)
;
INTIM:	.DS.B	1	;INTERVAL TIMER READ
	.DS.B	15
TIM1T:	.DS.B	1	;SET 1    CLK INTERVAL (838   NSEC/INTERVAL)
TIM8T:	.DS.B	1	;SET 8    CLK INTERVAL (6.7   USEC/INTERVAL)
TIM64T:	.DS.B	1	;SET 64   CLK INTERVAL (53.6  USEC/INTERVAL)
T1024T:	.DS.B	1	;SET 1024 CLK INTERVAL (858.2 USEC/INTERVAL)

	ds.b	$1000-$298
gamerom:
	ds.b	$1000
